###################
# Created:  7-28-2011
# Author:	Paul Hart; 
# Modified by Jingchun Sun on 9-29-2011
# Purpose:  Guide user through cleaning of PINA human protein-protein interaction data
#
# Filename: PPI Cleaner.py
# Input:	PINA Human Database, Uniprot *.tab, Batch Entrez *.gp
#			NCBI Human Gene Info *.info
# Output:	Clean PINA dictionary, A: Gene ID, Sym, B: Gene ID, Sym
#
# PyVers:	Python 3.2
# OS Built:	Windows 7
#
# Version:  1.0

import sys
import threading
import webbrowser
from tkinter import *
from tkinter import ttk
import tkinter.filedialog as tF
import tkinter.simpledialog as tS
import tkinter.messagebox as tM

class Thread(threading.Thread):
    def __init__(self, command, call_back):
        self._command = command
        self._call_back = call_back
        super(Thread, self).__init__()
       
    def run(self):
        self._command()
        self._call_back()

class WidgetOverlay:
	def __init__(self, master=None, widget=None, x=0, y=0, **kws):
		self.master = master
		
		self.win = Toplevel(self.master)
		# hide the window until we know the geometry
		self.win.withdraw()
		self.win.wm_overrideredirect(1)
		
		if self.win.tk.call("tk", "windowingsystem") == 'aqua':
			self.win.tk.call("::tk::unsupported::MacWindowStyle", "style", self.win._w, "help", "none")
		
		self.widget = eval("{}(self.win, kws)".format(widget))
		if x == y and x == 0:
			y = self.master.winfo_rooty() + self.master.winfo_height() + 3
			x = self.master.winfo_rootx()
		self.win.update_idletasks()
		# x, y = self.coords()
		self.win.wm_geometry("+{}+{}".format(x, y))

class ListDropDown(Listbox):
	"""Simulate a drop down menu with a listbox.
	
	Keyword Arguments:
	master -- Assign the parent of the widget (default None)
	label -- Text for Menu Button (defualt "Dropdown")
	"""
	def __init__(self, master=None, b_kws={"text":"Dropdown"}, **kws):
		self.frame = Frame(master)
		self.cont = Frame(self.frame)
		self.overlay = WidgetOverlay(master=self.cont, widget="Frame")
		self.overlay.win.withdraw()
		self.show_num = 0
		Listbox.__init__(self, self.overlay.widget, **kws)
		
		b_kws.update({"command":self.show})
		self.button = ttk.Button(self.frame)
		if "image" in b_kws: self.button.photo = b_kws["image"]
		self.button.config(b_kws)
		self.vbar = ttk.Scrollbar(self.overlay.widget, orient=VERTICAL, command=self.yview)
		self.config(yscrollcommand=self.vbar.set)
		
		master.bind("<Motion>", lambda e: self.mouse(), "+")
		
		self.button.grid(row=0, column=0)
		self.cont.grid(row=1, column=0, sticky=W)
		self.overlay.widget.grid()
		self.grid(row=0, column=0)
		self.vbar.grid(row=0, column=1, sticky=NS)
		
		# Copy geometry methods of self.canv without overriding Text
		# methods -- hack!
		text_meths = vars(Text).keys()
		methods = vars(Pack).keys() | vars(Grid).keys() | vars(Place).keys()
		methods = methods.difference(text_meths)
		
		for m in methods:
			if m[0] != '_' and m != 'config' and m != 'configure':
				setattr(self, m, getattr(self.frame, m))
	
	def position(self):
		y = self.overlay.master.winfo_rooty()
		x = self.overlay.master.winfo_rootx()
		return(x,y)
	
	def mouse(self):
		x,y = self.overlay.win.winfo_pointerx(), self.overlay.win.winfo_pointery()
		posx,posy = self.position()
		winx, winy = self.overlay.win.winfo_reqwidth(), self.overlay.win.winfo_reqheight()
		b_h = self.button.winfo_reqheight()
		if x < (posx-5) or x > (posx+winx+5):
			self.hide()
		if y < (posy-b_h-5) or y > (posy+winy+5):
			self.hide()
	
	def hide(self):
		self.overlay.win.withdraw()
		self.show_num = 0
	
	def show(self):
		x,y = self.position()
		self.overlay.win.wm_geometry("+{}+{}".format(x,y))
		# self.overlay.win.focus()
		if self.show_num == 0:
			self.overlay.win.deiconify()
			self.show_num = 1
		else:
			self.hide()
		
class TextScrolledLink(Text):
	def __init__(self, master=None, num=1, spacers={-1:"      "}, xview=False, titles=None, **kws):
		self.frame = ttk.Frame(master)
		self.frame.grid(sticky=(NSEW))
		self.scroll = ttk.Scrollbar(self.frame, orient=VERTICAL)
		if titles == None:
			r = 0
		else:
			r = 1
		self.scroll.grid(row=r, rowspan=2, column=999, sticky=(N,S))
		self.scroll.num = num
		
		for a in range(self.scroll.num):
			kws.update({"yscrollcommand":self.scroll.set})
			setattr(self, 'text{}'.format(a), Text(self.frame, **kws))
			if titles != None:
				setattr(self, 'title{}'.format(a), ttk.Label(self.frame, text=titles[a]))
				eval("self.title{}.grid(row=0, column=(2*a), sticky=W)".format(a))
			if xview == True:
				setattr(self.frame, "xscroll{}".format(a), ttk.Scrollbar(self.frame, orient=HORIZONTAL))
				eval("self.frame.xscroll{}.grid(row=r+1, column=(2*a), sticky=(W, E))".format(a))
				eval("self.text{}.config(wrap=NONE, xscrollcommand=self.frame.xscroll{}.set)".format(a, a))
				eval("self.frame.xscroll{}.config(command=self.text{}.xview)".format(a, a))
			eval("self.text{}.grid(row=r, column=(2*a))".format(a))
			if a != 0:
				if a in spacers:
					ttk.Label(self.frame, text=spacers[a]).grid(row=r, column=(2*a - 1))
				else:
					ttk.Label(self.frame, text="      ").grid(row=r, column=(2*a - 1))
			
		self.scroll.config(command=self.yview)
		
		# Copy geometry methods of self.frame without overriding Text
        # methods -- hack!
		text_meths = vars(Text).keys()
		methods = vars(Pack).keys() | vars(Grid).keys() | vars(Place).keys()
		methods = methods.difference(text_meths)

		for m in methods:
			if m[0] != '_' and m != 'config' and m != 'configure':
				setattr(self, m, getattr(self.frame, m))
		
	def yview(self, *args):
		for a in range(self.scroll.num):
			eval("self.text{}.yview(*args)".format(a))

class ScrolledText(Text):
    def __init__(self, master=None, **kw):
        self.frame = Frame(master)
        self.vbar = ttk.Scrollbar(self.frame)
        self.vbar.grid(row=0, column=1, sticky=NS)

        kw.update({'yscrollcommand': self.vbar.set})
        Text.__init__(self, self.frame, **kw)
        self.grid(row=0, column=0)
        self.vbar['command'] = self.yview

        # Copy geometry methods of self.frame without overriding Text
        # methods -- hack!
        text_meths = vars(Text).keys()
        methods = vars(Pack).keys() | vars(Grid).keys() | vars(Place).keys()
        methods = methods.difference(text_meths)

        for m in methods:
            if m[0] != '_' and m != 'config' and m != 'configure':
                setattr(self, m, getattr(self.frame, m))

    def __str__(self):
        return str(self.frame)			
			
class WebLinks():
	def press(self, label):
		label.config(foreground='#22a', state=ACTIVE)
		self.in_out = 1
	def release(self, label, link):
		if self.in_out == 1:
			webbrowser.open(link)
			self.pressed = 1
	def hover(self, label):
		self.in_out = 1
		label.config(foreground='#99f')
	def out(self, label):
		self.in_out = 0
		if self.pressed == 0:
			label.config(foreground='#00f')
		else:
			label.config(foreground='#d2f')
	def __init__(self, label, link):
		self.in_out = 0
		self.pressed = 0
		label.config(foreground='#00f', state=ACTIVE)
		label.bind("<Button-1>", lambda e: self.press(label))
		label.bind("<ButtonRelease-1>", lambda e: self.release(label, link))
		label.bind("<Leave>", lambda e: self.out(label))
		label.bind("<Enter>", lambda e: self.hover(label))
		
class FramePop():
	def press(self, label, down):
		if down != '':
			label.config(image=down)
		self.in_out = 1
	def release(self, create, nav, title, varPass, label, hover):
		if self.in_out == 1:
			top = Toplevel()
			top.title(title)
			app2 = Application(master=top, create=create, nav=nav, varPass=varPass)
		if hover != '':
			label.config(image=hover)
	def hover(self, label, hover):
		self.in_out = 1
		if hover != '':
			label.config(image=hover)
	def out(self, label, photo):
		self.in_out = 0
		if photo != '':
			label.config(image=photo)
	def __init__(self, create=None, nav=False, title="test", varPass="self", label=None, photo='', hover='', down=''):
		self.in_out = 0
		self.pressed = 0
		if label != None:
			label.config(foreground='#00f', state=ACTIVE)
			label.bind("<Button-1>", lambda e: self.press(label, down))
			label.bind("<ButtonRelease-1>", lambda e: self.release(create, nav, title, varPass, label, hover))
			label.bind("<Leave>", lambda e: self.out(label, photo))
			label.bind("<Enter>", lambda e: self.hover(label, hover))
		else:
			top = Toplevel()
			top.title(title)
			app2 = Application(master=top, create=create, nav=nav, varPass=varPass)

def imgFtoDict(file, format_name, start, end):
	"""
		format_name must be a string:
			"String identifier before" + "NAME" + "identifier after"
			i.e. "<drug=NAME>", where the identifier is "<drug=" and the
			ending indentifier is ">", NAME, becomes the dictionary key
		start, end:
			Identifiers for the value to be stored in dict[NAME]
			i.e. img=[[[image data here]]], where "[[[" and "]]]" enclose
			the value, can be multilined as well
	"""
	d = {}
	try:
		f = open(r"{}".format(file))
	except:
		print("Sorry, could not find {}".format(file))
		return(0)
	else:
		saving = 0
		f_0 = format_name[0:format_name.index("NAME")]
		f_1 = format_name[format_name.index("NAME")+4:]
		val = ""
		for line in f:
			if saving == 0:
				n_i = line.find(f_0)
				n_e = line.find(f_1)
				if n_e > n_i and n_i != -1:
					name = line[n_i+len(f_0):n_e]
					v_i = line.find(start)
					if v_i >= (n_e+len(f_1)):
						v_e = line[v_i+len(start):].find(end)
						if v_e == -1:
							saving = 1
							val = line[v_i+len(start):]
							continue
						else:
							val = line[v_i+len(start):v_e+v_i+len(start)]
							d[name] = val
			if saving:
				v_e = line.find(end)
				if v_e == -1:
					val = val+line
				else:
					val = val+line[:v_e]
					d[name] = val
					saving = 0
		return(d)
		
# img_dict = imgFtoDict("pina_img.txt", "<NAME>=", '<<<', '"""')

img_dict = {}
if 1 == 1:		# Embedded Images
	img_dict["logo"] = """
		R0lGODlhIAAgANUAAAkLD8XFxUR/14uLi0tfgO/v75Gt10pef52dnYODg1qM2S87UN7e3kd5xWuN
		v////5WVlT+L/62trXmt/9bW1mxsbCl37iUvQHqa0J+ntFRqj0xMTPf394Ki0pW9/7KyshwkMFpa
		WszMzFaCxOXl5WeCsEOJ9ThHYIyy8BMYIF12n1KM1naYzb29vUqR/6Kiok2AzF+Q2h109lGV/yl8
		+Jmx1XCOv1qO20+BzYKl30eP/yF79wAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMVQxODoxMjo1M1o8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMVQxODoyMjowOFo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQABwD/
		ACwAAAAAIAAgAAAG/8CNcDMoDkLIJDLBTBgHlWiFQqUMiUalsuk0SqfV61Ob5D6/VetwTA6ZvdK0
		UkQXPRF4xJPL6XMYgAxzdXd5e01+f4GDdIV4h0yJgYJJdXZGeXpGfH6TEp8Sk1ygEg+mD6Snqqig
		ok2pp7CrrJ+uTLK0pbO5tgm4uKoQwhCqL8YvaZMFywVpzAXDxKfHyFXKzM7M0cXHyYHP2cvb093W
		39hVzwHrAbsPlu4k8iSq7O2qfiLsiZKBifaqlgH6QPDDpEn2vgE0VYCBgRgxGkhssKKixYowMsKo
		eKOGKioiWrCQ4aKkyZMoU+74SEFEBgsTPMicSbOmzQksAzgwYbOnT5SZLFuMmPGzKM1E8gIIiCDT
		RooLIDR4IODBBgiZF2aCsDETKYkAOFw0PSAzxdSqKahm9VBCw4mufpKGbXrChooFZ20QWJBj7QkU
		C1DI9ApWbNULBFQIpqo3x4K1AA5cUCHz2YM/KwzrpcmYKgEAHlRQRnHVg+U/CgxjoDyT8mqZeAkI
		nir4NIPURnNbfkCiA43cRoMAADs=
		"""
		
	img_dict["intro"] = """
		R0lGODlhkAEsAfcAADMzM2OwyZx4MTR/Mvxrz7tZZWNRMkHtU+ihy1aGk/fr9zFNNL6yycSUMX5+
		Q9VdbfjS+I1qMD9OTTyAaDT1qcyZM7qrtEb4xjPWjWNNRfux8NHm4q6EMdaAcbKfmqvj0TfWRsOb
		V1dMMYbJSWPuV2J9dzo4MaFgOn5TNrSgaIO2sVSpjtPP5YDx02NqSvmd2zRvV357bTPDQu2IuPRp
		tLnmWUSQNkpKOq1PUTHXcrjYU6aGPILG2jLzl9yPqa3Uys3F2LKUaOPh+uhpkVldSEI/NWCUoMGU
		OqGhS/+E89TSifj4+aTg8mxbMnhwQlJRPYOpm1rEpI9rOruljTNmM0TxuTGyQ42QR7SKajHBdWZg
		RbZ6TNeLjYvtW8HKU8XE61BveWryzOfU5recejXyfMO0trqMMebi60VcY/6Z6TKxdjGLTq6uTsGs
		nf3C/HO901SxO/2D06yIUpXS4OfA6HeYjqD03dGy3Vb6dnJeM8GUQv3e/cS81mhwXllaP5FZR0xC
		MoJqNFVsbGWovYu+t8L26XiNfdxpbevz96V4PLS2UKnOuEHTozeaeHldSDE8M9CSlczmu610dKte
		T+h+mljXRf///3artGyNP3RzSf7r/o/33GelttmjuGiLj4amRcWle13ou86mSNTbWJF+P1ZhXam8
		nEJLOf+Z/2HbuI/L2V+ChdPS92tSRrOHh+fS+pRzMbuUT8WaTFnCPzb4uVRvXvJkoOTw7qHT4ZFp
		YTpAPjFvNUpVPraXjFmOOs1xVNfCajxdT7aMPLH35vGy48Li2tHD8jWmNuFcfIXVuUL7kmZeO2xQ
		M9L1735jM/5w48ZhU66vfJHq0TzwaMSfZ26bov+x/r+02zGkTfZ9qVf2yGqjrKN8MVpNPv6D5nvu
		WomQbU5BO0b7fouUf6W+TMCcnsO96eKDh8zMzM+wU+fF9npuYP/M/3y9z/6c9z2+ku/j/DOZM7Fm
		PmtsR6LtXUiVfLSSe4TeT221zLPw316csHlOQuGv3jOZZmr5cOlvfCH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wMVQxODoyNDo0NVo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMVQxOTowMTozM1o8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQABwD/ACwAAAAAkAEsAQAI/wDdCHQDoaBBCHsSKlzIsOEeBRAjSpS4pKLFixgzatzIsaPHjyBD
		ihxJsqTFiShTIlrJsuWtl2diypxJcyaLmzhz3gTCsycQPkD5lBlKdGibo0iPglrKlJrTpyGiRpVF
		laqeq3qOaN3aoKvXr2DDih1LtqzXgQQPFnTI1mHKlCbjyp1Lt67dkm/zQmzJt6WQv4ADC/7LqjAr
		nYh99gwKtCjRpEenSGa69ClUqSGqWsWadesRs6BDix6LNu3BtqgV6qV4t7Xr17Bdr57ddyW824Nz
		CzZ8GHFOxcAZODYKWfIUypUtY86smXNnz6OjSydbWm3q67Mhxt7OvXv37OAV1P9mqbu8EN6FfeME
		rlj4cMhtjCMHZZnacs2ynHvWOr2//4HsBHjadaiB592BCCYoUnjg9XXbg+bphh5v6rEAHGNCDVcG
		fPHNV999zXG232f+lTiaQAEKaBCBBWan4IswKshgdnw9aCM8EeY2IYW+XciYhhty6KFymOGn334m
		JgkaiikOyGJbs8Uo5ZSvzZgXSzdmiWOOg+3IY2KKYZihYxy2MeRlUhkpIpJKtikWkyqu9SSUq1Fp
		5514WTmRlnxCyGWXXqbXY5gYaljmmU6BWNWR0Lnp6FlupCjpnC3qheelmG6kpwJ9dorbn4AG2huY
		PolpqJDIfVhkiFiN+OircE7/SilbUWZq66Wbcuopn6DqKKqgpPIk5phFHZoqkWmyepWrrzoaa4qz
		0lrnrdROyeCuu/bq66+GBfuTqe+hSpmqyS66ZqPNtvlsgNG6NW21I2ki77z0yguvR9diy6u2oXLb
		7RcAA1wquGQWN9m4yE6l7HNcpatupJKy2y5Dtd7bUb0YZ6xxteHp2ye//fprWMABDxwUAyiHm5R8
		CCesZqtsOpzkuuxMTPG7Fl+k8c4883xnxx7fCPK2IrNizNEkCywshii7V6zBx7WMJnPmwoyuzCXS
		bPNCFefc89dgbwxjdkFrOXTIIh9tTNJfLMZ0ygWvfHBT5FK9mdUNY501xBFv/60azvCGLfjg9cqo
		V9lCnx1Y0TuuzXbAYjatMlIs0+3ywszq/R/fsvrddbWEhy66JtuBh7ifip/HOHpqPw75204/BvWx
		l1e9bMyaT6e13w99nunowBMO22yn25i66qtP6Ljrw0oeN+VzJ1f73bdfnXt0u3vu+6XBdy+4bKsV
		j/rQyTeOtOtfNA/303JHbfnUL1ef9/XYcw4t7y7e6v3+YdtFvPhbIl/5zLe8x6kvdsRpH+3ghznc
		0U802dta/n7Hvwr6rC7hA+ArNsjBDnrQgwP8FfoANiw+OI990HOf9BhoO4bx54H1i5jE8Ac4O3Xv
		SRa0V1zIdroP+vCHIfSS2v8KaMADTi4y0aNP3eLnQhLBEIL2m6H2LMU9wvFuDxXM0+EQ98MufjCI
		QmzdCA+IwCApUGqJKhf1mvjEE0WxZlfcHoxEd0WG7G9B/9OXF/fYQTCybohEJJk5BknGIxpHhUqc
		mt3yc675tbEsEZRgDecouDqmpnt4NB2fDMLHPfqRgIEUJCEjd0LZpRBR9llVCzP3SEi+sY5yTFAl
		LcmiHNJrNalRCyc72cVP8gaQI/zCIM1RyOfFp3IrTKUaGYm3F7bSlTKEYxypOKWw0XJWttRESq6j
		y13yEoi+NJoYg0lCUq4PhcdMYt0WyShHPjMskZRkXqppzWtGy5YSIVA3D/L/TR9+EpDnC+Ywi2nM
		Qy5QmQpbpQPfCZZ42iyW3fna1qLZOWzaMpf7VEs/+xhCgI6TnMIcJezKaEYkIjKRaVxmO53JUHi+
		UZpTnCclexYtitpUijj0nj4zqksvquOnQA2qOorm0aKCFGADNec5E3jKgypqjaxs6VdoBlN5ylRB
		En3STbcasRVZdJY75alGNyjUspr1l0VNK0CPGtKkjrSM8EFmMp/KTPmxVKqQoigsJxlRmhKIq4CN
		pj1nJVaemvWwQFWrYofI1rYOk5hKhevsnKpKqC4Urw6d2AQPlNW2GCSwoL3pYNlS2Iwi9rTqWKxq
		G+tYkTKmaaVkqklRSdeV/zoRr3mVoSU36x2e/TW0wOXqaPdQ2m6i9riqTStrW/vYa7xVsmd8X0oT
		alnr4TazmuVrbHyLGuCW5rtUDWwdi2va4x42uR5dLlIfy97IniqFiKwPQtnZzLte95W7hehd/Npd
		roL3v+ANLk7nRN59osW850XvR8nJ3gab4xoQdu7JYAtd+B50vvEb0W1x2wDstou32+VuW/wL4BIH
		GLi6dEiBMwpgBJtVwQt2nYNnPEgIv5bCR0xnfBNG3/pu+L6Cza92WyNittzUxEhGsoDZsWKxItnF
		dIgyHWDMYBrPOMI2njBs39tUNNa2ke7ELH73OmS7FNkhNk2ymtUs4CYXZP/NAkGslOdM5+Syzcp4
		HiaW90zhpco2nbStbF2b+GMxd1VO0ywzXfhrZBnC+dGPXjJFIV0aDViazpjGtFrzzGkH7xnLffZz
		XOWKUgw38LJSjZVXyUxN2DCaIZ91dJKtQeta2/rWtqY0gLyrazdY+teXzrSwo6zYThv7058ONZdN
		umMeMzGqHFY1omkI4v2euSHRnDWut83tW/f62yUGtriBPexM3+Hc6D63sTuN7GQrmygWiPeo1bnO
		Z6P6VRXId75j2KRVx1TRJuksmmVd4m4b/OC5Bnevx81wYjj84cPmh8T5ke6K32HdDW63xkMdu3hb
		YN4nle+X65s7fe/bjZL/sg619RuXVysk1hErOMJnTnNrKNzEDM+5pR/Oc55P/OcSt7jF2a3xokOY
		447xOMgDrVLbPtPkFXgTnFT+71YT+doJgXmKZF7zrtP85gPRuc57TnagA13oQje62jfO8aZ5XOlQ
		a7YimchGhkJ9qmhJ8coBXhKXL4Tg4PW64AUPabEbXgNkL7vZg452i6/98aBuO8reLu+4y326Pbar
		fd9p8g7nnepWZTlJ/P73mP938KhPPa4Pz/qdJ97ni59449MN+bVL3u2Ur7zlLzxyzRc6LJ3HGtQr
		8HnQPzQ8ryF9QrJ9etU7P/WtN/zrex572c/+DrUv+u1hm3u4ty+JpV6O/92cQ2jQ3L3k+S6+k46P
		/KtjnbgFMX3gn++O+tv//s/vdvRzPn3qV5/xs5d9fLZ9FNZ9ugdf9MZj4+d05nd+MgN16udv2dV+
		rpYxpBV/8lcaqXd/HNiBHJh/1rB/Ddd/D/d/1td4kEeAt2eAB4iAl2dqLVR3DahvZuGAwDd8OEh8
		ApFRVcd3maQxFwgBGaiBg+eBHYgKSIiERugOgieCI0iCDmeCAIh2KliFbceCLchsIVdvp2ZdY2GD
		YgGGXlEBolCGOWhyA7FPeyd6I4ES9dJfQzgQXbeESViHdliHS9iB+ueEwPZwL/CHgBiIgYgAhFiI
		hPhzjWeFithnWPhxIP+XgIqUeeWHbzgIFmRYhqJwhum3g2rYg1d1FylBL0EIeGhRc3lof3eYiqhw
		iqzYgWKXBrAYi4I4i4JoiLZ4i4SYbou4i43ofS74gjC4RpP4KJeYiWSBicY4fJBiGt3kiZ+IQaEo
		L6MYhwJhikaoithoh624jfcXi94oi7RIi7g4joTYCebYCbtohb34dhxySHIlcr3ne79nIid3jJio
		jGOYhmIVLQ/CIFWiF9MoKc03c3SYjQaphNyYh9+4kOEojuSIi+cYkeiYjri3jgZYJu44N2OwkfAo
		aLblhcKHj1+hb/pYWE9iI1YCPnkRhEIokANpcNd4kDKJkAnZjQvJkA3/WYsPaYgS2ZMTyX0WGZQX
		2Y4ZyRQbOQbyFYyDRmhh5jCVOJIQyIkmySIomZKgCJAqpnUB8pLdFpMz+ZU16Q43iZM5CYg7yZM+
		2ZNCuZYsSJQZKRlHyZHrRF3kp2Gb1ywieYMn91Mr1hZ9YpX+g5UNoRbUWI0HV5BfOZPcOJZkWZYv
		cJblmJY+yZaU6Yvf545xKZdzSTV1aZfz2CZPGYbBVwFAVWANsSuACY2COZgYuHVcuW15mJiyeYqM
		2Zg5CZmSKZmVuZse0Ju++ZZwmZlIuZmc+ZFNmSR5KZo0OIZB5WYeMyOtgUss2ZJbCWAIh5gGmQTa
		uZ3c2Z3caYS1eZOO//mHD5mb5tkJu0mZvtmbwBmcmZmUyxEL8imf5MeUn2kWZqiX9VgWIplvQlVg
		ZZOaczEb09ma1nmYXomN3rmgDMqg4fmN4/mYuDgDFEqh5+mT5ZCh6dl969mh69mewqmZPDaf81mf
		ntkfyCgKlrif/OmAJvef5BU0eqKa0pmVhFmd89eVCWqHDdqjPuqd4VmWcTCkcVCIFXqkSDoDPnCO
		PtCkTRqRGRqlUjqlVCqlHnqlWPqbbxmiIop5IUCisWCiJzodKSqGZBGaDUCDUdachYU4M0oX4OFZ
		uuSSOQqbO4qEP5qneuoNfNqnfsqnRBqogpqkhKqkTnqoiNqkVbqoVP+apY56pSDKpV0anyRan/bp
		H2W6nKGRnMu5pmxaXM8poCYRpwVqoK9Za7FZh3q6qg36p67qDYIaq0RaqEmaqLbqA4yaq+XwqLzK
		npEqqcMJn2Aapp1pl5iKjFHXgF2RnGmarA2AaWIQrdGaUacjqiTBIKWqFgeKa9vIqt7Kna/qqrIa
		q7Raq7eaqLpapb26ru7YC+4KrGOQAvKaAklpH8MqpsaKovmJn8h6cv6ab/vaFXQmrQRbsDVxsAgr
		E/4Ip6Rqowa2rbfWit/6reH6p+NKruVaoefqpJDQsR7bsem6q+uKpe5asib7rvA6r/MqrJVarPkq
		GpoqGukwszNrjM3/2hXImA42K7BzVrA+K60JG7QKS4Fyga3ZahAQa2sSO7GrWrF+erGBmrFHurE+
		8LFW+7FVerJa2wu+ubVe665TgLLAqrJkK3It67LQli5lSLMqqqmiQLM6CxYD+7M+K7RCC50DarSs
		yVMvCWysyLR76rR9CrWzKrUUurFXm7hW+7WM27hbC68bSbbzKhUfcrZglrbN8rZsy6IVALfpILc9
		S7c/a7d3W21taCUO+7D/NW6nCLg+KrhPS7hxILXZULvZQAm4m7u4ywW8y7uK+7GOG7yNC7lHKbmT
		S7mWYbmXC5KZa4Yx6xWe66zPGrqiS7ekWxPjURsMi7p7q7rflXN5/+i6rQq7gCq7s0uotmu7uru+
		vdu+7Xu1whu/JUu8mRkE9nu/+BsE4nev+PqyD1iPLAq9NauiXzG31Uuw12u32dsSeQs0DwJrTva9
		DBe+4tudz3DB5Gu+51uh6dvBt7u+ueu+IizC8muy9nDCKJzCKmwP9Ju/+YsZw1qi/atherOcz7us
		wTeSinHAo5vAM/ESQLzAfDGqM5IlC1FYEjzBRui6F9zETvzETWyxGoykHqy+IEwJ55DF5zDCXMy7
		7rrCYBzGYqzC9Xu/KeDC+RsLURHD9DnDnnmXKHp+AYzD0muJioETPIzAPhwTQBzEQszAp1vEm4TE
		aAG+S/itUJzIiv/8DINrvuhbxVesxZLcxb3rCpZsyWOcyZqcwkeZv/KKxvYrn1/KxsRqnDTcJpo7
		swBcx1A5x2kKHDpxwHtME338En88HiAhyH1CyIVsyPX3jau6yMKcyERKAMZ8zMhMAIXqwVeMxZL8
		zO7bAdI8zZfsCpt8zSsMytqcxqQsw2jrv0mSyjM7hqwchl9YAewBBDmRx7N8BrVsy7csxJqiy1rC
		ywKhczYZiz3ap8Pcz05czMmczDQw0NlwpMwcyc+c0NO80AuNBQ6NzZq8zRKNvyQ6ymxsqW98nP7h
		uWPYojcrmumszr7Rwz78zrUczyjdEvRcz3wbdq84lklQsf4808//ENA2PdA4TaGQDMIJ/cwM/dPT
		7NBCPdREXdRCPdFIzc3drLw+dsqOEr2u3NFpeqYVgA5WfdVYjQ4VsgFc3dVdTbomfdIpPdYrkUG7
		EsG+pnNjCbs0Pcw2fdM4TQNVXLsI3dNZDNQ/TRlGvddDndR+HcpLDaaWKo8avdEDvLNfuKxUXdVZ
		3dha7RteHdlffbBh/c5kfdks8RbYgtZqvdYy3daK/NZwHddzXdc9jdd5rdd8vdpY8NfbHNj8O9gZ
		fZ/SUc41mKzlTIY169iOjRiS/dte/cOVLdaYXdxYoi/7JFSdvZBOC9qJLNoBHdc4Xdo8bdeojdeq
		zdqs7dpKDdtt/4zRb2wG4m0GoCm9UU3OHw0WogAM7A0M6cDb8A3c8v3bw23Sxn3fiIDcugRUUpZz
		nh2uzt3E0D3a0r3TuDsECD4E/7DgDL7g143dTKHdEs7dFO3dgs0ZwpDhGe4Z493hHu4f+3nedOzK
		qeze8O3YxZDixTDfLL4B9W3Z+H3fWnKwukRnr3eTzQ3aA/7W0l3g6Zu7Ca7gDd7gDw7UWJDdEk7U
		crDkTN7kTu7kYMrk3u0cGl7lVe7hWN7htR3itu0Va1uzZZEO7Q0MJ57VKn7mK97i8v3ixB3jY026
		Potp0/cCzP2qM73j0N3j0m0LfN7nQY7gQz7kRQ7UTrHXT37oiP+e6FAeC3Jg4d+NFVYe6Vk+6eI9
		Gpzb5dDr3mBOFmLe3ovwA6B+4mg+6iqu5vTN5n7s5tlr0nYb5zZOdrT42aGN5wOu53Hd57j+54FO
		5IPeAb/w68AO7Io+7MSe6Ize5N4d6cqe4ZTe7ORdgysqszQLDAQ8FgNcAYvw6aC+7T+A1aT+7aWu
		5s0w7uOO6n2s6izB5kHr6nOWeLEeu0TqxLRO67Z+67huC38u5Lu+4IfQ79cd7AD/C1uwBcVe8AaP
		7Mcu5WC67Mvu7M5O1dEu7TPr3vz5FdnO7RgP6uC+8Wk+3+T+8eVu7vB82SIPxAn7s3Lec+EItfOO
		5/Vu7/ee7/v/zu/9XvOHsNABn/OxMPAEf/A+/+QWzvAM7/AOb84RLxrr3d7VbvRdke0Xn/EYz/Hg
		zuIgX/XNUPJYj/Unz+5SBuu0yPItL9ovD/O5ruv7bvNo3+85H/A83/Y8//M+T7ZsLPRCT/REb36W
		nqw6i+mK7RVO//RQz+1SP/XAbfVWn/WIr+4Hi/LtrvJfP65hz+NjP9D37udmv+tpb/M/vfZu3/lt
		D/fDHgT0+hSNPp90f/p2b/dzzPeWWNtg8ffaHvig/gG0T/uD/+1ebfi6//GJ3/smv/hcTwdeP4sX
		G/nIPPlkX/ZBfvaZr/a/sPk57/nS3/Ogj+grSw2xcPraLwyp/1/05xwdrA98r//3sl/75n/+ti/1
		hbD+7M/+u//+IJ/17x/WCMv4Xe/4xA/5kY/8e175+H75APFPoMBDBQ0e/JWww0KGCR3+2hJR4kSK
		FOVcxJhR40aOKVJQAxlL2EiSJU2eLGlG5UqWLV26bBBTZswKNWfexNnAZk6eNG8uAhr0x1CiPz4c
		RZpU6Yd8TZ0+dVpI6lSqUptdxZpV61auXb1+zbpB7IYzZcuKQZtWDB22bYm9hUvsxdy5cezevUtA
		716+fWn8BRxYcGBbhQ0ftjVE8eKBjf8dhPxQIcMOkiFWxJyZY8YdnT1/Bu1R9EWUpUu/RJ1a5UyW
		Oiv05LkTNv9O2TGD3gZadOlupVB9N60avBBY4sWNcx2bfKzatG3Z8oMOHcF06gjwXo/Td+9g7t3/
		Iga/WPwQx48hI7RMubLDzBYpJoIfPxFo+vVBCwsRAqNn0/1HqgawJZlcqm02mV4z8CZR0sEpGQcf
		vI03CZf6zTfhgjsuQw21Uq5DFj5Uy7nooquuOuzs4ss7FQcDr8XxFCvvvMgs+2UhGtvbQo4gdpRD
		Ph/jsy/Iz0iyz7/+AgyQtZVcS/AmBJtMJx1gphTlpgevvHJCLY+q0MILMdwwTLA6VO5DM81sa0R+
		SqxuBjfffHNFOb9r0cUXYRxIRvRovBHHWKjZMYgefyQUPiH/6YslFjmENBIlJFVzDaaYlmyywNmm
		xLTKmbDkNBlpPgU1VGm2ZKpLqL68UExVryLTwzNZACJWINRkkzo4b53Tuzp3pYQS8ZABNlhkzJOR
		T2NxjEjHQIMotFlDDy0J2kZJejS1AQWctDUDn2yyASkxZXDTTh8UtVxz7UA3XXXtMDWfYd5FFdUN
		4/2y1eRelTVWWmu9Fc5cCds14Gyy6VUxYYXVsyBj+URWomWD2MLZZhkVZoeRDg3ypGpRU1LbBl7a
		tluZRMF0SivHddBclUVdt2V0K3w3Znpnprnmqezd4Mx89SWxVgT6jTPXgANerFejDw424UMWZngL
		eZ6GWh6K/x6WuOpnO7vYYow54Lprr7/e2KUjxpb0Y2tj41ZkcMOVCWVyV4b7U5fntiNmu+22OW+9
		pSqmb7//9hudnXle02egg+auToDrvNNoX5FW2lhoJqd88oScjjrqiOHDSOKLrAYy64qF/Lp008Om
		FORsIc0pbZFF0bRBtz2Nu3a6170797v35v1CwH/vGx3hhd/5jjsMP3zgbBJvkQbls7HzziEc/wfp
		Bw56IHvtK+e+e2gkylxz0C8KIgVmQdca69GDNL19r1Enm8DXHqVNZJFnbyF//fdvoXaWb0+X7gQo
		s94J526mAt7fhrfABXbCgQ+EYPKeN7Ch2eJ5h7nTwRZjPf/tZa8g2/Oe9zKHufDJA3SJkINozIe+
		+xzKfS/kWrXiJ7+w2c+GMklFDnOIJf710If6C9UmhDjEIQKwbgNEYhKVeMB2JTB4DCRerCA4xcPN
		IBu3qqAFL/gipHUxWB0E4wNCGMLwkbCEJyyfaHZQNYutj3QwhCPYUHMEjtUEdSux1A15okMdhsGP
		fwzDDwXZQyIWUohGRNcSFbnIYbSrKU6EIgOnCEEfVNKSPlDeraA3tC0azIufREYYOzhGEZaxhE87
		YSLS6JE1Eoobr/wMN2L5Sll+Jo63jGFLZogts91RJ3psEh9zGApAFvOPgxSkIQ2JyCMy0pl2c6RT
		EhhJ4ZX/wZqTdOAlLWk0TUrPm0MAJSgPIUoQknJyp0SnCVO5n0QIwJ3vhOcsa7kDWtaTlrjEJUvo
		OMdd1tB1wNxjKkIx0IEa06B+RGYylVlIZibymUh0mW8mRBRqWtOi2NSmDxxHCThl45u/CqcXP3g9
		UZqTe+k8pbPgudJ2rtSl8qGPPWWKz3yaYZ8vseMd8ViB1QAUNgQFKjEPOtRAJpR/C11mQ5W6VHVN
		tCg/gKJFrznFjFbScVYtmPRCCsoOjpOcJqUcStPZLJe6Ez5lXWlnMMJKesp0pjSFoU1vKra53nF+
		lPJpToIaVKL2FaFGbQFSk8pUwt7OqU9doFQvSsmMbtRX/9/cahfJ+VXKHWIhBSilWDN3As6eID7v
		lE+PWNpStApgBwJIoQrb6ta3wrV0KqmrPmOLupx6LK8z2Stf/epXwOZPsAstbHDRJaGnPlWxUn1g
		VTW6Ua1G9mCTpSzl1HNSzW62s5z9kbJ2RFqzllYA9dyBClMgB9ay1rVgI1vXdDnbsNWWl7eNSW5z
		u9vdAva391XmuvCrrpXtprg/CMpxpVoOAmeUC1xwXHMjqxjoirIAD+bedCtXXete17PyeZgcYLFh
		WHjXnaf1zCo9Ul7znpcDNj3dSti7sV+eDb4NkG8otDFjGtdYG/Qdam8Di18e93gT/hsVUoqLGwFb
		k8BHJv8wJJSs5HM0uclc3GrRKNHgMI6RMtCYRJare91EWLiz8OGwdscrAA6DecNpXa07gxCN0XyX
		xOWl6djcN7YVb+yuLr6tfG285xrjOMf29XGgDQnkTwm5KLgBikUtsOhFI7kcS4a0k588HsmGUdLn
		IOeDNa1pUmLB01jO8iTQ6eXOyoPLX+YwLFJrPg1zmBupTvUrP/zO8F6kM+98c4m/lqivxe90/dSp
		Ge4MIPhWwdjG5nOylT1jPwNSx/sTNH77B2SkINrajMa2oyG95Eufo9INlnQos7dpckM4hKGeXKi1
		XGFSY5dzOuoyZ1ONwh7B2p2w3vArO3zaeHo31/bs2p//qDElYeTSDO6Ta7Bb4t4k5fXYx152xPnc
		bGc/2+KAjRunrI0bbDPa0Y+GNBcu7UUqP+DS5UY5Zr2HAxyo2+VZbjd2L4IFOXBWu4LCLr51ngid
		9xue7ZQ1Wv8t01iAwuigKDgHRvLC9KpXp6urlsMfXoULVF3iV7cxxf96ca7/UGXj2vgiTGGKjnvg
		4yHngivUvvaSi9LJ4075prnH8sm1/OUwjzl2sbAsmy9LDlKQQiIiMHjBR4DM9sY3mE0La27M2t9D
		p6UwUnD0WHDgCC+Ua4pp+3SATt3YVQe91bF+da0Xs+unz5+oUGbtsbfeA6+H/et7MfterN32au9A
		g+O+/3tNs9z3c7e7y7cQ6rxf19PH7/LNgwB4KQw+AoJ3p/MHf28Ov3PD7Uw1rT3sTsjDMgUlg2HT
		NV+tYdcQmJ6neujVH/rRL7v0FUe9jguJMkLU3/6td33sZT/72/ffFZnmvd3zvQEMvrtzueLzspur
		uRPgETkghQhgPsBLNekzPHs7vFdjPFgIuu2DPK75vpAQBjoyHfFrHzvjKYU7v6lbvxVcv/aTuPeD
		QYMaJFAZF/uzQfwbO/3bv9rrP0nwwR+UhADkPQIkQpYzwLvjLHUrPh3BCOYjheaTPp2jQMNzvg6r
		vsNzNe7bPnj6N6XjgETZATk6OK4RwTiin15CwRtCv//0Y8E2FD0XnLgYlMNiepD8mYM7rEEbrD8c
		NAUdpD3/A8IfFMIhLEICPMKXO4FJOD4sQEALA7wpjABYGLwJjEJJjMToo77sIzN908THKy+TeKXx
		o6kAAbY0FJk1dMNUXEE4jMM5bDZhSgUekEW30cP7wz/9oz0etL1ABMJBLAAifLBCLMIjLLVEXMQ/
		yDvpO4Hpg0RLpETnw8JoxLeV6jkObC2vuafSobMyvCVIOUGFK5smQUVVJMdVZEVmc0W/gkUdmp1k
		sEEVgEcVgIJ5pEdc1EX940VBFEBh5EdDLMBJ+ANkJDVJOL5caDcKjEAojMIqnEQKlEQrvESdw8BM
		tED/DwM4pVu6a7S8yzM4fJojcMQzA1lDNizHkgS9c3S/3YoxglrHlsxDQohHeaTHmYQC2NNFV8DH
		fAzCuOvHnvS9LPsDdQvIgLSwP5AEe0DKXBhKgVxGhExISJxEDqvEDZtEMptCLMRAneuwLeSG0iEx
		pZMz9OJIM9QlkGSdBKGFtFTLhzPJtmxBlFS2lYyxlqTLHXoQ+4tJmpzJceDLvly7nMzHTXs5n/RJ
		oAzKpSRKojyBP8gFT1PKoXxESGS+wVNIhozEy5S+w4NGS5Q+Ujg8iqxGD+OaVyq4NwvB8NsnOJIt
		szzL2VDL14RNt5RN9oNLuVzJuqzLKNDNKNBDmdRL/3rsy+DkS5yEPVfQSU0zQML8yVzwQcQcSoB0
		zuhETMBDgep0huvETmcAPO2sTIfETOcjBc60yqusSq2cRrSyGNIUhlw7TTMkwTmrM9Y0A7SEzfqk
		hdnEzzfEOtu8Tdxcx90EUN2MSd/US+E00Ngzzh/MhQVd0EPsScMMROmU0KGsThT4g+pkvgq1zuzk
		TikgBQ51Bs6ExPCsQhEtUVgghVYzz4rEtbYazTfbyFGkM8yLT/nsqZ6wzxytz/zk0WTjz73yT1gM
		0CHVzd+kSQNF0nFQUAZlUgb9wQFUN+aUBBxATAgFwsdETCyVzuqETOrU0A3VTnAQUzGNAA7dzggM
		hP80JYUHZMZmlANwSIFoiIYVDU3T4rfRcTPzOoLSDMWaes8Tq1EbvdGc0NFCNVQeHcmR/NHcCtJU
		INJH3U0jpcc6qIMk5csYwNRMbVIm3cUslYS1kwQtDUjolNIfHEoGHQctrdCA/NIM/dJXzQWk5Etw
		kAIzTdNbvdWHTFMTLVE5kFM5ZdNIpFMOqw8udCvL49Ns9Eg6k60TE9SGI1RDldZpXcFEtVZrtc0g
		hdRtBVBJhQJKrdQkzdQY2NRN7VTEDERRXcpcsL3HZNcEVdVVZcxcsFApeNV7RQFSGFMx/dDslII0
		ZT5nCAQR3bA0nUJJJIVfjYZgFdYV/bDGMy2INdb/erI8DoCzUbQpldCDMXTWZ23NmZjWkBXZtLzW
		kjXZh1tHRlDZleXWlo2CaoBZI6VUQ6DZmjWEccXUcm3S2xPVd/VBdV1XBv2DfdiHXBiHcWXVC63O
		XNjXx8TXV5UCcAjOXLDVQKhVWBhYXAU8XA2EEo2AhP1VOXBIfCOFHUACJFitWxO6yFtPGHUtWUiH
		E3Q6jw3JmBjZuzXUk9XbRF3ZvvVblnXZIV2BwSXcFYBZmAVXcLVZmsXZnNVZVG1XT107LSXafRha
		yx1aDf2D4CTXC1VaFIiB4HSEp4VaZ5DaWXWAQPDX6/zXJ7zVgOXaXeXMXwWHKzjYVPPVXw3PzpDY
		/9KyGIvtwlvCj4FTAmCQq7DMJVmQBbp9rwbA2+eV1r092b+l3r8N3N0s3Owt3MRd3JptXE193HkF
		2oB03MutXKI138r9XE3dB0f43KUNznUgXQ3FTgewXwcAUe0E2O1k3a2N3V2Vviu4gu6cSlVTWH7b
		wozswDgKASVw4OJVL7IRBil54I1lXrxyXujV4ByV3pGs3g+m3pbV3hEe3MStg+5l3O9dhxVmYSZ1
		Xwk93/NNX/WN4Rh2BMzF0C91BOGc3woNBBQAUdXNTiF2Xex8wCCW3Vv1TKicytyV0yBgUS4cie5T
		1heKhQd2YD14HzNIByxWAgu+4Bvd4DG2zw4+Nv8QRmO/3c13YOM2fgcShuMV8IQ5RmGaBdd5xFQW
		1uMWdoQ+9uM/vuEaRl9BtlxC3odVzWEN3eFLXQdH+OHqdIR1CN11yINKRuJbzQPsrNWAvc40zd/r
		XFNcXVMmrsJXAttoUIIUqFN3mmJc6z44EgZgwOIQKB1h8OIQCGOXIONd5mCTTeNfVlk3FmY2jmM4
		nmNPqGOaNIQ93uM8BmRDhmYZTl8dRoFDxtdIlt/qfGQUON1xoORM7uRKzmRcFWeBDQRS8GSBRedP
		Hjxc5bCuZeKt3LA4ZbMd0EpaqxiXomIYsuVZNh1ZfmDjzWWWoAAK4OUxLuiEVuiFTmhg/uVhhmj/
		Yi5mwq2Hil6Fi16FEtDojdboOpjJZWbmdTCEvowBQAbkGFiHaFbpyp1fZnBpaq7O0BXTGHBpZwBn
		cQZngRXn2O3fT3aGMtXOByxYg4XExbs+BwxPh03PtV3gFAOJEFg60+niB8blgV6JhD5oaWXorebq
		hXbo6o3osJ5o7a3osubos/boSQ1pkY5fQJZkTPVmQQ5kQ3bpuu7h6mQGFPhjZnCGvEaBdQhOS7Zp
		nB5nT87k7fzfT9ZXMZVT5sNVh3y16TNqOrXT3tVnWFqti9XGW9IDapAFarFqlcDqrK7Prjbt0/7q
		vg3r1R7rFdAHfRiEQVgBsz7rszaEmayDPuiD/z12hBhI3HVoheAO7tCt2ZSO5rp2aaJN7j4mZL7W
		UGbIA+gWZ+TOBNEFYmdoguzWbg7Ng1s1Z08W4vwlhXFQ2Af834G9N8k+raiEtbLdsJHwsB0on18d
		uvcZS9cKbTMYbdI+7f7u6tQO5tUWazgu64qO7QOf7Xqo7QWf4xLQ7QfX7RXWgnX4beEObpH23lao
		XOSe631A7vZ966O1a7yO7jzAaxTwaxRnBnut6zyIAXDIhEx2AnHW7uwO7zTtbuxM5/AOYnCIBvKO
		BtuNXUqc7KkkBXqOhkWx5zNDKznA4mig4vY0sY7N5YXe4NDz7yzfagAXcNYm4QIva33ghDHnBP8j
		qOgF12gIV3PddoE2d4FGdgTvbWQLj3Oa5cvgvmHkZobz1XPAvllM1XOXjm6XboU+HvRBv84W/2Ho
		tmnkrnHwVt2c/lebxnEQxV/TVdhx+F+qlOw2PdErUNgUwEImd6kdkNMHzuw3Q94pN7gL3urnVT9a
		0HIt74Fa7wEQxoBcz/UuX+1G8PVfB/NgXwEy5wR9UPAFr4Vkr4U1V3MX0IJn1wLdFu4+tvAUjgEL
		b4VA1/bezlRDyPbpJvQQNwRH0HNyb/FBD4QY1/PtVmfsboJAOOzBjnTB1t/r9HE5HQdwiN3wVNNR
		/lpLTFGP2LBTZrNV5j5UfmAkGLqoZvUtdnX/087RVw89WZ/1rrb1i+8BXdf4jccAXofoXwf5Rgj2
		ka+H106Ak69tZVf5lU/2NtdtaIf5Z8+ADOjjmc8AaRdum8925L7wdcgAAwD6VogBm3UEA+hj5NaC
		kS5uA1iGFQ5dLQD66c4DJ5DuQUfu7vZkGydnnSbsdHYGBxBT++XaUO53S7Tnr1XYhR28FGi9ha3T
		UER4Bw6Cf2P4hnd4uq1401a/vKcAjPf7Wuf4wN91j2fjkDd8kCf5sp6AxZ8AjmZ5li+FyJd8NyeC
		yrd8aJ/5mrf5zcf2VjAAobdZp+8DZiDuZfb8SnZpA3Dp0r9ZA1D6kV4HQad6ZnCCGq/kJqjr/yYw
		5+vMbqyH9xwnbO0001rNTrIf2KE+59n9VVO4gg2LhrFjs6TWylriBl9F24VPVru/+2fle67e+yz/
		+/DPeMEPfI8//PP3dZJn/PVn/xJ4fJYvgVKwfCLoAy2w/M2XeZpvhQzohv7vhmgHiBiGDGXI0EpE
		q4EDx40bGMNAqz6tDooQwcxREwMaDQhcaMjAuoaGxsVAwUxLHmZO8mzUmOclM2bOnDlxQrOJs0B5
		cr7U+fJnIJ0zZ0oJGsgZKVJGA8FqarRphKgRwEWragocKQFy5JBq6vVrUwHChHETYPYsWm5q16rl
		cIQsW24c5tKta/cuXg5m9vLt6/cvYL8UBv8TLmz48GFatBAj7uH4MeTIkDFQrmz5MoZ3mjdz1tzo
		M+jQokd/nmD6NOrUtVazbr26xCpPsgURqV3bRe2CugtqKehod4aOA0t1Kx5cociBxZlZrCjCgCNH
		Bpz3YejQgAuRDbUwy9PkZcuN339277lzZlCczn729PlTCilnRY3OjJB0KSxSUqNeMeXfVDQ7gDVg
		U9zssANaCSYYl1rCcMBgW3lJOKFegVl4YV+MabghhxRI9iGIPWA2YmWdvZMFiilmQRqLoqX24ouu
		ybiaJ9XI5kkJttmGW3E9+qiFFn2UMGQpfShkSB/OiWCkRwpp0VxMzkU3XUVarLOOC9ydxBD/l/M0
		kclLGYXnkgPOuJRJJkcBFUgTaq7J3ktSFCWnFEPJuVRQSuHZXzTgpJDCDvsRCIuBO3DjlYIKxuUg
		hGtR+OhdGEoaWIeVbhgippKRuKmKnarx6actkgYjqajNKGMpJdzoySql6Kijj7EScWQfpRxZAnMV
		CTnkkUhatJFzyyyj5DIxoYCCAcwsM9CVwjrCkphjjpdHJjHEwFAmTbSZh0/uvbRSHjWBA44T89VJ
		FClFDSWfnvilGwEsiSSyn1RfCXAggYkmysFYjcYFKcBzTTrwXpYa3FimmW46YqcogvqwGqK6WCrF
		p6IqyI11tGrbEx3X9kSsPjJpSI6rrDJQ/wk9igBkBkuW0IcLLnQjQo/DViQssck68WRGWjjRnQFN
		SBdteDiJmYkpUDC0jrZG/aRt0zRxaco4DgTiwLnyZT1UIOni6VUEByYCC737FSrAoLDoixa/D/r7
		b8CQEjzpwRwmfLemC1vWcBYQPyxxaRRXbPFqpRhueC2r5tgx4x4TAXLI3ah6Yx+VV06Ej4AoqeRB
		3UynUUXAhm7AMk4MS3qxMTVRkxNjusTSRstyCY62ObGpE9QzUTuO0lBAEQNNOtG37kztPqVf2Dt0
		VTa8ByKYNqJr8/t2o3HLPfeFjtU9GN7d5603ZXz37XeoogoOIwzpp48G++wH8z788cNfy/8qghj+
		ceOM499xkUPK9nIfahOOcLSiG8uY2TIAAYhuECF0FZnHzSIoAmEtg0obMd3NdmZAClZQWrBriSGS
		BgVwLOM7NdkJ1LilrTzwzncjPM/wiCendXUNeaQ4EPPgtRbogUVf3IAL9SBkvUdhz0KSsZv3kugY
		MjCRDAvLARTFR77yfaYfVrxiP85nGvVxsYvpkx8Y4ceLMZKxNmTkxQ3SeIPaqBFjJltFCTR3swPW
		rCIzAwTp7GhAAwACZxrpYweDRcEMTsd0FFSWFlzQB+58sCXXisE65jEPAzjDAT2BmrfAAYX/jMMJ
		MZTh1pzhFecJiHk3FICgeBiWBO1AGAj/OksQ4TZECRURMMq4pRJzCaIm8pKXloEiMHMgxSlisZhW
		FJwXk6m+MDLzjK4aoxnVKE0/+CGNpWCVyeLYowXOozgKpGM3vhlOBS5QZc4hHehuhrrplO45FczD
		sLSgkDrEgBmuc0ImljGTJjhgdeDyznhWmAdwJG0c4MjEndhDQ6WsyynKg0WgynYvVJZNlas0SysT
		FUu2zJJCtezLLUMq0pBGZjBVuEAVkqgMyPSypbwMJkyFyTfyGdOYFFNmMpmp02CcEZpllOY0nxCO
		J5jsRkI1oAjKOawFaiGcSnoCESpXigWes4/sPCfqKGg6Q9pMC3X4Kj1d9xNKfouf/WTT/3ec8R2j
		oMmTQZECnF4ylPhwLSl2tSt+8pOfHMLLok05UFk0utEIdTQvH93LSBM70ipoo7HauIASV+rSyZIh
		psEc5sNqWsxS4dSLO2WmBEIrgZ7y4lVAVaMfBhibNz6hnN5cWVM1J6xy9gGbdSiBBPk42z/KtiZa
		1aoFDQFWQzynJWOlpEDdEzXiAUVOcWUPQ9GjFLuGDRZG2U9S+BoVvx5obWYZLGELG6mPKra8t3zs
		BdK70rvxUhmUballL9swv2n2iqTqbBc/C0bR8le0p/jvf89IhNNK836MUyDjbsDNBCqwqRWZnGxW
		Ec7d4jGBxZUtBbNqAAw6JwYuhIILWv8CNTHByQFl0sgJvaO7pmUixd9yADjGkaajSBc+dlWe7QJx
		hXFZRbvb5WF3vftd8MpFvOMtonnLm94lJ9m9k3XyeysbX2DONLP1zeKL8Jtf/cKvv15+H4DDfIMM
		dIPAN6gmORcYDnKWWalLFQE1AVHbVRGhnFSdoAKfg2E/blgEEKySAfrwVUPEQAsjhpp4VtLPMq2n
		JhpRT9OWsp6XEPQ/4FioXeWUlJnolRT/8Q/yfDyoQkXPu0QuspHrUssmJ/YCjtVGFRQbZSZCebJT
		pvJ8rVzfLGv5izoFAxgSkID3ebm/ggBDbMAQ5mUTwXD2KwK0i3CDcEa7CMXhRSkEEc7/NALCD0/6
		JiCIkLE6lALOHJwtHvkISEM+EGcWYY4j+kBNKmWYaOHiZx5MHC4nYBKg6XHaTwjqwnE0l05FSVdO
		vBKUaHz6CqYM9Y/B0l17CfnUqbYLklktUsaqN7Gz/jgTbx1FT+m6pms4Ocp7DQP9CsIIwh52sfnb
		8pcre9n/LUVRWVVtabdWgbyATWxyhGAFUtMPgHiCCIhQBxwRqRWae9K53Q0knyVQWPPgGcyM5IKK
		5EpYBnhJcYPG75noG6Cr8w630No1tUINaf+BQnvSFZ8a5sl4lfZPNAIhFVJQBUAV/Qq+BiTkIQ/2
		4hgnmMYTH1KQv1fkI1dRyY2J8pOr/5zL73t5AtBQ7DAHA/MJkIDNT3FNVrFKAjvvGCCKIIHYRHiq
		3D76E5Zh9AUaDqq8UfDm5DjBqC9jHhSUJ1jr0AeN+MGdj9ZWS2iyLuSHS8VsXyspzL66Tf7HJgbP
		SbroROOhgGMRnFzK3U0B8YgHPl+DJ7LhVT0wxSdWHO5/P/zdz/gmTqP+jq/ylSefcvxaHn6YX0V/
		hd4qvJwnoAGAVdvq5ZwgDFC13cATSBuEeYIgwN4NFAHqxRlVuZbv7dk4ER0HTRCKGVIJ1AEUfFUf
		gF0egeDrBM3qMMlMfF3r+NOIIQVaQY0T8M44rAOa3Iee3JCeEA/Z9ckVzIdReNp/OP9c2QAWDw2e
		AKBf+gnMpMAfq8UfFVYh49UfFt5fw2ADF2KD5Okf5XWW5fUXGLicsPWXLqShGupCsL2cIJyCGkab
		BIABNtXP0RldtDlgEdAh65XCAGnBA3YMtOVP/nSVH2wgm3UTBfle703SkvgOCQpfHriAI6ZTRWjL
		OnyVC2mBS8DgoX2HJaWQTqBJnLRL8UQXEBIFEeKJp0WCf4CDRI2NRTGhEz5hFFYhLubi+/VS/LUU
		Fv5iFt7aFnYhMV4RGIYhTulXzKEBGKBBMIgWMzbjGqYhM2peGo7RKeycG4GBIJhe0T3gIAJCtpUC
		tm0bIA4iOMaeHzBOnM1W8WkBg33/E87wnq6QoAudIJBsVekIi6O5wIdBASc6wTysxJikHVrtxCUh
		hSkqpFCkYvFwzVLYB8ONy/hBlFdcwZ90RdqcH3g9IV1giC6GJC66FPyRATCepP0Jo4oQI0ty4TEi
		o2d9Vszxlxoyo7BVwyrwwjTupC6cwhghYGjtXBpRUwUWAQNGW5ytIzmBYxF0W9F5W8cA4hN4W1Ll
		mdRx1bAQATPU1le9jAtkmNf5VunAkz36zjo8jVhdTaQJD06QQibkmF1NmlwBYVMAoX2MzbtIlIDA
		AsOZQiREghwsYcXVYvpdiEgeZkn20kmKA0qepMitZEt24UuugTIpIxryZE2aYQIA/+AT8AIcYmYa
		qtHOjWYaSZs0MWURxJkWpF5qsuYgAgmx4IwfMNjK9N6wcJAkeV3S4UbOlA7rKMnXlWUJdgfRbETz
		/QS/bUsNtcl03UdcEc/aEU9+GI/e7Qe+2IcpeJ9/BIEqcWRHeqSF4IF4iidihmRjnmdjTpkMrCd7
		RqZLvmRl7lSxgaYaSoDnScA16iR9+iQvVJsJ/CeA7lw3VFNpRpsWOCAeWqBrWuA8NM7UrePVwdls
		Cks3NBU8UlBtKAk8jU7UwaATOIIhEAIkxkBxGpcl7Zt3+ERR4ARcwUdQPNd5FM/21YfX4El12kdE
		SaQrLsIiRMMsDuZ32iJgjCeRkv9necIfeibpLwYTCDSpk7KnDFiBlLrnZMakfIoWffLkAN4kGqgh
		f37mGgaoGgEomQLoDUiAAf7XmRWlBa6jUlogajqlVPrBRBRQN5RCK6zmk0zoPCTlRFAJNdlMVkUd
		6zCDCxDaIrmOcXmHA7TO18UJJo6LQcIoe8xQXSGPjRqFWfxYIkRDJGhnCvgVLQapkPZFkZ5qkYqk
		kiYpGdxSFYRCDjjpk0JplFIpfFppGNFklvJkGwIbGtzANKpRGpapmVYgsUrAsSVANQgCgE4lUz6B
		VD7g0VUb7PWpAmVA/+BIK2QAEVCTFkiS0Z1TbexKrpCOWGrEBz7Hh06JopJJ72X/gkbMBOtokn9A
		gSf9E6VGJ/ahYo65S/Pgy45dQaiJqndulEdCIV+gqsKiKpKuapIqQyhELKzKapNCqZROaUtW6Zbl
		Kpam4QJ87K6uIX6uoWeCqS6MKbH+5ymUJpkKQjUIG46cgpl6mxpNJYE2JWoyjhb4QRG4bDX87Cps
		a7c+ZQFFlZDEhj0+gSQxIgZlGJVMEOsAiXcsQx/EwPAZp+6YiT+dUAuZ5fNRah6gotcAIZ4ciF2R
		jXYRLJAa7MGa6sK+LZE67KqKg8SGAiNQLK1ebGRqLBdRwU557McGbsiK7Mh66X/pApn+VxGk7H+y
		7H/ap8mc4eI27jo+gQMCyToO/2K1od5UAoLP/qwnYM7OFt8ECZonaCIUVIML4WkrzKMhPe3NmBi7
		eZUK1O5HGCd4eEkN5cE6OMM6UJ8pkOiIwWggwFUN0ZVDOgOO7qWP1cuPri3bHiwH+AP1wi3cyq2S
		RiwjbG+syqrF6i0xTiZlpg8VlK/5+m38BK76LoAEvM/gAtsZPoL8zq8ulOx/6kIwNCO0paxp3u/L
		GYERSIACTa4JvOmZAUnqFSjPWa6Cfe7PTpW1AgkzlMCH/awFV8PwqdMgAec8mNg+2owhfFgfZMQy
		XMk6hPA6BMJZ1sSXfBrtHNpz0dWdJG/dWVdENm9fdWfBRq9HUq8P+4P14oHEjv/neRIxMB4AEidx
		Et8SMFFsxa4n+IbvMQ4AFZ+vFVPB+q5vNArbTs6vF+sC5qGBF3uxT6IB5oGBCYSDsRLrKYQDsl5w
		5gFCGolpGlmut/GsgubharbWDVywCpRAQcReKYCMoFnwP1YDbjkCEQySzczRhrWOA+hmH/hO7YbY
		S8SAChCCJo/DUMTgOtRrDn7itLRH1/gETZjYXN2YDdsoDvuV2kBvLEnvD88yEKNq3VrvESuxLuuy
		E9OqL7PkFFfxFZtvFquvfWJe4Y7xGLehEYBBGiqz/KKBZqKxCfRvykpzNQBwAuiC6klAOBBwgR4w
		kJzZzkllBgDCjcDR/dxAbIn/oyeoQAX/LJL0HjlVnQXdJlfVhK5AoiEEpDNoARSIKBR8BHjkmxRY
		SwmJskBxS1LAFaUxhH9YDdZg3yqycvO68g7Hcg/T8iyf6i0X6S/uskjzshPPKntebBRL5uRR8QAM
		MzEXs/q2YQIYQZdC8xhLs7CBgemVrC58sech7n9K2zeXqS6sgmaigQmMGbSFgwnIrBr/51SWQga0
		KZvuLOqtUZ22AnEAArc2mwiUADyDbuW0Ah8ZQJ19kzrpswg0LT9qhCItEkp0cJ0EtCZDwTzAU02Q
		gk0o9CeGbXwgZ3by6CKAwwzFJURatKip7dpY3BNyNEcTad0qA0iPNGUncUmb//RJo3RL2gBn28DJ
		UfEuhHZoXzFMx/T/goGw9jQ0z6Hm0W+AfeZ/MvOylmlQEjAbAjAAU/MpCIIgmIwRIK4Cc3UFAsLo
		EqVpQhtCaLXhsN7PtsKQvMxEIAQDQWsHVpCfcZijaRW4hIcjlM48oEBZGkJKbK2X8PWILQWcAO9g
		S9eMokem4nAOCyYsU09jO7Z9f7R4VrZ+H8BlY3aUorQVSPHkdTZnC7MVl7b6mnEz4ucjpOGy2bRN
		n2wFnoJRJ8CCh8MWZ15Sz7EJ4LSwrQIRLK6yWnAwPC6AzaEnTFVrkVECV+ATuAoR9IYWXDAizwxE
		QBC0clAHrsxAOkFFsI5vEv/BsyTLyswM6zSqI1xJnbxOiomYKKdd9AFFUgQ2j3IyDTpkpt5oYuvw
		fNP3xdk3mBMpCYw5Cez3SPf3E38vgBNjPMQDS785nLd0+SL4+kJ4g+fnKTC4TQMAnwdoMHQjtPG5
		y+I2NUNbBaKp5v1nj5QhoZtpCbgc6HaDIEJbN4QWNUFrRRREKdD4KmQAkBABI1YEmsyWhA6kdj/J
		7k1QR5CgeLOEEzRqoxrN1oJLcfY1wO1EDUlB93ES1rQ3dL53Kz+vqRFmYYE5LZM5sie7mZM0mvsy
		gB8DtLe5tMO5aI92+cpPads5hEfbGakhn387uH/7UheBGd/k55HpABFrOGT/AKMbAU4OdRGswiVk
		MwAPUCncwHIbgSC0wjqGAy/0tmxcwrxXwyV4Amx96zxkAjVd3bcKSybkZoU52u4Nix8EtAvVAezo
		G781anLWhCUp6nkrBZSTwhVcwaTdIDg0Kp0k72HjCXwr9mIT+yx9A83XvH0nO86T+bJbdrPnLUpD
		+zFIe5vHebXvwjCDUeBqu9LLb3565v7ebzTqwrcjrhnjdjWAASAAdVA7bhqDAb0D8L374abTezWU
		ArSVgrv/bBzB3qYL/CVkMiGA7jx4ep/escIbXe8VBwVpjkDSG86AKDxD4o9vlccTZL7xW7vGa3r4
		Nd0Rr0OzfMvf8EXDvGCR/+rM1zzmZz7N5zznLzuap7maWwHQB73QU3u1k3YW99R/Lf38BoNNSkC4
		V7Pqqd5MazPsgzsYb4M2C0JXPwGZWuANAKh9goHhkFm6g/G8NzNxJHXa28gCdUwrELwma/IllEAp
		zEOeakEmdIzsLTw1jbps9VEmcGIf7d48xFvtBr4LOIIUVJAlsc6+EWTi08TIb9rwVqpDzyXkZ/nL
		U76iyDxAcBA4kGBBDl26fFO4kOFCEg8hRpR4gGJFixVBZNS4MaMMjx9lWBEp8ljJeCdPDlC5clfL
		XVRgxlwwk2bNmad45Tx16pGuRz+BPgIwVJcRo0bQDFW6FICEBNWOJgVggv+qCTRgJOiieuMJEa83
		blTVdRUN1SLhinSTUKqEIEBoBAnKUKRIqW6AVm2rtreUFi1PAJW4RIgwoUuCurXScmNZJi1+IAMC
		pCXTvHnLlkleJiLTsnkiDDhZ5kC0CBdQVKiAAiWGFEej8+Qh3cRJbScGcOfW7cwB6drOnDhz1oR4
		8Sax80iR4gx5bOHPoUcPNJ369AjXsWfHDot7d+/fBYQXPz48N/Pn0adHb5A9e4TvG8b/JpE+xIv3
		D3DUD/LjSJIlj0EppZUGcKmlmGSyqaagHtkJJ14c1MUnoZQCI4EEjACjCKaYAsMIDI1YJRywwqJK
		qarMusEPF7q56sJqEnj/4qwb0DjKqAzCCSeDHbtRsZsSoFplFbu6oUuQSy5RAclLPMnAsmVaibIV
		EfwABLNMHNNsmW7mqeyyeQxY5jYRRFimDkP6SDMPF3oTzQkH8qiNNN3oJM42J0jJMw/j+GzCGVIC
		aa656Ah9rrrqtEv0uu8Y9Y68R8tTT9L12qv0oPfgk8+h+ujDjyL9QOXPI/8ADFBAAlUyEEGYFLSJ
		wVcbdPAUEwHw0AgYwZLglKlMWKrGCz88i5cniEWriKpONCscMLaxEY1wnrhBEL32qqYUF4j9S0YJ
		MhCklFJyzLHHG1oRZBUlkfSklXm0kPLbUlrJbDLKtBBBizQdacUPzAwQ/+EyQERgZkxmHHEkNNtC
		8602OnVrok3baHOiT+PyAFTQiwsl9NBA8lQ00UZBhvTRSUnmxtL2ME1ZU4U47fQ+UPcTlVQABRyQ
		QFVXbXVBWHkugsQi0EgADDQkGIoqCI8tQhcJBLlwaF2M9pkrYoml61gUTdCl2mouefaGIiS4tZpt
		tnlWXG7BlaCVbu4yd5W9VmG7hG08WaWEUiybpwRPPKmGkLhbeQIzz+aZUoRW+iBCs8ucAHjwZQq+
		bTQxcSu4OIYNiLM2Qe3EbeLjprtY9Nhsy9gZKcCJxpRFFgnE449BBk/k8Uqe9GSDUs595ZYfqsT3
		33+HeSNRRx2p1JpRLf8Q5wR1XoDnoDgcii4JqDf2WKXGWgXEsmhliqpToiWRxCeqegqqasDIgHwT
		Emj2VkHCkaAErOL344kV/TChBCXJriYcQL61NkDs6AYZqEZqkuSJxPjFMop7Qh/2Vg1PSMYPl9kM
		Zqw0j950QwRv2oy/XNOHGMSgXqApzpuuQJo86EZiuemTbAI1OkE5YBzjMMU4TAeOH7COdYB6nXZi
		J7vZRap26rndQHKnO021DHhNrITwOkI84x0PeahaHqua57znASV6XTyF+JpyIQwlQAImoAtY6BI9
		MxYhfGG5AVrAMDTqdeNbOQLDKsDwLVsZ4RIlCMeKwOICF9QFSWTbhl3/5pGBVmSAjn/50ZIuUQ0i
		qM9xBttfalSwDTBV5oKZSdhtPtmvDtYhNYRQgSEEhpzexKYJdIpTnYrzpz1RTIZQ4KEpApExUqyO
		h+Cwzg+3E0RHDVEARZTUETlAD2UmEVNLpI8TnSg84oXkP1Q81c1csioqZHGLP+niN090lrB9CENF
		A8CxwEc18X1NalQLHxEkcBczZoAIT8DRE3JkgnDw8RLbuETcuuGHx/jBLqXgmj8P08i++KWCIigF
		upBUCkBUCWDzAIQgEKgCSSIOM5+xEpYyAZraYIZMBIOCKVMDhVaG6U6YayHmmpOJF4oOHDxchAMy
		FghT7JB146AOMIMp/0zuELOYxkzPEZWZVGYiRD7PhGYTQzXNmdGsitg8UM6a100KgZOrtTrKJRLQ
		jQz44WdgMQGJ/PAVEq2RK2yzmtQgQ9BSlJFZZAOrXdwpgXAYNJORlItfAKuFybSCCFxbkiBEQEkA
		OnRJqSmBAZ5QGTJ1CUv1ykSbyCQmRxgCk6nRQpj4hbnMrRCmMVgNYWZJS0HVtJcak8Iui8FDn/4U
		qBEQaneIWlSjnudkSfXtUpsakadGc3hSrSZVr2nVqzKvVVrdale/aSun6SJ+ai1Rr6J2RnZuiFc/
		M4sJuuKVixryEkaQSz0nGs9W1K0t8IKMCwLrl1YExhNtcUQGbsA2yf/AiwieUJIESxAvLJXpcWKy
		jAP6hRkXOCIGKkApIQzhCC18kEx1AiXDluGMGBSGEOuY2KCcwVrWgUM6eUKdKcABqI3V1ra3hcUQ
		5ZCCHeyWUu3x7W9zdw8d73jHEBkucaMoxeMiFyXJuyIWdeZc6HJVAnKUkFJ8Fi2qfZGNbryaG9u4
		Fam91Q8SqMuHhrajUsQ1rq1gEdsSI9D4UsZ+UpJSkfxwtygBsAR9mG8rSkGmTPQBS5jpgwMMJmEC
		G6APjuiDChZhSij0QZRkcjQLV9qwhS3Dlj39HHFeO53VgIM0z8nTDgClsY25DqgufjF5UmAKJUQi
		EtHQLY0rdeMbp4z/x7XW8Y+HO01qWqFURLYZS7KJ1SQrecnFjt6WzXpWrkxNRmxstozMSqxle8XL
		aN7RjrTwLcBeW83xvdZjblCZdeXtbVyrRgYyAYj5isARNyBCJvwgJUcg2ACtMIAjmOECf32mNgUz
		RB0EqW9HD3zgsXGpxJowD0L8gDDjmNifLCY6Z3As1KYbNalLfVvymILVrDYFEWlsMoPIetbvsXWt
		cQ28Waxc11Psdc3ikTzlLZe5CiK2sTkEtWIXYSfRSqP06OJOsIRP2l97ggvIGm9AWOWOcrl2Blww
		1zHvVZCLRDOR5nEDvFlmvUuyVjeyXQoiWOYJh8NzCUpAsHyxpc77/37TnQpGcLk72gmk1Y3BcZOJ
		cbAGS32qzuhemyfTQefiLBYqeXYQjY6zesYhr/FASF7yLpwc5SlfOctlNmRf/zpVwUYQN5+H8+g1
		2UMJeO6SrTair3VPakPvStVWRAQSucBDCBWRFgRxN7GiOaBRx3Mp+qaudT0BsKXIwCogiVjHADYT
		+vIEJAn7/NSowhPMYMZoPEgEfM997qFh2MIM4LA8hJZi0wFUcZpjflKAePATHzWLryMA3IpnBzsQ
		xv3vn4KOb2ADKeCAHO6v/hrPqAqiBgww8pKK8irvqS6vAWdBinpt82LOio5sm7Iq9ESvQ2zEnDKw
		u9YKu6BsK7rCBf/qaUUY6Vzsahvax5/iBvfMBTEWKS8Q6pAyYKLm4X7k4pIca10YCkvyZRXaAaUk
		yhPaobOqoQQKRkxEg6S4j+DmgRkkDZQQBqZ6YzhoieKkIHTYb/AKb1G8gxvqDxbqLwDtD//IUAAF
		QA4iYQM6Tg44wAxF4QiOIA7lUA454AhuxwAPEAEVkMcY0AEbkD94LQJNAuZkrgKbJxhcBA1gpQN9
		xSj0QR+kotiWBg1WYRKnwtnMikOSLfXC4UgMqR0gyQiOj2wyyfi6AfmWZBvOiwgeI9vKBW7awjIE
		6gm6JM8EA5MkirNUQBVwARdUAZUc4d0GpwnJxAX6gLPqgE5eKk7/Iq1h9GRi8iTiRkc6DKU6YKFj
		xBDUBLAbd0AA0PDFvnGo5I9REiEaoiEI5OAbIYUDzMMM9SAeRSEe5bEOBUIP9ZAP+/DWVA4QLw8O
		ADIg4YAQC7GqlOslhM0mgsFGwKARHXEonOIowMAEeEF8kIVDgsYowErnlkLZlu0GpiLZsMYEJIC8
		RHEVM4AICwl+PhGS+igDti5vCkdKDKAbHKGBniQz+mAwCKP6LskXcaEdqiFenMCCKGzuSoDDoKCE
		OqiVIuYZPefS3C+GZCgPppLipnEaBfDTQI07uhIWWgwsgcjFcquIzFAYZGEORQEf85Hk+nAE4BIu
		K8EfG1AgAZIg/wsyuQ5SmyywVUDkQyYEeh5yKBKAE/QBKYxmjdpo9ZQCDSIxEo2gjNjpur6GKwRK
		kNzJZ7oMbPShn4wAoQqpFMAAksAgMUoBNI9w3CwDXsylbwSBsCrovtwMcS7hJD3B0AZDFXTTlOzM
		M/jFGA+tMKBA35TwYC5MN0YDpAwBCmQKK0mBOSau4pRDObIyKwPv4lastkwtt17NmO6RLdvStygv
		LuOSLuvSLgeSEGGO84CN5mrOJvYIKYqAiwazMYmGIznEasYHbIzgMMnmWZDOK6as9b4GAIbuA4vg
		+MAAMU5zG1YhLroFkpokkYQEQp1EJltBMNqhCANsoQpmHr5lFf8YjW/qzBGaD+2qQTd187HCpDIA
		pgmJwMFQitEkRgRoA6auQAoMYBwIYxF+AIfyRP2CdDqUwwnWwYaYIzZyqf2EowszTuOIyvHAky3F
		s9bIkzzNcxbQ8y7Vcz0nkAI97z1twjH1oVnQgOcgZFfqMwPpgiSNgBMMkxPAAGrOyiOdrQj8IGnM
		yPUsU6+aTHu2gZEGaEdmcBUCjpESwwVkEkQfCZOa5F2Az5/aQRVKwCblzRGApDZ/8QhLAbQsQzJe
		dO6gQBUKow4MJjSuAOGQwzYywSoJ4QN4SKXshDmIQ1Aq7Qd+oFW3kAvfTzvJMkppbEoNUAeINQF5
		7EqxlC63ND3/I9BLZW7m3BPJdCYYhIZogkJW1tQRg0ZosEIC0OhqUoRqMJPZ5iHgXKAlD6sVvmZH
		0M7poE6QvmU1FZUWu+FIlCSTogQ3WqE2i7AdbtMRSoHP7CwpOcwtROB+/CCkQHXglgE3/EAESAkK
		zqQP7kRiNudNHIA4csMQGG6HVCD8Lo04fJR1fgAcMIZJrxJRfBVKgdWYhLUGiDVmY/YekBVZ/XFZ
		mVUC2bPzwlRMd6abdgJpstXYJAANjJYjz2hF2IgEvxVFlpastK4bRnNJVgG/2AhexArPzPXaok4m
		n8D4qmFDRTH3+AahlKQdtiFfQCoTcDMIexI3BicT4NY3C0z7//qATOJOCxzgKEED70ZLw3CVh8Ak
		ZJ1hp3D1R6uRSZ0UmLazLF1WWGVWZmvWZh0QZ3PWVAzxWaGVL/uyubYoP9dqaLlqW980AfaULhxk
		2YoAW6pGRbwC6cCCoOoVodrBCAJqMW4ARK+l6hKDbANMNRn1+ezqEnxRbDdUBUQRXta2YMJWbFUA
		TPKGkyiMb/PgGPXND8akwmQjY3MjTmIjE0rVEBo2KkGHY5RjHHhqh2RIY0QtO5/08By3diA3cmN2
		cq+0ci23WQ3SyHrWZ2mim75JVrgLnJbGQjiwq+hiWdoBTg3TWw10fOwnvG7AXO2nnlSEBPFJFxKg
		vITGzMz1g/9bIS+QpHajJCYLB0KPpB1+ERiBcUP7SXnXVgRK4Hjphlg6CVRxOFQhqARQwxBeydHE
		xO7kBOGEYx36YHwbJg8oLlCIIxN26IZMVoYCARxs6EcLZXF/yNROrWUnZRTAk35llhzstzzxd1lt
		4IzROI1tQHMNBCG1KYu06HPBSbt+jkPAIBLhFAzUyGfOSIKBBk7x+ExbjwgEyYItsip8BoNjl3rQ
		QEq6jfg+OAOMwHi3YZFANG/wRkpqEyh101+RMEoqaG27oRbqy85EABBwQwSIQF5yGFQNIDUmVRWg
		4GEza6S6V4hfqmGO404mJgZUtSrHoRgO1xRyqldXFn65WD3/RmGZ8RGMiZUcoHmMRwAQcVaNrZmN
		K1Bahw0DlwwsiIAXrkcpEuANBmEQAsAIeOWLRvCDmZYX4ocT8AEf3uAN9LjnqCbo7lm78tks7AdR
		o6QI3o0EzVXcPIEHxBYfAkwQZPIm5+E1t6Ed5oAJJDooHYHdCmZt2aVdoiTuBqgWSqGiW3lh86AO
		OlkVLoEIQGNwEgyzOmgJXWiXKza1QvY4BCV0wOEDDncRLA6LX6dxkxk9ltmL9dCZoTmapbmMBdKa
		r/lZ25hz4TiOuRnn1Gko0AAfBiGe8SF9iOUU0kpGhqJAmWKc41kf4OeCQTIkxUfownkpnmAnbmAt
		2GVFvGQe/+KqcGaYB3ggolXBQRPDzQQhE7qhGnhAFSQar3kgkobSREHKLhxBSA7oMLhGFdpBokJa
		MpyAGUpARSVb30QDtDqbTJBjpWD6N/aEYS6tpp0TdQ4XV6+AV92XcX81foE6qIcajIvaqJH1E3T7
		E84zqZU6jbE5Wv33fwHYEc0IJ+InAJRbnpOie7hKFwQBDJqNLnThCb464NQJrL+JK0wAMsKNCEyA
		kBeVkF2gFdpBotGbCYQS7TzhoS/hvkrACIhwDgibviX7orHEogCheSW7k8WWskM6E66AGQyhhXXT
		EPrFAPKmYVNaTDCjYqESc/hESTkmtZdUOBbhAzT8A0jMtf8PxfB8mpiUOaiX2Zl14LbFOLd3m7f/
		0S5/G42Zuqn58qmhmmeylSQD4A30IQEwsYu+50FypGjBgBMuxMskIILZCQS7Co2qJhNcwN3Ie17z
		JiUhOr3nwKAN26Bfs/mOj28kux3wGglN1C8kI0U1+8s3tARCukzmxAAOSGL7YEUWZuAORgnrDipd
		IAbqYBmTGDmmozcc4FCS1FYXYRw4DWV52mO0mDtfjcRLnKhR/EpXfNJ9odIt3RdefI0PMZu1eZuj
		ek2r5yyUPJy+aGrYaSj04Q14gAmuvGozQfYG2NiabWqIAE8DjghWBENbwQjmIKLT23jTvFwcQRDy
		RRCMl/r/8DsT4IUIvxyvxVYVqqGVE9YBrsAyVBmlmSGlU7nCnCBVHXzuXIAwflEVlmGXAb1i7/zD
		qtIqFdeY31eYGP08HH0UTBzFUxwuJ323L33fMV2pN53TO/cCi1t0l+IUXCAnwHl8fG7UASAB8prV
		s5qNHtKs6omQwQvpFtUyXnPXHz690XxSjSBK/jpfHIF4dXMOEnt5Z9i+T56+22EVQHVfLkPAO0OV
		DYBgCEbgUvpOflPuCE2zccEQitTuZDpk8yATYmB92/21YTu2c2ve6d227V2M8123MYHfL32p+bd/
		P4/GtYrgT6TnvhknvKLWuQoM8rrXeSABHtgRwae7K3iC/zETuzE0LrYhvZmAB/DBsOegksdt44n3
		JFdBsdd2Xw2aSczNEyj7CRJDcfzAAT6jMRKHCNgCCtrhsVyg27MXiEdKTNZBCpygF1UUwUWLfJtg
		HWSKOGJgdXao7hK3/bATxJ2emKAe0u296j8BE3T/6rFe69uT64f7Z+U4W6NsykYdrtaaKapa7c+5
		GwCAythUynZC9gKughqo6kS+FcI27eeAE1SyGh60obFESkrgQQumFQgfpOq1XTe6YJhBMhLrBiSj
		NwhHwVSg13sdwf2CwXe+TUbjCgDiigNnzgjhUoUQioGFDBsayGQICqEfUPI0aTLuh8ZF6/J4/AiS
		oMiRI/8DmTx5MoLKlSxZwnoJM6ZMWAJq2rx5c5TOnaN0+Pzpk5zQoUI/GT1qFJNSTL6aOm1qI6qN
		AVSr7rqKlYrWrVwXeP0KNuyjsWTLkgWANq3atRLAJNAnYW2RG0/q3iiyNi8AE3P90NXbFowEXYQl
		zL1hQu9aXXmf3HDxpIgWE4/9+HGBGXOrVp7w4eMBmkc7Tpw8CRK0efO8VhlalVhl5PSqaoIcZbqN
		+7YjhrY3ZypRQtDsEoD6OLg9b9kyIiKqtXs+p5qLPzGuXHHixIF27NyVixCxDAouFXUMuXCIfhxC
		VR8WZboITqNGcCDreySJXyRKlC37r5wJYEw4DSgATzv/AfUTUUQhxeBSTD3llFRVWZUVVxZuFVaG
		X5nF4VmKrWXEGyK+gQYAp/BSl2OJffghXze8WAReLM5FBBGnAOaWPkbkhZhlmPmYWWZoANLKNqo8
		99wqYKCWmmqCzCNINfi0wwMuoM2hyiqt5JaJIJlsJkgJnnjiiCN9ZFKNKpdc0s4lZTowj2VaaEGE
		AXUgOUc7hjjiwjIizOOAn98NOmh2UvTRRx4LNcFddtw54ARG8mkUgzNSxLDIBxpB0YR99eWX334p
		+edfgAESWNMOehioE4JBKVgUg0k5CCGEEw6A1VUXXqhhrx12yOJaCeAzSABvGBFOOKesGGyzaBWR
		YhHM/+pVBC9EyKhWAiMOElda0NZFxG1aPOHCPOae60drq4iGJJNOQgnlZvgcqQoTeYLmSQalcPnb
		ms+pUkImu3mCEJJ7npmJdg44wkwJ6x3UhwHKTaxco9lB6sQVMSzM3UfYXQTpRc7EwJ6mP4BzUROZ
		LrLIOBd5GhKoJIlqEqmlmmoqN9zssIMwPrOqkxdCDw1rrLI6+GCtvtyKq667Wtirhr9y6GxaYLxR
		bAA7Vs21WtXywssNwTqGWFpoFPsGPoKY4KJlNRLxhLkutOKCI5cFmYEgSPIwh5ZPPnluvEUe2c4c
		eT63TSt+cOmIw+tlmUEfJVyCCxMHqVJHKwpnQkQrff8YUg0u45VgnhbKmbuMxKmLoHrqywSKXuwG
		aBcIKfIRQgjKF8UQw3spdwrzRzKXRLPN/eEMoAA+Ly8MN0CPMjTRRcs661JKN8X0Lk9DHXWGU5vV
		NQBo4BNAAJ4xFn76p5xiF7ZrPQE3+miM+EYCRaCR2dtvp9ZNODfQnRm6vSFP+OCElgIHrydtxhOh
		mQMTqJSn2swjN60QxLz+VQ0RrKJwTOhgnjwBiGVMcBndAESaCEccR4gAECwk1KAq5gTwQMqF30FP
		HpzgkUwEYhxQMMQ6MrGM3wkxZcET3vAIQrOaGc8lyNvZ8nbAjZwALXpCmx71kJY0W1Vle7zqnve+
		V5b/8OliEPpIABq65SxdSKBE6VPLDcDGC7athS4SeEsA5sADI5iRF5ipkQuAlCwoJSABpchbZlqT
		ACMsSTUIbNJmSgCazzBBFfi4RDVKYBkKOuISj7uEa9qhCgc+sARPYKEpl7EPTh6JB9V4AngMYEpA
		EGoZThDU6wRFwxrmQWEeIcU6FpI6hgxxmEW8zxGdkcRALJGJM+EG84Sxg5fgZIpU9IIVj4a06y2N
		i9zzIljACL70oY9rukgkJ/CBxjY+iy4qWks4PiMibvXPf2yjCxEgkzd9iOhIYGhNBSEzN0cikEnC
		qYaWjGAaMQVnM7axDW7KVA08imYbtSlc5R64j1jK/9KVd/rXJYgQwmVo9E+1HJQBsJNL1l3kY4vC
		juwMMMwhFjMPx0Ri8ZapkpnwjGc2EZBNnlfNayIFi1mEEDe74s1vgtND6uyaLvDxBmOBoal6MQEc
		6RiOYRkLH2gIhx+esBfM3MBt4Zgfu9oBhm7QTRABpNtAFbiKQUxpDoPIQAYcIQh/psY2XspN47bh
		iYXu5hIezFMfMuAHFlrGD90oReEM145ShDSWBjCdC2eYS1pyhyHaacJLhRlTIhazpsi8KU4F0LMn
		Iu8l1KRi0ZCAzWxe76hUSKpSlzoWqqbPCAGQawLEiAY2yuVEb3MBEcTnGaiCwQThQMs92fbV1RAh
		AP9IaocijWCE1QS0gk7aTDe6kQEjHA402xiEaBh5GoH5hktNOk0GCIYlNfFCBOKa0zxEQAQ2GZSU
		gOjGPFo4scvGcJaaraUBXkgKB3zWIaH93WhrmsxlKg+aAlhtTFobPVghAbYNIiqEFntU224It7nV
		bfi09ZkA6GJaH3LLILCGvq/BEVsxKiuV8AEXE6ABNhJIDLkOqQ885SlPXXWLEQq4GRdkYB5uuaQg
		2CXKdp3LXWFCjZeu3KXaZIKBF6WkIABRiv+KAE6lcAQR+nADQMBSlsoxgLlWeEo4uVCzbTbpZhfM
		4NA6oSMPPmaEj7ezHcTCwgDC8NAUQZQNc/goRC3/6mL9ALanidgrJGaqibl2tUEMwghdfRGLxscD
		EQUADF51jPv0IojgdiMB5+QbGJ7QjSAJohtGUAUPBlG4dj05NGrLW4hExMoMSLKDTBANDw44D7x6
		YhtTyldfc6OFu3piDhd9Tgm+2w0tzEMLK7wBQ7RQCpGGcDdrNuWYHfDCebiUhrODHZ7RM8R18HAi
		9JkphJP4n53y9HiENrTQED0URXdYtk55NBzhiFTbVtrSl66aLsBwRm+96EVqRMNbFKkPvuGxfuHj
		yztDDVUjJFnJrekGGMCwChdsEEkpf8PetJQBToSGB5wIb71EucpttAY1JQAlQnT+pDJBKRPmatxj
		/3FRjVJsZqwO0IK5xY3fMjFDcsSJpQhQCh7srM6FJ8WsSd8N2pRBQRWL0Mg4ZmpMP4vqJTuFxRL7
		zapqekERdFcEGwQ+1EYXfLEH7/ukF15iZ0lgjQmYasP1kiwwhDpt5sOHA+fwBn0YnlkxitGJBs+L
		79Jt1SPiAT4ykQFYfzfVdrUrGpCkCp1P6Tl5bEU3PLE3fMCGE+atl5XaUY1WmEv3n7mxIwWh9NtU
		kJOgvAQLw5WJr5YSEE8QNwv74C+E9EGFK8zEFVKH9Vy2G5eEAnvYJSWfiqCdpvc2ib53QAqcRsDC
		/q673RW94U9Y5wpYRKDB+86L9Z0iqYBn+Kc1bf8s+nB4HyIByUU+ZDQvqsAtEgA/dbFY7PQEK1YE
		rOE/aPFk1dVVgvAW5oUPrDE34fBixLIKGbANDcQJLtAN63IlEoVdoDFJq4AaU0aCoGFrweEJUsID
		1yZ8m5Qnl+AJfTAuWpB8QshCTrdRBuBYqNcHIYQdAlFSLtQNfeAHMhQoKcU63gdT8DEpPxApL9Nn
		wxMBpEAKPEMKbqd+zBQgcVdN7nd38Dd/1uEgCBQnfId/+sd/gBc+aMADvaVp4zSAa6EPaCMiycUD
		+jAtMZIWckQZZ2Rxv3U/kTQICcAYp3dWqwAtrIEGqFF6RtAOZFR4VsYJR0Y47QBYnWgEWsJI5hL/
		Xu2AD9uwCj0nUa3nJWUCHCWQASxkLonFfHOoWODGQpfAA2wCMP1lHMkxMXDTBzcISntyfQdmhVfo
		fZ0SAx+gKSzjO15YH46SdvghhvoGC6aFUzijhlREd2xgjvCHBG/oAHEYOI8GaX2nf/vXPf33COKk
		D+VjLML1h9nSeJ4hagFgRkTAC1VVLWtUPoOIBpuxJBKQLIkhAeY1IqsQDpiRVxkwN3blAu4CJnMD
		CCtHJWi1GXale45UQe4yD8T3HJeQN7eBGt1QJt1QBIASGZXnB3GiBVNoStPGAwhxCQ8BRE+nHCpQ
		MKqgArvxjN33biDjAE0ABVAADj9kETKVCTzE/zJnZ0QjIQViSArJNCpnmIYGsobleI6Kpo4Kox32
		d39wFI/r4yv0qE4h4o8JkCwThxcsBgB+GD5gEImC0RZntGImoHvGdRds8y0yUiya9gYSCVYAcAPJ
		4gd3KXMjkgA6lhlUBgas0RqVqWTrgkesWAIAlJGpIRyekBq7Z3NX0g5aJi6t4Qit4Ai3+FWmpAVn
		GUvvJTptcglABGcaBQiOsx4ucJRch2fYoSiq02CdAgXUSI3iJzxZuVMmgR9/pn6FBpbkWHdtSJbz
		Z5Zn2Y50eHBrKY+3hYdNpS1lBHFsE4+WcQPBlSMBkE4DWAS6UFyQATdP8Ah8cWQvxgOGt07Qkv8B
		IChR1mWRsmYEgdgOCQCalZk3tOcJSpKRgSMI29BqPAA459IKaQJZZKIbgqBtYrImWtAKRHCT0NIH
		TyBZ2JZsk0NKT1AmzqdYItQw7XA57dAHwSmcsqONDXGcF5ER8rEIzvARWrmVMzMz+HaG63dh1Rk9
		14md6ViWCiOHaQk24BmeC0CP9ahba4SXeqELGbd4YFAEy1J5JoYGbtEtEgA3YvUi/mMEngcagxAO
		cwEA0uIY82ByOgKDmUmR3fBkhjMHNZegmhGarRAOahUkrQAGCGFsyMYatWZramJXgFMmjooleUUE
		cTJBrVAE3wUcQrca3SAC3sVCp9OazCECfaD/CgdBCJcAnDZ6owyxSzgUOw3mEfExKevgDFpJEg4A
		DuNgCqYQndIZjjAxjocmlm74pNx5LssgpVRapf23j80yLGgjl93gB0QwcXURI2wjR83SpZKZLHFk
		Ao5RI4ihY3uoRwlQI/NQIz8mCEVABMnSP3zaCvjTqMT2QHoaJBn5XXb6XZW5GebFesjSGifHQNVl
		ZbcBXgTDemSiexMEbiWwDcXneqVghPOAKN/RCgdmdRD1g67kqtoHqy71UsOUq5kwMizzq+PAO0Ma
		EuPQHhoBKsJ6hsU6d2LZpG8oEGaJlpYBj1Q6YpUWrc6SacWiDzHyIuSKrW8DLvnHFx/yrXK1/zVy
		cQM1Uq/CNYH5U1yo4QI5Eol8GlAJgK9zwLX7OjdoEKmr4An9xBrftQ2x6IrVgGvt4JFUoiWOMEFK
		pzc0uA1lsi9fQjDrYXwZUALzYLGZoG3LoELwUwtjQgSOcAWtMFIhm0udomB45mDQCaTYAZ3FBA4m
		8wMDESpGeqQ2y6Q5q53bGTjM6p1T6qzjObTNMj7lQyxrwReHcRjG5UfG5QJ0ASNpoVVpEyz4wydl
		AwB8lD9VSwTltEp0NaBKpnj4ioptFZJgwAlIYgR8KhycaF2msbehsQpTciUi97Bf0gqgVEmm8V26
		EbhIonSl8ATsBQhEsA3CqAp74qIa5QI1Gv+yBnBDTpCUmQAOMVA7geARJpEJUiAFzgA8n1I7UmCr
		ZiczXFm6PGGdx5qdqcuzy9qszloEQhu7DmeeEoClzhIjvPAtP5Y/WZU2ZbSlaeFpc9FHdMqucEME
		bFUECbB4aVO2djVAoZEAz4uZwpEA4RsaOrcNIxId/iRs7MIDy9aKp1ihgrMKMFgmXYK4WmB0eJJ7
		rTAnfjEnRDB1oORzVadRTzAbhIAQphqcjBIpeBYDEqEKJ/MygUA7Buxg9yGkpOAMDrAIxUCN0XBE
		NGs8SvpvTIqsGqysyeGO3wmelUdiISzJM0IZulBWMEhyaNCA0iIjiwnDdBEkN3AKMfJdq9D/efs5
		oHb1ayKiD5lZQUYgV6BhBNf7HPggbH7KBIOgGjMIHWpDkr5xLq2ZGrhhGa1ZOOvhCXVhrb0oXSoQ
		X3TLm6VQAqLzQAATnCdlYHi2DAYhOrgABQ4gBdoRlcSUq1sZCCMBBYtgCuAgusNDyKRiyDdrd2O5
		Ycm6yKzrs44cj5X3weA0yf98l1zjIsrLrrqLrS/SrdZSF30UDm1xZPYimbGGGXalD6owiKCZAQJL
		Jdi1T3TLA/iamnnDGVjyHIOgkfNQAqfomkXHks8mfN1QDa4Ig5dqsTfZfIZbJpeAJZb0ZeZGBBbV
		QQjhCUc5Mc74dTrKKEz5MIRwjTJVO1pp/8D2wR2kVVqkazPxfLqJvLMK4wSrK6X5t8/87M8APbRt
		kQBk9J4CfbxhA4Hlqp5PywubwQn4ygShmABsFSThsC5IcpmYQWt7E4o7GXklgA8gPTerAQatGFin
		gRqrQMtzcAlWdi5cMkGZ8D+lkHks5JJEl2aZVLWO4Ak+yBwG4AhwkmyOQAh8E9RESUNTCB60xH1I
		uRD/Ow95MA7djAuEMA+LUscOANVRjXZU/c4sgdU4m8HWsZ1djTr4nM+uuz78HCNjDdCD94eK5xnc
		IhfNsiKnQAQsNq7GxT73ZBl2Ndd+OgcZ8F3Py6+mbGxBzFYmRyUaB0o8kABqNQgBygmxJv+amFl6
		GVANoJFrkh3MZeII3SCiE/RdtlECc3IbT+AHDI6x6rUlf+AIWpBtV1AmzixKSJfMIuAHJVAHKtAO
		fsAMjhDb3QdDGINDMYA7hhADu+2/2AHV4yxE9kZaFAzPO3HB86zVW70dXT0xj2YXL6J/0M2tU0PW
		YFCgkfeHEkC7b0BqkAE/SyvlgnlPAimQyAs25XpPmQEueLMKhcUEI4g/smZy8IQPQVx6VyN7H5kk
		4NWmoaHLFpnSl2kuBTWxHlRstlihwlySS7ahlB04uLFtcBY3NzngDuNzNDooqKoKamwIzGDUufS/
		GeOE3war4YwxO4qNwSPcON4SFrykiHz/3Mm9rMydIo4R1tt65OFE1gCgLeaD3awepyZwIsuyPrau
		f1OqlqfgVXIFVa0cDj9mT00b3vn3NrdhI9wdJPVptigoCPVCbK2ckfuaN4NUxdglCLM8JXCqT8Bm
		0ik4CJyQAMFx1p+RektWQfe9k3RtBEtWdIKwbGzSDiXgUF1SCjegbbm4WJW9bYDg2pUtLgsDfdVF
		owvRc+thCClVMT9OnMXZENsB8d8XWsF944Qs6sY6z6iL3Gap3MYo5EO+6tLCrWwTRq8uPoIIpryQ
		LOFgAgyoLNydfzMGI2GKF2Ma6/WDl3exF+xEGRBYF+sDP5mBwjGiwkJiV+1QbGkjl08Q/6gKyQnU
		pQoAOXNvkAEJANhKxlYhSYKjqMsBVYLPQWyGQ5oWui62Jhp+4+etcLhCCG1zMptApBzxexveURwG
		TxynWjC4l1mQ4gDXYRE2tEtL+VmcbvHlZ9UZf8gbr9WmvtyLlSITV/P8XPIlj/Jm8xnEIlxl+hYv
		HCwyouQQFyMScHAv8lWj/PMrkupHr7uZ4RdBgrZXL3lgoGRoUAQSsK+zJl5+GonwJCKCAAbVVd9b
		3yQ6jLCaAXvQUWygwefxYkGEw0pqVUGv8ZlhNtlE5+ClcBwOvu9A9Gbf8QRpIuJ0awAUHjo8aVK0
		pB0w1H2VTpxJuaOHj/iishI6fsHmiP+dOuvx2GGM+Bz5kg8QRQQKNFHQoEEACRUuZNjQ4cOHuhKA
		QaNLoT58AQLgQ7PQYJEbIW88eTKSJMkM4QSGC3fqVMEiJh6aKPKEyEgXOXW6IEJkJy9eO3O2QpPB
		qFEX3boJImKTSKsMAZhMnYMvASce7XjwMGKExxuw+pbmFCTIRQYw7dTymLOqVatwadsZGTRHldpV
		Gd4KajXvkl1VPLa1WrXtUjtVlxw5eqJlnpZMDuZ1AwSoW6s+mTI99uNnXuc+joi0w1WaiQpm80SU
		qlOCiAjYy+ZdueJk2W3YBpY54c27iQHgwYUPD97E+HHkyPMsZ958uTPo0aVPdxbI+nX/7NZHbffS
		vbsi8IrYsEFSHglt9A7U954373bnzidFhhxI8GBBiPn179+fQGMAHhI4JZyebgAKqFN4cWkgmfhj
		qAheevJJKKEEcgGMnIhwacKdjELjrG7QAgMuCYhAAypOpmJijrmMuEutrr56gwd8+HIBKr1aceEN
		FvHhBAy9uillxKU4qWYVvlopoYS+WjGinUu28YTJalSxMjFBHBEkk8UyKeUtkErJ0hEtKjOzMhEy
		KAEXFU/z40xAYHNEvd2cgE2E23pbxoA7cyPuT+GSE/Q45wp9jjpEocsuu+1G8e478MYjzzz0rlDv
		Ut7cey8+kua7ob6Y7sPPQVJLfQiM///w0efTBl8yVSGBTEowKAlJ4lAnIhR84kYiWCqiJwpdcMon
		MPQZpJ0A0LgsA6UySGCOFecYBIwEBjFiFTC6WUWrrd4QBJAMXBAEW70SMKIEvgQBo6u32p3nrVWq
		wSerLFsRBN12RShBK35LyGAxR5QSs5pqLtmqFTgr8wOyVrohDRe7SoCTGQdK6MMFP4LrzTY++/RY
		BEBDNmDQJpxYJxPjDC000UQXva7RR70IT1LzzksP00xvWwY++eYDVdQGXxW6VDTwMfqNQYQetYhT
		fIbQBc1ckEACl8IJV1ibnmj6qYYTCsem9oAVSoJuHEkgK7UECefCBPQBAwy2tlqlG/8QQ+wGjBkH
		0efawrbBZy66281glb+3MossqFbZSq125i7FEaP64mvfraz0pJsnSvGkGn8FmcMurUoYqLLGHNBM
		BEA8sVItTwDRbZ7IHDDATBGIwO1j3O8UGVDkMgEHCkJ+gMKJlFV2jmVEXYbZu/DEG4/SSi91IFNN
		d+a0JKcZFHVo7h3UxVqKJODPIgAkeJslCXihL0GxmwqJpaPCSQikkHJ6wgRd0FgXjHBauSlBCoUk
		A4I42hsS4B+wBKgVnAiAPhJQFrKIa4CroGBX6sKErfBgEOHai7MWxwO3DGUeA5wX4y7XHgmUQjOZ
		aEUmEGNCRxjhMCxqhSO4pRVPoG7/YVrwwxPO5Ii/MK4aBnDECudBBAMQoQ+GgEIfcvdE3e2OOMcB
		hyp+cEVCoIxQxmMO8pKHHe48qnnPg97Npkc9nfGsUyIBVaju0z04xjF/1Gpg2wD0BjS05BQ2ydBN
		5kOScNwADfpLABpMsBMiJAQMBdxgBm4SrI6YAA2r4NFWusI4HugjXII4SrBAtIrAsIUJjKuRvSS4
		yKxw5WpvQUs75pBKTgywPWWZZSuqISUkpekSd1FFKbexunYMpoiOUA1sPOOIVtRCSlMqgQNaobPb
		9EEFalFFCaB4zZAZJzh5cEIemgAdcCziij9YxDqSw8UuenE6YHSUGCNFxvJED2dO/2gPNHvYM/r8
		7I1x5GepTDCgcCRAFW8w2rwIarQ87qopWtOFgRDkKgD4B0CqRENIGlQEvBW0Rjm5gdj4mAE0GMFo
		0PqKERKAyRo1a5Ce5CQB2zEvDHIrL2ZpaQk1mKNWeEIt0IrpYN4lOM+0EH56AQTcuOWvagAGSo4w
		yRPg45kyxQlgi4Em6p6wS7XU4ZpPDBQ3N8Yb6TmBFKRwxjoW8YFxgkNQ6EynOqcTRua9c1LxNOMZ
		26MpNWKPjfUBWj9fpQsJkA8iIBFsESRAkpdIQCMF/U8ADHgKUAXyUw1RLI3CIr/5kUSSBXxDXozS
		lA/1pCgZ4AQve1kWuIGFoEBCw/88cLUrnsBWR4P4Cg8wuDck4ahdg+iltcrSMK9oxS6eSNdbSlGK
		VTBpHoJoTym0UAqlqE4Vn5ubJy5xJCYhzDKUAQR8HMMlyHUmYbWrklouEac+CWc3wNnNGb/61eU0
		YTmAAh4UwGFOkrE1D259a8xkJteayXM9OdvUPfWaT+3t06/7MV/bBtGRhoDkJEUAQBHCMbWG6KOx
		jc0kL3xVBMAuBLBokIDVvKJafViEfiAxrD5kNAcjhMgoLZ2QURJA0I3gQykLNClFQIo1CnXGBUUJ
		hz4GCpYYH0Vd1zIKGJCUkhCVhXBoa9xl7LWNQRwrxlvaTGO45AnbTgUXTEJmDbX/FK9qlKIIQurh
		PC5VPWi2h4UGqMPnrNSHVjjBdnXijc76DDKOAScPUiTOMki2Vv3yFzrtjOs7AyzgjcHZwAfW5/YW
		rB9dGAFpRkuACajWtJNAViES0N/eBAsAXbh4Kxn5SgPBYBEJHFAf+lCIHTPZsJO2YxBgkYAJEGRY
		q+16bxRZRdusYoJboUW1WwGSUZp1NcbAdidC/iQnJtJso+hDK6oYxI3ekpMSGGEbYPEEVrZthAHq
		iEef28ZSOpMJP0AtA9JdHJPGpKVdbkUxRYwMvO8JzUxoQWeZQOK+2qGCS/SBT7pZxlZzR+jhHPqc
		ieYvoyHlvLnajDbSm95d7YlP/wTbx9KXzs+NN4I0CcTqBkEbtT4ISqOOSOAGLKlWIUlNkVPDLSMB
		sEg4aMsDVeijxIu0ygEFwQsA/LMnLAEsQVxstAAB4BQfEggA0LCRAPg2JxngxYdw5Umh6AjKLGnF
		VcJclZaehYB3seQ2qjKIbbilFWC44FTw8SWnwi4TnKScCTOgGb5k4i9o65JmhsXdbrypT2Z6Qi1K
		4UM4OZyrEC+OxJVDcS/6d2bw1LilcOZx6xk4ewk+CMn3U7SCDkJ8+ZGAywexkU6Len4swSxlX78R
		/mXA5fPiyIWnVvVfjcSPTwAxGg5Y5INyRRdrVsrvJSAIsiHFk0EBOx9/S5Z1Jf+QKvjI1m8X+KJg
		OjlJ9rIXPnjKhGq2ohR3XW75X7mVagxQM4spb+j43S4+HTe5gCAJemGTMP+TPCjanWVQuIizvOJh
		K3WKmTHiPAFzr+rJq9ETudIzPdbLsomAsIcgNf3Bh9d7AyOYH5OoOohAA9qaF02SJNWyinDQBRMI
		JIEIij+yOseakQ6EumQJB0HoCg/Mo3BQiiGzH6GQkFtBJA7ZwY3glhlREVVIgKs5i1zjFk5qlyZx
		AbdTkTmQEr5gv/75JSg5khXaO8K4kjnwhCLKkhKwrulCjEuoIdhxAMiQM9C7jfZ4HYa7DfZauPTy
		mD+JAUNQgWTAhXmYIgSUL/3/2i+WYcDNezQzirQ0up4JdKMKtECIwLBKNAINA0HUc6wHg0GWYwiX
		gCwJqIuv0AfjU7VC8r0bgJWQ8AOZux8AWKQaJDGDAosEiIsM4gFlYYqU+DY/uBWFkjawC5e6UAvV
		4pGp6KwbkSDFeb838JdZEpe3cBGeYpH0Y793KYHcMgpicozJgZJLuIQSAJgqEaVRgpK3gIx3kw33
		yIRl0Ix6YkfdsA121BT34g1HYAZmcIQlMoSRYY5lUAVcuJIY+JNCTEB0SkR3wjhG3LgBoydJOwlK
		46u+okTuyahBUJVicSAwWD2IKAiXAAqaKySL0AWjcaxs6YZTEEE/ugGloLAK/zPBg+o0DBykoiAc
		DzQgE0iJH3ybJwQ7oISKkzrGDHqDAAASU2qpjLwWMGCu5dKJt3gWV3olHHoLbHwLfmMuH9ICTvKS
		BEEm8PKEV1KFqWCcUuA/QBA4OhQBP/iYevI4AxhE3QCO2OCT23AB4CEEu4gBZ5gHJ4AOQhhIK/FH
		3inEQ0TE6VBEhiwjz8OUOdwZkPsUihw5i3yV1tMIsACD/WCaWfGJCOkJZlmIUTRKroBJqYMsE6CP
		+7mBBkMDjNi1QSiCipgfC5NJFLwbY8skusEV6gPKnRCEu5kR1RqEicCRnaBCvlCKpXCX9rAXJDkW
		ahqMvsDGeSiFztACL9uMhf+xsH/ZOy4xONJAP7KMP6UgnTjRGffoBrZEnQD0s3q0Dd5oSxdAjCtx
		IpABjjpLhmRQBUIQmYM0RMyDjoV0nprpvLAisNADuTYCmk+sTFJJNRppIA1sCId6KKCYj8IiAoHQ
		NADhhITYow0JiZuwOoyYlwMKAGvrSJgUCAlIibOZFyMIhxMDi0F4ixv4OgnJELArsbV7qR85Cum7
		kQlKgIaxF05Ci9y6K+BCGxr5NuyEDHhrxc+AmhUqCy95DNgpInywkqnggXBkEiP6PzSBDS0oU3XE
		Qyjyszzog8C8EkPwmD4oDf6Egt35z8NEzIWkGcZsTEcsMAWttEl00FehFhL/e4hw0J+UC8VT8ImT
		YDmXSLpTAIM5QJoEKBHI4gUKC8WEuDHSNIKpCYcXXMWkI74byACMchtDwkUZ8Rb/EYoeOgUhFIrD
		M77i7KRScIFbvRFB2DW2sDa/0bUTTDtve5a7wIdt4Av4uCvPgJ0twdKA4yHS8YMb0ILFOIxt2AbO
		ebw1Y0cjakv2hBNooke5fCI/qIMrUQUV8JhlgAJD6IM9kaL/BNBDbLTFpKtGZI9HFL29msxAFVR+
		0oV1KVFDkrm9ctQEoR/WJEmCYJCRuCi6ez0NWr3LuCiRcAGrm59ikQoMmhGkpJCm8ChEEorIaZdg
		0QveA7oM+hx+mZvD0dVr/wHOywhDFxAJHmKllYs3HwoJp4KPf9FG4ESTbmgPH1qGxihTN9OMhvtW
		OLlDiKyePukDFlEBFfBHPqS8yjPMw6RXzjPQsHrMSZtABvXXOEqQEpPJGgQDTwvFT5SwlQQJmIAJ
		lZuPzMKfXcuIN9DMjhJVAFg5k9AFIpAJNAgzqsjMryEJWS2JnPjFIjxOoCwFvXg6V7IstvibdnBC
		oVCbImCWmigJyCCJzcDKVoiJzkjNNyGJJ9WCIuALo+A/kqiFz+iMb3WMHWK/pFXaMxEO9+gNA+iD
		OugDLVBP3LHaq8Vatmo0PWXMAwU9CQTbihRbf5oVBWmQ1uOBxTICmmhQqf/Tmg99iZoAKAqjmoQI
		iblNCNpqICMYpAhRCJEAgOFLCAlohxXp0rJwJJ+Ai8sIwiEURt+kkKisrVdKoEl9A27bCyMkJqea
		2Sdoj3gLGB2koLIhPoFwqsrQCYFYjXH5Wf4LPWhVmDiDUnfEjfH6GGjSx+XQmY7xk+CYhxioA0Io
		yGw6SP26uHrtPD7FVz9do5CjwH513oeQMMQKmhVDFYjlOYcIvgYhiQprilOwCBO4H9JVX0xVCJzD
		LCKYB72dj0RimgojrWhZkaOosSg70ljV0aDUkZINXF2bF7RRWR7gBBvZCeqUM4zhknX5VVVYBezE
		mDL1riLwA/+Rob+phlb/gLzueir4oB2dAQRoqiqlHcA86Q0HgCbhCMzSqIM6tVMukuGtfcA+TVAc
		lkx+RQgezg+/VRDTDMmHsjp8QBprObXwXbkPVZC9vQmYQGL6YcWgMaQKo7A+9oNH3dsKW5u9HYlS
		RYM2YYKB3SPzMQKsUL1DPYkqbgpPAlIzphCQwpa7MZprYeaJSBdPwkbZTZfFmZe84KFlzQQqPaZS
		YIu7qIZuIALx4j/s3Nn4MBOlwI1l6AbZ0IyncIE+SMNLeNOtCg4+o6f9UgH+VAU6vWRMNpT/ArA9
		5bimzdc/DeVRGeWG0AUkBkX6YLlYszlXdglYrjBY7qiVHGaZ2CPTbFiF/+AFmQAKqUtfCFlYAOgG
		i+gJTwOxVwoAI3i1hNCFwRHOr1AbnsgJWPWkE9ERanGbb+NfJWMWGTsKHWFOLXABcI43aVygl/ob
		tJXWgRBRCUGmw2DDcCCmeO4uiXyCRB5TnSGC7hKBt6izK1GBExZA9rqNOhBMQnhXhiZe52ieGa6U
		xrSreFzefdVhUcZow2owt0mIfwIKWi4VCTPNXAlfDa0woCiIkgiaBFkI4jtNX4sQvSWCbjCfRQKD
		zF1FF/gaijDNhHiCbiiaY0yAxEtg+7mVD0lqkVJjdAuWbzMLMwZuCBIcoyAbM82JzVBSvaiGl9IK
		fSiIG5DW++iG1LSlv/9hEb6QjD0mHewh2oa7DUJWzm64gf8zBGBqhz5ogtoVwDvpg3M1QHiN10Jp
		wIzj2oekJ4r+5AVtXn8FtScIqCwDkE77msl6FZVWiD2SiRsIXa/ptVF17c1WX1FFOslMJIUIKNVS
		BXTrhqQTUhKU8JCYl/fTB6g4i0MSmw+BaqM4wbDQi6F4ix2rZgpRXcLwG3yYqfvZo2VtrlV4Eqp4
		JeiiCadyCfNZhZXrBk9YJuDkhWWVDKHdIUXuP/hQWiKoAxVYBQPwA4R+oT5QZD3xGCWqA4EWYRWo
		gxiAb4iLV3ml74Yc7I6LR0+eSIu+6H8lNVeGkAOBKLxZLNUbGl+L7O3/jckMkAnzgTCLgpXPlvAK
		84O3dQHXxiijXOUUkx9gmTmWG9FqCbOt0CSjSIgMMNxuyFwn6+luOJsV7BARYWZOytWwWwVOeAMV
		mYu1OZwe6uMREoSURT/EWAVkkky64wS16LUMULMigGsDg3Jz9gzwhh32VGtAEISxnoNLqJ0tv4RV
		cGs08TNmKAFCIAQrUQFvfTjhBQ41P47Nq2/BTl44h8yKJr3ElqO2wQgIowm1paxUwQePlGxWWQgE
		0dlY41VDAgrTZLGF2KOEiOKV7IyFWDkJQBqC6sQm/mFYueyIWuXPqRGreRtqUYp3CamT44rgXDYg
		OQu6qy0Q+kmoJIyt/4CWVxI6G9EMLdDZggD2Y9H1uaihEpiMVeiRGimC7pqHgXgM1G2zMokqhXHH
		HTJaZjBXxrmEkPhndw3hOymBc20HF8CmcSd3NYfoiJ4n/L7hAwNld6dzOKosTnvB9Inih8iyLMMj
		U2Ea7fVsizp0jcjIBBjpzILwJ3jlXS4Ci12IRBrFXZuRBNDoCYHJ1CxwAKAko9E1T8OIGeEBXvAf
		IiCtbmljo6Bc8JEgAlpV2va6sBMEsDi/V3LCr0HulNvQlK0KrjCBboAMR9iWbcMHI6iJTACEgkjL
		PSaJeuo/M4lno+0G9wY/bDcTx7gdMN/yu7AmrM/6rZcUdH/AN49ASP9kXsqEI4nwQFUZiP0QKY7M
		d/2I4JNGdJlTkKqR0axDOX536YI/aZA4+EN69IEwAld7m6npib1fdIjyA2U7Gh4wH4DgweMNQUGt
		whHplgAfQVX4wIDB167dKkAZXKC5yGmgwEEXXfjx42Kki1YZBuHjwWQlD1VGMoQzYeKGH0elFqpk
		okrVHJT4ZJoociPcoDkr58wJZgIkoKA3njzRoiWklnk3aD4pojWqCECARGgBdGliO1wVvaL1asDR
		vGUi3op4Uk1Vu5114OLN+9YA375+/wJuIngw4cKK2CBGoljxlcaNHUB24GTyvMrLLof0A/XJ1ata
		PxcBKtoEgNKmT6P/Tq06Ij58AR6pVi1BQuzaAIpwJn26SLiYpBFmBQAmQAAeAWiXvopa+e0nMomY
		4EUENS8Ap4roknCjdLduRL6fAnCVdBEiLsbjG2QEovRBBN/wSHDx4HCCrlOSNdKNpItw+ui2ZoRB
		35lHEkz/vTEID3PAN4guJhBxlQSttFLUgjxwAsZ6aJSSlWilGFFXOzx40ko3IckESEgq+jEPVJn4
		UURIoF2W1jY8XOKJJ3241ZVXRAhSwhMGLOPEPHDVoYoKdRjigl5P7gWYlFMWVqVgiCW2GBKOPRbZ
		ZJRdtkxmm3HWGWhajSaTbWvGhgZxg+iDHJtzoqYLEbzotlsrYKAB/1Fvp+gmgXH6JIDcKeHthmdp
		vBQhnlaKmnYoANXd1mh5N7gAlQmHavVUhDeQJoicAGRQHEEYZkDEKkZsNIc+gghixEAEBZDBR/1p
		uAoYgtgqiEj8uQCdIK8WsQoPDPEgCEJPeYgGfO3gE6do4fgBqmghSrSNRZnMo0WZ86h4VbVPOJCV
		ZoB8BpYfP5ZQClpgaVGKJ9uoMBERahlQmQHfQdkvXFMC/JeVhWGp5ZZcRgYZZZZhFtJmnXl2Zpp5
		0smmLnxKAFvFFQOl2ikZgDGIyAE81OhpaGT8iMqnOHfaU6Yxap1QLqTmR2lPlCaBbgUWcZ5zRFQG
		aWm9laZLAvqo9P9GAEasQi18x76RQDfhJDCiQG+AYavWBxWhNbDBkkSTI7aiMRBKq7RynmgSSJQS
		D2CMJqO1QSVwLD6cyDQVjN1mkglNN+BWVSZhvYWuVipqcQNafrjllQhEkFVXCWl9VZMjfPnrb8Cb
		GzDwlWwYfLBjCX9ZWVsNawYVxGeGNvHGr8M+py5PzQZGAmAUTUQ4EhAXAEFo2GYCVKgVQSkA2t0G
		qAsUAxCdozeb1oogh/pBIHSxAS6cKgLFl4EJ3fBC9Xs8DKIsGu7BmQAa3Ui/6irdoIHG18EuNRIR
		GZXSigQJ3F7SPJl0Y20p0YcREsAr5wAFNwg0gSA4cbtShEYz65r/yRP80Ld5pK6CGPwRrARxuKmk
		5TI+qgZZVOEJyjnuccuoTF6804duaI5zARsY6AzGpSskTDJGYpiYHPYwM0nMdbEbIhGT94RTSGBk
		SjMBQhBlBN/BB3exKZ7JTFM8K4ZGPBAynmmsxUUAXAwMuxvJE75jm/KEYziteUPTvDMdMIwPa+EQ
		BER4NbWFuI0T8JvfSMrDHxlloj/hmJqtugERiAxFVKL5VetkUsHWPUg0NFEbUCwYlcEN7gmOKEE1
		ttGOOeADcFvx1ru00ApAlIAsuLiE4lCIlstYpg8lqAMUVFGCzIlAhgCzUuhuiEMvLex0PcwgxEQJ
		GiEWMZkVYxmg/46ntACgBAxVBEAC3pCeQUixaCi7TcyoU8VwlOZQp7jeaU6xHaGUpk9He4M+wiE/
		molnO7FZSgZOYQSl8UA/rfiOCdBgNfJlLSPdsJVJZPUefPCKP1HhY7C+U5J96uIJGkoJyZQ1MROI
		JBMeEt5G0wQIb81NRjHylgZb4Yk5HGsiEPwMi3z0FRGsgi6XyFErXYmXZRigljvBxV1wqctdEsaG
		N8zhl4wUpjH9MGLHRKYymxqbcYLqNE9EydtQYzuU6SJn/NNHAPRRntSMM1C2A4MEQkMERJ0mZvIE
		wBP0capBhOMqOCsNFVNTv0Yt5HZ8esJIMiAIOEEEDa145zsF0f+NVYzvbd0QhP1O8SuGilSjROja
		GuGzirmlSUYjsdbfJibSBc4kE1pZl4wAIYFLzIEsFTnTDaSyLq88oQ4l+JQrKYeXEuxkJ1CAIS5z
		+VMpDUZLviRqMI/qQ9UBcalpcipzwXqd1FTzPdmUVGrYRhyGAA81M2mUBJ7oO3wATzqqodR0KpUA
		lCQoq2zNE27QKp6RSEpnaLoBY4N1A5iEAyYZeKf9JJDGBdlnFRcp0NduBaye9bEInEhPSoxw0dE8
		oVut00IjFwmVplQyRhVEFyCIYITtTaQiFD6cV6jiUrWcuLYvFUEp6FIXVRCht1H6rZQW48tfKqy4
		qCPm6oK43Ob/NlcoUU0NGMh3Ozl1MzVc9Ul2rRgcZyaIOMAThGqyR93qoAFZ4E3ONIUczkzdZjsH
		uYEbvyOdsvJmvwTmTziKcLT+PUECLihCIB9KoVaYQAtfI0JWzNOb6L4BlLR5sGiIEBLAQaXCJtCO
		phIoldFmpRvV4MFELuFBMRmuCCFsHCBuQAQRqphyT2jHkkrQBxnjhcaAYcxwSafjYZKpx8odDZCZ
		K5QnqyZ+6qXrZGuDR4YkgDpolQBXiYO1DEyzNM4TTxcBkOXW6AN4yyaeVu5Enr/1zA9oiFBobDVI
		6a2ZP/E7WgASEBNMEagkvdIVr+LXUD+MM1haKfLdNtQoQksS/4PMSlMFQRsUDGolcUUQxCq0YyJE
		ZyArJC7xitDSjamkuLYxRvWTVO0X0SHM1TsUZmZ4nNzPXLTWTWVmbW7gX+IJTTUJACVgT9PrcFKt
		dwlqcjm3w5wihGd/fNp1eVODbpefJ2ym6Y0EVmWEmHiNJE8gCkHmwImMzEM6T8EIHgUitZEIwqGP
		DUmsdD003+AbKFDRDKxWsQ00zGRGowGEi3BD2rRIReGh9oMWTuwHCkXcthTvl8UNcGPivhqpyP04
		mpgqcthBlXlpTTJdca0aXQhCfRLQxa5Nkx3kPdsIBaw8zBalmzYznq7Jvhl4qkhgXhgvjSITCD4+
		QzZb3dc/b/9Fgzsna55u6EIfoCSIfsDgAu+ARCRX+Y4EbFVF4WE27EEpBevbkYC0q0jRUQHcjESq
		lQyc8ga8CBJLKQdCypXCAKFe8d71YvFWa9x0xj1uMVn34MNXTAJ8Ss6QY8ML99K1/qopHuXBKoE+
		PZE+kIYuoEFWEU1qaEWlmMZsqJcf7Brq1YwLIIo48VWmnFWeGNJAMEQAZEcCPBEYDNT3tMI90YrO
		yNmvTEfdNIRxUERcwQgAaAamgI0g0JzcNI/yAYU+5MeDjF3yFUFljNJWxAggCMI2bMMltEaMLdzi
		uAWQmF1FmMj4lR+U0NhQAZ76rV+syRrIGR78ycbRuEecFIH/ztRG8XxRabyc/YUezD1bg6DGKcBT
		alBKnMlf1QRbcpQT/mEKWgmP/TQUWq2PIPjOm7gV9+hDqsQPyFjNG9AeScAKbcARfLDE2whPJkBH
		8WhGSYxEjOwGZ9wgDkYi+ciXwyga282DTFTfjDDfHGzPJZTCiajYKqTWRFSDVyxDJnCaTU1hxelS
		xqUfFg6TxynVrImGF66Jm7iG0tBcla1heVDM/4FBtE3KGeYfGKVH74yKBKpGXNFVRBAHD+hD46XV
		8X1HFcFh2AyUOf4eGrhVZb2H0oAPfrENPhQQDcoPfjWKIDzLTsBHsAFNxERIhFUGXzlehHxi2DkL
		J2zDKgAK/0aJi0fBSMAp3BOY1o1MBEK5ndylBfNFDkV6xcMtg4rtIi9yTpdcITDCWlINY+F1oTGe
		RhIZGyPWyf/RRvEonlBQjC7cE3EYQQJ6TM/pwyB8YzaZ0TZm1XVIwDNB01G6VzigFT8lR7BsBvZN
		DRjpAoJ1A7GB0tLcE0MQRFahwdHooEcMUnf4FURkVazcDidMBPmwlUYBDoR8RwVu1hGZBkfhoAkQ
		4OSJhurESJoIX1BUX3l40ohQxCi50g2MBVm4y6a5FBH0wWuR30jOGMDgmMZtXJik5OCtJEvSmkva
		hj64hpSdjBGIphGUFedxU7IZTZQNwujlX55UEzQ9BOkp3v/xZBejPMJ1+Q7wZA8W3cad5J+mHIou
		uIDtmOYbvAS3jSHK9EcSncocAA8Y/BNC7RcarEJQ/o4JZAKyZQA+rAQT8MBVzgOfbYVmYR0NitJd
		emJeTkwFVYuiYdScQVqnjMVilgBLTcUSTtqI2BIKeccqVAMJ/ee7UGZeBEwO6VDp8FAwaiHhyWfH
		gGZtaAjGoEbdbOAyhhM5WVXv4INq3gYnmgY7YsxR2uXJ2E604CEABODtZFWShVHXIMfPAYB5EIGt
		uIc1sVMAoQb7aAXJ8A9ZzZF9tMb72EpxcI8YmYizBRpS6EM3FIH8DJ9nlBERmARMZMdcNU+vuedo
		PEVpZZb/SMhEEYSFVpRCNQhCMPBCV4DGoWmaV3hCO1RDCdRCTaXFE6gALriYJ5zYgZqflADexgmT
		g6qkMRGjhE4o7LgJShwHAq5VarjJrGjoTNzmaUTHFznLW+mCU+ZMAbpMo5yPe+ADchSIKJmHp6Fd
		yLSGcYxKft3ApoIMbUAp+/zVGuUTAHTHRrxHAujCftHNqnICspkHVBwKPMnZca6KPkQbZuVGlyaQ
		Hzjke0bk9RmOV3SKt4DG9H3GVYwfIKxCvdTFJUimgfppZfYFZprOoHbcg0Lo+yUq7OjCdWEN8bRM
		bHQXoXjqbnBobfRGshHbdQ0C2lVqjeYMg71NOKiOU5xq/40Cz7MNYpN5WlTxQneWBoWcRwa41ewd
		zYXAByOWB29E4k54VThY4qcwRxp5ZRT1hnpxlLI561PQRIRaUAAxUZt1SnxiBWi0lkZ2qyC8mCps
		w72gULmmml/kGIM2aMdlUJlAaISqybvCzpJh02mEwxrWiS5ozG7o32kQYDSipuLp5Ds+H5v833Xl
		UzekBpSylQQWQSQSBDaRBqas1SlkQitMykjwQlmFDKFABD7QhUocC6siRFCAARMYhXiiQc8QyEwM
		GdtQGrQkAG+A1sscZF5qmL8BhY9G6SqsVOB8BricScN1KyCUwjbMaYSEGtH+C18UlaCq67oWqqF6
		5mdC7f/rxA9y/B/KDOycON7J5OixaGhpJEC5YQxsppNYmsoApQaWrs+d7M6beWrx8Jm+Ak6pDkVZ
		1WwrcIKOMsgqoAxCRMiiaSBBwE1G2QzL6EYRfNh7GAFbJVolyZOzlgm0elY1XMKCtUMJ2GzAAQ5W
		ZBpuLENWjO4Ap5DqvkVRpevrCh7TNq271m7sRCNX1SYR/aZsCKVQbtnj7YZtsIbvoFTLnYbtHA14
		od7nxQTpVXA8YQrq3YmnWIcL2IoRpOwhNg8c+gEZThVD9GSUWmLzMIdwoNREhGM8XaBMfGnlhh1u
		POTEbAS0tIMYQakQilJU/G9riRIBD7ABi0AwNWgwLm3/Mcnu7BbjA8dO7iXjvA6RQdqGdzFENpXc
		o0Kqh+LDHVqVNbkN3AzdCbNV4nrZlvJZpggPgVTHSKzPQpyKPogRqJRRy2AoQ8DVOTIHOSURPQpI
		of2lI2Gu8tHEUlzUKkjEiPTk7nxGfn3GYJbyuGKxFKpuAmvmji0tA4exGCMqGb/O8JJMfIDommwX
		mwwvshhBLnfR7oYDG8cHAnZDsaVENrUXGs5ZpIBKxAJNVmAKhDSKpxnW3t4OyNKGDJIGHBHK7RBI
		JqAvW1XRbBRBd4BTOC1y48VvXsoI8k0MGOwEtHiCVkwNS5EWbkDpDZRCuwCwR6ZytxJturayF5MJ
		LMey/wPT8uuwBkrwKuxAIJucDyLnaxlq6f6ZwGwqqxtbRwDNpu/cIeptx1KkobLJVQWWkbw1yqHw
		1X5pzUtrhQQE0nbsJQCAUwZchQvI2XZ44m74gahYKkGa9Fy5Z7XA82hIwDYkAOc2pAnU0ynACi9k
		gOGUwBFeAol8UIy8aUCLpJ8O6vodV+yyjtM+7UK/TndJHjDXBnXNyaisyQ/LxqKVKGqggebJcHrw
		XqXEZVGmBtCgHp4Q5N/EE0bIj8USVCsQ4BOkSk9bx2y4AGOhLdEsczmNTbIhGPx2qaY8xcRcBxMB
		hT3NFKVBkGa0rUBMxDbgMypzdW0daEEr7Ssj9FiTtf9Z125EzwlvVMzWLgcch7AGQhv/ZJco4WVs
		5FcgyYRK98ekOLXxkc3/sYrIiBGgjMelhs8gQQT/KJvNWCr7ZMD/7ZoJlKfJJJrLhl18XvJ7/iXb
		uBhGPlIpEESlMcpnPEFIwlbWrfbQjqRmvvYrg3Esk/Xu0natsfWcpJxtwLVqXDR0JQhKOEg5dYpw
		7h84yR+y9Yf3sA/9YV/8GEHiuglKGYeAUcoyv8xfvWMDMk8DraobaxbOCE86I/F7Osf7XlQFBQW2
		QMsqfEYr8MKCpcQceNCZCIIn2K8J3bculp8rhzVnNu1/B3iiDjibPLlt1Gtt9FxquBMyB2wC4txd
		2av/B1bT893APPQGE8UPH0cjSvSEUyuINQ2CfDTZ8Bikm9gHD2SXiJpG3VwkHUeK98iEBFAZeT/Y
		Zsfsg8mNCawCtGTLtnbDfRph534GbrXlNthpkZMrqu33QSt5Z3JhyDU5aPZu8PC2gbOJbsNgOOSe
		0riGNC1KjboANZZGxsJHKN9oWKKXflCNKrwHB2LsrLDTRSQHZ9xJdfyrsUnReISwHdNjbIgwSjQZ
		vikQXhI6tJbCRAzCnIKGt3Kudoz1tJPFJfACpbO2pcPuQfe3fzN5pxsjbgD4chjvNgI4OqVGGQkv
		8ZqzdQSFNlKojuZTb4ATGKCUNeFNOBx6ypaVRpMVNhGIlnIsRQnrpK2276+/5H34jlsfj6lYE9zk
		JXTkGb7FiJ8n7sRwq2xrxUxNhI9vNbinBaoFBAA7
		"""
		
	img_dict["gene_info"] = """
		R0lGODlhLAFkAMQAAAAAAMzMzHJyck9PTyAgIK2tre/v7+bm5oyMjL29vff39zMzMw8PD97e3mtr
		a6Wlpf///9bW1pSUlLW1tYeHh8XFxWZmZioqKgcHB5mZmRwcHFpaWjk5OXx8fP///wAAACH/C1hN
		UCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtj
		OWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUg
		WE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAg
		ICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8y
		Mi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAg
		ICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAg
		ICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29s
		PgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0xMFQyMjoyOToxN1o8L3hhcDpDcmVh
		dGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0xMFQyMjo0NjowNVo8L3hh
		cDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlw
		dGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9k
		Yy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1h
		dD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAg
		ICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u
		7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1
		tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18
		e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURD
		QkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsK
		CQgHBgUEAwIBAAAh+QQBBwAeACwAAAAALAFkAAAF/6AnjmRpnmiqrmzrvnAsz3Rt33iu73zv/8Cg
		cEgsGo/IpHLJbDqf0Kh0Sq1ar9isdjuMPBOdjoEWKYvK3lehI5E5xqlCgUuHAkbhJKMTSWw6Mx0A
		gBEYYQwOLXsRBRgxF2koeXWUS3cieXMimmsXBQYcHGccFxtnfpAsG20mGxeAHgUJoXilI5cRFyN/
		K7klrLEGfa4GCbYer7SYr5iwlc9Gg2HMqb6FY4YeEqZw2x4dugaOK5clDF4OgBeJ3ukexiK4urcs
		AA6R7h534B4GAAkeOMxhJkEUrw6mJkFbKAQAGl7VdPlC5mViQQa6JpVLcanABU/iwrii6MGXNEHx
		zv/MS8kCHABRHhwVSAjrUp5U+nKmVMiwZ49yNytKnBfRA4M2vjSywADnG59zZcYUdYiG5UQR41yc
		C1iAwRilTknmLLfPmc+zOYCqA+ixJFGhOtuCVSGBAR5AAOBIhXuBFRx5IxgAVCFsxLhC88AGLSmq
		KE+0kGmofYeBw8iJRRuVylizhccLDDh4MYBxD8mJHBiERgZAYmvQg1dwwADb8GDF6jAy7ffxwlez
		kYMLX5J1uPHjdFYhX868ufPn0KNLn069uvXr2LNr387dgffv4MOLH0++vPnz6NOrX8++vfv38MsL
		EBCmAwUEEjLof8C/v5z/AAb43wQTJGBgAhVUEMD/gguiUUYDEDZwwIQUVjihAQYooEAKFnZYIXcg
		SufhiCGW6NyIHpqoInIodrjii8K1aCGMNKLlYRguxgPARvrseIuPJOzIow5A4lCkjj8KGaSSWhzZ
		Y5JO8likahoQQAAJG2xggQUkJCICeCN854F3gCCAXwYPbCIHgb2YcQaELYzYQY5k0ROknToFMWQN
		Q25UZ557VtHnnSwViqdRI8A0wAhchtnll45CKgIracYywgQqRHLGCA2wICeddg7KUqA8kBrDHVIS
		qpOpguZp6J+GjhVYoiIseoKXko4pKa7aeJCBCZh6wGaCI2i6qQid9sPhjTn2CKSQsF4CrZ5Euurq
		/7Sx/oStDaiW4CeTh8oqAgNVXlkrCrzi6qWYJOT3KwmaiFCgCAGcURWncIrQlAmfzuhtodKGGu4O
		rL4A7qsCO9tklKr66e2UtHpg65aN6hqpxeu26yu8JQTrQb0lFXusB8nuW0K/Hzac8KoDV2vkoQ6P
		2vIUsF4Ls8qIiqAoo49Gqu7FwGxyqbwjgBxJGpGUvGyF9eFIoY5SHnnwwQRvO4OSWE8L7bcFO5E1
		qlpbDaiPQlJpJZZalqAuu2N692WZ+cFbAIHBFkhssW4im+8KMqZcY3Ndu8ArDx7v0PfTfyceBIGx
		6XD4hIpHXsfjB0huuRaUX665FZlv7nkUnX8uOv8ToY9u+hGln666EDc6jbjCS5IVpZNE0n511NKS
		bbsP2Fpd5Ndi+w5lkgqTa6WiWW6ZQnhfgjmpfmrOXTiCFZBwL77JqtDhnBNyDzmg4UZLbbZX46x7
		EeLb/OOTLLccc/oeaKDzuSJUbMLPFluMwAiVxlt30SNL2gtQ5L3v/UlU7RtC4MhhrbGxT4EnCFhK
		ZMc++KkKfAmMnwfMRYJGWSARbrufCD2wPxH0b2jCAmDIjmUsvjHLX87K3e9CRbVSVStV9OgWCrZ2
		gz1JUFyy+qHscAgwqJWgXCUwRZgy1rMmamM/amIT0eiFt6NFKE7bS9G/MHjAmfWwajHD0wK5FUH/
		qc1QZtkKIxcNJT8OekCJFxvc4PJHghNO0WNGE9kKSeYpCxXQb0VEYwLH6AJCqqCLW2zgDyy4RjRa
		8H1iHIH8SGArDzQKf7m6GAneZak7qvBoI8ve0ijUtAIaMXaoJB7vxHYq3YHta7BT4O9m+UrgUe2W
		wzulj4xHyeRdkm2ZzOSZRjCg6d3NXpq6Yh8Ptzo6GFJwz0hdM6PzwTli7nHTzKYPpKnNbtKAm94M
		5wCxKc5yxgCc5kwnv8ipznaiAJ3uVGfr/qjKet5ydz3EJwxmJ0OF+e6ZsnxYP4HnAzGxC0z3aQOa
		OEG3TOXtnH4kZcoYyUgbkk8GYczdA3+oSDuY/w9sK9sB/vCHHxMKbYonAKUMWmTKRpovGi9D4PkE
		2VGvNZCCZwSoCkZqgpJ6wI4lQJD19AjR7dETajJMHyurlhZrOUyHGdRp7PRZSKfeCaoc1QHz6CiC
		/f0KqG1qoQtahABAisBcHETrCNR6ViG4kQZWcuNb07rWs5HgrVGI611LQNez2rUHzoCFYDvg1Z92
		snEpEOBKLVTWCTX2eyNYiWRFMFlkRNYHla1BZVdyWcp2tgScjcJmTZDZ0PKAAiNArQdUu1qTxiJY
		sUHsUJE1Aw9J4Lb+WoBuSxAKmOhMGb/1bQ96ewPiGre3ojhucoEbEORKQbnNhS50fWCm/VW3q/9m
		MuED5jAvESSoekUDGfa+yc54mtcDfcOQyc7bzg6p970YYu95DwDf+qpXvua1r37xG0/92pe/7vRv
		fQHcTgFnSEMbInA664vgBmtIwQs+sIMj4GBiyqEE/7FwvLRbqR705wYf/vBPOzxiEY+YDvwpQYrr
		aOIV11HDwjoQsRQEsgWRgEE2VmFJzKBMyKL3QuulgYMRXIYKpxClhTtyJ5fsg3hteAYXZvKG50Bl
		jtHhyVImppW3LCxMGci74BXvx248ZjGLOV+VG0GaRVC5MQR5BkNWQAPkbGTwegC8dh5BbEUgWx7s
		2QZffoeeBU0C2fbZCgBpXKIHfQJDF7p6CqL/F9JEZqwWJjPNa25zCd4sZAfPWQEHMPLHGEQvUnt3
		BHiuQKB9cKBDv2DRe0aso3/Qale/mtB8xvWhZ33qeuWxIpziIwlESVs1o/fY+lJWEIZsoQabIA3i
		rbEKxZtnH1RbBpC+M6qPeeoSXPsK3yVBuLttgmvnWbyT7lT2lBnsEoiycprWV3yXHWdQizqAeoyE
		tKkIBDHToMb7HrOOB46FaPNb4AYnuMAPnoZk5St7a0Y2CSKe5nlzmgf1Vq+zSbY3vYnyeqP2tw5M
		bQNS29jkOSY5jkU+BZTjOOSljvbLdRwAMzzoinB6GuJex2Y1Qy6+F8d4vTUEgaJDAMJSEKvh7qIQ
		Z6M7/ehIF2eDn071qEud6liHutW7mXWsb92bXa/617UZ9qePnexlN/rZs5l2ta+9mVifetFlcN+J
		+9hwEf9x3l0I7+/5GIY8x8LdB/+6wFN850C3+L7ga4W4zx0HTQk6Dihu7HH2vPI9h/flJZ6FvVP+
		8pme+Mkub3ESSH4KXvfB6W/wec73cfOaFz2/uBD7zGN+9rKvvF70wpDHn6X1e9fesUOfd88DAYY1
		qP3wb5975vNewYsfweqT7Wbpz1v6m65D3eUd+RME2WTbJ3D0k/2C3ZNf2edH/xa6j/7nK/vN03+7
		/OdP//rbPwQAOw==
		"""
		
	img_dict["clean"] = """
		R0lGODlhIAAgAOYAAAkLD8bGxgxp9YSEhClbpJS69ebm5kBkm1WEyDhHYJ7E/1V5sIKl35OTk9bW
		1h1o2vD1/SUvQFeZ/8DAwFRqj2aCrDFcm0yS/yx47qOjo3qbzdLe77zW/0GJ+Ep7w22Ty8zMzNfm
		/2N0jhwkMDlelefr8i87UPj7/1JieUF5zrW1tXKp/4yy8DZos1GV/xMYIH6UtV12n0dfgkpef057
		vnFxcYiewOny/6nJ/yRx53COv5iant7e3vf3962trYyMjMje/x1x7pW9/////1J9vSlarUqO+GuE
		rd/r/6LF/5y9/+/v75ycnCh16099w3yu/1SEy6/N/8re/1J7tWCEuDN+7EKN/1dmfih06v///wAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/
		C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRj
		emtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRv
		YmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6Mzcg
		ICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8w
		Mi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIi
		CiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAg
		ICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JU
		b29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wNy0xM1QyMzoyNDoxNlo8L3hhcDpD
		cmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0xMlQyMjo0Nzo1Nlo8
		L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNj
		cmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9y
		Zy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZv
		cm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+
		ICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx
		8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4
		t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/
		fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdG
		RURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4N
		DAsKCQgHBgUEAwIBAAAh+QQBBwBZACwAAAAAIAAgAAAH/4BZgoOEhYaHiImKi4yNjolDj5JZkZON
		Q5WWipiaiz1DPY0GDiClpqeonwY8BlknmJlZDhpQTh63uLm5G5glrpyEPB9VFy7Gx8jJN7CgrYUB
		QU9C09TV1iHMEDsghTw2GNbh1EnLzAUiKs6CDghG4uFANyFSURyvCgcZDoQgKVbv1XAkCXcCiIUG
		3AaB8HABoEMhOJAcTCgIBA0XQnS8iDCCgpAZGUdMi0BthI5pChb8CMDvYkaQQl58zPgCJEkhFSgk
		mCZBJUuFRCRkTKAjhomZOmaYYHAzAQsTLIRIsLCSnxOMOiLMiBEVZFIGJm4CmBEhhlSqPytefVnN
		K8gZAIqExDDLQuTUqgrXajBLzezeaUdnRP3I4m7aLCDWPgToAi0hB07cLX7XgQTCYDDATRaHBQWT
		fYMMqMghbXO1FQ9q+OBRCASVJhdiy55Ne7YAGT8mqBMkukKLIgSCCx9OnECRKwN8gO42IUODH9AH
		SJ9OfQD0H0xULDc0CkSA7+DDi//ugHWn8+gPBQIAOw==
		"""
		
	img_dict["help"] = """
		R0lGODlhEAAQANUAADMzM4TO5Uah0qChnUeNscTQvavAvPn59yFWeWmwzLLWz5mZmcTm1ySn+Ie8
		xrbg2E16jjNGUZfV4dXYzzNwlNXozW3F6aaspp/V2UpZXUJMTkm28L/Ovrrj2oHJ39frz2F4ea2t
		pM/XvaPY3Dg9P1WInTOt9T9qgC9PYi5bd3PH6LPHvszMv7Xe3tTt01G577O0qKOjns/s1qXe3qrD
		v97ezpvX4KGnpLXW1t7vzjhHUDpCQv///wAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMlQyMDozOToxMVo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA8
		ACwAAAAAEAAQAAAGqUCecEgsFg+s0GIRYh2MvMkAJvp8CqHBpDiJiVyMjpjB0Q4PA5HsAdJkHKNH
		+clLuh6kTKIE8NgeFyxCISIMGCQWLxsnEAEjKxdCCx8dEiovJg0RBCoSCguSFQ8SFhsNCCkbFp6g
		PCEFlZcUKCYvnQaRdSEMIwEWOgIvFo43gjxoHA82ASoWKgE2NAN0UQPJIxoOEiPSW0RSFys4CgY3
		ZkZIF0uB1FDuQkEAOw=="""
		
	img_dict["help_h"] = """
		R0lGODlhEAAQANUAAAAAAJmZmU+06CiRz7PKwABZlZijpjCs9dnZzQA1WJ6pp4W1xvj59gCZ/6DB
		w9DWzwAlPYLE3ACB11W57BWh+wA/aX3B2gAXJ8LIwhSc87ne0yJNYnfJ58zMv5LS4EKz8qXb3q2t
		pMjLwKChnQBnq37L5pW7xKnHwwBMfwELEQkbJbXe3qOjnr7Pv3jH5d7ezrG0qDmw9FK67wspO7vg
		1Yq0w8TTv6etpzCUzqDCxHvD3p6npr3Wvf///wAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMlQyMToxMToxMVo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA9
		ACwAAAAAEAAQAAAGp8CecEgsFhmdUCAQ6jCMPcQIZqPRCLcRoohg2VaeEqfkOWmHjJENxNmoZjgZ
		xzF69pIrTgoiKQAyHy4KIkIhLR4CKQ2LFSgUMiY3QgE0JTGLixckDTERAZMaHAeYCQmLBzqfPSEE
		losoEJgxNQpCHTceMhQNFxKLFBMGGEJpJxwfu78fC3VDUjkuMioDMRMLAQ9cIzsmERY1BiPZRgwi
		N0sKGHZQ7ENBADs=
		"""
		
	img_dict["help_d"] = """
		R0lGODlhEAAQAOYAADMzM1u650Ce24+aoKHHwVqk0W11aurz+YzR43ubryql8czr1oyzzEZNTURs
		gG3F6UW18WyoyJ3B2WuQma7f3FKy5pKanztJT0FWX3nF4Dyv8YmfrGWEipjW4Uif1ltgWWZ6eX+P
		hGSuzISdraLD2H64xyyq9ly+7YWmpDg9P9vx05mZmUq173l5aFKk1ez0+bbi22KmzXGatWTB63vK
		5omZo5K1zERXXjqt92qqzJy93i+m702h1TCs9Vql1kpPTHuctf///wAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/
		C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRj
		emtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRv
		YmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6Mzcg
		ICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8w
		Mi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIi
		CiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAg
		ICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JU
		b29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpD
		cmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMlQyMToxMDoyM1o8
		L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNj
		cmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9y
		Zy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZv
		cm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+
		CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg
		ICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx
		8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4
		t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/
		fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdG
		RURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4N
		DAsKCQgHBgUEAwIBAAAh+QQBBwBBACwAAAAAEAAQAAAHuYBBgoOEhYUHDCMrKyMMB4ZBEgMyAgoK
		PAkDEoUSNQImGhCiGi6agwcDAj0sDhcYIicsBQOPQQwJJiwpNyUTABkzLI2CIx4aASkdFDAgHDQn
		MRuCKwoQMwgUCyo/KAgzFSvTOywPCDAqLQYwCA/gxDzW2CEfCxTeEdK2CRonNB0NBCh0eLbBhiBU
		LljMoIGgIY0ZOSy8GCSpAIsTF0TMmBHBAglOA0bEqFAhwgiPkBBtWFRwIqSXhAIBADs=
		"""
		
	img_dict["help_32"] = """
		R0lGODlhIAAgAPcAACoqKpXU4JmZmTWt8R6N0QJrss/TuZTAv26KknupsFNTU7XYzYrEz97nxzd3
		mQCM6Vqt0nXG5Cxgf0CUwKiposzn0y9DTd3e1cDKuHXA2cnSvLfEtimi6qXU0RSP3QB90VWt11R1
		gEWPtYnG1Obm3NfYzly76LHg3Bt7tre9rzRWZzGY06+3rhac8E2p1yo5Q3G50aSkn6PZ3N/vz8jl
		0Iq5u0Kk2HfD3b/gz5rGxkJpfFybs0pKSk53ik+57y6PxnzL5lRbYNDnz+3t5We+5AB0wiGU2mS4
		3d3x00FBQcXGuiKi8EKs5kuy6Nbv1HeYnovM28zeyKDV2FGmzrnj2mJ6g6ze3XOvwACB1ykwNTmN
		uqTPzDo6Ot73zsTNuIO/zVBXXA5ytTmv8wiU7mi1077l2bbf1lCx4XvO3qWmoV2+7MLEr63W0C2K
		v+P00jGe3DqHrsjbx87UuoXO5H60vqyxqEuAlrW3qt7ezpbFxi1+rCKc5ozO5s7r1matxxuN1GV3
		fVBsdmifr73m3p7Pzx+j9Dyq55vW3+bxzdPozi6V0DZWZS9HUzun4yea3y40NzFngwhxtkecx8Tn
		15+hnj5JTQiO5G2+3UW08ACF3qvZ1ZTO1nq5zAp+yYHE2GrD6rvh1VW77guAzNncvXGJj8rRurXe
		ztbWvVpaWmTB6zKb1rzLu7vHuABzvbu/r1V7jHSbo1mnyW2Ch6rRySyQyRWS4aXb3q2tpTMzM0m1
		72O95uj0zoXN4d731qTU05TO3lK05cfhz3mstjORxUel1imj7JfJzHO11t7mzjiu8QCN6yxkhzhE
		S3y/0sfZxTOn6R98s0qt4HrC2lNfZGS74UKt7wuF08XFtTKh4YW3v7W2qDZXZq3e1v///wAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wNVQyMDo1MTo1Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOFQxODozOTo0OFo8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQBBwDdACwAAAAAIAAgAAAI/wC7CRxIsKDBgwgTKlyYkIQSbZQECKCkTQkJhghLpKFooAEiRA1K
		3aGUpgTGgUNuUTCwaxcSJzBhIkFSKs2tIRgvxFjz0QkNHAuCBsVRAaarGBcWXhDA0qepWTkOSD2Q
		YwsbUEU1CEiKcEiaUW6c4GCTo0aCJ6RIwRKWLU8HM5OceKGE8+CtNbucTGKTh44sVDySJFGACoEw
		Br7gOklx62AJCoj0cjNGBxAPLo+2bcPFRUGVKwykUJmUKIbJgmkMuOlDxdcXQZdVwNGiBQ4jLjx2
		cNpki0ofDGkKkqCUd5KVTZwC4cKlZdgKRW304ErSw4+nQ1ZIC7g4UMmd1VRkQP+BYccCJEWO9uwh
		AI0ZFx2xMvzq3aeOEoLaTiGZdOIQr0sg2PDGHi20YIkoYSSBiwNTXMLLISdMgkEdBFHSgF5WBAAE
		EcAYwkELYzyARRFBYDaMC0QAEUB2cVBCkACRlZEhEKn4kEwhYygzYhBJAIDCCtHooqIVZSQiwIsx
		2qJhjWLgmEkRqPQYyR/YNJGKiraUIcSRA1nohIxL+iDGEpZ8AEYSWRRhzR7P+HDlimW0iJ8cGGr4
		SSjVFONBgrgU8EEtxVQTyidDTsIKhd1ps19/c0SgRi7PGLHMcp14sMcAuagRwRwQTmIfQSTEMANr
		SgJxJxOqSADACwQ48gwmg2LNSUUF26FWCoaHNKoLMDYo8sMPqjTSRCipbIqdocEV9BgypAbQKDUg
		SCLCBMScYcInmwbQWzCUnFbQLa7oRYWSvNxAxisKTAPBEREAMYe2o7HQ2EFDxOCFuLYcAkUzIeBS
		CQzS8BIAvJOsQldCS2kgrhVSbMLAF1+MsMkhtlgx2gZbKUVJCon0MYkZmvhCCCG+aHLCaMGwQAlX
		C6UUAwZOeAzKzKBMMgkNrNhU10kaCVAHBlEkkogzhwpQ0kkGOVRHRBPZxx3SUEct9UEBAQA7
		"""
		
	img_dict["pina_help"] = """
		R0lGODlhWALIAPcAAAAAAPgBA7/T770PHWp9SQAA/6Gr1lJSUpqlx97e3kpcpWV+vgAacf//998H
		Dv8AAAAfXp+ftbTE2Gl9nDo6Ot7e/0FXk5mZmf/58ihFspGUwcXY9IypYLXE//f39+CmfikpKqC9
		X1RU/2ZmZpmZ/76+vpunhPbw6WF9yO3v6O/v/523Z4OUZ7vM5n2ImtLYyCI/bQALRpKj3tmWaoyM
		jDlSfHyTySkp/7Gw02SBh97e8xEU7uqdV2R0rNbW/xcaHDA0XbW1tdCrxLS0yWtra3t7e+bm/0pK
		SlltlueXTvbku4GB/+vDp//suNLW6FJhtZSc2JSUlLC+3bC+/9/j6Pf3/4KLvBo4aeqORb/H16Wl
		pTFKe1NTac7O7MzM/zY48e7u7vXKRq2UP6izw4+P/4+aznggPK2traGv3i4yORAxY6KujnKDpEZG
		/9bn/0VZn3SPgBsf5eq3OK627svd9gQEHNi9xOzWzXKMxYykdfS+L+bm8Gpzgisy1L6+zRUya0JC
		QoSEhOZwJMXF+W9v/7Gx/1paWv/UI0Zdg4iVqjJWuLK8oVh1x/3FKHh6teOvjaZdhbE/TP///2Fz
		QBwcP1xylH6S18PJ3JOguFJpjtTV3ylFciY5a+bm5uysclld6MDIsp2q7O7x+FxxOGJxtA4PETMz
		Mw0rY2yFz8bG/3aJpwgI/rfM1Kqqw+fb59Xd7DpIuKO110dHW8bX8MfL732NqqnHXLm88BQU/zFH
		jEVSupSva2JreVBov+bm95aWqqOw/4WhaD9FTsbGxiEh/+WtUbG52OvNw9bW1uejacmsT4Sce5Wh
		/1ZWfmt8qQ4qcjNKdjMz/5Ce7yAgJDExR+nGtNLN2Oze3rI6QIOczWZm/wAaUpelgb29/5Op1Rs1
		fs7O+Mjc+Ku1zuyyfUxkjd/d5wgoXN61pSI6gllhbmJzljA8xHJ8i87f/zk5St/x/7BifBgyZGhx
		x7W+zp2swnKDrI6k0L3M/3Nzc6W07VtqtbvM7FBknczMzHKF10VlvyH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDoxNToxNlo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wMlQyMDozMDozMlo8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQABwD/ACwAAAAAWALIAAAI/wBZCRxIcB7BgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsWPHREdA
		TBOGSYDJkyhTqlzJsqXLlzBjypxJs6bNmBJy6tzJs6fPn0CDCh1KtKjRo0iTKl3KtKnTp1CjSp26
		kx0FCi4k3NwKU4PXr2DDih1LtqxZsQboCNhQ5qzbt3C9pl1b5pfdu3h/bdjLt6/fv4ADCx5MuLDh
		w4gTK17MuLHjx5AjS55MuXKLFmvFYZLCtXPLfRpOiB5NurTp06hTqyZtrYxaOho6rZ5Nu3ZrteE0
		6GnEu7dvz8CDCx9OvLjx48iTK18+vIULYVy0Mr8J+kSK69hTlM7Ovbv37+C7n/+4LQB2AvCjw2e3
		rl779/GuBeTe7bv+yXb425ncoF9Auw1r9eefgCvlR+BN/73E33ThhFNTgyYlSJyEKuEnE4QvYTiT
		hi3hN8t0IIYookotYMIFCCBEN+JM1XnXzxAwIsNeewmo04A6MrZ3whCqNPAeeeaBB2M/GLSXAjJG
		ItOJd/Dhplt9vMnB236YuOACJuFsIAUme2HSAh1bAhgOJliytEGVLtDj4EsUorRBIlIAaKYxXBYo
		J1cbOLiBOImsGdOe9Ojn5Z0ncUjToCqFkwg9aikoDj2EJkoPJo3++Wik8q35pgstYLrip6B6Rk86
		aYAgDKehwtQid51soo46mbT/gsGsRV5HK3aznkBOA+Qg04CPts6K66xjTNDACbWuB6QG53WHQSKV
		RDuEaL/WisEJDdRKjiQ+Ypvtddhi0EAmCRzLXZPyPVnfIYZIGeE0P6RRCj1uuPADfj+AUO+9G7Tw
		wzSdykdoO9NMI6+a/LXz4QZ00AFgO+wEulbDYsqCcH4DszONG/K1AyHEEjPssEkN6tlwoyLvJQ4f
		brSTSDr6pUyyx34K4AY7AGDiRimY6EdzZizLN4vHe0WIYcJ7zXtgOOKUksYsUIfzs38NbuAGL2m4
		UXQ4UNM8tAu8+Nzgh27i56Ab6VDgxtBjz0IPO27UWwoFUpSsqYezSJ0f2an2/x1qC3yUSgEf4vj9
		0qrZJZCJJIxj0AmslSyZAuSSq4MEOYg0UMkQmURuHeWiqYOINUNMIIkfmCQL7rLNZodBLRH82skQ
		GCBDDjmqOI7JEIj0WAsM0Z4wBiKIREAsIon4cUUm5AyjOrrzQcmuu/6BgEkV07jwTiIg4Cfvld23
		44I77iSCH0kCEkxPFT8k4gYmwlAQaAtpUOAfJgD8MEY7LbgjzFob4AK94JcGYQQsQi7IWjhkIQsQ
		uA9/PxAH/9whC6jNgoFccIMU3JGGRDSMfhRoQTvSAIB0bA9mWjKVBRnowErJLQ10mAaj6MCONPQs
		HCAAAC/c4A4p8CERieACfv/4MI2euSx+4ohhImQhgTu5gQ/CSEOgZiGMBlKKDljjwiye6I53sCMd
		PBTHE9PABf+ArR10CFwZ7yS+KPbsasJwAxbJCLUfAIBlPyiFC1rGCxni5zl0oyJ00lFBvhnukMyB
		3zRSRA9EugRx2EkAIvwwBOepYxgJsIaNLpnJTY7hRbtCRCas4YdKFCkBnbzRGKxRC0zUokYJmNHq
		4hMk7mAAEbHUzgkSgARrWAMTuYtHIjQBTElaox8p6ISSVPFJdWiCHonIxCdziR3oqcs302tEhNKQ
		L1n4h3vew1oC28FDBsbRbU28DzdTZLNEAIBTI5SF/9zgLz745yppcEfL2vf/DhcAIBGl+EX6EuiG
		cPxAGLzQVz39U0BTFbQU7khiC7iXNTqkgR1cEGNCjXEzfeGQC2mQxUNlQSqOmeRmwjgVCOgFUEMA
		QIzpAAFHuSALMmJle6XgQyk4irNErGUaOSNQO1JEATDOohRc4ILa3MYFAIzhHXzoojhAgDU6zAIA
		7mDHFnmhNgFgVat8e2JOSyEBOHKMHk0VI0jLeoA0lNUFY5XAO3hRikTMYh+lYEdeSyGOmjnyr8Wp
		oTASgRnArgSS1+kENNRRiVrwig2JUEUNJEEOyEp2XDLqRCYwu0tyzAoTkc1cJmSEgXnUIBE/oiWz
		nDXKGSXAsxgo3QkyMash/6gDA7RFljVUgYkajMEPxsLWaGU5SyfRB5vt0mb1eNFIqYFzqNAEgNpa
		AALypaFTBUXJUPnQXPGl4R38qavGWibDgsZLGOloWBH7+d0iDlSB0+BT1trxA3oZtIBhC0d5tcRA
		fW6gFGMQR1mt8g6IZe2/mOCDvjYwDQkQ9CQ3cwcdSgFgLwJAGBGFahfpkIgfpONEZSXiVekBVWGA
		l8Gl2GGhxDEN8rmjji1ghz7DwYd0RJCLWjNVHMPxnB+UlRdxpEOPJeCnMbbAqXMNMi9sLIW5yuId
		cIQyqY4sjncQErz+MsY0tNxXw3rZMzkxyaSk8+WUIDYFiuPWr8gBuwgMgf9XbX4zORKAgdeOi86d
		yFwtEhGBROxqzrVFHjWVpdrW4WqUueqEnRtgW12Jpli6ylY/JkAPepDjt6ZD1mivdS7yRG9d7TrE
		uxIBXjNOAz/TcF+p+jmNd7zjB3tE331+gIlSi29j8nEnz6QmDP25IRFpSIML8EVqF4Dg1ea7Dzs8
		Wl9jt6zXYgS2sBtGa/xgwmnXdRlQxXhtLnixov6cF7XF8eCTBq6fAJhf/GTRgveVAmbteHc+tUY/
		AHCBDmNc2yxoHd81XY0CUBZ3KXyotg2gKHtzVVs7dNqzDWDNx1fzL6l8XGS9vhvf6fAvivjpTl5Y
		OY4bkEAO04s2kLcAwPr/i6Bfy8xyl8TYHelo+WdC0x1JWmsCQyBlIhqAc53znB5ZqAQ0JFE8P4zB
		RpsjZQ1+7gfeTuBxOSL0a1bbHWRMwA+ow8QJKoF1IJ4AEcQyJdcp6cwEVCICmswCJiJQC3oMYdDa
		8fQ1e3OIA4hBGfsZwwH7NYa96F0tfZdC3zeg9w3QI50nKfx+JND3CNFDgmsRwKDaMalOEb5TjL/8
		nUI+eHpcZvD7mHzl9+J5MT1ewPx5PG4qTQcJiONhj++P512/edq3Q++zoEOJGh+OSpO+X68vT4my
		pKXgC6CRpd+PFILvebftg/b92gyjlm81PgDA8luSgsOor6XNVMpmGSfy/164XyLB54n11Bc+lvZi
		jNcDyPN6b77M57+SiTaQqvRXyZk78QtZTuBVkvN/6rAkJzABmTAMEeABvxAt6gAuApgIomGAyIAM
		sdMPxtNpheYdtYMESFAL18JLHeg4/XcCFugBvKQOJ+AHmfAq/dAA88Bm12KA/SBL1nRcdCcGhmAI
		hUIoeUIyANKDPVgeADIyKEGE+1EzDXMS/CEnUiMnI9ODRniEJmFVebMfEiI1ZGOEJcOEfuIxa9GF
		fkKFfhWERMgfYDiFUaOECrMwYZh7hkSGUCOGVgghQMgFcDOHUhggfiU+LAM1mTKHa+KFGsIffqgh
		VnWIhpR/84dWpXIqhf+liCZxZimgOinwK8dCLb8yGplYJOKSiZj4K9fhiUWCLOLBOsQFLpaIiqA4
		ieAyiqDYiZfoLaFoLlKXLjZId4cgapC4i/NnIVshNbwYjMVhDFhTXexAZry4DwgABp3QjM74jNAY
		jdI4jdRYjc0IBtYwFxuAAAlgjd74jd+IjdqIAGFQjuZ4jmEgjOq4juzYjsKRCO5gMLxQOOyYiIbF
		N/aYKvhIGO7Yj/74jwApAFhDEhZUkAZ5kAiZkAq5kAzZkA75kBAZkRI5kRRZkRYUkBiZkRrpZWF2
		fIlgBY4QkiI5kiRZkiZ5kiiZkiq5kizZki75kjAZkzI5k46wkTZ5kzj/CSISAEX2JAAtgANAGZRC
		OZREWZRGeZRImZRKuZRM2ZRO+ZRQGZVSGZQ5WZVWeZVb4RzxeFGvwDhe+ZVgGZZiOZZkWZZmeZZo
		mZZquZZs2ZZu+ZZhiZVyOZd0aRIlciKm8gtVAJd82Zd++ZeAGZiC+ZZ1WZiGuZHiQCqm4gJdOZiO
		+ZiQGZmSKZiHWZmW2Y41ZDB8cAmT2Zme+ZmgOZmXOZqkqYggxQVjEJqquZqs2ZpnWZqwGZuOJAGF
		RSai4Jq4mZu66Zmy2Zu+OSLiAGTsIACz4Au7eZzImZx9+ZvM2ZzGEWMUUF0uoAPKWZ3WeZ1kaZHa
		uZ3c2Z3e+Z3gGZ7i/zme5FmeDml/KCILqYmd7Nme1WkF8Bmf8jmf9Fmf9nmf+Jmf+rmf/Nmf/vmf
		ABqgAjqgBFqgBnqgCKqf6hCP8ugE7vmgEJqbe1AOFFqhFnqhGJqhGrqhHNqhHvqhH2oNTrAHJFqi
		JnqiKJqiKrqiLNqiLvqiMBqjMjqjNFqjNnqjODqhgRCdgBAICRChQBqkqlkbRFqkRnqkSEoaGFAC
		miCkTvqkygkGI0ABRYAMUHqlWOqXHmAkXNqlXvqlYBoesdWkWVqmZuqYHgAGHiAJHlACw3CmcBqn
		Y7mlYVqndnqndTqmcrqnfHqWyFAEhnAGfTqocUqneHqoiJqouDIEZP9KqI4qp51AA4BgCgcQBI96
		qVBqqIq6qZzqpXqKqaCaqWcQEqaAD1Yaqqj6oJraqazaqs7CqKkaq+7pAcMwAqZAqZYqq7p6nUna
		q776q0a6pI26q8Sqm52wo6ZwBBcABsXarLuZBTUQrdI6rdRardZ6rdiardq6rdzarVTgrODKmglg
		CD36o+F6rqspDqewruzaru76rvAar/I6r/Rar/Zar+bACXuArvz6mGm6pmBQAv3QrwTrmfNwBQh7
		BfGwsAubsA77sBAbsRI7sRRbsRZ7sRCrBpzQCQXbsXDpAf1ABIZQAh5bspF5sAkbD2qwsmqQseZw
		BWrwshg7szRbszb/i7Aay7Emu7NmmQCBMKkjy7NC+5coewWnEAHI0A8UeAoOqwbQgASn8LQxaw4L
		aw7mELMta7XxcLNc27UTm7NDG7aMAwYXAAggAAhFYK5iu7ZrWbSn4Aec6Acyi7DmMAFUEAPqsAcQ
		kAkTAAOb0DmbUAmbcAp8uwkt67WI67Vgy7Ym26aGgCKGMLCMO7loWbRq0GdAFAGHS7eVsAeVAHSI
		oAmJMA+ZIAqY8EzzELqnO7eJ27o0u7iUS7AJUAQUkKxasKaxm7tjWbTmMLANIAn9wLrmoA5UcFpB
		lwWhmwlZQA6XwLxIsAdsgAlM67rUi7Gwq7vn2g8HcAQ0oLPY+71e/2m5tTAG5FsLm3sFdasJMVAJ
		mlADl0AmSHAJmXAJvVQDmpAJmXC+1bu/EXu94Kur/yoJnVACp/q//1u06Gu1VguxMFAD8dDAp1AD
		5KAGMLAFFQzBW5AJMLC1/NvBGbuxBgzAJTACIyC5IRzCCFyxKquwLbuyf/AHLLuyMHsKf+DBNty0
		IHzCqPqntVvCOozCDBvEQizEL1zERnzESJzESrzETFzDCDvEUBzFUZzDP/yoKSCppgAINKC2Vfy9
		89DEYBzGYjzGZFzGR+y/YOkBa+oBnfACfpkAb4qcL4C7jDMMdLyWCeDGaWnHYokMepyWqBSYcwwK
		d8yWHnAGBwACpf9awF0MvkogB3KgDBwwyZRcyZY8ycGQyZq8yZzcyZ78yaC8yZc8yqRcypbMAuVQ
		lqCQByywCGtAAHRcyLFMlsOwBl8JCtywxmE5y7isy3NqlrE8ClwszGzqlWpszIXMOCbAAl85y4yD
		u6Pgvc/sAaCwCM/8zCwgzV+5zNdszLucxt7sAdGcy8Xczd5szpKADERwq5XayCfcBLmoB7Ywz/Rc
		z7YQAvicz/m8Avzcz/78zwAd0AId0Ppc0PZ80Aid0PQcDI1JlqDAzKBAANwwDCnADSYACnXMAhNd
		0dzwAi+wBi9gAi/ADYxTzS+g0SM9Ci+wCCZgAh7AymsABtyQy4v/wA0PPQkrPdMewAJrYAI17QEs
		7dKMw9M+TdM6XdOT0AnZnM0EkAJB7QFrANJeuQgsgAwP3dGdwMokzThZ7dIa7dIJkAcuTQAJwAI7
		DQZRbdWLENaLsKYvMAogzQ158AJZnQcJUNNsjbth7dWt/NSMswbcsAY7HdgeQACdwA0poNGCHdWC
		zaaKDdWEzQIpMAkhEQXM6s4h3ARRUtAFHdC78NmgHdqiPdqkXdqmLdoAzdn6rNAKjcpmSdWSsAh5
		MAwsENHcHNuzXdsSnQcPDQprANu4vcq9zcyTsAiTkAAEAApOvQbCbNi4LQlJTdYE8ALTLd3GrbM4
		Xd3I3QnSzd3I//3d1j0JiW3NjJMA3KDRNb3K6Z0HXhnV0dzUTe3K753YayDZrSwJgD0Mzs04BIDf
		v80NrlzTLB3R3uvenTAJFF3c4s2m4i3dKdDdDk7WCs6sHtDgyD3Z1E3bF7AMbhkFJMuaRXDZYqkF
		R5DMa3nMjHMBHy6WKM6mLV7OamziTooPI4CWHlAEoXnjX6nZjSAHqo3PAH3aQp4HQl7kQv7PPx4C
		rH3Qrl2Wi9DfVP3Q+u3RjBPlLDDlczwKi9AJKl3ltf3lD13Yi6DcSS0Jo4AM0v0CKVDfhU3d4A3e
		Y54CjHPc0o3cbq7deI7cYw4GYKDRf50Hsh3ogA7ozMw4zf3mdP+eAJNAzSBgy32+CLD91nJe4Wse
		2P8d1ZE+CpMuzMe96GYOCqBA4dl94Ipe6p2u6AcO6mvc6Qd+AdMwAiwAy2xZAoEwzaEZCB9uClz8
		lSVABCLuljSQxYFA4SbeCeQKCBcgCcEOCIBwBh6gBa8uCQdAAcxuwl8JBgfAOCWAD4xTBFpgnTRg
		2Wn565756zzu4/vMz3AAB/6cB3mwAqNN5LuQCZ/t7vK+DMuwC3Ag76Jt7/7+7wDP76SN5Jy95PXc
		5GS50pKw0ncN1WvNOCuNDG392z+6BnJu8RC/CBIv8VDt0WtAyBhfy7kc0soN0iM98Wu+5mDw0YT8
		1ykv2CffACL/7wEfzQ1oTfMfD9RrYK5obdMvAAorDdkYXdKAjdZrTqtFL9gpQMyunAI/nwC//buS
		4NudENUpANUxPQygAPWLIPW+bQI3P/VrwMdTb9MNYPFo//JH79t8DNVrPgwHUDAjsAhaUARFsKYl
		0AlFQLJ2X+uMEwghbgim4O398KP9YPcDO4FnUASSe/h7/5VRUAQ0AAZF4PeSAPiWj/kJQKlFAPcB
		a6UE7JUHYAo0MIFaQAOSUPchDryAjwxB0PlgSQTfTgTJPgxW6vhvmgA+rOySIPuMAwg/egQcCwg6
		OwIr7pWdAAhsSgNEYKW0D7x2H8deWQLRn87IcAaor/rkrvo//2oN1a/4F9APx1oCJcCsQXDZnZCs
		ya79kpD3gZCrbGqpeW/3Xgn4cv6nsJ8Arp//JJsAJHvjAFHkgiQPw5AJJBhEkiQaRZo0aiRnxUSK
		KzJl2gUnRx5yFuBoXJYj07JdIi0sW5YHTp4cOTrmWJmjEkqZKfPcxJlT586bu3z+9FkxxFCiIWwd
		RZoUKYtyC50+hRpV6lSqVa1exZpV61aoLxZxBRsWa4JAFEwdiVIiShEtWohIGjGNRj9JbddKKhIo
		ChFDgNKOONNvRJQoI/qV+EGjcD/Bbeku7PQjCo3BgYrg1WtZEr4obalQGGztgCRDA0s7HUHhwpkf
		gbRc4FwY7v+BvUUKl3hK5IKHEVpIa7E2ePGZEQs9LNTtwQOgBJKONH++MMhoqCkASQJzACG+M8h6
		u8XtFFlbIsOGtX6Nr+2ITk6jqL9AZZjwEeZbnykitx8gZJJM9ZfEOkPOuIAIwkbwID8ahnEKDBD8
		o2AyfCQJRC8iiDtwmH4SK2yY6SQ5YzQi2rLNg1IM5MyDBwOhQQsl9NBDoop2WQEmODy6aKRcWsoE
		jkxEcqmSSjgC0gJy4CAHyB89IicPlJ6EMkqbeMIJqKAmKooopba0hSmxvgQzTDHHJLPMsMDQAhAQ
		KCjijIVGCISxHyQhggbx+gnCFEkoOK6TMyaEq4Qz3oIriBL/DHnzjBIMa8+pTo4giIJI9zzOA0kP
		COIxfBSSBJBOPDBkr+OkmzDERBeSlAiFLqRzIKeKAAEQU3xTNYji6FS0OGTUpBAEU0Bg0DnomgPx
		Vqi0KIIKzi5Y1IMgjmDMr6c8YOyAM4ahjogi5CQWs8e0uFU9bBfCJ5CFEqgziqfYgsu3ThM09ykw
		rjsiPD0pSEGSTrRAdDMt+qGOs82iMAQMFRkLBFJTwJCkhNGuoyCwF2OcyEobc9jlxxxWIGeXSjYm
		5+NdQt6I5BVEvghjkjmSsmWXUeLJShqxzJLLpLw0M2edd+a5ZzDnM8UUQ4IIglB8KDDEEHNZrSvp
		A67zdCG3/5AjmtBarfYtiKTD0xfSR7t2rr1OroPLEDtHXOgIKpyjoV+p35qaTnchVU9uu51Cu9PN
		DL21VmOv2zQBQxqNLjpJtJYK2QPaA6TthqdJGp9GJUkAn6RBKGHRhYpA2pAiGniqbSISsJXcXMl1
		Nzu9nsJnoNbTTtDdBultbl5hpQtXi/nIHahOSD2A3BAiSlgOd72POMKQieWQeeQkS0bSJZbIQQIJ
		OPh5IwNY+ohjhx1WAb8A8ccnv/xVvN8hjj7W0YUfdl6GciegKMrSKJu7bMpn/ffnv/8xtUCeFmhA
		NATxhlPq6s1CTHEcMEiKOR7QSwFHQEDlTLB07XIKvxwlqf9OcNCByPBAAq4zKj0lx1JrOxSApFYc
		cCFnN8VDWwITiJoXXudCzeKNFsCgKuXYcCDIMAQVLNUfCoCwE4ZpmJ0cVafjOMwaICJUEILVNNQd
		CjnuusDk8KY7Qyjnhv3SjXEK1K1WDayHHnidvD6IHUlBC4IX6KIHRjQMMKoLGdbCDtkSoAVLSQdR
		bWzPxJTxk5x85ElwCImN1LGO7q2ifI+EZCQlKb5VqG8dT0Cky3TyE/rVzGY4818oRTnK/oGBYZJA
		RgnaEwjiRQEQ+ADDCAABCIUEglOPmmVxcBkED7hSL7x0pV+cFa9ADEOEgBjBKQNUnBQwU5dHmGV7
		iDBL3PD/BhD4aZSenhIEc3HTONMEBG5sSaFacmohF6AANcnpgQvMMgqVkmU4GcIpZATiDKYoTjyZ
		QyqoDNAp/WLnLAOhzIDKyhr9uAxBwHmGUdVlljRQTjsb54ESJJQGblrIuELnJjmq86JQiSWdalcc
		MEDzDGCQKEQrupCPwiVfktgPIAbHm4WslKTQVIIc5DDIXeSkZYuMgyMhCb44qA8WunjCE9TxPphJ
		CQ4TmEAPnqCLdXCvkZGsJCzUkcn4VelKK/Akl0BJSrKW1axh8UCIiKDFs/aMBvFqa1x3hkbZyXUr
		Od0pTqTEDl0E9ZE7WJ/74DdYwqKEHU+o6vfMFwddMPVJ/14NSv0+mT+7VtayoaToCIJGBGVetkzm
		9GxouUJR0WLlGDpVxk2gxFe/jg+wT3BsYam0k8Ku9gl9UCwlGRtbyII1rDejbGmFO1yuHERWR7hA
		Z4m7XOY2V392iEQk4HGLfFRXGl8QagFw8QVChMK71QUveOcwXvKWt7y3QG96zbte8oY3vN4NhTS0
		EQ1cjG8VbZCGe/ex333Mwr+zeEWABSxgemiiKpXaykmrkkXnNvhLYIgCBWJFAzI62MIXxjBWhBBd
		SHRgCsBog1BXEY0lMAMYJz7xFFS84il0wMUvhvE9ZDxjGtf4HjDGsYdZrGIUo5gZhIhGdkWQ4inQ
		uB1Hdv9DkpWs5HfEwsBUQYYpXHUcODYUOw0qxRQXYjB+8aZ2DcpwmGtqCF8hESolcJXPiqBcnaGZ
		KmBIKM/gvDN8GGsqw1CXU/AMFWZJpc9YCQRbG4zcqGw4EpCYAjOIIT5ciIAMzIB0j4Gx4xbn+MU2
		xnSNLf1iSksaGJBmBhlEINQbMGPFMw7Hkdux5CW/QxxPpsoPSIfMQf3gDIY4AGfqDIZA4OMHyDgC
		sBPQkAscYRq26gQNdn2EXYsZw648wG6kohwysXIq1BYTqKhi5ahweyFuE4shQHflnAUiuVbRAnWc
		wu0RpPkp7a6KP/1TYbAgtKz18bahIaFo8bUB1J5GMYv/Y3zpTB/ZyAa38aZ3LGlQg7oN4iu1ijsw
		Y1Wzmsmvtso0EnABax0hCNf5wQUS8GtgTSPK/QAByvthcoZA6gcrR8Y0UB7zxzibuaZcyGG08IMi
		XKai20Ilg4ZhDXY9BRnIwA9djq4FdSHrMp0AgXZw0/N4KUSVllGuKvNS004UIQUJYhcNeH4ZhAI9
		AUI/SF2d1bCu+/wH2mpPz30DBoP4vOfBQmh33l6EVC7EMgnVepz/7u269NwDYDBFtJ1Sgv4wvmGk
		K0IQisCgBFSz55s5Q0M6yx3NS83wiD9CERZ1kDgbp+6uavtACnKQA4CALf2gQucLv+aGUWGcg3/K
		BXqe/68SkKWWl9fzNMozjK43pwj6fvgqtAFqaehDHsCwxIcrHYp83KMME5cxGtqRDzSEIxwyRvg9
		rGCF78vYCmwg/z28n2kZT6EHnJ70h1H8hIaPugBtkDiqkWxxN7ga1tMuhX5opzS5JxOhix8oAZnD
		nJdbQJTrPc4xQMyROZl7OZtbLpRitoxaDRCIgoHoh/X4wOIoBdtIo4VgDcUwjCBIDKaLDc5CpihA
		qM64ixKahgu4gGR6imlAC80AAbRAF8JonSDgQGYZEXDph1uThFLQtTzTFz3pwcnYFhDQC3QhkXdS
		QjtaDw0ZjJ6jAL3oB0nJCyiUhFgRQ3xoEWnjMwPZi/95GRDUQCAE0gJkAAEU9JDRGAwawEMQsEH2
		cIpA0MMbZCc15KzkgcGnkZBpuUKBQRNksULOIIIIkbwaBEQtUA9wSRC5GIYiOEMrK4H1uMQFYZH0
		cAqU2xZAiJDKiQJ9cyQRaLg3sARUQAV00AdpwANSyAd+qAErkIEOsAJngAIgqAdvuIU5YIPxqgcN
		8IJ2GD82QIB2kDEuQIDxU0Y2uAU0GMbxQgMZcAQr6ABy4MUeCIUpWABSkAZgkIcnyIVPAzUR0K78
		k7FUWzX+87+q8I5MgUGI4o5AaA7JeyfJS6aK+kfXoII2CbSKeqdkKQJ6s8DLOpSgSSjicI51Y4x6
		CYL/CeGTYnkKDSoUKyINTpGUTVGgTAmCadCbOkGVFCCdIEgAaJkUQKCLDjLB4oCUuoCWL1SUt6AA
		hkEcyIAaBvEAPTkCBko5hBqNnDSOiSSgLTsABoKYU3KgYNGToak5qJghMMQo4wiVnhOVD5EbzZEU
		fSmXhdgncokXQJAjdzFLexJLe5GXhWkY6mAMx3HLEjCaskQjfJATePm2wIiKTmAMENDLPQkMxHiK
		A8gXefpJSdA38Xk0UHsCefAHZsgFf4A+R+iBHkACGUACDUCCMsiHGkAAZ7CCCSgDzrQCNFA/BIAq
		K5CC71OHI1MHDZgA1SyDerDNeoACaNAAdbAB0eyB/zLghw6whHNEhSfwhzdoOGZYAvFxR/XbP4ub
		x4WUzpzph6NJPEqUmgmZSWTgCzLDE+18m4wElBEogaK5IrG8Gwo4AENIIBvCqKC8NUM4lHwZm7AB
		m7p4i5kUwsgBg0GJSPx0FHoRGwHFjuApj5I6F8shs2HQHLFcm/pUmwAh0PqkE6Vhs7w5ggaom6dA
		izojGIzEPM0hm7sxHH+BnTQKShStnRHNI+Npm754C7K5oA0NyrJImssoQb4YKD0bgR79gQZACOdY
		z9NwimC7HdtRxQJgxYazhMd8gm6QAX1wBAvAAxvwgkzgxQlAAySogPFTBzcIBzSoByvwAi/QAFWI
		hf9mMADXdEZ1qIcyqIBmuIdmoFMkuAckaAdH0FNHsAQv4IcoJYU3gExgQM6GezhcaE545L/+w7jp
		dNQw6YSyMIXG0YIG+MoCeRd2upUJ8s9LtTNL5I3y7JsaahXlCMqFUBdJqUoyeqBd2ZMBjagYVY64
		OQNrgMivbCHIkBQKeNA2MqLt5CNcBaNcoSh+MSJfDSGIaQ6YHBUKML7JMSFAaIAwegqHQQZs6Q8k
		xBUrMstkS6OxpJN3Wg40ElezTJHlqJ2v3DKz9IAW0ibE+Uqt8SJXMVcsIlfjQBUVgjfnuFf7lAQm
		7JT+4I888gDkKwDlAzV5kAcFsARSIAV54IcphQL/frACJMiHikUA23QGDbBNK6jNCShTBFCHRGgG
		Dfg+LlAFdYgFA0ACNmCDdjjG8buHTAiHbeyBie0BPuWHBXBFBVCAdFxH8RGBRH1OVovOR0VarniW
		NWkdIvCAI5IOOykBQAjKYDKFyrOTW/Emp1BBdxom44gnn5QlHYKmfSqOcXKppzBFqm2PEXipYcil
		44DboEwpijIXrYWrZoKL9gipFICmBLCGXOqEkCIIiaKAYQgoQ0gBvw2nCSmpaNpb7CgOfFCneVs3
		cMINeXs3griVEogXGiiBfjAXuPWUllorp0AndeooxJwmZFkbwjWOH8glhokpCshaMQIEgcCotVpd
		/zdpqSKo3G+aJT2JAox63IHFm+YYnZwDBH1jhhsQn2gANX+whE+jTGmwhF2UASgYrzJAzQ7wTBe7
		PgMoAxpDg/Kdg+zz3u87XxnDsTnogPHKhw6QgeibAiiwhHK0BEsANTJ4uAKIuBbTv3iEzkZN2gMG
		NKThmpy5wf1xSwTeJhy8MMTDMH1LtGgYH0cDOErDMfbzYEzbNE5bMYADBv+tLwAmMuyDRwI2WgOG
		4BfeslM6DMIjk05QoZ5BXBjOKDZrMC1rsA3DBnjogBPTBvu6geXzNEoTuBBm4iZWYvnrsR+7AaFq
		NBMj2qJtNRfW4aRNtiNQoi0G4zDuH+gKYh07sf8QM2IklrQnZmMmZuMnZjgRmOLxwQV/S+GDw+KL
		+79pU44+9uM/BuRAFuRBJuRCNuRDRuREVuRFJuT+PII1eScxluRJ1hlf0ARN6AJwAIdB4ORuKARC
		mGM6jgZtIIFC6IZT7gZOVuVVZuVWduVXXmVUJoH5OmFKugFCMOVU5mRN9oEKqABf8AVREGZhBmRJ
		8IM9hopfiIBlZuZmduZnhuZoluZppuZqtuZrxuZs1mZpZgdAmIZpSAO4ouRxJmexUAEjMIIK8AEf
		0GRW/mT6Mh9ciIY20AYyMGVYxud85uRCWAJtaIMbwIXsoqRowGVW1mRw8AEd0AFgHmZRGGRjRmb/
		eSln4joICQOEc5vojNZoq1ABYPYFhWbndm5lYKBlgSYfXMCFG5hnEdAGQlgCMiCBEysEVfbkQijh
		JSAEERCBNogGgA7oSEppbQAGXV7lg0bohPbohn7oY95oB2unWNHHppbqqV6IjgZmhdaBdeZlHyjT
		Vu6GWf7ngDbpSSJrrErpNiAEEiDqVjbqdVbopB5mQoZoqmauRzQzusbriVYBq75qrL6F/bWEWzho
		9CrTrh6EVJiDUCCBfm4DYrgBYkBpsQYfgZ5s8MEFx46GaGDpJRhqfR4Eoz5qrIbruF7qiM7rtjq8
		U8ocGj7t1tbhKhBmj+5rcMiHf6guwZ4DFOiF/1C4BX+QAS8IBUvg7d6WhkFgBM9GblgG7YNe54R+
		69EmZrlmaqt4qauglm4jiDCZypy57q1AhuqWyG6jC5zDNqlABjbrbqiwFcVz7fYeZ9geZtn2aH+o
		ABmQgQpABUvwh1tAhVDwh1D4h/r9bRlAARnwh01O7nxe7gVvbqxeaOiObuk2bRPswsG5Mg/IFy3g
		pQDpk4Wobjl0lQzf8K/bsgbAOexo1yAAA75VpupuJ+VQF5xjFjY7cVS6DCsDAUAJkBhmCC0zpafF
		DmW6gA8sl2ppoMFVFxp4i374YuxogK4L8n/Fs28mNPe2cjGG7/iWb1QwAhlAgwrw7S9HAR+wb/9/
		IHP7tgRGMPAFZ/M2d/OtbnAHl++GduhDnmuqoIHrKAXJA8ViIgILssEEOIOisbaFkDVCH4Y/Jxob
		7AQzTIHMMybbOIAROYMEyAs8IYJCvydE0UfFmI/v6CV2svRAsAZbaQukcw8KyMlBsTYBGo8g2I0L
		QAY83KNZhyh9MZcoiDsPoIEGKA0I6qUo6A8a6I8dUoxhk4QLWBA1+YFSQIsrh/Yw9gA6FwXZ5vLe
		TnP+RoP9RYU5oG80hwI1N/M3J/e2bu5zd245n3M6T+Q7n4oL0MMimpALYJABogtrUZULaAu8cAqN
		2/eLuvdBKQFAgfXXS/b+6Ay6aBE3SSjdoQ3/AnGNAeqPC+g1vpN1hrgAhTiAuioLEEAphbgMWLen
		8cBLz+0HMADdOIGMXLeNk4KoKBiG1Rj0Wf/Xl3yL1VAX/JCwWEGQaPd5He5jahfmhVaB/dIBIzD6
		OdiHCgAHpkdoNJgDOEf3qaf6qk93B3/udWd3RXZ3qYiCaRgGg7kMLTiDTijek8p3ZOiMqTOOUhiP
		zD2Dk5ogWTeXzDsDewqCWQ+CZNNws9edBEHVay0Fe7qoTlTxRCcONFHJhM+hbvkBzVKPkx+gFnEN
		ZOiH05U8zz0cfOiPSMV4uqgcXoMLzqgQWBpyXE+BAdJ3MvsBECCCG/752E/aPxZ6Opdvj9YB/1/W
		fV/G+t73/d///duHcNJe5K6PihJQorXrJX3k9bxvETAI3X1cCO7M+/7gJVuadR1SCAhrEV7PohZB
		3LdKgX5IgAbgFGOqi3eajASAIIVwf+x4K7pj/xIAA3OakJgnf4ri/kxJgBQwFyYHiDMehiGjIVCS
		pCjWhnVCOKxIpxKSghQZ5rAEDQ+SwBwJJLBEAgrTDvRDaPIkypQqV7Js6fIlzJgyZ9KsafMmzpw6
		d/Jc6eEn0KCihhIl6uso0qRKlzJt6nRp0ahBp1Kt+lOSH009t3LtmrIfspcRZYJFCKaEBzAaPZSQ
		6PUt3Lhy59Kta3erVQ9R94p66vcv4KN8i//mLRwUq9a7ihe/TVDE0BnGkidTrmz5cs4s0DZz7gxt
		C+jQokeTLm36NOrUoD2zbu26YcszDK2xTAAbp4eSKZHdVpnbpQdktln+voksRVcwFwCZOhAEM/To
		0qdT5ypODfbs2rdjP+X9O/jw4seTL2+eO/r06tWY49Q7pRYatg0GASOpk8aNneyrRbgfpQf4mbUW
		fh7gg9J+/f2nUkNgvBdgWkWAMSEYDWxk3wUlOHihSb1BOKB/gVgkSVr3IZQCcv6dmOKEFk5IohZH
		gGAKEWFVdyOOOeoo3TxX+HhFPEEG+SORRRp5JJJJKrkkk00aqYZ7LY2AjxYlXEDECEEEcUH/FJ3g
		E8UF/RQRSCAJaBGIITYilMAFF3hJZidsXsBmEMgE0Y8WGd6Z53MmaZFAECWcUVAUbEqihXBt0tnP
		BUUUcSgNw4wwghZnOBaINUEQEYhbkiDTZidE0CDfBYEcEJYHI4zKKaTInLGpRfH141gRhY6qBSA/
		/AACEfnt+CuwwQq7VY9OsufjKUQe66SR5pijBpPPLikts0pC+R5Kf55xhhZ3SnKAFkSUcGC35MYn
		yRmdSmJmluQypEWWUYBRBA1g0KCFJBlGoYWv69Jr7zCB9OPBo1rMqoUhQWihRaxhbRlInQldEBYN
		Fzz36JoIB3HgBWfQcKhFnXwciCSPPpxh/8kTXVBxAvk2asg00wAyArbD2nwzzjkXe8UpY3TCWyvJ
		/qhGDROYcwUi8ThrDjTqOMsee0E6e4Wz21ySyTbQUj2BKjWwZ47U0i49AQxLP3302PFkMsbSYWtt
		bJQshVlpFNuCQcSWyJDc8cd83z1rg/gEkWXfQUCcJcmB4EtFngx3cq5uBmrRwKMlFFFCIJ2MgPng
		WzIcBVrxneFRECJ3K2c/85olOOEJBUFDJ4aU1EkRBHtg0L33WmPvGfveO8zrWhTB3BG65Xw88snr
		uPMpfqSQQAp+CO2jOZWIooo5mKihDhswYOIBOeo03fQmm6hSySnqqP9K+NCocUoi4tSAxP/2qpSv
		iv3bs4GIJPQgUgkbkICEpqVPFeSQBCYygT2uwQAa+NvE25h0rZbMxhpooUGd7gWG5xBEIsNIwDCw
		xCa3DIMGZfJgAvphwgRI5AIWWVknZrWyBIDhQA6hQgNKUBCBBOwCYChhmYYBllHVJwoG8YDihnG7
		QPwwAR7okyQwckJJMKSHDUILFsFgxDvhR0Nb9AARNnW7zSmvjGY8o2V2poYI/CIRiYhABM2BhFpo
		wnyZKAcmLjGBcsBAFOQoxx+RkAVVlAMRmhhkFqyBiSCdYg/kgAAE1KGJWsyjEuVIxDzIIYoawGAP
		E5iAKDCBiSxIMhNUqEElqDABNlxNE/H/U8crEpGFo8GtZjpJQN3Y0i/gBGGXJylLGZFxBFPgC43G
		PCYy5bIzcxivH7SknjoQoY5yfNKTqpBkDOiRhUxgoo6n1EQmNEGOGGhiD7WAAM+oUIltnEIVWTBk
		JbapCXOwYR4woAI0KqGJGLBhm1mYwD4bmc9/ZtIa6pgHEubJrAkm80YiY44h1NXQiVK0oi5RIxsi
		oFE2xFEdlTDHGDRjjUqQowbiJAcVtkHHbdAjj5vQBBK2Ic4x1OJZ5MhCAGtwCXokIp5IuAQM9AmN
		lqriEttARBboMQ+TsiETRM2CTulRi4NW4hLPlGDcXDILrXqFNyQynkmC41VP2dI4Zc2J/3IAAQIK
		4AOsFn0rXCu6M6qZzUgwgAF2oHGKTSCCZ9CowRUgGNggIWITp4AGDOIBDSDVQGrQ6OteEaEGGGyC
		sjAo7CniUdhN+BWzfL2CGjZ7WEScwrKbiMdCs7oSUegAD5IYiiTQIAVRVMEXVaiCDUShkdpWASG+
		EMVrfYGQvoRVQBvJTydYNa/+nKQTUQiZiO5jH4R8qEP+IZCJVBSp+zQgBZnTD4PMcpv3DA4EIDjA
		iOKq3vUic64LBS124BvfeGgtvvbNztDuKyQhxVe+PsIvdoIEYDXsN4JYPesrspEN10rBGwLAwwJa
		4AsoeMMXC1CwL3RAYR3EAgpSeIU9vP/RAhDbA7jrApWo5HMmkpDIEKPC5aEEJZsV48liJvmUm0hU
		qhKcST6qMmE/XiUwhp3hAt06QqSiALqThEtEyHCUqzbllgSYYhrmpRl7s6zlMs5jv17+MpjDLOYx
		k7nMZj5zgVWbEm9s1R6SaIEBbNCCrXI4wjaQRCwkHIsIGyAWsbVBLLIxC0GbhF0UOdS5ArURc32s
		Uh3zGLqsxK9CI2x2j3pyvnonCZJV7Dn0odTmLiAJEwrvJDSQCJgohrJAfIoGIADEASKz5VnT2mbu
		rRauc63rXSdJzSiJhRRmgYcW2EMK2ZDCbG0ghWFnQxQiPjYeZiGKWAD72FJ4sw22WsP/zn2sbrAz
		hEVqKDLDac5zHotdPx73sUUPLtwQwdy4A2G7e4HEyBvLW+aMeIbn6IYGqbtXndqUboj0Y3BqqjXC
		E44jD1Ch4Q5/OMQjLvGJU7ziFr84xi++h1YkZiV7sIEN0KCDBdujtQZoAR7w4AQbLKDky1a5PfAg
		gJFHG+UVdsgKPRjDQOR41IobCM9BmO5+8LwTMzSJFGGDuRR6hC05HMgFRsDEoR8R3jN0jEO6uMQf
		Du4IFvGlwsMu9rFfJistQYM30h5itae97Wv3xtvXbg+5r/3a1BnGdF8CTJUkIBAUMIXsyC74wU/G
		MIY/POITr/jFTwUxhJ+Jvf4OiCK0/+zxlr88XAwTVsYjvgENmIpaOC96qzjeJsORiZ2+mhKxesit
		Lxmr3i11epuMlS2GuLLrMa/73d/EMLEowyuo63kLkWj4wwcKdX9y/OGbhAp7OIkHumD80VNfI2aH
		SXUdpJECZc6XBSJCSZa7S6PHpxPEh814v7sh8D5XugixmH2MGyq8Gxl24DULdeWP3Ip4Ch+maM5B
		8J4ADiBNFAawOYE9vEIXeMArvMIelIEUNEALABsY7IETeB4VQCBQwFksSKABUIEUlIEo4AEptMAD
		SoEHOAEI2gMVVN/old5KDAoXcUmogEnBtUkJINmcBMHXlQroHMFzeICLyUcUxNi20P9AR+RHt2xK
		nwwDIIgImXzQmODJMOSJWxjC5vRYQwwDEGoJEiZZFARZliAEjoXKi5XKqUzEAZzXwRGgG76hb+SF
		a0mCFAQangXasrVAhMGZAUhfA4iCFMgZifQCsbUAI0ygNyCgN5QBFSgbHkiBPezZyn2eCzIeDDLI
		mHiAoRXM4IRLCRQh7WTERhRMkVEXox1Kke1bEeJSkXVLymxEt5WE7oxauhiZEobFo6CMvSREt4ga
		qQHcjWlMLnqMBzDMumgJHCajMkKfHFoItWUDnknBAhhANnSBm0kCHtgAJVLbAlybB0BjHbrZyUlC
		NuSZJPRCLNhAF3iDOWpjJVri9bH/RBGImuDgzd5QBL7hh+KYBUREgeGsTryVm5GNTifEUD/sixJh
		zLwYXRCwoqUgJOOsm8XQjsiETO0AXOasjGy40OpwW0KcwQjAjKwtI0kqY2E4gYLFggek3SFSmzeM
		nEZQG4l4QCTigQSQSMtlA0o2wMpF4srVoQEYgA54A7I1gDu+o+JdokrMChXlnCT0AxUUBL8QnQdw
		pEP8HBTdCtDNST8MHRM5BFNCUcA4V/dFwdSxiXxQ16kR3UE4nRB1wliuTAowJUJIEQsdChGAwA9Q
		QO6VpF/uXmE0AIfZwB54wCWE3iW8QgOEXiJSomE6AVDgQRfgkFo0wCtcggdY5isY/6ZiUkhaIOXi
		KeVOoEUygYHfmQIg2N9fruYAGp4kOGBmUqLnBcUeOGZsAoUozCZQ6OZs6iZoip5ojt0TyYgp4EMb
		siZyXt7h2eZvNuc7BudcjBXsyYQ1zF5YpRdXIEMJjMD/HYBEJSd4Pp5zjid5VgV0qsT6GRd/mJ8k
		eFeD9MaGgIFjOFcJwMb6bYRJrB8YWIOE9B1sWAwVdN91NRdypYWAIkh+2EsgHMER+FB4PqhylqeE
		kud5ossLEQoYFFkUUIGoYIS8PGVqBgzEkGHFDMMnIhkNqIoOVUzBQQaJZojeRGEUIJl9YCFIvlie
		dAmJ/JiZtEkQHIGSJYClnAGevP/YCGhkERwnhC6p2E2okzZnhaJMpHCKB4CLuDxKwIzI7eRLSWBM
		o5zJvomajd1LEZyJKyJEFJTpvZSEvYkaQiCKJJBLJ45A+BFBvsyplawLPuBDINSLvOHD3xndujEp
		oZLdkx7qc8ajSlTKMBhCFF2O4EwMyTyquxmdpUzqmQRKpeTbMDQA7gQKyrwpBvGYllAJQVpIx1DB
		o/hjpDYE7bhOpOoNfpSp4oCBIcDMNFBAihQqrzZpYWwe9Q3FbjKn8u2BbhkGcworUlaoBygZSByR
		CvGLROxQfpSQoFZeVcKONcQQBjUEWsAQXeqYfNzOc22rCtnH7RgjQ6hQW+ocuw7/BA00wMB0ZSDo
		pSlEgZL2qr5ume8Bn/BNn/H5ZvLRZMMRnwPOpK9QQTYUJthRlxOgxCtQQVgR3wsqqpYVo1pNXuXt
		K8fWWmEYgBQgoAJq5gl6wARKARhQwQU2QAai4E/YgPNlYAvYACm4rAf8ni9AmG69AiTuwR4AW8u+
		giLYwx70bMO1ADsyoAYCp8WyV6OaV+B1rNTSWmHggYXUITQ+47JJYwvAmTf4ISAKIk0+ozHsAdzp
		gEY0mCLag0YYwAIg4J59HNyqHB6WoxQcYrFlgzG0INN2nE4MRFcUB2643nQmBCAcwaRNreJebF5o
		YzRCI8guQKB1ATRi41EGZTeS/0gkSsEegKwUtACJSMI46u1N4lkXkKM5MlgsuNmeURu1sa4EmG0H
		9q1L/EfKXteLSJeBbITEdox9tCCBqsjtwp8kAC9sSGzwmsjw1kfxbh9CIG97IgcNzYuWQO/iXq96
		nWRKrqQ3HKIUBKXCxqSf/URN3iRNIhsf/uRP9CSy2d2eESWyScIi6qQBlAGx9SGysW7Xph2xIl6F
		PhnoROHGjArspFgC0EBBZAiWCAqXtEyqjEoNimgJLLCGmsngYJBJ/FgEk8kEi0sFb4uo9EmVyAgg
		/Oh3Yi8KV1RgUkE6FmYXHOtkLuZPNCZQdAFk/gRRKGBmNqDyUcECIt/q3nAN4/9Q9DHcAhKFXoiC
		Dles36ZEmCSELP5JQwbBGRTMwghPppaEldYpKuaiLA7Kt3iivW0aK5LiqlIMGINLqNkYxuBDrpiC
		16Ww2N0WHdexHd8xHudxHnus5r1CZQ5rUFRIUPjmICufbSZrZk4FbyqfVfRv4lVopViDQeCSwVSy
		x1CBP9YNxAiKFtzNljRIEVABBpFMpThkqOQNQhLMfvKnKP9jxyBD3ZzBKU9MKidpEcTMNMyJHFuU
		HveyL/8yMAfzHiMTohYz9THrvihHvfAGMyPDAVRdVRbK7dRJLpEIkn0EiRgRfmAQLPMQU7qFB1wz
		W2Qz7NyODuWSEFFBqDBHcfb/5S4fjzDHszzPMz33cvIYMz7DYxPXxAkTRz/LxDjTRA7OCBFEQCUc
		NEIntEIvNEM3tEM/NERHtERPNEVXtEVfNEZndEMLEEd3tEd/NEiHtEiPNEmXtEmfNEqXtEav9EMj
		bD6/tOY17TEFQnMEQcbdNMRVAj3gNE/3tE//NFAHtVBP3CUgQlCXA1IntVI3IFM3tVM/NVRHtVRP
		NVVXtVVbtVJn9VBvNcW5NEx/NVVUKPJcBRVpyFywgR+8M3oiAU3Us1u/NVzHNVxPB1jXdVjLdPIo
		xzMrRj2pdUrsAVu/hFwHswoUtmEfNmIntmIvNmM39mIPNjBjhuYN7OhNCCBT/0UDGGtahB4jd95m
		MzEaPdEamsKg1kVf+/VJADZLQLYdO7ZrvzZsx7ZsIzZr0zFlGEb9Bl/xAWzAIh/CsiAOIcTB+nbx
		LiwD6jaJnK5v/GsDnG4DTmxvUvZd7/Px9IP/gcARjKRdnDZqI8QeZAJKQPZsjzd5l7d5P/ZgL8bH
		hmwCXgJPNlwZGIPJUqDKYuDSfqMDvoL9kqDN/t4e6OxxI+2HDW3RlsEesDDnaqB+S4EiiBgYLLjJ
		Jq0T3Ld54rXNJBdzpGbe3QV3d/d3I0Rcn7eIjziJm3dc20XVXq0dau0j7qEBfK3nhS3ojm2glS3c
		FSYdJuLatS3XsiMevELdxv9t2EqATsbCj+ctAhoisRH53v6qhQtLjKwV5U1Gh6M2YNdziWe5lm+5
		bLs1XRSG41ab6Erj5FZuNlIi5nrj5nYu+obu6BqD+67uHWat5FIb6LJjN0IjGNzZM94h7Hbu7JLe
		k4cuod8IEQCeO5v2PBTedu0EDeADtja6XLTJTQDKTnx3PHO5po+4E7iAJsR2p396Yf8CYmtCK4w3
		PceF9pZjAxiAPXgv+GaD+M6kNxjAI2pu+7Kj+qagDUBg/EYj7P7e/XZB/NqD204gBLq6PSC7TmZt
		CzSYNziy9VG3SVzAAeTLEZCIA4/XdJ2VV5C1ljQshy86TlwABSBdEcYEGAD/AMbkhCGUwhlMlwew
		u0oAgnbbBK4gRMzYBJmoyobLBB1fuS9v+msbgcEfPMIbAWLzgTA0PBeU98EPQR1EQMIjfGJnwcSr
		wC/8giz8wqmrADu4QDq4gBOUtzy/RWDugTHYgA7wJAxT5gxfIFA4gRDnMGRqZg8LMQ4r608soMpO
		Bc2v7/oybBfUploMxSvofIVTO5qe+4z2AyBcQIAQwRGkQBHgAwhcygF4O0+IzAG4KXRUOU0QQSkA
		QkNE3VM2RLo9ZW6EBUhsBABAxsYKSuUNTAK04TAQqaeUwjTgHdK1TD/Q/UQAgHNsRLhvREmsvZYY
		T96jxREAgKX0w4jkvW4g/0Pep1fe98m6A8A/r3YdC/wdE3xhVzzpl77pU0IdXMIlTEM66IAR6EAr
		tILr64Af6IAvzIPt4/7ta5TrS3wrvH7su74RXALvGzzsu0Ad/L4RuEMd8ALC10HGi3g8B67mUcEf
		G3IgH3L/OrK072ZnX7ZsXnYhOznTGy629wMFPAc+0EAp9MM0UJn7B8I00IaqR3nU17ZOiP1MUAoA
		7M2B9D9ASAJQRCCFET+KHCg1zAMAUweHSRoBAmJDCgB+SNIoKUqpEQAunCnlMYFGMAMFUlwYyCER
		KhQOHKAAZhiAIwCISCpSpNQFjh5HFLk4ooSpaT8/+gQBIClHpkQ8SLoAiP8CDTAbsWbdWIVr1yp7
		MnnlqoJsWbNn0aI1spZtW7dv4cZtS43S2kt1Wr1yJ0sWNSd+6gy5KzjwXb5+swTWsbfvJSND+HDx
		u1gWF7xGIkjmNW/tL2HU2L1KO5o0WbGnu2pVvVq1B9evYceWPZt2bdu3cefGLcmPJtZSQSQoAkhS
		v1LIppX40c9UEBDWTEU5Q+V39dVeh41IA+KAH9TfwYcXa10jm3nkWY8IEgUElTP4BNKIL/BAwyMC
		CQKIgn8+APgADgiiH6xKMUUSEDICwcCNGgpEoP38my8IABJABoB+LCyihAQ8GGGEUo4qUKN+aABA
		IxBAkEREBA800JSMfjj/aqMSzgikn6jI+06HsMYqzUcV5ApSyCHdomutIerw464udCisjiwSG6IL
		Jy9pkrB57qqyjggwS0cWKpts5bFLuLjEMSNaaYUPP3R468fSxEsNvep0q9POO/HMEzbefGPNgyho
		CKSTBKLQwoNhAikCjBI+SoDEM3CcU6vvrBEqDWGiEMWrN+GM87TVzJNUK/UkUei9/uTT70GBHASg
		1VanAQSQMxoAQL6sFGxRVwZdZdXXXktwSNZO+gEAGY1eTGAaA1HcqAgAompW2hSnlQQMCkDwiUH0
		wtuxCk7PIlLccYU00ojB7sIysC4oYUeYV2RhhxIonSTMXnS3bKXeu8Rc/+uVt9okElyz4hR1NT0R
		TljhO/k0OCsqLjDUYazCEyUKYS4NRJOBOU6r4I1CnViiMySZ8IBWIXz1V5T5UxWMIBrUasWjcuVV
		5V5tlSTYkoZJoKaIVGQ2xR8W1OLZE4dmNkFqU9SoxEi57TYTcMmt2mq4zE2Hki7mqeMSJ7Y0woU6
		2BGb7MfqwOEutdPO8hUw2/b67X6vlmtg8URmcOG9+e674bwBF68sHdKhhpcsOBWy47PCC3niEUiW
		pCb5aADhplQxn68Uy00pqfIjDrix16yUO+KHiGrWKGacHaz8ADAMoeAIIjr5WaPSS6FA5x+OOKKE
		Tkw5IghADCz9hxIkMf/FRQPxOQKEW+eMUwd+fKzb6gqwz1777bnP3p06+NraiFeacccdLpwwgp06
		2KqDjwpwiJvtVnRohprzXyH/frzq359u6+32po9NrG8FNGCe/gY4h33nLL7whQp80YohANB6PjqN
		4xzmmo2AAUeD4qC1ovJBEQ4qUh40CdQ2mICrWGuFGwzhCzUyKI0kgEMmwQoYVIgjHJZEEh7IoQ5V
		aJKrgOEqg+qEqDw1vdFQ8C3dc+IToZi9LphJB9ozk/ackD0nVLECWewi9rqQvSuK8RJhxJ6ZvOhE
		JrblR3gjoG30VqcG6IaIr2nAHG9DBdzcMTZ7YFhvFIhE1KDFGuzgApf/xBVFKFZtNF0xD1cCGUlJ
		TpKSOQKPWZRoFgoqkpMV8EIhSLAEQmhDBG1oQzSicQNiEAMXrVzFK2H5ygLMkpa0jGUsW4mLVRLj
		BtEwpQhEQIglkAAYqfBBJ6MIwDaC5421MUAZXqG6O07TA9OkpgdasBFrXtMD9qACdTTyij1gxY7T
		NIAUNKg6rYiTnF2wJo7gCMhKXuc0adFBIj4jC0QaAZn9RGZc0sIGY3hlngU16EGjd0lMUg9I1/Nn
		9j5JBkKUMpWsxEUtMZpRjW6Uox316Ctb2cs2BJMMhTDmQytwtU59J4POlMAr7PGKFjTACa+gQhli
		gc1YSGEPVHBCA16h/wh7SAEMVOhp/nD6mmyI8xVlkAIeSNGCpqLTNU5w6isU0ALXSMAbOeUqFWJR
		hj1AVapO9UBNw6rHsO4Bj7JJIELriZYIcoES1GgGDlCa1366qSzOEMenEBpYwRo0PGh5BT+IlFcf
		dIMM2jglMVbh0VmCVJciHWkwhbkEMhCzEN1IxWdT4YVjds8LoE1FIVBLAhKQQZSjLOUpo7FKV0p2
		Fbr0pTaWUIjR+lNgjWSpwWyDhwZIQgqxyIYkYmHcp0pgAS1ogTe88VMwLECm0IWuE5ZqDwn00B7J
		zYYxfAHdPdjAGHp0jQ1gGgs8mLcXtLBHCxghgFgYwAn2EC8eniqF7v/iAaZSsEEX4tmngxGRwAU2
		8IEJvAcFL3gPOnDwgx3chVbYjxpASET3fJBhDW+Ywx328Ic/vEi3+NU04xnsiVGcNwam5bBxQWk3
		liCCaLSyo7UlBipFgFsSFMILevVxPz8ZSlK2QZWz3ahtcatb3gbJY7+VlG1sEJWdHvecCzBuF7Jx
		RzzYAI820MiWbcBlPBA3Ftzd6R7OGYtsvsIABpijKMZsjFjY483HTa49JOGNbGZDzZLoxZW7mk0u
		S2GpbY3NW7XyiwgsmtGNdvSjIe1oDUxaA7WgKyUocdcKgJjTnfb0pzPcPbY4wxhlAWyKUZ3q36w4
		LRVAbFuATAJtzHj/o7XtpQiG2eMfi/pqu3ZiN0gwUSLTOKO1jYY2SKDrTgIULcx8cm2wy+cGGMAe
		zZVCm3WQDSmX2TXPBIMUWiAFKeS5DIX2gDfELYWuOsEG4oYuHr1RbpjikRHyxjO7r4rf+RqACuiW
		QgO8aQBzzwbRWUGhwcSiybaQCQjqaDMUIB5xiU+c4hW3+MUxbvE2b9wA/HBELMQR8pDPg+QlN/nJ
		UZ5yla+c5S13+cthHnOZt1zkNRe5ARBgAY7vnOcGgII/vgDZYuvyC5/wBxR6nnSlL53pTXf606H+
		808EHReRxegqbtCGo0Od5zav+cxN3sPaNGAP/tUBTUVRVSo0IO3n/35FW53Qdtg4ga2uEcXdX+GE
		an7Tp7GhO9tfY4O/p70BfS+8Hgd/d9eA4e+1KbgkE04Wtmz6mLRAgAZIkXlS6IPznfc855+gi3X0
		oQ9xiMMOUL+DW67+lanfgelJvw5dPOHztee85nFPilzwowfO8P3v2RB84Q+f+MU3/vGRn3zlL5/5
		zXf+85H/e+n/vgfVz0X1sZ99zetjHXGwei1X8fp1PCH75Tf/+dGffvWvn/3td3/7SfGE7qu+2HFY
		hz5I8f7pTx/6wxc7HKmAg2CDj14DDAzN0MrJNt5pAGcDARuQNhzw0OSpkiJP8oxAAiIDATbMCziw
		AzuQsRzrBqpOsv9IsMZwIeu0oaRCywM7kMMWQApSai1MjaBUrQZVbZDCxS34wYl8gAzaYARriRhE
		gAxSAaXW6AiR0C30CsZEQOhqCRdEgAR2i9fYotlOjTwOKAu1MMDmqQLXogtcAAiAQBY0kAVLCxgI
		Iba+7+oqC5VGShsyS7NUaw7JgLUIwbVMqaKAsNiIoQ0IwaTMULRIwQCyRwZLTE5sMBEFCwcVri26
		YAe1xwt88KJoCReigRC6YQr/KQk5sRNhLa+6IQ0pcbLagASeyC0YBzXmZAtZsRWjYgInqSvujix8
		oQIiQBYoAQjuygNTAQ1pDaNsK5hIoBsCsRiN0RiBbaLUcA0LYBX/LhEQO5AUoGC3DFEFaFARsZGw
		4qosmogWFAB7vIAEftCWnpHDlswT0REd/YnDCkEbiAH82qAQqNAIrNDEsNAV8dGAHi9wuuIX0mCL
		eMF+KEEWkKADU4EEmhAYj20Yj9EDQY3DGvIDyUDGRnGWcEEbeMwL9GEaQy0GZxCSsjEkKWkbuXHy
		sMcbfWAJboAcl8CYQmzZ0hEVF6ehYtIkO+nDUoEQVpKWooEMlA172IhgrpBO8rEo92YfHQYZKMAQ
		NIUrIkAYhEFeME0WcKADl+AdK/EZjfEhudLDjrEQluAXZ4kYlmAjObAjqxERRXItVYwkaZKfsocW
		1oESsa4lPQ0m/ztxJgdGHW+y07yAELCyAG5gCaYwKD9SLYnSKBVTT5DSYKIAACikH+cBF6lBFiaA
		A2FsFKGQBEDLDLtSE7mnK83QtBByFFfhE1YQLenRGkGSLV1zgdzyEyugEHZyFdoAGB4SL9dIL3nz
		LdeoLz+NBKLB6qKhGwqxCoXSHhPzAfkoAu/EjxYTgWARcDphBGiAK0TBF1xgCJBkAjIsHHeyAKJh
		GLvBsz7LIT3M13jww1gQtMqTsaKBJ4HhLI+pCq/xNfHTkjYlB+GyAsiAEuOxK3WTiXrTLB5oL6vG
		FeQCOEGtENrAIk0xBqvxEO/zN2xjpvKnAbRqI8RNddLpQ7eJpv/gKY6i0/GmM5AOhRfS4RcuAXu+
		kxAiyzaB4T27YQ5CAbTQ4BY6TD2hCB0swEUh0iA/i0aBzfuacQm84BYmrQuMQAeGIALO4AyKKEqP
		aFGiVEoloROoND/ZMjZhbQnGch027PImDQcyjNI0jNK25xKmsErgwhWSwXrGgQkGZk7N4ho8oRM6
		4Q7K4g6uQQWO4Rhc4RiqIVCrQUFd4Q7Y4g6qoRreYg8eIQl8wcU6yQmcIMPO4RzAodP+swBwIUIN
		k0JbczllY8yyAc/wwAPWyr9iCo/Wqqly6tp4yqf0DrpEIazerkS5cJLKoQjcIQ24wA/g0gfCcSzJ
		gEi74QkY4LP/boEB8MAcRazXtKcMykB7grS0hpRIn+ATLgoX/KEZwLUZuiACQCAdzDUBrIEIPMQl
		zmAaPGQEHMUQ1vVYuDQkvZQtCuGibiAfFGDDJiBcKcEHrCBca8EH2CBcLwx79MWMKmBh44IHrMcT
		6BRc7LQsJFYFHkEQykIQPEEFeAALrmEcPEEQkiEZrsEIMnYtfIFjJdYtjsETggSZ7GAGNGwGusDT
		aHOWjDNUWbNC/aQ2oisbssEJ1Kzd2o2/ooy4bECr8AsPmMtMrisbrq0L7EFqhUtXTVTAFMgDLkAY
		QMAd2MEa1sJFU2EliaGzkFUfvgG0nNUH0MACLMARMswCvMH3/3yg91JKCuDWEdxCby3ACvip+nbQ
		CJzBAvgBEh3BCioAHBSgcTOMFN7gDRRgEFLhFhRAF3SBRp/AEoDhHXegGTKMC1ohAnihZ6MAPiSC
		RnJiI2hIIwxBC+rVXivQAtniQW/gs/q1w9RBA3wACDa1d31AAzOMErCHdIHAjEjXHZiULXwhGXiA
		B5LACJr3effACMaheq/Xeo2ACZjAefnUTpngeSe2GsSXLML3Y4+hT/NUBUR2HDDWEzr2GNyXLHjg
		QO/AE17WCFwBYo0AC9wiCbAAYsmXB87BCO7gHB7hEaohCZKgGs5hBs4Be2YWgn1gBrBgBj7AB+wg
		gz2tGyJLBP8kdDUPc1QtlDYkAb4slRGcQAqsbKeyKVVdg9CcwMqyAcu0jMu6K5sMwMq8AWuzFkVL
		wBBQxBD8wAIpDxhmiTzTlgEgzhIYwAZ8gAEWoFmrlQHQwQCeIRcMgAHKwAgYoB5oAQI0gC10AAIU
		91+M4PKeAbHQIRdoAR3eoALauAJyIRd8AI7vOBduAY5ToY1rVHMtgbFm6Q0m7XCywB2gMhDAQAtQ
		lyiUUlYU+XbeA2hiVxHvdS1eiQx8ACU57BZkYRB693eBIMNoodLUAX5OmQuwRxzeR5XbIhkE9Q4g
		lgdiGWJheX/vYH+tF2SvAWLHoRru9xrwdGLJ4pfvwGSHuSz/qqFj2ZcJkkAFkoAJOnaZy4IH/lQF
		mOARjMCa9wALqoEJ/LctutcVqiEZXMEVPgCYBeFQP+AR0PkcNOEDIjh7HsEOZrYLbraCQQ1McSGE
		U9FnD8Y2tM0DtA2mDMC5FqC77ojNhnbfqEDbkOvfYsoGhsoeDto5sbYx0QMZ8IECgkcLNMWIMwxM
		CwBZ31MfGKDznjiKofiJK4CLX7qLGWCMxdgIzHjy+CEXxtgIrAAdnOEb3sAIcsEChPpHh5qO0cER
		stgHcuENvKCOU0EevkEetDWQPbgA3gBc+eBMyCIdaKSRI0cjRgB2JSEQgoKHKjkRL9kIZkm0OHnD
		msEKMswR/8J1lH1ACsBVAyog03gh01rBrvq6GfaJBxR0D2a5sCG2eefUE37Zeh11mx37ZYuZTu9g
		HMYBCwKVmStWBai5mbP5EaSZs5nZY/90D6LXgOMUC+AXf9timY3AtY0gnY/hA9ZCnivAtm3bGj7g
		A7DAnjnYB7qAZj+tEJrRn5MTMX9WN8hO7zwg7wqw8QYvNkTh8CRhD5jbhwnuRA0mCA4AEGigE7rC
		iDeNBJLYpLtBbc9zpbk4ihV3pl96jGfaprv4ptsiFr6hB4xgjYtaqIO6junYqLUYDdCAqZ26qT8r
		FGABHQBZkLE6dH8hpbq6BBhZrCEFRyAnnV43rS15dn1zlv80+a0zzACaQUfPVAPUYZRpQcOIFwcS
		IRGowQUkQAJ+4Rde3BjYIgmq1xWiF8elN3pdwRMS2LKZwHqHHLJ/WbLZF5g9oVFpGckvliw6+5f3
		QBCu4X4BdbStGYIC+GPHAbINmH/XwrXLubYLlbZjO4Jx+xysYQbsmc1ndsOE29MIwVONe4SrAD2w
		O8/dSrvvMSoSYEM0Irwlz0W94B1vYEaRVVmZtW2/QQGggIl9YBsUV9IrIAYA9xv4AQEYAAHawgCM
		4b6NgB+uOIuFWovvuwK+IRdcDR3QAArkOtW9INVTQQZkIMEBmQQuKg6aYdKawRiGgBcWzRD6gVGi
		VNiHgQj/ir0fjr3YkUfDbXCtH/RsQRwckMA7NQwBEAAJdBQJaqHSmkF7qIFhKyDc2+IDmIB8/XdO
		vxlmtzcZfKF7J7Vl+9cIJPZ+GxV/jzlQeUDJv3mdy+Jl90AFLjbgy5l9sSDgVQBkodlPhRnIvbka
		Eri14/QYkqFRPyBQ4/TMbxvN1dzNIXjNhcAOfEC3h/uiQJhnh5I1QnTlWb7lXf7lYT7mZT7mNXo1
		smME6JViBH1YfQDXjxRZLUEeQIsUBnwQOA8KFrcHYNAZlt4Ykr4HOH3ynKEHAHctHKH3OD0X0IHq
		sccKqrUCHCHzMmzLvAAP8CCqn+AJ0LY8t5USSUADwLVf/1rBXEuAK4LAQ4Dm7kcg7/He2dWaw90i
		XwuAGPh1w2iBDTYMHMCVxH0gXLcnEcQ9EdKnLRJYB45hLRJYm9diUPX38g1YQV9bBfxUBUJ2HPiU
		9C37elG/GoTZLOx09MliD/g0gRG+GqC8Lfz0s4ucLTjfCK4hgRW19++gHCrAGojfGjShAjQh83Vg
		5OW5gn+X0wSfGHYWOe0cCxEs+7V/+7m/+73/+8G/wERhCLSWPJBBKB4CrbeiRxqK8rxgCYhTicuz
		M+kTWnl099ZzA4U0FYiUDHbAWAHCixcfPioYMaJCRZWFkho6fAgxosSJFCtavIgxo0aKCztWSQjy
		oMgKJP9WFcC1jqDKlSxZVngJM2ZMkdV4ePKULBkPmzd37tTJA2jOn0GB3vTk82jSnj55YMFStKlO
		pkGJ+syZTGnTqkWHcsWabIbYsR/Kkv0wA8uHliyX4CpQgMRLkQhBKvRYBeM8GHz7+v0LOLDgwYQL
		Gz6MuJNGMFEAmQJEQ7HEjiFfEvRSKBrcVdGWdOuWKnQqgQLZEpSJOrXq0zFNkxYo+nO3JTfgFogG
		rHRBgyA7bvwNPLjw4cDxLrSrgu5LMm9vFzINXTVqkTpcWb+OPbv269e6e/8OPrz48eS3mz+vvZz6
		9eU0uX+vqYv8+dCBaS5ATK5BkciN5704jxoCDkhggQb/HohgggouyGCDDXIimUUeBHEECKYQgUxF
		lCV0UAWXeZHKEsTYtkobZIj2mm7QRZfaiq6lGBsZbTRXwA6fhFbaXHX5RlyPPv4IJEfGIafcS920
		YVs0ZLi4knQy0QVllFJOiVyVVl6JpZVTbsllh07CxKRKZIwIVxvdwERXf8bpdUWbV8RDoJtyzkln
		nXbeieedasy5Z55+tqkGhBf1M4IpIBwQxEUbcmiEhz6QNtsNJm12gza5pZhimJq+iClsJBASDY23
		kaEPFCru1xtDQa7Kaqsa+UfkSDDRsk5tcOFCSDdMfjlTl75ymWWwWf5K7JS8WuZiN4SQWcAN+unI
		n11r/7Lp5l/xzBmPOebIqca2f17R7bdumrPnKd7OCUM86l6brrh4BhohRVocccQFYGDkUUiNOvoo
		aYUsa9utN7RBSCGdHjzQpgjDCAwhbdwg6io3FCxQqU3ylpBHrm7McceSwGpXkRXQogBJthYgca4s
		Hltsyy6/DDOxxyLL1r+SJgnMdNGmildG87h5yhAndHLCEOeCCw0mE2irbQ1skKvtFUxnu2235jgN
		9bZMh2s1oLXUYA45qphL7hXbqHPJNuRuM8ElW0ttzrVu/kF33XbfLahEHnjQEDIlJLBRvoyC+SGk
		S4Qa8Ga4DKzNEoWMtnDkCKdSCBnaPIzLpAHj0oZnKf+SgsZuqGbMo8emn04cyCEXyQ9MhcxIIjEi
		kJAwazPvF3Puuu++5e00P0qCCMRojosIz+l8UJX++Qz0EAlYk8AQp2ALxgSbJJLIJph4kEkNtbCh
		BhuqqALDBBOogUgi6tDDfQ2JsHEKG2xMQA78iNQygbqngGGNOVS8Yg5VJKIGapjAPLIAjQnUQB0T
		0IQ52PC1eIxvE326gjvMgME/XNAMfzADEDzoQRjEqyETOsAIFHMJJKhwhSxsoQtXyI8YylABNKyh
		DWkIi3XEYQeaS9xmdgDEOAgxDn0oYh/WgcQkGnGIOwTiKnqYuFXsIA7r0MUNbZgLCyhAhjJ8oRe/
		CMb/MIpxjGQsoxnPaEYuqpEf6ODHDWERhx5KsQ+wuCIN14jHPOpxj3zsox//CMg+2lEBsOgDDwO2
		ijjU0YZ9RKMLfwYoemBikvSoYJvMoQlyVKIcbMiCOl4RD00kQhTk0MQ8JoAI9iHCGmxImibi4YQJ
		lAMRVMDEKxIxS2skgnvbSsQlMEGPeWRCE6rIwjDZMA91WEMdmqiEMZ1Aj0uQQxTQkFubzPAAIDjA
		DNsMgDu6OYABwAsi/SCCKS7UiT2oc53sbCc7qQDPeL5inq+YDy3uec9b6HOf/NTnHKRxuWgMD4o+
		LKhBDboKXESjDdogwxz6CdF96qMM+KSFE+g5z3hS/8GdHO2oRz8K0pCKdKQkLWlHNYpSjL7CCSyd
		Txek8IaKVvQW0hDBzWLHUGncQqY87WlPXQrUoAp1qEQtqlGP2gWfKrWnoQBV5hApO50ulRbzYelF
		VfoKlMIzpJCUmjUc0o+jSe0ViEDCJTJxiUpoIgZ7wEQttpBJtqo1E+UgxzZUsVYw1EATw0SEJvxK
		jle4lYBXwF8yszCBLJRSHYr1pDGz4Ex17EEdY1PmFio4AA9m1gEX1OYAAjAAIIyzIZ0IhGMAEYV7
		pU5wjNrX71QSOcqRYAnaEEEb2hCNG9yAGLjorW9/S4zgRmO4bRBB40jQDcmxBSY9MMDOeoa66Er3
		N//++UisDgKO1n3JC2QQHhRXQQyGkkB0vusV787rsvKCqWFtGF4UbzA7L/AqSspbHvMANYFE1EJ9
		llTDJqigikwIMwubSGEilAaDs25jkn9NBD0CfFYH7+USiMhChdOXCOtdKxHqUsc8NpEFetQCGiEW
		B4npMQYkzIPEqEzgJaBRQQd8MLSZdccztpnZZ8RDUB7QAiBAQIEiAO5HeFmdlwgHHckpecmvcRFq
		mlsX0pVuulSu8kSqWyWRdIEfR94uCS7n3sQtjqFkOJN6v4TeYp1ZOrMRgUAJmlCCHY9l9FXTtO57
		SaaJ9Qp82US11AADaJwCGhSEAaAIfYVBQ8McgR7/NLgMDelEb4GCcmLXKQItoEDD4NLQaNOmYUBA
		UIMLT0CoE7yGYQgQgMAQ/WBVkY3s2tZsata0Nk1qROIMcUhLY1buta8bUl3rVukVXBbZsXzwr/YS
		dDPEWGhDDbbmaEtbvV4ABm1xG2YfgpdgwCDvfKVkpWBvpKt/UsO6zo3udKt73eiuE7vfvS53uQle
		jTmCFvjWqiHBOtaoqbW/l+ukKOVaylP+tcGnG2wrEbt35fXCl9v71IMmlBgDEwEhyIBc+U5749Lx
		QTesXduH8XbZm2McCVKh3i6Fu7q/CZCDXg7zmMt85gM6BYT6UYIR5vvV++Y3x38ObpDk+s4HLzrC
		/7GMHGInx1drdjgh3Dzyg0axt8G9wUJFYFxCEGIJS8A4CQpRCNCIRnQ+EE0qugF2YJCADFzXem1t
		O1ze9pbkBcVFsy1+8mj/6kribvkm/g74wAt+8IQvvOEPj/jEK/7wlPgBJaChc46pruey+nl5t2Ql
		NhiD10bv/NEnrwId8ENfLYu2x0GOW4Fmju5Sb73rXz91ikfDuEvIu95dlqVg/2cjHgCD738P/OAL
		f/jEL77xj4/85BO/BKkGAT6+SmXQk/5XMXGEFFCjgTLcWkoGoAWUEBBlFfjCADxDpqo8j/7o6l7Y
		or9u7r7kAxkcKxXAYDshQq7b3cp97k984uv7//9EvhVcsnd12rB1ZABtTjIH8vBtxIIG3ldnWKJ7
		wtEAFWiBF4iBGaiBG8iBHeiBHwiCGOgByFAEFAACgHAB+GZlSIclv6IDEGAFUZJFv/IKGtADGqAB
		CWEMCIAECIAACeGDSBBNHoFMDzGC+OAQF0AvWkBCyICEDaGE9iYJ/UAvRwAI0DcCUph+W/gx61cF
		7QcSviALY6gDdMELTmAEOjCGslCGRtAF7NAKB6GGY/gKUuIDihBtjGAJvqOHMWEJKBB/GQATirCH
		/wALc8AI/6CIunALFSADgvgSivgP3nYLjIAG0AIz+2AJB7EP/4A7wrJ+w7E3o0iKpWiKp4iKqaj/
		iqvIiq1Yip1AA6dVBK3WEPMwD5rQEJqwBx5wCZIgCuIgDnkhCr04D7UojJewN8joi8CoWvMgDnvg
		EM7Yi11YBZcgDvOwEE4gDsaQEK9wCSrAjSogDgbgBMkhBa+gAudoBDjQBQcRCwggBUYgBfFoBAZg
		AN+YEFJwjyBhDBDwDXZRDzFADndRBTUQA4mAF0WYhBRAAQ2hBSOQAAlgCIlyAQzpkBApkUHgARHZ
		DweQc0UwDFwoksCme2CYELLgB5rgB7KQEL7ABz9Qh7IwBF0wD7JwELLwAxFwEO4wkzUJJWiABlCg
		CAeBBjKABpz4EvuQlCNTAUX5Eiggf+AgAzIA/w5JOZVVWQFSKQP/IH+WwQj5UAGokAGNuA8ZwAgV
		YAmeCA7goAhzQAseIpZzkJWKQAu38A9QggptaQTxR5VGUJW3MAc+UJTgQAtQAA4HQQtXaQR5iQZz
		YAQokA/CQpB9JxyqaIGuiJmpKAqZyZmpWAIVciHvcwXiIAkegD0wMAaS8HdgQwXQUAnkgAgekAUx
		wAbkQA6YgAixOZt7cAkxUA57AA2ZMAFsoAnqUAMTAAO4iATHSQ8PgQkwMD/icAlX4AxbwAZV4AwQ
		kAkxcAkK5AwJ5gvbkIPiqQLkiQRb4Aw5iA4WkBxWYAXf8IMa8A3OcAU/qAMaYAFCmBCXoArHif+N
		VSAOClQLTvAQCukQYHAEUPiEI3AGDYGgDREFC8qEFykJWmAK+IAPITmSW1iSmWAXwoCOOiAMCZEO
		rcAFaCgMaOgEwiASfPALB5EIZVgB1EAXMsAINzqUNnqjMmAEGXCYivCjYakIKMAI/lABUEkLRHqj
		t2AE+XCjKHBPSpoBR3kQNnoQKJCWRvAPUMAIRoAGXXoQ/wCBaNALPeqXd2kEQ0kX/5ABUKqkUDoH
		bWoJlgALjIAKqKAPKLAPRrCA8gCljGCWlpAQigCKE9gjqugE2eANonCZ+KaCDWEMLUBCHtAARniZ
		lTqPpdkAHpANF+ionZmZgWAKR3AGNVAJkgD/DYjgi8OJPpJQAzVwi/MQA5JABWyVNuLwCjEwBuXA
		VtawDVSQBdsABrN5L+2xDc0ZA5ggCckaEVeQCbn4NFWgCttQBbVgDuKQBa+wDQhQBTFgBVVgDpgg
		ChDwgxAwnjmYEFswkL7gDM7wB+wJA+RQBX9XBb7gBFYgAZewEFnFBlSgCQvhHqqwUQVajA+RAAkq
		CRewoA0qCQdLWvhAL0UgGWBwAIBzBvb2kCWwoRxaXTqQCcKGkuWQBSOaDr/gC+7gB2JYjisqErzw
		oiLhBLwQhyKBh2GapvsxlHPgDzKACpYgA5uICmCKh6gAlGCKpXTBCDLgpAeBCjxKlGDas2ep/4co
		4KVgqqXe5wOMcJg/WwEZ8A+KULMiMQdUa6WLKQP7oKYocJRNu5ibKBJIigIgUQH/kHuh6COqiAdg
		4AQ68AplEAseQAV+6wFSYA+vYI+xYANl8AoV6AQ2EAuP6wGN+7dOUAaMIAUt0AAslQ0eEAuKKwoG
		UAZUsKmgmoq+tzdBcAb3sgnPGpyuWgN7sLqo+qySEKy8uQ22y4vbkLsEqgraoqzBiosNoQY1kAkV
		RruIUAOv8BDQQA4O0buZQA4TIAmqoAYLIQrDW7wSAKCncAoe6gsQgAlVkAWv6gRVoK4FWQM6cL6I
		4KyIEL7BJgoR8agNYaAN4bAJu7D2i7BngP8PEUkEiSIJQTACUFgEDTECE7qx6Fdde/CxHbEHsiAM
		spAGKsAFEPwD7hABJ6oCKwoSLisSiSAMMysS/3CYWqqlh+kDdzm3Ucu2amuzRIuIVyp/lqALbDoH
		MWy2IvGlV4oG+8AAN9ylOxymEDilaECkabqWMkC1OhzEUNuYS8y2TasCTYuWNZwBD8UIYUi3K2e3
		d5uKnRsLDYAHUjDGg4sHLbAAXWAM5GgPeEAFNsA3jyvHUpANOuANdGzHdCwJc2wDUtDHNtAFpKuK
		F3AAgdB7uKgJ4/usseusqNq8sSsJsloFTmCrt5s2touLbLANCxbJbBXJtyoJw+oQ0AANDwH/A7M7
		D7VwCrU4vascyroayllQBfOwDRAgr+P6vua7BeYrr/FakIhQBae8EKTZI/Ubygh7AURgwBP6oJIQ
		BcosCQfcECCAb8m8zAnMhcbBwP7xCzRgF2yoAtTgC+JHDSDBBxGQEC7gAkZWs5YwlGE7lGiJCnNg
		Caiwp1D5wmiwtI9ZtAfhD/rcpT4wpSJRtlBZAfIADkubD0t8tUagxCiAAvKACrdQpk1a0U9btUwr
		A5WYEFLs0Y2ZxSpgCWjA0SBBqLvmhauiimAgCne8AJ3rBAYQCwtAuJJgAFJg0xIgCXC8xy1wuVIQ
		C9kgCUAt1N4Q1JJgD7Fg1C/tDQ1Ax04w/7qCvDdgQCEWQgOigAnMK0s1gASSsAVdTWBIcAXq4Kqz
		KwrqgLyqIJvCeslpQ6CwCw3QeNY1kD5tpdWa4AFIkAnQELwNQWCZMEx7UAO22Zy1EA8OkdXRi4tn
		DUu+aA7Nqdd8Xda0Cw1iDdbBmQlZ4CP1ewGA8ANHgAydUAT0Egj30tmfHdqjfQSlLQk0EAX4Jtqk
		rVrYnH54sQdI4BGiAME0IGwqIAvl6AfCINx+IH6yAAJpwAvhvIbJDRLg0Au9YAlZTAuM8NwQeAuo
		YATXfRAjfRBdagn5YASW8ARP4Lbi3QsZsKfi7Q/y4JgiMc/hTaV8it1sWsJnacIi4bP/8P/cgEgX
		150cUDDem+jfIo0GBC7SkSkDTwCo+6AC9vAEeKACeHALBJfSKv3FZZANryAFCOANOhALBoAHEtDU
		r2AD9uANmLu5Q90CK77iUoDhrxDUC+DT2SDjBvAK9mAPLUAFCJDhUS3Iw2BOJ4jAYLCLpck3e9MQ
		orAHm2nkD6FODuGoJNQQ5aAGteDk0OigS94Q6jS/vvjkW47lpfkQRB6/UA7lfMPlk5rkS45vSh7m
		xFG/YNAJYEAFRw5PBzrndV6ad+6gEAG4VEDbG+rADdwR6mEc45wQVgUSeztP4mdV5ZgQtIAG2ZAN
		QKnPlJ4N+WDpRlmUQDmVnl6UnD6nnI7/BnMKBZbus51u6YpgiZ++6UEJBZz+6aS+6aOu6ZaO66We
		6rnO65ZO6acOlNlgD2gwpV7IeRaeiq+wB5uq7Mxe53vTAOrk46jY7B7wCqN47dC+B4srCq8ABtPe
		mQkQCBTwGIGQIdElDokQ6BtjzOvu7kBy28a+KJJpFwsI0feO7/mu7/vO7/2e73fq7wEv8ANP8PmO
		B9kg7xwj1QvP8K04L0CGD+f+7hNPvwVL8Rc/HNss7/pG7x3v8R8P8iEv8ii98QXnKg2P8ilPiuZk
		CBqK8RPf7i8v8xbBwCRZ8hw/8jmv8zuf8zdvX6aj8kEvyKbrAWdwBl0+89gc80nP9E4+/7sO4fO6
		x/NTT/U9H/WUiTpCr/WYmQJRcACvjfRNn8DFJPZl7+enemVXv35Vz/ZTr/bG3mtbL/el62MneAHl
		YIt5r/d7z/d97/d/D/iBL/iDT/iFb/iDnwmJcPiLz/iN7/iPD/mRTw+I8PfAaPmXj/mZr/mbz/md
		7/mfD/qhL/qjH/qR3/hGPvepvzclUCggYG/jA/uxL/uzT/u1b/u3j/u5r/u7z/u9z/tc7fvBL/zD
		T/zFb/zHPwHQcPzjIz/N7/zPD/3yUw/TT/3Vb/3Xj/3Zr/3bz/3VH/3f//3LL/63j/qnOKm9h4oV
		CLgN4O2YyeVTrZmbeYoJUIKjGhlmT//xtTCN+G/2aD8cbw8QVQQOJFjQ4EGECRUuZNgQoSSIESVO
		pFjR4kWMEj1s5NjRm7cGIbN5qOjklSST2cCEbLCRJUmIMPfsiZkt5ssGkqRIkQQT4okLgEwBCpQg
		41GkSZUuZdrUaVM2855OpVrV6lWsEfcgyQrR4VewYcWOTdjV7MWOaSV9rOLNxgIPscpQoWIgGxU8
		+mI5wbNAyp5XXUI6KRPLgxR7Bg57+/vKRhcbiT0QNkxYX4ue9rJJyXbJ0DR3yM6OJl3abFTTqVWv
		prp1NVnYsWUfZJ06bUedLVp427PZhhQbsfD0juVNVDYDBpx8dNISj5TnC5ZLkG4gVrZ1ci2kM/79
		PNsexpJELXiF51U2Fy581mbfvjRq9/Hlm3Y9X9Js/LPtr77NMfdOSYJbIJZYAMwmFgkkOZAnG2xo
		yQNG5HLCJgLtkYRAm/aw4UIpBizDiQ3tkaIBZGQxhJz9UlSRKfhWdPHFi+qD8aL8HJpRvoAAADs=
		"""
		
	img_dict["note"] = """
		R0lGODlhEAAQANUAAGZmZouLbP/MAP/iROfnKP/yp//aJ///bYuLVL+/WP/jKufnfP/kU//5b//Z
		PP//mf//DbKyOf//Uv//ef//QP/6nP/QEfr6H319Xv/yuP//M///ZrKyZv/5iP/aNP/6Sf//J//P
		B//lOv//i//5YfT0OP//HefnPf/yq///XP//df/yv//eOv/mSv/lMf/8Tf//h//lV////wAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQyMTowMDoyOVo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwAy
		ACwAAAAAEAAQAAAGiUCZcChbrYhIpMORbGYslkwT6WEwPNMhKtTpWFBZmUEUWIgM2YJgA+CQvlOD
		QgJISFzoZCH0oWBOFC8hBUlyFBoIFxoUCnlaIS8UIBEQIBQSIWBDBi4phwQmiylnjw0bEhQlixIb
		KnAyHgMjKqd1rCojLVgZIRUPMBMHwgcTMA8VUQ4Cy8zNzQ5BADs=
		"""
		
	img_dict["note_h"] = """
		R0lGODlhEAAQANUAAAAAAP+ZAP/mp///DdfXGH9/Bv+zJ//6Z//6VT09B//HKtfXbP/3n//1Sf/F
		RP/ziCcnCH9/M+3tMP+jC//zYf/muP//M//3dZWVLv+zNP/HPP//J/+fB//IU/f3HP//QD09H///
		ef//Hf//XNfXLf+zPP/HNf/mq/+jD//mv///i///bf//mf/KTv/LV///Uv//Zv+gDv//df//h//L
		Ov/MM////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQyMDo1OTozOFo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA2
		ACwAAAAAEAAQAAAGikCbcGhLpYhIZKmUbFZQqEoTmel0MtPhafJ4oE5Zm0EDWmgMWUHgAIhQJuCm
		QfECYF41dFLAaXwgJB8NHAJJcx8WCR4WHwp6WhN+GwUDGx8IHHFCBiYjiAQijCM0j1sXMC8fEowv
		MBdfQhkOKjKodq0yKi1YFQEMLDMhK8MrITMsDFElAczNzs4lQQA7
		"""
		
	img_dict["note_d"] = """
		R0lGODlhEAAQANUAAH16VmZmZv3ACfzZm+6tQ+mvWOe5EPW1Kf/dALKcM+quUvTnB+2vSf/WAP/l
		AP/MAPK/M+ffEPG1SOfTEP/wAL+sKuiyW/3NBYt+Tv/enP/GAPC4ULKuM+exYfC+OvK0Rf/WCP/2
		AOqyU/rsA+uwUPzRDfO4MfzJDL21KYuHTv///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQyMDo1MTowN1o8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwAq
		ACwAAAAAEAAQAAAGiUCVcKgaDIhI5OeTbA4IhGOTKDkcJNPhgCEQMKTTjQljMG2yA8slkDiJwMiN
		pxGoNCDnZLqEAEwQIBZwQnIIDikjDggeeVoiJQ4OHCEhDoFwcg0OFBGUDneNAyQnmg4LFBSfJyRS
		EiYPDwgIASiKCA9XRVwaGg2+v7ACUR8MDAoFBR3KygUKzh9BADs=
		"""
		
	img_dict["note_32"] = """
		R0lGODlhIAAgAOYAAGZlEv7BADMzM8G+APnXh96TACgoKPruANaUAFlZWejPAF9dGvbfAKenBOio
		AN3JAG9tQ+bmAEtLS+WkEZCQCPf3APbUAEpJIczMAGVlW7+4ANybAH5+Ko2MDvjoAPjNAP//AGBe
		MDk5Od7eAGtrSoKBCuXYAM7AAN6lEPrWkOi1AIaGO+/uAHp2FdfWAFBPHf/3AO7WAE9PT//MAN61
		ANaaAOatAKGhDf/eADg4K4qKHUNDQ+DUAPrFAP/WAP/mAOWqD9XEAJ6eEfvVj8W+AP/WlO7oAO/P
		AP/vAOXeAOyrADU0JKenCXNzNtnKAHRyUlxbFf/HAM7FAKmgE8XDAPrXi2ZmZt/MAKyiBsW1AO2o
		AJmSC////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/
		C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRj
		emtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRv
		YmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6Mzcg
		ICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8w
		Mi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIi
		CiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAg
		ICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JU
		b29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wM1QyMjo1ODo1NVo8L3hhcDpD
		cmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wM1QyMzoxNjoyOVo8
		L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNj
		cmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9y
		Zy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZv
		cm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+
		CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAg
		ICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx
		8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4
		t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/
		fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdG
		RURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4N
		DAsKCQgHBgUEAwIBAAAh+QQBBwBcACwAAAAAIAAgAAAH/4BcgoOEhUMphYmKi4QTE4yQkCkFBYiR
		l41aWo+YmJMBAZWdlxMOMzNKnKOLVRs9Pj49G1Wri0AqsLAqQLWJrUdHMcIxNQS9hEA0R1dOTldH
		NLzHXL9XWCEQUw9HxdO3R0ELEhlPJwq7x1U1FgonFxJWVhoKFrO9EyoMJkTvGRkaPBioUNUpRQ0f
		+viN+xfQxwZLnSbYwOEhCRUoOxJAGGCCAY6Bo1Ig+PDjRwQMADI2oZLEww8LCCBGkojjxwEjGEqI
		SMABQ4QDP3DYIMhI5AccSJCwcEFhpw6fBw7g8BGT1MQfSGAsbSAggRAMRmDACDo0klGkSECwGDGg
		qxAXLM7EIsHxoSojmljFVhiBQYCEGyNYgBBLliihs0nFwojgwoAAFxEqgBg8t67MRlezKl7LhMkI
		I5IHjxVqmAtizWLXunDxOTRlunYx18w6GUQFxhgwQHZNmHShs3k3J+mQcUXg0IR/UJUp0cdsxVpH
		vBAhQYYL0IqTTi0raNIrHyWTJvVgYsuSHC14GDkgHknQWKK4lDrlvGbJHwxiXAkS5EHH+yXhgMMp
		qXAxRAGg0JdLLhYAA4wFCy54SigpTEBJAQhkqKGGNXTo4YYgXjhBIAA7
		"""
		
	img_dict["good"] = """
		R0lGODlhEAAQANUAADXeTLW1p5mZmdTctVTjYK3Onvn592aZZrvxooXlfsjLvNnZzVCwWpvvjaOt
		nWCzZHHocrblob7UqNn3tEvhWpbuimrmbsn0q1rLYm7Bbqfula2tpKChnbbPpNvwt8/YssPXq2el
		Z930uHS7cd7ezofrgMD1pK21pczMv7vpo8r2q6OjnuD1umzHbf///wAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQxODowODo1N1o8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwAu
		ACwAAAAAEAAQAAAGoECXcEgsFg2ojUCwQRmMrgUnMGCxPhvOorhYDSYqk/gC0g4NnC9C06g0NAgJ
		5+lKThCNEmQ/aiAcKEIbHyoaCRYEFAchJRodG0ICLCYNGQ8ABwcPEA0pApEeCBUtmQcMFBAVnoIg
		lBAPpgAEnAWQdRsXGiUWGBQEFo0OCkJoIHh6eyUNBXNDUhJrbW/MW0RSDh0pEQUOZkZISkwKdFDl
		Q0EAOw==
		"""
		
	img_dict["good_h"] = """
		R0lGODlhEAAQANUAAABmAK2tpJmZmSbbQ/n59xyiJ5/HlmfmbLPxndDbswDVK8fMvACMD0vZV1Hi
		XsPWq5/vj4LnfdnZza21pcP1pp7hkZ6pmrPSoQOxH6nOm9DvsC/dSQZ4Ctbys5+smnTodKTwkwXW
		LqSunSGZJ27ncDjeTt7ezqPllMzMvwBtA8z2rLLRobX3nKesoaOjngKUE5zLk7rVpbW1p8vXsBus
		K57lkNbvrdb3tf///wAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQxODowOToxNlo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA4
		ACwAAAAAEAAQAAAGpECccEgsFgmogEAQQBGMOIlLluh0HgGXpChNqBAgCAgR0w4JrgQFEiEdSBHI
		yvXEoSYqyMdR2pRGHxAiKEIBMwgRDQMhCikcDhEZLUICHSAkBQyNAC8lJCcClBoQBzQAp5obBzWh
		OAEPlyUMAJohngaTdgGIDgMYCiEDkBYLQmgxenx+Dh8wdENSF2xucDACW0RSLhknFQYeZkZILUst
		C3VQ6UNBADs=
		"""
		
	img_dict["good_d"] = """
		R0lGODlhEAAQANUAAACZAJOdlHyohLTznUrCXy/WSnTFej+8OpDZeOr27JTDnGDDbYzCl9f4s42e
		kEnfWlTjYHPldIHqfP//zELEWa3xmHGqfBGgDlviZHvpeY7ogmnOXFbFTJnujGTYbJ3Pp46dkXTA
		e5mZmYbrgBCcCFnEaDXcTISmi7z0ouL6uh2nGaPQq1nkY+z37mrDdF3ZaFnASjvfUEq6PnuthIqm
		jTbVTlHDY2Hbalrea////wAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQxODowODoyNFo8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA5
		ACwAAAAAEAAQAAAGqMCccEgsFhOMk0h0YiSMuY/DQikUbALQpyilmB4QFuRR0g4TIEqMFZGMJBHW
		AvTMMQQmVqZTGVQOGRhNQicEDxEaKA0pFyodES40QiIFEBIcMhMXADAVEi8ikzUsIxsApzApAyM3
		oTknNpYVMpwTDZ4hknYChx0oCCkNKI80CkItICV6fH4dGQYBLUMfIAsYbW8R0CtcICcuLx65AdxG
		LQw0S8XSUO1EQQA7
		"""
		
	img_dict["good_32"] = """
		R0lGODlhIAAgAOYAAABYAFfHcz74PgDVAA6gPpHZpACkACrZKgCZM3P/c0fBZqPgsxfXF2b/ZgCN
		ACitUQD/AKf5qnLWhpX/lYv/iwC8ABDXEFT1VMft0Cr/Khn/GQD4AFbPbpL3li3FLXjlhQBzADLq
		MgDoAIT/hKX/pTG1VhHNEQSbNrPmwBjwGE3xTRelQwC1AGDRd5zupT3/PW3/bYTzimL6YgCZALX/
		tVj/WDnjORHoEQqsCgv/C3z/fC31LZn/mUzCajm3XWPRegBqAK7/riT4JAB8AJz1oQDCACH/IR+q
		Skn/STP/M4Pfkw6gPS/1LyHgIQCuAACTAADeAAv0CyboJnXXiTv4O1PObK/4sxKjQBumR0D/QDq9
		W27Vg5TepR/VHxT0FF3UcmDGfXnajJX1mgl0CTWzWymyUABmABP/EwiUCIz3kBHfEQ6rDgDMAIHq
		jFH/UQDtAAKFAgedOHPbhS/yL0f4Rzy5XzrwOqz3sE/EbGPWcxTyFGPWe3vmjP///wAAAAAAACH/
		C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRj
		emtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRv
		YmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6Mzcg
		ICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8w
		Mi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIi
		CiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAg
		ICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JU
		b29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wNVQxNzo0NTo1MVo8L3hhcDpD
		cmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQxODowODowMFo8
		L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNj
		cmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9y
		Zy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZv
		cm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+
		ICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx
		8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4
		t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/
		fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdG
		RURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4N
		DAsKCQgHBgUEAwIBAAAh+QQBBwB9ACwAAAAAIAAgAAAH/4B9goOEhYaHiImKi4koYGRLCAhLZGAo
		jIgFWEs+Ei5WVi4SdUtYBZiDGA9HU6Akr7AkEVtYDxiYC1cBd0EkExQUI8IjFBMkRD1XC4sLJ1M0
		vhQ6CTAN1jAJOsUkEifLiBgrStDS1TVuSOluNQ0w2iQ/V7eHD3jkOg01SC9J/f0vSNi9U/DgkKY7
		JKQ1cJMliRENZyJqMJJEgAoZ2sSsOFUIy5QgE/C5eZFBQw4IKFHmSCHFw0UdE1pgKYRiCTkYNbJk
		OJOy55sBONDYuACDgpg4lwaBqQMSH5IkGnqm/OnEiYMDdBrALAGGEJkwCRPUeCEkyoYNPgc4qeAE
		Thc7Nf8SUGhBhtASFwlhuEmSwgmUN2c3UK1QYQYIBnPcFOWzhBACKyRGNEDCRM0TAwNEaFZLeMYQ
		IGqYIGkwQgwCxwglI9lhwUFVNgM4Fx5ixsCNHaNHdDg9iABe1XMsDDHAoura2WZmQPGSJPeHxoPI
		TMnrhgkDEA4MEO5MW/kbDUkUU+BQV6mPsDWoNAGBnTgLz8n/5jDyIi6FMl0HobgSIeTkOSYAAYQD
		M8DnHQTgjaZDB0h1JEFeNQggRYBAsBffGxCckUEWNRRVxUyFFHAEEf65QcWEQAAAgHc5aJDBC25o
		FcMVHBVST0IiCRBCF2OsoYYeEyWRRYzaaFHQIRhc8QNpjvnQYUcIIeywQxIACUTBFwTMc0gzcuAI
		gwznpIPEOu1oU4U3zFyhgBi/TFPNNdlQEIMWBHyziCpXtMADD8AMQ0waHNSiJSaaxFFCC22I0cEH
		HJQRhymoGOIIGQRIQkAlSUWq6aacHhIIADs=
		"""
		
	img_dict["bad"] = """
		R0lGODlhEAAQANUAAIFUVNW3n5mZmf+IbczIvP8lHvn597W1p62mnv9xWsA9Oc+umv/Mo/uoiP+c
		fdVjVfG8mtnKraxJRv9UQ9nZzf9LPLKuovfgtv+ph9nEqO63l/+Xede+pKGem/+9l9U0MKxcVeBU
		R62tpJRPTt3VtN7Wzv+ggP93X//BmqOjnv3bsNSumLVUTf/Wq8zMv9vFqN7ezve9nNbOtdnJrPe1
		lP/etf///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOFQxODoyMjoxN1o8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA2
		ACwAAAAAEAAQAAAGoECbcEgsFg0ukUAgchmMNkrqQLpcIpYUpSglqRioMOPV2QoNKVLLg3FsHBgP
		p/O0uSwqj2lwSpwGJh4ILkIiMgwYAyAhFSwPAxgBIkICFygOJxMjChITJw4QApQXHhsJFR8ABRUJ
		G6GFM5eZIx+dnwsIQneIioyOAw0IBGcpGXp8foArdEMUHRxsbg4Ny2bNHQgBEBq4ZVBISgLCdVDl
		Q0EAOw==
		"""
		
	img_dict["bad_h"] = """
		R0lGODlhEAAQANUAAC4SEpmZmaufmP8AANnNsP9rVv9VRPn597oGBv+Ga62tpP89Mde1nf+jgszM
		v/80KoQODe6hhnYMDMzIvPnWrdSfjLoiHdnZzf23k9u9oqOjns+hj/95Yf/Hn3YaGP3Qp04PD/9y
		W9nFqdWrlf8JB5YJCcwLCrKtoqGdmt7Wzt3Rsa2knPelhNm8ovnbsLW1p93UtN7ezvGmifeljP//
		/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0
		IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4
		bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQg
		NDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRG
		IHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+
		CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhh
		cD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRv
		b2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNy
		ZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8
		eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOFQxODoyMjo0M1o8L3hhcDpNb2RpZnlEYXRlPgogICAg
		ICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIK
		ICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4K
		ICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVz
		Y3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAg
		Cjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c
		29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSj
		oqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtq
		aWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIx
		MC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwA0
		ACwAAAAAEAAQAAAGokCacEgsFg8ORSCgcByMtIvmpXJRRCfNpSiFfTCNMCaD2goPGlinkQgVQokG
		A/WkOU6fBseweCwMHA0rDkIKBBgJBh4mAxAWBgkjCkIBLg0hCyQgJRIkCyEyAZQUDQUPAwgAAwMP
		BSyiNAoil5kgCJ2fGytCd4iKjI6QAhNnGi16fH6AFXRDFygMbG5wzGbOKCsjMhEbAmVQSEoBKxN1
		UOdDQQA7
		"""
		
	img_dict["bad_d"] = """
		R0lGODlhEAAQAOYAADMzM5mZmfcpI4iIiKamptlDQfd6YvCoht/f37VubulnV+jSxNmdna2EhG9v
		b891a+/AouXPwcyMjHJkXPlKO/eIbO25mNlNSPldSrmpnk1NTfnq6tReV6GNja2JiK6Bf/UvKaCO
		jX10bvWUdtdVT/C7mvnr6/Oqh9JqYfWHbP9aStw7Oa+TgsyRkJ2RkO5hUbJ4d/8xKfePcuTWzLF2
		dvethPdfTN6cnPxIOa2MjNhTTd5COtVdVc6UlJyUlLF6efw4LP///wAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/
		C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRj
		emtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRv
		YmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6Mzcg
		ICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8w
		Mi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIi
		CiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAg
		ICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JU
		b29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wMlQyMDozMTo0Nlo8L3hhcDpD
		cmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOFQxODoyMjozMFo8
		L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNj
		cmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9y
		Zy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZv
		cm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+
		ICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx
		8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4
		t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/
		fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdG
		RURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4N
		DAsKCQgHBgUEAwIBAAAh+QQBBwBBACwAAAAAEAAQAAAHs4BBgoOEhYUbEg0BAQ0SG4ZBDB0JKwIC
		Fz8dDIWSKyA4KqEUOiGbghsdK0AYBjIjIwYYHCGPQRI0MRgpBxYQFicVNh8Sgg0FOAYHExkzIiwn
		BigeggECKjIWERoDDgslMi8B1CAYIxAzBAAIMxAj4cUX19kaBN3fD9O2MBTJy83PBjy0EGSiAwld
		vHwBexDCxCAGIXjYaPXKwAMXph6G+IDihYIHDUpBMiHBwyKBDiGpJBQIADs=
		"""
		
	img_dict["bad_32"] = """
		R0lGODlhIAAgAPcAAJgQD5mZmfcCAjMzM/+eg/9wXd4AAM6llpU2NvdURzcqKu3l4PZEOdnNxakn
		JPetk94eGXU3Nf6MdfcyKvI/NMewoa2ln8wAAH8cHFBQUO7BpfhnVvcaFuASD0JCQroBAepANv9+
		aca6sdSmlm0eHObc1uQxKfpgUPhLPrQBAbmpnuYAAPenjf+8nfe1lF5RUf+WfaSemo8/P8sdGjs7
		O/o4LtuznvchG6ApKT8lJeDVze8UEOQmH/cYFG1UVLWkm9kJB/96ZboODv9SRP+CbeYJB9q5pP9S
		SsStn/W4nUlJSfFJPLMNDaYCAmM7O/8yKvm9n5QeHqahnf/BoUAyMssvKNa3o7Oqo29hYfgpIvEg
		Gv9qWP+vktYAAP9LP1AXF72jmNKvnf5CN/+mi/AYFOetlu8AAN7OxfhYSf4bF/AxKN4ICP9iUsUA
		APfFpv+0luYfGfQKCJ8ICNGsm0g7O/c6Kf+4mconIlpaWvFCOJhCQns0M+7Ep72tnPJTRf9ZSvdK
		Ov85L+8nIf/Do/wiHPEJCNizn+YhIe8ZFmkiIswjH9QPDN+8pf///wAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
		AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wOFQxODoyNzozNFo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOFQxODozNzoxOVo8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQBBwCNACwAAAAAIAAgAAAI/wAbCRxIsKDBgwgTKlyYsISIKzECBIhxRUQJhggbSImhwgofN240
		WFERQ0oDjAMXWLBgxc0UO3a4yORiB4oVKRYWYNQRo4KbFlzGECAAoygMAmO4JEESQ8dCHQGsDHoj
		VIIEIiGyEiEiAekbQwGcIlwghdEULkSJBCmwZQsbNlsKBCFylEuYGDoPWqgwCK2EEAXY/BnipfCQ
		P2wKhOjKBYmFgxrdvCEgIcgWNCjE1HjCuYYYFGi2BOnqIsbJglKMtBgDI8SWBHnUCNLCobYWQWoY
		hA4BY8wcKQVLxHCDlkgBNHmq3OlQxIzzIjMU5f5TgAiBBwEuDhShYsqYymxQqP9xgAdLl/Nd9ODZ
		A2eCFzajx/wQQfCKETuUC/wRI6hDIg8ytNEGExlQYcAOWYhBXVdzXEFQDHxMRsQWQ9SgRRFdKKAE
		DilkMMAFBhRCSCBDbGFdGTEQFABxrW3hxRMcmGFAGwNk4IMHKXSxggBpPOHFFrxhpyKLIbDxYhoy
		XtCEBx5g0IYBzvX4XpABPKgBFy0emWQUAwzgxJNm8OgjkDCgWJ8VElJYww0YfpBBDl94gICOcYxY
		onUHOLidCvhJoB9/HVyAxwAffKBABkIcmOCCBMxHkHBQfBdEeGpA8AINclxwwQc1LtLee6OxkB1q
		VhR3HAgRDEACEAa0CsAAdEydVx0BBwBXkEZJsBbCBn6AYAIPcCAiLBw8mJBHAmSyYJpeSExWGa9L
		UFDDBNROQMESaGwwGgFgPHbQAjGE4RdgJ6BBmGFonKBYVyPglRBUNqAFg1psuQWXXHTRGtZTMSDh
		QlVXZRXCVl2xAEZTGKkUwxxBDWXUUSwcEENOKAmkUQA/zFHGAw+UccAPAZhUcXAPRTRRRdqNrPLK
		LA8UEAA7
		"""
		
	img_dict["drop"] = """
		R0lGODlhEAAQAJEAAJmZmf///////wAAACH/C1hNUCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLv
		u78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJh
		ZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2
		LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJk
		Zj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxy
		ZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDov
		L25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUg
		RmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+
		MjAxMS0wOC0wOVQwNzozNzowM1o8L3hhcDpDcmVhdGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlm
		eURhdGU+MjAxMS0wOC0xM1QwOToyODoyOVo8L3hhcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpE
		ZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAg
		ICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAg
		PGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+
		CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAg
		ICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tl
		dCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT
		0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJua
		mZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2Jh
		YF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKiko
		JyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh+QQBBwACACwAAAAAEAAQ
		AAACI5SPqcvtb8CSKtADArNYN541lOVdCCeUXnWFn+Q6JGSs9N0UADs=
		"""
		
	img_dict["refresh"] = """
		R0lGODlhEAAQAMQAADMzM729vXx8fEdHR+bm5pmZmWZmZtXV1Y2Nja2trTo6OnNzc8XFxVJSUu/v
		7+Dg4JSUlEJCQoGBgaWlpbe3t8zMzFhYWGtra////wAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1hN
		UCBEYXRhWE1QPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtj
		OWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUg
		WE1QIENvcmUgNC4xLWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAg
		ICAgICI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8y
		Mi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAg
		ICAgICAgICAgIHhtbG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAg
		ICAgIDx4YXA6Q3JlYXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29s
		PgogICAgICAgICA8eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wOVQwNzozNzowM1o8L3hhcDpDcmVh
		dGVEYXRlPgogICAgICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wOVQwODo1MDozNFo8L3hh
		cDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlw
		dGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9k
		Yy9lbGVtZW50cy8xLjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1h
		dD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAg
		ICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u
		7ezr6uno5+bl5OPi4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1
		tLOysbCvrq2sq6qpqKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18
		e3p5eHd2dXRzcnFwb25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURD
		QkFAPz49PAA6OTg3NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsK
		CQgHBgUEAwIBAAAh+QQBBwAYACwAAAAAEAAQAAAFXSAmjmRpik56loGwLAnkrIQC3PexYhNSIAMA
		ZTc6LAIzEuFHIIogN4SJ0BxNIopJidAAPEYPCyDBUgy+owKggWZQDABBUhSOixARwNlUMTAwDgsA
		EX9ODBJyToqKIQA7
		"""
		
	img_dict["uni_help"] = """
		R0lGODlhvAKQAfcAAAAAAPX2HMTEL1aYUPf7/vb29jRfivb25vrW1goA4/nOziJLfp6fif//AMXF
		98TS3EpsnP8AAOfnEqCu3t/fxmZmZvz8Si444YSEYe/v793dqUpppP//1rS0oHyTvRkZADx/sfn5
		i7vL2f//uf//5hgA1f5CQjZckOfn58jQ2HV1dXuVtvf3193f7ff3uPr7KUaFq1tyuDFShf08PM7O
		K0hklP//qvj473qRrdzx/Pb3Zd7e3n6PxHKMrf//hR0i7r2998zMzFpznTExJrzl/AAA/2Zm/0lZ
		z12CokFijai4yFp7pf7395+f+dXWw6fZ9YGUtcbGxvyrq///YtbW9vb23u7uxTFZiwgIAN7fRUtj
		vu/v9fzm5kKDs///3vf3zqWlpdfXqmSAoCtUhXWTt///zP//7zMz/8XFtYuLi7a2toiI+cAAOebm
		9gAA7vDw3s/Pvk1ynf3v73x8e1pux4ejtkxktamr8SEhAGuFpbW1+M7O92yFrTtljvve3lFtlzRT
		iiZLfunqszpbinGExQkJ//j4rWh8xVJqq///95Ke4UFjk1l5nQwP9z9N0vf3xf//e62trWpqau7u
		1h0d/+b1/WyGx42kvv9jYyoAwfHxHVpa+8PDpIWctkxM/7C40IqKg///xb29a0dHOWN6pHOTsDMz
		AP///93dzz13Ut7e/3KMqPn5e2SErP//JJWWlHt7Z9bWvubm/7S28K/e+JmZmd7FxRAQAGyIt+/x
		Z62t+FJovXmbtbjF3mV6um2KrL6+wHun3FpaU6CwwGJzyN3dvu/v/1dzp0Jrl6LTmVNzm3Z2+szM
		/2W0W2F9nr29/z9elCxTisTS5EJL6NbW/0tqlOXmz/Dw5lNsm3OMxIugtygo/fj5Kt7Q0MXF/5fO
		kIvFhIunuJqn4GZ6z42Z4lFqtVNwmN7e9ilMhR8AzUporJmZ/2GFu6254MDAnuHz/FNpxjJklSJL
		hYSgu+7uvTxjkry8lBAA3f//Vu7uzWKDptXVtf//M3Kaz9/ftNbW1iH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wM1QyMzozNTozMlo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNVQyMzoxNzoyM1o8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQABwD/ACwAAAAAvAKQAQAI/wDBCBxIsKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBD
		ihxJUiQ6eYECyVuJUiXLlSlfxnzZUqZLmzhpzoR5k+XOmjp7/uSZsyhQo0OPKiXqsyfTp02NQk36
		k6pQp0qtSs2KtWrXqzS5hvU6FmzQrWTPRlULdepXtGaRvl0rtyzcu3Tzas3r1i5fsWyXAq4beG/b
		wXqxykPHuLHjkysfS2Yp+THlyo0vY4a8eDNnz589a8Y8unLpyZFFp9582vJq0q9Nx0bdmfVs17Vh
		55a9mzbo1o6BZ74dnPjw3rh/G2csnPny0LaRF5d+XDl159eh67bOXXX25tp5d/+PPn476PPo06tf
		z769+/fw48ufT7++/fv48+vfz7+///8ABjjfGAQWaOCBCCao4IIMIvjJA844M4wSpDRo4YUYZqjh
		hhx26OGHIIYo4ogklmjiiSimqOKKLLbo4odXyCDjjIAAcsWNOM5Io4043qijjDX26OOPQQopQx6k
		kPJPG6us0kYGUMgYI5E89vijDEVaSaWQU+qYZY5bGhmmll5WCWaZXF755ZBoitkmmTumOeaZcbpZ
		J5xAmsnmnXTmKeebfWKpZ5d87umnnYfiKeifhRKaaKBrOrooopMqGqmag2LK6KOGVgpppnN2emmo
		ko4KqKignlpqqo1qyuWrPdb/GGmsssJ6o6yDcpnHP5ecAIU2pKzSQgs4rDIMFLPiiKutVyxrq7Ow
		QvuqtFxSK6S1tCZ7a63Pchutt9OCW62415Kbba7Kmpuuts2quy272K6L7rvztguvu/bWGy+9zO6b
		b7/4+itwwATfa7C+BSN8MMALd8vujYNEPMgJFFdMsQEGSDyxxRVjrDHHHWcsMcgXG0DKMKtsTHEe
		SIpwShs4jEyyxzKDTHPEJJ9ws8oc75yzzzOLjHPQHxNdc89C82wx0DYn/bPTRg/ddNFTH7001FVL
		jTTVW1sdMtdXg/211yWLXTbZOmPdtdZho8302kqPzbbccZ89t911p2223m6r/9323XwD/vbfeQ9O
		99N7G15yPYw37vggSUQe+QmSVw555ZRXHvnlkmeuOeSrdOL46PWQksIpGcTMueWae8465ppv3nrs
		SayehOuS24677LDHrjvtv/s+u/C9fz688cW/3jnwxys/OfPJ59689NHzvjzx1yOfvfO3Q7899d9b
		/zz242tfPve71z69+N2T377576Pv/fng089++sHDj//66lfff/j/s18A41c/ArIPGtDoQx8qRzoE
		KpCBo3PgAiXXwAROkIKdUELkJKg5HHxiGKSoBwcpGEELQtBxI4xcBR9IQhSasIWNS2ESVnjBGZaQ
		hSq8YQ1peMIYvjCHLsShDf+DuEMd9pBxMuQhDJH4wyH6UIhKBOITi0jEI4qwiVF0IhOhaMQlXpGL
		VfRiErsoxS1ScYpWHGMYy/jFM5oxjVgkoxbbCEcwolGMcVzjHNV4RzaqcRGADKQgB0nIQhrykIhM
		pCBP9gkcKPKRgzxFDWqQhElO0pCnqKQlIcnJTnryk6AMpShHScpSmvKUqEylKlfJyla68pWwhKUl
		ZzlJZNgSGbSk5S1xmUtL7rKXvrwlMGspTG0Q4BTEAmQ1qvHLYTaTlqdY5jNzeYpp5tKauhSmM7UJ
		TGzO0pvBtOUwawBOYopzm+fsJjd7WU5yrvOa78xmOtkZz2/WM5y8VOc84bn/T3nmk579tGdA8TnO
		dhr0nub8Jz8V6s+CItSdA02oQyMKUYYK1KIERSdGJarRiW60opOEgEhHCoFlmvSkJl0FFEhhy1Xg
		gKQkXYU2nJGHTti0E2KAaUlRelKS8nQYp3hZJ0bK054StagnjSZSl0nSau4SGTrdKVJ9ulSqTvWo
		VxXpUqth1aJ2ladfRWlYjarVqmLVq2cFa1rFulayShWtZc3qW9UaV7jOla11petd3brVsZrUr0xt
		618FG9i84nWvg81rVEcKVQgsYrEiheouFyvZW1JWpO6Mal8Jy1XOArazhuWrWUOb2Lvq9A9/gABq
		V6tTFGSgE38gxQNakIfT/yrBGJ34RFBPYYx/vFSkqFXtalGbB5TFIQ7BHe4fVvEAFIBQuMJlLUyT
		O1ydnuK4w90tSVF7ij8ENbgj3S12qzvd1Cr3tOYl73bTK931Rhe87j1ved+b2vnKN77qHSl126tf
		9sK3v/RFb4Dtm1/g+re++OWvgQec4P8u+L4AhvCDCwxdCVeYwvt18IUVvGENZxjBEaYwZEdM4hKb
		+MQo/rCALaxiAnO4xQ0G8YSV+wdl2NjGIjWHjnfM46BeIg7OaAGTiIskHXswD6d7gAj+cYp/OEMZ
		zlhFbYNVLORq4xSfkHIclJFjHtP0xjiGAI97vOMuj3nHp+CymM1xXe6CWf8ZQdVxm91s41OY+cxl
		XjOe87xnHt95z3/Gc6DPPOgxF9rPeu7zofncZx0v2tGJBnSkBT1pQlfa0JdGdKMhvWlzPNrTmWZ0
		oz9N6lBzetOlNsdxkWthkm7g1bCOtaxnTeta2/rWs47DBnSKjV77+te9ZnWNwZxqVJsa1J0u9pjf
		zGxm+xjKQl6FGD6BAhQ8AArmGEYLoJACY0BBGXnYQeo6saRtf6INxmiDEpxxCd5m4B95YMSZSQGF
		YeCg2fg+hTnkveN881vON04zmAUO54Hj++AIT7jCF87whjv84RCPuMQnTvGKW/ziGM+4xiG+WFx7
		/OMg//iqRz5yYGNj4yj/1zgjVs7yljNCGUKIucyF4GNGBJlJum1DC5C5Ct1qo9tQEIIY/pGBYbQB
		mSk4XQtEsPNhtFvnInCGy2F+CWOcwrkuXznMZx7zU0yd6113+Slk7vWWl50RY5/5br8OdiGwHexv
		53rcZz53mdc95nd3e8u3Dve9t13vLOe73P3e9rwbnvB9D/zfD6/4wiN+8I1PvNYX/3i6V97ul8d7
		5gE/ecdHHvKd/zvXm42I0pd+A4iAtekRoY7Wu/71sI+97GdPe9WrfvWmt/Exdm/jvwve8p8HfuhB
		/3LKBx/zx9e84pfg8iU4//nPF/spLrGEm0Oh2lDIg8uG4fNud2IYD2iy/24/wTKdr2IJOKg2UD+R
		JOhD32VBbQMj3A99sdP/+Wc/hftP4Qznn33l+ud//Zd1Aeh+zXd/zNdyCJiALLeAB3h/D0h/EWiA
		CoiAE1h/FQiBGSiBG0iBDWiBHYiBH6iBI8iBJeiBK+eAIRh9K+h8F8iCJyiCKQiCMQiDM0iCN2iC
		OYiCLbd7PviDu4d7QiiEtFeERniEsjeEqweETOiDLtiCDLiDMjh/NCiFNkiFOIiF7icGXCgGzhch
		YBiGYhhUwxAhQtYJGdACSQJU3HcKP2cMw5AByAQFPucMOJABURchD5ABSoBlXyiGEQJUqMN+SUIK
		gBiG/HeIEVKAp+CFYP+YiM5QgIv4iIj4hfqniJiYiZq4iZzYiZ74iaAYiqI4iqRYiqZ4iqiYiqo4
		igvYhMeghKtXDrI4i7Q4i3Zwi7iYi7q4i7y4i+Wgi7C4hK74gwu4isaIivqgD124jGIQhsm4cyJQ
		U2kIBe+2hqfQhm8IBdqYB87gc2KQB+YnBjigc5dAAP+wCqTAjMs4DCIALOmojs34iO+ojo8YVPC4
		WxGSjFy4W6eABPqAiEGFBAI5kP8IhvoIj86ojAhpkApJjwwJj/GYjw3JjAkJkRW5kBJpkQ+Jkc5w
		kA6ZkRzpkRS5kR/ZkRO5jBdZkiKJkiQ5kiCpkifZhSnpkiapkS9Jkyv/KZMtyZI3yZM1yYwL6HxM
		qIS1WJS/2ItImZRKuZR2YJS0aHrDeAyk8HyFSAoDSZAz6ZM5yYVZqZM96ZU/CY/JOJZkWZZlCQU7
		51qnoASrUI36wIbd521k6XMs04dLhwLXuCsv8wAsQ5bGMlNmGZiCOZiEWZiGeZiImZiKuZiM2ZiO
		+ZiQGZmSOZmUWZmWeZmFWZX0FwOc2Zkx4JSgeZS8qAWkWZqmeZqomZqqWZqh6ZSeyYRVGZtViZm0
		aZh8cJssk5u6uZu6CQUPoHPrtivslwdoqQ3ahgNK0AJSlpvH2Qqt4AxK8CQoQCEsIwLmpw+5iQM7
		h2WkwJve+Z3gGZ7i/zme5Fme5nme6Jme6rme7Nme7vme8Bmf8jmf9JkHznmf+JmfzumZ/OmZs7gL
		ABqgArqaBFqgBqqaApqgAGqU/dmfvqCfEHqf9Tmh4vkLFnqhGHqheXChwcIyFsqFFsoyhYgkpJCh
		SZKhv4ADeXCbt1mIGdqHQZUBq3CbKFqjG1qjGXqjOKqhO4qhOtqjP7qjQYqjQ2qjPcqjR/oLRYqi
		S5qjSaqkT9qkPhqlVJqkUoqkR3qlIVqlWcqlQOqlQgqmRBqlEYqfDdqfCpqmu6CajnABF/ADcAqn
		jTCndNoIhXCneJqndUqncfoDbnoBjnAEBKqmCnqmnOkLiEoK+smijP/KB2JqpFb6qDvaAxjaJDVK
		qRdqqSiKqRaqqRnKqb8gZRPSCcHSJGKAjr8giC/TJKy6CpXqqpv6qpcqq7GaqbD6qbSKq7Y6q7ta
		q516qxgKqp4arLlKrL2qq7/Kq8nqq6EKrBcqrM5qodCqrM1KrcP6rMWKrcdqrMuKrNXKrNcqrdkq
		rtuqrd3Krd/qreH6C9MKrq7aA/DaqIzKDohar75wpoSaoEfQpm/6A3OKp0UQsAI7sARbsAZ7sAN7
		p40Ap27qCFqQrwnaoPY6sbjQCiz6rPCase2qrtHKruPqseVKrr+6ChpbsiZ7siibsiqrsXrJWxQi
		U0L2AMXCZMbAfiv/e7M4m7M6u7M827M++7NAG7RCO7REW7RGe7RIm7Q3K698MLGI2qD5uq/9aqcI
		W7VWe7VYK7CFMKd+Gqjw8LVg+7V0sAt0ULae6bS+gAtqu7Z8oLRuq7KlELdyK7c4ULd1O7d4a7d3
		i7d0q7d8S7eqijrFgpdBlQJJ0gkr9bdxq7c4oLilwLiOC7mKK7l/S7l8a7l567eTq7mVy7mX67mZ
		a7eRC7pzi7mlS7p9K7qbq7qdy7qf67qhu7etK7uvS7ux27ira7unC7u7q7up67uLi7rBy7u/i7uz
		W7Jriwto+7Rl27zO+7VS66+FkLVXm6fWe73TS71Yu7A/4LVh67zN/xsDy5u2a3uytzu6xDu8wPu4
		wsu+jFu3vBC/8lsKK1C/9osD8ju/9nu/+Ru/9Lu/K4C//atb/GhT/NgGefC/+yvA+avA/Nu/Dly/
		DKy/ADzB/gvAAdy/vBDBGQzBGGzBG/zBGszBIEzCIyzCHlzBJ6zCKbzAK+zCLfzADYzCM8zCNQzD
		NyzDFIzDO6zDF2zDPSzBL+zDIQzEP8zDR0zEJhzDQuzBZPDEZJC8assO9Dqx4Ou8R/Cm2au9eMq1
		DPungHoEYjzGRxC28EDG++oI/OqmcUqnW6y9C3sBZXzFdEAMdkwMFCvFa+u4S5zDTezHHQzIJYzB
		vFC/GqzBhnzI+f+byIocv4zMC4GbOne4WzvgDBi8AoWMyY3syJq8yY+syJ98yKGMyJ3cyKPcv6e8
		yKUMyqssyq1MypvMybGcybOcyvJry7Icy7hMy7r8yqjsy6pcy8B8y8Ocy55czLx8zMIszBgMxU8s
		xb5wCNJ8x3aMxVpMvQrLsF5Lx9zczd7MzWfcpnJqp29ctXF8BFd8x9K8zsnrzGRwyfCczKaMzLsc
		yjd1z/dcv/i8z52gz/yczyvwz/mcB+HnskmiBHLYBtrgzwLdzwHd0A4N0REN0Qwt0BX9zxfNzxm9
		zxuNzx0N0BL90Tcl0jZF0hPd0Cad0g+N0itt0S2N0S+t0THN0TP/7dE1DdIUfdMjrdMlzdMn7dL/
		rI3aCMDZUNRFTQjrPM3UTAx00KaNkLXcC6jw0LxLXdVWfdVYndXUTMdZ/KZUe7WNAKhlu9RJLc1r
		mw3uLNRqHdI+rdJsvQLzINFyPdd0Xdd2fdd4ndd6vdd83dd+/deAHdiCPdiEXdh/bb9GXdRlfQh3
		TAdH4K9g3bXwoNV2vNiWfdmYndmLrdVN7dXlXLCF8ANHQNbrTAimbdQekNqprY2GTdjaoA11ENuy
		Pdu0Xdu2fdu4ndu6vdu83du+/dvAHdzCPdzEXdzGfdzIndzKvdzM3dy/bVOq7QGJbdrrPA7jQAxZ
		/NQIG9pyXMdW/63Z0mwJpj3e5E3e4l3e6E0I553e4w3eSl3NWfwDnz2wYT3ZxFDWlmAJqB3d89Df
		/v3aAA7bzi3c4RAOr30JCI7gBR7bCX7gCX4JC14HDa4NDw7h4cDgCO7gCR7hE17hHJ7hFP7gH34J
		Gq7gFy7hIO7hJ97hIr7iKd7iGE7iIb7hLi7jKh7jJW7hOD7jJr7jN47iNg7jQJ7jI07kNW7kPi7k
		LE7jSc7kQ87jOv7kP77kPS7lSv7iTk7lUa7lRQ7lXT7lWF7lXH7kXk7mr+3f/R3d0l3U+W0J0nzd
		jvAD5izH1l3ndl7W5d3m+Z0N453Yfv7ngB7ofM7ehG7nhl7ndP8wDRfw1aD9A9NAB9ad1IRg1DxQ
		6TyA5v095k0u5mG+5Z3O4fwY6qI+6qRe6qZ+6qie6qq+6qze6q7+6rAe67I+67Re67Z+67ie67ou
		6wTQ68bw68YgC7KgCqpADdTADMzgDc+w7MtACQdbCGewDE2gB8te7c/gDdiO7ci+7chu7N7u7cQe
		7uI+7uRe7uZO7t+e7tzO7dmu7Na+7E1gBGcw30VACcugC9Wu7cZO7MIO7L1+TLse8AI/8ARf8AZ/
		8Aif8Aq/8Azf8Kf+78Ae7MNu7MiO7c+gB81usNB+79Ru7e2+7syQ7tRw7uEu7CZ/8iif8iqf8iRP
		7CJ/7Ove7u///gy6sAzbMN+UYAQdr+0hP/L9/uv/7vBCP/REX/RGf/RIn/RKn/AQD+zDXuww7+5r
		4OwFm/PT/u7Zvu4iX+4rn/IR//VgH/ZO3/Unf+7qzu4Wb+160ASbQAmfTQnrkO/d7vOyAPS9vvR4
		n/d6v/d83/d+//f82PTB7vLHbvG6MO8EC+3r0PH5zvNzD+7jvvJiP/mUX/mWv/Lo/u1o7+7Vrgtr
		gPgJ6wlNsOz6Tvd2D/CAn+rS8AAPsPqs//qwH/uyP/u0X/u2f/u4n/u6D/uj7vquv/vAH/zCP/zE
		z/q9z/q/X/zKv/zMD/zH3/rNH/3Sr/si0AvW3w7YPwETIA6K/9D9y1DOhSD6z0AO5ND93S8O6I/+
		2r/+E4D97v/+1h//8j//vSAC9n//+J//+r//+U///h//ANFO4MCBEwweFJdQnCKGioA81LPOU6Ei
		FStSWvPsmTdvzKhRUyXL2EgCJU+dRJlS5UqWLV2+hPlS2gNpGWzexJlT506ePX3+BBpUqM4HRVHO
		rDlU6VKmTZ3mLPrgKM2nVa1efRp1alKsXb0CRRG2xdgWVPY4cABk1qw7myhaLOSpyTNydR8CQetg
		z969VPxSORc4cBvChQ1vQZxY8WLGjR0/dmxYMmHBgf+a5ZvXQcOHzyKeeWtxk0aOHlWFHGnMZEzW
		rV2/TimN6/9X2rWxGpVtW/fuprhn8wYenKjU3MKNMw2LgizmtGvvnLFYcdsycnTJPdTM9zJgwZMJ
		QwZfQPx48uXNiwcP3jtlwZczo2XoQKPnNZSiF/GkZyMz07JEkoQtQAEHPOW34w7cjTgEF+RNQQYf
		pM1BCCfMIDmyWtirOba2ia6QTe64ozqH8tLur8q8Sw+x81ZksUUXx0txC+8q+4uvs8RxwJv59NDF
		rejO0K+jj1AjiQACj0SSJWl2oLDJqmhi0kkpl4JySiuFqvLKAy0cyyy01poFOoswAvGOhtAqkbtz
		UITsRTffhHNF9SZrr8YJxGFGR4300GONRqLzhDTTiFwtSUP/jzRQS0VxSnTRRRt1VEtII/2KS7/O
		UmuWTaKjZJ0y18JRLxMHk6zNOE9FNdUCIJOsTr8m4C/PHdexzyIj9hvSPwAP5VXABygF9ldgIxV2
		2EWLNdY25bo8y4G11giNkiY+BbUvNUt1TFVttz31sVYtm+Aj/vTks4laiyhkLiFD+q/QXt+NadJk
		J5R33gfrtXdBfPNVSqyxMlTrDg4ramRaah2YwC9SC8uWW4cfhrMxOts5jZpx94wotDNwBaldI+EF
		WSYE4yGZ5K/iuRfCkku+CeVk9wXO5ZZtktlRmKta2eSlaq7UX+bUgtaiZcq8Yy28El64jcZaJFm8
		nFcsebyo/x9uGmIYGTOsHVkqzpNcXYyAax2Ocm03ZLOVPJBnnnFO+UG1aVZqbQRv1g3lmuV+VLi3
		ecJbN0szXMsTi7YxGMRZ8HKgnTUZXszNqh+P57ypC5ic26qtJk/iXvxTRVyvdTk30HV1Ve1s049K
		O6e+mVqdN7pPVh3uoVoP7vXa7MaJ9iltZz12vrf0udm1Bi7CiMKN1kvx7xSLE3KpIy9vZcorx7x6
		9BbrxRjOLSaXR7Clw5XdXU8/m3en+ma5ZZ0zwJ399e3W/Svzr9pb5vRp1vl+Bufvqn3Z7W8f/CjE
		P6HszX0uSx/uAIjAmR1QKH/70iz+hK41HG8WaGrH8lR0Kv/nOQ165JGe9Dx4uaaRMHIm9OD0QHjC
		D6YqMdnTXuf4gzFdBK0IjQgfochnOgLubH2yYx8QEcjA/xHROD08X84aaD8hArFtKmtgEKU4RPw5
		UV968x0Tpei+/82MiVr8CQSdNYvoNMGCGNRgqjqowuidkHJs/CDkWDhCOEIvas6jXrcQA8OtWYwZ
		NFzHW3C4Lh3u0GxIZB0Y12bERUZROIjsXe6sOEWdxG83kGyKIru4yS3uT29KbOIWtThKSk5yJ2Jc
		S2gqeLDkMW6DcFrj5Z73xjk+r4O3tGMuU1hHbSmGjzL8o2d4ZENK5LBshgwZJneGv/utLJSSNOUl
		oQjNBS7/0JGeVFnOiMjIZ2IzZo4EpSYPmL8pOhMswdvDQ2ZBvE1YEC97UJ7SGvemWLYwhW5EIS53
		qU9eslGPvtReH7smTF0IDnyjOyYy4aVMn9Svkku8pigPxNACZrGbnHwigxxaSo5a0jYU9d1FJYpR
		uBnxgehsjkGLIC1qIU5xi5Mn815UT/OU0Kb71GU/+cnPiGFtc33kHg3PNRqEjk+hvQLpTjZaSnKG
		EoyPnCZEy+nUAUZVktus4kgzupu7RZGbnBRnJ33iLwxhahY2LMLQWoow7hyGMUzLqSxnece45rKW
		dMVpXvMoJ6wVRmtcC6ZnvvaWQojNG2Qz6lEPlVSlmpOZ/7kLIGTDClW3gVKU/mumR2vD2IYqtaOR
		jeYRsQhNB2ZVkT+82w/BshzhhSlsRFsLW6/lynm2cYRyneUb/fk0FeYzjnWdqz3NExnDnINiwOxe
		IC2yMSF1rEiKfRdn+aUU6U5XKNX1imZrZ12vLKssADtrtCw4C3FYqztuXZr1oCZc3DZPuKsibmHa
		Ey4/6skztLJII9YRPtK5C7pJwi53fRJgAfOEwOeLaFULXBUufTeCmxqTBXFUohNhq2Hq9Wdum5fb
		OcnXMn8J18X2hF9bcUx8pfsvrw68YEaxGEIrzqRqnQTjKTX4Z4GLTiPW8KkR6cVaaoIpei8MMdy2
		d6YlY/8VnT6MmT3gSVZ78hOgNlJU1XwsxYaiMYuzvOAtF7jLTbJxszIlJot4okzXQZyP93CZCk8m
		RRjuaXrWQ6MaZcgB4rDvMwoaGvwIKlep8e+VCfRl7hLauoaeLqIf1OCyRvA59yETOfh0FxL9WGHn
		ZVOMautCTS9mPW2ozDncY2e0AEERO6rPfQK1n/78B8WCBrCLtypr0dJ6brZuSpgxFTAfweUMy9AF
		n/RA6UpbGshBdnOnlb3sT4M61Nt5T6khUp1nrAM0HboVq0FCpCrDOkBRATcwxD1ucpfb3OdGd7rV
		vW52t9vd74Z3vOU9b3rX2973xne+9b1vfveb30oA+DD/BN4QRYxjgr5eQ7CFTWw02Wg7oUZ2s5cd
		o2Z/i86jJnVaICJsXSxjG3xeKXXIoYiEGEQgvUC5CFQuAnC33OUvh3nMZQ5u1sDZ5jfHec51vnOe
		99znPwd65hDj4Z8BgUcTuU8htpFwYQ+b4Q1PE5tDXXGqV73qEBf1dpgcbY1vnE8d/3jSPaFwxPUF
		pjIN+nlqnna2t93tb4d73OU+9zjLiDKXErPR10A8Tm1iHQpf+NPVHHWpY73NVp+R4S8ObRs1SzN3
		MXrT1+CJg0dn6ZMu+5pJhfa4r53unwd96EU/etKLXjFEtzNEOn6uDm3DeIDHvOAHT3itj0rxt392
		7bXe//iM5wXyTS+XESgBcukAG/MNb2sa6e750jff+c+HfvSl36LTswfvGhf2MoZ/n4oofRMJh73T
		ZT973uve/Oc3P+9tpJnH/x74EdlE2LmvdOM7HfnJj+kWPs/86fff//8HwAC8OU+7u+vDPj5Zg2vj
		PnShBE9YhiYIv9gbP6hTvwq0wAtsPPZrP/d7vyZYBk/YvgUshDNYg6bDDgoTMtDjPwFkwRZ0wRd8
		QQJ0NgM8QD1ogk0IQRFswAfUhQgUP8jTwCAUwiEkwiCEPA4EPl1Yhw8cPuIbE+MJvMxbM8CgLf1T
		wZiAwSzUwi3kwtGTQVCrM2mLvGECQSeEC0o4AweEwP/3i8IjdMMiLEI3lMMxfD8l/MBtaMIF7L4G
		ZLrYI5FRqULRW8EufL4dqIBIiITx2IE52IHxQERJSERClEQYNEREVERGdMRIgESr+cIPe4+7aLoa
		ir9CMMPuI0U03AQeZEM2nMNWdEWvW8WvW8JNOINtaARS1EO42Ibvgz3sgLpLEzIrDL1BnETSM0Ty
		yIB/qIBGJI85iMRihEYAPMbxSMZlLA9nrJ5OrDPHA8WmawIjOIM8zEVTLARK2IY0NII1+LtYZMd2
		ZEdd8MBN8ARPwMNbxMVxZMBfawLgYzgKW5hNG0YsdBMAIEiCdBiDVC+EJA+FTBWFLEiGhLNpJA9r
		bMb/Z5S7hyzIAsjIaORIRawA86DI8cDGbKw+68M7x+u6DlyGcLxHfCTHU9yGc5xHT9gEIzCCZViD
		nFRHCOxBeGwCnVyDZbBJeZzHM6hFSrDHlsRHUixHNeTHp0uTpAHIgISJN0FIiDwPAGgRrIQYrOTK
		F9FKjQzLqwzLm5PI8QhJ8RjJiyRLrdzIjuTIsxSPtCyAtcScvmKPrGOyDaTDclkGWhRHlxRBpiTM
		wjTMwxTMwSzHM/i+fXxKX/zFSwuyt2o+YjQPhyzLrMzMy9zMm/vKrezMz8QwuSwAurRLuHvL8UhN
		uCxG0jRNiyTJknQ2vVw/30NCYbuDNTACemxCpUzM/98ETrhgSjT0hHT0QSDMjqiUyqkcPcssD8xU
		zY18SPGYTup0y8ysTrHETK6Ezu0sS4Nsy+vUTvG0Tu8cT1RxTWYUSdiEs+zMSO+8zviMTtFkTQFM
		z2tkz9hMjOJasq1jPzdcxRoSSk84yqT0zeAcR8M0xzRMxXVkReQsth/DNA1KDOlzzoX8zrGMTuuk
		zg3VTrHsUA4lSxAlUQwV0REl0fccyxXl0BRlURdtUTi5z4rMOYxc0dTEyA+VzhytTy2c0fXMObzM
		S8brva67zQ70QCOQR6OsxZikhCdthCg10EKQ0ic1x5hkUprESQeNRTlkv8Z7uKTJv1eKvgv10BI9
		T/80rU4ULU/59FCvfFEUldM4pdMWndPOfJMfVcv8rJ4dddPnbEsdDdQepcSPLI/X3DkhzUu93Loi
		NdIjdcdIlVQTnMMgBNPCizjK7D8zjdHufFEQndMNDc82hVM7vdEdNdVUddE1zVD6PA89rUs+xRw/
		/VDOvFFBtVFCLVSQVM897TmJsThGPUmu+89XNNZjRdY008DyC1MxHVMy3VSBBMsMVdVQhdFrLU80
		5cxqDc06vVY2PdNsjRNYPc2EJMgbuAEsUNd0XVd0ddcboFUVBYB3pdd6fZN6xVd6vdd85dd95Vd8
		9dd/1Vc3EViAfVVDnchejdWfiy/+dJVtzEA4lNj/iaVY8jO2Y8s05pw+TsVWa73TbyVP8PzUN3VT
		j/VWk+XWU5FLZYyEDKBRDHtXdZVZLEBXmcVXm4XXcy3Imp3Zdi3YnwXaoBXaoSXaojXaozVY8VjZ
		Q3RZIA06b1Gyh8W4CqzYqk3OC9S9qUu29GpBjsVIeu1Zdw3PFc3ZmJ1ZdHXP1bROd11Xn8WCnUXb
		TxVZnqXbmoXbnJ3PsgxaQ7yBF3FGoiXYep3ZAyDcWzBcwkVcwsVZm8VZdjXcW0jcyCVcoJXcyo1c
		yrXczMXczK3czeXcy/3Zz+1cfCXN8yhXhoXaqJVaIsXA1nXdS81ard1arn1B50Ta28Xd3NVd3eXb
		/4L926M9D3oV3c/N1+ElXnw1Xs4t3uS13OVlXsl13udN3OiV3gOo19I1j9NNuySbM4hDv+8FX/A1
		PIl7DEIkxnp9Xs81XvUdXvYVXfe1XFSoAFRABX7dgR1QgUiQ3qCt3Crw3/8F4OpFXAAm4CoQYMIt
		4AA+4AT+3wM+AAb2XweGYANeYAhuXnc1xPtlkfvNX9DrsE/DvRAW4RGmuvAoxkF8Vwe2XuRVYeqt
		XhfeXxZ+XvpFhcm93vu9hgP+18gtYBbw4R8mYObtYSAO4uQdYh8uYCEm4B9mgSQ24iUmYgU23iNu
		4iKeYihGYitG3He9X4Uljy5uWtOTM8Qj4zKuuv8368gVTGHJnWAJtuAKZmA3jmM4TmA5ruMLdlc2
		/l8m5mMmluLMBeA+7uM/ttxAFmQ/buDPNeRDzuIIVuQ9ZuRGpmDOXWRGJuT+heRIJmR31UJNM+NP
		Jt8Y0VX+W+MBruQqvmRKxmJUTuQrrmQnduVMZmVHjmX/ReRUBuRVvuMpZuIv8OVfBuZbnmQelmVg
		DuYoHubErWRj/mVhLuRiZuYvcGZMtuUfjmZpRuZnrmYfvuZp1uNtZoFujuLp5WRCnLhzRmdN1dXx
		YL5SfmBwtuRWzmV4FmRcVmZZPmR7NmV6HmR51uYqiGRJFt1Trmd9RmBrvmZmvuVv7uWE9uWFJmb/
		gEZoh4boe5ZobnZobG5khp7ohK7ofW5oih7niA5pj/Zjcu7bjkznlabddV6RdkZXHi5pY/7oiL7o
		cFbomrbom45mPvbnnZ7ph9bpfebpnB5pai5qmvbpny7gX36Ep4bqqH7qY55lLDZmqX4Epa7qRb5q
		qdbqCe7oL8Dqr4bgsB5rqgZrjHZqr0brslZrXz7rZs7iLUZXl7br5ZPWPCbqjJZrVubotxZnvybp
		sO5pgR5swC5swbbooDbqS4ZmkUbmVQ5nrH4EF7Bsthbqrb5oYKZsqG7rI+bszs7qvmbgjhbt0c7s
		0n7r0/5sq17rzm5trn5t2JbrYS7nu8bttuM//4sObcom60mW7dme6s8marPG7NSm5eCG6+PW6FZW
		brFm7qN+7rju61kuaVawgOzW7u3mbu1mBWxm4BDAh+4mb+7+bkkGYPEu7/W2gPPWbPVmb/J27/Ae
		7/ju7vlOYPi27+3G7wLW7/3O7vmm65TO7QIHurXTawSuAuGmbeQGbQaP6tjO5N72bdJOYNMWbQnf
		Zgqn7siecAj3bK3u49C2gAAw8RNH8QDQhBVncU3IAnvogBiX8RnPgha38Rtv8Ref8R3vgBrH8R9n
		cR3ncRn3cSD/cSEf8h43ck0IAFdwBU2QgCiXABrAgCqHhSvHcljAAAGQ8i738i+f8irHgCzH8v8t
		B/Mz73IaYAAkllwDd3OfYz7exocXcPI6t/M7f4E8xwdphuApyHM6v/NAd4U/33PNrgI/z3NBD3RC
		53MGRnRAV/Q6Z3RDf/RIt/NJ7/M/t/RAx4es5uOufmp+eAEdgIRSN/VTN3UfUHUb4AAvIIFXh3VY
		twFVV3VUt3VIoHVWd/VYj/VZp/VbR/Vcb3Ve73Va9wFgP3Vh33ViJwFfr3VUZ4VcYAUBEABWsHYf
		YPVhJ3YvcHZkv/VsX/ZY5/Zf93ZUDwEGWHPbrus3Z3eci3MFX/AvmPMUR/Ejh/EkV/Ilx3EkH/Ii
		1/ccv/ck9/d/X3F+5/GBJ3iD33GE//cXt4f/gH94TvAHqXaBPLeBEcD4jA+Fjed4DvB4jw93ZveC
		j+eAMjD5k0d5ktd2Zn/1kf94lIf5MlD5kN92ko/5lCd5mud1l/f4mJ94DKCH3/5w6D7t4W5u1yb6
		on9qDrACDGBzGybwdpd663n3d453FxAEQbCBred6rs/4ry8DnYd1Dtj4rzf7s8f4sGf5Vyf7UED7
		t097sWf7sod7tFf7tW/7urd7uSeBvNd7sw8Flf94K5j4qK74F7h4jef4js/5tRd3wcf5mXd8WOf5
		lz95wV95x6/8nr98wed7yod8ky+GR8AADtDwzQZxoz/6B19upX8EDnD6Jh7wqaf96ql6/11u/0Gg
		e4xf/M5vdS/4/Mq/ed8H/uC3+eGXeZAH/skXfuT/+OJn/uMf/udffs2X/pvHfJUPhSnIhae2bMu2
		eMXfeOKv/lc3g/NHf3EH/uzP+fInAfRPf8pff/ZX/nCH//NX/83HfOiH9fs3g/wHCA4CB3Kg8AUD
		hy8Kv7Bg8eYhxIgQFy58ZPERxYUNJXJ8mPHLxZAWF3LA0LDKgZQqC7Bs6fIlzJgyZ9KsafMmzpw6
		d/Ls6fMn0JanhhItSrSlyipKFVoUFOop1KihCHqpSuIqCTNasWL1QlBgmbBlvlb1wlWrGa5XvX4V
		O5aqVaxo1ZJgS9At2bhX56q1OxAvXLNyt//2/TrwiyBBVhYzbsyY3ogXL1xQrizZxogRUfGWVYv2
		c1quZf0KHO0ZNOGuZQ2bPos6tOqqrDu7Rt139UCDCPNN6j2po0Tfk/IRL26cuHDgEYUfJ+7YSvGS
		J1UeuGE9KPbs2rdz7+79u02j4ociTam0ClMXgjJLhTqwdVbbsQ3n1ftatGz672nHB42f9Gz2ybdW
		fvpxAN998331BT30QNecY5C5MllllF3G3lOACTbYa3zFNhp/e3XoIYEghtjfiLeZqJeII8JWYlkU
		sICBF751dAuOOUIk3HDH8ahcRzw2N6R0LCilknU3gLckk006+SSUNI0nXnkHnMcUPhZgKNX/fhui
		6N9/pIFY24Aw1sdiimGe6WWaH65JJphuDrTYkMc9IiGFlRlyoWahaHiai6nRNWiLgRJ66JdtIgqo
		oYeiwgIsNSYX0S0SVcojppn+BuRDmtYZnUnTUXdAlKWaeiqqqcI0pVFVLsXUZVKZMmuXH7SYI45o
		4WgrVnj4+mtZHwhra6Av1rWil4V2qKKJdBXL7JiMLhumFyxYYw1vvTV3EZ6UGfLtni9gxmVp0j67
		KIfFCrqoup+hm666hKJSBSwHTEqppZ1qqimny2UKIWNFGolSSkmqejDCCSvcE6tFuYoerOJGZUpY
		HOARrLCgYYHaLWjxSsLHIF8Vcsfxvqts/6Mnt7suuysTWsW1mBrHrQ0Tggsun+69B+/KJJrbs7Fw
		Ah00z0BzNW+9mOK79C2TND3JsB/0JnVvTzv9kI4Q4eppcY6VpJCo1C08NtllJ9zwUSxR11DENkBF
		MUF4cFUyWlgkcvfdoJVMF68ffFYy3oFPS+hrgeM9+KCFG54I4s6itjjjCXIVs8zEXSRIza7c/O2F
		fopVLspDiz466aUPjcoB9aKyOuut44oj67Cjcovrs8d+O+2r55677q2jQgHwwBczvD/Fs0KDIWAb
		OarZzTv/PHhok6e2SmyDFOtTFL/lBbFaAX43FuHbHXj4HdJNtxnjQ3646OsL3r77ecMfv/+LB1zL
		UUPFNZX55uGO+xRVima6ARKwgKJDnep8V7sF8o53trMd7SLYO9850IGrC17wilc8C0iAFRoh2Eqg
		J8IRkjAn0jtFlQ5gvUdgLxSm2I/f6uY+9eHNbhz7jPjCF7/FFWuH7uuhDyEHxCAaDjX2s4ZEqjCK
		/OVjf67Q3OZa2KV3me5QVSRc6awItB2k7gAY/CIFLLi725HxFhT4wBnTCLxhxe51CvyiBjfYQY0M
		LIQlvCMe73jCFK6whS88kFk6VkP3AWBxNATfDImoyEUyspGOdOQNdoCCa1DyGgcYwigq0BDGYO6J
		/ZNiaVhExZ6dLFEpQ5fRVKYuLtYLjBj/RCMGxzjBCaKxlmp8JfAsqMDfDa8YcfQHBz2oPBCSKo/G
		PGbz9ki9lPRRYgC8WCDNEDgAFIWaRLGmNU9RSMMdEm/ZRBsjTziUcIqTnCd0XyRRMElKDkEYGGAA
		A1jAlE5C8WbYC0wphda4UZ4rn+3KZ+hAg8AqCK+XBv1AMWKZSzLqLniwPGMvETo8WD40jLvs5S+B
		2cGRMISYyPwoSBGmzAKsTZ7Xe8EIPmexjHkTAC7N5ku/+dLxyHSm4rwpTnOq053ytACSzABQhTEH
		BnSAE5xwxzxr9oJPOjMwXkKWKPsJo2bpM05TjZYA3UUtrAYULUirgkHDWgxfRc0JZr2F/1nPmqO0
		OkGiYzXorw661rM6Aa0S1aAG8qqBYHJ0eXYMKWAD26SRljRiKa0YBwaTCJ4ytrGOfSxkGVsAdQK1
		siW1CD2U+q0K3dOpIApQsho3GtD+zFijPVNpmUXaqpoBaSyIBWxhm9HixTYWbL1tWmtb29n6o7a4
		xe0+9qFXvfIVIx0Vm2CTq1zuELZ6JmUhShEbF2kuNrLWvS52s3vTyaKgskC9RkQsl9kJVchC4kKs
		Zw00RZ79R72hZJNVcaPeEJVJvgai72seZZLgBjcM/v0vf/nr29vWNsD9/a9/DbyPAQO3v8Pd60aN
		69eULLfCFvZJc5n5XMmkdD97uZt2Q/8s4hFHlrvezQAlISLeEZC3vJdBr3s5ABiyvAtAMw4gumys
		Uhrn2DA33hmi9PuFfSC4yAAOsG51a2AjG9nASdatfx8MYVb01aMXvjKWpSS9h1WEw28B5IerS+Ix
		k7nMUzKxd1M8EQaxmBvldYGXYyxjt9CZx4fyC53rjOM73yXPOwYdn//iZxgfCFEywkCDmMxkJys5
		wIpWNKMLfOAo59UFxQWblbOs6U1n+FUK8fL2BENdM5O61GNGc2XBGxGFSMjN5eUHPwRhIBv4oNa2
		9gEkcg2JW996BMniCgdozWtc63rYtfb1oYJtbF3v2tjIJpSyh81sY/vg2XSZBAUMIQD/AbCi297+
		Nri7bYiTnKfcXzBECMKtbnCPe2DnaYg8DRHuXEhAE1Q27nn+uul9W7jTngZ1KMNs6oET3Lqo/q5E
		WN1mkTzCB6xwkBWuJXFrWAEfkrk4xjOecR1QDlMV1zjINc5xa2jq4yE/+QtGXnKLozzkKs/UxyUg
		85nTvOYzFwAGMACLnfM85xiggc2DbnOc65znO/c50G0egBeEQMITLia/o75cf0PsCxz2MFpAXPCt
		cz2nB0cxR75ghYUznI7wXggr8KF2tVug7W5v+9rXHgJyl3spPoh7lt7udrzjY+7urvsX7h53ve8d
		736v+5UEv3bCw93wdAe84tnOeL4f/x7x6Il83glP+cebO+2Zd/u9FXIk5Eq99IHNsJVedXWB4GFY
		t5imTatZ09nHfijf7Drud1qAIESiFr7/PTyD34F9WCEUruAGRzMC7+WblCIMDwlF4G35Kpy9Is9P
		PkM4/27rMeX6xlXe38td/e5fP/raV8r4QeJ984d/+81Xf/nNbvnxx//pFDY9/kGKenOvviq8St/d
		yFQ1adM1FaDtDaDtuVTuLaDuRQIKvISaXUss2IMVlIHafcTyid/yfUTZsd/0oR/3kd9FKN/5uV9G
		dKD8fWD6wd8IeqAKhiALYl/2tZ8Gvl8Mfh/4vaANYqD95Z8PItNIkZR5XIlkTAUgxf8QACaCAB4g
		AYrH7RkgFDKgFG5ZLbREZe0AFqKCE6BBLDBAPnBAKAgC+GUg4jHfDvIg3Y1K6lHfCn7EDLqbGrrf
		GZJgGo6KHLohHcKhHYIgDLohGRLTELJhH6KhHtrhBuYhCBnMDy6iHm1ZCgliEXYGEo7PEjbhEz4h
		EyLgFG4iqxRAFbLEFa6OE8ABF3phVcgI85UbddQd8+HhHwJiUtyhH0pfvqnhGgriHL6iLd7iIRKi
		KtpiDeYiLY5eHMqiL9ZiMeJiKhJjdVwHIz6jCAXhHlaBDuhAoV0FrngTAsaUAkahUVwiJ4bjeHgi
		KAIVCvwDOsIBKTqBKXoBKiLeLpb/oRkuIzPGoxzO49/t4ire4zz+oj7yIj4OIywmozL2IzLqYzDi
		oz/ao/stZDMqCTRGpPNIYyyehzV4yfcEoCZGISZm4kaKoziSYwFU1jmm4zoywCRcxaM4JELKo/b9
		I0HyYfvB5DTKITzSZEXaZN3hZE7K5E3ypEvOJFBanhoqokQeJdkoU5Lso1JYg1pkpBJ+ZBNOJTg6
		IUheJQp9Ikmi4z+oIxqwY0qSwLwcJE/e4k+WJVMSJVrW5FmupVnupFv2JFzG5VuyJF1SR5I4I1Lu
		5dk44lIypVNiRY4YjjbVXgJiU0xZpewZJlYyoEhuJToGQRB8JUqqZD0WTF7ewF3i/2VmWsdmYmZn
		fuZDZqZodqZnfqZpaiZqmiZPZiZfvqZI+eVpVmRgokjgNCZuhthjmiNXSiZlhuVYFmVqzmZZDidp
		rqVx5qVbJudfoiVzEmdrPudySqctdiZsXqeqBKEQ0ma64E1ufid27WYGlGRXniRwXqZRPqd6rid7
		tqd7vid8xqd8zmdyYqd9oop2TmNtfoZ3gqd/PpZ4kqdXgqVlAqJRwoR74kSC3sSC2kSD1sSD0kSE
		Sqhr3qeF4qdsqiZ3Fspt/qeH6p5WjmdJSuZJ5kOBEtOBXqiKriiL3oRSQqdFdmd/fiiNihM5mqM6
		/UMQeGUp5sMpFqK+taiQDimLvv+oht5ibdqm1tUokzZMAYBBd5HkDrTOKHbAF05BLkifGhIpl3ap
		hVJkIDYlfFGXmDWpmbZKFIDBK6wpmwYfPBVVPpQBP3BDBjKPl94pnh4lmAai2I3GB2RjS3VjYSbm
		YdLeYnbkmZLYwVVSwhXf8Q2Tnc4ENwJAnlaqpU6dIy6TlcCb2pWBJMpQVBrgEo7qNkploioqZaVZ
		2DkqN9BRpsmES12qrM4qYIEp/72AEfofqFZiqYpqr3rkqZ5aqqZawomd8bUqpJJeTMQqrTars5bQ
		/hEhSoXS/1GiVMLUr1qiqQarbg4rwq2a2LVZ9AEiTTCrS8QUS6BrulLqSxWAuT7/K7yeyg5UQCRE
		AkuAQQVUABi0RL1Kgr1GZLRCzOodiOtpozdO5aB2I6keLLd2a5Smmqp5BJsdX1/V0f3BKqW+hLky
		K8fGaru+a7yGrJPMK79Gwg5Egr66xBz8KzRS3UIMLPf0h0Z6I6JiU7YiasNe19ep2RusGMW6KgiV
		Kzeua0t0LNG6a8aCrMgu7XeQLEuoAb9WgMqy7DO67KdF11vITZjxKsJq4sICa85q186GVxO1Gg4i
		o9B2ZvgkydreQNu+LRZYR9vSJ93Wrd3eLd7mrd4aZ5Y57Uv4bQGsrET6G0UAHFmFmRIypqEeKuOG
		Lao+7Lc+hM8i3/dZLNS1RF7O/y3bxq3cci7cdi7o7q3oji7plq7p3q2FAW5LRMEnsoTgAmymxmKX
		RZeHZcWSOq6Hjq2KlS3ZSRgxuoTaYoEa4ohKEO8BGC/y3kJKGK9oNq/zPi/0Rq/0Tq8+muZyqa7r
		ZsDUDm7sOpdhfdl03S7u+qfuSi7vUmyVBS1LmCbzFq/yui/zJu/yvi/11q/93i/+5m/zVqhgYe8/
		QO32wi7a8NGGYW3A2W6Zji94lm/Pni/lfpD6KmdLfiAFV7AFXzAGZ7AGbzAHd7AHfzAIh/AH/mNe
		JpfqZsC+vsTrtmz3atj3hprAKfB/MvDknu3vSnBairAO7zAP97AP/zAQB/FcIv9Jin6U6qawClMt
		I6JeM3XYAY+aDJOvt6JYxNawqxJxc5plQG4xF3exF38xGIexGI8xGZexGZ8xGovxEJcwYAHuHPwD
		Fv4Dy65w1bawp0GXE4MZAkexFEMuFYOr2TpdImYxP6axIR8yIieyIi8yIzcyPXKmXhqx1I5kvlZy
		BWiv6yrxIhLuyxqwHkMxH+cmA7+BQozdo34QJBtiG+IhK7eyK78yLMeyLM8yLdeyLd8yLueyLufh
		0xWxMWFvTNDxEtvxvxkwWf0pmTJm1x5moQoqN4aywU1xxEosq17xP17JLmezNm8zN3ezN38zOMNy
		2ATpL09yTQjzJhNz1cFstc7/LMIq7jd6LTRn1yiTcjUnK0M6X/yFMz/3sz//M0Br8/qZ3yBDpCRj
		4UxgoQpo8g8G7NWOwHu0c5lWJcPK8zzrrLcy6qrd8zgn4xc0AEiHtEiPNEmXtEmfNEqntEqvNEu3
		tEu/NEzHtEzPNE2zND5frBEjtExg4Q5gMgsPsKbeKkQf4V7YjaneHqHG8zUp80Xr1KLy7EOwQJyq
		XZ1O8EfXNFZntVZvNVd3tVd/dU3fdCl0AQiUtVmfNVqntVqvNVu3tVl3AS5Yqq1Ka65yz2CKWUci
		9cHmdVM71lNDdc96QRn4g5Za9VXTw6ARmpwtNmM3tmM/NmRHtmRPNmVX9mIn/3ZYgDQqp0Qr8EIb
		EABoh7ZojzZpl7ZpnzZqh3Yb9EMrVOqeQiKufmrWubNiQqFeTwnO9vWWSTNg+6g7AqlHX3ViWzZx
		F7dxHzdyJ7dyO3Zia/YwoQQMoAABVAJ1V7d1Xzd2Z7d2bzd3VzcBtAEIuHambmcgVuM1kgBUYqtS
		2/Z6v7NuSxZvQ7WJiiVZBjdI+9ly57d+7zd/9/d++xlICzJ0J0J3F7iBHzh3E0B45+lrl9tFYsWf
		ClKgCmrCzl5tF+p7w7cfV9I0n+dA7uFC3LeevRdUlbiJnziKp7iKrziLt7iLvziMx7iM95lbBDi+
		HQkMEDiC7ziPd7eCizdQE/9yjMpoAme4FO6sRndKgcIkNgu3W/wRIHkBNK0INP0KsLD4lEt5VVi5
		r0BVlpeFlYPIxVQ5l8u4mZ85mqe5muNZjTdA+h4ADBTAO/Q4ndc5df84g2eofhJ5kRv5AiI5h19D
		FXg4k3uaiIsFlBP1ooSMyLxL30A4pHMFo0e6pFc6pD+6pQOUpm86p3e6p386orC5WNi48qREnL8D
		qqe6qq96qgMAq7+Dq7+6rM+6rOM5nhrpnnPojPr5kcc3hw/6kl+zoTcAnSW6/6HLpE/6oGB6yDC6
		sttKs/PNpY+MtIO6tV87tmc7p4t6Zru5IMO5nOeAuI87uZe7uAOAuecAuqf/O7u3O7vb+p3mJ2AS
		Oa9zIqB3eLAb9iOAtOeEhbHHrMgIS6Qne8CPzLAYPLQ3OqVTu7RHO6Ewe7Vru8RPPMVjO7eXAaln
		n1LEubuzu0uV+8d3vMi3O7x7qbxvqJL2eb133b0vR77nM0jw+5PDRd9AvMIzvMDfPLMne9Q8O6Ur
		O84zfKZXPNEXvdEjyq/MyqyMurc/N8ePPLmH/LhLfUxNvbpLPdTnQMl3Ka7Pu66L78qzvK+H14kK
		O8TsewP0exn8O6Y3es1Hzc9b+qM7u1oQvNADvdsL/cIfPd/3fcVLOR4ofZtX7MYXABEcPuInvuIj
		PgAQQeMffuM//uNDPuRP//7kLz7mE8HWc2nXozx/7nrYi/2G9/aP1ndFhjixzzwM3X3QL/vC27zD
		733P5zzQf0zb773f577uf/qWBz6dZfx0xHnmD7/jFz/lW35MUT7jEz/mbz6Rdj6S0gWOqE/CHipM
		JTWwMnXoU0lGJ7nkcgCWFjYwDnux0zzr573r673NKzzdDz36V7rt67387z791//JlMUL/X7TZ5+p
		Gz7zLz5AACBCRKBAggMNIlQ48CBDhw8dVgJRgGJFixcxZtS4kWNHjx9Bhsx4imRJkyUtHlB5oErL
		lta8kJBJ4pYZm1gSJQJgcifJnid/8gQQ9GfQk0eRJlW6lGlTp0+hniyAAv9FBqsZrmV9s3Uri3xl
		+HFjMZZFlZVnWbb8srZBgzJv4ZriMNcLHi937eLVW/du3755+f7dCzgw4cB7/Rb2mxcw48SGE0eW
		PJlyZcuXMWfWvJlz4rlz4b5t++jR2rJmYRSAuPqhwYILEzaMHZv1Q4kicefWvZu3SKcpz7r8YsXv
		B5s2E2E5RbSkUZ9KnT+POp16devXkU6tejXrNa5bh4dyxc10WbTBq6z90jZ0XDzvFwtWLJnwe/iC
		Ddu1b/8x/b/8DytsP8g6K9DAAxFMUMHPOGivjNFK+8KlA1KjxcILMczwQgA27JAWDj0cykMNSbTw
		tt5QTFHFFTH6raLgyML/B58y+vqAhOPMUI45n4YiqsejnBsKuyGJLNJI7a6yyrvv3ghvPPXGMuu8
		tNJbzy0HGcxSyy257NLLL8HcEo8wySzTzDPRTFPNNc108MEGIowStS1KrPPDEUH8sMc7OdzTThJP
		ZFHQQQntyEWKVnIpvRdeCIUuG3HUkSekojMquuWMzFTTTZVCMskluVrLCvHIK0/K84Sz0s232GzV
		VS7HfFXWWWmt1dYGV20LytMorOTPX4G9M1hAJyrU2GMJPRQ9tRgd4dGZbsK0OUqpnbRaTrHNlkhP
		uWNS1BGehPJUtFJlb1VWb01X3XXZbddd0M59U9yVYPB12HszzBNfE4tF/9bff3dTNlG1vmj2My9s
		vBEnnazdccdpIZZW24kphopbJUFt8gt6wOWGNFOnpNLKtkgu2eSTUU5Z5ZVZbtnll2GOWeaZaa7Z
		5ptdBlmlep/o2eefgQ5a6KGfAIDoo30OFOClmeZIYJHXMpguhD+oKSedfmwuax6F1HrrrSsOW+yj
		LsYK1HzyeYTj8SL8IsqQhcNZ7rnprtvuu/HOW26dKWwhB6QBD1zwoXNood+mEU+8gKdTLfiFEdCl
		+pZbcBrb8ssrLjtjtNXuuG0JxyWX4LVIK9109VBPXfXVWW/d9ddhj1322Wmv3fbbcc89dtN5T/3t
		lVrpp4VKiC/e+OORT/9e+eWZL76FflpRXPqmGa8y6scjj+nGnDDv3vtMNf+O87U9btu8kKHWXf31
		2W/f/ffhjz/+389qpQsQ8M9f//3579///wGov+hNj4D/qp56HtGsMhxMe2bg3vcgGMHphI8r4/Pc
		x9x2qhtskFxkYYH8QBhCEY6QhCXMnQfPp5IN3qCALXQhAZ92gLGQToEMlIkDEyFBHe6wU1RJElbE
		lzbylc40GlzhslCYRCUukYlNdOIToRhFKU6RilW04hWxmMUrTmglK2ThC8EYRgM25UUrmeEXEoi9
		BXLgLjd8IA/hyEMKbsWCbDOfEY84MJdokY999OMfARlIQQ4yiooalxf/xZhIRQ4qhmdMI+TW2Mbt
		5TCOlZTgHN9QR4+hjosHKIAXUWVIUY6SlKU05SlRmUpVrpKVrXTlK2EZS1m28jyIXOQtcRkwMiLK
		jB9EYw2n5kZKWpKY3dPc2YTouV21ZCUUASX6ZhlNaU6TmtW05jWxSUr0HcCWufTmNw21ywIMDIEK
		XOB7PlA1HEZMKELpGteA8s5izpMkx/zOWoYYJ16ppCJevME2ARpQgQ6UoAU16EERmlCFLpShDQ2o
		P8EZUYle5IDqMedc8DCThWEtSBJzWMSKQk+RYlJjVugY6lLIz376858OdelLYRpTmc6UpjRl6Rcr
		8goV7JSnPfXpT4Ea/1ShDtWnr5hoRKtnvYtyIKMyWRg7pRVSqErMWiItJklFRaplogUjK8TCV8H6
		1ZuOlaxlNetZ0ZpWta6VrW1161vhGle5QvQiaUgDCuaJglek4ajfTKpFH3ewhOXojZaSDlUNG0+r
		0pOkTRpVuNyW0o8MZa6VtexlMZtZzW6WszfliApQQIAfjpa0pTXtaVFrFQKgQAV99WYMUyU1Nqaz
		aldjZ4++htuqAmmxV/Uhd7Ryz8eWin4q7chQXJtc5YJTBadI7XOhG93RnqK1y1UkbIUjtbsM1oG7
		9S5Il3Kp3l7ytxjL2Bu8UgYZeTB0kwWARXBrXfnON3EqEK108Zvf0v8SoLr0feGhxqkSRTnOUWxE
		GI6GSdXvehS8hx0vHC/WnfPmwwtl8AdZQudJjyCXIhzmsH9BHGIW2Ve/JTYxf0XcQgDDaCyMCkWN
		0nmcq+HWUl3TrdfkCbYHy7G85mUShb1AgdNk2L1excIGxdpZJS+ZyU12MpM/e9/n0tjE+kVximEo
		zgDrUQc6YCO0kPPGHY/5OscMLh1lgopOcnODGvFnkm+QZDg/mc51tvOd8dzmi5B4yj8EQJXxe2Us
		S2/FenyJ9m4Y5gSTmdFRMXPGJpFmZp5lhV1l6VdXMjmVaLqmnfb0p0Edak97tiJ8Tu2fk4RqQENX
		0INOnIvyKGCXWGP/JjeSsZgbnWsy9thsZ35DpEmg5tBV2iL+zPQtjr1pZIua2c129rOhrcJumhq1
		qk71VVSNatxiOwM9im6rXU29XcZa1lWgdaIVvWhdrzs7vJZwd6oAbGFP6SLPTPZKaPuBbO6b3/32
		978Bvk2WtnYHBTf4wRHeo4MDwOAMLzjDHf7wh0c84gi3eAH6G25xM8WZHFzWuW2dbnaPPCmPhre8
		J83VlXp8WQB3+cthHnOZq7KWXiS4xXG+cIrvAOI8bzhuJd7wnF884xpfGoC3XG6QIxjXJHf6o7+D
		8mGPteVVIOTVsZ51rW+d6040JKVXePOhD93hPe+5z4WO9qCPveAY/zc64pAuOnODWdFOtztK3N2d
		qEt66ixFYtcBH3jBD57wT1xz2AvwD7avPehmR3vFy77wxbe96G/3F6xZrnS6U26jy9Gx54uSW7DR
		+O5jg3oF+X5Iv7P4jCZ0/ethH3vZxw6FGW7tP3Cfe93rHgC77z3uf/+P4Adf+MAf/u6Rn3u3W/7o
		4848lUAuk5o4cGEPU/DDpKrg0oeNW2VcCR3vIuTD27vcszf/+dGf/hEW9wC3T37yacz73BMft8Xv
		fY/en/zlM3+MHP9k5hUl+qYPOXYC+3irwRhs+yzHUwpgCBxwCEZBEhjAJfKBA6YgFzAM7MitcdCI
		d4hI/UAwBEWwhP888AO3aiVU4AbybwVZcAWJrwWVr/L4r1AKrdwObSaMQ8YKsKpuDLEQsAcVcGK6
		TxgqYA7AAA0U5SvCgr26aAPVQm+gMAqlcAqpsApthm9SEAa1EAZfUAv3bwaPpQbLjzhqBMGUA/Te
		KftIj2suRbyC8Eh4TQU6AA6opAqGi2/IL26scA/5sA/98A9jBgszIAgIsRAN8RARMREV0RABYBEd
		8QvBkAa1jPVkhEa2K+Ry5AATECggpg3fUAh57QA6IC0mYRKcpFQiC4/0iC2u5Fze5RVhMRZlERbj
		RV6KCAV34BoccRd5sRd5MQN2QAYjkUVqcMBcbGpykLA4EQFvqxP/F+wT4XC0vg88TvEEp6RcWhFL
		ZnEbubEbvRFNzkVXTMUsQOEVUACXUMCuhjEMxanlHMdZDAxhJmfGPk/0fESqgBAaN2UqpLH8huOk
		5gVuCMZc2uMbDfIgEfIg3WQ0+AYUiOohITIihwoU1pEd/S/pYiuwkLFqKEfd9LG3+PGHVnFjLohv
		REc9CBIuGERBWLIlXfIlYTImZRJBGMRBIGQtUs64KpL5/up64NHAQq7pPnKx+BE4ZE09hsgalwUl
		s9EUnHI/ZvI/7kMmGwNAWJIxBkQ+onIrubIzajI0bjKDVG4nebId/fEds0eYhnLMpgIjzuKMklI9
		cnIkVSUusgTR/2pNJhImL/myL2ttL0kAMP1yMAlzLwFTMAkzMRNGMA0zMR3zMSEzMiVzMimz1rzg
		K+EiLMdiLMny7SrKJ9NyktZyx7SDKkwTBUpxEtDGCqwgnwJS7pgyNORiJQcTMScTMW2zMv9SL/ky
		N2+TN/NyMXVzOImzOI2TMC/zM9pDMyWrMy3vMx9pjYBSNEcz13LCJkjgLkDjguIkw6DmEdoiFOxy
		JS8xnfTSPG1kMWkLB9dzN2uzPQMzMA8TPt0zPt/TPHkTP89TP4UzOHHwOAE0QAX0MZMTXjITTvQp
		5ZzzOc1SJRwJmKZznaqz0a7TDLIzOcuAO28xlKoEPBtAPN/CKf9NwSrxsz9LtD6B8z/98jDPEzhZ
		1D9TtDfd80Tt00VjNEV9c0B1dEd10z5E1BQOFIPkpJkW1OgayZeiM5IaSCgntLcqNDuVsyQ3FDbR
		KDzHk4EQRkX7s0a5FDf/kkZtNExvtEbnc0vtszG7VExVlEt5tE3dVDLrAg9EFCwRdBwPQKckMk/1
		lKiMqkhV5EhpSI0eRZ1ygsZ6oh51K2tGr0m15UlJIErZhpO8s3FScjaxFE23NN/4sy+9VD7zDUf3
		kz5BFUY1NVNDlUY7lU3fdFVZlS/xQk6Xs05T8QDKEa+KSa/4yk9RBFB/CXs+o6loolB58Fq0BqTk
		iVE1xVG1kwP/lMkk6bJS7/ISwxRNZbRaZ5RTtVQx1zRbrdVMubU+c7RVxZVH+0IuYlVIWUAlYAEF
		mGDV3NW0VksYdTUkoPOi8uKGKmdYNXFaDnUZkXVTlDU5pZT9zhJasfQwHANh4yNA+uM/EGM+IJZh
		A6Q+EnYw5KM+LHZhH7YrObZjPUM56VRImQkWEuFdTZa0qGtee+Mz0fKcJEkZmxFIviaq/PVfM+U6
		Z6JAAXJKQyk240JEAaQx8GMxrBIqIwMqq3IqhfZVp1JjmVY/pHJpEbZon7ZpJdZjsXYrMTNII2RC
		YKFdTzZsVUteVdYjerJlmepln8rB3JBmMSWxbLZIriYRsJME//bhM3YWdKBpILNRJROSTWKlGwP3
		bwk3TBYSTuz0a8VWbMGtbOm1QRvHXvHyFuZ2owp1xqoFAC7XcpNjbm3LKTw3dEX3KUS3dD+3KUzX
		dEnXdHGEBPLBHj5Dq5x1KevSTQoXTQZ3G3P3dnkXZA93mcxCcaVr26zC2ha3cR33I2JIhgALcn61
		jabvajh3o6pvbjW3c3PiqzyXc1O3e733e8E3fMV3fL/3OCwzdiFrSO0NG2uxd8nEUmcRft2Xd2tR
		HMVSJVJweK+t2xY3SZA3ecPpImlXtjAKDyAFRwYwR8KKesEqe7U3ObDgOCZngtNNfHHkgm+NfDEY
		g8m3Qjc4g//H94MtdB/u4m5BQ0bw0AnTAxBZuIVd+IXzBguZ4Bqgy3j514bD9n8BeCOKMbs08lfR
		6YBFGIdSd4iH2HuNWISROIk3eImZ+IKdeINn4nW9wApgN3YFIYUB8AlhuIu9+IvB2GRkeDtOrbSy
		zduwDY1vmNXIdodbZBJXkYCnBi/z8oND94MJ0449F48HU4/nlo/90o+vBpD7UpA9+IL70i+2RMiK
		y9josgNLcAQleZIpWXdKEIOUUuwWr+IkT+0er5OHYvIoz40f9yIx0iWmQAekkzwlKZCf2EIj85Vh
		GTJlWTJrOZZfeTBJ2AtMOAyyRPxSbvUeuZKJuZiN2X3YT5P/2Y6T0w7yfk7hPHnxIJGUedj5WsoG
		rcFLKKOOjTgvK4Obh9ibt7nWklicJwOcRdicJQOdCflC+8KKOYACYBeeGYSRVc+RE8WDjnmf+bmf
		Waf2zkOZx46ZG4/GGC/yRHkHppmaR0LLkg76zsQv2Nl8LbMvtESiyVmKK3pZWZmO21mRo7WV0Q2R
		N7pAD3ai6zZnLbpMKCAnyervCi+mZXqmabqPxu8Gbk+UmfnsCNqZo5ntFpqhKUqcyC0tYCJN+iKj
		W1elTZpLkpruKFomVlqbRRqDNxpMnnqkU9qdsbqqSVqqObpMvGDeODMPFaWm0Tqt1bqmv64JN8j9
		tJD+gG+u/+ePrum6C1cwqIW6Ig7FrI9aS1ZlS+jYL5saV9DlLgkUsP0WsR2zsENDsBM7Sx77oiN7
		ayd7JcmazXCq456vDmfus0E7tEV7mmoO8bbQ+IairlGb/vDv/k5br/d6cbSsqM2Nwiw7sGkTOW/7
		sukiMU06Xhh7MH/bFXNbuHd7sXtbt32XuD9jEtRMAy2ts6tutKm7uq1b5gTOn+D6tLm7u5EPtvca
		6TZwEqyhvK0AHxglvdV7vddbB8o7NeF7EqxAB9i7vtnbva0hvlNzvu27vxkFv/W7FPnbv+0bwAP8
		vAm8wN/7wNE7we/7vfHIzcgv2ii8wi38wl+KrtzOuzm8w//BW6jF+/kU5REa3MHVWwfkRJS+oMRN
		/L9T3JBWvMVP/MUHjMVbHMWHzJBIXMbTG8dJacd5/AVwPIWILSNuCsORPMmVfMlJjSJayxehPMqh
		/MMZGun+75rL7xFcwAUMocu9/Mu9fMu3PBUNiSy0fMvBPM0NQcxdgMzPeizOnMvV/MvZ3M33CM7F
		fM7pXMztXMfzXM+7vM5pfMT/HNAFPaV0UsLzbNEZvdEdvbMwQgV2YBClvNItvRCBsY1B3KE5m0pJ
		55IxObJy/M196dMvGaUGvSXIAnVA/XMwbJRWHYFAHdVH/c5LHZIjeVdqXdVbD9dzXVwiPCQefdiJ
		vdiNXc//NMKuzvGW0jFXY7uhTbnYRHx0ZP10aN2UYr3aTbA8dt3WU8cDfSfVvZ3Ve+faSynbTX3b
		RR3be93XP0fUiRzZn33eW8gh9/Te8X2nKJLe3zjaVw7LWQLdW4e95pJK9Pl1CD7DbP3W//nVFZ7X
		2311Ep5DD951Jl7uKn7gmdCt+b3jPX6HrXzlUAWFGv7FBRLiGV7Xc/zkrU7gVV5RWD7jaX3lr3Hh
		S57mObTlI57bh0wDN/vjgT7oyTLkRb7lDG/NYt7rkL7mUX6JYB6gSJ2Jnn6bot7plz7nj34ui1zo
		ub7rZ5DoORvgPVvna72gRCnhr35vo16UzL7MHT7tWR7l/9meoM7+7Qu+m7w+7/V+0MA+7OO+rRPK
		lBZK8BWK8AO/lAYf8acE7/e+8R1fvvo+7MXeoKiOoSp/oS5foTI/oTb/oDT88UE/9I8q8iV/8gEq
		rTwfrVL/rFbfrFq/rF7/50V/9ml/kUj/348993U/rWq/930/kW4/utUKJNqK+NnK+NcK+Yf/I4r/
		953/+VWM06F/+qm/+kUs+K0/+7V/+69L+rn/+8E//LPM38W//M3//CWR/NF//dm//UHCKdQg/uV/
		/um//u3//vE///V///m///3//wFCjcCBBAsaPIgwocKFDBs6fAgxosSJFCtavIgxo8aNHDt6/Ajy
		4qmRJP9LkoyCMqXKlSxbunwJM6bMmTRr2ryJM6fOnTx7+vwJNKjQoUSLGj2KNKnSnSabjvwHNarU
		qVSrWr2KNavWrVy7ev0KNqzYsWTLmj2LNq3atWzbun0LN67csU6boriLN6/evXz7+v0LOLDgwYQL
		Gz6MOLHixYwbO34MObLkyZQrW76MObPiuiYLeP4MOrTo0aQ9EziNOrVq1aVBp24NGzXs2bQ/r759
		m/br2qJl8/49Grdw37GJAy9g/Djw4cN1J//9XHlt5sKdn5aO/Dr25dRzz96tPPr21t29F9femrP6
		9ezbu38PP778+fTr27+PP7/+/fz7+/8PYIACDkhggQb/HohgggouyGCDDj4IYYQSTkhhhRZeiGGG
		Gm7IYYcefghiiE4BAMCIJJZI0okmkUggiymq2NSJKJ4i44ozphgjfTPCGOKN8rloI5A10iijjzTm
		ON+OQNZnpHpNSvikiFJOSeV9PL44kosoLrlkfFGW5KOWYW5Zophgfonje0aiueGa7l2ZJZlExmlj
		e2yCiaSBO3rJ35dR3qlmlYIOCuGQZ9LZZZyAjmgnZ4lieaiijQa6YpVusmcopCyaCSmm8F2qZ5qU
		6ueno30SimqqB5a5ppyPwvninlkS2SqZTz5KZ6S05rlprDiKueWuSu5pK6OcSjqrkHP6iuWYw+aY
		qJnH/y5bKaLMHglssr0iiy23eGLrrLZn1nptmdYiC+u2u67LbpDjeqtqvPLu9yqMRf7apKz68jpr
		jLjCqWy0/WqZJsFHDozwwMH2G6nB+i7scMG5fntwxbqOKye1/yrMcMYLHwxxwR9farCoETNsssgc
		V/yxyix3LGrKL1s8b802J9kqoh5TS/HIKMNM88V1cssqkvsmDLLESSNdKtDfHr101KDKOnTDtgp5
		K9BQ+7z01k467TTXFD8tM9Qyk51nzFrfzHbbb+Y8p7QT97x2tVH766iSLqMN8pBed+33u/x2bK/S
		fRf+88xB85xrl1jXxfW9Mx99dcuwSm33w+liHLaiJf+fHXis+WKNuNumn96ppkXHLTndkw/+Z+xz
		Fxlm3a5Tnni+g2P+OtJng24i3oxPW63ZtocctO7Fq011y7uL7XzyhkP/tfSoX+/249JmPHfZhntv
		tc7iB78808cn/Lf1vXO6c+/qU63rpq6O/Of57iOfPsnMg/9+4y4bv77ITc122CvgvB5Hq2GNCXJc
		she5cscjYFXuRgLzXLn+xzRlXct1LDMXuPAlOAtW7XIau9oGcdVB0pUNfxfc4PSG1rx6NQtl6opg
		rfTGPXWFkF0oNKAPUbWoCwXxdKBa0BB/2J8jInGJTLSPEif0xLYVMUFRbOKP1GbFLGpxi0ycIhdV
		RcL/L4rxizsooxnPiMY0qnGNbGyjG98IxzjKcY50rKMd74jHPOpxj3zsox//CMhACnKQhCykIQ+J
		x/bsYIyMbKQjHwlJCC0ykpSspCUvicn1TDKTnOykJz/JxE2CcpSkLKUpBSXKU6pylaw8BQoqIJCR
		7EASFZgDSQQiCTW0cj+p3KUvf3nJV5YkCKcoQAVqUZI56BKY9uklM58JTS4KsylgsCVJlBnN+Tgz
		m9zsJvamaRIwiBKb3nTPNk3SC3EEY53B6Ic73+nOXpRznvTMEDhJUoBlXlOf9azLOUsSjAkIdKAE
		HWg2+onQhDbonqcIQgUqAIZk8lOhJPknSdiJ0Yyu/5Md/grjFZNkKgi5wT8jNUlJKVTSkwJoiNH7
		EQXT9ikXOvGSKq0LQ0eiggoQYJ8UbYpFRxKM9nDUbosDqVF/5x4mKHWpTG2qU58K1ag61Q1SpWpT
		rbpU9tT0Pls9RVdNyiQsrodNdyprTIk608QxqkBSvWpb3wrXt361JDcdSQVQwNOeluSnpwiqcbbQ
		hsCeYqhjKyqfjgo29cR1sYyVagIc69THQrUuc51PVys7EsxWz7CQ85Rnx3rWwoZVrTDtT2OVKtnT
		qjaqqeVMXU+h07zqVZbt8etqtoDbLQwWps9SnLk02K4r6bBwDURRUx+bgATIQQ7JXe5yk6vc5zI3
		uv/Mna5zo6vc5l43u86dLnWhe13rSve5yW2qSd1wUvSm16uZHWl60dveraaUJOqNb0d/JbjVwSuD
		xXJXuzqYQhCui1Ue5OHh/KvfATtuhcSS1FORS13vkjfC2cUuhbVbXQxXuLvg3S4TUqtUp9QVBWmQ
		6Gwr2p5+jAQ3uN0tWn3WvGUhj3fcIxzTIhvde9xjuTuWQ499zOMeC1nIPA5ykYHs4x8fGclI1vGR
		e/xd85ZkvZltb5W9Ot8rX1bL9L3y7aY2Y/25j39KK1n7cDc5sdmYxs9Lc8cenOMlE7m7Tk7yk507
		5CfP+cdzLq+U6VoBktRCEmAotEnIeWK+qpgkuDn/RQx4u7bf1g1+5uPgyJpaXR5zYdMl2LSnudBp
		UHs61KEWtalLTepRf9rUq041pzd9D1iH98/sbUqWa11rKm8517aG3VrvZ7Tc+bp8bK50mBNr6WBD
		q1vAztJS6YxnVp+61ap+NbVZ7eppW/vH0aW1KwNNkrs4BdGzVXRJUtOMdDfjFEuA9OskvT6Tla52
		WpPRs4+M7VGXYN9+8EMJ+u3vfv9b4AQPeMEHbnCAI9zf+x44wl1dAh3X+c8qVe+tdW1xL0/Zy/XV
		OAGBl0AxGzhzwk7zvCftOctV0LelwxO8JadAACi1uz5WdacVnnCcFzzhDXe4zh8u8J5bmws/pvVr
		/w890Z6a2ynNSEYyBnCKY7h7Xy8v8wsV17mDMZXOowZ4Ovr9dbCLfexh90PYz+71sZsd4GovO9rH
		7nBPd5epXea43bkM1l7juu5bBaBvSeu7wI/Z2MPuWslfzL+WSjp6e9p6d0sN6rWnvexpb7vlJS95
		t6td4Z5WMt3DfVe82hQFKkg6RZfelKZ/YwCokDpRY5x1w6NPzX9n2cydG2rMpwMBCNh9732fDuDz
		PvjDL37veX/85BMf+clXvvCNH/Z/y3q5Usb43eGL61tvnNd4v92v02d1wQMwcldHc/5IPnvSwl5q
		S5V5dyNPduQ/n/m+b/7zl4//4d9f/mMXtXONLv9uo4cCO3Vip8BXB2US4JBu3/ANzZAKqdBRjsMl
		INdb55JAMCRvMscE74dw9ZcJyJcJH/iBCCCCI0iCJGiCI5iCICiCzIeCLHiCKBiC8sd7ZpcOobZc
		WGBe2Idl3Gdl7/VeegeE9NV3wNUwGbhWFRgtRkg4KlRv6NNC+2VmM8Q4YBNB47KBy9V1YMeCKWiC
		vLeCYAiDKviCYjiDXUh/wYeD1JdVBUgffHUJlsAOcziHSzAAzQAO4DAAqTAP8uJ4ntZvzKcAg0iI
		hTiImWCICoCIiciIibiIjQiJhsh8/SZ3OtiGluWGFvKHmxaIyBeJnwiKiuiIoDiJfiB3cvB5mRj/
		H3zFGQPgilA3L/cmB4DoiaH4iIR4i6D4iLkYio2IfJS4aViAiiEGH1SmihIii7TIe73IjIzIi7zo
		izVoilzwf8R4jO/Biq0Ii36YjFwgBZhgAuE4A+NIjuVYjmxgjjOAjunIjuTIBu/YjvEoj+FoApgg
		BZtWjdboHh13jRDieLPojeAojvJIkAU5jut4jgY5A/Roj/jIhvrYj+qRjdjzj5uGCRGAkRmpkRvJ
		kR3pkR8JkiEZkphgivnIBBE5JRXJBRcpki3pki85kiX5kCeJkpokRir5jQOpkDvJkz3ZjvV4j9Q4
		kzUpIjgpkD6JlElZjkDpkMMIkURpEhNJkbcH/5Bc4Ae12IxZqZXN+IvTmI9QWZRUqYwIsJVluZVd
		2ZSXCJY+NUabaJVXiZVmKZdniZYOmYpr2SFu2YnLOJd9mYileIp3iZcodpPd+JZw6YKJqZiLyZiN
		6ZiOCXCn6JQ0OZgcopKH+ZiZqZmbWYrTKJSTWZlR2ZaXyXaIyZmniZqMWZqS6W2heSGYpoWcyHap
		SZuZuZppKZiVKZVTSZVVeZilCZzBKZzDSZzFSZyfNndq6ZoZ8o++aZzPCZ3RyXbIaZLLWVGIhJ2H
		1A3byZ3dYAvfCZ7hKZ7jSZ7laZ7niZ7i2Z3dmZ3t6Z7vCZ/ZuZ7bmZ71aZ/3OZ7zuZ3xyZ/9af9I
		nwSbNLdqA0qgBWqgB4qgCEpzM0mZ1qkhAfp+CSqhE0qhn5mcyumgjORUC8qhHeqhHwqiISqik/mU
		GfqaEDqiKaqiK+pUJhpJUbWiMSqjKRpVLpqXUDWjOcqik2WjL7paPwqkqtWjHxKkRWqkQ4pJRqqk
		RYqkVLKkT1qjTSqlU0qlVWqlV4qlWaqlW8qlXeqlXwqmYSqmY0qmZWqmZ4qmaaqma8qmuumfbxpH
		bSqnbrgDGWCnd4qneaqne8qnfeqndlqnfyqogzqouzmnh8pMgUqoi8qofqqojQqpgmqoiEqprfSo
		kYqphHqpmcqpgFqpn0pPm9qpo4qnokqqkDr/qaCqqqBkqqfaqa3qqpq6qrMKTbAaq5Fqq7fqqLTK
		q7+Uq7q6qL8KrHqaqpWEAgXQq6p6qbQzrJqKp7RDIs2ap8UKSWqQBiiwA4UGDMlKqcsKANLKqKIa
		reA6ra0UBJJQErXAT9TKrVXqreTqrHo6rvDqqaw0BypgEvoUBKbXrmT6rnkqI3YasAL7rSeSAfOK
		q3uKsAMLrOzaSGlQAduKTyPxShN1rCJGgOGGrBPbrzb6r8/6rQQrsgcbrQaLsI0qriFLsiOrqw7L
		SK9USxlbTGpQS2qAV2oADDugAiVWALVQATr7UMhUTLWAAg6FV8ZUYh1rot46sPM6rk8bslCb/6kp
		e6dS27C7tAMPBVEmAUsjsa8kEbEGWAFpsFMQi1dpMElBIHppQExKm6EfW7Uqa7Vzq7KoqrByG7V1
		G6su60hg8FCSsLGwtUwqoK4CUUvfJnqwhUxpoAKB67Y9CrcsS7cje7Lherdxy7K3yrePNAcVgK52
		tUx3ZReii1O2VAC0NAeO+7hvC7B6u7KUm7ewO7WXK7tXy0qJOxJmC7p2JbGAlrhzYE2nQLOku7qs
		C7LyWrcMO7mYSrVxW7muurlfZLEVsLFdewoq8Lkjsa2vlLgq0LulW7xLS68JO767ykpqILTai692
		FVENVQEqsAMoUAuL9EptC1sjkb7om7v2G/++gyms5Xun/wuu0ctFwAAG84sCahC8p9C5c7BTfvtQ
		7ftKKhAEO5C6I3GvZeTAxTS2/RuaAgzAINysBCxGBTCAdmESJ0yxd2XCdoG7quvBYCnC4zvDtktR
		3BvDU1rD8LrDmqtXOJzDTdrDAwzAfUrCo1RNYCCzQeyiQyytTnyqR8zEUxwiUDysVjyqUjxbeaEe
		XKwqOGuAosS/+hGAElJGBbKvuBvGdfG99XHG+bqtb1xJWNyyRcynWqxX71vGKNC5dCW/xKtID0UQ
		pRchQbCtOfVQXnu4+lEAaWCzO+DIexW0CjwHYxwgiTwgJeZQ7WtX4EZXtJQfmOy1h6y1lwT/p6fs
		RlO6yCNhwqJ8S4DcHn1cEkm7HjDcH548Bzl7TQvcTNQ7y+uLwZ5Ms/w6H7YsS3isriMRS9fpFDRb
		H4Erx/eLwbpsSXjcTGasyrzMwJ78ymrMHrIcbuxBtAICDNx8aNpMH8fUFFsbzCXhyvYxzg1ive/h
		zPMRz01Rzp9kzW6MzVK6ytdkzsILy98c0E3hGSRRzmqswp0xepxRzxzLwLy80O/ht96cUwDtzgXd
		HhervQMduDB80Cm8xAbtzfNs0CL90BQ70sUUuAldEoGb0sUk0k4RuBz9Q/v8hv3cpP/czvk60OsB
		zg3Fyn67A7WQU8RU1MekBjs1vw61rQVA/9QPpboHLL+SMNIKDEu6dK7BC7yCtgNOHR+gTE0V0Lbg
		vMny0bNFe1dJra7Z+rNSvdXFRNRGTdaCpgY6W3qW3MhfLQltm8A1q8Zx7bVEqwYXjb9fHbZQ/bN0
		jdQ+q64EINhYHUuCfQpNndhRTb1pbbQ3nSE4zR6ejVA8vc1NQbPeDNRZba36lLXtmwafC8Tx7FDI
		mrUlRsusTLom/coloQJcbU2w7cvv8c7KbL2yfK7ErB5o67V4BcSzfQpJu9uyxM6trczrW79O8bOK
		vEm4TRLPXUzZK8u+LdvR7drEy90Crdu9LXqxLba03dxpa9qn40yZQkN+40D03UOplHHxJf9feadN
		2dwUQS3c3uzFh+bJ+QR6olfPQIzaPqtLr7RNGyy4zczNXY3B1rTg2j3gYFvQwxzMhX3droUXTcG4
		jgvEDp5M1gTE9UzhEW4S+Qy2wKzdFY6/nFzPF97gpJvgxLviKU3hNv5tmzTioZQ2FPRSY0NvRe4U
		olRxe1dxTc7P/qzNAC7Qajy8wT3aEJ3i4IbDI/bTFIuzMc7jvP1t61HlAS3WPj1JsvxQKy3QpdwZ
		qLuxJQ7IFJ7l+Ju9dU3gyeTJMR7RuyvcYz66CK7lOh68YQ7oKUy8p1tLxgzfaJU0SP5rvhMlSr5x
		S06EXaZZnAHa/STaUl7aKUwQ46bRdY7/uN8Gw0DcFLUgtGA+4WL+SozuSqFuEj7bS+Asy1mLzrE+
		EHUxvMpNuqje56Vu3rurwKKu52DLrz2uT8786oH+58Ie7MMu482O6FT+UO9tOqlURJQ25DEz6dtX
		ZZbOXjWV6f7k33nu09heF54u7Dkueh1MEsQE7PG+56Zn6DIOW7VtyeuhzlyrT+Dst8bNHs8t57hL
		5zjuyWCwr9tE1NdEy3xO4ZKQvTWu7+0+6L9b6K1uVxU/7+DrQ9re7Sm3Qyyn6efFg/kd7vwtH5te
		T50e0J8OHwBeC8hK6iZe2WOLrWQL7SVBszTP6ie+y/iL85DM5pyh3iSRBgsc1Dml7k6R/7/IZPPA
		fvCCjr/XOtFc+/CJC/HWRLMSC7FCf61Eb/ErvEk7rvE3H/Y6j+pPz9miheSQnlgq8u11l/J853Hl
		nuTnXlEPBQwyC/Pu4VAQNRBz8LmOTQAFkFMS67lJ27kP1bY+q/PrXEtZG7Z7RUtqEN7XTflprrX7
		zh58/MiRvPcRG7gRXPT/Db8WTICLTwCQT4Cb3/rHdPiJ775a67kgnUvya79+KwnevPlCv9sMHsyO
		L/S1MPuVv/hiq/mXn/mcT/xoT4AZrPptj0VwX/1iBXiUjunbp317t4p6T+Zd7h8v3PQpDNHPXP6f
		n/72UcYUax9BIO93EQS17cf20cIk/f8e64//69H+BgTyrwcQpwQOFAiAYEGEBwkaVChwB0E3EE9F
		HBjRzUWMEhtuPPiQ40eQIUWOJFnS5EmUKUdWmDNSTQUUKmXOpFnT5k2SFRSqwdnT50+gQTd6XFjU
		6CmGCJMiTTgw6VKFRCdKpCiwqtWDV01KFdrV61ewB1m6hBnW7Fm0KiuoAIYCRZBaaeXOpTuSa0EA
		eRUuzasXr1+mB/uC5IqxqmGFWrWWvFvX8eOwaiSrIcBxMmXImTX/VDNnTq0gm0WP/tkYsmm0qEmv
		Zt3a9WvYsWWfVV23dtjbs3XTdeuWIIrKA3vHXB1EDXHRO3LrLoCiwMbQdX3vHr08rfX/rtipb/e6
		dvrLCmMFuq1VlmSQ8MgJlq+lXmWaU+jB/CwAPkjwUyhUzHGvMLzD8MDoLC6Z0KtAjedOSaOCNBLc
		IUA1alFhPpEk4QiYOYJAYYdaJCMoiLYWVCEmFMqTRLJa0gADP5t2YIu8WiisCQURSTQRRRVZ5G4g
		7czqEagfdxTyJvHyI5A9gl7qD6Q5iiQovZo6FMhDoJyccsmOiGpyoLVQSvCULQdKI7qBwjylgC5B
		eonM9VQ4KEaC0qgMhQOFq3MgFcxr6MuRJOzIwpvo5Gm8OwXKE0vqgvxK0Z4YHfLRlIoE5kmdBlLS
		JM8q0LGWJhEtqVChrDzlOEwrPaW8/0lLaq9MU4NgUyAzTwGjglcVyrOlg17SUUGC3MyvUEEPkkTT
		hlYl6cH+CLQpWEIHHWjYXbdTblpqq7X2Wmyz1XZbbrv11lpIwwVLVFhNHVXPkfirQFlYLx2ouWiB
		4wjU5/hsTqEE1UNUVFIPKoDPM1m1FNSAheMTGD3DBKZWMM19ydmGjMtTxzQPQg7EZu2EOL4KZBwI
		Yfec40gSQP212L18FZouY5YHkg9SR4WKuUVxaw4VV1vhG9jThloaNkkU3C1ABeXqLKA8F8Njd7yX
		5jguCEmcZvDMNHaAOjqoM1xQUzCaXJpLnC2NqYBZOcwT66gFFmhB58oO7zkBacSVw/91MdsStI1i
		Lc9TN9GD+MGvD5KzZWafLNkh9jCLO42w7fS4oR3AoFGFyrIOQkQeJU+DcsIJPqWCw3ecGcjTbDbd
		J3I/V89dklryu8xziWNcoFkBHJzthgpVQRKrJ63AI/Q82v05OnVGD2CB+CXuQQrTKHk/tREm8EH4
		4FPD11NIJhQ5r0MnqFO3Zt3Y4kFBT9Lzg7AvvHAuzd1+Suy1z5XgHSQDhgACcJZE5+HPpBXWZ+ls
		fZ77z6NGV5rSnU6BNSEXnM7Xn+H0LHmVUkNo3EWl2v0KOevKnbPmgD2EPclXnuHSoOi0JOW971xl
		wlmTjIMgOxGlUC95yAlZhR7sHQT/fJFjULRgFZy9DWx8H0rVr5zFvgmqzDwz/N38xoc0WTlNMj8D
		E87q1LXJUHGA4yvgkA7oky/KJIwLFJeoUNC42M0vPO4D4LlC4yvWnQIYaliQCk8BPf94sIXmChMJ
		k2dCdIFtJ8Sx4QphtceGFHKLGhQYDntmLjp5bzwnQhEHBfIyjgyuc1zM4fsW+aGpzS8mTuuZFXlC
		SiUekYCd5A5X+jKYv0AlMEiB5SsBM0uOFCYjVtnlRHppmMWIZIxkhJSo0JjG31xGgsmThKumZJ4C
		SOI5L7GjH8WiR7WV65AltOOT0AhDRhqyitn8jXkWWciGXbJi5LxjIAVSCxZRMXms/+xVOVW5sddZ
		rCyfpNROyjIHnenQlGAKqD01dpB8elEwC+XLQhjS0KPQMiRSuYpFqKKRYDKGmBs9iZUCh8zWDaQ8
		2HOXJChEzXDesYhPwibtmggrnVnzTuj8HhsDWkiUjlObStyg+ipAvIS1ap3p7BWxFLI0hJEpiBaL
		z0r5KRB5lpM4FaMT8l6y0jTO6kupkilPtPqxTQqLja1caFEgipeGQOUpuByKRjhi0YpgRYwcpetK
		wjaHHfTGmc/kmULCxsSp6qyOvyLTWD/X0uQF1Dxd7SaP/iccVRInp9aMlZ2Q89VR4YpOWjIXwji3
		U3UGrhZ3MR+efkqQtiiIRU/NE//yfuURzHZmI+Xhk7vCoyEqMfZztAoaIO9ZVNdKq6xOweVaZVnc
		vUzUrRuBK1YyqtG6RndeOMvTGsODnzhOtALASNBN87SqWamgQwxqzlqCsIM5uHZWkojJg156phOV
		KDrufYhn/8WeaEHtOCgQ0HrWRYChbfcU9CWAe7n7ph4OBAxEu5zh5ORecJYnPNx1b4foqIIhImxF
		qA2PJk/FIBQlKIclWksNbxShNGBVLPujHYMLqhCotQcFwJiQy9Y4t/DUdy3PMZB4SEw0I4EORyoW
		kisZehSDHPesxCUMVS7SEIogxpe93Ip0reyfYzYkuzj513i2dy+ZrIwmzelroHb/VWavuMWHgbLY
		mk/mWpGNJM5XHrBgbNmUwDw0uUwebi4hcpisyNW5yz0WnQ2dOn+ieVnuNHSjHT0XI+85IXqOKFvx
		3Na4ZlrQFU0MSob5aNcgWpRmoSmoTX3q7PSZz0yx5VorvWpMC3oqsuZ0oE/yaVSP5jJr3rVZurbh
		XAdb2DWJdJ/VCmtLXxpyy42yrQetaegOW9rTpna1HVNsO99y0ndOdrcJossnT3mXUhZ3SnBt7blE
		0GC/6U1sGHYSIp9liEC5D3RMLeadTEo5Hyryas4dbXQ/yjvE6bGyyMPoXCpNMmkYU1fQk2WSoCCq
		aXmYVwqAO4SKuq7ig86kqlup/4f3mzT/LnTAixk2AiX1gaUC5Yt9Yk2V5HQu8/bSR0q9TVCj73Nl
		AoaWIB4bkqsk6MI0+ck3guGVl6SyGhYKzFMi8x0ZayM31ylYPpoZ9IUwbz+HzdA9ncCiCyl1c2DR
		lpnExonP+SRdZqHFkAcvlREA6u/ysnBUhrK60z0/H0nZyS6ELrh7kkVOl9dPpISvvO/d7wTpu94h
		2J97oQ/qXyK8jtSeHH+DPezcIdcOAGb2j1T2w9FZHHXvtKBUuYiHZnts1Uv/LqI9yFlwCVqeYBy1
		y123a5aUVXtqIYnKAAP3a3yO8DNE/DPNKiaWw5xACoDXl3SIRXST/tCKBsikdf+s7e+0moBt7ry1
		aX88Amo41TqmHubr3msK9j3w5Tj8t73/+PEfsOY+q6Dzlmd8nTkQT7K2/VPpvlQ5mrdAuGv7FgRM
		QAVcQAakls0Tu8YhscYBPY4QvYq7nmcBFDoprOjYkAETP/DDOQyEKkCZHVmplGhiJ0ORpl8xntNC
		k6kalN2ZFDrBlRn8FRwjjv5Bk+h4qTmQpEIywQyiE3hqGOLwI2M5HpBgONXilEvCHvPQuvRhweJR
		p3pZIhmUBBoUjxuswTbKHsFKFSR6pl5pIVxJwtOqmktSNNrIvMfwugeskmNaEHbZMnXTITaqOCby
		iLSZpylRocnClT0clUHJIAf/EqfvGahwIrs/wrkPqwxrKo85WayBwqmxwqlCrBR0siQ/6r8I0bln
		AQYKOZEPxI87+YxS4qZFDI5TxBlJrDpJxKIpqhRzkTw+MsM/qiSe2Jzgygw4rLI3jEPOy7LB4is1
		6qKaOqrf+SSECT6EmSZANBUS4qc5GiwmSsVGTKmgQZhBsSZkqbpvLCTdeiw1AEJ0qUZNTBhcmUbD
		2gg0IRA0eQ5JYJc7ab1EVEV02sZWdKxRwhlkQSUOYyktu8W2o5M9GZb0csPq0DxhnI3UeZCkg6zJ
		eCSF+Bl+0j7fAY18MY9ANKKDiqZpokVnmbuqmynzqAUC2cf3sSYbEkdFBAPg/yMA9kokaGJBlEIn
		P2LHXlQIkJkSQHmvB+Exw9KtQkLJbGTJf8KZEwIofxLIpgRAndwI8GBDH1FI22hI6kgdGonIdHEf
		bvRDQvkSVHEpGbHE7aOq0zIpMsyekiFJoiwL9FBFb6yUuVQh3dqBObqfqTMPtTQkdNJCnAulS/oI
		8cKT+cDJM6SnkgSk5TMVlfxAR4RIzJIjjpGhIZI5yhLEgnoVPMI8h3olp6glbgPNWApNbYuKrPgl
		1Qy3cvs6rNSNIrEaMVkdA8wbc0EPZYmtsGEWNCkis8Q53Uys8HumVCnGe8xGG3oJoOrGkjm8HxQp
		xnTEeswrRNks4VSQdCQk7P9BQgbZkMEBgwbxjy+BiR0gAPNAD1bsOWw8rPdRTo8Ek+ZkTuicINwq
		H0BBk8dZS0fkzjTwzspQlggZOVVLskqjNKUwq1f7NmabtWdrUAYFuNeEjSKZFaeROmM8FoWjIwuV
		FRezlV7BD/wKMH3LsRazmoAKr/EKz5H6DPohUfs6mv8yT5YwsIZpjwAtFxtVFvyiLznasXayrvz8
		HBZD0ZdokOdrph0IKB5tmNuaoBeLS5YJghHpDFPEm45w0R2DUXiSUbyasBoNGmXxGjC1sfDAGTRh
		iaZxjx0YFhji0SVtkiYFk9hjxIUsUOQyiobK0wTlkbfqtECrNWCM0NhwksD/G7WfKDygQFTna7wz
		ocqp07tpHLyWUNSRgA8yo5ElQQ62Cxk3a1SeBAmAoVS2UwlN3SZFjVSVQR552UmSADN2Yw1sY7WI
		crUDJa4lQ03m8tOLgraSE1QJ5bqdeUCnc0SToBKX6VSfKIBfbJ1jGtZpi1UCXTVa1Qs9RTYFTc2K
		Ys1dlbVe9dVQA9YLDTtndVaRmBUwoE4weLeg0JDVGFdwPTVXGk0kyzZZtdU9dYg+dTa5AlQI9dbV
		6DWpnAxkFTb0wquO8IwggQvPwAxQK1iucNiAi1U8o9XkqlZlu1Yo01UG5ddu9VeP/ViQTRRVm9iL
		tVeTLVl8zVVn49fn+ohl/w1ZmI1ZmbWLkb3TY5s0BLVWPoW25po1xSA0mp1ZoR1aosWNmqUlwJAl
		WCpNpvWzP2NNKQOmKKOyfi1aq71arL01q6SLl81ar/1adOtaogtGsC1bs/VasVUusj1btm1bmU3b
		Jltbt51buhVUuHVZhqxbvd1bk2tAv/1bwGVAvh1cwq22u3XaaytcxV1ceN1aSGNcyI1cKzvcWLtK
		yb1czFUgyl02uc1cz/1csvrMpSVNaRVN0uS2ym3N1pRaXtLWqgVd2I1dWB3QO5Uokp3XsaW1B/3Z
		3XVN2f1d4PVMWFPaWvW2WTouzuXW3gXaB+3Y4H1e6E0N2jU2nT3ebl0MliVV2UCNXu7t3lSzU+pV
		Cm17CtKtXIuAWqrNqJZFXO9tX/cViYAAADs=
		"""
		
	img_dict["ncbi_g"] = """
		R0lGODlhvAKQAfcAAAAAAOw1MsEhJGSJXAJUQ8iv3u/1/z1xqwMtLUyO3/Xw+e3p7cKl2vfNz9bS
		YlpaWkUHCr6+naidUABm//bZaI9AFwMdHrGT2cLC/1+HssuuUAtiTJqH41ZW9Rg1VElJ8+bm5nNz
		c7G9X9Xm/8zMzCNalAIKEJSSX4BbzMXGxfiSNDeH/yUpLbO/0Y2ctzOrGklJSb6+9J5YNVtc///6
		/5iwzVBUWr29vc7Kt6gWHitinJ+twxAcKRwCBszM/yFCYxgoPnuLnIaX+np6e0FBQclWP8qyovg3
		O9LMrbLI/ay60W2D+aSkpPruqDBJZXd39y1hk7W1tTxUbowRFuDe39bW1k93tp2y/du5V4l4Rn+T
		sN3c5JmZmeXn7wAACK2trZWm+wRGOS9B9Obr/vfc4AQeO8Pb/0SXZff39w8QGGhqbczMmdzY3B94
		/2xu9rW1+q6t+Gik/5SUlKhGPv///26CoXV14cedijk5Ode6rPmzkUlmf8qJZ/vpl4qe3Nvb/2Zm
		/7PK7ZmZ/4yN9/3v79y61nh8gnINEx0dHcwzM6k3LsXW8rG2nQQ4Off5/2ZmZgoECAARHGNj0IyM
		jP7395KrxiBo/ISW2xgkOaCG2xAZIZx3yW2vNt/s/4WG93yYwuHKep601/zo6IdZPaS1xU55p8uh
		zIO1/8Gfc8/W3k9uUqSkfNHe9kRj5rF5Xllu9/frwObu+HmvZISEhIQ0Lnqd0jNmmSE8WvHdjdvO
		7hAgMWmMsfLh1hkxSxkhKf8AAKy0imZ1mjMAAMLP1qdmRmQKD+FXQ87f/5y55k6gSFNo9+/v78PP
		36Sj95l71yYLEAoBAPOaWHhANdrVvkZLU5+fu2tJzgts/x9GcXiM2wAzM8C8q7fU/ylZiNFCOL3G
		1q2Ka5zE/02U/61yVOPSl4OEjnmN+ZWT9c67d3R0/uDQxQssSNDQ1eHd19cfI9jXzj9p1DhsVr3V
		9gAICPlIQTY+RbO5wC9ZPkJslzMzM5VryVYLC5OkvIlw2wgQGv///yH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wNlQwMzowMzoyOVo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNlQwMzozNjo1MFo8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQBBwD/ACwAAAAAvAKQAQAI/wD/CRxIsKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBD
		ihxJsqTJkyhTqlzJsqXLlzBjypxJs6bNmzhz6tzJs6fPn0CDCh1KtKjRo0iTKl3KtKnTp1CjSp1K
		tarVq1gxLluwrGBXgsu+Zh1LtqzZs2hLLmCihskNrgtuqOG69QuTR1XEpt3Lt6/fv1aXgWAyhAoI
		EAuq3EW8oDGIR+wWAJ5MubLlyzUXDC58+DCJR4w1U3lEAgTm06hTq14dcQEVwoY7fzbseHRpvaxz
		697NG61rLpxlP6ItmjQI3L2TK1/OvKhr2Ic1z27c2Pbx5tiza98e83lw6cOpu/82jpy7+fPo00v0
		Hhs8FfHWy6ufT7++efbRQXwOPf62fZ1hhfXfgATuhB917IAWVnH+FfjSVuJ1hliAAjpo4YUoHbjV
		XST8sxUI8WG40lpt3XDYEI888oVhr92V100QiifjjDTWaOONOOao44489ujjj0AGKeSQRBZp5JFI
		JjkjcppBJ9aTmpEmmYgpCQabYbNEkcIsj9xAxZejRUaTYFSwwUYVaKap5ppstunmm3DGKeecdNZp
		55145qnnnnz26eefgAYqqJmGPbkZYglFKSaVGW7GRpnslFlFCEM8+qVxMwlWBQkp3ODpp6CGKuqo
		pJZq6qmopqrqqqy26uqrsMb/KuustNZq6624epoCCVVcJxCJvSZ0Jl7yMQqSd492ViZwYIYYEwhV
		4CPttNRWa+212Gar7bbcduvtt+CGK+645JZr7rnopqvuuuxeW0qwA0HLhmkISWpsSr9VOqFok0TR
		LHkyUUFCCToUXHAJJRxQisEMN+zwwxBHLPHEBiNsMcUYN2wxwhl37PHHIIcs8sgkl2zyySinHHHC
		JFBxL08HeniYGhI6+yAbKZRgy8626FAKM12kckDPPNtCcMdFJ82zDko37XTTOmSwy9QZMP301U7r
		MDXVOmPt9ddghy322GSXbfbZaKet9tpq+5wCG8W+3N1rnFEHAhfzKgswTMuw/3FD1zuXkIoSpQyd
		QdUFH8DPASWU8oktB3xCyicZ8FPJLrZUUrXTodRQwy5dF9yz1RLvLLrBVB++y+aBr16C66M3XEoN
		31SyMOqrq84627z37vvvwAcvPNQGJx366UuLvrTpZPt8A9xy54RsbCBE4W/Ne7+U2N9Faw26xS18
		0vUWzCT8zeyHV1IJ4VsckAronBccygHq27KL5gd4HrktlIcy+y70q4T9Lsc0FwwtYQdwgdWM9gnx
		fWJqn/uEDiRYCdHVwBY1EODODGg0hSlweCAMoQhHSMK1lUBzJZifwWbXOPFVwn8HaEElPuG40GXA
		c6UoRewa9gnGEc10pbhBFf+mFD2bTM8wVfhCsvTWIO1VgXtFa+H6gLYLg1WCGRdUXw0s9gkldFEH
		39hd0r5RA2Y4znO7aKDjpPYJAc6wgVX8RA1CkUbKMe2BqShFKjIgQZ6V4BO1Y8b9dFCDNiphhl2b
		IR/hp4VdmHELfFxgCSdJyUpaEnglUALhWCHAHv4MgA3MwB8zUIkTtrFrJahBDqfmODp+IhQSPGEG
		One7ggVxiEW8yXNCQKgqDCEFu/pCCg5jM5dsD3A9+8QWyMeMSvhwZ87cwuUqsUUdvE4JjsyAEsRY
		tFD8sRS7KGQp+AjHBrqRcmnknzj5WEFbuOCPXRDlBwP3wD+2kX6lCF8Lbpf/OcrV053wrNo8L0nQ
		ghr0oE37YygWKsdSOi6NaWRc477xiRbwsWtQKEX9HkjDNmq0FH8Mp0YxeoAosINeuaQJsvyWopaC
		hpjZM+YTkSm4CiIMnEVrAeS6EIoMdAGApeCHEjJZiTBKsmgSPADm6ne/DGSugjeknFNr4FSmao5p
		/ECY0WzBjwWW4HBfHSdVJ0hWnj0ugzzLqs501lWEuvWtcB3hCbWoTdCNtAVaOBwUdlEKF2DDBWns
		BhSg0A3MlUILjcwrYqHgAnx0A7BawIcLBEtYfAhzXkrKrGY3y9nO3qhYTarUl4hJHJiSgIhOhCLP
		wHkAa+qgmQTLJ+Pu98dU/zCjgamwXD6rmDWVGSwDjZwaDSV5Ooh1z2GLFO7C4src5joXba87XFVL
		kVG71gEbddACYV2ghWBAIRjdCG838IHYboC3Dvyog2O9i41g4MO74BWvLZigJXYI6r74za9+91sn
		S6EULJtpD3UCpJnHLAomx0ya6DLAjC3s8agVgxzTDtDao47QZ9IFae8wfDgNP/fDIA4x8RJXxYKJ
		FxsoTrGKV8ziYARDCiyOMTa6MQkmfCEKucqxjnfM4x6balfzOgiJIiUfNBFLJglWWtQK+cOnRYyS
		DftdlEVM5SqL2GCD7UYsKIGGLnv5y2AOs5jHTOYym/nMaE6zmtfM5ja7+f/NcD5z3/4bLzTRmSBm
		qoJKZ5o1jln5z4AOtKDTRlgtcznOiE60ohfN6EY7+tFjXkBplnLMjVn60pjOtKY3zelOe/rToA61
		qEdN6lKb+tSoTrWqV81qbGwZ0rCOtaxnTetag3kBKaBC3ICyPalt7dfADrawh03sYhv72MhOtrKX
		zexmO/vZ0I62tKdN7WpDuw7B2MOrbc3tbnv729/GNfSSsr12NOvc6E63utfN7na7+93wjre8503v
		etv73vjOt773zW99t4MEN2DCtsFN8IIb/OBrjsu4kbI9/jr84RCPuMQnTvGKC4odKYiCwA+N8I57
		/OPgVviuf9Jwi5v85Cj/T7nKV55yjGt84CCPucxnvmiRK6XkLM+5znfO857v3OUbp7nQh050NNuc
		3E/0udL1+45pOP3pUI+61KdO9apb/epYz7rWt871rnP9HWpqh9jHTvaym/3sYtcT0GFe9La7neZH
		Z3jS3VQmM51p6XJih973zve++/3vgA+84PdehXfgYBsRSLziF8/4xjv+8ZCPvOQnT/nKW/7ymLc8
		DsCOJiWQ4vOgD73oR0/6b7QjT2vneJlpwPrWu/71sI+97GdP+9rb/va4z73ud8/73vs+9kZ/3sh9
		gvM1gWASeIABHrgALbzDafDQj770Az+NbdhjiJ7Nvva3D6QtbGMaaOoh/4XHT/7ym//8FCbF3e2U
		ejMvo+52j7/850//+tv//vjPv/73z//++///ABiA9QcCZxZ3R1F8aQICcgADwsQELCAH54Ym8Cd/
		O7cAdHCBGJiBGriBHNiBHviBGLgF04AE5ZACIHiCKJiCKriCLNiCLviCJ/h97UAK6FeDNkh+GZAC
		eNJ+ZLYp1CMhQBiEQjiERFiERniESJiESriETNiETviERcgOJLAMZWaARoGAaEICMMAOgoEGN/AF
		CyAHeLB8C6AGj0AED4AmNoCGPGeBF2gXNwCDcuiBIogEk2CCc5iHeriHfNiHJ4gGETAN7bA440dK
		+HOD5Dc15vcFO5hxQf83ZmzADn44iZRYiZZ4iZSoH1UofDc3d2pCBVzwAMugGJPABTeghVHwBTBA
		BTCAF0RwA5OAFw8wCc3Hcm7IBG5hYxe4DBjIi7uIiRpYh3cIjMRYjMa4goAoiIR4AFYQC3VQB8tQ
		OFZAftNYflbwWi2AQOPHBI34cqr3ZctAAsc4juRYjuZ4gmbyjV5mhc7hiWkCijawAGwwBA8AAw8Q
		BSzwAA/AAjfwADeABjDQj2iIhomRcxaIBkOAgV8yCXIAcCEwC7nGkHFYiaDIBFzAi8KIh+e4kRy5
		h8k4iOS3Bd2FD7agBPzwDavDDJpUCl2Aklg0R8uAkuTHjXfCg2H2JR3/mZM6uZN5uAzsoI5dxo5E
		gYVoAgNRwBV0EAX3CAObkms2AIYB+QBcUAW7QgU6d5AJWQWzwAVfMARd+QVcQAc15pVqYIkgkA8A
		8ABoQAcZyZNu+ZYc+JHLeAD4UAcyhA9ooAXDQAq7kAougAaloAB70AKkgA34QJg70ALdsI3d+Ihh
		Ni9wGZmS+ZZoQAI0EGmciHRCxCZUEAUwMATAkQ9DAAI2sJUhUAUMuAyvyAQwQBgQeJV0gAaTwAZo
		UAVqEAVZonFxOAlfkCVfcIloEJYX2JaTWZwdKZfjZwVbIC1ogA/LEAQuEAyaJAUKUArLgA0t0AJ7
		xQz8sAP2sJgURpPs/+eIbOdlkGmc6JmexYgG7HCZYiaUQ0GUvcIOIaCPX3AYX6CPUbAMvwQC/RkC
		NjCa67dybiibs8CbwTkJAiOJX7AMcjAJkliMxKmeFEqMyDl+6lMJWtANn+ACpCAtpMAPeEUK3VAK
		pFAJLuAC2bWhjFmT5AmUaHCeFTqjNCqH7OmeYQafQiGfVcAGdiOBjtErVvkl87IVA0qgk0kFIwiR
		NdqkfnihFGYLgwUFQ2ML3bAzWSal+HAAU8ozVNqi4+mNkAgCTlqmZuqBN4qZC3eA7uh8egICjiB0
		SooESnSmduqCCiCDNIiIfFp+pSCedWKTYCajd1qoNZqm75mZcreZbv/aqHnyDtsQqZI6qZRaqZZ6
		qZiaqZq6qZzaqZ76qaAaqu/wDuygBX16qqUQBIwaqC86pob6qjSKqDmqqGy6qo56q3TSdEiwq7za
		q776q8AarMI6rMRarMZ6rMiarMp6rE6XJiTwBXIQrdI6rdRardbqFqjXqmJGqLDarcUpq7dGq1fY
		prharuZ6riw3quq6ruzaru7KedkqpttKpt5ar5MJrl+mo0HBo+jar/76rwDLJoL6Zdxqrwark/i6
		juLajrYasP3aDn4QCu3ADhK7JkpwCRLLDqfXJnbgB2L3DZewsVWgsWmysaensWLnB0ogsg7bsnQy
		sOZJrwc7szmZsEH/ubBDSa4uW67tYAcZewl+0AF2MLQg+wEd67MsiybDIAl20A6XIAkdcAlVcLRK
		ELR2wA6XcLVZqwTfYAcfsLI7G7ZxArNdVrA0e7bjaLNooK+8prNi26hOK7HDYAdA6wd26weXgLEd
		C7Zh97QdEAp20LVPu1BZi7F527Tf8AGF2wJI+7aOuyZkG6Myi7aUe4xqy7Yk57aPu3TtkA1+UAWC
		2wKXILp5C7ShkLVJO7V+MLR2MLdK8AFdaweSMLqH+w3f0AERewlK0Lib+7iRa7aVG7yVeLk4G5+a
		27s91w6hwLQYGwrf4LwLRbiAy7dpwg5+wAtVELF0C7EQ27HQ+w2r/1sFgNsC7CC7poe8jvu7kyu8
		7EuJxLum49qw6Kt0aFe/bWKyY1cFp2e/Zje/6autj7m+aZuBa8mCBdy+lNmeajp8PcGv/vvAEPzA
		6ruC1tOBOLaCVDAETHCBGcyNH9iZFxgF1TMLpYGMcoCBaHDCG5jCdKDCL3iUL/hETfq+DAwzxxvB
		OJzDbzvBKnigv9iLX/CbdOCLHeiLXImBXBAFaBACBbwMNKCBXDAJF/gAIBACNMCVrUfEF9hlKNxl
		s8DFdDC5YEyAX3zAW3zAYKyBaKCWQ0zAXYzCGViKM6zAiQq/DKvDeJzHjsspUcAF5Vm2AvyBWkIC
		ajALVEwHvemPiP88C88DAyk8Cxw8C1lCB/W5wZT8ALNABML0kLOwDFpygTbABog8mkQwCzZAxUMg
		yRNJB0MQixtMBVxCApwch8LJypPwABvMBTTwCLdsyXSQwa38y6lMAiSQkF8gxYRBB0wwC2pQBcrM
		pCFwy7+ZwZPghjYQyOlJw514A8DUzd78zeAczuI8zuRczuZ8zuiczuq8zuzczu78zvAcz/I8z/Ts
		zjegcXLwx5K7gsIUBSc8Cdy8wXeYAro8CSTABPVZwEOwllzADp6CgV8Qh5BskXSwAJ3MizcQAlMs
		ypAc0XTwCGspByaIBo9AAwvwCKx8mWUY0jcAybGJ0o9BAwlZlo//scUJCQJqINMhnQKPsAwhYIKi
		WMFDwA4aRwOMXJZUkNNDMIrGnJBzjKPhasc5ewPTV9VWfdVYndVavdVc3dVe/dVgHdZiPdaCx8d+
		DKPA24HC9NBaUsHcHAWPIMl5AQAujZBv6ClRgIH0RQcTjYdOzcpxOBqxOdG7+YZ5jQaQjNisjIFS
		rMxMoMKKjdhGbdSDvYtOPQkyfYFMQAL9ogYxWpYNiciKUchDQAInLNk2MAlyHALi+NQLvM0IHNuy
		Datr+0T6nNYc6BapqMxUfZEhQNVMQAPOrAahKMpiCTdywAZBrNd5vdDL7JNcwCKOTMkbvMTK/AU0
		8AC6JgdSaNd2/62gVUAF2u2gJADJJGDX/CnTmc2fdHDeCkrIYrndIMAOiCDFKkIHAefTGPcFtYne
		Q0ADk9A3NMAONmDGM6rNmjnbCr7gTlrbN3Db2NyBpbgpdLArFX6gzrwls6nRx7zFk0DCFR6hIY7f
		9PWQJ6yDXFDdD9B6v7kMG/7hkrjBv4kGMz4Jp8kEMI7IyqzjNK7jM/6blnygCYnYs+DMdEAzJI2B
		W/LT+D0LJ/zjQzwJcyEHQuzadVzDBiLDDL7lXG6cDg7hb+kWGqjEdCCFcfnXmOijbFDLG0gCIn7e
		U4mCaBAFT9zgdDyrUm28q9zlfN7nNbs9YO6WKSDiKdjjxJjRXP9g4B74kEY+swi+qH4e6ZJejl+O
		1hHOgRSS6Zq+6ZzO6ZRACZ3e6UMc6qRe6hRCCVts6kSs6qze6q4e6oqOpnce1ViuE9sz6bie68AJ
		6Jau637+6LXq68I+7DbK665K7FsO7PGL7Mze7B9Y6cfu7LKt7Awr7dYu7dA+r9ce29Q+1dv+7cOe
		7QEM7uzb7XpO7ug+6eI+qJfugaLACZzQBPKO6ulOoea+o1pe7/qe7Mau7S0oCy/wArIAC7hACG/p
		CPsel7Oer8WL73sOgn3MBRI/8RRf8RZ/8Rif8Rq/8Rzf8R7/8SAf8iI/8iRf8iZ/8iif8io/8XIw
		CyEQ6CwIDAH/LwJNgAv0fg508AYYoIF/sIE4Twd/0PMX+AY+0IE634GO8PMXiAEYUPQcOAYGkO73
		vq/5foIsAABYn/Vav/Vc3/Ve//Vgn/VeYAJkX/ZeEPZon/ZqT/YW0PZubwHzMA/rsA5lUPd2f/d4
		n/d6v/d83/d+//dvbwGRMPiEX/iGf/iIn/iKv/hl3/iO//iP7wWSP/mUX/mWf/mYn/mav/leAPMr
		CAsvkAx90AegAAsX+AR00Axw8AdwMAZA/wEYMAbN4PqO8ARwYABjkPvNgAFv4AlvQAdjsPM+UPTN
		EANj4AN/4Po+EPy1j4FwAAgxkPwxYAAYEPVwEANP4AYGcP10/+ADzRD1Ts/sU9+2D/+BeKD26J/+
		Wz/582ACg9/2CIAA2jD/848Agh8JZR/388D5/I/5+k/2AOHPAoJGYQweNKgL28IfDR0+hBhR4sRb
		FS1exIjRw0aOHT1+7BVS5EiSJU2WBJJS5UqWmFy+hBlT10yaNW3a5JFT506ePX3y1BRU6FCiRY0S
		TROLEhqmTZmyAUFH6lSqVanC4sSJAi4KfaR6ogPnzQw4g+iMAfTHEwawdDrAEQSnrA9PcJ6cw/Dk
		g48OGOg0i/GkwyA4Yzy5+YDBLJ03zc69OdfsyZsPg2Kc+zOoWWO8M+oathpa9GjSpU2fRp1aNR00
		7Gg4dbrgBv+bZf9s38adW/du3r19/+a9oMqN1HgAHEeeXPly5s2dL/fixYSJSJEQXNemrdF2bdcR
		WKg+3cS86OXNn0efHv089tMHZoePMIxCbBPt35eYUb/+j/39czwpQJFYIrDAlGJCMEEEb2KQwZ8e
		hLCnoyaksKikloLtqahWowMWCj7kqgmpnjAgrkFoeGJEFB1JkUU6PGmmrD+egMOHN+yKYYwU/8LR
		kUHc+MMNDHSUqhm24GrGBzg8+WMzGpKEAwO5zBrkiT84xDJLLbfcsrXXMkRDNtqAI7NMM8/ETTji
		UDPuOTeTgyZOOeeE5s3j2qMukvfg24677iwALxLx2CNPPUP/D/WCUPcQyK4g+eZjCD9J79uvUov+
		w9QjAQU0sFOVFAQ1wQZHpSlCUyGsMFUKLwQTDaiwhAULWWXFRSq6BDHAMx+kwiBJT3YNizEf/vjj
		nCeGHTazMd7gldhBDPAhRR8GWVYqA84Z5A8MhjWAMANg7DYzXOH4awYuz0U3XXS9bFXM2tCEN954
		1SzOTjvpxHfO56LLcyBG4csOoUauAzS88QhFOGGFF2aYPUD/PYgAiSGtb1KLI7LU0kw39mDTAD31
		NFSRXyKV1FNPllBVlZFSqtVXOSQEFJllhsWqtlBrrBl1V5vxyp1/BjpoqtgF0115j0b6N3rZtNfN
		fJ+WE7ry/6bTE7tGt5Ovkey+A088r78Gu2GxTXj4OoM2ICChSC324OKGMq4U03U47qUMkdZZx+Ne
		QO505JFLHhVlwXNaufCgWAXzZaDHUM0Hv4Q2bQyfIae88iyJztDopDfn/J+lT2uz6eXmhAQSqJ8G
		ID0T/AnKO4Kwlm9rggsGu3bbxUa4On8RCGNiiiHyIJgugtlIeCkqcqGL4x8KXvlbIIJ7P0xdkKKX
		TNcxZAum7JHC7k35NtBvkQFvcHDBDS8c8QwVt7x999+H/2fMYdO8c/vnHa5e0ZsrvfSn+/cf6dAD
		idUBanewix18ZlcdBjbQgQ8MG8OoUzb50CciTqBDC+bGDv868GMdt1BAKjbCvCDQ4XgVaYgHKtKL
		imzkUip0YQw5MrcZBoMOTpgbDfHWkXW4gA5bqAYppLIHvOWtF0Y8Yt7AVyDxhYp8DjLfydC3MvXB
		hn3xw2IWtbjFqcwvNrN51/3EaKbPmSZ0+0tdeQC4RjaSDoDroVp1vIO1tBmkT376kwH1uEfX6bGB
		tpsOe/S0u4NYEHgtSMUtpAACUiRSCgrQwjqkoL0W/GAddTChJLX3jT2oMBiU7OQt2PGNLSxjDy5A
		gz0q0kM0mFKHmKTDMnD4STS0QAo6lAId7LGOMpTBCdTjJSoXsAe7pcIe9lhGFFJSBiaEiZggayKo
		nniTKEr/cYqqqqJTrqguR3TTm9/sJhfFOc72ebEp9RtjOn1TxtKc0TlQiw4b5QmJHtTTnj1443kU
		xUBABQwh/hSY6wR6nTsCbGt+FBQgC+gvtVWMeZiUAiZ96ARMOsEJINgCKndwSRNKoQtd2AEdQLAO
		G4IgpDf0QFTs4ZothLQa6+BHB1uABidYbx17SAUN7BE8kVZDKpb0QBlK6ATv8RJvTKCDC1KAhlv0
		YgG65KAcIoFULiz1FtCMpqimWZNqnuqa2GxZ4jbEJXCW1axnJWda1aolczIFneqEa27YSRp3wsmN
		a3zaPe0pDL72VRj2lBMbFSUe3THqjn1CSB0NejXEPsog/wBDaEJrtzsErM0hHtgDGvgxjG/8oAt1
		GAYIblHCagRjGDe0IUXpQMxguOAWW9gCUfdAg5cuowVlsGH3lrHLZWwhGCXcQRk2gls63GIdsL1F
		GfaQVOEKtbh50x4IglAGNGzBEKQtgwJIEYleoIEJ1GVDCEr43ZBldUFbLVVXI/TVVGWzKdtUzVm7
		aQD61te+9JWvI9a6X/6Opq1hAmNcBSzX/DHNrqeLExt74FcI7AMCfd3HPoox4Qk/GLClk6DXBvkv
		7SDQd3y646MkNmLfPbY7s7MAIB9myIiAoAVb2OUCXkwK5x5zBy74QUUrupEPUiK4xpXxOpZB46F6
		YMhC3v8CKUjhgmDosMgdtFsZdtvcEhKzFy7waTWkzIYd2MMFRESDlrv73WVU4Qtf4IIadFFe88IE
		velV74PYWyH3aghLZr1vnvWcZ7P218/8/e9bBwzXuY6mrs2h0xoXHGEJF+MQxYiwo6cwaUpDGgLP
		6EGcCGWo9hTWOwAtcXwcS2JSk/og20HxZC3AYuZpgSlEdDUaiLjcYPgyGLfQMR2avINheKAFjmiy
		D4MgZHs4VwpGJsU6hjGMXu5hD9bzwDqGuo5vyLoMwqbhLdCQilsqlw40HmWzqxdmu3k3EuxIQSTK
		oAYpYLXNJHuzLuKMqjlPqM6uGitqyrrn+o7B3//2N7//8QvOPxd8nIEO8KAHXGjR1BXBCe7fog9B
		aYpPOgcXx/ikD+Hgv+azPAojbNXm6KgwHJbkIi51yuto4uzQ7ms8sOxll7uAH2CWDjSvuT1uTodh
		SNuEt2hBLDN4UzQInQ0VyaCxPZD05QqdiDwu4TIUWfRl0CEVIeHxbGmwgKqngpi5bGUmv203OkQh
		EmCvuhTW3Ld3w/vN85ZzvY9yb/iOBpx5Bnje9b53Pn/T4H/PIsLHpHABMzw0Z8yXXvlaz9Kl4RkQ
		mPjFBYBxygvA8pO/+BQ23nGPNyzkIh+o605uEJWXnsT/dHkgYe7QiPCjDm27hevb1hB+2EMLNd8D
		KY79/4PaB+EHt/CAE3oP/NgPew87cIIHqvH6myq5eh25hQtIgcNfkiIIWJ/hL49pCF7WLfe6z1s1
		DGE3Jox/3VH4ghP41na3oxfuP5H73MO6vnyT5u72/Xcn9L9//vff/wC/L4IDvAG0HMELI8JTJ8Oz
		CsSLE71aMGGAgAi8tGegwGcoBlpQhMsTAEXIQMvrQAFIhMvLgUe7NHwSLM/TsD0yIIEyqN4xvRdc
		ue+QrPFYPfsYoRSaPRzMwXW4LBdqoSKyiLkBvg8yLhUyriL6iB0arjLImyTspV4aiSc0IiisG++p
		ifVjP0yIN3l7v5SJP5bBEPo7jW/CP3/zv04YgTRUw/81XMMz/Df78jsClMOgMUAEjCsFrArjCCBo
		eEAIbLBDAETNO4RLQwQWyAcYGIU5SIRFZMRGZER3gMTJm7Ri4Lz+OZSE+ZoHUkHRGz3Sk5gNAEW0
		UTmDkEGv8YIadJtUjB7+4BhM0RuTWCICyUItjLcu9MIvFAq6q7/QIMN+G4P+cwIpGAF+EEY2NEZj
		9D849KYsmgUWQAQ2eAA2UBciqALRYIM1oQM8gIGiywc1CA0uCIEoGAIQyIcheAQqsAoueIRyco12
		STg7TCc8pIo2KZ0HbLRAlAEJyMAcmAIIMMR6uIcHGAVi8IaCLMhGLMgAUMgAgMTMKwYIMEFL5LSF
		Uaj/BtIjqwEoTwxFU/unUjwYAEDFVLyYVcyIVnTFVySJWGyJLNxCWwQKXBwKXSyNXqSvX9S/NbyF
		SOCHSriFQKiDOliEQOAHFwgEojyGY9ACoERG/quvOISfNGCCG6CCSYiCSeACOaCBqcTG1UAEEqCD
		KpgErJzKKHiANIgCqUAEAFiGGwCAB/jKSSCOqVQDGyABLijLq4yKqxSpSXgEGGDHL8mcd4RHMZLH
		qaDHBXO0ibM4AcjHInCHDZQGPKiHeIgHVciCcSgCY6CHzVzIADAGYziC0AxBzJuCh4zI0rlEFFSo
		OBokyoKYFzyIPxmUeQDJmBNJ/CBJjTBJ/0DJlFTJ/09hyVp0SZ2AyZicPyvaRaqgSQP4NzY8hlsI
		BifQAikIhJrag0oAAie4hWA8hjqoKSc4yqNkw/1rymWEnxTIBy5AAxaYhAcAAEggASIwDg7iEETg
		oBTAgzRQAyJITxtIg0mQikMMgUkggmjURkgAgf0kAjXgAhh4AETgAhZgg1nITzUYAhgo0L90x8Eb
		TMIsMNABAD6EwCngx8XcQBlQhEVUBGmAAcqkzAEYh8/cTHo4goX0hgAIzSMYzRJ9yGdYo9TMsNXM
		RH4qG7ORjxHryBQLJNoMyduUlNy8iN3kzd4ckN88kOB8u+EknOI8nOPUpuScCm/Cv5tMw/A8Bg9A
		hv8DKAFLuIZrmIA3hdM3dVNLgAcr4AYzMNNjUEPyHDj9gh82YAMAIIF8YAMuQAQQMFR1RMf69Moh
		kAMbsIEbeIQbaNCpYM9DNEc58MuuTAMakIMHsEsmsAE6sM80mIVZkANEoINJ8MsCbMeiEcwO7ZzC
		lAo9RMwckMQpwMA54NVF9AZeHQVVcFEY1cwZrVFfXchFzLhHq0TUnEhMFFKvmYeK1J33QCD54JrZ
		rE3Wc1JKgdIWklKQoNKQsNIrZb+W1FIe4NIuDUPktLv5qi8yHYHwNINTEIc4xdd8zdc2EIdwMAM8
		1dM05FMDME/3YYGDBQE8GAIASIN8YIJCnIUsccb/IXgAFnDQspwEdkiDEEBLKtBPUdVYRJgENLAB
		RMADNWCCB2CCTYVGQ6SBksUDt3RVwKSfWJXVzaHVbDyOHoA8XMU4RSAGYigCg/zVOQjWYc2CzJzR
		AHBEhUwEDtS4h2xWSHjWafUaf8BagTAgBpLWINUw0OMw+ACU2WwPLkzXs03XdVXbteVSmRQNMa3J
		MSjTo+SGOGiDOL2GNliBOIiDcAgEeQiEoJQHZDiFOFiBNnBTOG2DOPhX8RwBPi3Y9qGCKqg6EAAB
		KphckaoCMDUNENjcr1yGBaACaaQDzJUKEEADKlgANIgKz50Kyl2G2F2G1pWKKqhG0H2qmd3QA7xZ
		/5z9UDPaWQggUcrjVV5VBIMsAqMVVsq0TIJMSEdMBIUkTUDch6ml2vRAmKvV2iLlmtRbUq9lTT5C
		AMlSGLY13/NF3/RVXzB0GTCFW+Yk06OMg8TN276908bN0zz9VzMIB3FAXDk9hcYVWP3r0zk0YC6p
		w96d1d9tp53dh+H9WQ5UhDkYWoM8Whd9BGJQxEa0vESAxMfkRxIsQTb6OGi9WgvgAU7kDu+wAH/4
		GtzBE9vBWrJFmPW14RvG4RymIi99L/eF1+ac13C42wm4hn7d3/3N3/w94n8NhxWA0xXwV/GE3Mg9
		4Co+jQRWYN/dytIgghAVhgemvBzY1eIlWlqAgf8WpUyB/MBIDGN+tDQKPE1ICFJNHIhOtKOBARQX
		huE9tlqx0eE/BuRAVl+35UVfLFMhflNx4IZFXuS/lQd5WIRIluRJjuRHtuQkwOQmftM2CIdHZoVP
		ZoWP6gLZJeVSNuVTRuVUVuVVZuVWduVXXmWmWJdXDUwOzWKkydku5sOexTxa8GUZAGYZuNEAUARf
		JoJ7uAc8kAZasDhctbwSjdoHm1rzyN6QW0HXccFSeyzaYZiq5WNCEeRwFudxrjdCrgq4jd+7bYNT
		YORFToF3ToFtYIeANUZ63d925oZTcNM2wNMBbkorNriiOxcsvuWjyeWdFYZi8Fld9eVRkAAJEGb/
		hizmfDjYgy0GQVRMiquwvopjABqsPGEgTiSoRiCAUBRFiUE1JV0YRPnmhCHnl4bpmJa/dv3St3WE
		uJXbY7jXCQgHfOaGG3jnVMABHBDPf13DY1hiM/DpU3jTOJDiTihggPYzBZhlmv0iWy5o/Nli0uhi
		LxZeaJ40acgCCSAGDxaAKdgHCkSEtW40CYxARpNmxpunGI6jsumwggix3tnIEdOaUlQYRCnhTdOn
		8pXpwjZscTbnMP3hmzwGN1Vkn76BocaBCEiBo7yCV1gCbhgBIQCDJFAGZeAGIRACpfbpe22Dp4Zq
		Kv47djhLOiABNKs6EohKOmBtkfJKEPBK0mCC/9zlAuIggdamAyaoOuGu3QWggdz+XKmg6oGm5ZrF
		6qxGk5xtkzj54kDMvEOogFGogEr7qx54hrV+PIh0QL2aJwz7vEhI4bw+NcQqaVBE0jA4MUERbPWY
		b5aebxM47PzWbxxObKmAW5uc1zdNAp/+6W3YhsmOgEXY7Cs4hiUYgSVYgmMAAzAwAwgncG4IhzdF
		bYINJwJEg0mYhSpgA4pNAdrO2FmIAjmYBBLgSzqYhXUcjSiYBSbYXBJAcRVPAXb4gklggqqUA9Z4
		hB9HBHS0z6lYbgRu7qvmXeg+E+k+jgaEwIumtI1jtAjr7npChDQYbwcs79I5b3+5VoFpLMcaGP+/
		Zo+JBGxEwe/9ZvM2X9v+poP/Zuw37WmfjoIIiIBtwHMSWPAHv+xXSAIwuILLVgYwIPAMn4ANV+2C
		QwM5GAI2kIOpnISpREc5qMsvKPGIdXHSSIFwJIFKv/QoSIGoZIKoBFAbnwUQeIQvuIEHuF06OPIu
		SfJzslkmLxMnD1E5gUBGszRpvvKO7vL+STQvr+siDXMxR7VP6xOCCY+Ewd5CSXP1WHM3p/ZqL2ce
		tjOrkHM0PIa7fWx8ZgRgQIcIAIY14PMrWAIhSAIhWGRBvwJ1T4LM9mknPm09Jc9F/7Nl4PEdlwo5
		4He4/PCqStBloAI1qDrR4AImmHStDPgbqIL/UmeCL1B4GhiCSQgBObhKlC1x5a7q3bV1rdaf96zH
		xRvvwJInaCjv/yH21sRIO45NFr5mFpas6KjvaI/2aS8KfzhYX2CdOfMFCvGFnz+KoCcKFkAfoQ9k
		1jH6P1Z6TUB6tfUHbMc3m8bpeY2DN2VncAeGrd/6YdhsZXgFIUh3sYfwJTCHs19qN3Vqe4dqDvdT
		AryBiCeOSTgz4piFkU0B9XT0KGCCIQBuq/hwEEgBsBzZuEeDKPhwKkj8w5cKJkiB2U2BRYX1jofV
		5/544MD14zAdfMm0fJmnYZen5Og0llf20buj7n0gBzqYPZbIwV5p88D5ofCHeigHQzCEfDCB/4Pt
		+XzAWt0fiqDneU3Ih5+nBtbB/RCwAZ1nAROoB95ngeBnAdaZfedX13J4BH8Y/t4PCuA3fk1ggWak
		htyP/qDg/aBQfi9Qg3qIfuXveU3whyHwT/d/fvkff+/v/fV/fqz1Bb7MffZ3eu4HCE0CWfjzpymf
		QE0seBhEOFBhQRYE/S002FCTr0kPTFAjyEJTPUMXB1Kc+DGkJn8hR6oMkc+GpliU0NCsSZMNCDo6
		d+p05MgA0E6dRozg1mbCtVPcli6VJ28R1EXHjiWpeuUq1qzhmC6Nc23CCjPHiAoFasARz7Rq17Jt
		6/Yt22VodsqFa/fuXQV43aJhR8OmzQU32P8s+2f4MOLEihczbuz4MeMFVW7gxQPgMgBomjdz7qwZ
		EujQoD1/Fh368rx5JiJFsqBLlwUECBrRph3mdm3ZFlhHMuH7N/DUwoen9mLci+jjyo0Tn7fcuImE
		0jFO8ucFZEhD1B5wmUUtnyFDNvyZeMTF0BdDLNSocfmAu3cuXKiFr2eDmpzw60NQI/8IvyEhPHAD
		NWoMMQQLXLQnxyxfhLAeewM+8gge5ZRTj3nl9KdSfSFwoWE9FmJYz3pMcOGLCSHK4VJ9GVKTXT0h
		qYHigNRwwZ+IashRjoO+GBSCIUzkw54a+ZynXghDuHSjiTHWR9+M/vhyIHv21GOCGjYaUiX/NRMW
		yUSWB9ZD3wOP3HDlI/YUeKAm5UVhg0YyAVYTTm39BNQYYxB1jFETgLXVUmYIKtZUhRpq6KBmMBXO
		Cn62Ec5UZHVilk80WHoppplquimnnXr6KaihijqqpjTt1VZff82JhmCEQfYqrLHKiphklN1lGWaZ
		kbaraaHtCg0kzx3nmz+suSYbsrUp2wgCFuzWG3DR+iacsL2aNtxxxC033HQJsVDOPPWEUI8ak6hR
		ziMP+LOluXL4xt9///FgAxM2RLjuA/WkIS66D0wCgBo2hPBIPeQJ+K8aD6ihSTkAHAzAEOSSS40v
		NnxhryYhjKvJEAFrMkl0IFFJDcdq4MFD/8ckDowHeYbkA14I5QCZJQ8al3MgfTApFIImcgDgsi8a
		i4vHuBwCUA69D9T778CGQPxAORkFDWR4OacU0s8Ke2GCIf4+PeMXSsN5dHjaaUe0F/7goQYLThtS
		MLlTAiDnqnWu5dOdeeo5AlWN+rkCoFw59VRUUA1+uFOnrPAVWEk4xQrkrHQRC+WxLKMA5plrvjnn
		nXv+Oeihiz466aV3fiqqfq3K6mCFzfo67LDXWlmutev6a7DP2Y6ZsMOa4I+zsSGLrDba5NYstNM2
		tzy1x1nb63DXMj9PtwJllDY16D7Cgi9ZBs0eCwiZMC6F8eYzib3eD5wPhvSlO4TDJFMzy/+7D8Av
		oCG+NKzGI/cPOWSB8iEHgWUsBHjgGMFYQD9/bAdK9SggQjSWDxZ0LB8tm6DGHsC9ce3HBhLByCwK
		Bp62/WyDbHtQ0bDWtUmED2sCut8jUNjBCWKkHCxzof18M4QHhOBrvpBDC+GHNBq2zV5pIxcJ36aS
		GT1ibjOpW07u5hOzjEEoezrGKY7iKHH44RvDGMYiEiXGRHHjFOLQ4gTacApBjWUEQpnUWXyCujnS
		sY52vCMe15Kq1bXKdbH7IyAbM7tb7c52nikkIhMJgNT4pjXBc9bwhues5JmAec8hDmjm8bxNSo95
		1UsJlB4UEvJRLGIBGg+WRvSfgdWLPRT/GxjSyvaeIXghSzF8BHkSRktdpmFLbzOEF1xSpDA9ggnU
		YILCQqQdNZDIEL6xgSFuZh7xKNMG9ZjFJIbwCDnwgCOGmMQv38ZMFoyrPvU4EEHA4wtg2mAW3jkh
		OQv2vS+I6xHMdFoIiNCxt8kwn+ZEp5R8ec769TAEFqPGwAhGS2i+TVzjoqcJ8vEFauzTR/lA5gOc
		uDq7SfFOBsgTUfg2lTig0VErSMApwgEoRYXjFHEQxwrawDhHKYVQkoJjHPOo053ytKd03OOq+hjI
		oRLVMIO0C64UqdSlIpI5qzHWI6M6yeD0rqrI4SRWswqakFVPJSQqSIww4guMeDUhYz2r/0Ao5ou1
		ntUXD6wHQtiKEYwUzHprFauPfNERKc0Vrb4gwljxgAcfxUhKaL3aRxRSMK+C9SNuZQiGHgDMwt6V
		sA9UCUGsN1fG+jUh93EZDzrSV4xQjK9nLStIMiul0o4Vr3MlkV4de7XF1oOwLEhDavXqI4GQKCV0
		mxNH1YI3sxjAilecSjjOOFM/Mbe5zkVKG1awBG4IAQxgMIcZ3FgWoODNp95VCwjm4pYFiLe8OhEv
		W9AQxfOyVyfLcO930wLUOQm1qPaN3VHhktREboap/gWAchrJmwEPWFrOsWrvtKpgTn5SIAUxSEog
		LJ2CNDjCXbXwhSuM4U9S+MEbns6DPf+M4RBDmJzqEfGEIUzhrkq4WwKzQRpQ7OAVg1jFEpZxt0ic
		4hmPOMQJCXEXliHkIQtZAVWgwuoAUznKESVyrBjUNraxg1okQKbL9dM12qDlOJxCCPJQRhKWsARz
		vAIMiyDLkmOR5DWvOb5r4cIkwisHJgxBJyHwixwYRAUmzGLPs2ADEyZBBbVU4RFUqMIQKIOG7vg5
		J1UIQQrYEAJFy+EGNHjEXNRQBZ3OFzD1vS+oY5Xft+z3v00V1ql9J61oTW8evEOwtXoga1kvmJNc
		1TCuc63rXfO617wmz+98/WvfCLvYxq5wGpK9BRAwu9nNJgE7FiDtaVO7C9a+dhciV7j/qDCi290G
		RgsCsQQ/kNsPYnCDOVoxbmWIAQzKGLcf3G2HQDgZ212gNr7zrW9qC9lUbt4JFYZAhS9EgQQhoMMN
		HgACgtOBC19gwhce/oUbdGfTaVnAEFJABzTMIgpRcLjEI84Eio98FnTAOBdokI8ULIAFFsdjpwPT
		ulDT/FWjdkupTa3z2m2r1dpCsLCEY5pZQwACwjj60Z+h9Fn3AKtM78Gtp+OLl+1WOmN9WYuPrfVi
		J7vrXv862MMu9rGTvexmPzva0672rn+DHSR4O9yhHYUbVKHudr973dmhd70Pgxl+/wbgAw+MVaxi
		8Kv4Qgv8YIdLwCMbkvBDNiCfjVZc/yIUjc8G5iUBeL8zY+/swDvoQy/6I1MBBHJB778rPQtLTYIO
		6ZLDJNBQhSgsQw5ReLjHTUSCtXyBHXT4gumpAHKI32AZXCD5DVrPhIGlIM/Y3H0eY16TT9e8+oq5
		eVtyvvPtAxjo3v++cUTTA2FAoBhTOH8x9qH+9e+j6BCgNSR8A4lZP6Po9YcAJBrMhLJZlAcMY080
		PYIJhE9EVB1FVN1H5EPVecsCbp2GrR0ERqAETiAFViDBeRwGYiATjNwNdKAHfmAH2oMIjqA9kIIJ
		niApnIAKriAX7MAOfIIkfEIlSEIMfoINwiA/fAIpfIIVWIEOkuAIgqAQDiERdmAKkP8ATtTFv9FB
		oG1gw8HAYExCCDABHTyAHBjfLLBDd2jhnxHaA8yCgpBAwW1hxTEBCSTaGX4Bx7FDCgzByDkc9MGc
		6gTVzFmfHdLKZNAO9+1hroCfHz6H+MkaBOzDIeSAO7hDDuTA+S2iIk5B+kGA0nWd0ikdIR7C+uFW
		9ZAQwNhAmSRMwpVDm7xI1eSDhZTD74SIzNCLvQyBy4SAF/xHfuRP1jlg9fwWm90iLuaiLu4iL/ai
		L/4iTXBOmjFZkzmZMR4jMrJCSBFFmnEOMM7JMuCEv7kZCYAACQxa3Q0awuUEFeweGgzaMoCjNl5c
		3S0AO4QXHSxDTqjjydEBG+jEO6b/o04swHulI+rZkfTRBPXdofVhH1toHx/u3B8O5FVBwjMcXfkV
		4iG6gwAIAEMmokMi4hRYokSsFSLcHyFOQQWMQgVUACZ2iy8sH5DgATLViytekziZyyww0w/pUG1t
		CUzszyMAU8IgTH/QoobZ4jPuJE/2pE/+5JoJ4zASYzEm4zEuIzMOozP+5AJU4zLQwBJGpVTaRT6y
		jqvw4x3641oAZEByH0F+3/yVn/qZnyG6QyI05CE2ZCIEQAAkgiLQgjQQwT3cAx68zCHcpUbKgARI
		gAw8wyf9UD1wgb5wAQvA1SyABADUg7mwTdA8EMiYQMRogiH8h/4AjBq4zRcCDDUE/xtOVk8a6CRQ
		hqZojiZpro5QDuMbIaVqLuMbdcJQxkLnhOYCpAAVKOFU3iZuntcc0lcdYmU/5iEhdaVwXsZXIlhq
		CEMx3GVyToEAJEIieIM3OKdzQmcA0IM3FMEcjIIqxEM8zKU00AJ4VoAMyIADiAAxIMIntc11oFAM
		gUcazILGWFOAvMgslIO7cIiFPAA1pEHHzEI+aMxELd8sFGZmdeZ0fOYTlaaCLiiD8mTnvGbl6E1r
		CoXeQCjlxKZoziZh3GNudqibVeU++maoaaVacOVwCmRxJhgkIGcxtOj5KYJz0oMxQCd0GoON3ug4
		ZMEAnMEZxIMqjAJ4zsF4ZoEIiP9AFqDnX6bEXX2VL6QBD4SV2lxWjJiiP+TDI0CTPzCEWxHEY5Hi
		BB2ggXYLgjYomZapmd6i51iomg7l55BmH3Goh8ZpT4Fob4oozZFoWpjoiaJoiirH/AnDPiTnIUxB
		DsCoN9CDjN6ootroOIzDjvLoAGTBKIynDBBDFuzlee4ajfWYg81LRACJBf2YjVUMZ4apmILmmaaq
		qjLo56yphYKOgr7pXdTjTtDEer2FbaIXOm7cHKkXT8zFrsqjsNJBsM7pbnpandopqOEpT+jpnj5r
		9ykHz4Xfii7nixrqoS7qouboo57BAETqeBIDMTRqoyKpgUoYsWjYLJpqQozpqr7/K7wqqOnMa+Y0
		qKy6xRmyQcelIxdUwfI5HFxQQZyhwZzNgpzpGZ+BABfUmRzUWVsU2qHNgqJ1BwhMgsHSwKNF2qQx
		oRtOAhcg3MFx2rHK3FUq64gCJ1JBq8oWku5M6zxAA6AO6iIqQo1q67bqKI96a6SKK8+SKyKsK7sG
		ba+5a7wWrdH+JL2Gzpnea1wMgRycIRWiAQwwARoozcfyBQxEARMygRxwgRhqrcMRn8HRQQqELFtg
		nMbRQcd93MTRge09HPKZnBywQ9jAwDLwz07Racma7H0x604468oKZ8tO64om5Mw+pzfYaBEsLuMy
		LjF0q85mATEUAc8SgwaIwM8K/63mch2qHq3nfm4vJq0CvCvT8t6EbKAc6AQRfAEdhIDA4uoQHF/s
		scGATAINsAPtyUHbth4d8G5b9B4NMEHwOVykRQEaGB/ytZ6C3J4cbFPqiqyq8Obe8m1R+a1OAG7g
		BuTg1g5o9MAgCuoUwOh0XmfjMi635qy3ZoHkFkGlimuRZu7mxu+uEe2akYr93i/+5q/+7i//9q//
		ggoulq5aoIHBpcAsUGHtpcAXqAEXUCFfwJkTcq0TWiEW7hkUMgEUPuwXhuEY/pkV7tkZ3kAaNtym
		cQE7DAEb+K4cRi+yTi/1DpX10gH2Zq/2Hse0ht/4FV2LDmoOSOf40ugcUG4WqP8C+qqC5M4BErfv
		+wKt/DaxdNDvqoQjG0wxFVexFV8xFmexFm8xF3exF38xGIexGI8xGZcxFocXmwmwHrkjXaRjN1Kl
		NQ5atF0jHVCB7/lqNlIBG4yjWkhGFUgGOvqqHR8vGxeyqfgbra4wHyXrCwdSDM8wDe+htBJu93rv
		IPIwRKqldCqCIgipdnInd/7oKCAxjQ6puToxKp9qgq5KFVyjs70yLMeyLM8yLdeyLd8yLueyLu8y
		L/eyL9+y253eIm+onBazd+mtHzUyDKOsfkUyDU9yH1Lr/N2f+S0ioTYkNnMyJ0sDDMzlXBKBNGjz
		JoPnR6ayOQsEFNsEG/ieMbf/szu/cx1Z45qpMTzXM1WO7PQxsjLjFzOTmjNnLzRHM7WOH/kFaotW
		szWfnyIWwwRJhETQAiMKwERaYjmfcyqnM00sQxzaM0d3NB5lSh5N8SqTrG16tEkPMD7roz7v8+s8
		8j87M6xVcg9MIvkN4vod9CEUAyQ+gySWn6DeZfs9Q9RZtBNj9Dfy8UkntVLXKi+eyjKww0jnMzEv
		tVIjM0svs62k7Es/M6oB2NA9naxN4kG6XyRK4iSStdIhwlATtfwadXBRNVzbc5INWZLtBQGzMEnD
		aVzDs1VfNSC59FYDdFd33/MwXWg8HSSoHVubs1vf6l4/tjEfL5ENGb9N9unh/wUy6zVPce17aRwX
		LADZMoHWkgDrkjYdmDaqpEA0XqFOiOFpa61OMAFoy7ZOnCMapG01Qu8wJ7Nft3Q/41xgC/b25kqt
		gQbZmUCyOdhiX3TnvjVkP3du6iOYjJy0McGEcEGzbeAjVMFl30Vm/9sywIDGkUDXlvYkVMEkREGe
		3UCeqTcXpO1asAMMkMAypMAk6N0kTAJ7Vxppz5l6py4abBMdIMI7IgI7KzIdunBvi9pvZ19ww/Ry
		2E5xI/dH+oPXUXgaWMBaL7fQNjZ0f3iHHi8I0FnpgUA2RsEjREGJg8AjRNs0wsV3/1t+U4EcUMEH
		x5nbaqHITdwXPMJGqwUTjP9375HA8E0cCYzcBiYf2boTCKjByD3Ay91RXy+4b2d1Mz84VwNi9HDS
		cJQqD/CABQAbcADPhnM4u3o4iKe5VLLKiAucsx2ak1OBnFOBj5ueZqM0Xkt1SX8XwX5B65V360ks
		Gnjsf1+jGvz4r3acAS9D3XXtx703O5gIxMEZDQxBNnmsHDg5fEt5Slslb1M5rAA2lgduyyYbcXdS
		l4eMJDlLtJC5mTcxmqu5rMcXq+yZm4PAAoDAoYVAFeyxnNf5nvNFp9NzT+lu295AxFFGft821d4A
		1equZp9weuv3NaZAs1Ot8cqBnIWXrQT58dJx9A37SoO6Y4j6qKvscC/SgRX/pGj8RowJTySFeasz
		8asbaKzPOr7zVK0vbOlNGxV4XK/PObDfuXyJ+1Qv4TS+uKxPObmHeoP/47lDuBe8Wu8Ix28Aj2ws
		i25Q0m/Ue/zee76HvJQvgK2XnpAtABdMyGD4+sBjtsEHu8iv+cs3vKyYe8Sv7B8y0u/Exm30PG3I
		BmusmsdvLsjHvNHbNcmTOK5LGxWkwIRUcct798sT/NH7FMPT/GPY/M1D60A+VWw0AgGEPQHgBgLw
		QNArj2oMveYWfdW3Paok/a2rox73uK/TuVNSfa1OvdvLfJ6rtIJj/WJo/dbv6fdZ/GoITxhsgOKH
		PbMgD9ozktp3eHM79t5X//6vwr2cL72cp4AazLnd27nL972n473l4+PMAz5kCP7gE75VRUtryMZt
		EIDi38bGB8dw+F/kmyrbl/7e1zqd7fGbQ5yu//rdh/5ukz7v9+rpo365P/xasMDqDz5wQJJuaPjE
		J1KfZr/2E+TkJ3/y+z4Klx57SPqbR/09iz6xez+no/+4M79ROb9aLOyBzD/917/93z/+57/+7z//
		97//zz9AGBJoaEhBgwcRJlS4kGFDhw8hPgyh5kEsSmgwZsTIBgQdjx9BhhQ5kmRJkydRplS5kmVL
		lynRLADBZAgVKiAWVKmyYFnPZSBAPCLBE81KNOxoaNS44AabZUVfRpU6lf+qy6NJlWJk6vRfV69f
		wYYVO5ZsWbNjc96oupZtW7dv4cY1GbPKDYtZN3aUCxMkVJZ+9wYWTBLNT5o3efrMuEzmI3YLMBpF
		ijdm06eDMWeGORnv1mVnQYcWPfprWs2nUadWvZau3Yt4ObKMEoVkFLUrqQxh4jE3kyomqdCmEwVE
		lFkk9KpEI+fj8pHOmUuNsiBqlRQzmdz2+JvOFybfU2wHWVekViZq2FF5CrvKoyrrJWPN6hnwavtx
		r1L2TJp/f/+m7wtQwAE1a+0u2JJLaZZJPFoGpGW++KJBkxykgwsJPeIiCjRCgGoZGkLigkE6HgAh
		BBoupEHFCpvzK6NZIqP/I8EYQUADxvpipCPHvh4oikUdW2wOpEmiYGKSG7gYwqMobPgthS8euOE3
		JrmjY5LdyvtJpxoxUtFLNKhgwyn4lONsPsvqI1BNq8xUaj//4IyzLADXrNPOO5VL68CsYlspihRI
		UGOWErsbVK0vZmkKhuVm4W2WWWgL4QEsJZ2FiC9SCOHRZf70yAY2uhsCBCJmsaHEIR7VbohJHtmN
		ilmE0jRRCz9adVILaXhkklt5K4jB3I4jQckvGKSJDiZmUeM3ZMMLYVcJc5uEOjpsWIYJEjySA9tH
		5FBSxxHp4NZbNGxIsMWsykM3Pv3QxNPdk/LrzDI56a23KzrfzVdfAg18/41Pc0/CNArmjkxht0lS
		SIELGiYhgQlJoRqiKC7YuUG7L9RqlAku6Fhglp7ouCEEjx4AtVGMwy1KjvDQeISGBR6hY4ikFlBD
		5Rsa1THmoGhQUg0ZY9ZRSRDU6FnlFB5ZJoTwHuCUtiHYKZKGRH+moughlqliWCW5CO9YEqhw2Yai
		PPaIHZd7PDbn55QiTKOW4j3TqTT3dTduN+e1V+//yKvb779P65eyPlXC1OLhUpgt5MQfefQ9AHJG
		w1uMbxDuWNo09tpbmdUKW0eN1RrxC9ps/Fzmj0b8LrrSbZx6atPpWMbbSXr26FoibWbjZ227q+K8
		WYYggbnWbZhkEo5DwP+2a4+UDQGGWVjYrexwbYB+txDYse/updoF/N3tM3pz7/FFw9f789FnTU9/
		lSI8peyikDA7drhQ+gZ2mKDhNzW4KNmjSZwiBzZE6CNMeBoakLUM+t2ECouiQwh2w6FjfYEGD1CP
		HNhBAskJzUpUqAIVLLgMbTVKg0qSXc9qJzs6aHASVAhUB0UIAnYggkGPkNANmKA0djwJDVXY4Akn
		sQw20IAdY6ODHKKwDC7MYgEPWBIROjY0Jw4HBlUw4mrAp5Xupa9OaCCBfPDGFfKN8Szm4+IZ0YgS
		wSGIJcerArYARYcULMhJC2LDyIjlETRM4jhyzJ5HUpA9HEZBU8xJQRX/uBDBB3hJQssAoLOOQwMm
		oOELhZmkI9FjpOAhkJOXrGQlPYkGLmDkUR3y2CZbpp4eYQRnargBGqKwKkoWppIeUwMIrsTKEBQE
		DTeQQ0ZEBaFe/hIjkwjBhiiTTGUuEy/LIIECfBLNn0iJS8y05jWxmU1sZkaBYOSeGMkYTrGYMY3l
		NKce1zc4gAkoOyHZEB0y+BwlLYYxC7DnPfGZT33u854kYAMJpMVPi9kTBDfAZQr4mc+Z4CShDb0n
		ExjqUIlOlJ8FBcpFMVqFKPgzohT16EdBGtLE7EguHmTfNz8jTpWWpm/ndKk51/gvOwUSbpUsDAjC
		pBOd7pSnPfUpT7nQ/zh2/LSnj1BDFIiaVKUulalNdepO2fGFDJKAqlUlgcH+NNSnbpWrXV2qTUBA
		JrmgIQXrkRc4V6pScr6Urd6LafvWWRJpzpWudbWrTyhBibvW9WUg+GcKKjcbwQ6WsIU17GAtFtjD
		Ejaxi3XsYyEbWckiNrGVtazFosAFxRKWWImc7GdBG9rQ3iCQHOmJNq+5DCpc56QoTWta19pW2e7r
		rRpx3xnRAIIq7Am1vfXtb4EbXOEOl7jFxeYCbENVdiyXuc117nOh21yntNa1r1VrS2eb3brVNiO3
		5aJqScBb446XvOU173nRC9wFgA0yXnLve+EbX/kyU3zWJWNsSyJf/f/ul7/99e9/ARxg/+ZXwAU2
		8IHjm9u6iLe7cT2fEFPA4PROmMIVtvCF6UtNs2K4Mmi1L/nwyzYOjzi9biMxhX8SNQmjwbvoKwwb
		XHNiGc+YxjVmVxXCeuL6fnh8IRYJgoEcZCEPOb4kIfKRkawi7ualnEu28ZOhHGXyMoUdOSbxjnms
		Nx+HJMld9vKXjfxlMQvYyS1GiSg4wYkmrJkSAnKylOEcZzlbk8pWHjGWs1yvLZtkzH32M39TgmAu
		//m/ZXawSWTxghfIAha4IISb0zlnSU+a0tyr8oYxjOc8y2nPLVIyGuBLCEoEmBCPpgOhUQ3oklCC
		EEAu9av522pUG/r/JcBQtAiagIs20+EcdHgDBkLyB5H0mg5/ELZH3uADkvyaJI44x5srHW1p6/h+
		duawpjcNp057xBWu4La3QdIOYvBCJbwARwVkcAdTqyTVYCaJEWRQgXGo4yV5QLcM8L1ukeRBBqIA
		SZ9p7RJYvCAZfegDKGDhkSfQoRlw+AMcxlDsD2BgDM2IuCOeAAcDjIHjzcDAGzzxBjqMAdg+UHYz
		YjAGH/wh4j4gOcbpooUVT5vmNadwQS9NbQ9nm9PYTck4xuERoNMhD3e4gyhEgQpR5CEPRrgDGehA
		hjuo4+gfGYcMnF4BI0QdFUonetPvQB0ydP3R7e4ySex9B3jLoChG/0BFHujAizvkARX0poPb4e4R
		uZ9b7VS/A1ScTm97E0Lucwd4pGUq8DRTABcU6INHPEEHOLxhBnAYxMgB8QdPYCDydOgAHAQBB8v7
		wBNweMI5MPCED/igA8BG+RM6MAiIe8INEx9ETPwgc+pmxey99/3ve29NnFs703njuZ59jpJxgHsc
		4GhHBcBBDFQ8nxeuqMAdZAAOUciAGOOogN3VUYF2eMQI6iBDuqNPCO9jX/voJ4aDgC9kkhADHB5R
		hxEogQpiYF8d4e92BQjhDvZPBvLO/iqABgiB+2RgHAJQ3r4v/ESBGKRPBqhDzAKuJWCBAjSw8ZpA
		4Qwg9AaBBhaODv+eQAQxjg5O0BMabhD+ION84A1ML+VGsOGeIAYcYRDc4A/cgOKeICYuwQVmDiNU
		S0yIsAiN8AiRMAmVcAmZsAmd8AmhMAqlcAqpsAqTsJqSafgw7cIWIAV27vj4RjtUYvm+bRkkMA9o
		IPyqz9ua7/kW4PnGjw7CjxCeL93C7w5QoQLWkA6a7w7zkN7iL8hIQgZQgQ6IgfsikBiMAPrCDw3C
		jwwkcBHBzSPsjRIqEQcq4PwK0Q4B8A6uz9/G7AJZAhawoBRLERc8gvQEwQBmwBOUjQ4woBlI7xXh
		wNdW7g/O4QlW7hYHYQxEDhaNbRAMwAcWzgd68Q1igh0yIAjf6Cb/MOoZoTEapXEaqbEarfEasTEb
		tXEbubEbvdEaM2gLNUILdSwF1AMMkU8MU8IV+o0XZMDbeCEP84D6uo0PnS8T4dAjQADr5C777tDt
		RIEM6e8fUaECA1HQRgIcKNAIrA8SFXHuGvERu8/pCpDoKsASLxITNZEOOFEU0ADeGPDUvkwUV4IQ
		QOEkTzLhQqLzVOINmqEZpuLN2OCPtKsmBwQENCgLq00cK2y9QAAd07Elwq8CiJIXeKECUCH7qG/o
		uo8QJND74vDu7o0At6/rXAENuo8jXaEqUcEVZO0gD4wktu/evFIABVAdBs/eRMEsicHuKLECRMEd
		D5EBPdH70BIu/4HO+kBxJBEPruQi4lbCB4AtJvtSI5zJJhFzQMRk98iRxIToJ4Gy59QxJQoP6ojO
		6JBO3Zju62igHYzA3twy7ozOMqUu7L7uNEvTIMHSwEyCIj8C70STEuTu0WDTvWZTNP+O/KYuNtvB
		6NTh8BZs98zMrQozI2wiMZGzLzLivZKJKhSIMa+Eci5rOqmzOq3TYgCFIyKTXrYtKu4w+uBPRaRi
		NRHSLd5rPEOxOJksjUgyObXrt2LyiyhjJrLKq+yzCtgArLaTO5PvJA6s6NRNJMmz98JsQJGsPV1M
		PVns0NzzpQojmujJrkjqL9pkHDeKI0QqQ/EppfZTMlsiLD/CQP99r0BFdMgQ9HxOtEEdNCbOIzt8
		YgHC5qK+wz3Eik28KSMKCsc6dEdBozttTspM7EeXKcWiYMWGE3BSVEXP6aYOI6JAAFacESgcAzLo
		pkxuVIu+kEe19F760z9L9EuLjETB9MAULMbYiD0V9EiVtMlkokkvKkIewSbkVChyTCqyqMM4dEv1
		lEsnc039dC+S9G8C9U+5KCaogCbyEyjYIDseIT/nFDkuIyruFNv2dD+7k1Ax9S/SlEH9ZlAzlTip
		gAtCwFGpAINuwD1IlU4j9SUm1fgqdUsv9VNltSQ8lbY2dVZhCkYfhggthgROFT8ftU4ltULDx1Vf
		lUcvtQu6YCX/lDUkWMQRHAEkUuFHknNaQSJaR0IBsNUjtoBaR6ILtmALUJAOwHVZMaNW9QVdcTVf
		DPVh8JMNJiGDosAxUhVSq3QzrhRPj1VPuzMVXIAfUoFczXVgzZUO/NUFtgBaoXUYyJUOWoBhi2IH
		+MEFmEELBNYjuqAO7pU9JRZho9URlOAbKmRZl3ULKjZa/ZUfxLVbMZZbHaQO+IEfmOFhYfYb6IBl
		A0Nd6QAGbICK1kRn1xVP2jUEdOIL1CAEJuIRjslRVXVj4YVYsTRP97VDu9Niu0AJtiBmt0ALXKAF
		slZlPcJi6YAfWiAVvuEbsFYLhqEF0HZZtaALzBYfUkFiM9YF//DBW89JAd6WGbKWBnZACWA2YyfW
		BYZhGHYAHxRAb2/2G+Z2B+r2G752C1xAWf+2BSaXDpiBH3ZgWsbqVlkiHwAAY/IBl4KoOCAKomxH
		Ws7Vc4O2UHV1VMXkqgzmEQ4pWFfVRtklS6cWHavWYbWgBbRAbV1gbIFXbcOWXPlBCVJhbUmBFJiB
		Dr5hD2zWYGO2C3ZAAQD3G4aXH7QrFapBZYf3b7egBSyXDiw2eb+BFGInfPmBFIJ3GMLXfbUgFerA
		BYIBDUjhG2DWEbK2BZyWKnQWD4YAD7gABkYFEaIkDYggH4gABqwEDxABigYDaFu3i143UXFqteJU
		TsPGXu0Uav/1dXd3tDuVdwu+IXOVoAu2dxiS11xbgBTqoAVmdgdaYAe+YQfGlxR2IFr5YRnylx9u
		OBi+gXu14H8LtYdtWGWTt31ZmA7CN2TFlhRSYYpvGGu5F4jFl3u9VglqGGMtV1wBlXVVggXYYQgA
		wAbkAFZgIApgIAWIIAXygQ7SAJJWNzjVqYJd91CHgCMwigQeAaM6WFhZFYQpVYSzbdvQYGu1IFyD
		d263YAdSoZHDdWtdIG2FWIp/l23Jd3yDwQUiWXtdIH23FozbSgFIIRgAVglQ+Ru41pFxmBTYVm3D
		tX4Z2ZMhGZJbGYdTQQm4mBTClX75oWDxQ4xTggVowwZgQA3/EIFnbwAGmjkK4vgRECEfqKCOzTTx
		8BhF27QmwoquZCIohuJ24YaQjdWQebdLSaIL2pcUYrZ5d+Cd37l5Y7addXgHSEEJ4Lme4fmdlUCH
		/VmfSQFvzSlr+5mf/3mf9xmg2XmdEdqdEbqhd4Bhw9iOz3QlakQf6eA9IKNGOHo7fMiajZRTc7Yv
		rKJ1mVRUiCIrGCMoHmNC1+WspNacwTBWs/lTKfhO1FVxRsI2WKI3esU3gEM4iMM4kOMvokNHjrov
		mCOpXWI6quM6vkMMucM7wEM8QsI8lIVLmLOH2uM9XNpKczemZZrnaLrZFPas0RqtaxpNKRqbcYuY
		T2JBJuQj/yAEQwR6ri/kIzSEQzwEREBCREjGRFCEglbkql2ElGhEOfXRRkgqR1waDdLmRw5bSFCn
		SI4kSZakSeQISqRkODT7qrUExyYUTMTktIyYMMhZd8c6y3xUYZXCAGA7tmV7tmnbALICrce0PH8s
		txGsTEPaJfJq19QkpwFFUAgFUaKkUBSFURwFUh6IVyrlUjJlUzqFWkDlC0SFVEwFBFBlVjxiVVqF
		Dl4lVlKFVr57V3ZjYXSFV8TbV9o7WIalWJQEWZRFbZrlWdpbdanFWrDliLalW/QIXMQlXdqGwN/m
		g/O1kFfbvhB5rmLhwSE8wiV8wilcmhI3cYVUmUQsw5MJvP+KVDhFGiTWbM1wQSUHRF0FhmBI62AS
		ZmEa5mHSRmYmpmIuJmOOhWM8BmREhmRMpjvU4hGORmdeJmZmJiZs5ohwRo92xmV8Bmj0aGiu5miS
		ZmlIxGlkJmryh2rE+2qyZmssxGuuJWxowIim52wqyK+V88AN/LRpNbXFesFZG52vNa0dobbt/M7t
		nM63da3tRGf7YM1gYc1GArZHwhEubs9BwgC2FdHhBa5NwnDU4k8Uh7Tm1XGWAXKe3CMox3IMiA4y
		57trpXNipnTaSXRIp1FKZ3NShwlWB9VnwXVcvUFmp3a+BndYbHew5Qt8R1CCZ3hevXiO54GUx2ua
		53mip2P/cuYRqufYA6RVVRvOrSvE0hrPYZvjrP3asZ3jqF3R1ZrPLbit/ZIl1uzPcaEDPWIMPMEA
		WhAOYuDyLs8j3OAc3uAJPOEJfJHi0j0G4v3jHE5Twd22Qtx2Kkd+7qd+QuB+8md/+gdUrCSABghD
		LkfGE2iBcMqBIEhHRoYJKCiEMKiEOKiFPojjSYCEfmhmTD52lISFXOhnWiiGZqiGbiiHsIeHfMiE
		ZiaIhqiIVCaJlqiJniiKZGSKokCC78PZ3xzaGRydp322s73pnf7ptZ22u93bT9zRTcLgyN3RkM0N
		TE4QfG3iWHIGXvIN5v0c4AADMCAHfw0Gn2AEjcLqScKN/+AIjuhIjuwIj0Zkj/qIpgBJkAyokOQI
		kRSJkWLnkfjoiyapkqylMCYhkyZhkyYp8mlplkJplGxkFkwJeHIyTpdhlXopWV4pliZhloTJlnBp
		knpplyTGl4AprCqJ9TFCVGbMmaCJrnIUMpF+08gJrWebFZhhEcagE4S/ExZhEYb/+JE/+ZX/2qX+
		rGXLWilbJBIXzbeAc1Xirjv33xusJRrP8VISBd2A9hzBB0QPDjzBExT2Cf5AEMie/VuP3kNuBtzA
		ERoObuDePtoJJN4pnspjnoSwngBigcCBBAsaPCiQBBsSkxAuuHFDIIgbICalcEgQBBMQGDt6/Aiy
		40QQJP9LlmQTRSHHkCxbumS57J/MmTRr2ryJc+aCKjfo+PzpKKgjA0SLjsnwKVSnT5U6Bfr0KdCI
		qVSrWr3aKavWTmO6FiUq1NHPsWTLmj2LNq3atT/R7KjmYgsaOmiUfFvgswsdvVuYaRGbygW/VHS2
		LKPjaJkjNGgI76XjogVhw3nZWj6LZueNWJQYe/bMBsRln7goUMAFigIsR28E+RAEuxmcGBg6CAXU
		rNmTJ+cMuHEDx0czNz58xIDzZjRdzZw/fw6tPLr0FOyUo/nCeBkIKlTYVPkOPrz48eTBM3k0i135
		8Y/URFkPP778+fTrh2f3hR2J/fz3p2ASBXX2DUhggfL/scEdCDktyOBNmo0V1lBGdTXGLot0MgJU
		x+wyFYdXfQhiVVtp9VWE0p2I4mgKaNEFM1vwQ8MOStTBTxc0uuDCMMPsgI8CK/qUSmAudBHMN3V8
		Q8oO36SiBTN1RBZYjU+2kOJamfHUnHOMQTcaOVhgAQo6DrTjyBhF/YEBUWaO0cw5cKBpwDHHjBHU
		HwYMZWaZRFnHXGdaosFllYIOSpd2VZCQAkSKLspoo44+Cmmkkk5KaaWWXtpoFFzcEEWnnnb6xSRM
		fIFpqaaeGmkKKjXIKoMP+hTWVwaMsRVSiyBjhRXIfHKMPLzKKWeIwA4L4oidlCgUocpWmUo1/Gzh
		Ah0y/3bxTQvRakEHP3aRQscy2CLGzzItWEuHFjQEswM/pGxBhxLDkEKKAuNGG+2yZF25mZ9aBppW
		WGgsAzDAsg5MlA8Y+ECwrBEmaxm+We4rmr0SX4YGCFU8/GfGGm/McccefwxyyCKPTHLJJp+c8TKh
		tcqyTa/GOmFXVH0yVVSB1BKKHxnUMmzPPv/cs1VbIRvUxEarhQY/Cyg5mLbqDsMPZNK28M23pKSy
		5Dff7MBM1NdKhuQW8JKiNddeH70clvo6x69ZCyccM4Vyzw13UQuz5fDaz0WMdt9jLUMFCRijTHjh
		hh+OeOKKH74ACQq2DPk/Lwf1Fa1ZUWVGLYHcvHktyP8kkMAKK7TRxjXXTIB66qlfQ/oK4sQRjhmy
		mxE0VUODVbTfui9DSjCDKeF71S6ksgPxqZBCtRbDbLHFk8zTaHzxMy6pPClaKJEK9MXvIJbReWfc
		NoQRDjx3+eafL/fAd6f1/Z/hrxWFaF8wwYVoUTDBhHY90UGF/fjj5RONAG5//aPD/fY3vyiMJX5m
		UVkKBre4CEpwghSsoAUXkAIqxCRyLHuQUConM6oc42a1KGECSqe6FKpwhaq7xgrikATZEct2WbFb
		7nSHti3IKEk73AG8fAjEHQhRCULsoRGDSEQZCfGHSuChDxVwtPZB7CwwKwoI2oHFdnTBWFzsorHS
		R7T/G5pFimzj22UesIxR3YALJKDDI1KQgutAQjSjciMcDxPAB6CBCZDAC4DsWAU6cIFUdfQJGsvy
		Lzbky4KMbKQjHwlJLWGQDRvkIKs0U0XLTWVYZgiHONqgQtaJ43WnCAc3aMfJcJwiDnEY3elSeA1x
		xA6Vx6Dhse7EMBzqcpe6I+PeyjK+ypFjGsRcwzQuF6JkToWLFApj9xDZJ/CZkS1RGAIJHkGWIdBg
		m1F4BDa/oEBtlmUWBvQmHf6oTRp8QQ0/4UIK6PCFEIwxmpGspz3viU+RPYSSlmwVJimnJgxtUk7c
		iAMoU9eGF86SlkBrKDfC0cpXoq4NcTgl7Whow2fy/3KjHFWWL0EzzSrOikLEJCYScFCVN0xFCGDg
		BjdGoFKqCEEII0hCEkYABnPIw5Zc8UpGNdoWek5xNA8AQRR6cj+8PGAWTIAnCULABE7RYalNbQs5
		mfBUUilwqVEg1U/AOVUqzFNt+SyrWc9qz31Wsp8L+mfMBsoNcUi0DbKUh13tuoi86nWvfO3rIu5q
		V08edALXgOFdWYFYVnQhFoyNRcDQyrEGQjZxgCNBFCC4JTOKtCtaQYJnpxEBHADrCh9IwhWWkAQh
		fIAbbpApGF772mMo4wrmuKmIboc7Mfrko5kdDQiw+Ud2DEGB5PQJqWhgAzn0pLhjQcNVb4CG5C7X
		J/9/pG5EsDnWRU52u9ztbsnUytYGuZUoyJTTKV4Zy4XOzmfKFGHPZjc7T76yDaeQ4TI7EYvcbnO/
		/O2vf/8L4AALOMBnGbCBD4zgBCt4mxUjq/v4ttmtjAAJa1gDEiIQgWHIyRxLEMIxhMANMHTYHMB6
		hZw6DIZjLOHDHg4WT2+JS6CmTbtDtUwIuNAtOVRhjwoMAcDO+QU63AASPfHxMmjQFnb+MQpEpoM8
		c1yFZZCAC2iAKmaE6t0sa3nLjAFveNvKEwnN6nLHMEMcXimOJFhUhsAKERdBBCz4yk6+qIvDRUdQ
		Q9x1dM98PhFvAQVhgKophFPBMDoiwIgIfKOglrD/hOkkGkrTkS4OrQiHOWJXOzyTKLf3wvIvG/aI
		udBlErOgMh1IPYsFsKM6dBhCdVCtQYBVwcckYHUIAhnk3ZJaDox5BJKzi1kuC3vY+PTyl3GyE3uI
		ubxxQN0KTOlS+Lb5tl4ckVXiPDuXPhSU1zhFsDat2z6Le9zQdPBQPzgh9x6DESIQgQtOCGkWynt1
		dDUlm2t5XxjncsbBft9ZDlUlKsxi4NNky6rR8mfnLHjhDG+4wx8O8YhLfOIM7pixj+2yKih70GMY
		wTHCcboVqFnb0sZ3vqv95qqUOdva5sYKCBsOfOf5TuSuuc1362mQwkrQIeSkH14Oy4SSMobAEkKH
		/x+6SnG4EpbPXq8tOR1Uc5fx5ihqMI1T1h02aH3rXO+6178O9rCLfexkL7vZz472tKt97Wz3Oggs
		fgN+YtxBGpeQJo/x8ja03KW12EUtUEltrSgBfXqtAVR2dfhd7AIZew8HKFcgc31TPTpMUgINmDGW
		VHRBL0DqArsmj/Cc9xbdYxYoQQ2qOrqeIob3bignZZeEU3xyrhUFvKYzGvWrf9oyAeu9738P/OAL
		f/i/X0DgLqs35xyqfyZpvvOfD/3oS3/61K++9a+P/exrf/vcp75+lrGxi89dJ3Uf9CZPd4q9cyMD
		gUDG32tRg0DstQb0H8EuOlGJpjzlQpXIgBJCkf8UiCUPGSAPteAH66d+zXYNkWc3oHcZKyIvPNIF
		SpIK+NACXRAYROIC35A0ciEjogZ6fwYd6EYhm2QGpzBYFLVm6+V6PiNnsGdQ81VfdwZu/mIxuqdz
		DjgaCccGrKaDPwiEvAQCJBB+cbdW4ycTyWZ3HedxqDNyLbcLspMUoQCAhpd/UFEDoZCFWqgEgQCA
		VJgUlRAKpRAKNXMMfmAFn3CAjYc633ZL+xaEZaEEkdEFLNICWtAC6vINkaFDRNQCSrAFedgCeBSC
		ogdoO2d+HhdXqBNLyDAu4xIIgOVXieVXfwVYNmVTp7ACaHZYiLV5m+d7x9dvBReH5YaD2dFGpaj/
		iqtoL1qXfF1mhEhYE0qYiMdwOhW1d1GYOX7QfgAIFUkRCP9XCTXADC0AhhkQCptDf6FQCazQIWeo
		OWaQgITFgGDBivfCgfzQAlfDI9+gBErADMTjjUhyNYlBCjWigyIoGoJGZnjnbOGQBPYgj8OwDSnQ
		eu01UHICX413UOJAg2/4TOp4jcD2imjAHQOJkOIGYPayDOxQkOKHhLRYeh6Xd0/oUkhRC3ZVQiO0
		OR25OaHACkzBCszYjJUAFaywOVTBM8iADLLDjxMAeffVgAnZLtWwA8swPHP4IkrQIuvyDfzwDThp
		GPBCiJMnkABVgsfQbBOAi/E4j/W4XtJIUCbn/3HygG+txw0jZ1MtJw51Vo00h3NSt3s0KZA0aZZo
		MzKEggYkQAMZA5HjJ5FJCXIw+YSBkAF3WUKK94t7uZd6+Qm7ABV+yZd8uQsW+XLXEHMyaY0JCS1P
		wg9a8Jj88JiCwQ83ogWCAZmPqQXfkI6GGBokSGaPp21OaQ8pwAg3MDtJsARLIA+vIAStaQZXcFpC
		YAZT8QpL8AohBgavUFtX8AqvAG0ulXduCHVlaZbGeZbJqZYp81h/MihowA5t+SdvOXcSaQDM9o7a
		5pGReFeV6J18BVjbqW2OhzreVks1SJafqJ7ryZ7sCUUOqI4kyITHgDrBmQRRwAinmZ/fIDtugP9K
		ykCbvPlarlmbOLWb5sBSvJkEuckNDOpSp0CN51lDDIOcl8ELnMAJTaChlCBuFaqcH+pnwUcQwMcY
		ggKd0ilJsSiL5HcDYnZ3ZoZmaiZn04aPwoJtqSlXhBUHLpZncAiiZxmfSDmf5TmaXwAMwLAN+yk7
		S9CgIpYEx2AOV9ABp/WkU/FaLKUMu3kFC+pSDsoNELqAEnosFOqZpLgWsvACLyALsIALhIAi4SYd
		Hvqjc2olmcEEahBVJSEHQ8CnJIE/jxBlJVolJ+qWKrqikhNmy2Z6x4CCjNh0JUejNepx7zU7mohQ
		MRd5ACljdIqQQWp3oQmTRXqkjHCk/GkGqSX/BKqZYjTlBm+wBGBAFUuAoMfwCldAm51kDpfWcsMp
		ocVZptIBDGkqAk2ACxxKB+dAB2+AAWTxB2WBrHTwB83qE2/gA2ehrFR0DnLKqdt6L9rBBEPAfCDA
		BqICICbxCOywAIKaIoQ6nYa6ouM1UvMpJ2eGUOJwBdwAWPLwnd+Zr/JAZ4wYB53oiZvnWL0nbJJF
		bCFTWcgnTYixhB3HqKiTZln5BatgsRbLn6n1m0LgBsqwmrlqDh0rq+bwmyO7mh+rDMqgq0nQlRPg
		bYoJlvxWkP6mFrDwAsnQB30ACrDgE09AB81ArXAwBtD6ARgwBoIwtHTwBHAQr4KAAW/gCckx/wbL
		ejA/GwNT+wdD6wNT6whPcCVaMIrcKrZXphHgyh1UwATgEa5U8AiOA34mGp2FKneH+k8uWl6nN1iE
		5Trp94J967fSKHubmHoz6GKapm8+OralaHVhy44YUmYt2wbwmATbOTtbiolJ8AaZm7mXe7my6bmf
		u6WNOgH++JUB+avRAQsYehoU0Ac+4Ql0gBwzAAevOwaA8AeegAGvSwcdAAeCAAdwMAg+4Alw8ARO
		+wQf4AMdsKzNEANP0AGDILSe4AZFOwiZ4QdgO7NmmricmhloOwRaxx1qIAckUAUIcrZtCwJvO6hx
		265z+66JynN3q4+CFW+s4zqsVEoyCnuqxP9KSodCKURRmFa4mxZj25uQZSmkmxRXr/RsJAepmTap
		LriPLhUOQFdY3MCj+JVbi3GDYYu6prG6TdCzRwu8XduzXWvCJuwJsjEIf7C0PvAGxHu1PvuzMuwI
		g+AGf+AGRuu1C3AJLuDBBjy23csF38sdJCAHavAIk2C+3IG+6ruu7Jui7iuLHiRo8apuwBJ7szdv
		XUxv4sC3M5RvPyXEA3mUQiqvojsB9ZYE/YpX/OrGgfVJCHUKAqtYjVWwACOK2SsdsPAlf4wLPiG8
		gmAAM+AJ0ooBzXC70goHdBADPhCtgvAEkBytfzAIY5AcdEDJg2AAPuCzPnDJb5AZ7JABQVz/xtva
		vd+aINvBBufBBGfLtm4LglUnxc5BnRg3OWJWegI1FfLAkj1TUEo3OqVjOi0kaQn1Qqt3VxCsaayg
		MJs6kBh4GO+JGLCSCuCXCluQCtBciGKpc6SnSZN6goNlv7Czgq33enIGUaMzuGwGs7mkrWpBCOQA
		CvW8s2Whu5bxBrmxrqd7yqhsfN+KICXRHecBy088y35Wy59xy8eWy7rMWVoxAjuzkZuzIRTNMxZt
		BoEwOzpzDLpiBsjAkZoTCCNUS4HgjCNQA4M3Bi1gAKnACrFQBwagnGhQB+nyIj/hAkqQLZL5k+hC
		zUGIwDzHhBHcSXPcQqTzOnFQStCGifw7/0qbWL+y5HRjXMC5Z8rLQtOXURyD6s//TKepbMQE7cQH
		Lctwi6K27K5VzBNAQXrxSiG7YFdRUUJj6Ae8iAwkFAh+8AkZICehcACAzZI4Q4WEjRTx9wml0AKd
		sNIGEAuVwAwuQArMgA+xoJwr0gWRETV74QI7gAZxwQyHsdmqONQQLb8Etc7F7MXzllCww4ImR8D7
		Fs+rONtgfZwBPdZkrQbb4cRnvb5pzdBrHZFtLT5XLDdIUQqLEAoZsHh+cAw1YNiLRzMeggx3yX43
		swtUKIYAmCE1sAjfOAah8A1E4QKsoC6P/aE2vQNHsgM+MSPBwDzp0gWfzYrG+dYlmI/6GP9fliAO
		jvZoK/RojSZLawbBsa1bta24X23bICrWAx0RfloFBI3QaC23Rzjc+1PcVzwrnzAGwfgUobAIngPi
		npMUIb7cUxEKJeQ5+YeMzAiGS2GMuzDeSsAPzMAKQ5KHfpHQB8wik60F2jwkqaAuE0gY9ULaX33f
		Ep3FwJKyTioEv5lTLDay5gAGIPYzgXe4MobgcbjlC36NDd4/aoCn4wswJBHL6bvj0cGuU2zhcEnc
		ZBFM5AXZzFAJgaB4gVDnu0CGdr4LgVADeq6MWkiFobAL201/9IfnflEKkA08waAFk70Lw/Pjyukt
		vsMkdeA8xAM8g2E83GyUSP7WuwwiSQD/BrTVASSbBLn6AQiaWseQWriZYlT5YmFkilndqQrOS7Oc
		5kjj5WSryv2zE+nbeyTRtgsAxbQM3J7R0F/2Km6zMKyQf8O43dKehflHf9Ye7dlu7YfO7dKuhfkn
		I9+YJN8oI0FNk2Lzh+FO7j6EPEmUJOb+gxW6WRGNTJgzFacaQ/duU5M6ArWZlbYVeM1ExrXOx0CK
		62nRKWdxVKNBBUNQVQ2ftmlBBQpkQEY1C46zg3LQFhqPSBrP8ScSBQAUHVWQAhoRVWMRSPCEP0zw
		TnSQ8oVStsAOMM5R5uearru+gwut7MLt5hhORW9TN+hzPnWzMJ7e60DooXEeryknqULz/0U+tcHQ
		3OVIf/BoMQuT4BNFuQxfkGtFWRZ4NEjtFAVVJmpHRhZcgPVTBQIhQAODtF9er66eMQuCakZ071zq
		ulsgiPdtoUfd0lxtofdjMQn3MwlrNAQ+EQU2EEgp8AUPcAOBlPgp32V3yg4aBD5VAKjgh/MUo/Ow
		SMUXbhlFr8t1Q/rqsz5Hf8BVr/RwjXKtPyJg9FOePvXxXvUKrypqMAtFBU+53xNfMAtxBwNoIAfF
		JXCz0GMPUFUhsFRE8AUpEAIDtwwB4hM2wAbwNAQgQASzYANFNQQDh+FDMAmP0FQC17bP//uC9BPg
		j/yCRANLvP4+0fDgzz/dvx+HHyrndP/4TDALahBI+v9OIQAQkx58oUNlyKQFdOjYWMaEhEI5Dx/J
		GaIQzSSFdCZWtLgMRJUqINCMpFGyJBoqbNgsWzYy40uYMWOiYUdj5M2bC26s/NfT50+gQYUGXVDl
		hkykdBzdNNDU6VOoUaVGxVnV6lWsWbVu5doVaVewYcWOzQqC3Y1YlLCyAZHU0Vu4UcfMpVu30128
		eevuHRMVLtykFouiVXuVbWDEiRUvXoxmcNq1bRl/SRFFDp1JN1IwwZwiBRcak0gwCfEAjcIhp7mc
		Parwy9FZdJhwobNgFks6N0IofMCGTuzXGk/LSUEHzSMaCx7RGWJzgZrhN2IbXw4CeUX/NXSsW6wI
		Qg2N1HSIP1oWoviDZVGiMGcXhQmNWTeyU/k+ZFmVil8qcikumwQV5Gw4zTaF2EHuAZOukklBxpKi
		yaardOJpKAorJMqoBkdSYMMNWfLwQxBDFJElDjck60QUU6xqQRVbdLGrZaggIQrIDJPMrb/eUkcd
		qfjyca+pmsrREcUcM6pGqw5rcEkmm8zISMIia5CyG46KorL1NIvikVlmqWIZAKZDg6PXblhPISbW
		i42J/jhi7igAjVvzKIzo+GI9NGLLk7mM6mSCicvklBM++ASlYxmOJgEPTRImiQI6NrKLyM4qmFBj
		liFIuCxPGmyYZBLaQniIP4XUqCIE/xhmYYEzAjWyQVXOLFqRxZucnKkmrCRcxkJeLRzMVqSGFPYv
		YIs19lhkk1XWwccKS/JGxOASRQUN1mAkFqfAGGSEEQaBwwAffDBA22MMeKMpH45pZpA/nBI2KQwU
		+uMPwY50tioll9W3yGalZIwJMwkCmB0uyruBnfeqoEMNLnpTaJKV5GDjC4LQXC81Jm4jmAoQqIDh
		tBA4Q2M3Jr6g4QEqlpGDHRLGNK6iSaioggqUVSYhtpYrQhS8RRGlo+WYScguZpXNQgSjRwi6gYny
		2EnhCzSqcHnnSZZhgwZ2BBQvimW4mGWBBxSKgojaugubjrH3XfLBXHfatVe4L2xNbf8mCbH7brrz
		1nvvvKFEEl9oFUtFDmBkASYuN/7wpJknMDDAjScMeMUHdsU4Vww43IBjDLg2/6MZOBzxIfTNxxgE
		g9DdaGaMZt6oN0obgb0BEXboIGJuvmfqN3bGQK3ioRSAn2UShVMYno3dvqjzolmAr12hFGpfOooQ
		ZrkshSq4EBnBkghaBuIQJpmlds4IQsP8SUKoVPzaBbbTOILih182hYavKE8vSxVpOehnMS83673v
		fIeahBoWIIeK3WAImKJDCgL1mwUM8Aa0qV9CcvcVXEXIbXHjoE9+dUHEkEMFIyShHmgAQhSmUIUv
		8du9cJIvxRggAQlYAxZ48RdAeOv/DZr7wxOeoDhHwKEZnjjHGzqAATecg3NB/IAn4PAEQWCgGRh4
		wwe8NYhBnAOJMTgHHFxnnN09C1hRAAAL0MCCpc1iPVG4EzsqRgU1qq2F/lohUgAGkyichmULcpPe
		2LAANlBQJiR43s/QwAWFJQYNUThhHY/FNg1OqINx+6AjMxINPYgCFtEgISEsicJUdAFYCjCOQpYB
		E5ecJjGkVNYcebcYR5CCH1jAQvSW8RbNCbEZBsCiJwbxw3NQrhkdgAMcPGGAznnCB80Y3RvG0EVP
		fA4OgiimJ0zXutf97YWBW9IX8PCAWRDhZniARBXyAYM0PAAS7KACHvAAgP4sy5Vi//wkTKK3tort
		TYFcUGViqpfIevINklbR1SQ5WMlPRgOTsKCEHkboyYDujRn82EEq6BBK42xBIRhFg0Y1elFRLsMF
		dHCBEhTADzQww5T82AIadvANUaZUIV0IaRdO+lFkzRNwDWJDOepQBy0EQRaGoAIdXOeDNywuBgp5
		gyCiaVRHjMEHn4vmvAwgiDfMa17N+IMjsDqvcP1BEIMYw7yy6cKbwJBJTCDCAiABACZMJA0kwAM7
		6ooHEnwhDVxQg2/0pdNtRlSwgyWsIjNI0A0aFG4IXQw/UKoYUpSkBYrBJCH60Ac6cBKihV2WArRw
		0RakYgcsrQM/QusCF2yhDjvQgv9pRctSl6bCBaQgBTNG+w0laGEHw/gGP0or2pcqobRbGG0XgmHa
		ZAE2rdwMDBv20A1bHOAMA1BDUW31ByyOoVjKHYlal8SEfPwsDXJABAwQQdcU4CG9KWADIliwm31x
		Fw3e5Wx97VvHgValoIrtFWMTw9IutMClpHCEEmC7A1Ko8rh00IJLW8AMmtKUGaTYASk5qQdCkAMW
		DTDGZu9rLM/SgRSz1YIWmDFSfpBiGd9oAT8YTAcEl1ijLQhGF75Rh97SgR9K2EILutEFJQS4Bavd
		AY9b0GI6xGKkI81pGHfKGDSkwB5TnnJN6ilf+kJZMglZAAhaIhIwDygkcnRyYD//fGY05y6/ONkv
		f32FoQZ9VpbfcIEWbpwK09b5GwpJsWhbgNoUU5TCpj1lZTGMYWOIIs3GUgIzmJGKYeygBV1wMT+G
		0YIdTJSkMI50C0jZhc+Cehn8SIUSgqyEI4+WFHhuwRZOHWmYupjJjyzzchcdGCwz99ZnpSNjotCW
		L8ymLe5hGghawzG0/cmC2mEaFY497DvaKU0vicICuKYQNuDOSWiQAw0e+JJs7xq/h9VvYt1cIf8i
		ZqRKbkFrt1DpdrNUIZ/Vggvi3QXUohYNBtbohVWgUIV6WNyMWUYqgJqKVJTYtrY1uAtEu/CK1sEF
		jma4aFNBimAwQwm4ZTE/6n1x/xxvnBTfIIWJM70DItHaXr0eOK9f2XKX07NB6CnZBCXimfNBoi0l
		04hnTqkQEJiGCZBIyLQfgT06cOE1POfNMtJQJzmwQFYZ+fnPjXMal5jyZdqZOkS+DXOBkpvN5j73
		UNIdmFGjFA20XTsdlLAMUihBlaRIsgvWrgQapGILe1cAbUXJC4ADvAFgbxBxW6CEHUga8bSl7eER
		zPjGIz7xFEYwgjEN+bib2vKPZ/ziEdzP7da6u7pGe1MFMVbtfjLXhI/5k32dKf5lpDkl2dJy7sSc
		Rr4kNrWXzcW6lx2FkOoLu3nEckZWkSgMgQs6udQDvIaegzxiEnJ4BGdCIIcbFP+KNlGYBRckYwPr
		sn5va84J2csutwbhu8SOXX++Pd7afLvAse/nR/zrrAWri1//rRT9fEm/oDVwgAzAAF+ynMVohmbI
		PcXwASjrvyxbEgOgCwUEodWbORCIAithgoQAp/IhgZAxEzrgQBZaEw98jfUAJzaam9tDGW97hCrY
		kstYhi9QAzeije77jeE7lLBRjgaKq9/omS94hKPQj/0bP7ErP0k6P/RrkBFpQicEkQksQincNgf8
		v5iYBgdoglBohiiaAdf5gy6igdIBHRr4g9ABwzfwojJUotYZgzcQnW/hqjegAWqigxgQBHqhAzR8
		gy6qQFshhyhwg0EABEJEjL7/QJa3eJItWLmXS4ztmDZ2GAI1yYjX6BTs+42ZmBM0sIFLnI5pQ5Mb
		4MGLIIHiqwKMuJNJaI8hHMIv2BQ9iRkuIIGKmIVCAZjMoANRmUK6Ib+RaDMlBIqz08X7aokXKUZj
		zAkZoRG0Gr0GmQZc0ELKEQQvpIMf8oQqcqInaIYYcIMPYEA8rCIMYBcEHANA6MbWURxeSkNBiIEO
		iAFPUIgfcoMxcAMM8MMmCUBgeIM3QMAZUAgEpAOs+qIdIquoogPQicCX4Bw6MICMYEilyAizYkgf
		kIRvUEaWQ4wQoA2VkZppCwHc4LkbgISj8MhlyD00yI5piwKRxEVTkoMvIQF+/woZ49iNANqNEKAB
		Ubk9LlgPpdOT+5kEgGGD5WiO5rhJ8/AY0BPG5DrCXjS/X+yJYPyKY5xKqqzKWlHKr/gI2JE5xXDG
		JriEc0gHTxCDeFGmJ0iqZUKqJ4oBXoIDOvglOCCrcXSDGHAEIBoELvIi0BkEagyXQfABN/CByLFH
		JslCHDCmJ+pHR/CEd9Qhf8QAGrCms3yCDhBMtzRIxvwDN3gDDMihz0kcpsIAH0IiSVACK9AmW2uM
		R1Al5uEnzOiSBWCH5xmC2hGfWUgZljiVZSAkhVCf97EI8ZGDkUCO7vkZhSEI45EDECCB4imeGZmf
		RbqISZAf5LSeA8onrFxKCP9BrCR8SqiEs8awSvEcTxfJTt1hRK5MDCzsA3Iwgjw4gXIoiR16AjqE
		A62aFyUShHMwAOwqK7KiJjBkna1yBAxwhHNoBkdYKgyYqm30hLGCA8JcElBogm1onXQQhA8wKjeg
		R2r6oimig2j6pawyHUCgAQN4grdshlzSxzcAhHPIQ9ChT29hhkuoBtRkxsX4nWKBoy6xQpmQzRRi
		JPNsJaZ0DKd8yqgcUiW1pAgNDEI4ASiF0iw4k2nKQ76p0iepQmCZ0CZwBg7gAGvgy2jyASKCg6Uy
		qid4UcF8AspJKk+IASo6h8TxBNRBqn1EUIUopnOggy6CA9O8Uf9bUkEdt+3/LLfu9M4kHVRFVTMt
		bRBHWIYSiagmZQx0EAERoCUNyIJTckinAEMlmip5oZc/KMMlUtFm0MOu+otwOQclSsSm+AgbXcZA
		JbgnrFVbvVVczVVd3VVe7VVftdWkxLUi9UXv/IdEXVQVYgYtSLCMYIa9Y71J3bVoVQwq+BNrjYKU
		gwlw8YFsDQyzSopt7dZpRVZyfaRhPdJfPNZyzR3PcoTQkqUuIIUjc6kdADJ5u7VxTbN8RbN9XVd/
		zZBzPVQkBc9/daR2k7tgMDxMazQ7q4MtmDV9bVQmND3UuzKJtRVKyFgmvdiC7dgm4UUjFdh0JViP
		RSE0aAFHkDQUQzXaMrwd/3gxfOVYxECDAEQBAhwEA1QMBIzCwPCB1IsXXJPZBrGsJijaJqAE/BLa
		kl1aYS3UsRNZJVRXpl0WJXCBChuuR2uBZdiBOmCGyaK7mEVP1+vKLNzCLvxCbxHDuQAduzzDc4gB
		M6SBO2yX1TFDryqmMXii0EFRPfSWuLxMMBJbM3MSWOgDWDhcXBA4WznExEjEwN3KsZ1ayV2QgH2b
		Yv1ObZvcvHnYenOBYIA/QNOCn8q3/DuzflUIrwwF7JJG16nGa3wibXSDygRIzazMdmSXYwKEIyKi
		AzWm1uFLatTMeQTaxwXUB1QMXugDo03cjBCEU82IvGVLOlDIhZzebE2qF/+lXtZxS4ekg6laIqVF
		DF7gBE4wWqTVXCUFWWJFVJJFX7V5VA9BAxEZCQ+R1vCVCa+8hEEQS7IEUcFMqs9RyydgSyeiA7oc
		AxR9AkfAywG+Jjg40H18g7+kHMAUzO49XZngBVy4rD4ABVhQiMV8x1wiohwaA0FInGYABLGSR3/0
		pc80Q0/ogMDcTNFkphP+g/tNCll4gReQBVhgXidx3GXpVvfVzraB2vOT2iJmWgxeT3KIgAg4gTqZ
		TzrMqvvMz/0M0HjBgM+xy0+dqqlyItGZqh1yUG/JUsFNTSfhBQpoY1ygAFxA2h2iSwVGUS/SRyRq
		0RfdRg8tJgxAImOig83/yZwIxuPNzGGkAAYeFoEmiGOF2FPOhAkrzYg9RdWMeAMGlIlIlgkDfYkY
		iIFMjgnGXeK1qdzL9aD2JeUixuAnjdITmNI8xcO9wVJUQuTAgIU2hmMHiOPInBdf4lNWtdPMQZ04
		pMc8fYK/VFEpetvTOR04sFMVjQFbjglYeIFkuCwPhkeDxOTN0cMPwAATTr0n+Ba6iKKkcp0x2GIG
		1MZ0/gPt8tkC5VtBBgS4dUMDiAHtap0ncAMD8CLv3SXvVWUMcloktNzLVWKBZkLyXOitWIBkNF4f
		hQlHKBFWstg0xtE1piUKAAUscGROdUifNYkyVAhuRVVWlSrtskuS1sMy/0xVuPgDDM4IWCBfOKYA
		zAJRQX6DGQhkclQcAlQIYqKmuCTTJ4qiJ+jGIzLIGKBMbxkDT+DGcMzTZiiiAz1LK+Ii7GqdqcaA
		GXAip07oWyHopkTiskNosF5XNNBKiBa/mI6Ju8EbWwnXj51mmMBlN6aAJoBHE45LR+DbOu5rpUDR
		xYnLHnrmNGxgvo3RuhyExKFHBH7McXbe0Ykmtp0iOJCiuHxL0DzrJzHlUzbWVOZsJqbr+2przjJt
		WKAl1cYFknZQA+jqPJQixclDtwTleREENr1PsvqiqcIucEFRynFDhTAAVv2DBW0XbzGAxeElMBQE
		R3CdZuhH0bYIzz5ls/+ebkVt62WgWGuyaMgdXLAz7QwDBfLOZph4R8a40xXqodSbbvVF16gNbezu
		WAymWQfQAgIUhJxNDAQk4uQibZk4XAF3JNOOoQYJlzoqq/k2juo+aPlecH9t4rLlQp1GW9JZWwS1
		WzTELjigwwQsiXXBgHPo7gwB8Lo2XFhoZMW9oAKH8CJ8b7I+t+t2cfNs4mdU3UFgXWp06tfNxm2c
		XTy0JicSItcpptZ5AwVeGxN/icJdXohCQ8SYZGNpcRpn6wYv1hmvcqW08a/c37Esy/+lbLV8U+V2
		Szo9ywhGHSRPqgJV8oue1TXeYGxWNIPM7bn4g2XSrgcW7v9+8+PVcqz/hHGDxvIHB/RBlXD2RIc1
		kGKmghwaOMcrZp393EYUdd7nPlHVIaL2bowlzwg2xgVQBwVHJuQpQh0vLCIuDOQ+/241NvQlFfTP
		Bu3MdfVFZWVXfmUqleXEoGWIrEMq9POITgo2vmtcOI3WCaLMMabF9CIn8gTAmPJOp/WWg/XPznJp
		17+YnuhIDSgq5wXV5mhyQIMxdoSrwsO6dCZP8MI3HBYh5nRgv/b0vXL2nXV4T99oHywqXwZy2Pd9
		n4a4mAowXJ2nYPdnn9l7r3d9lfeBpXeEz04qF6y2HpYgmXiKH5agffeG33KFH1mGz3hhbGtRiMvT
		eyrVI+0hofgf8RGK/0emHPmKg/d4+6J26y50mH9x0rZv/HbQ/UYM5+VZ4oUXg8f4xs0Rp4gFozf6
		lE/6lPeLlq9loa/5/ZN5B+94qI960sZCLaTwacxqR1gd1snw0HkmzlSi+0zTsrJGsLfLQZBuDo/L
		5y1eWf1zEP53pwABcpgGvEeCLsgLvu97v9cLuoCKpkdjVsfoBkkB2rEdqt8/NsgHRAiBG4i9ZcED
		gIIJ8Dyn02AB4IMJLgiB5AMBFhgClIkJ6jPiSBr0ea/6Gr/6G1/daXwCHm8i2P1xb/yDIzrQPx7m
		LsKit5VdAnzsHYd9NiX8tQ4Mon+KMWiHu8f7NdiCuziGY+AW6Z9+6v+nfr8PfHchltYDb18rozNK
		ozVqozeKI8KbBERggyvRHlDhyaoxlvOiA3YYnvlylAdIgzNBBABYhhsAgLCJfziZBYB49IAElwdp
		uMhZQEfOJDogZj2CQWcixYoWL15Ew44Gmo4eOy64wWbZv5ImT6JMqTLlgio3MMKMKXMmzZo2b+LM
		qXMnz5480bS8EYvSx49sQOCchqvJpUHpPInBQMcTBjdvPPlo5uMNHE8xDHiCQ+fJn0Fc3cAhO6gZ
		HEFsn3z1CuiPj0FVMTwZQxGoy6FFPR6V6WiwIwOGDYxJPIYKuWmO17AaMeLVkhFmJGM+JtmMm8uX
		zV2WfEzeCCFCOo3/SJz6MOHBdPgKJfoXTWCdX/A8mEWExCw8kKrkg5HmASR2VPDgAZDCJ/Pmex/A
		YCcHzywWACZNwpNGInNE7OikIJJGDZ58TGwgkjMxeIhJMB5VwWMDEgg1MGCE4ALjASIuLKgMoZ0a
		Q8BAxAPOTaQRR7OFNNJKD0KoUlAIUlihhRdimCGFsPk1W202TeNAH+Sgs8YJDdHxhhtP0NHMG3/A
		COM5YzQzYweDjEFDM83QiCOMPsR4jgF/nOMDkCp6IohZewXV4V8fXtTaYYiN0YmVVayxBhJIRJDC
		MceAcYUbbghhzjHmCKFMEpR9AEaaSSizxBVXKHPFK2C48cobrwjh/4Mbx0zZmiMcyvYkUjoxQcQC
		kADAxCNypEECHuxMigcJXxykBhsacmoRGwuEQMQXMKDBwhB0QDLELOp1RwIN7dlgww2P3KAfRSzI
		EdwQj0qECAlp0DDJA1w8ch4d3qUxy6qI0OHehhvNBpRIJEVYLYQTdpqtttty221FhEYLJU2EnFBu
		uVlEMREczfxRk1Q9rauXReB6eGiUhE1ZpZWopZLlGttEEMEiYILxyjFLgKFMwuasefAxHzBs8BKm
		JbHEndwUDEZpPiTGGmH0GroTE/nQ8asciMDgKx4prLwyG4iwEIK3GXKBSH9M3AeAqWogko9CzLGA
		yBAPsLCfQZOwk/+GzMdSoTQTDySNyCRooIdHfo9wYQPTROdDA3+4PbvgXw1Sa63ZKGE7s9prs902
		TCAXJS5Ngjri9rdNFhq3vRbhe5himI0wDDqDRwDMNoGcYokl1zA+geOPQz7BNW1YssLEc77ySjhy
		ysnNEkns6/GgeIe7901oHKrQAiAsg7rrIKBBR0um2/0TG5uiDgIVgd0eO3MgfErHSMtQQcVEVBwK
		O+vLIAVCFRRVsYz00zs0ERvP0xH9MmFHS/bZ35uUdu3jk1++c3AbRbv5p5NeL0Z9G6aaaF8yAwww
		LiSweOT787//5OKcghtJMEMSBhia0BlmMOgDjPrW58AHjk9B3Zv/FvjAJz4IYjCD5VtgR+Smwbe1
		L2T3Kkz8xjC/L5nhFCvwXxtWII44nGKAX5rhMbgRjlPEQRwraMM1IneNFYTDDELUjGQQaIBBdaEv
		eUvfB5voxGxJkEEUrODZLvjEK2LxQhykTQNlwgs4DEIQgvBEu+y2RbnBT1/z40Yc2gC5NgDQgGag
		IR3reAwhEvAU4uDh49oQB27MkYhWYo0Ckhib0mUxkYrUSRTHNkUqWsuKi5wkJWdyxi5iBA2gcIAW
		MJAkMbzBJm6pW0X+IJbmXHKEJTThCO54Cjc6zo+BCIQ8alnLReAyl7rcJS5t6ctwtLGHE2jDKWzJ
		imOyIhbK7MIW/0gQBSfpzSdUylElq2lGaEnRQZCMpEus6c1vJiiE0bxJiJoQimYI4g0zCGVZmuEI
		Ho1hlKZ0xBjO8YY3YMCUf/iAIHwAh3f+4Z2e0ItAMXCOvIBQiYi8VwlFww1xOO4a4kCGPSpaUXng
		0Y4anSEezSAPboDUhisQpjiGWMROKDMWIGDHId23E3JEwQ2DAARNM0RKnbiGIkfE0PYm0tOe7gWT
		3woqDYq6AN/5jiZAhd1FfqpFbDpSm9uMkCTBaVUsppKcSwlFWQSxzrGMwRNv+EBYnuAiN3TAB3QQ
		xB/SCogOxCAvgsDAWM3yBhe16K5viIEnbjovcTKRbyQ0gJVaef+MFU4AiElowQ2G4dhtLCKQXwIc
		ZSlLw46GFKThgGVJBdmJwxgSmoHNyRocAIwY3LUZM5jIjta6V3V5gg5/cAM9J3LEuh2GDrWFQwx8
		UFuKjAG3Op3ITYFEBwPQwU8d0+kRx2AAGtSEDWogQcmGAKAo0IAJTEADE75Ah2UwoQpMyE+6ZIIG
		LkwCdpMIgRxaJwc5zIIKTJgFCLgwi4Wc6iK8KS9DkBKC71QhBClgQwheQgd2zOK8XKDDDZaWk0YW
		xXtTpWo3r2rhRGYVREtpylOiMpWqXCUrW+lKXP7JIjd8hUVlCTEc0oJPOLzhCTGOgV/vplCXVmQw
		q2xlHBz3R5D/tmAbNxgyIyJLwCR86QqVrewMw+FkM2Q2sxCdQBw8C9obizAnDmgCDrrSldU6whOx
		HUSL1SUGAwyiA2OQMQYAcQ4yukHMb1jzPe+65lM2Q8x/AAQ+ATGIPzTDDWXE5xOeUBU3+EDMevmD
		JwCRZzXXZBlDWM4QuPAFJsghCo+gwxceETs0wOALaHgAExZs3knE9wudXg4TXmLp7qaABKdqMEZu
		MIQoRKEKAKJCCh6QgkvXqtX35XQI6kuEZahh04yEaoQfOeGVVPXC0oZghmsSohFl6UQTQVJe/zCG
		INFoRmol0hjUyi4dwUFHbDbAE9yQ5xkltKVZJq6OEVPYY7hx/wWZbQEjtiFkRtxAiEIQwzEGbgYh
		CNEcV9CYENwEUoSbBgxJYFiUQbrCNkx2kIYJ7RIZuBNQNGEbLkqHID6QojFhQBAw3vYg3HCOc5Tl
		CTBmy7pg/OdByPgNMJ8pDdhNh7WgBcb3dHMZ30IDswB6DPekA8zhYCS12iQKbJjVAxbAhSGUWrvo
		nQge0hUCNqAoJsuQAxducN9lTOIGk6ABO6Iw9i8sB0Vhr4jWW4cGOaQgBMNaRtm50OqGLCM3mZaD
		Gsi+Ewh/RMLPhnaFp+34DFZ7XOY6V3nXVUbnwEi2eLUkYD2e43rL7xiOC8e+GWF600MWTApbwhLM
		kDkwmCP2YP9YQuxB8/rZr0kZFefGKSSXcY1zfKE5AXkTnMEBDlhjEFOhiyfOwVt1eZJIPniCWO/a
		Ypr3k/r3zL5X6HoOQVPF6ffcESlbfA6mwwEDicYKu5oBCEF0AN40YcMDik2CrzMhCrLWP9a/i/cv
		qIHfWRJDaBcdMMEkFOADtBd8yRcM3ADOGFhFpMAQ3ID+zVfxYB0TyNoNyJp3dRc7MIGmfN3cnQ6z
		JZ6zLR7aNN7jseD6RN7cCAr5RF7fhJ7jBFBIKYH9AAMjGM7ANFybKBzrgYGbDGHDwd4VsJ5pmMPs
		6V7F9d41/N5nGUDw4RhOoIMIiAAWYIEGZMH2INdxGQaRwBz/KSGXt9GNjslWcBVGGg5GoDWDbAVU
		axjJy6khGJZhuyQG9T1djcHEMlQBO/jOMlCX8FgPRWzPAlDBIM4E85CA8ZDAAjQiHSTiayAFO+ja
		9RjPRWxK67DD3mzPphDid4VTUdEAUOEE4nmE4qWgCkZgC7piBHVeBwmVE80g6N1bvmWWEqzCLu4i
		IwjREF5BEghBEriBnAzhMRbhmiDMEWbO7l3c712ZvI1TTsiXdmlXFPDhcRlJNvJE5sWEAWzjTICj
		vLxip6AiSKDgKpZEtJVjO27LC2JYLHIRQ01TK/XeBIhDEghQEpCCqqlaCwhc7QnkQBKkQNKeOZBe
		SCXBlJ2C/5VtHJZNoztKZIaco7RIlTqGzwpO5Eaaozx60Ew0QAO4oEfSTr0RFmrc0ZS1QTgUUGZl
		FA0tGeDQEWZF2Ss5TmedVDSKludxZE+ejwmmYjqqIzv6ZFH2BDzKhCiogApkSVLVxChNhLdVCDyC
		HivVkDgIk2LpI0j5Ei955S75Ui0VUBKoUET9ES4hUxeoJTM5007KojQpBnQZpTtWpCpi5D8Q5Vzq
		pU0gZUwwgxwAgwQAQymtxTt9mzy5Uz29gT89wQwk3fmQpCrVo2HZZCwlQCi0wDdgVEdJlkZxJh7V
		UjjsUR+dwhARkWIYgEqxlFvO40vF1EzVFB04l9p8IXBtC/9Q/cy8oA5fElVRMdVr2MRSxc5vimJx
		TiVQouNF3mVe7mVzxkRfZlICJMAaYAEsVEReiBVZpcVZpdVaARoGsEVZ1KZPvGAaFZZhpRAsSc41
		JEAckN5neuZnAtMOvVFpBlJOJlAhQeRo4URpnRZXwMFqxRjMyaZtkRJbIMa96BQZyssXOmhFvMtz
		DcL5kaNs0tNs+gQbwAeBYVd3gYfM8J14kZcloZd6sZf0vFd8zVd9nYoc5JdF7NdE9BdDGE+ADViB
		TQSCKRiDOdgpIqdFls1d4qVGOmeR0gR0ZgQpVIMWxtoCFBVVoBj7jZhXgIVYrJggjIFdQOZ+8uTn
		DZb8GNb/HSFDAqhnRLWQOLzQKTgZSEGZDeFQDu2QMD2ORAVRZx6DESERl76lTmxZl4WFJ6xWWvxZ
		V7wIQtEBWk3fPfkABuBFjTDdHyAUoyGa+0GqjO3ZG+qWi7gZBnwABhAqa3mCWcUfc0iaeEUBF2ha
		R6jKa4TaqJWaJaEaFajaI7Caq10a3Mkag71oRdgarunaENzOELADsPmd2U3EFxQbFxxbsh3ej9ol
		RjKnkUorknqKIQTDLmCrLBiC8XCbi3ibt9UTjWApHPyBjnCFXDIHVZqkvaFGmDLDGtwAKUhn4/RP
		vUZOC7lnQh7DAI0AwySBD4xAGCoQFc7bTYCcyL0ByZlc/4vBWGw9AUCxFsfgnNO12MOyyMOyy6MO
		Hcy5wc8F2ik5wlrcExyc34n13MWulXNEgawGGxeg6iPYwPaICh2EABWQYFORnbGindqxndvJAdw1
		y0TcrAGWmt1NAgmgwdHyXbCp3XcJXhTIwaOwyoM5q1CuYrRKa5FSa0VQwR7sAT5kwBkMQLGlCI+w
		DVLCz2RKRipEQJZsg+HIg2haAg8xDr360A9RzinEyTLu7cSpicK9gSC8wmyFxaA0Qyi4AGt+5EwQ
		nzM4bvLRgaBmxTnwCFlMRF1cBVakmc4xnScI2hNkBaDB1Y5k6c8l2rug31Zw7svdE121XMuFUoY+
		wKTdGv87DIGokYAadMT/BSATDCAC+u4BJmB72Zd8ycp5tOJETGAFksAF2pd4bWAHGuAXiJemAOvQ
		HmnVKie0EmnWei+T6Glr3gQTGEI5mG85LEft9GXa6kthscPgoEPApJ5pJGESXIEQLMExkEnELeEQ
		3gn/NpwR2gkRthhaWOxrbIEkSILiziJGXGEWbmEX6hbHXO5xedvLDQkNZN4f3JZutcuQyOaaWa5v
		CReMkOwb3BZhVHAbokWMkGoVPE8mgiJwiiLxKKJ5gQAJVCIkIgUVfMduwnDxsEEmespraEQlIsUn
		FmJxosEykKIplqDYNNv2DmX3fq/3bq1ueoQMRiZMSEn/vuzL+xJO/LICmATjK1TM55jJ5yRBER7j
		K9yvGxPhwqHFEN6VVZxDmL3GAtiBFjDwTlSjNWKXTICjb+XEkFToRdDF5cWEN15xs0rxCVLx1Vrx
		IxtpFmsQdH7xKo3BFqDCJ39yBGQGZoBUK5lymM5QEsTkCFgJx3TMkLRGM6xF+C6uJfdkXVptCmKt
		LfskJkNeF8eEoORLYqzlWrbrKiMzK+/LvqCm6KgwXeQCLTcwL7cjLk+yLlcyNetlE0/dH+dENEQD
		CIAAuj6lIGQj1JEnMAvGJnPyMrvzO8PzOyuGcwVKa/yVNPvEPHOjNmOY9gbpcmYzPxvlMrBBCnjz
		TfAC/x9ogAjIQlLVhTuxyx+MUlbQk/NJRT6N0j+N0be5E8kGVMaalzqvMztz8jwnRjxbiUmb9JQk
		UAzeszTyJ07AlEzRFCAAFx/mVEUkMr3pVo2NJ0789E4L9F74s5BmZPIO9V7a8EHbRC0kwDaIwDRc
		Z1jV1XaqSHeyFYushSe4iPPpFaJ2gEGNFYuEND7fBN0cBl18iRSqdFuvNEvXsz1nkkjbhH+iVout
		VosMFIbeYYHq1iDgCHLlFoywlbc5qFTsVAjb1kQ0KITaFg00n18z9oX+tExUAd5RQXtltkKgAXWl
		QKnlZkw4U1F9dnuBR/6VTLrwmiSm70UwwaGUHR3E9v9EMMH2MMHPoMFydOJrtLaPRnJQXvPi7XJS
		V7PzMPXc1EItYIEKqENuQilfiRhXUKnMTQUcoMVW1Mg9yZhXrNlUhBjnmXVOfAw5fAFNz8AMHIYP
		wPV6s3cKy/VzLgA72MNx20SfXkVaBOopCYIbiHAM9FZryZYYxECgES5VMKo9ZQV/uxu7RKrnZsVc
		FNqLOBpxaeo5cKqnihVr4VwzjKpNuOgCLMMXtBdvfFcIMEEKPIKILyKqXc8s+FrJTEIVTALUygEJ
		TMKmQQRGRMEsMEEnTiA7TCAJXIoc5N97TUQUxOwsaM0scAfV/nZy/jP3IjVxG2UTOw8JpMCQafmW
		c3n/l3v5l4N5mIv5mHv5pU0CffcnKDDCyKpWYYxRM8TPOH5bCRlGJziCV9PTYMShI3CwXyfoce2x
		ElQDmtPEwaaTwkbuKalIjP0cjJkSRcSWitRc4F6fi4DYw/ZVxsLcxkKqx1L3XzfDXZfsoZ7sWKTs
		TcSoyx6Y79IBC7yEArL6c8IXG8gBCNBoei0EO1ha3AktRuSd/jmPddkur7WadjVts6TdrNga9lpS
		URv1kE45lRellQsxDFv7tWN7tmv7tnN7t3v7t2M7kEcBExB6fXNZVzRDYzpCizlCOqGFLOcFWqgT
		GZ1DWnk1/BEJpioJWXQAb/kZkXTAHwCFHyRux+3p//A1QfE5QyZA7jvNSKCtLm9x7kR4Ag3st/XV
		XM3FgHVz7p+BbvvBVbwo3yAkWgxQhPOp7jnQAOvi0xu0nOfGrk2AwBCgARXMgu1uD7Jp4BBI2op3
		V0Pc3Rc0xCzcQNJyQQpQgRr4odJfhN/JwVEswCSkwALIwQ2Il999wdalQOEpyw3ggbEu25MD6bND
		u7R/01+QMyN1hPQsQNu7/dvDfdzL/dzTfd3b/d3DPfD8WrnXhKEn7CAs7D+5iMU6AuhO7Mg6GpG0
		mKNxdGFodbrfFV3BAeMDxSX4scGLrxVioRZy4TJQwuf7gAJQgsCLvgKY/h9QAsnCgeiPPiWY/uu/
		/v/no37pKwDqK1OhoX7ol/7oA5o9wb7pg77rU8LHurBNVMEsLAAbzIIgzjhvo0GtTAIRx8QNqNpL
		/CzQYkdub9fVjfutZUR7DdjPJq2oRcHdwU6tM9j2iFfbL0O0N7vYP2sVu7/ZX1ETr444Lw8apL3a
		R0v/+///AwQagQMJFjR4EGHCZSDYRYlFCSEbEHQoVrR4ESMdUE2aZPJo5RwdR80GNXM0iA6cQW58
		ePL0xsebGHCajRH0BgNNA3Dg4Hyz8o8nDDBx6kSzwI+WhxEnZnRKA2o7JlOnRiFECWtWrVtzdd36
		FezXBbm6hMXaNZfZrH/+YIVKw2lcuXMzCqxol27/Xr1756JhRwPhghtslv0zfBhxYsWLFS+ocoNv
		ZMmTKVe2fBnzZIELQCxY9nlhZ7yZSZcuffTx0oMSLaOTIEJD7CzLKv6h6IhOsydw6IwZc/GPI+EU
		g/+m2MwNb9/A/wyy8+2GaoOs94YldB17du3buXf3/h08d7WU3pY3fx59evXr2bd3f56yX8AHBRNm
		fB//YseQTff3/x/AAPVCYyHaMFqGChCWoUTABh2kA7XoIFqtKcpA+AJDDG+AK6MxbKPMQ7kMYIWZ
		1CacrkK6tCJkAVFcdJGMGGWckcYabbwRxxx1pHGBHn0EDTQFhBySyCKNPBLJJJVckskmh+SQL/kC
		/xussPysxG+/B7XckssuKyqQIiV2+QQ3itCgYgE0oPSSzcgilK4g6to07c0T40xRLq1Ewa6LLfx8
		EdBABR2U0EINPXTQ7b6ak1GL0JBMSvqovJJS/R5rFNNMNb1LQTqYyaCUUly4CMFlHt0UVQj3g5Mg
		OSnbitE6mcprKxfJYcQODuywxhpRdvwV2GBvLDS7RVPl0sAo/5rSvkqdNSzLY6Wd9r+FKCqFlFMh
		3OJUEEBQk9pGZaXQMlH64KiJPhhsc1wUVVyREHQcWIUBBi64wBoyLiiADGfIYIONGgEWWMaACylk
		xoBpHDhhGxmY0Rl/ES6YDD8XwA7Wi9iQYwEIb/9A44ZvQ4aQBDpSYIJjukj4AqobUKYtBS6ioGNl
		OthIwWacM2KiKZlpkLkiLhb4uWMIcSZhomVS0HavSA2qr8pnK4023KqtdtMzir5h5iI0+ImFjlLX
		vbrLdu+0DJY+YFkbF0LmNLtVPDOCVxQN+jDign7yzvcCFJxBoRB99CkEBcEvCHzwGAlvIBPAC6/X
		Xsf1ORxwMgr5u4C+CdeHgUKsySTGBu71mwFr7HXmghgzcUZvazjAWKsDSRiCjkkeoQIGEtiAAedl
		QmAihUe+kGOuZSaZhY0qZnngaDnYmCQKOeQgwXY6ZnkkoyhmYQLpFIZgR/kbVpaDieGJpyMKG5b/
		mcUG62HQbFlJm5WaUqrJvh9/R7+9CyoCu2gBH12gCJqYlr8GwW0grpIML87FkbYRZxBvYAtG/mAc
		Oq3KTnF7FyWwQwZ03C0TDOiHM6whuk0E7nCmyMS9LuCRQpjiAg2QYQpRcAF9NGByfTshCnAoukI0
		4ISj2yEQGxdDGW7iAqaA4SYawEMeNqAfZIhiJlwEu6xghB1fYEcIZkGHL0DmCzpjAWQeQL6+yGEW
		VZADCOQwCSpMYiJyYAcXwlg7ikwiIykIQRRI4JghxLEKJGCCywaJR+vN4gY3eMQNhmBIN8XvaZOi
		X/0uZUBLkg0NIIBSFyqRgQN8shTfqAia1nRJ/wAhUCAKjAwvcNEHV4ICFsd5wxs6kBM40OAN5/jD
		E2bwh5qcBoOzylNWOoiFPpBjE8kMBhOVCMRCJLMQSYThM08oQ2eaQh+mqKESuQlEbwbxmSjoJhNP
		uAlTWDOJL4Sh6KQZTdZloh8FqOJVYmcR7yltFkRYwCSYsD4mCEQN3BvCAmgnF+OVD49okMMX8DiE
		j01iemxQg2MmihEuoKwK3ppECibxMUFe9AtcwGMK1MCFWSASDzfoIqQgWRCoTZKSN6jETGlaU5ve
		FKc51elOedpTn/4UqEEV6lCJWtMaHHUHBqrEAXZRiRq0IBUX2cFUj1pUq14Vq0J1gRbqwKoEyv+N
		L7ygwFhxQQFcMAgObhDEIDCAgQ9gYAYYOIcgmhEUAwDTRMKMCzGv4ysNSCA2sRmFOoCYTH1sAgUo
		SKZhEatYwx4WsZuwhmOTWbjDCu6yjVWsZTdx2MQuFrSgpSxiJ4sCKu7pOvWsCEdnRjM2zGKjJ10G
		DZZ2A5GC9SIpwBDO5BCFOk5iEmg42c9mEQUmFBcjClXaxr6ABuCC4GNrVOhEbkCbKjChR8v4GEvn
		E8n5wRRLj/HWeMlbXvOeF73pVe962dte974XvvGV73zPSwV2GKgULbjIFhRgJhJUIUH0FfCACRzf
		LVRBt15NJW71AouxmtWsDGrGOcbAE0HsBiX/L6kJW/EqIb06hW5kuIM3AlDiEh8BxSlW8YpZ3GIX
		vxjGMW4xPfTwotReUUtMKyCbktW0lhLkpeDNz34IBCQjHxnJSVbykpncZCc/GcpRlvKUqbzkBVCn
		C8zor0U+ATaGdKbKYRbzmKe8ACqQwCEZ/KpleIEFN7sZFAyaIFua8wcf0AEDNGjGG+BQpsygEg2q
		vEiIo/ELQx8a0YlW9KIZ3WhHPxrSho7GjFwEpIRcGtOZ1vSmOZ0Q7jIrakJmzH7U3GlTnxrVqVb1
		qlndaoWAgA3a6q8jslyJUoCtCmzwjKt53WteL6QhCg40g2lFDmMbO5bsCia5hokVQrxID/SQ/7aM
		qV1ta19bxdKmcYzmeeP3fBvc4RY3e+Lz44EEWdSjfkypfd1ud78b3vE2CIKocJEWQAEfu9gCHUCQ
		UQXIG+ABzyQ7PMxsU95l2e5qNnZgpLiD/dCaEZf4xClecYtfHOMUpzRq6YmVg3vJaS6VZLotxZ+P
		nxxVBEoQlGKRCrDxO6OmKiXKSQNoQVvS5sSmA7yeTQZy3MFvKOBVxoledKNXHOIR3zhqM0ZzB4Uc
		yCMneWKyNG6rXx3rWdf61rkO7s1QgYAWWUbyFCSQrp8d7VfPOc3XPhe+PlteqKjXvUpowwZ4TuJJ
		t/gPD4bOc1K87xHXuzX/LsPD3r0BMkIYwP/YwPGmU2RjE6mZcDcGGTSQgLYo0znNWEYDl8mBNraN
		Ag1qxgbImL4uPKOIz3prJqERjSJKo1m9Zf9p+YV66oexn9N5z66FAAzsVAD+rsHV+w4L++Z7IcQW
		BiGItTZD2Xk1+F7fbky8oa4ffCshCSFnr9TFyLL1KkC9VlgIvflrhS3sF+EQdjkUFKBxm+vc50I3
		OmeU7nTfX13rXndjHIudHdLoj6xnCJhgAH0HeITnfOLCeJBHeZiHZpwHeqSHerDnerJne0iACrwH
		fDpqfMpHeigifdanfWbhfWzPu3Av9/5h9yqiaDZP7HbsQB5FgJghFdDgG1rAEYrmIoYhqvT/Yhl+
		cBm+4RtkkAF7zCmUZuacTiCWgTPG6zPMzvj6o+0oAxbm5RzewCU+gA6CAg4mKC7urAs/JDIqyEwW
		4BLS7MNA7O0+yAhCqB84gG/+xiP25QI65/v65V5WKHM6x174JYr05gL8BQX0BWEyIZrwBRELEfvy
		EHXmDnSiqBClSBT6QRQyoVhUyyIaggnUIAVIIAQmgXpaa4zooIyY4IzSCI7a6HniaI5+647yaAj4
		yI8ASZAI6QYM6aQSaZEaCX66S+S+awVZsJIwIgrAbjBibSAg5C+ckAb+graOkQ4ShN8y6VtoQwmC
		AQ1c4Bt2QAn4QQtagB9G5TMqohuV4AaH/4EOUkG/6EAdcfBRHIEf+CGqlCAcuQUN+mQLaIBb/GQd
		oyoV/CTLtsARWmDf+O1LouAGliZBhKveki9/EGIJp/AyqnAyHKAJbkALMUAQZiA3ZqmWeMIRYiIo
		3sAk+qwZaskHeIMOfKAkRsJD6Gok+4wiMCAmdMkOPqAakA8GtyJe+gAXFisYqGhfnKEQEJGEMgd0
		VOcOkdIaMudw+sFe+kEqp7IfzA/+jtJ07oUN/MUopVJGyo/8yMAjxI8BdKUf7AAO/O//VmugpmJ6
		8qlHaAcBZ4egioefGApCFqqhHiqiHmEB2AEwLQqjNCoFEOnymACkRIoObqCkdjGlVuqRgP8x6oRx
		BVsw9hSyIVwmeXBGpRhqZbYnAm8gCiBKMasAuEiANr6hDsRRCyiiBeqAH4KBH8IGQ5bBEV4zFewx
		GLaKFHZAC2iTFOpAlOgAHLFRNlOBFFoAOElBC7RgGIIhGGJzB1iTFEjBBa5TC1yAHkmPCaoAfdig
		MXMRpEjzuZyuPCjylBLubCpjI3BgKDxhEDwyrdaqrd6qGXLiHOYql3oCDjBgzyjiCcbgJT5gEODA
		E5ohBtygA8Rwz+JqP5OCJ/ViK1wjsDQgC3ghUMhAFLaAQ3NBFC6AA/KQQz1UFEBUFAAmRQGl8SrG
		V7bADvqh8SbGV1KUDUT0YQYFRS/RDhj/YAu6ouPacrWgR6HqbfbgyGhA5rboQrfqqLd+Sw6EiwmI
		y7iQq2tALwWoYKGca42i61vWqDGtC7s8w+SUhTLPTeqGETMpIgXYgR0kYhaoIApw5otm4QvoYHog
		IwUArLhO5swGqSmU4Bv4QTaFhB9E6TnDZipowwXQwDmJcwdGhau+gRR2U5SIkBRqkxSK81BzMBWC
		4X9cQAmYgRnQkQizMQiDYRlaQJRIgAvYgWZUkwtk5mSWQXkUEgbVU1ebhj01yD2bAAncYBDSwQ08
		csJ2Ag4uTILOgSfOoRkmjM/cQII8wQdcEgOeQAt9aSURNAbK5Fkz7BxCQSnYDSIHLSuk/4IqmCAK
		OM470CI83nUsQOA73BU8gJQthfRBRmM07gfq0NQyc29N6aAKqmAZMEROmUA80Uwh6SCLwJMdwI4E
		EkkDl0EhWcMHl4EfFMAFqrMOoFMJ6KBHvmRjFWAYXKBU6YAUSjYVvoEb6aALuFO/hqEOuJFUXaAO
		lnMLMLZS5zEV+GEHWNVnWyDLospI2ZRnKDYFUqDf0Gy7dtVpK7JX16wyHAAXcAEU0AEdHmHf5owt
		KAwOPITO7EzPauJr2eIN3MATPrKCKmgMdIktfMDO6CAGYgA6JrQ6wOJd81Zv9zZv1eJp/6NfNyNN
		V3DsytRpv+EH/1ZxpcUiJQMJTgByI//XCCODJiyIgvbzrs5Q+hROL95iPD4XdENXdEeXPKBicf0j
		cI9icHNv7HTmdF8XdjGlcSVDOGo3VqJ2wSbjLcD2DxSAdH8XeEMXPmKXTsxNcP81986MeJeXeXMM
		d4eN7Z63XOPiVoQVEGbAI7vQclFlyypie5v3NIxXdZF36vrNAM4XfdNXfdeXfdvXfd8XfuNXfueX
		fuvXfu8Xf/NXf/eXf/s3f2NhC4KNXHMVxNbGgG93c9szMkABFIAhBvgMDjzyDZ5gEOD2NizoWYdj
		ObpwJzCgCymibd+AIuiKDjJ3DMpkg00YhC3Cgx3BABzBE0KCDLvQEXzjezNCje4UZOj/gAsm4vI8
		T/NUprka82Uak45o604vpRgdpYdXb/SABkJer4nD5mhoz3AHRHzRbRgNYyECKQUSCYzDWIzHmIzL
		2IzPGI3TWI3XmI3b2I3fGI7jWI7nmI7r+I19iwkmwW6tUG3Yxm2ir+A4ly8wEge0UDfoc5bOYTcw
		ABAG4UOewA2QoyU8wZcGwRP8M4Kaww3c4A8wQAyewAcAoa4GtCU9gSWaARD+AG0lqAME4Tb2DBDO
		IQbw80BHeBB2owNCgi6WIY+tJwRCingQMHiGBy+RJwAhMAXk4I2iZ3rkwAKxxxgz8My+x3tI4APN
		RwTVh33c5xdBbYsTYyGEL3kGlpzL/9mczxmd01md15md29md3xme41me55me69me7xmf8zme2SEF
		jGuPJ4OB0OWBiON7/Qx1pZeALWIjkOAm0kEQuBAORNkld0MmWPILH/gLATRtLxlB6SBB/8AkY5hs
		d2Mk/oAGdGmWRHmX6KAkduM2SmIo4CAknoAO3KCGaZqmXVkvXpUd1EAUh0ANKKIUTzEVURMERKoV
		efgVccaQHMmeZpEd/Mi+hoANbnEqcpEidlGRosAXUTAYVfCb/8EJfYSsy9qszxqt01qt15qt29qt
		3xqu41qu55qu69qu7xqv5xrWEmyA2ayVXokXKGKCK/iuKsgR3OA37owtEruEZxhrEv/YVxeYI5zh
		I0LiP0v5JXxgbiHoHODWJUB6JYriQJujQZ81KDCArXbJBwThDwQhJDeMpYMiBiqCWWMil+hgrR54
		KFbClEV4l2mHBOSSq8Pmd2YHBAqKAfMSj5aBL+lgFrlUdx6BIaSbMOUgo0Bgo7BbfBSzfBjzBkLA
		pBCJCFSqm28vrM8bvdNbvdebvdvbvdONIdRw+hbIrKoWFM4qJWZpk1F7EGbZJJ0VDnJZpr9WreID
		oSfDNWBDNpDQN96iOQbBABqcBpYDOWjyg3vDEYLCNn7DNyK8hMfgCSiZhnEDN3yDJN6gdm33g4VD
		EKTVQ244uUzuYcFUuJQUSeeiSXn/y7eYOkoFibhcxkodBfQ0cKFoYEs3RLrANAXEtEd22KsrE6zf
		W8qnnMqr3MqvPL0PvDLEiqwiLCWkFQ5mopMnrKbL3JVx2iUBwcAhW2oj40Iy5Ism8jbYwqC917Et
		wsPjwgD+IHOdYrHpAgxjxVFwLotXF8sPHdETXdEX/b21nDLabKxAAQvwGw7u7D+DgpKbgSciqLdV
		AiY8gaY1w9HBl9QxI3W1mNFTXdVXndVb/T5GXTJE4c2wQAPIwSk2+DdsI8JzHYT7/LEDWYFLXdjL
		7UyPN8pdHdmTXdmXHb0L958nw1jYZHb5gnd9fdhf99QNndm3ndu73dvxo3Wf3ZSm/z0vqncQrjd7
		zTBAzjczXtgiTvjaid2bv53e693euf3MxD0yOCi1EBjYI5svGJgRHpjPJJiC2eKFn2CXxgAqStzP
		apg4LrgiMpfP58zXLYjPe4Mi8rzPLfg34MqGvXcM9hzev+QG6k230KCHf6behAuIwRTHh/jzQu+I
		dYsGlPiKo7gpesvIW0vlNWmKtWv2wibn6SLbyffek17pl37K+03f98Jc0EVd3gbW9YKQf+KQ83uW
		kMOtBuEDVCK2SZkO3qCRKxkkn8AR9rOXSMITYiAnBkGX3F4QWHKtFL4DeqLsz6GXKOI/V9kNQPmz
		W3IlSKIDLLcKbOC/3nIqhme5i/9bAYuZDY65ZJL5jcyHBJzZeqD5IrSHe6b5YTtKt8gHm9FHm0vw
		BCdz3ple9Vef9Zt9ab/YjmNf9sMYj/W4ryVjoRv6oVMCEGz6bGXao+mApm26rmQppD16zxiZ7Otq
		o3kibZvBBxT0D/rMAGi6pU0ypkXZODTd+iWoJmYp7SvMzu78C65LDW6gCobATrGaDob6oooajpAa
		jn6mCuiIqWMRI7wnCqKaDQbQutkBIJjcYCJwEh06s2bduPEoyhCDByNKnCgRDTsaaDJqzLjgBptl
		/0KKHEmypMmTKFOqXMmypcuXMGPKnEmzps2bOHOiXAaCChs2VYIKHUq0qNGjSJP/Kl06lF2KKExi
		Udq4kQ0IilgpgmrSJJNXK+fowPHxBw4cNxiawVEL58mTP28Pjo0RA86gN298jHm71oDdJ28w2MUw
		aIYPs4HfDHLzx5NgH4HXOpL7Juy5sY09/RG0GdC5DoPGSFw268sXJrNoRJkURY7BZSGYkBgCYkjW
		iMsmcfnyWg5vOkOioJkkh0SVRyDYIafIhYmcKlRATEoxSzgJ50y+yJFD50YILglTELkx67Z5ixip
		cvQIUqf79/Djy59Pv779+ymXLdjPv7///wAGKOCABBboHwhspPCFVOplZJV5t6EjgQgaVJjFMhIZ
		QMcfB4nmIR0GjDHGIKHRYCIN/xxS9AcNzbjxxmQb0jHGZBw64kiLcMgomkR//EHiGCfaSKNoBsDl
		iV5/wHhQFZNMsgAXC7AhBwhocEEFHWikgMYNXExyFYRPfZECHXJEISaZcqBBwhc0gDeQQhRVuQwJ
		VHAh3HYg3NAmlVxclQKGbHyxwDLLjAkhVug1iEZHH+Hn6KOQRirppJRWaqlNyUXBYIMPHkoRCKaF
		qqenGfaoJIRjpIiqqlgVmSSERWpI6qyHolERrbjmSmuiDTLa3qXABivssMQWayx9C1Rxw6bqdarr
		s9BGK+201FZrrae8qufrsdx26+234IZbX7LLTsXpl9emq+667LbrbkTZUrWtuP/01mvvvfgWSy6z
		VDmra6o9yvruwAQXbHBW8W40b74MN+zwwxDDtK+5zaKLKzmMuDEIIDPM0OGOuc6oqwECy3jqwSin
		PGvCGi0c8cswxyzztxMr6u+soIDCSAx4weGxD0/AIaSNIMuoI4gxYmAYq39ouGOIHUZEltFKiwhy
		qq6eHG0VvlExZZVXZrmlcxZnpaCtXMqBIZdfZMmmsnSwcwOiVh5UJhplmog3lVMetMzcJLBBx9+6
		srxeozMnrvjijN9X87m6OtAEDoo188TPgojlAwZpNRPROc3A1Qwga931hBs+uJE5HYIM8lYHzcQA
		yCB/fJYiHBi44ckbbvngiWb/dPiwWDODdFC0tGg4h8ZpBHEHm2yPaAdhbrOwwc4sD5BARwpyUDGJ
		dsXJ8Qgdk4xPURSzyEbFbOzMRoKCzX3R5UFR2ECaDQjBUPhFirrc+P8ADKAAUfK4iulqK0gQxBvS
		MYgPHOQPzWiGD5rxhjF47oFvkCAd3ECDJ9Bhd2RZjCMM4MFBWC4GzcDAG+AAiGbsSC0lfAMExyAY
		R5yjLH/wgQ/SxQXtEaQKQ1DDQVgwtwc0B0J4mwWTQNClJbapCrsZE0QgMpEUBIcdy2DDEKgARDZc
		ZyAFOUhCosAQh1BxV/zrFXsGyMY2ulFxBexX2Ui1la54JRhhqR0cfDQDwayO/w4RFF1YiIcXDBgp
		BipcTGNUCBnBNENWcHhD5i5jyN9tpjOfCY21ljEEGmRxFmhwyOBiY8XaTE83v8mN9IIznOIcBwQk
		WM5EuMAFObCDCt5LgfducB05ZGc73flOeMZTnlwZblFrfKMyl8nMesWxKnP0lIQoZCEMOSJFIhMN
		8eCwIxGdiFVjMICJLJcjEU2kRz86kTrNGaInaCZVWoPWlujApCz2LUs0GIiXDhWmMZXpTNtRE5u6
		pM+5MWdOdYoCDe6mJyjtaXuAEhShDIWrY/qvmRjNqEYp9UyN3IxUoIqCSMlIA/Ok6niHMudtrvkq
		88RKZYW7FUyjZdFkbvSmOP/NqXw66qBozvSnQA1qumqKOJ0a9ahIfQlP0fBRoTr1qVAlFVF/ldSq
		WtWqS21qVLfK1ahO9apgDatOs+rTrpr1rCr7qljXytZlkhWtcI1rytTa1rra9X9vlate98ouut71
		r4B9WV75StjC0jSN2rJpYBfL2HsN1rCQjWytECsvxTb2spjl1mMly9nOHsSvmQ2taC+1Wc+a1rCg
		Ha1qV4uf0p72tXpNLWtnS1v3uBa2uD2rbGvL297G5La5Da5XKaswy/r2uMhVSVavJNzmdnW3yY1u
		dJcKgio497pRTRbFKltU6XpXuktVk62wS16gsoNK/TPud9fL2/DCEkPlje//wSzCju1yl6rszS9t
		w7soErCDKQAOsIAHTOACG/jACE5wgQOnqJapV78QDi1/M6IfA1n4whjOsIY3zOEOe/jDGlaAfRPb
		3QibOLMTbrCKV8ziFrv4xTCOsYxnTOMa2/jFFz2xjgOb4hv7+MdADrKQh0zkGed4x0iua4+LzOQm
		O/nJUB7ykZNM5bBmsVxRzrKWt8zlLmsrBSWuspjBmsUU8MvLaE6zmtfs4gXoEr9jjnNV13dmNtv5
		znje8gJIAAI5+/mq1a1zngdN6ELfOIt9/rOij8qTKrxvIZCOtKQnTelKW/rSmM60pjfN6U57+tOg
		DrWoL52CwCV60ajOKU98UQIUBbv61bCOtaxnTesBswGXp061rnFaYRD7+tfADrawh01sDcN518hO
		trKXzexmO/vZ0I62tKdN7Wpb+9rYzra2t83tbnv72+AOt7jHrdOAAAA7
		"""
		
	img_dict["ncbi_b1"] = """
		R0lGODlhvAKQAfcAAAAAAAAA/9XWwLe2pcJyO/75/+/3/2tsYdbl/8zI/ubm0SpinKqq/5ujrp2z
		1WuOtBhTkpSWnO/mzsXGzsDX95WT55KPlEdHWFpZ/8K/qSMizu7p7mxq3qbE94KFdUFBQZSThNe7
		pdbW5N/m7sfM1UZ0peXVv7i+zUdtmPf3/8LL5KyorL6+rjMzM93Y3fbx7iko//f33n5+o7a171pY
		saSk7nN0e6Ofo+3p/9XV8c/X5c7KwJiWuIWD64CGjdLf/6290nybu4iG/z5vpOXm8GRmWau0w7+9
		/7bN+M7V3vf398S9x7KReSAgIN7f7qKjlPDbxZOjxLbA18XJ9ra8xM/LtXNzaObm5v//4PDv3s7d
		9+bm/5ycpOfNvXWUt0hUQv///6e97MzMzPf//9bW1qystd3f5pyc6DNmmVJR2VmDrdTR/+bu9kdF
		1nt64t7WzqW13tPO1ubHtcXGxbGrnISEhLq69XZ0/4yMjJutvtbd7+De/66zt+/v7xMT/1hhUMbC
		8ry4vM7Y7qqn7ba7vayejLbG5kFA//Xx/7298Ht6e3N0c+/u1j5LN97ErRgYGpmZmd/m98XF/2Nj
		sfXx+IaUr4qlwbW2vyFalf//8oaQoqy+3ra2/6WlrYyM5+bv/9DN9+/x95esz62qyd7b99rJv8Z8
		Sc7M1oyOlMXW9zs61GZmZrSqlW9v7kpKStbZ3ubm9t7dxqCc85yltWxrbL2/xVVdSn19gtemhJ2i
		pdq/r6W11CkpKb3O9zhrnpucjMXCtouNes3Ize3s6ZOT8/ft1t7e3qWlpa2trbnG21pZ5tTVzpSU
		lKe48FpY2+/ezcbY/rjK7nl7aeXe5rTF96+t7ouHi9bW9tfe5pmZ/8/N33x86bW1te/v/9/ez4mZ
		t7zEzDEw0mJh51B7qczM/5ytx///5hAQEFpaW63E6lNSU9fX///430ZG+mOJsbSwtL29vXNz4AgI
		/6estubWxeTg+aarr97GtGNh3cifg97n/9jPxShflrrO5ml0hv///yH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wNlQwMToyODozMFo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNlQwMjoyMzoyNFo8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQBBwD/ACwAAAAAvAKQAQAI/wD/CRxIsKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBD
		ihxJsqTJkyhTqlzJsqXLlzBjypxJs6bNmzhz6tzJs6fPn0CDCh1KtKjRo0iTKl3KtKnTp1CjSp1K
		tarVq1izat3KtavXr2DDij3aZ5jZs2jTql3Ltq3bt3Djyp1Lt67du3jz6t3Lt6/fv4ADB+4ztjDI
		PleMGSPDuLHjx5AjS55MubLly5gza97MubPnz6BDix5NurTp06cVXyFsuPVFxGTEzIFHu7bt27hz
		697Nu7fv38CDCx9OvLjx48iTK1/OvLnz58/niCGzOmFZ1gOxC+yj3bXXK2RQiP8fT768+fPo06tf
		z769+/fw48ufT7++/fv48+vfz7+///LUITTMMbQcA88wZcFDC4JlrXDMKmR0551WxoixwIUYLoAJ
		JkOMk+GHIIYo4ogklgjihiiaqOKHKG644oswxijjjDTWaOONOOao44489jiiGMYchNgNikxzhVlk
		PHjkWVessswwE3bVhzFzoGHllQuMk8wIOgyBxgJXosEPP1aSKeaYaJI5ZphsYtnmm3C+uYA7D9Sp
		hplx5iknnXbiqeefgAYq6KCEFmrooYgmquiijDbqaKNzGCPhMFfcYIMxV2R6hRirLGnWNKuIAWWU
		W/VBBjxt8qMDEON46Y4aGJb/YEkJ/JQQhC++BFFOEGpYEsUDvlgCK5y7iCLKA2Ze6MuFVpLY7ALL
		XujOq68+MGyZ1kJgLSbRfjiOA8mIUkKGdlZ77aPopqvuuuy26+678C4KT4QGDTONpZhqyuk0TBoT
		anWkZjXMqW0u4IUX/KAIRBBmOpEMJiUkU4ID04piCRBqYFOCDsjC6cCFuwxhiSW+PGCJO74YO0QQ
		aAThzi5qHBssyV6cDK0lXkLgi6xgWolJEF5AYEmdxwaxgCVHKytKykvfnPMQPMcr9dRUV2311Vgb
		Ou+oBA1jDBeXarrpKsag5a8YAAd81cCotgnBOEFEscuWHaNhSRKi2G2JKBCM/+kFEF7sskAy57IZ
		rsReGGuyF7bSmTgaogQBtBcLBCGKA4vDmqs7OmyshtFX/pyMJf08IMoCkVtSLMJoBMvrwfzk+oAK
		noOe9e2456777ry/uXW9xuCbKaX7ogUq2hKqLRXbqXqhB5cqiDIEnjhjM7SxEGj4ABCzu4Nxz206
		gIkl4zzgQBAlqOGF5O4cvHTk6nuRa+TpexFF7Jb8PII7/CAdehAPgIDk3qeGTQRBCrRqXRRcBkD8
		CXB//QNf7yZIwQpa8IKC+l1BvCa8I42NX2c5XtqURxXmsUlVSNvQONwRJimgoQREcIAanOCODl0M
		AkAQhRTuBCejDUF+I0ODyf/UADlLoMEdFlMDEUWBsiCazB0344fOIGA38PHjVZhwxwpFASujMcxK
		vpCfxcCYP25R0X8YTKMa18hGrGmwa8ELmweLF8J/JY+ETzEhm8o3vTGpwBJj0lIJMGG6n+lABUDT
		wchKIAX+wYlMPlJfnR4QBA+FiVkjuiSI2jfJSkqwjaAMpShHSag3DoSDYTsLpzxlLzvisSp6DBOZ
		fKGGZGADG7CCFq7ChIkXQgtqyvIF1fihhmlp0U+LIqYxx4FMUjrzmdAEpSkFgkpMnWUZneLOp1z5
		yqnE8oRqOJ8vmskmEVktTeRUFDqjyc52upOC0/yHvYSHoAGF6h9laSXyuun/TYLFSUOY+OQ7B0rQ
		ghq0gvGklPCww1BKhYpr/IQK21pE0Ypa9KIYzahGN8rRjnr0oyANqUhHStKSmvSkKE2pSlfK0pZq
		NJ6IOYYijpQQhz4poss71SR3ytOe+vSnQA2qUIdK1KIa9ahITapSl8rUpjr1qVCNqlSnStWq/jSe
		8iRQgBDCGAjdEacn4Q53PMK2F5j1rGhNq1rXyta2uvWtcI2rXOdK17ra9a54zate98rXvvr1r4AN
		rGDTilV5ksEFEC2IMVxABrCqJJ9M0hSDxIoRtontspjNrGY3y9nOevazoA2taEdL2tKa9rSoTa1q
		V8va1rr2tbDtbGEdi5MB/xUoEJlSxCpWsQJMTeMYD6JXRSwb2+Ia97jITa5yl8vc5jr3ubGdLW1r
		MqRLGakO3JhDHVYBD8VMA1Q3He6pRJuW50YWuuhNr3rXy972uhe20p3uTBR6KcUsYxqMXUR9FfNQ
		ixDXs9xJwi4qGQTEgBYtmz2vZM9ihgZHFi0NNsNqKLVgswC4AGDIsIY3zOEOe/jDIA6xiEdM4hKb
		GMSUeK+KV8zi1sZXvjGZp3U9uBiwKYa/+6TIfxM8DIyhAQJAHscLQMs9a5FgyJcdRiPb9woKX+EF
		ZiiHGoaAqxKssBzDSIIX7KSGEuzMC03OlBlc1j4zOBmzfSiAMeLA5ja7+f/NcI6znOdM5zrb+c54
		zrOcyaAEJbT4z4AONGdfDOOXeM3GRypLYvDAjRufbYQR2fFmgwaBElAyCkCglJnPjNlhREGFHkzy
		OASI5NWUA2ruACARgWwJswYwYkkgAcPeZuYnlwPIUSh1ZtUMjyX4+tfADrawh03sYhv72MhOtrKX
		XWwxFIDTgo62tN1L6EK3pJo0VTQtxPborzJE0ph9gRTeJgUzoDVTSQDCkaE9PDPQ6me6ztQLgoBD
		Aw+DZZk+6zBewbBkcOfWakBrOcYkBcT0IRkX8jdnwRCHJczh4RCPuMQnTvE51OLiGM+4xjfO8Y57
		/OMgDznHK15xJbB72ij/Tzlzq23tlWCbSZCgjqa6LV54dDbL/ChHJqA9DDOMLNSdJuKYgBDvPlgC
		Agp/wa2BYHKxDeMFXiCBWXYBATVI1gxDwAQQEDMMEoiJBAbWLMMdTvKyV1wYYki72tfO9ra7/e1w
		j7vc5/52s0e86SrPu96Ty/KWp6SaRsoUN7gR+EzRXMfjvTnGkhB2pw/jAe7YbB/UEIVxcIvxYutD
		OTAh9Z7vzMKYTYKEXwAECLij8YME+5GS4AvONx6zY4d4m+0OcWFMfAMnzr3ud2/iV5Dd7njfu/CH
		z9q++/0kqHSBMYxEht7my/DcnAi4M/uCJFhCCkl++guOTvTM9mEcQHhF/+vHAXTNLyAJZrl1EOK9
		4CeX/gFI7kMSrmjhLAsT/QtvuK+FgYdbQEIYwsBmSxCAcTAHAEiAS3AMsRFxuJdhqwEGmOICGcYN
		wEUJIVY2vJeBued7tDcHwUd8IBiComV8x1cSHLQIZKAYZKAIDycGyDAH0Jdj0pd4nmUWr9Bkn/IK
		JFAO/MMPCpdZJaBzQKA9oKd5aICDAVQO7HdZpKctO2cWDzAOtbZ6uBJmmzV2SxAH1qAI77AKNxAI
		/hcHK+B/wnAM1hAIeGAB8IAO1sAMsvFwDQgGdXAMYAAJyFAHYEAJ6AAP3AAJfQAGSgCIFpBhgQgJ
		HqhhgQiIiLiIGrh7HP9Iex8ogqf1XdPgaJZ4iZiYiZq4iZzYiZ74iaAYijfGDctwBSVYEzKWgvCw
		W6zYKTEIaRAxfdSXZQOmRSUwPUA2BJm2WUHYB0qXMK0mb7vgC2UzDGqgda8XbkAAMZNDRJlGYfbn
		C/h3hfonBsxACzdAG6sACegACRYACavABR/ADHWwCHWADK5gAdj4hg34NVygBMfwDngABn2Ah3U4
		B9xgA8xQCx9ABrewCMuADKtQB2ijCIsAJNYACVfwDswACcZwDBYwB404Yi5wAytwA4H4iMB3cpII
		WiqIGiAZkiI5GS9IHYJxkiiZkioZF8lDX95leEbCJMeTWJFGgzz2PUD/BmSYwA9D4A7lYG6cJTJD
		tn0booTuNwSbdoy7kIxMuIwiMzIoww/jUHBUKI0ceQVYuARicAx1oA434AqLgA7vAA+L4Ap4sAhX
		oAgOuYpXcAsWUIBz0IC0gAe0sAKDN4/1mGHZCAnW4AqBcANioAhbiAzIIIeBWY5iwGhXgA4COQfM
		sAJkMJEidgW8AACrkJG/Z3aR2JGhZV9v2IGgGZqiOZqkWZodeAPZtQwjuZqs2ZogqRraEVOKkC9o
		IVYW5iQ0GYs2uVkBpDPqYwnlsAskYAxmxZH7FixI9ng7SXSkVwJnoQZCs4Ri04TugFZJMGr8UHDy
		hyvTKHb6p4UOaQN1/0ALYvAO74AOc8CGq+ACioAH77AC66kIbwmHYLAMNkAb1mAN74CHfbAIlNAH
		FiAGeAgJKwAJ2agEeAAJfmgBBqIEdXAFdzgHtPAOCjkHECmZItYHzKBhGqmZV8mZmqUYshEI74AM
		K3CiKJqiKrqiLNqiLvqiMBqjMjqjNCqjeHADyMAN0LGjPNqjPvob0kEd2mFbyyApXEUGXuVfuxlu
		4zYEu4AN2lecsbYaCZYEdpOcV3CMaJAMmQAEzmkW7mB6TDmd71dqL/AKWacGZsF6vmCF3rl/gUAL
		tKAIwsAMq7AIjrkKBWINYhAIehoIdRAHzHADtheXYNBoGbYMeEAG7/+QYbfwqJEJqMzwcGSAB3VQ
		opbqAn1gDee4DBZwA31QC3hwDMPADYuKob2XmWW3mSDaWcawDBKJqrI6q7Raq7Z6q7iaq7oKBlt1
		SoxhigixWI11EbIoWfMXBDuXWSRgCckgnV0Hb5JlDIPUpjs0lJ+GBkfGWU2optPpBRBjbqyHBt2Z
		WbHXgmlngAcIgHEAgOaadgNYqIa6q/IKYh26qh/aqpcVG4Ewr/zar/76rwAbsI0IJNe2pJ3GKtmK
		Zq+gBlhGfeO2ftPJepgwDsIyZMc5sUCZfe5XdZfVB1HwNqshsapHjapqmg9nBimQsiq7sizbsi77
		sjAbszI7sy5LBiX/W3EFkLMCu7Mm5wKxurNAG7RCO7REq3uR4m0iUawRe32ZNQyZ8Gnjmil9QHVe
		EG/idiZVK2+fNrFSl1ZS4AW2VnVnNm+k9gJexw8j+6YmS3Hp2rZu+7ZwG7dyO7d0W7ehKQZ6lrd6
		u7d8+2ZiUAsUWrSCO7iEW7j+Oi9IGxJK63gkQALDcxZJUA6tl7aasn2mx36klzAQOzxBsCFHVA5A
		AAQ86AsnkH4Q8wpo9QoLUAKblgwEN6aZUq5rG3HMVru2e7vLFpq4u7u827vGBg/vcAOD6GGfEAkj
		cLzIm7zKu7zM27zO+7zQG73SO73LGwqGe73Yq3skqBGLq7HDUA5e/6BFP5ZzJwedrAttSgcBWasp
		mjdIOQlk/AAOSAad3OIF5VAOOKMGr2BwRyc0sIuVDTe7AjzABFzABnzACExxFDi8HYYEHRAJEBzB
		EjzBFFzBFnzBGJzBGrzBHEzB3ZC9IBzCILa9GdG93lcCOmkrmNdpSSA5QSB13qc6nAZlC2NM7iAF
		FksCk6RF4zAOXiAFoGc9I2MJU0iu+udr8BAISrzETNzETvzEUBzFUjzFVFzFVnzFWJzFWrzFXFzF
		yMAF1vBhvdALKWAAZnzGaJzGarzGbNzGbvzGcBzHcqzGIlzHdkzClWWwNWgJ9ksC5iad8lacm2VW
		Tat9CFa5xXkWhP+ceWfVWVlpBmIVyZI8yZRcyZZ8yZicyZq8yZzcyZ78yaAcyp2cGOUpxr3AxmPQ
		DWNgxhlmABpmAKkMy6o8x7Rcy7Z8y65sx7qcvXhMrHrsWWh1ryiXlXG4y8Z8zCRmcqdiymuMDbWQ
		ArUAC7DQCbUwAmVQBhPgBM/szNDsBK08BuAMzrC8yrhczubsxsiczkTby0pqc/haWllJBOo8z/QM
		iGzDzGk8BuDAC69AC2VwC4QAXOgwDbRgDbQABnywCmCADuAgBvYACxMwAXwQ0dBcBkRwzhid0blc
		zxzNr+xcc5p1yKvBHZI3PJtJ0h37v84Vzx3d0naszPCAz2isz67/EAGPuggZVgt7aANcgNM6zQ2r
		EAE2kAu3sArMgA4WsAiQsAjqCAYa/dS37NJSjasfjXjunGTTERt9oAR9kNVbfQV9diQmZ3Om4obD
		YHJnbSoRghgmp9ZonWLqxdJTPdeFC9MyfcZjQAWK0Akf0NRgcAmrMA02kNRgQAUQQgt1UAdJQAuL
		kASNrQjbZQ9cQM5QXdlxTNeYjaFVPYNXLTZKAAkfgAw3UCnw8AHHMAdJ0gc3cAymcgPLsCDDYAOi
		3QfIwFjMcAVzOg3I0AcKSAauIAaQuZUqjVxyndnGDbR27WFjrMZ5vQhE4AokEAERgAplwF1DjdNU
		cNC0QNSo0NMk/7AIJGADnXALucAHlG3Z6M3Gx73e2ksGuWmCBguPYYkMxtDXizColroCc8oNZPAB
		N1AHlHLQYHAMrlAHN3DfdXCN6hAI6LAY21gHCVoHfpZexc3eFj6vyd1hy63GbOAEKTACoWAAfmwA
		OnjRTmAAbDACBmAGBjACJPDhKR4KKu7i6V3jbXzhOB5imy0R0/fZ3IAOx7AIoQ3Zx8AMioCGN3Dg
		pn0LZpHgBqIOg3oMN5rYqzAHioAYdRAINmCgxwDX6FXhOR7mtJrhHLbhb/yyaxyzNr7maSzmbp5h
		O16TnS02ypcYszEN0pEY8GAqyjcbi3EkxkDflPBwjgaDgfDn4P/RBzanGMJsXMT85pCOoWS+YWNM
		s5Z+6Zie6Zq+6ZEe5nGum3NeYQwy6gjiKdrkZIp26mZxHUU4YaBH4Ucsz50+67s36RpGAemgB4Kw
		67ze677+68Ae7MI+7MRe7MZ+7L7OBrR+4Z/+ELJ41n4WdijNvkw57d6XeQBm7bGVlXEQYd7+7eAe
		7uI+7uRe7uZ+7uie7uq+7uze7u6u7q9wCvDQCR9GAdTQwfie7/q+7/zuwctu4c3uENM3DMvwmH0A
		g33GGF+91WKgqVtNKX2Wdl+d1kyy5209B19NCRqv8WLd1QrP1hPuWrLruyRf8iZ/8iif8ir/ayQq
		vKZcxmwe8zH//+/sHfAN0eNLfY67fQPGsAiLoNtdjQzcCB7MECE8b6AuwNoFHwgusAxoQwtkwAzG
		oAhQz9rHwA3MYPBkAAnc8AErkHaszQWs/VoFcCoJfPZon/Zqv/alucB3LfNwj94jhgxNYAxg0I+u
		sAwZ9gFN0ASu8Ic0z8vuzRI9TiDbOKoQnuC0oA7ccI6KoAjM0NMMCuFJnt94IJjlSB11sNTMcAv5
		WQcrsAjWsAircAuB0N/MwNQ3wKn6fQvcMNyiFfE3y/a0X/u2f/ujyYcXqtynzMYqbgCwAPMZ3Q0j
		wAZxD9Uj9gEfoNCPIAa8IAYZ9ggKCABF+gHqoATG0AItUJiL/3AOhfkBVxDkgaD8V1AH0g8Gt9AC
		jaoILYAOgB/4mj34LhffB24N8JDlW86V25WYkAD6CcqVABHIBqQbN5gpgsds0Qo8t/pMqwPpGJ4b
		Kw4GwsPlGLMbxxZ9eKeojkVFgSwUVHJF5UqWLV2+vKJE5kyaNW3exJlT506ePX3+BBpU6FCiQvtc
		EcMNzFKmS3v1MhBVqgEzdTr5IEEoVy0wRKTauAUGLJgRU6OC6ZQkiaskY8ZgO1anDhc2Zu3exZtX
		7968Tf0uJdPiRos+vMS0ELOUV5Mm1sDwUsdr1TEAq8gce3TjnIsmVyCpQ3ZODCSQXFacQwfAxSNX
		FpT8hR1b9v9s2rVt38ad+zY8MsP+/QYeXPhw4sWLDyMDD6YxbnP6kOkDz5ixOVcCTYc3zcV2F9Cz
		TzdWS4kFV8sgwTtKBjz4Ws/XU1c+R8wV6u6NDYOZX//KYX38/wcwQAEHJLBAAw9EMEEFF2SwQQcf
		hJDBK1yYA5nYnrJrDCo+EGMYcBZxpRM+LPBhBDBo+cCeD2wgARIfLlkEFXveUkSJW8YyIIVQaCGj
		DC7G4CtIIYfUizZIzmkBgMDEMGypJrj5YBUwHvkAHWb6oIWXRY7hxYVzlmnCBXTQucEVMOr44Io5
		jlRHnT7eQWcz3eaks04775yTN9+M47NPP/9BTjmY/LsCvz7/hukvUUURRfSKQxk91AUx+ljmqEIZ
		hfRSTP3r79GjGN0vVFFHJbVUU09FNVVVV2W1VVGNIWOOFS6E6q5OXFGkDBtsOIUWLlaZAIxFrImg
		DkVeQQUda2wAR0o+aDnxlkXGGCEFCywA4xIpieS22yBpawEZMm5Bh0PEnNTunHfg+aCF6z5oTAlX
		AKijAHQeaYKWY8zsI846KEGnBXT6qKMFXq7AM2GFF2Z4Nj3/hDji3wJ1NdT+Cq04Y4035rhjjz8G
		GdVYZ4UNQ7vMAMcYdOqwYZEPI8gFGzBWiUAdC3YtYxE8FrEHWkJuWeuzS46xZ+A+aoHWW6WXnoo2
		Y5ZKKaaY/5aaWjswYF1qOqZcYIoMJYahZJituxZbCTIoaThttdfOszeJ3+6T4pDnprtuu+/GO29V
		R6b1LjZg5iMJe04JPIJOQhkjlyRqIcGeJLiAJJdVkDlljFDqoMLCXF4BIwlUcpkjAiqAZLr0btlG
		PXXVV1f4YbhfH05uvWenvXbbb8fdpVgtLLlWu5hKwS3hSQcjBeOF7zyX4g0YAxzODQBDqqVS4MN0
		67llPXvtt+feddi/BzQ5MsYnv3zzz0c/ffXXZ79999+HP37556e/fvvvxz9//csXYw5ubujb9c7S
		DQJ2Ywwp6AZeSCdABvaFew+EYAQT5j3wvS5Qc8BgBjW4Qf8OdtCDHwRhCEU4QhKW0IQnRGEKVbhC
		FrbQhS/UIDy4cQxs9S4FiMBhDnW4Qx720Ic/BGIQhThEIvJQgkdEYhJlQ8EKvi1Qy4BiFKU4RSpW
		0YpXxGIWtbhFLnbRi18EYxjFOEYyltGMZ5Ri/94BidhQgBpagGMc5ThHOtbRjnfEYx71uEc+0jES
		SgRkICXIxCZGLFCCRGQiFblIRkLtkLChQAckOUlKVtKSl8RkJjW5SU520pOXhEYjRTnKtu2pkE5M
		DilVuUpWtvI2X0tlyZDwiU/og5a11EcudblLXu4SAb8EZjB/MExiFhOO0EAmMilAgVQ005nPfEo0
		pTnNXlD/w5rXxKY1NZmOMHTTm92MxmsStoFR9eEv+KGbOf2CznSek3biZMpRCHlKPz3SlffEZz4Z
		CUt40AoRBQToLQU6UIL20pfBBGYxFTrMVCDzmQ91JjUl+pRsVpQal/zmNw0BTzopwQVE2EBIRTrS
		kdKnACf1KEhJulKWttSlITUpSj/6UprWdKX0YUpKbbpTnorUGOoEwzSmER230VNi9tRnUpW61O3x
		058AhWoBCTpVWhpUHwhN6EKN6VCIdnWi0kRCWJFgUbJSIx1nRWs6OtCMfnBUN9MIRQGMN1e61jUF
		RCDCUuAqV7v21a9/9SsRxBbUuALWsIft6xU2kLXCItax/4+d69PAcJSlzNOoxkFqU2gJ2b420ABU
		BW1oP7EF0pbWtFuwqj4isVrWtvYTTIVtI53aOwMUUCpRFagTnPBZqqb2qljNqjHl2FXiNvOrTxHr
		WMtqzbQ2twNtrZMx+PpYyUqXs9e1a3Wni13shuJpSrAud8VbVzO8ZhpoA4NlL0uczDIlrN24JW9D
		e1rT/tKqWiVmHJOZzGX2d5nTTG6Al4vNs1ayGQdGcIIVbKLYNliQs/2LycwyBhK4QgQkkMsExqAI
		VKCiE2PQwycMsAU9EFAPpdWlIHIpCFqqWB8/ULEw83vH4j70uMgV8ICbG4Zw0skFnKWEZH9c127U
		oxvbHf9vXYMMBo8iGQf1QASSk0xX7zLZBVImRZQPS8C+dgOyxniNMdCr3vUKp71O6cU/cSvagqYW
		uPgtZkOhUeOI3piiA9YmJbmZ0W4y2MF/PiKE/SLhqWxYEdaYwCIWwRVggYMW8+jwBG6BiktcxQfz
		8AE4bnELHyTDB5eeBSp8cAIboGIWvw0ufodL5zrbOccWjUaso5GOKaA3Nz/WYQGu4YluVMMONSiA
		Drsh5BvmsBvx8EQF6gEGI2/BE8zuBg7O4OUU1AMHwSaF8ayN7WLnsMoe7TYicIDsCsAC2uHO4RbO
		cO4iG68bgwBFCrK9w2/j2thn8IQn6jFXeCPCeFsAA8D/p7AFROy72gQExLlTsAVte1mHKQBzUMdc
		1DLHLZYRTnNUj5xAvWyBgFuoLWoNCtxUK3TVrE7FcQMsVjw3F60dCIOfAT3zpp4ZDISWyhhocQtF
		TGBX4DiRNYBFiwg8ehWoOMUqtAGWWySaFtowwioMoAd0FH0WR5dCLt+sajuiPOV2xvHKkSDrWTth
		Tq8wCxiq4YZrDKIaFVjgZyWL9qns4dmkqADeazADZ0zhDGcgBQc8kYhrVOAM16hBBaZQ+MMnPhEp
		mAob5m4WUjy78NfoQQ0AP4hr2GEb2zh8BTCf90Eoftf4AEXiAQF5qUieyXSXCuZTkIgp1GAL1ahB
		PAAf/48KVMAToKgGKM5QAVBMwRM1uEY1ML97T0zB+LY3CzbMO3FTVhyzFx80VGwbFWzUIgVUgAUs
		OkEFPcxjHhPQAxUMIAL1k994Ba2q1kmOAOHO0eut/mo0wrpcl788HX+kuQBkHUFrCpxjHnBwBS5Q
		B1SwAVrgCnQ4hVpowAi4ARIog1WQFhhZlqJbhWQ4gVUggRMgOi4Ah3lYBRswgIOSMZPbo/sDO2qS
		NT1wK9uAPanggG2ogBmYAbibik+YvKnQh2f7BE/4hBmIhxmogSI8Qk8wACI0QkCogRqIBHxzg9pD
		PtaLCtcDgxo0ALsLOMPTh0GoAU/ogeM7gylwu2o4A/99qAHn670awDu/4zwsNADXUwIuNAA7OL7C
		Uzfkq4Fq6IFPcIM+BIQzGIRISIQKIDzN+4Q/9IQtULwKsAOOkwrpk7jKojjrOw7sK0DfyTlw4IVX
		oIUyuIVLKAh0uIJV8AFnkRJ0OIEJ6IRIAIcSPIET+AQqmIUQ0yWSg7Nhsj+vc7XkWi5ZS6u8EsBj
		ZBsCZAoDNIBT6AQwsAc+4AN7eIUUyAURSIFOuAQu6IQruAEuUAsLsAci6IROmIdO0AE26ARUSAYV
		iIAGwAYu4IJkwCX5wyqt6iMtuD9ourFo0IMCoJMaTAHjAwXfmwFPiDsfXAou1Ac3gAU70MEzcIYd
		nAH/iUyEePC7iuw7Kyy9QSCFREi86Gm9H5SKPXBIHRwEv3s+T/i1azgDNUzJM0hEMqyGKVC8RPg7
		kczC7+JCUjiDFPCEtxM+QzyDHXQ2dTtDnDyDSDhInGzDHKwAZ6uHGeiBa6BDSzwvTKw+TYwdTlxG
		T4yK5nGFCNi0RViKWkAHeLABLjBLKkAHbqCZtbyFo0MHC1iEokMFWkjBXZw/+oOzOkK5F4wmlqso
		sosGAETGxFwYZUQzvACDbmgKBAIDHDqpk6K2HpwKAoqK3lJBhMLHPtpHG/sqSwxIgJo9UgAD4QMF
		O0AggJo7NSugCsi8hYvCy6vN0luHLYjCPUgET7gG/xyogEHAAT20Sqh6Tagiw0FYOE9QTkDYgoED
		hD0ABFBIBBwIym6oyEmUzS3Qw3WAzW6ABZ78TuzchmroBjtwAzsoyGrgzuHEAUAABFI4yD2wuxnY
		gur0BPu0g/ush6AcTxGYPq3kyuvrJ9qaMCpQhFz4AAuAlmxZhWmwAbsEAyqwDFqog1vQhlVYBG3Y
		UEVYxQaIgHq0Ks/kOjxiNcEUu7AiOzZQzBZNGMa8uYzTuBmVKtBigxvF0dbS0R2NhL4EpnyMo9A0
		romKBidQgkyok1eg0bmCqi3gmi2MKuHhMsCitgQiHbegttYsoPBcyCjFUgMaA0q8CyxlUndjUoDi
		0v87jKoyJTIEQqBCC8swRSAy9TIwjSoAvcT0ysQBDQ6bM0ANWQQicAUSiIAIkJFVUEu2zBZooYVc
		mLQIWAQSoAUSkEsumAcRHdGtY8EWpLP+EsxekLVQcNFRtRMYfYpQwNFUVVW8IoIRcFXdgtVYdQI9
		oNVatVVBwNVc1dVd3VUV8NVfBdZgFdZfNYRiNdZjRVZj3YRlZdZm3QRBkAk7eQU2I6gnnVZqxVZq
		jYS5y9ZuFa1tfT1vFVdqxdOs1NOt5NOJ8crGtAs2cIIUGIFQMAASMIP1IwEi6AYnQARY0Fds+AQ9
		IIFu0INIGNgQ04MJIC3fskcS3VROFVI7AyrZuAH/dGCKFpCSpfiAZfCLDyADtVGEjp2NFiAZMPiA
		J2WGxXCFOcBYxmgCV3gNC7hYUp0NU+0FVFXV1RqBWMUGEeBZEVCLJCCBoCWBCZjFogUHKkDapFXa
		pWXapr2Ep4XaqJXapzWCqrXaq8XarNVarAWHGdQNJfXWuYOvcSVbhYTSsiVbfZAsERhbtHXbclUn
		MtNEPwVLvDBTd6NRGl0tXmKtziy5HwBSfRTSIZ2oPkBS2hiGJujYwWiBxW0BgGyKR0iMtPkS2jgH
		AECYKenYj5gDMoAEJZmSdxgfyQADRTATmZ1ZulWaKWPdxxqe14Xd2H3dV9IPMejZ28Xd3D0FlbDd
		/9z13d8F3uAVgd01ht4V3uNFXtyNA/o4heR13uft2VOYDhcQJ7m1PrqlhFDQ3lDI2+6lUdFSWL/t
		xfHVgv0y3zk70X4w3NtogsTAA1c4l/ftg1VoWZVV3FRsgg8wJ2NYjA94DVdwhSZQhzlogUewkGmg
		35RlCsp4BIRZhCZ4hHfwixZwBYoFgyaAlSaAp2M4hgtGr/cFg1tQB9RN3XWNUc9C4RT2ltoYBmPY
		gAKhhBeQ4Rmm4Rq24RvG4RzW4R3m4R724R8G4iDuYXiy3oqjW+1NVVbV2Z3tWW1wYm0Q2gmQ4qKt
		xSq2Yite2ipW2q3l4i7e2nIA4zAW4zEW411gg/9MONzaqIMRRgw8YGMxoAV0MA9eGAZeMIY4DoxV
		uIJzWITA0N9z4BF4EYPTSMVVWIaTVac+MGAloAXJpQzecZJlcIVZaQKCGeG/aIJFkItz6FgRJmHZ
		oNm8cAvPWiDhUWEUpo2H+OQArMwiLjPVjSpVTWK8ctVXXWJswOVc1uVd5uVe9uVfBuZgFuZcljnb
		YIYPuGBvRGbF5YVmTpIlwWCqwYMWYArRaIGnYYbTbd8mcGbQdZKnEY2l+IimaIJhIGAlqOQ1ho38
		BWBesBBPXuW/CGW8eNoUwAazO4s4xVIRYJ447YZTYJ4FYj+poIJOqIX1C+h8Tmjo0eeci7tThp7/
		2Yi4yqToirboi8bojNbojebojvbojwbpkBbpjnbl9VLdFG7dlG5d3eiDFgCRAqAEl3bZCFYPMDOM
		MGGKOjjdKWESjQXhCwYTbqhpeFJcMDgHycIDZGaKor4FZmgB66BmpliGQCiASmaKR+gDa7jkeG6K
		ebaLS5BiKeaCOUgBM+gEvKqFWhjog74EEQiFSzjoCDCAp5VXA7CHTiABy7GAK+ADKZ5r7xOBTqgW
		usaGTsCGUOhrEeBXbEDauoboiJaNpxnpyabsyrbsy8bszD6pkr6sk37sz/7sOWmBNlmK0R5hV0Bm
		MnCFOiYDdcCDmVkFMQCADqaFzuAFjbUGbXYB/3VI7dW+ao1FbbM5h9de6o6lhMt9GldYBHOS7X4q
		ajCQ7azeaq52JBNmRgOIALdQglqIgL7OBSr4bgvYxr4ugwkYHDOoBS6YAO+uhbIwAB/gg7owAFTg
		BjwAhzIAh0so7wmotAnYCjPgAiqg11oox1qoNIN278d2GjDQ7AZ38AeH8AivaM42Ks+2C/eGBTos
		nW4YAfkGbQaaE2Y4B5UFAxEncVd4hBZghguGFXh5BI19h3OA4KdpAp/W5o79gBRnI6ZQhwYm2SY4
		hzrwi+cODckq4CZogRqCYMZQ8TOZbur2arP4kTF4hVpIAqJFBWm08gm4cip4WhIAA2zgg1sAB/97
		YANCKAMzAIO0rgU+sJwIuILxe1psIIFa8G9r6AM0N4NTKG8zGHMSyIVceOs0B+0Fl/BDR/REV/SL
		pnB6snCpqIqryIqt6IqvCIuxSHDpSYu1aIu3iIu58PAPL505Aa+ckizAUKepAYOzYYorYHUwmBrK
		gnVxgo6/8BrAANmmUPVZ75papxrySeTBou7qLlCMw4tXKMdXAIegnYA2T4JlF1pw4INXIEEysAdU
		WG8/74RXGIMkKMdcuIIUQIV32PYyeIVAf4VpjIAR4INtl3ZC6BFUqHJw4Ottf+gUNvRF1/d953fL
		bvRTenTm2ZAO+ZAQGZESOZEUWZEWeZEYmRH/bKiRGwmLHNmRHvkRUTedYdf4rg74sMTlMUjVZjSA
		7d1eNhgDMzB5lL9Re8YGIHmLsqiLESCBEQD5t2h5NsAGL/t4NgDok68LPmh5EXjXQpdoBu/3o0f6
		pGf0PU3X8Cn27MOLW8mVXemVXwmWYSmWY0mWZWkWMHiWaJmWarkWB9VJjFeajUf7KDd7psnwKiX6
		yDb6ypwNuV8Kpbf7u5/sfy+kjkcZlWEZl7nLmJmZmrkZG8iZnekZMPiZoFGHoSka/0Casl977EF7
		jadZlcb8zGfdfK/MPtgAJfB8lMpcpgipuq9oJdgAvFf91S8AvW+ijv+bXAicwSmcw0mcxWmc/8eJ
		nMmpnMvJHDDYnM75nNAZnck/+8ofdhilgHTQA151/ueH/uiX/umn/uq3/l1l0aKv6EBYAV9BBiXg
		hjo4hltIjCuoA4OAhJNSBCEbCbRh/fdHetevoI6H7OB53bOYK+RJAuWBvOZ5Hp0ECDBgUvAxYPAg
		woQKFzJs6PChwIgSJ1KsaPEixowaN3Ls6PEjyJAglQwjA88iBSRsIrFs6fIlzJgyZ9KsafMmzpcG
		MhoDU+An0AKrpoExNhTMHFp9LFgQuIgbmFUuBKIjIzAo1qxat3Lt6vUr2LBix5IFCo/MsH9q17Jt
		6/YtXLglT1bs1eshXoVguvHtNiZFN4Zj8v8SLmyYocjEihczbuz4cUiSJi3aTXH4MubMmg3z9JmV
		1lRkdSJKpXVFYCBFYGj1BGONlhjPZWfTrm37Nu4CZ9PG7e3797+5lHulQGT8OPLkypczb+78OfTo
		0pVDrm79OvbsjCXTpWh3M/jw4i931goajGjSLkyjVs064hxXJ3PTr2//ftjdwPfzVyu8IgXUaDEg
		gQUaeCCCCSq4IIMNOvjggZFoNyGFFVr4GHfDMcQGNrAA9pCHfWHDhmUHwQLLeClqVl5WUoFBxip9
		vEjLBtYcI1AdK0R1WkQ3qIYfkEEKeZt+/RnZ238UUdABk006+SSUUUo5JZVVWnklllGmciH/l116
		+aVAGdZ110IWcJGLGWMQQUQ3ERiw5odUcIFNCilccsMNZqRA5yt44BFKQtggBGdgKhq6E0Y9mTcV
		GMfUgYwiJxmjyAqQWKPEaje8E8ccK1hz2pChijqqVkUeeWpbSU5kVzefuPoqrLHKOiuttdp6K665
		6horomD6+iuwi4npHZkKcbEXmmWUQYINp/BhjxkGRXAJnW2GQgI2ck4QgTU2uNlJN/bUYg8JJKBy
		irLRHmooi1j1EdQGLmAakQtECdSHMcZsUIC8spH6L8D4mYoqwapKVNm6CStc2EfHQAIJN1ZRRMZp
		FEdkzDCMWqREbAItA4mMFUlM0QrzSuTw/xwvSjRyRJR0LPIwGaElUckbYayxzCYz5kLIGw27arEJ
		5WIQF0TMgUotfIRSC9JgYBMBH+omkUsnZhzbCTgTUAEOFxFEMMErfERQSy3bfj3YwuG1y1VEQG0U
		MNxx5zYwwacaHNF3aeu990EfLbMIM2QsckzMNwQiECTqKAHJHGSAvEodJ3Fx+BzH9LE4PH3YIJAY
		jDPThwuQKGEMMnMs80Efx5wUyDKrKeL46Nz00QdrzMxxOONioH7DSWK8M8zgo69w0scFWLDMx5iu
		MMdJFuNRS+V9QO54UfCIUTrzBcwBCSXqWJAy42DAcwwlAm2P6TGK3PBi6CmPr4QSN8gYfv/nIdcP
		xg2UZN45GC4ck/IcuFGAzs1rGHhARneAxhBmmIEEhCCBPW5RC6xFEBxgIAQ4+IAKJRjAHkrgwwTN
		YA8qUCEXr0DFBFAxgk504nnlygUh9MS3FSXKX3K7IQ7jRre6GeluAskbYdjgBCfMsIiEAcn/wKCO
		d0CMGYpImWjmULpAVMoCD3vHCr63RGYYYwWRwoNAmNGxYdgAGcyAxC0gIZpKPVEdVqEUHuZwA0gs
		An7ouAE6AgGJd5hxjZCwQSDwwA1joOMdx2BGHZgRiDpU7hiBsIYc+biKW3DDAj2BRCCWeINHPe8Y
		TLEGKJmBB98dgwvWgMQNkPGOOG4RDJT/QAaekIEMWtSBG3t8RxsNiQxILOMYN1gEPBSBjNhMo4xk
		cJjjAnGLYxzDT3h4JDfEoIhmcu4GtGCGhhbCBy7wwTKXuIQZ+JAtalmGDw/UUxK4cAkDvIILI8AG
		NvgwAhKMYQJjSAIfSPCKVxiAD0ozImbWlsOBEnRIO+Qhf3wIBiAmxAlcYMMEJlAQAzAjF7mgwhhO
		VCciGkCjfTkIGwyi0RRwFKDgAQnvwDAaZvioDpckAzfQIYZKKoIb8MDTMAyJzTo4Th2BRFwtwLAM
		Y6jjBsy8wgre8Y4b3KIOYmgK/lYJBjwco3XAM8YtDMm9FSR1k04F4zTAyAzCHQMZTcED/1fPCjLe
		XRNxTAQDM2SJTaoOgwt94EJdrwfKd9wUEgVgpl9Hk7o6nBI98FjFMULnCj0uDhKnuQUe6tCHQNgO
		DErgRuDwcIUCMCOmXHgHFxa3AmwSlQs3Qoo1PgDGMQlmDGhzrQFcC1uDyLZvYDDIbWl7kNfWdrYm
		5UwNCyrc4d7noAgFjkIZutttJUFrnZBWKELBBRFCiwqdmIAZLGqGMvQzhVMDB3XNcAmslei3Af3I
		DVJWhwKMEg83OE16lYCO7UV2Bbe4gRjqUIdl4EEJtmPGKuCx2mEwY6x9gMQxjkmGFQRiEZQ9hjGs
		gbjtMWN8KevDHfHwsfxagwy0eLAxmP9Chv4i2Bj/g0SFT2yBQJDhBuq4QvjA0ERKIHgOBZbjNLiQ
		42mkF5EsrcMx8qvhz0nYgHVoLzqGAQkXwAMSAQYZJKQpBhtD2GE6Sh3E5qCIZXChc0uGhJLFgIfA
		MaPLAlkBHtSxWmKV17xuPoxAKSHnOdO5zna+M57zrOc987nPfv4zoAMtaDsb97i+SW7QdouKCHBh
		AuMyiDW4oIgR1MJrWosaFZJAgvEaoBMkBAc4lHAJr236Ekl483k9Aj8wyEhGZGjNqgVCCWMUAF/l
		s1ir+3c5k7ksTLGBH/x6gmtZW/bX8zKGGGImo2WcZiq47omM5FwATHHMlcXu3yIk61j/Wa9azq6M
		DSUKEO5xsxraxsBUslmt7nJjCnmWxRQZKLFqV3PuNMN42b0FYpXy9QHc1h7GafodESXMYaYoUQkb
		Eq7whTO84Q5/OMQjLvGJU7ziDA+FQIOl8Y1bp9CGjguiF9LOV9gjF7UYmgGOVYtTTIALMUwCFcoA
		aipMcAQXJYFEjVELl5vhFCVEG6oZxvGhZ6QkuSZ6dn4mEQqkQxBOfzrUoy71qVO96la/OtazrnWp
		s0GgxP062MXi8Y+/JeQJGcMpsAGGcGKDBAYBhwEg2k+lTe0VoVBWKJIwLXh2MAmh8GcoTmHCoMMZ
		6YY/fJeUjjfi1Knxjn885CMv+clT/77ylr885iPv9bBzvvNYGTvZUzUZ1joE6LFFyGxhm3qgq563
		hAcu4mMv++so/oeJfj3uEbL5AoSkLBLxPPDzg5bQJ3T0bM498nXvETL0bCJKoNgVXlbtj1yBR8xu
		vmNYdu2iYP8ir26NRASOkZeBhGcSeb5ExBBUjYzOGN3fmNkVUluF1Gm3yr+t6ZOfGa+D4ieDOAMi
		XAMpgME11INAgIIBEmAFnEE3cAQp4IBAXEMFJALvKUbwERToEZ9/GN9EpEQoWBwIhqAIjiAJMlyv
		cAQX1NKLgMziBAIl1AEt3MIyKRstQFhspAwY1AL5GMM79EF6kYESXAHhkAEzWIMYkP9B9IDBCsiO
		ZUFC7yADx0Ch45QPxDzfts0B6jihQAxDDRLcFRCh8MzB7QiV6DQKMJ3EDQzD4szBMKgGUviVifWO
		BYwGGIhBgsmY+5APXOXhFdyAEsDDvb3DTwwDPJjYlH3Ax6QMN4jhMfQh/PASPLiC7IgBNh0TDlJE
		7S3U7RnEJeTCJaSACIjAGISiAZAAX4DiOhkENrAQFRjABBgECYCiCOhf4V2EogQFIOADDszADNRD
		NVQDPqTAIAACGNSDM4CCQNRANdRDCkggItRDIoDCDACCNBYAKDAgB5wBGOCAJ8BCDUxB/xVgNQAC
		ICQCGADCMg5CNyBCDRAjIJxBAZD/ggFeYA5loAYq1JJsnT7uIz/2oz9y3UegkRPegmh00S00GVWt
		AjeAkXxxwylhlmVJ4hw9yi7VARbZADxYgKMsoTpww2etgEy9iBcJWMTUEhkIkwWsEjKc5DukzEkm
		1SixGjpwAzM5ZOUgkjUUWDCNliTp0S6JQRd9kWUhAzMVoSLhARcsAhhcQR2gETIk5Rx0ZFktZFQe
		liHdwEJyQ8wYAyT4CTOswKNQpTqIgTpYJRe4ADIQZFM+Ejx4CijhzMDFX0Kgwis4Wi3YQB+UjQjc
		QhIMhj2Qi2tdQhn0QRlMQB18YgSkAKONQaHQIl4I1BlUwAyQwgLiQCJUACBMIxgg/8IgTIFADIIb
		TEEKeAIoDMIgVEANLOAZnAEooGMN1IA5CuMZJAI3psAZpOZqfiMHgEI8vGM9zIAnTEE81MAMnME8
		0uMN2SPxIVqbOWbQoRfpxNQc9VQgpBI8YJNq9MEtTFUtuBGrjQZVXQFeIQM3LIKmIAMYIZgZwRWY
		JdHHdCQYMSWrFVUaPowxNNlJDIMvUUISySdaZdFUEc57HYN07tJlESUk9ETnyAcY8ac15IgPrqeE
		GUN6FiEj+dXDNIrDKAEeFIB6YpNAcKX87FGl4E+lUAIz+JcSWIDjyAcWlShL+Zf2hYlcIkQu1Ml1
		YU3WdGIZWIYP8EFIjQHTrEAnkP+cPYiAPWADF0xXczrnQqwNInBABfTANQigMpJCIuzmZxIjGJgm
		LHSDJ4DBGSxjL5JpZnqCJyTCNQwEIMDCbGqjMsLCMlbDDNQAGFTAnZJCDeADINipG2gjcuKQcoZe
		jTrpm6EXGSAQM00ZgI3PMdxCio6GfFkDFCoCtamDNbTlMuRXHfThMiwPilHqO6Ro4OBRbFznKnQO
		HhDhqqLSEVrKpyIYqwUYKEEbpurg9liADhrDDZjY9tzAMswBHgRYlz3R9gQYNvVBZFnACvCYqm6n
		D+rXUyXY50TZkS3D5+DBgQVZgW2laYknN+AXKGFrH3xOtR6rlomRKM0BXkVZ6zj/X6EaRC7cVies
		3CnUQQp1gjUIKdmUgWtRAR+Aw7xygQFEgKcxBTjkn6EmxNpUg2cW52pmZv/FwxSsaTUgIxhc7ECk
		ZmaSwmR+7BT835hqIyKs5hlcQw14whl8rMcmQg3YZgrUACjUgBu8Ixi0ow0FKsAMKtnFK20pbHiw
		nm8Z6kcAG+eE6K6NDqaUj2VNxTKsD6vhwVSsmsVQW7ElbbllW2sYQ/nMWrltH7Ox2ssIW8yEydRe
		G7Ct2vSRARmIm8r0j9F+rdFyTMjgAS1ARdjym1DFTNe+G6vxiN8a7TJEm7X1rbyMTqv5G/yU7fn5
		LCowkxlEFBhwATOQQA6SgBmw/1AunEbZgEEZrOI94YE9uNZzLWxDQGlQ1MOa1olApAAOdMXqQt5A
		wEIBIALt/gQoNGAzGgdQNF7t1m4xOl4NwELO6iyp8OzH+awBfNOeOEFu5ZZsMeYs8lY3nEJsAZ0I
		tKJBWFctGMD0og30gu/PCu0MXUjzMS1IlATjzp5GsC37WpbPjkASjEAKRJdBhNT9poAZjEDcJUTC
		gdT9mu7pBldWvC8iFK/xjgryGprPXkJERRQXzIH+dsKakE32GkD3XoIIhMIldK+bfBOgdFAn0FMo
		WMAV8EFELW8tgGIn0C8IryI2/N0EiAAsOEG2UEEI68377jAPj4TyCnD5EnACD/+xDg2fBv6Gz0aA
		aylBpaHwRV2UBVwCN01AYdrDKZjBzknUBJgc/xrAj+IvKiwkOMicYEbUeG1xLVgNFWDuBNXreNVr
		F+twD88xHcMfBx4M42WeHu8xH/exHz/e7hGxIAvJAh+Xz3KBa71CLTQXOKCCPy3yBDQXFXyT5cbT
		LYCDPbABIZSBGeQg2fDBGIRCBFyBp31T25VNLlhDH2xyzxVmON0CCVgUB3My39SxLd9yJjLdP+4y
		L/fyP3adEA+yMBuUER8xktzx4jHEK7DQK4BDuTgaHySBM5cLCWRQO4EDGdgDCkUNHxTpPWnuFaQA
		KrxDkZbBK1hU2NhDBIxANzf/szmRQRnQZS2Awwl7897cMj7PcS4jXAn2sz//swhGwglWxC0Os0ED
		SSEjlM+OATyNwcIZgPVGl0R/4BiYARtUtMLtCTYMBkPzb0jN0wg4NENvNId0g0Y7tPVidD9ttAg4
		QZMmTD7H9PtmIsIAsXkF8kHnNG0kNA/9sGOGSJ00ZtrINFHHHk1vok0HsS0isE43NVnwdN0w5x9P
		NVVX9R8XNVYj3VEzBCyIABF8CIg4RBy/ySwm9UBTREE7tVqXBVQXDDILBNPpgS/PNV3XNdQBc1bn
		dbBsdZlY1EaPAP2mAP0SgUEAdgq8Iht8NSgexDl/Ygqcs8l9k0OHVCgI9hjw/wEVlNdH06/33nQw
		z0bb3EZofwVF5MZok8XvbcXbEDNvGDPIvTUYpMRK5ARt17Zt3zZuu8RZa8Q1EC/GVkQ9NGA9qK5F
		eGYKIKMENuBpEiMyVttxD0RvN+BEpMAAWkTYgsE1SndGkEIKUMRwa/dELEPZ/l8NHDBIXEN3c07M
		gEIFVAAysrdnwndEpOZvU8Q1gLfP+Oy8dgOaaJfBslAaKws2ODAeVM0l2AM4dHcJJXgKEAIh9MEp
		lNm02EMHmQEkmE1ByNy5KIsxPEuCmxROgwUlLEEFRoQY2MuLAK73TcOMSsSIR0RXUoILbMBFLIFF
		2PhELAEe0Hj7om+YkME08P94RcQBN1CCMDyTZVkDVFyiQAgD4MbB+31EW6MKc5o1iH/En4KBG1QD
		BA6COb53PGhjPKBpNSi3OQ6EM5ijJ5DCIMwsKfRAPbQjnrahQKgCDtQAB/Q2KZxBlydCCpgjzqKj
		dMcRdrd5DdQDIJDCNVQDen/jOVbDcSfCauJAm4NCmnfDNcAjKYyjQMQkLPQALLD3zXpmpjfgN1qj
		pidCNwwCO2KmQBjhnSYCLExgBcQ5INT6GQxgPcA5M8osdp9BnVQDnGc3R/C1QqBcJ5iazxGsBaQc
		GzBN0mwNCXzyqfVTo3313+UCzrVcNxCsPVwCCRRA2TzXCEUUqSVNtQNUiH//RSZNgwtoyk8okh5d
		ATowgwswg4wjwxJoCsExwwagQ+QYjyDa0gZQggVwwwa4ITO8A1eiQ5ThOxl8lvZYwy0YfCAUwArE
		gRhQvH9BIRgsARfEgSUhQxwIQ5RZfAEwESVIEVNcge1gIcIf+fNxgQAVgDEU2Dt0qhhF2QrUAjPE
		gaxZExn4fB+4wv98jiutABk8VQHEASZhPBkIgwXIWWcR3JTbDWwrl5XXskdIYK33ppfX6a0XwALO
		wJ1WQ816ecoiYzegJpu3uUB0w3D2pjYOw2ggghtUgCcMwjRK5jUU52TOpqRPAQfYrIzFxsl2aZZm
		urDDAnCCAgckwi+Soxt4/6wnzEAFePkZTEE11MBqrqkY7cVwsuYMDEIPAMLlb7rpg0IiDEI1rOYv
		7vlqDiAztM4ZqOzJ/h8g3PkZAEJ340A8DEKXmj7qVwPfJ0I8gMLlr2l+Zz1SW0ADlc0kC2zBGkAu
		TEAE1UIZrDGowVwuDIY7KcIpgAGosUEnbPJzccE184ExEEI739wWx5ADff+VL/VtgFK4NmXKTA46
		NNlYESRA4IGEh5k1ZnMCrWDG7AYkZO8swEMHz4IxZIoC4QEDJo7BK9a4wVsBCZJBbnhWKJp2cYm6
		OCjrcLOAbAMYPHHAQHrnEuWilYpaBrpxo1YtWi4uIrMGiZs1YTcsRMXJzP8Fl6fMAhmrA+ZKnQ0a
		c3JbRYZbQzzw4N3QOM1VHBvHBkKK6FLRDWbImL2LswgemWH/AAcWPJhwYcOGh5GBt5Ex4169DESW
		HJkNNlgpuk3WHPlyN8/Y2KSYDAvWZtOnUadWvVp1Y9evN9boES/RGTBnquFINMN2jRnXwFQDVANM
		jWo9KtQD061CCjeDZkwBc42UJ1gVaoMZtrVbD0+eqlUDBeoMIByDapAaNAjRjBnEPW2EJKY4qNuJ
		ahSocJtUDXzDi6vmmkRSuMY/QNzj7bZquhnEPmbow6EHUNy4zZMKupnijGvOuBCHGS6cAZEzYCng
		jAaBY2aZ+86YAQxA6qn/YLwYSQEDlh6Aq0DHazioAT8wfgPkDOlge02JxBaD7bHT+MiFjxRS4IMP
		A0igkspQCCEEmyReMcPLV3LBJjIwk6jSgCZHwIaPU1J4hQsqzsQGGyrM4KIWOc+8JJQkcjGDtT8B
		jaxIxowBo4BDEU1U0UUL6EMdSBRZYZoVFnOIGTBmWgKdG1Y4xphjpjmmlhXwUOSdQLjgYgNk8ALD
		mjggcSWjjcSIgwxmVhBjBWsivYJTjSyAVVZIUtgKj2HkmianOTB9BxIlrHFV2EAgKYChOFZQQgxm
		ZGUVGQtsumGD+Vwdd4klhrEmkGiNwSOFWzaqQ4kV5jimjjqQIcPeRcBw/4EZJdS5gRtINuCUC4Bv
		QAZZSOKYyK/DII5YYsCQLHJJ0yzgos8xiCCimwgM6BgzA6jgAhsoLxnKjBROfgUPPELRTEzJRM4s
		0JtxNm1Q2BDZL4UK3MDuGh3V01HBQTzJb0PccFhuv0R6SKGGCmboJp4zltaOO99mqGYGUN6bob8N
		Bxm6AlLO+Fk+ZruZOpFQziigmgo8AaUGN4ZLYZDa8IFuEDdASdpAGauBRUAwILTRNkAAIa+aenhL
		hEOxz6jAt3oCv6bwsjFdsQblTqwAaw6xhgWMemwDQ0Oxa0iPvHhI4c3FnRk7UjGLITNtjN0j4120
		36EMXjTJwBjegOKH5//dAOU3Wr733ceQjPmcqd+M9kIZzZ7RY5h9h5ZJmRX4X0iOQYkLMlZA34UV
		lijJmhVuuSGOW6whwwIlmBGGmVUo2qiWWyywBKjcoA4z+ZQwuGANp+wPHv8qSP0KUqgNFCQQX1EC
		AW+xLf5BghJceAceHuWsVcxBERAqiTBAJT8wcCMhwoiKNTYwhzrg4QrwOMZGlmANdMSBGXUgCUnu
		BQZj3I8ZkBgiLZjBQ0oUkQy3ugkk+vKXiU2Riv+omJJytxkuLKdPZSgDCWxwCj7Yw08GiMAlTvax
		UJBgTlyYQASsYQOQdaIb9qiFPUhAAlScwotlrN4fAUW716RgI4gogHL/wECKpoEBFN1IgekeSUhE
		JNJ0GyFk8YoHHBs1EpN92ArygpfJjZCiG2CYJCkxeUlyiRKTZ3BDIk4XSijhgBTAqQchYVHKAqWS
		kKu8ZCkVaUpNBhMRkCSkcggJJcSRAXmpBMUkU/BMxlxyOqVExDBrdE1B1u6Kr3mM8QAZTnGOMzXX
		M5T20HkoSiBqnYhSwjsL8M4NFICZSnAnGJRwBTBQ4gpK6FdN1kkJMEzjnfY8lDGYSYkN5BOf8dwI
		Gfow0ILiE6L9iuhGKMHMhuKBFoEY6KHsac8NTIOZ0zjUFSKqhHrG059KoCFFLwpRaF20Xy7Ypz77
		0Ad+snOfzITEHCIq/9CMPjSoUaziUSPWTddcbDO5iAwXiDAHVNSCD6GoxVTBgI0I8KGMfOpEncDQ
		CXBMgArg4EIEIjCBV/AhAkV5Y1qjR065Em+bdbXrXTGK1yK9s0ikqJFe9+pPwO6Mr4M1rGtsl6TX
		UAAJbCDNYyEbWclOlrKVtexlMZtZzUo2FOZM52cPdVi9Lkq05yzAa4xRqNLWTrBG8idp69ranRkV
		qbUljFIbw1TNMMMMJCAECexxi1qINbjgAAMhwMEHVCjBAPZQAh+GawZ7UIEKuXgFKiaAihF0ohN4
		qEUec0GIlc2VvKs173nRm171rpd2iS0SBdIhCPnOl771te998Ztf/f/ul7/99a992eBZ0A6YwAU2
		8IHRyRgEL5jBBKatbSFsxdthkUlceJIBLnEJM/BhTmgUDR9+u7IkcOESBnBTmtQ0AhKMYQJjSAIf
		SPCKV5ypquQtL3txnGMd73jH7sWi8IAcZCEPmchFNvKRkZxkJAuYwY3Rnmtgu5EGT5nKVbZyOh8c
		4dri1jFZ1Az0nrc8MD8vrscDg6Ckl2Yx8055NpYrj+EcZznPWZA+9qaX3ZxnPaOGyQsWAx7ecdq9
		4gSKsInDNPQJG2HUpDHCUBZsrhxpSTc4y1o+Kpc38s09b5rTdKXzp0Ed6vXaeal4nkybAbU7z1xy
		DDbrtJ77fOAN2GD/GFxACCSuUACdFGAON6CE92jBDWu5gBIREcYH3nGFl2R019YyVQHEQERhCAMP
		LmDWEsDg0Ulvm9ufrbSlqYhpMDCWDeU297nRnW51r5vd7Xb3u+Ed73R3VtT1tve970rq3JpaMl4M
		c/DEjGbJ8EEEkcFGLnJRizMbYMgCV3USAh48V79aM7E28AXvQgl11MJSizhJX6LSEGRwIQ4WMdVS
		3vEqkhhEGIhbSCAihZKmxMGH3FjEO7bYbZ3vHFHfBvfExA3f/w6d6EU3+tEBjG+lL53p+BS3bicD
		4yRMIAUZNsAEyiCmDFNCBLkQAZTAYY9OEPISfOgDEUjABhJg3QlO/7jECLbedRFQgg96qkWerp51
		ip/G4gWmRCCGYYGUh4t+wojWFXD1jqHEoQDCiFVCVkAqV6UQ21R5CDqOgYxjSN4CtVhFHdBhU56P
		nts+/3lSJ3xnJa+e9a13/euF3HTZz57O+u7yaSIABirwYQKdcKM1JmCP3nMBHJ2gQpXG8L9XdLYW
		1kDGBCZggQlYgwRluIQbfd97KpBhAgk3QyeKwnsfdB+cexfUzrDHYEoQxBrGQEcdAvGSGxijJC5I
		GDfOZ4Ml6I8WJMzfDaxhCVZgfVruBlYBD8hgKNAHgUCiD/CgD6xBCZiF9Cjwykzv9A7j6fjN/DiQ
		emjvA0EQx2wv0/82kAtSwAnsBBXsIQk6YQyMTwWxYa2oQDRyYQR4S/cuoQ9CARt8wAlywQWpIAnA
		wQLsYUugqw8IwR7W6hJegQQuoQxSgAs6cDL6zsAgqtgSzRgASp8Kyp9MqgByrQA2gNFsyqAQJafw
		qQw3wqbwqaFqogLhcMouEAMLQwNPY8w0A0rU7PzOrMym0MZCMBAFsbRGEAygTjLAxB5GQLr4YATs
		obmwwR744ArAoQz4YHfGKBeMCxxQARnmgLqoABU0ERxIgBEpsQzohA86Ya0Ork8esQX/0MwGJf2a
		rHbuLQ5xccHmkA4Hww5N4xJy4RJSQAREYAyIkUpWTQRKzOC4C07/JiAySGAYCy4WxWkQrfEa7aoQ
		D7F3RmAEoKQbU4ANDCA0wNHEJuMVwtHg5IQNOEYRJ6McZ8wAnMAbQ2Me0zFmYrEKc3Ef+ZECd5EX
		A8MXNwMVXmECisIG+qAWJkAEbiEJosce8Gh3nrAPymAC6kAYIyAFIoALWo0aAQkbQTIkjUQgOU0c
		PbJ69LEfVXIlJe0fAVLCFKvUTiMXoKQTeg8cxgoYodAAfIAPxDH5UGEFVhEiRaAIU2W8TtIDRXIp
		QVIbewH2oDIqpRIqU5IlrfIqEcwlAZIkJyMXzgz8TuEU6iC7OsEakq8oymB3dg8cvFIKI8D4ogIc
		/DApA4Up7dIa/wsRvnQA6fiyL/3y6AIM/UwLKwmzMA1MK3mRKyUDFY7hGMwA+sCAC5iBBMDgu76v
		E3JBnxQSDLKuBZMAD+xhdzqBLpXyLk3zA/OyseRtNVmzNV3zNdFNFouEFg2zNm0zexCTDhUzMkYg
		CbwxFPDRJMcxBcxgBMZRM8pNMkxSOEmzLk/zOWXPKcuvOemyKm/zOq8yNzFwN6nzJKHzO5fOKbuz
		O60TO82zH7Xz9DRwKtmzPd0zyMAzPu1NPE+j7UYmNZKzPk1j1SajG0qDMpgzKWNNwQiMQLPHyc4z
		QUErPX8u6OLrLyE0QiWUvgJTPi209rjzFbjrFcbAPrvBCRyp7f8+JgnExAlEA+LGxEmghApyD7tc
		jOGGgQomgE2cwACOEUSJ0xsnjgNjDREAQdAaQ5N45kcZI5heZCOu4UIA4TVAAZEGRUFrk0HBLehU
		Ezat9EqxtDUjQTYvtEt7jDtN0AlqQbrIiBlygQqMwR4q8hbWpLo2rAzAgZBKJk5ToBYUQQxsgARq
		oQxqwRg6YSyZ0I0mgAQiIOHSlIymc+9iDRDwoR7qYW8AoRpSIBHUYwYKIHAqiVFJoQA+p0nJIz5u
		o2q6ARB8FD/aBhSSFBFIoXB8RG7sA0oLU0otbT3Hszm99Fa/NPVk0jRyr2RqwQIgYQKk0PiKiKyK
		ogVDoexQtEn/JoAIwIBQ0eoUUKFJgjD8LoEyL6EWpHC60GrF8lEwFUVHEmFuWsdHamAQKmBvKmBo
		NkJcE6Fs9uYMEqFCwOBvhgRqACEeQAE6EmFdW6dFZAMQOEA5YJUwZVXLuLNW/xBXGZa96HMzpE4h
		wwsbpDAXuk9LnOSOJqC3qit6uMAMFOEUdI+7xOpMoY8K7AhOy+AVssSpNDG8/GgK+6wbOKBDHmcG
		IGcGoCNn9yM+aLZDyqYAoGM/9qM4EsGRQCEeYmRBFAQ3YAFpzoA8BrNgWfJgI4w7YUEEiOA+U+M/
		T8M4aWYaFZbvGrZsz+thIfYSxyBL1shKMgxLwCFNqkpDy+jg/5qwTczgFeQEGzrhZIDRDCCOw+Tk
		FNxWT6ixz77mRdygHig1EcZVbBIBFKrBE2BJPIAEXcFGcr9jI6rBDeTVa6ohHmTkayYXbK6BQx7H
		NqgWK60WwrjTAhAOG8YAHFPAG4mAN73xGdlga4cREYMRSsAk4TJsDJIzFGp3DPhgBpXTAMpRbM1v
		sNAQr6L3bM0W1ND2y+IK1QJOeeJq4QQFShwJyBauzeYyzA4XXBHsr1IgURZplAzpUOqBFC7jdM6g
		fROpMepBl1aXdR/mJVEvJvdtJrnIDBDODN6Su8bUi7DhEiYAD77qEuwhTnVPE6EkS/rgFJjhrCC4
		ucwgWNFqSv/gdI+8yBjGKE55FK/EQB0e4RFa4IZeYw5owTVSeIV5IaJWYUUGpRb4ZWfwAB2q99Ok
		c2wFFH0VhceoiXb2Nzv7138zUFcD2DScygA64RKS4BRKxgAswAC4gA2uiqrKSk+palndaGtDoUnW
		Tli7YVuvtQAUcjSnC/q6NYw7EK+MAQAU4QqugBsAIEmU4KJuoQUEijEeoQ6GYRgWoQWM4RHmQJ1o
		yp/6YBE+QLAogab2yQFd4Ycx1IkZg9w2q5M9+ZNBOZQji95mcWqT+JRLb4mZuA41mQRPwwJ6SyGp
		4BLY0owMwGKDa0+PDyeToGO1eARCFgxwkg06gRDKYDS5wE3/kssYCEEVweT4Lra3COEHT9iu1EER
		GmMOOgFxeKEJaCEFWuAcYliQL2UjogIAHmEYxKCbP0CfWuADHuEczoFfmKGbF8GfLKAJmoAXfBiT
		5SwvH3RCBXqgja5CZ9OUUTmhLVCVV7kXW9kQN7BJniRKpqRKLBpLtIRLvCRvwyRFyyQy0ERN2MRN
		4ERw6cRO8KTu9qRP5viuHoEMDiWnoGQCHiEQyKAF0OoD5glR5uARPoAWIGEjmmAxWgCiaEEdwOAc
		buEKFOED+qCn5+CmIWEZmoAMruADkNqf40w637OrvRr2ylOhxbrAWte2uHPMfIfhGC7IqNB4kMd8
		macPyazM/6anpe3qpQ/lA5rgEWygE86BFwCbFjrBFYTHeENBLFzBqXmBmcRgEdDhEXy4CQoFDy4Z
		D/5anxeBGbKaW7R6qxNWiJ+XiMd6tCmNoRs6IB9a00D7fJEYUdThFqCENFBBHbigBWDBCYhABFDh
		AhChtxEhAi5AeM5hAlqA8dBBHY6Bs5tgRazhkusgknOqKzb7kjubx6731Mq3elQtfLl7tbkUtRCa
		tMV7wMp6yx6ak0U5vdV7vUGZlIsEUYInCQDgFpwAFqigBdBBG84BFerhAhpAEz4glzwDFh6Bvp3g
		j83gEWohBR6B8bAaDB5hRZ5bW86Bg1xB887BGIbhwas7V/8B+PZOw9+2l82iB3pI/Hs9oxsIDkqS
		wCFJoBizt3u5dohLebxt/DBN+7Rh8r0CmqB9/Mfzy6Ch7FCArBtO4AL0uQVoQQdw4ARWGB22IBma
		YBW2AAesnAqQXJ/nARFW4RE2oBNWeBXUYRiKGgzE4BFieA7O4RFW4Z3qIMlXocM9HHeY5BREAByU
		wOoqce4s0QAqMQnKYO7qjutyIQmg5I7sgZD44J5XQa1qUE0ugRL4BB1tVbRv/NK1p7yRaj2/utM9
		/ch2pshTvBtyIAfqYQtQfQuuQRD2oNVLPdVTvdRxIMWdoLc7RgwnCgyitw+GoTHQMJDlXAS5s1d5
		L/vwALj/ioKBreEUqC+Cfa/4jm95lK+zoi8X9ugULsH4glH7zIQ0w/pA3xvBENQwx13nDPTJpCzT
		c/y0P9u7O21QhGfUYb3V6b3e7d3eYX0LRl18g13prvupatdOZoIFU2CKywSCU4Am4bIIlxAzcoEI
		UMEMwOCNzkpPrZ0USQAcGr7Sa5zBOgKAKgifcKIx4iDRGuPvXIMS5qDk1Kvk66oPPvzk4yAOKNk1
		NgDbtkkMGI0xyGDnxYCk6oyDBkUx1r2hE1Z7WWO7WW1H3Z0KYSPePSPV630dqL7qrf7qqR7fUT3F
		+b3f55M7CbgTulESHZGDC/gVOVgSKdEeCEEiG9O4igK5/0gAZSPYB8go7C4hu7+14xeMEsRgFYyB
		GWwAGZTgHfDnGARKHSyADKyhn1CiD7AZDDZA8L7iBuZADOpH4RYjEKLNpigBHthYCSxgBSjBhSgh
		Dm5gGnDFn1xhPhofoywg/qYhDgbmHTbgFqAl0G5ADKKtJgLBFSzAVCTQAhgtEI7hClaBGcZQXQpg
		939VpyrCFY4h2pRAGCLv5vHAGFzBGmrBpaah2Aj/UNZlGNQBD8DwLJQALuLAAv5O0y8ttTfQAETc
		d/SwrkF6GltR4SKj4Y7neboB4gBizBgDKQp2M4AwocKFDBs6fIgQjMSJYAoa7NZty5Y9HNd59Lgm
		pMiRIv8/euTIUSPGbhYLUnwJM6bMmTRr2ryJM6fOnRSVDCMDT2avXg7HjBhRkAiRFKESHmW68KkB
		bAqxjWHTkAiYWhNCpZgKMazYsRBrGgNTIK3atWzbpu1TBwwkC5C4MeOGB9kwMHiOWSPDbEWgu3gk
		ukCmKNCNFdz+1oH0bhEyZnXeCQNzRREla+/wvHNBawVdZsgsvNsAxtoKxxIhQVrE7dYKPK653TgG
		zwI8dGQWrVAEhow1Zq4D+QY+rc4cF+iWWDCGbNESdcYCHYO0YgWZvIqOMWN2A1KgW8hcWLtxW7v3
		d33AGKsjBhKey2Si10InbFUt9PDIDPsHYIACDkhggQb/GvhTUDEN5RAfJCQxQQqXXGLABGVQNSEl
		IuQiQkHg2NNJCmBcwkcfRJDABgkWOuHEJSNkuKEIlPBxSSi1GEBjhReSxWOPCcHUEkY4aLTHRyOR
		g2SSSi450kkpbYEDRi3xRGWVVl6JZZY9JSgUUT5+CWaYYvZoFlpunenWBrfIZUx2FgxzAx5ncdEY
		X1xckV1hYMwBiSuBcHEMMoXhscQq1qAzDZ/IYBaXNXBaEAc6gd7gX5xn1VUYcKlZY01m1hlzzArh
		9bEYJAWoc8wxYExz2wZ0SqqqMdaA4YIFSuAhBjN+mgpJHXVw4YISkOx2DDdcbMBMHPAwM8cNikFi
		jBKs/1pwBa2FWXBDHGAsu2sfFlACyQ39/Xdgueae+w+XC3rJUARgUMHHBJ1wMYE1E9gjLxfgdEIF
		CQaMUcstr4SylTXITDCBBfWSUMYl9M4rLxVkTJBLLWZ0Ukst8fpA8VdjfmwAkBcN2RFISiaAcsoq
		r8zkGuughEOULFmkZc0234xzTj4B1WVLPv8MdNBCD0100UYfbXSZaC69Vh+FHUPGO+8Aa4E1l1qw
		Qh393WJNrRLNYQEttQQqzA11BEIJHmkr4d2i4NbRtQV4kBEeGdqRIfc0YHx3zNkSiaFaICu8U8cq
		FrjABRmK4OECM8JCctkGizBzxTFieHeZt4dDAm6utP8sAYkSFtTBTG9kuLYCM8bccEW2x1jAZx3a
		LSIG3nhU620dcVC6LTOfHwvJBqGOi27xxgOoLkwMNsRFCk5wUQsq9iTRyRj8So/NK3xQ8VUuIzBj
		xruX9BEKNj44kYv1VCQBjgX2YJMEH7X0QYg92l/yCgmXlJECFyCD/BKLCGkjRVqHkiRxhGxg4BAw
		8IM8HhiAADzQD36AAQaIcQRJSCJJLnvZHmImJZfkbIQkLCGWdqYgmFAgHToQhAtfCMMYynCGNKyh
		DW+IwxzqMIZsUBrTfnimabQHDEpoz1lW1R4lqGUDbTniS5zoHkogUSJQnIYUidiHAlSREleExByk
		qIT/VYGRihPZACXW4sQiTiSM1VrjEKvFRS2aKS1KOAslmFiANhrjikQ8y1qq5RbiHW+Q5UreS5bH
		kFfkwh4jMIM9+DACexjgfY+8AjjKwAeB8MEeuQAHGMCBCmTMgQqkREUnwUECR/LBkmWgghn40Ant
		YSMXuXCkAar3vzEF8CIEXMcakCQJBmAABvKIoDGPiUxjygMGd8jgBslxEpXMTIQmrKY1r/kSFMqE
		Akj4hDe/Cc5winOc5CynOc+JznSqU5who4kfgfjDKqkFmxJZC0/g2RYSLm0mgiSkPwdkSIogciFG
		QUoKnoIVNhwUKQZ4hUJekQKsTAUb2GDDGIjASIVI/8WhBnACUhTq0YgaoCm5FNMuMUIkXyKJAe0o
		ZgTl4YdDYOAO2WAAAzjBCQYQ4w4LJOYxMcCAZ3oQSiEUET2PitSbaXNdHiupU5/6Px/ic6pUrapV
		r4rVrGoVTf38p1cDOpGBQpUhEh2rWRlCEQGSzCPkkAQGXBrTO9wUp5w4gl3vegS65vQOPg2AH+6w
		QZftQZo0S6phD0ulpSqPXWdtrGMbItWtSnaybnnJPOtJWclOpLKYzedmA+kfr4o2XTxjKtJOi9rU
		qna1P0trClC6EQOSAwMR9ANQ9UpXvN4Vt3R9qwQxIImQpCRKhUWscY87E8UekrEKkWhZIfLcx0r3
		If+RrepEjNFGmFwGqXNADUXiYAxjkMG7YBCDeLEUlD4sISeU0JZMxOCCOcREWAWQSR/MS96XdHW0
		gwSrRFbYwh0KeMAELrCBYdjDifByC2y9QzEPMVe9bqMVrcCgbrORDd5ywg0wiOAdyCHYPVwihPyk
		iBhs4oIhwmQ55R1GAfCwgvJySgliyC5MlsEM5GJTuQJlbkJyURAgU/S1VDEDS4acviF3w8gJne50
		q0vVJfShcVeIgwV4FggwrKA/gVGCc7K8Fc7NwRp9AMw7rFOAFUDCyldQgmrSbAG9gYESWKMEPArA
		J8l4WU7q0Jo6rCGGAsCjz/BwMzLSTDk6ryCMRAz/xLfEYAFkKAEedVjTFVbBjPveYBrWCMQSCiAM
		JQhDGKTZQCCs/A4lOHq9YHBFHSZnRjxwIy3qUIQwKDFq0yiBG7x2xWngYQ1R6zoQ++Wv8fwLBm6y
		YdnMbraznw3taEt72tSutrWv/ex2SoSXHPmlHwIAgwjrVRbi2AYDWtEDTsiiFZzYBjGy0QoGVOAM
		OUXBJDrsh0RMQQY8yAEtqIAITtVhGJBRy5hvQQlmwEMMH7jCXdIihj4sYxi5GsYcyMANSAxDWMfY
		Cx7UoQRmQUIM3OBTIFbnxa9R68ULd8UHVgGGZSiBDLnK8jGWgWMV67hKPA6rjxESgSQkgQuzrKUF
		/zqRC34pMhevsB8tX3GJXEiPDZ1wsnShPFXQHSMxikCGDbgQndm4hjZ4CQTM1XTxOrjANRagi3jQ
		IQZ08GnLCpf7rMBwDM+4AOHYCk8gKoO364TLGmmDxHVWsARmBELukDHNEHd9HeLUxTSLAMMG5H4D
		C3CBC3yyxjFucYzMW4Abp3M7NyJNC4nUARmraBZ6aEEGMNQh78jCww3uAug50KYzYohT5uFxi2Ib
		G13IHkpTrY78kroWpQUkRwQzbNPo03UbshCCENzdCllsowfEQDcxBmFTT9CABq2QoAwSwQN/jMIH
		EehEBE5hAzUvQr5wicwVEEM46NAODFeuC+Drwv94yMANcId3eDA2gjIRzLAInLICJzYMi/AOdLMs
		gvIayCA74hEZc6AOvbECa7JzVtJzEiFWCYEKndAJkLA+SRB1KRABk3QJInAKE4I/MVg9nQAOeDAB
		A5F8ZoV1+KQEtHADyPAOqxAohXIowmB4oDIbBQAcVxAXycEXxzANUhgozFAA1lAAdIEnqVMAHtg6
		kDIrzAAsxzAHfDI2f8IYhYEdzyI811EAAxcnctYHvSIbrjIbqbEqipCFN7AB38IF8EALr3YDfcAF
		FhAffIgdzEAJcbE3GQcuzIAHeIAapGEBBRAucygawZEeOYYt3qIswjd85lJ8P7eDpfgly5cRzff/
		fDmFYTY1fdrHAELQA61wBN7XfemGU5MwfmkgQZMABzJwAaPABVRAHZ1giXBTLcOwJsywDH2iGKfj
		CsvAf/dXhl5UhXujcSO3N8bwDuhQC3FxX8NiDH1xYpPmRZkWKKEiBoG4CFDjjJAABqiiKh/Ic6Po
		EFwgETZIIhRjAC2YCxOwj/iyj2UwAahABMzAUKb4VD2IT1DzDnOgZl+kNnigBGB3GMJAOKknLHVg
		DFygHOUBkoEQOrYCCYrTNY6jJ7ZDBh7JDEPION7RLLfwDrfXN4EhG4rDOJwDCbXyHFnWB5QBCcgw
		hWLgkXGxAasAH8fgAnGwOKTCKi6AN5ASKpUT/we/oSmjcwyEuB1ZKRdx0CvY0Tpx8B3GsAglCQm3
		sDthiRuhFYrHY48OwSKvFRbL9hBO0BBSohDdAAsJQZcK6RCoSEC/1GEwwIo1JWGysG7xNmHEwH2z
		KATzxgCTkFPfBgMysAsyQAujoAk4cAsk4Aq6gS17ISyc4jlisAgiuQqxBzi8gQzDIoChAy2QoA4n
		xgXLUACrYAzLcAt4MIWLcznl6B2BQAa7SQahlx2r4wKeUwuwqY30mFhvyRD+YgD+MiHTaZ3USSGn
		YACXwD2glAuhkD5+uZDuNEeSJWcUwRYKmEJDpDc/dAVS1BZWJBHTEEZcNJ9EhEdnRJ9KgEfyuf8W
		9LkBjKhGbEGfS0QR8vkS/rkW1kAL8oVF/8lH86lEaqEEYWRGRNSeFAqKbYkgpbVYDvEKJvgKYxCX
		3eAELMEi3RB0VOEEX5EECaFIfFAQVOAuqJCDL5oCw0AFE3AKzmMAIiACHcUSZoAUB6GQgMlgBiQE
		EXQIGaZhemVX4iYLnFAN1YBT2dBh8pANU7AOKsARsCAvoTANr4AZOrdHmJEWe+FiE3EFepRNvXE7
		MWEMSRRe2XREcyoRakQRbcRoUOScOhGCYDCCDSEQhKqD/zIQtVAGRGAGZiCe4zkT74RVO9GmNuNZ
		OGNPJVSp1bShHEog0LkQzeMEFmMP9mAGzJD/C1RgDPZAkLfAB6dABbXEB2UADiJCBfpSELWgCGJg
		AySgqLVgDJ1QBwD5CvQyASQQARWzqqZ6fDuIpEWCJLTlVxjgpDglC8SArRimrdjKrcRwUwrkUhiA
		JEOll8WFM31wpn+qrlviocvVrABUEQXxqE7FkJl1WeVpr/mqr/sKRJ3qqQICqgrhLrdaC3QxAf7D
		L8QxAVSQMdUTCiTyojjyj1qBrBHwfqjAB6maBBlDIyQwIrXgP/ZAoxFAAodaiq71WmtlQEdwB98m
		Qcw0V9KnV9FnU9nAVy4FA0KAMoJFWNS0rj9bQoFKAdQAC5FgtEeLtEmrtEvLtE3rtE8LtVEr/7VJ
		SzDkya9Xi7VZq7WgRS7/Kort2mMN8iBckQuEgA3+849lO0vygy9mQAKxOhBcYAaKcArvYoI2mKoI
		QwX2oKiX9AqEQAi5YACdVLaO6pcnlRGx9UvkIEwuW1sw0A53IAROygDZIAR30A4NdEy2xQk7O1Qy
		Y65AK7pKhWwU0AF6cGCpq7qra2AJFqn4urWxK7uza1X+6rWklULL9RB8kEljALih4C/YGQqEAA4j
		gA18EAoharizlD8p8Apm8AoUhQ2dgA0SUksvygfSq53CK5679FqpWCSLKwmccLPJZL7HtEzNpEEg
		Fk0zUFQToXs25h97oppXcIWqAjiEtwzZtf8MTjRxVaJwo5szgWp8rGXAB4zArFWvtMvADczAtuu1
		AasQhYqoBDUQFKyDYKAQ8TpNNIMQFPwvhvqo3jtAJXNAwTRMFARByrRMkMtuPSAL53YECQDDe2AH
		ntADOHAG1RAKDsonbSJxzDAM6lAYzABywzJy3AAPdXEFriFfwkILyzAHQqwOIyfEeeoZeHdiCYcM
		lKB7w0ALH9AC3LAn2zLFSrAMx+BwsybAOiPB8wrHC7HADkzHdcyvEPyvo/iucczHIvO9JNN8dqUk
		MEzDxGBu3ldh26AMssB92scJPSAJ2lcNnjADPWAHFTADbOBdpfMevUGBZJx38BAoeiIXC2j/MPJF
		J7QgBvCQOopnHYw4LApHHXhnGi5QB6cTLooAGTaADOISeeFyA1HcxjhBwKS4x3zsrFZrx8vMzFeL
		x55aukjABrBAzdVszdeMzdmszdvMzd3szd8MztdctSj7xwS0B+SAU4PMAOQAw9tADttQA+WmDAzQ
		A2vAfYy5Dttwyc4wyd1QAVswCGdQDxMhLmCwCMSCDMhwYqrDDepQC7OiaYFwBX0hX3jQB0rsF113
		OQwqERadKjmGGVzAjLMCY+8gSoGIm34hG97CKXsxzDZRzA4xAQjRqP5SqAKB00CqwR9cwcgMr6/b
		zEEt1JP1zBxauunAukmt1EvNQzERJLDF/2B2ZRLEUG6yQA6ekH3vzM72vAbEIAszYMjVcMnxMAU1
		0AOeQApncAZO4KDg0mlKUDe3BwY3EGirAJVcAyqLgCsNWF51wBu9wgze0TeMKAa72TgSARhz0yti
		sAK1QAvGkGnfApTIkJt94dIvTRMx3RAtaABJQAW0YAbVeQkTkATeYwHvN50iUAYtUiM+/THV9VlD
		LduzzbW3+7W522MJrNu7zdut5dQCNEDmjBLrINUeYQcmgdwoMQUaQQorcQ0sUQ/dAAZmel1EdNkU
		gaer4qeVqkYVqqdUNEbgTUYSsXGMhkXYrXOYLROazRD+Iz58CzF48AqwmgsTIrid4DD5Av8OJuva
		PlJdiJAIRoUToIADFQEILzEFpPASiHDgYEAKiAATtC3h8FTUbfnG/d29MvHUwS3cKOHhH44SGiHi
		KzEz96reJ74T7L0QuSARGXMJBYsM1DMGl9AJqAAO+wIGIss+pAFRGA4m1QUIHEAKKVAD1YAIoFAB
		Q14DM1AAM1ADoHAGOFANPeC+bnDgiVARbnAGYDAIoAAKNdANWo4D11ADKXANZD4DKTDha740FR6K
		F97T/yMQITQzRurjPxITarHhMTMkIu7nIe7nIs7nJG4RJo7ih34TKq4QqPpIJMAFDANJ9iAhpUox
		4AAJuUACJHAFj0QEd36KyqwWFYDJgHD/BolQD5RMCtVwBj0ACPFwDfHw5dVQA4OQCGcwCLcOBlPg
		CWgt5BUACvUA60teAVVaAWYNCrDL5mzu5sMH52VQBh98wTcd7Tjd0xWxEnzQISkgdGNAAiKAwRks
		l30sE3q+4d3A5zET6H5+7jKzEr6N6O+e6BfOBizSZMv2vd3gXAZgBmWlFMfs6dQF6gWAA/Fg1rCg
		6qTw5YAw5WdwDVteAWCww9cwAzPQ5UIO8Z7gBk5eAJ4ABvWw5TsMCD1QpZ5wBrCA7Mk+4ctubBf+
		qiIADkpQnZckI5hkAJeUBGUgIzSiIbmQBLlaqiLCB4ugBKswAYpkvDpf2j0u7jNB7gWB/whPvxJT
		8NyAAAokbvWgcNaeMDMJzhaTphOUUAs1oQQOqiXLEXsS0QdkjxOUEHuw0xMntmI29hKUAPfwcBZz
		0AdKsHrbMmNicN08oej/boqRNQPHngjVENCkMAOlntaDAAs1UABnUAC0ruX1APkc3w1bDgaeMAiT
		XwGWnwLVMAOKfw2NX+Aoj/qCxpa23aG47XMOMbDxEt8kwLe1MNrWcArWQPv7oi/8YtMBMzBgkDBS
		dwo0GKuj7fs+fRNrATRnMAWIUAOJgPWgkAgAjgh2gAg4MAXxQAq6jgODAAhLPvZgMAyaEnKpVguZ
		ZjdLfGgF0AeY1mZ4EAhigMZofAVz8P8BwxBpbyFrSrAfXgwQNyjNsUaJDCRu3JCBQcasD7OESpgh
		G0aL2RUwYB4iU9JwmBIL3JTAO9bnHbpFgUAaA8PtwzQLKmtZ6IPH2BxjE5WAGYZnTqAPO+ugA+MT
		Epl3cyzMIXMD0rKMUaVOpZpRyTAy8KqC6dUrhQGwYcWOJVvW7Fm0adWuZUt2a1SWBeTOnYsDUcZ6
		Ge2CoTv3LhhQM97e7VuXcGHEiRUvZtzY8WPIkRHDIzPs32XMmTVv5ty5M1atVbua5ZJiBJeZyJJ0
		StHpUhISl+ylyNWaigV72F7xuZSiWy4iqMyAmRCBSwQStXKhAkeCBLjdvdtOp+72bdX/FJ8+peCe
		YlC8ChwAVbjmqcaMHjPOgPJdIYWnaxUKqE8Uqo/GOhmdLpoDbwUzSJgREJI5wKAEnTkgWQGeG6w5
		po5jLLjiCgjhYUYMMIxBxoZAfCKjDqbqOChAPLiABB4EuVjhHUjeseCdKxDEI6MI3zEmxWMgWYQb
		n5YR8BgVV8CQjFs0XASeW5Ax5oZFxDiGmXfuIwMZRZC5Ra4blroBmRkzwkOROpg5hozrygTjqqy2
		oiAMHQRx800445RzTjrrtPNOPPPUM042yoyrMDOvSyHQtyQz9FBEE1XUMcos8+xRSCP9B7StRivL
		jFw6GWEEe/jg1AB7MM3FDHsM6ARU/1L5uAIcewgZY4xLjjkGHDBqqYWQ5qiwxx5wfAiV1UvGqG5Y
		6giNygBofkhhrkEGIaWCGeSrYArw3Ii2m248eQ8MT8Doppoz8uIpPzCYqQOPaY75Epkrjmm3wGGs
		KReSYVYIZJE6FmEGjCtuuGGYYwpM0JUOM8zPmPzwcPeGft+R14Jj3mFmmBuY8bEAcvtl5sN5rbFG
		jBldgCRip1zYaZqnmPnAmFoIhESdOfrgQsJaIXEFHki8rBedWuS9wkcxyLDgBjKNpQrN0KiiAIlQ
		tHP6aaijlnpqqqu2+mqss47aAD/5WvRrsMMWe+yxG5X0bLQvo1S0XswaY1PuiCAihf9QwoK7brHg
		NgAbsbAZg42yiKh1glC+4ptYxNkyGgwDEEBg0IyqAQWMGUCpxpNEUjgjhQqi6uYMMAbBHAxSzjiD
		iAKVQMdjpW4wBhJroNRQQwxrUuKoW6zp4xgXhDSQljnqsAajOZihhQwurHldeUjqEGMFY44xZkF0
		nEcmkBtcsMCCg0DKaJntXaieKYVzsumY68dcpBaNaAkEkuOfnAP6G2phBg+MLKRFjFUoAQMSk63i
		CmK4Bf4gAaZljGlxU0FapbySOAhGUILFus6fyHZBDGZQg2AzW9o8+Ki1UcVSEyRhCU24QDOJ6zoq
		hMVd7qMRY7DkCvdRwgvfspMr+I//KvfJYVSGYRUavpAlU7nCxKYyjZ1QBYnDMCIYpuG/GnptLj/M
		yA+pqIQhRgWJPsxIH+YyFWPsRAkTQuHRQjiVEZpQjWscVtc2+EY4xlGOcungB+2omTNKpSvd4WMf
		/fhHQAZSkIMkZCENKcgyJlKRi2RkIx35SBQ2kG1mcQIJzPCVs8ACFmzkJATdOEdQhlKUh6rjHU2Z
		x6hQIB1t2lMrXflKWMYSTn2CZC1teUtc5nKRkhRh28qCind04hWhIEI3SDCGMvBhDCRIgQhEsLdu
		pAAb2PBNJ62Zlk+OUpvb5CYdK2NKcE4qTVVZmtbMeU50plOdW9NlO935Tng+kpdo//QlWSJwhTJM
		ABW1uEQnqMAF1PCBChOYgAVyQQUydIIPZrhmQ82SzW5GVKJvLGU4PYjKjOzRoRvtJCNTUIMKqBAM
		gNjKNapCChwQiiDIKEBU5kDFqZBhgFJJmhIKJJVlwDQq8BjeVvCAh3ckUSp9SNp1lEAGMtiQKvBg
		ScyUUIeFwONcShADRjIyB6uCQQw2rIVQFzhPPdZzLKjoRC0MEAEDcAEMnWgOKsqQC1vVZlStAhxH
		OQrRieZVrxz8pkXtiFGuiNWug5UgIwdRnxpcAwfXuIYbatANUtQgEYCoRgoyV4NqIAIUFYAFKOpR
		HsieJwWb3YJMeWKDPtxgDnMowP8cuLAIlq4gZX0QAyQ+cB+p1qEm8JjDyqC0E1dAQgw9BQODroAM
		2lpACT56xzBQazF4KJe5V7DGSAxkjXcU4AYYooQ14AEPV3wpqEqh6g3uM5QCLOUo3CgeU5xSO0is
		wgWBsMAwXHGMmYBEESLhhgUoQYkXUQIeePjvi7x6JsCmUSxqZRxac0GCMlChDP4UAxWokIu0jkA5
		xyRsQ/G6wajsNcSNGTFiSiwZqQAqxSTOSF8q6tezJViwYalrXdNi4w5vdHHZ+YRU6lGBCuBgENeo
		RiLcAIpmnaEGNTisZM+QiHp4YgakOOwZIluDMwxiPDO4hhLEqC6KKEIJCoPEidD/IQYEjewYVxpG
		HbihiOMq4h11MBKGrLECPHCsKMYgEhkW8Z8yQ6IW6MCDOrKSIwCdSF8sIZAF4KEOjBBoIgJyyr2e
		dL+dVGwOW+pSUWxwC4iRiRnwWAUZsBeg/vhrZBYQAzf8hQyE+PlJsI4SA2VsliSEJQmm6QQRzFAL
		Tm3KDLlOQiguYdYcX/PDkaEENzLigqwuwQVUEcY441kVMmwgKhI58FaE4YI43FC5ZZrDNMCQ1KEK
		QxhKjcqXFHHTQsklEFnMyIthHKlbl6U2tJEmNbvBNzNEc5q0GcPAuxFwwOE42RNcnAF+oKyogEKx
		Z6hGPRKRiM6dYQb12PgM1PMt/yuDogaUVQ8YNA4LyYlcMFbhRh9eNCNmEA0ZDQGDvMQkMX7l50I2
		Y9AybEYmhMxIERkhEBiOhA6SUWzOfQDRg+qwgmFwIRDouMV9CnKD/2Tk6jMvCUKQ7uppF+W4PJPX
		MGobtKFBpQ5KWMGm6/D0Zdzg7ZC4AoHkrgiKWezrFKOZVMAaFQWjhXEGENbgx/KqhVtz2ZDZwNCL
		Gwc8110MTIm5/9ShiEXYBCQrECOBlBKHQIAh9AtxeUnmgD+JABAeSggEJfDAkRugSwnWMNnrdxKI
		OERoGoQOXh+EcYP+cr3Z+HNFHVYPVe1awNxgUMdSdDuHDbhXQpRgxirCzY04ZP8JI+8Ib5VGgr8q
		vtvVZLCGSN5h3g5ZdRjouEG5QH8Me98bhNamp1kikIQkcAEbuRiVBTqRKSp4Bf57BXsQwFx4hUtY
		Dntgg1NJPBJqOMeBHMDwhAoAhGeJB1DogQoAhUQghQ68uIozHVJQjylIBMvxhMDgOA48A0BYBowA
		iZ9yAbmDiFWwgJwACSW4gaSghY9oHjzwkf05EvgRNTGpg9DTiOZZPRNxgWOYhrZbhZ86iDqABHZZ
		AYWYEq1SBDxwgX3JQhvUF4BJIGaInqI5igIQoGUooLpDIAUSg6GQQlWTuxs4BosgA3OBhJzYGC4Y
		Qztsom2TMUxyQEEUvAqSokP/2QByaZEza5FVmIN3ACptswBkWAVhUBBm4A+NUAeWWYFbwLpFkBUw
		wLN3cAFaWIE7gwdacBjXyxFaQJFKPIYVQB74wZAXQYdKVBDaC5Asib0nEQaSAJAcOQZhYIapEwZ5
		qTkuERk8VMRXXIJSK4qTMMZzwwNm+A9u+MRbiAoLQEQ8RIYdwQMxiANaWLOMQIY6uAUyQAfyE4P4
		k7/PoL+wMguy6gRIoAL8S8AUQCt7uAQROIVL+MdX8MdOGAO2woMJEJZB9CRG6gZxwYGU8pa3aCG8
		8DGqyIv/gosk2iIv24o+yMidoKL7sKGNXD4tKsmhCqMzYTeryIgrOLCW1Aiv/yLJrXhJfskqlnxB
		MfKyJLrIjeQXMVo+mvQ7wKIAaiCCSDhKpExKpVxKpmxKp3xKqIxKqZxKpQyFxXsMRCQ6ZLAAMLCA
		FUCHKGmQaUMIC0gvuUMXfpEX2FEEYYBCdJi2fgFHpGMRlHnE/2keCxCGsgSQOBizn8KISSsAMeGS
		omAYujvMJZC7W7BCE9kArIMEJcjGctnKroSEDYBFSKA+SOiDFRCGroQ1SjgYf9kAr0OfdpuGi7AQ
		guFK8TFNMLiF6lsBLugDeWlHd9yMfCMLBmOrS+CDCcAwB5uA3pwAexBO38wnVCACZhiBQExIYrk2
		6IxO6YTOv8sICugAPchO7f/cTu7sTu/8TvAMT/EcT/IsT+4UBFp6Cws6FCVYhXM5EUjQrlFcgSW4
		H3O7gU68HRewBi74oQ0oy+apLuXiymnMs/+IAxeoA3XIvXPZzxtAGf3kDwfVtmMIBC6ghC3JvjqA
		PCfs0M6UwwdZARdQBBvMzC68gey7hWobik2TmQ9Bh/vEnocAgw1YBMs8htyzgHAjun6ZhmFchNex
		iSwJt9fRCEXgvO2xzdvMjNwcCxIAiyf9RwN4Uio1ACk9BSulghQAB1TIhVDIBYR0TsSZTjItUzNt
		pOoMrENaUzZtUzd90z+6yseghAlRjA3QIY2gizs1xALA06nYgCSyKs4Mt5f/3FO6eCFA5VO6wAjF
		0CFKkItETQyr2gBt09NKRYyLjApGRQwb0qFNRYyR6KslhZQmPQvEI4tTJTxhqYUy8DWGEtPEOVNZ
		nVVavaFShdWElFPHYKS+qIpdrdVaKhtRHVXPAMQTAoPuwNUxBVZmbdbpTNPAC4tU7aTmVFaw0NW9
		ylZtVQwlJdahpAZYoEpxHVdyLVdzrUpnTVd1dSdonTGwIAI+YKZBAYtpVdVo4o5uQMhXwRYD2BR6
		pdcx+LdARFa4MTxBxNbHOLFuWrFfVVg5ctiw6dZRHUrslCWLvViMjaX0XFeO7VhGalezyIVlsIdT
		CAU+gIUUcA4i4BsRSAGC/5ImcJibCXACl52AauKC2sCGmDWAWnjSCKAmbIBXNkgCbGADPiCCXC3E
		RdGiaQi7eGtYqSBJFauKDeghY5kGSs0iSnDaqS2jL8oIY7gCejOWMSoTiV1SQIRTtV1btoVTj31b
		uP2qWwWLMqiFCWDAfoIwa1AOA3gwe8iFU7AGPojXXCCovz0mJ+iEXrsFPigDMyCEB1Pc1egEQjgF
		W6HcCUha9VRUyeid/1mB/ECGqhqjMdqAd1iCuehMq3CBApg2ZEBdJyyAK5gDqnIFJXgHzyzHApme
		nVBdMBAGdAAQDJkeuTiqlsuuJ7oCMsADixCGYYAHMdiAbPSdjGg7MOgdef+Lgw0whtYNxXAjA5EA
		g3fwnxXYUTCAvKIIhNDDvg0AX36hDDLwTDJYAX4JBDKYA3VgO2EoXhw9N/gbVmLljLm11oWLWwM+
		YFuFR8BzVwPAvzI4BTwogwh7heToBDCIsC49hYHcRxIAg0vo0iQAAyqwhjpglTHIhREghBK+BBK4
		BQdOArs9hTJgpkFEWMXoCGSAxXeQujIzPmIEXTHBCDJYs3BrvNnjkTF5OqdYhaOiBWRokHDDsySW
		rfdRhHATR2Yg0SV4uhnZAFdYgVXYEgCiQi6AzRyxAQtYAi7ghgMKtwhJ4mO4AexRBx6pCTa+BfzF
		Om6wBmFgEUUgE87ckoj/WeMbUIclUAcdxINbADU82GKs+5JqVIQnOQZtE4YHqYXFPNvbHOBqJWAd
		Q2BQBmWQLYtOmINOOAU+IAQSiAN7sIYJGNwIIINWwRRTSYLCZWVCGIG+DQU24D9TIYFWZpVQiIBQ
		4KdjAwfhtIcwTTwbTozbtQA5O78bMN13sAFrri8A+SGRUQfPzEr8iTljUAeAOgYMuUzzWgH2QU3X
		EeccqQNFYInLXIF24QZ0KDN+mRGdm+aZ08Fa8BfOXAHZcmdzywneUYeRgUz02ZeKcefiKYAyw4i3
		gzMDQQaPWZEckc/4hATzskzgq+cV2Oh3kGcxkRKbcQGJ0WR3HODMNQAz/zCDJ0W8V4lpZzI8YalX
		T1acUM7puB1lsmCDWkiCv6kFNhiDV8gnnn2FMTgFLNXlERiDJCCCpMbSfgULM2Bqpy5aX1NmIjAr
		NuhqZKthpU2U0PwSgGaGJbCAOhCZJTiRpriFcJMYW9QIa7iBP5Y7pRASLiiQPkhFcyETDb1rX4QY
		jKhRG+SC6KLPnAtN12uZVXC15onjRViKURNsrbJrhRGDQGAGdRADC0ie6BoT3bGAWgCRzD6GH6IQ
		4UEfAjkGdKAv0oQE1ETNJVAYO6y7a5yDNWOJHDE02UJp+RtgtGpgKqAFM5DSS5gAWx4BC4gALCUB
		ESgDJ/hHvLnpttBp6//2WJ5G1YDNV3rtanvF17IAb7UYgbpa5mV2wGaW1HXrgz7IHzLZgALoA/+x
		36gQBmPQoQ0IhGmj7w3ghgLY099VglooGtF77/CFB/MVA+6F7/4WoyuQXdmtlVqghKrdqpGBywKP
		Cv3mF/9uLWuojHnL8AcnntsjcB/tA0rd3kW4BRcYhv8G1JYccWcD1DsVBkoI8asa6EDw7XsbYC7g
		GiqQjVroBC6YADwIyAv7RwxzjSIncnA4b+omxOuecmdt17a9cizPcj9KbxMzmq9NpK5tMblYpAdn
		sagAcEL5crhYAplsJB6HsQHOhYywlWOTxNWAlU5gDnCwYHuwR3CYiFf/6OQofygqL3RgTVOiNE9F
		X3RGb3RH706rDOttnfQ3glhFeXO/GmBmyIVOIQEugDBPmQ3ZKM5cAAdIeDASuIJOQdpBXwtDf/VZ
		RXRqOFdar3VbP9du4HJK3/WIwnSLGmA2cAInSDgD6GrfwJYaY2kbkxtBb3XrgHVof1ZjdfYO03Ve
		v/ZR8vVwGmBq97Bo/3bq5PZuVzxJx3Zzz1ZtB6dpH/e7And3f6fsFouE6wZ2VyNrP3d836B0PyUF
		tk42yViAD3iBn6V3L3hdinewwIYIqAP9o45qqvezuPd8n3iy2fc7GkqmWSeN33iOVyeuMXiQryWE
		Dwvg6HSCIgHF7eUi/ycC/uvlXEhAcOADAygDiB8Liad4nP8ai/+rflfTmneokA96Rxp5sACOOYiA
		CZDgnp2AWogAWHANEmD6CGADVHj6f6ICKGd3iKKKMH/arp+KnMf2nf8gcf/5EhJ6tFckou9bCLsF
		Vq1bph9yU7Hby02rvsUGPPAbs//4zaWLeqiGIYOFKYiKygEDWGgWHEiEGciskcr1epicjCCFwZei
		a6CsygKEu3j8qCAFyDepsNersb+ono9WA6ikS0ILTdp7tTATnWx913992I992Z992q9927993M99
		3d993pd95T3CXjoLoR5ce8S/XWEDKjAAKgiFTljA5H/+tMp6rS/3M/9QBVBog3hwBrwIhzTohjZo
		lkEABQ3YHDAIh8kBhBoABYk7A3yABZICg2roAVVIhB7ggDYwKfRX//hof0DgAFLgXIAoIHAgwYIG
		DyJMqHAhw4YOFcIjM+wfxYoWL2LMqFHjMDLwwIAMCbJXLwMmT5pE9a7Tq1BEupEYU4bPGBIpRIgw
		gK1bCmzYUnRDKXQo0aJGjyJNWlQkU5BkxECNKnUq1apWr2LNqnUr165RT4ENGzYJ2bJml6FNq3Yt
		27Zu37oVA+8dpKYjSyIdk2Iv371HwbyyqXQw4cKGTdoVaQwMwRptZuDrgQ/kGQ7OSOELNwikKlKc
		r4E546xND2c92uD/AwQyDak2g9z0SAO6wujSp/GBqhGP8cPevn8DD9474sSNxo8j/9fxo12SRSNc
		KTMBVa1Lnahw4VKLD5UJEyzkokKmEx8zh8+jT38ycUgyyxTAjy9/Pv36Crzhz69/f/43/v8DGKCA
		/+1ToIEHIpgggqUw2KCDD0IY4YMh5FOhhReCk8w8JyQjhYcfghiih2VQ0aGIJwKRoopASGHEPFKs
		WE4DmiTmnHo34pijYeyBtFhjaYDijBscgORGG6rMkEI14eymCmhgqFJPaPiwJqQGqnQDUjjXtJGI
		J26kIeUZVNaThhtXhpYGb8Kx2aabbxZEXHJz0knRcjXiNRQqndRi/0AEBnABRifgkIBKGbnUUksu
		KeRihj2EsKGjpJPyCAYZ3mDBjqabahqDp5+C6mkxo5JaqqmkSpCqqqum+oyrr8L6DBSz0jorPbea
		kKuuXfDaq6+/+iqHsMMSK8c9xyJ7jyPLMtsss3LkQ4C001ILRDqa7LIJHNty2623cFxbTrcOkFuu
		ueeWC0cUlWxSriiWeCEDnqF0U6+99+Kbr7778tuvv/8CHHC+lfo4UA1ImuYaKEiWVsFrbkAJCmee
		zOAJldekwYEblYHkzDWqPNxGBRVfnLEbFfQwSA9rwtmyyy8nJGedMxt3Z3N5ChUoGH4akAsJJJZx
		nRhUUJELoCMoGv/TpEvfWCkZZLATqtSgnlp11ayyGqvWsNZq661f06PrrsCS/WuxwyabNrLOOnsP
		LgSYErfccgOxSSXZbpL3t3vbXY62uwAeuOC7oJtuOey6u668dlEQhg6CQB655JNTXrnll2Oeueab
		cz45GwSz3A0oieBQwBSJXOMZIvUgksgUIJGCCOyAAFKP7SmQYjsinoGRiBuk0A4G8LXfnjvr13CA
		A8swM9/8mzLTHP1FNjdl41BJnJRECiN0QoQZtYxgzwgjmIF9EqFc0ifT66PnNNRTwy+q1fNjXb+q
		W8vaNdhfiz122f934WzGUluy2Na2t80tgXW7W970tjdv9U1bcBj/HAUL5wA4iAJx5BKF4vCUAvaB
		MIRJAR1BKmXCE8LihCFRnvNa6ELhQE96MqQeU6w3QpOMwQA7G8oYcijCH/6FR0+LWvykNj/62a9+
		+Msfrfa3v/7lCoDAEqCwCLg2AzbLbXBLIN3SwUAHPrBbERRcGC2IQQ06gIOVWFz1cAbEN4KQhC+c
		Ix3ryLwYyjB6NBQJST4Ixz+uz31ELGKojni1JGJtifr7mqtwBUUTQEGKU6SiFY+FRWZpkYtd/CIY
		wwiHMZbRguRSFxrVyMYaunE9IFHPGOzVwx7ay4+AxJEc7WjLW+LSIXjM48z2GBIKUIMIkRgmMYtp
		zGMiM5nKXCYz/5vpzGcaMxSC9JQ5zEHIGByRHUhEZKvwt8hbZWAAYOuaLgohyWCdLYBVtOIll5VJ
		TZrCWpxsoCc/WQm/Aa6eZjxcuzbYwZsRZQR8uAQf2JBDMGxvBK90ghN6iEMfGsAJE/AjOAhqk72Y
		B5Z7wYYBYJkTWM7SKLXMJUlLmstd8pJOvgQJBTqgh5fCNKYynSlNa2rTm+I0pzrdqUwF8TkhQk1T
		dDiALUDwqU3FgFPaLManRiUBOkjAkKsqhhJddT+t3cpVBzgArTIgDWkcwAMmKEQjdDGrc6JTDoUI
		QRfURqx2OuKdmlxg3TrpyQjW01vnOmM/0/jPNhKFCOCog3de4f+EMrDhFa/4XmIXC74UTIAERDDJ
		oZT2igjkYgJEIMIpbMAGcEyULOAwQC0m4KcU1GK0IV0Kjwpm0tfC9oUoTWlyVgqGPvYlt7rdLW97
		69vfAje4wgWu+7CAhWA0Ihi/eEIMrBmLWERNAYx4rqfYIQEBeENTGfiCAIoRi6iuKhYCAG8xTFCF
		Z6hKACaAVYMk8LV7rNdVJigFWJ9BDyhkILm/SC4rvhACXcA3V7pga1uPpYteySEEBA7BFwohB13o
		wlj/VbCCjZVgVoRAWI5QsFy5uEC8NVCCYTSEJvyWV26hi5R9NSWeipKCToDhFt65RBkSZQ2C2pjG
		E+CDNWqRwxv/R0qH4EiCdyZQhghsxx6nIGwnzEAIn/FhAp0ghBNWS5SRxjbLWn6eRGirR4+02Mpi
		bh9QzVGFRtAhE2o2ByOk8QdbPIERViiCLRrxC3MI4A9f+AIdinGALxSBBVbwADs84IEM2KIIX/hD
		Fdjxiz/84QD0kEAwbGGFSRdjALbY9ACq8AdFf4EVxejvpqVhX/x+4R7FKII0tqvnP4QACh6AtDS6
		4OY/NKLWugC1B+QgjS/Y4hfB+INa/8CKIui5wV0oBKSN7Qhp2OIAukAgPD8cYnqGcRMlFvHeBFc4
		FSdujWEmChd6NgYpWwActbDHGPi07jHY4xKBAQcYKkq0HI6B/wqnGDIJEkUFbJyCxowawSXqAI4y
		EIEb3BjBmFGC5S1DPOIPma2XawZmgBbFoT+UZcNHWOYnNEIB5lDAABjxiy/sYL8K+PQO3MyIIhQh
		Fh5oRCxODtX9muAPTzjzzr/gAQE0AgTAaMQTgA6C8aaKHqVAtDRM8AVpeNoKJrD0PQ5ghVNvVxpW
		+EIG8luI/n69EYUgKys8EGrk6sLsIQBBI1hRiC8EQxesaLsVrMBgaYTgzSGw9N6lMfdgZJjamkxG
		P75hiH4YIvGJv7biFV/4XfQjHZKX/F0Zv4tvRENv5PrGKfmYypOUu9ydOLK6O2EAeyTKHgZgCSFQ
		Qe9TlMEeEf+YbL5J8Ap7oGICkACHPeyRBNN34hT2wMPBnZyLJEB0zA+XOPObH6cuV7xOtrUhSpIQ
		gTKEgrcncegrO4pviIJlt90AB0R7iI2GgrTjOiwzHVpQhUycuQpmN7QHJPCHYIDhCX+IxReeAAZg
		tMDSfUExmAM92MKwidcXvJ8VHMDcDZoV9FkwwN2r0Be0Nd0X/AI7fFV+0YEGXt19bZcVgEAGPEN/
		3QMUBNt+fZUVeFURQEF/hUARWAEUMBgIMFis3QOr/YGDFdUzSCArJBpYBcOzPV2HJdAsGIEPzIMR
		MKER5AGI5U0eSOEUJmEDOOEU5kEnBc4m7MIsYGEezMgVRsH/N3yDJtAIxgWUATAcGyQBG7jhZBGB
		G0bKZjFDBLzCXiRBS0yWAbjhGBCZAbQEWYwBwylUEpgBG0zWKbxC8ilfay0Pm4iEQ0Si84XEQlTi
		b0yib1xizEBf9M3J9H2enygBoZhBLohAKPCBPYiAaYEDKvKBAVBBJ5yPPZBAKJTBJYSCSWDWGFiH
		CLBBvIUCko1BLSSBKZbF8XFcI7LH04zcosVCFSjgfrEAIyhADNiCB2TCo63cATAC20lAfgFDMbAD
		2xEaNA6AAMAd0HnAc8WCfc1dBoyKB9gCPdSd04FAMWjdPTzdM2gd1nFdMczK3B0YBs4dCByLrf1B
		Fwjkr4UA/9nV4D10AdsVwbEc4K4Vwd5dpIINGNuxguBx0THYQyeI5Ejmwi3UlSHMQh2E5EiyJEve
		wiykQ7cEDontyUg2wE3i5E1qAi34wLjdCBFMwE/US1/gi/ipn1Isn2+QAUgogQtcwQaEhFPyyBU8
		ZVMYhApdQR+EhDFopQo1RRwwxVMupUikwGJs5RWYJVO4AFROpTEogVeKBBlswDRsoki8A8V5IkaA
		YlGAAxfwQTBSAZLVAhcUTc8oChdMRxKg3iUYw2HSm/VFADZYQzESwRxEwMHxQWZexytQQS1cxykc
		5fotI9SYQwa8mi0IACP8WaSpZjBkAggUQQwMALD1HzvEgv+iDUAmDF0GmNmi2cIfCMA4ApstZICn
		FYGkpQodRJstNN0f/AI+SoMESCRz3goUzCYrQAEkASFF/gIU/Npvph1X9ZcuIJot+JywHEDQ0SDc
		dYEuvNmmmdPbbRoIAGGkTdsWaVIfiB8qAIEhbIIh5AFN7JZQ2EMDGIJM7gIcGEIEnEIyCgUbmMEt
		9OTNDBdx7UyFYmiGaqiFsodrBQc8qIMLgMEG1IEYPA0yKAEzCIMxXAEYGMMNFMAVBIIwkIErBAJV
		wqiMLkFIHMMcgIEYIAMlgMQ0BIKPzoELTMMNKAE6HMMVwOiRxkGQgoESHOmLvuUKQGWPgsEcGMOL
		1gEYHMP/EggEOlhDHaCoEtxAHAiDK7wlGLyDIsDDR/RoAQgDMoABHsRBHBzDBiylC7jADWglPKAD
		MzCDGFgKjBYAJXDpiwrEnLqAEhgDJFiDOijBnApEHCjpKtwCXualRewlUdSCEqQPM/ABPOhbonQC
		vFEBMyDD773YJUyAqEYAMmADGPBBdlyCPTBKEvCBIoADHyRBHYjAK/BBokwAsfKBg1rZNJlDFghA
		FcTCpzxrtMJHDMCHOMbCOS7VM1SBBMTAyT0DO0AjHZwXVRWDABSnq1QBCbIXMOTKM5TCejHIrABD
		BhzL1xSY2BxYewZY12VAWx3YPWRYe37dsDgChi1bqLXV/zVmQIY5woVh2MGywoF5ZAJtwF6wAV+E
		AizwZ94AaBn0RMaehBvKUgPMwoF+y4Kalk4w3IMSgQjYwIQ2BTDxVM3a7M3ibM7O1E916CP6BiSY
		6YgywzFwgzocwzG8w9D2QR/cQiAcAyQsAqsqAiQEAh44LdRagKGuwA3gwRwYrQWAhDUoggXMgSvM
		gTVwww3UwQ1YwwpwwTEEgtEyAxj0wQfMQR2sACRwQ9ciA9uW7RzggQXUATdYwAoMAxgswg2swjHc
		ABkcA97SwlseLToEAiS8Q+G6gCscw9YKwzuoLSQsQR2YqY8Kgw0ILh7UQh0cAx6AwRV8gDCo7g0g
		A6vGgf81bAAz5K0iHAPuQuU0mOkxLMIccGqn2snFARZRXAIX5MIVgEMnkMAVdEIdkMAERAAXXIE9
		8MEIlIEBlMEIcAE4XC8fTJY9gEG7bW95yB4JvCIkoFYneMf08gkjitk0UVM1fUo1DVJTiaOmlIqm
		sF0GimsjZIA2qQqqpApVwcpVuUrXQMECO9GtANBZAVCxLFuuCYsuwB0UyEGzaNiybLARzs0SEAqJ
		eEcohAJ/+mc/zMMlJME89JuxXoKLTG8odMLJbsvgJEMEmNbvvXCipBY2wALMyixTABM0GfERI3ES
		K/ExZYkjsokSqAMerILQrsDlgoEFIMMH1MKIfqk1NOn/O6xAGK8A63rxNKzAjuJBHyDD7MYYSDDD
		BqwxMxTAl+LBO8wBOrwt0s7tLbQu66rD20LCYliDEoQxJCiBNdzpFTADF0DlDcDD3FpDpLoCPOhM
		HSjBOyStIjcu61rAMXSuNVhDIKDDNHCDioKBGa9AH9wAN6ADJNSFMcixOkBCkw4tGYAtF6zyMQwD
		MwCqpYAt5g4v8X5qQGXs9pyEd4DBCGQfyaJEkDFzUQQZIFJBDrWsSVSz+tHvNenvEVVBFZCKCbCC
		CVAVIi3RAtfKAz9SFKEVr1DRhSFLObHCACkLFoGw3DDDJeRCLkRAJ/gAEYSCJpxkHlyCDhQoFaDC
		PHQC/xfgJCoQgT3YcMoipgEkQQNEQOs1ABdoQgOQABvGrAeF5kcPRVI6BNyCASSIgRIU7hijdI/i
		wRVQgjVY7jGsAh6IwSJYwBIwQ0yTwQ34aNXS9CDzMRgwAy3ggTAMMkxzAyRYwCxj6jvgASV86RVY
		Mh4cgxjUwi3MAeAW9VED7U7XgYjiQR0wAyVYADxAAjoswSoIaSmvQiAwg1fHATpYQCA4cljfAtNS
		wtPeQOva9BWAbif7qDFYw0sfQ56qLeASKtHSwhzcwC0shlQzg1l7RCcS70YMs5gFBUhfGVDlrzbL
		j9XwL6kQMDd1Uzmf8xP1zzqbDRUV2EF2AVy5U8XOzf80dAOEns8GUALH9ud/5sH2joA/+3MojAAs
		hAIirp4ND46CRjQbjA8isgHAyWES+EPnhQT1aXZoinRDbMBbLm0BbMB3b4B3h/fS0u1H3MAKiGgc
		TEMB9MFH9IES9IGQbqmIXoF3gwQXrMBjj+hHoCUluHcfhDdbQuUGwINACMNbLoF+Ezhd1oJZXkEc
		9EGM/ugVKEEcyHdWKwFUwsM0kKihhveDK+peTwNzgIF62zeBDwRUXkGBF8CGty48ZCUlxIESuDhI
		rPiI0jhlV3ZGgKKyXnfDZbNnG9I2JVE5v0oToXNqqzY7C1AlwXZcybbcvMBBIAIK8/YlgIRvFYA9
		GN7/3uTwKcgvSoSCE3Q0GqJHZv/40mQ3Jp5QeAsEXIqEm18lnNM5nWe4XdR3nXslQgRzp9pW4zxO
		5wj6oBN6oRu65PBsYgyRZ3/2kJcKaRt5rCA5/0DRkrczOz05s0R53KzALHg6S5ZkQPvASrZkS75k
		TKasJqDCTTp0TuZkBKzCEHseDyFzZOViR+FECqRQammPCZsEmqd5eqy58xG7lvV5Xv45EnTDJzB7
		szv7s0N7tEv7tFN7tVv7tWP7s4umor8Poze6oz86aWfNEj0waqdzpS95a1fSQW66KSChDyAhFhrB
		tZXDF1ZhvWNh3TxQF3q6F0qhP2BhA1SCuJn5SRAB/xeMQS5YB1hEAAuTQPBFAJKNQD4TQT6Dg48H
		O1I6cbFzfPMduyf2eMYfZZB7e8mb/MmjfMprszmEAH5yUTKkQgMQXj8g3uKFWOMlXi/MAhDUvOJ5
		y+B4LM5rQjIoXrtEAXXfRVHQYhmIwCUgGazWwis4vXcM1ClMQGCyQbmJ/HkMe8d7PS59fPRdNkrw
		xdbDEcmrfNqr/dqz/f22PDzFkxcRHs7TPc4XnonVEwUBzgXBgSZcmyiUoU9uHzbUgRnEnjUQygQk
		WY/RWGmhKs+Y/Y5s/NdTPmyFfcWNvUnAAgkkAQnwROSLENq3/eiTfunDD8u7vAKR2Df0e+uTIRn2
		+//rf4MPOAC37bve870PVMIsfMPAa4IP+IPgo4SP/QwxYoNiJUGNKeYEhELvhUKfqA/oD0bXV371
		t9Dle1nmR5Q93EKUHaK95DobnOJNiEAKiL8BiEA3wIIB7KH0ixRn1681rbz8M7r9pj39Tw0WwI/+
		mz4hoT7cAwSQdLvylDN4EOFBTZoMRim3aRMciRMpStx1EWNGOOWidOxYSZM/MCNJjuzVy0BKlStT
		jhnD0mVMAy5Z1rR5E2dOnTt5riz5c6QxMAWIFjV6FGlSpUuZNnX6FGpUqVOpNoVHZtg/rVu5dvX6
		FSzYYWTgATWJ0iYYe2wulanFhw+4Tp2woep06dX/3Lr2InTiY49Ip56DCRcebLYkGTLs2DGqwoKR
		uRjmJGeSTDlGZnMKBGCefJmy5MyTFWTwphk0atSePTOKxUgBI9izSTNi5zmzgtGYRbPerABL8BiW
		XccIjuXzaOXKzYUgYAp69OhANhmyfh079mgF+6WDGLFieIoZdzkw/x0iHFHfNCE+aRh+fPnzdyIm
		KbRqfv37+ff3/5+oq7IKi8ACDfxnrLLMeu+mXIioxRoS+LikliSSuKSTFOzB6xQMU4hAwwmsmeAl
		+kw8USX7RlLsNmBs+cUKAWKoQjcQWJgxFnYyi8WVJxiRUQHIYoilCiJ3q0KRX2IxJ4sqZKuiitti
		/wEGOQGsrCI4AXJkR4EiqghGGhY8yGAABczZ4Y8qzHFytyLooEwA3arILAMzYwAmSAEcky2YIgfY
		jIUshqxC0OWYc066RKlDj1FGDfkmD/DEmxQO8jAyD1PzRImiEhkQQwKJUNgYldRSTT0V1VRVXZXV
		Vl191VQDVAQDP6N+QmrWkvQjCcBeff31KQEPHJZYrRJ0Dy2bcpnAHh/g4oMKuCbIxYBlpaU2AgO4
		ICKCEVD81sRZWVwTBDAGCCYGK/5Q4EVzPPhgSXMGcEWBA6yoQppgPKhXkQOkeTMGRqRhJBMFsvDA
		FRAGKOJefD1QsghprLACGBbUUQe4TH55Ahh1sv+QJhYrGPklGFsE+MUVKy7bAR2VqzhAARBAiMGD
		YKyI5RcPBJCGxiIOYMSVAQYAQQErggmG3XxFM3QyRBOdrtGoITKkI0kpDc9SjMJzYD1PzUIgFR0E
		GZvsss0+G+201V6b7bbdftvsUGattahEzpgCjGtIqgcHMOo5AxRYaqhmEEQK0BsMUmDp2yxSEAEj
		BVJISgHxxGt4PFcVgd2cc6WELRZ0Ao9dMNmakjAAHBJIYGOEEcABx4DTk0iBilpivz0JNnIpEdze
		DRN3MXOACSaTJ+gYwIMDvPmFEWA88BJODzKxIosMggGDYp21l6xLBTKRpmM6dhCahScUNqeIHYL/
		EeCJ8qXxQMgYigbhABDevPmATOBHp/3RHj4gUB5YRhVAEIsDgCEYMDLH9E6WvCzMbGgZKNcBgDGw
		A+iIaU17ztOgsyipOQpSVrvaRDKSKfOM5yLlYE/mWNhCF74QhjGUIa2GUhREuOEaNQBEBUaSAjec
		oQCeyCEgAMGBKaSgAKrAQTXwcY161CMRBQAFKepRgwIM4m4FiGI1poAIT4xkiDNIQRULAItE4I0U
		VjQjKK4BCMulAAzVAETn6EjHz4UOj10ZHVAYhBOZtIR3gIQJNpzgO0MWBni3EUARPAACc7BAYjgb
		wM4ASJkqeMBdBpMY8zywAxAIwJGTYYEVavbA/06ygA7lM2CYYhGMHbSPDlWwwhN2A4JfQFIyMHuC
		NP4gADoo4k/mEIAHwDBMb0hDAMh7oNGyAKNhAoMOHpBGDILBAhYEIwsT89G+PJBBzTiNgx784Hce
		lQdDjPBq5IGDA3zgg4Voop3+oMUM6VlPe94ThnQrgA9n4Aa7gbECFehGDQaRCCTyEAyIiMcZPFGD
		GdhtBvXABygqkIhqVMMTZwDEGeoxA09M4QwjOcM1cFABUniCcIPI6A4tWgNPVOAMGq1ANWoA0b7V
		Eae+umMeebrHn5wkBYcU6lDroyIWZQY2opENUrGwVG8Cx5tM0o1xDMacLETGUOZw6nKQo5ypYv8h
		NkyTTVMzA9bRhBWpo2GEV7vqzdEoAZxPE+c4qzOLSKEThVnbxSY4tQmMbOobXsPnYAlb2BnqExE9
		uIYnElGDkQzCDRwABRsBlwKEdqMHnkBpNWYQ0pIGEQxnqIYZZ1CDegwCHxsdSQ1AAQY3AGKhF4XF
		DDob2tFWo6OJWOggcFCDGtw0p8Htz055ikefloQC1CBCJJjbXOc+F7rRle50qVtd614Xu8+Vm1EX
		49bdTMa74A0v05Y2XvMqp62jSe952ZuZuCpqnNmJxizK0Y9G4VUijtpFA6JhiO9sSrCGFfCACVwS
		faYgHlgEhRuw2AMwdAOmgzBpCr74YNFeVI7/NTgDKSpQgJha9Ic5nEIN4qFaMAiupt04wyCuUQ1S
		ZPgMFn3xiwFB0ClKWHLC1bF+iFtc0B2XJBRIhx6IXGQjHxnJSVbykpncZCc/GcpHFgQbEqmZ5DBH
		fkO68tIw4w3h8GZpCojNaUKTVOaA+TO9sfJuQNObqlo5NrpBM2tUg5vwNmeD4fygFIDQ5z4nowGz
		4LOf+yzCSW2C0H3OgyYGDQQj5KEBqCjwpClNWH0WgBSAqEfiiLjpByMiEZ5m3KcRUeoCdENyfUOE
		G8e46b6RtNQk6YYbE+rGUhtu1Qm9Na7nKMVN7xjYVOmxj4kF5LOkANnJVvaymd1sZz8b2tGW//a0
		qd3sKscgTr+gw2zMpAAYxYAO8pvTjNYqLxBk4QADWKuVhBeMtWpMSTcSgJqumeXJzNtMWhoSMCLj
		mMzECak0YseU7MSCIixpMq0sYAaECRwaYVtG2F6rkxp+XjxzsIMfRAUquNDxjkcgAh7v+Mb9O0JD
		wFPkH4+AJiIAiVwgAxlPqPTMaR7DS9dcV0TBZ7B5HpVhE/tAxgZDH4ladKPLiru3GWWX1geCLx1T
		mrGQRr0+IDTqTQYERUC3NKRhjid8AJX0mozx6PCLRUpjktIoYJascIBU2sIWsfhDvrLpiliKLDcH
		+AMjGOmBLBytCN6gDCSloe0nCABmKDuA1/8/AAxgUA8ErlAE4gVf3qi+Vzpz/U4yuGAGA4QC9KEX
		fShe4YNkGLoiyYjABFICC1iMwBhkWMbsZz8+SOAc97k3y6V73nvf1/HnQC+Q0Im+kj/GJ5Ax6cby
		g5qT5h/9MEnn0r4+GYtO2o95IOPZH+gQC+sr4DYDeNPA7iXNwz8hE8N5whMG8IsqmL2AvEB/3vdF
		ShYULV1VUAcd4iQNL2PhCZLH+hjBA2QpExQhXjwAGHZA237hYBbploZplhTAA2LBFjhGYGJBzMbr
		4jBO8yBCBSLADCiBBEuQBFMA9BDhFVBBClCPIgxh9YjgFchgH2rQBmsQGLjBfHSPB3WP937/DwiD
		8D+CT/jCgvhKRyWwgQtCjg1iYgywARtIAgp7SNm6IQVIoAxCISX4AORqoUTAgdlOYSbGoBtqIdmg
		jycSiR0QTwGe4BdiQBrqhxEmpgJF5mgUAF+AAwuch2Zayfr+pWjKjQ6O55PMDv44hjKYzhseb9u4
		iRGOJhYQL14GQGJASQHcDQSkIfAsSZvar2iSyQrKhOvoYBmsoA3DpGhw5gksj7wwD2qiJgSxgQTZ
		gBAIgQrMIAkmwAxA7xU04fTSiQTEgAzegBiLcQd2wPGScQBkrgebkeZ+UAijURqlggiL8CuO8CaI
		wAKIoAwm4BRyARsshAo6QQTEsROSIBTK/4AcU6AbOqEMSKBEyoAKTgEKqYAWzKAMspAPaqEWiGBD
		2IAL0rEM2AANdUINZYMx1ipg1Go5dEMh3eohzavcgKEI3CQTtuqsAsY21Coi02o3MJIRgmOsFnKs
		wCoLTnK93KoD9QwWRZAEuSUCGuDjqIAXUeEXK8IBgAAcTsEFruAKjMEbgnIfkhEYbnAHyscZk5LS
		oHEam9IpkaIarVGPyAJZcIILUqAOsOEUqCAXqIAKUOEV7MErwdIe+DEXagEM2MBZCFJW5jF1wKEt
		qGACqAAc8AAbHGQOIgAc+GACOqEfCzInrs3O2oswxausukokQ7IwzUs42islVdIVMw4WO/+PBDfA
		CYjADF6BCDYT9ETAJkUoGeJgGnySNL3hDW4QNfdhfH6hDpTSNQeMKZ9SNpsyKqVyK7DxJrigWsaA
		DzoBD8CBCuzBADrBK4XzLrYSHMDgEiagFnZnJi6BBCqEBKjgEi4hF4OzWpKgDBQBHNaiFjrhFZ4P
		MFmiyszBSHzjzELDOJBDq+wEvc7sM4oDMwxGMryh3NQMvRpzznoDP+dTzrKKPzUDNthrJeXKOxqF
		84ggKZbNDD4TInZBCsjAJ42BQo2BGOOA9mrwGI+xYpYRBFrzNUN0sGJzNks0CGvTNhGEKkkHJ8rA
		AMqAduzBHlTnEgxgOSegRvlgBPjAGpL/cwRywR7KwAxcInUCwxqSgAtIYC521AD4AB8hgQQIYQRk
		1FvGMy2S7kw84E+8YdweDqm0pALHLCQFYALlZ6piwUzxcK28LxboAAusJBNAQGf0ZwAyQUs2I+LO
		Chg6gzN04/68bhWDBKsggx1YQADi9BfsdKpGw0rAqgo6Q5gUYRUtLjJNQSCiph9QwS1qwSs71VOD
		0/QiYhdIoEIpVDFO9TRtkBi9AZUG8XjKTkRj1Z5I1ERrtedQ1DZxcyfYQDxrwgmYoROqdFTIkCVG
		RSVGRTzZMiWM1Uqv1D7GhSKHpAgajw6+QOtuIxgO7wNO5pqqIJrSTQHthzLC9Qm8wRam/8kVgiGa
		4hRensBfgOEXMiAD4E4B0I41uA6ZUOaabMYbrMD/jMbvIJFkDsCX6ODxsEozvo4BD+AAYgF53I4V
		Ly/PDDRqkiEPKgFjMbYB2qkBOrZjNcGcKoUnXWAaYk8xTFUxapAFNpQYWWABVXMZZVVmZYhWm4JX
		juJmqSKGdCxnSxRXpVJXTYQIrLAbmrXoyjOaFqZM6mcANONcaCZOxYQP188b6kcz8GXqQCAYfmbx
		rmmYKKh9ysdG3udG1i8L0HQyFEEBBlHb+A6BlrEKrAd7MuCAYqAIimcQn6BeFeA1jEMAFAHtfgFe
		o2ltJ9W8ClRRDrRRDEEFdEAHnAByxf/gFHRABfrBcvvBv3ZBGFyAc0+WQmnvKGFOaAagKINSKIGh
		/WZWdV2oZpliBSBhCQoAKJCBEmTIBSABEgqgJ0dCCeJgJI4BEihhBTpuCVyIEnyXJFYUMVygD37C
		GK4AeWcuDoQhhuJgA8DgZ63xCHvVaLs3DbG0gu6vZhhhlNw0M54AXUDmZXppAKygCOrUTZYm3TSG
		6wgwBqyHAq3AmhhpZFhAlmgJBA7vADRDE/3OeOLUaMDt3CQGgEGGDg4Am4yHTOs1mI4J7VLpeIDh
		AOKXUic2cRFUG0RgGohgGkq4VMlgAtBjFyYgDlo4Dji3hcnAGJZhBWp4BUh3H4qRGFX/ExlTd3V/
		eG5qKD/6YBXIwBrEwBi4QAmmIRBoQRHIABKWuBbEgBvmIA4CAQxcgAuuYCTigAtqFwws4AaE4Ri4
		oHjBgBvUoQ9qWBgsQAxogRmEAgxuIBAKgAyUWAm4YA7AoBZcgAy4YQMWYQWadw4+QAxuYI/hAXnv
		mBLmgAyEYQWu4BgKYA7moA6UABISGXlvAB4KwIuVoACQYQmugAx6Fwy4gHrnYAUooQCO4Xr1GAzi
		ABKuFx5cARlqoQ9QGQzmABkkGYznOHbFgAvAoA5cIA6ytwiFjgLCQGzgxpmfGZqjWZrLhsqSDqkw
		o9y2qiMVUqtyw90waDk6kiEX8iPX/2oj0dYcgiGYdmNRz+o46DMiZcM827kju7m9EDfzFDcZtIFk
		OdeYW1gYAlqgp/dSlzMOxEAM/rknK5QbkGEBV1WHiVEZfwGIKxoxWlcpKGEVjsEayOAWkIEZuEAR
		6mAFLAAebgASbsECFAEPWhoebuEdilcJYM4aRgIS6uAGSHqPlYAZrCEQ2vgYhOIGkPcY8GAFyEAR
		VgAPjOEYbmEOXEEYrAEZXAAdSjqWFeEdlPqpyQAMrsAGkEGW05gbVqGGb+AdIMEFmnqr59gCkAGp
		gTer1YEbrKEP8AAZRHoO1KGG34EZxKCMFeGlkSGVb6GlbwAZrCGvx/p1bRoSwFoRbv8Asl8amYXv
		CJfPsi8bszNbszebszvbsz8btEN7s69tMUu7MCPWtN8ztVvRgzNvE/ZZBGJ7Gk6Btk/BhadXoJdA
		t5cAY2thAryRDGibEMSgZEuVQiN6h3EQdSnaopv7PoS4KvqAFuZgGgpAHSB7BYwB5vAADKwhu49h
		GrJ7BSoZEspCCZR6FWx6BcTAu7kaDNQBDxbBGCqZuzN5JKYBd13guiEBitUhEHK3NaeBu28BDDYA
		pYV3BZiBd7kBEuLArHMXDwqAGY7hrG/XFQJBwcFgGkKaDNSBC0CaEgzbAua4p+tgDnIXd7n4Fqzh
		FjYAw/d4GiC7ruf4dZXAApQARI3/ARJuoMMb+wa4AR0mG+iC1nuL3CCt+c5WW8mXnMnDKxPiigA2
		CBe0wQzMoIQthAhOAbhvW6BzewkCwS99mx9rARmQ2LiNYQdMV4eNEpWY27mbG6OTYgNAlBIs4Bji
		4BjI4BjgAXe5Ic//XM+XABlQGgz6wBqsYRFsGqcD4RgUARJWgXo5WoxvAAzsO5ZvWhgmXAzggRnQ
		IRBu3BosgAzwgBJa8wosYA4Onb1HghLgmsItgBKsgRIggcK5gM89nbvBQAwwnRmGegnwQB3iwAIs
		AA/mwAKOGg/6gBnmQBGEYQnsPK1pnVZ23BjgoaXbuK43oKbBQBi4oA7a+AZudw6Y/0HIiY3IjRzd
		a0Iw22w93xT9QiM02A21m5ze6z2DVpIJ8iEE9mEaXC8zX6GFSWAa4oCFb5vgvbG2f/sU4OESToAE
		uAHiyaC4Y28ZYm8O9iEoixE1x8cN39y541zOSaKRwaAEC2Dk+0AJUF7lC6AP9ngkNoAMwLgPhGGP
		Z34OqLfQPdnlUZ4kqLvQ54AorJcSmncDXKDAC+B6C3yXp0HpX77mh57lWb4PKOF6hb55R2IOuHgD
		XJ4MRL3ludjn+wDpY5kofP4KXL7QeT7rc17sr36Xtb7mC7zcfezcDYAICHJYj5UgX2JUqjTdh+og
		bSkGdukXhEdnLml8vC1mvOEJoP8EBMTZ3iM/8n3SBXShFN6ADMzA9UbADLg8oONABhG+tkc/4Vl4
		B+SyQ/DiFV7B4iEeiZdhB9bcBjm0fK7H4y0a5JmiB3GFnng/c3x/JHiewJaCJOa+uM59DOYSDGpH
		DFKCCEgAG0KBRObiFFLAQlKADdDx78FFDXcGY+AHAZ/gDz4JaWbpCXZAGl4AfNzwOCTf/e29hEc4
		tuc/tkn/8+NAhF9B9Gl7/lf/FWgbIJYIE1ZrwgQxZFwonBOoIUIyZPa9mbiv4o6LO4CxoBMMjMeP
		IEOKHEmypMmTKFOqXJnSGJgCMGPKnEmzps2bOHPq3Mmzp8+fQHPCIzPsn9GjSJP/Kl3KlOkwMvBI
		9uploKrVqlzGcKnFhwo4VJdITOiaK9elJJ06vcLTqUyKq3Djyp1Lt67du3NPQmSX6deBA7E8CKgD
		rIiHYFUOgPmlLkuWIgKsDBBQhBEIAeZiaN7MubPnz6BDix5NunRnYyS0mTFDgsSpUwZfy379Ko5t
		Jy4maLPNO85s2RNOzQEX/NQ7QtySwzNGZplz5zsqWsSokQ4Iltiza9/OvbvLoODDix9Pvrx5mEOL
		Nl3Pvv2/p1FHTpWb4lIZKknsRajVGtwr/QZdcokIp1zSSQpc4KXgggw2GJdeZLDDDiNP0MFIFQpU
		ceETGAKTyRPBZCIAHTEAIwAw/8DEwII3prXo4oswujjNEgM6IYJBscFW3G+vTTONbMK8huOQSywx
		gQtiEHdKLcjYV0YgyyD53DIoTodRRiw8cV13XHbp5ZcofXfemGSWaeaZMqXn3ppsGgWfVFTJRYQ1
		bLSFB3/ggGOPPXe2NRYfJORiQAQOFmrooVZByI5mmWQSgzmQPgpppMAoIKmkkUYa46acdkraNLV0
		UstqSewoGxm9pTrNjTyeIsyQtRT5Wp66zcEHH0eKgQwyz1WE4pUXVaclmMQWa6x2YqKp7LLMNjuT
		mm1Gu96b8sUp1ytjmFELNiN02+222ICDTQq1gJPCKwagi+i67NqlaIuaeirvvP/0dgZqWhOIYKOp
		rc7mwqo49mtQkfAsEUee4IghBh/OwYMMPApLt8+v1Gk0wADDHqvxxhx7lKyzIIcscnjQSmtyUtSK
		NJ9dY4wBV8sGwAxzuzTX/KBJe9Wr8848f3ZvGWWcYgYRNwbc7ynaaHOKCGYscfSrBtUidRwTSH2Q
		GIHkggxUc2BkEQsDoMjC2GSD2PHZaHv58chst+12mkSdLPdRKYc01Vs25633uu/27Pffnl6xRFpp
		CU3EKzvWZltwqcaxhAgz/jbQQENOUORBVuvKBTKBIPMOsMFqNDaKGmnZUdqop77S2m+37jqzJc9t
		ct0gIdHBCE7krvvuvPfu++//wAcv/PDEF897KH0DrvzyozFCxASEd3LJakSUGodYsr2i/eKx5TsN
		vwFDXbXUtcRhtUHcrKA+xGJ0HSzZLIhNxxP0n676/fiHtHZINGFX5kevC+BPYie7aNHuI92IhLcW
		yMAGOvCBEIygBCdIwQpCkBJ68QYWmMfBDnImC9qI3vSIQMIc0eYVwDHVBMgwDe69ZnKTwxH5DkYF
		q9VCa7uagw7nAI8ewm8AdKDDxQbggSLk74j5W9sMzgAIMFzjI6SABRhIcQZQ1OMMNahBCq6YxRRA
		USSk+EgKnpgSUuDgI4NIREjCOMUz8k+AriNgAdl0QCTakWMQiYFj9sjHPvrx/4+ADKQgB0nIQhrS
		kFeYANDKwI1XmMFHLZwNDF01SdjE4UetgiFBCiK1U4iBfAbhwzECsUOGNIR0YLuY2FbwBCvc8ZVn
		+xgi3ECKGgCiAh5JgRvOUABP1BIQgOAAKArQjUQI8xrdgEUinIGIajQRmIBIwSAAgQhPgKEaiYjJ
		NMEAimp0Awwz6AEowCDNRCQCFKRABClI0cRwXoOKiCiAM+EYx7jNUVp1hKU+vUQGhfnznwANqEAH
		StCCGvSgCE2oQhfK0IY6NKAMQQYz9klRYn0sBfGoRjwScQaPXKMCFejGIGqQiBSkAJe5xGUNrlGN
		QXhiBksEBT6mcIZ6zMATgP9I4xlmcEZS3BQUHJhBGjX6RBxYE5uDIMUghJqIGcQDFBWoxhk4ytOX
		0LNtcrxne/JZ0a6ypJ8PDatYAwqRsoJVDMbog1rXyta2uvWtcI2rXOdK17raVa5XMIYY3uHVvm5H
		lj0gRQVmUAOPDMINHAAEOqt4UgSqtB7mTEQ1cCDZwlZAqfgAxBlwkEUpXmMQmS1sFrsBTDAYFQy3
		nKw5W4oIQCQiHjWYbBbPeFWs2lOrdISKX3f71bH6NqxEcesVljGHK/C2q0rg6nGXC4aLwvYM13BD
		DSrQAzAgogJYvOx1HcvNM8RjCj3QLHTPkIIq1iAegKiBUi+L2vNqtryg8C7/GTVbA1jEF72DuC8o
		BjGIdw6CvbVlW1Zx2xTlMpe3Z/2tghG6jA3A9QpoPbA+k6tbCVu4uVaNST0AIUVSgAIUUrRua0Pc
		DZmUuADXuEYBSIHieoChxN8kRTdSgAhuhniKM47nN1MsEyt6VMU7fiIihlkAEGc4wCEbMIGXYuAL
		dzXBCjPrQJ1j0GVAWaAQOSiVAeoCthZACWyNsJORSOH4jHm5+2NJTbQTE5OsOSVIFvBtl8yeJp9Z
		n1fmxhz0jGUdLoOgUIHEQSHxjiv/kww6DGha1WqMd4iBEmsV853vV+ZJH5d1cc50ppVMZ6TY2dJ2
		vHILkPGBFUCZuB+4gaH9/3mLVq+aDMe4BS248WoxfOAYUF60EuqAhzlAWq2SBnXaKi3svmJa08i+
		Kqc77aYKF/vJAR11qaEMFVqouqCIpsWqEcKNVQxloGSoAzq2BtBFX2EV1iADmIHtkmejjdjupuix
		k03v1y2b2Z+Od+quzIsVtADXAb3CLSCx7WXAQxEFXUYgyKAILmwbHR+wgV7/ueg+QGQRYIh0u/W9
		MXhz/JXzrrfIbaseZhfY2R+/45UhMYcbzOHPXMYDwMGNDnQw49XvWMUiXg7oOszcn11WKyQUEYh1
		9yHYKSeWx5N+xJCP/Okgu3en8830jV1Zygsm6xzEAHOGkoGtVzA6hDde9f8vLb3sqnM61NeuLKnT
		mepoL9a2s053hQXdrYg2bty9dPa9o03tbA88mdy+ZIub2e+om3vd627WLLeP7IjXTt8jvzHA36Qk
		4QHg67pTW8ITuA/GmAPlUcecxpv+9KhPvepXz3rV63302Zk87ItleZuQgRnM4IKvwaAEMnCHDMZw
		wUcoIYyR+L47ccAgSlbQe2ZAogBk2IBHiO+RGzCjD9ZnhuhFEofXdzkk0QeDC5Qv/j7oT/oeiQP6
		UeJ5Aut19vCPf8dkL/8u1b4mGwgEOsRggToEogDvUAA38A5KIH4r8H/CAAl9UAArwA2U4AIK6BEW
		8A61YAwH2Ae3AAZiAIH/xjUHH9AHXBAI0wcJ8AATSlALN0AJX8dCc3AM03ADSgAJdVCCcfB8LvAO
		0hcH17cKilAAeOBox8ByHoEM6kAJXPAOwmABy2BtxkUJ3OACZPB8eBAHYgAJlKAOpmaFBXAMixAH
		YOAKkOACBSAG6rA1zAB9DrMBcwAJYJBuVYh+S2CDx7AEBTAHeNB+uHUFx1d/fNiH3EF/fogsRxYU
		SmANYAAJt8AMgcAM74AHK2BceJCIe7YChLYC6BAIt4AMGXiI7wAJiMgM8HALLncL7yB6DKc+eCAG
		YEAGK6AIXtgHrvAON3ADEMgN6qB/73AMN2ANFhCKlDh0SiBwS8AFMwgG//3HDI5YfEqAB3coBngA
		CdNwiOp2BVfgCmKgCEF4DMLADbNoDcfgc5CwK+ggfIoACXjQB8x4DHe4AtaAe8IgizdwDKGIDMXX
		B8hwA+zIi4GAB6A4Zya3FH2gh+3TQwRZkAZ5kAiZkAq5kAzZkA75kBAZkRI5kRRZkRZ5kRiZkRrZ
		Q9xwj3gQiBY1iECxAXVwiNOgPhYwDJ5oXND4DvDQiIpwA1fQgOhwA2zIifE4DaOEDovQB4EACSK4
		AbrYBytQC2BQg67ghVfwkbm3AbtyhobIDDK5Au9QkyugamAwDYboiKo4gc54DMJ3hXigCP1kh8bY
		T3VwewWgDjdwj8LAjv918A5LUJMSxYCqCJQWcIjIwA0TZQE30AeQ8JZ14I1xsIhLkHHf6I2UAAkr
		MFF4iFsBaQyl13qUWZmWeZmYmZmauZmc2Zme+ZmgGZqeSVzcCJJgcn/4V5IOR5UEJ4O+BwmrkIoW
		YA23QAZcgA4t53IecYT4CGu5KAbH8A5cwAUZtwqBYA3W4BKLiA5KaQ2UYAHO6G0WQAnOCQnHEJs1
		qGo3UI94YAEoWHzMUAfMsAQ3UI6r4Hs30J0WsAJgwAyqmJXWoAR+SQYu138W4ImzGAd2OI5t6In8
		6InmOAdccAUsd4zHAJyMCQZXQJvMcAwEmoR36I//2BR9MAwWeqEYmqH/GrqhHNqhHvqhIBqiIjqi
		JFqiJnqiKJqiKrqiLNqiw6CHc4AMpvklqFkTC0gJOIqjRxmNYDCAxtUHLqAExrAIdRB2whATOZqk
		GKRWxecRYth9H9FlSgATC2h+tlEAlFAAN0oJPgIG1IejMPGlWXp0qkimXphxq9ikYEqlGVd8GLQB
		xlAAG7AB1HeUcQATc0p8anUF1HejYACnWPqn7/mncZqlSyoMjzmhirqojNqojvqokPqow8UNM6o2
		IgkeJpGlMPERG6B+XtJmppmokTqqpFqqpnqqqIpbcFepI1Gj5aF5gpdsopqqtFqrtnqruPqPq8qq
		+nOpm+cRISMS/TMS/6AKrG/mqzIBqzjxRjgxq7n6rNAardIarbvKqx/hqsWKLOtHEitAfiNxpsb3
		euknriTBBcxQCwXQpEdpXGLADMLgArjHDN4aB2lFEi6ghylxDAWQEi4Ap/V6Es46rQI7sARbsCZX
		rdaKYeOBghsQgyIYCLZhhRYID+8IfQqIDpBgDJAgpDg4gAVIC2TJDEpwg+jHBRT7AQQaFfBwAxuw
		hYvQpGsonwghsi4wSgVQg+Z3BbRgDBYQCCWZcRhLCYpgDNoXCKsgBgWogRaAB8JABgsXhVkqk+qA
		B3R4rgUQCClYAECpBEqADtbQrtD3DubnsEqQgH1Qc+jwhCuLo6Nkfv+PdkkBa7ByO7d0W7dOgXIJ
		yxLYGqauwA0WYIGKMAfqgDW/eAsWcLiYiAzd+Y3IcJ910LjIYFyKsAK9ZpOLUIDqiISLQAbIELjq
		IIvvsAKrUFyUkItccIDW0HLh2YuTm4EbgA63GQh5CQZLMJiACQncIKcf6RFXUAdc4I22eI3HwIiC
		Vgee6DlU+7nHALnStwiUCw/qWAcFCAnMsDXYaI7MiLvKS5XqIHxFagHcELd2O77kW77PirDWurda
		moFpCQm3OFHqqAjIcJIWyA01ubxzGY+4ppLMYFwD+JEyd6YEGoZcAIGusIjtqYDw0H9ESZu7AsAO
		egP2O4sKKnGkOFH/YIAH4qZDxmAN6vezzWWI1tmJa9mWzBCNJGiTAkiJhaiSkDAMetmXtOgR0+CJ
		ZMCWoeswu7KxnqgENwcG0juA4mu+RFzERuyo6Mur6qsE6mANesYMxmkBPsiMW2NqK0CeNxAHN2AB
		uhgHBxqFaQkGugcJvXgM21eDX7sInSidz+mM/NkHyGkNK7CG3nkMxuBywyl6r8sFU7gKzECbCiqe
		vzsNC1q2GceM6/kOIpt7+olwMnigvBYHFtAHNyeDLuGuS9tyZ5qAX5t7LjCbicgNkLABBMcF3QsG
		+4ibQ3zErNzKrlxAScyq6rsB1iCGBSClBUgJhZqkX1amVzCGXopB/1Dqpb0czDEBpWI4fmBqfhAR
		E6AXqF8KzYNqDMIgfS4wEOjHtdU8fdOwiZQgBn3Atbn8nsIHehgkBtJXpRqIfkuqims6hulcfBvg
		Iw07pSq4CNagd3GQEKv8yv78zwDNZHibtyqhvlqKOsNqR5raMZc3ElcQB+YXEv0c0BRd0awcy5Vq
		0LG60cVKExNt0SAd0nWL0TOq0Rx90jXx0SK90iwtrSRtmiaN0jKNHhLa0jZ900T80iAZ0zON0iqN
		00Ad1I+q04HI0z3N0T8t1Eq91FM30AQdJsh61FLdrDXN1FZ91adK1H5o1FMdeEmN1WAd1u6h1X34
		MSBxJsSaecrKE/9n3dDb0XlVLdZyPddLRtZ8+DGCVQFqBEZNBBKD4EYm8dceUQ/WdA0zQE3agUyG
		FVX7ehKgsNdOBFJTIBKP7RGtJVVnIFLf5ETWBAb/lQh5fU5RTXJ0XdqmTWB2XX8fUwFtAAvhMAWE
		1Q1UdNg1FVVeFA7j5NlnoE5R1Q2EhQO47RFuoAEclQYVYFMz0FSHTQotNQPVgAgfNQUsddgaMAhg
		wNofhQODsNvXUAPo5AnopNeekAaT9WIc0No1QF4fBQqe4AwecQaeoArRhQ+qwEYcoAGa1QbXsFkc
		kAb1wAFhRE9ffdoEvtSpLX8fUwOqUAPOkFOqEA9pgA/w7QzO8F//ZyTfYMDgntDf2w0KNRAOEE5G
		beAGbjAD+OAMboAPHOAMqjDe8TDiIw7hFfDgI87iTTQF4aDfg5AGHIAPQPXgaYADqiBV4+0G8eAR
		FeAG1YAPPQDh1ZAG8XDkKdAG9aAKZ8ABrO1iYDDibnANGpAG4+QJR14BRy7gcV3gaJ7mKOPUT20S
		H3MGaQALbTAI8dAD+JAIKl4B+NDaH6EKLkbmiZAGbXBGQGXnafBE1xAOaeAMeo4P+KDk+ODfPN4D
		1aDkztAG1EXi1XDpWm5UII7pNeAGFcDjRx4ONeYJbgBaHoHqZ1Digt4NES7l4UAK9S3mbfBNoKDo
		adAN3eAJGpAC/xsOBnY+2iMz4Gp+7CJ94PH3MYPQBjWAD6AV5WfQA84g5j2AWGfUBj0wVfgAW9ee
		6t2+4k9UAc5QD20Q5fhA5j3uDNfgDPGg5ErOAT3gCSAV76nOTRwAWtUg78bk4kfOASTuCT1QAxyA
		5G4gU/lO4vEg5h7h421w5XDuCYeFD1VO54PgDCd15NtO7CJj7Mj+8RSt7PC3NvUACjW2BdeQAiim
		8jWm2C+WYqbFRooNC9eACPFUADb/Yrwu254g4TDG6zSW8zWP8zlfDzBR8l4ECzKPAzYPE0Nv8zef
		80rvUTBxYoDgCd1wDS6GAynWDTV2RiUPE1AfD15k5iUH8mhP4P8iP3tmfT/1oOVdVWNvbfZpX/en
		vfawx9VAsdZdLWdnb/eAD9Z4P3p63/dP5/GBn/h2O/iUV/iGL3KIr/iSb7CMH3mO//j0FvmTv/nT
		WvmId/mYj2yaz/mkn6ue73egH/qbdual3/qvfPp7l/qqj2Sj7/q2b6qwH3cGzazLwvtBsdZtvdG1
		f/vED6m5j3YGTca1cAXbuoqQVxLgqhIpeEklQQnbF6XN/y/XH6VBChLC4K2rmLQq8f1euod9sP0f
		EX4hsc3aMfzF//6LevxlN8u0QI1zEAfwAAm/fAy00LTM4BIAoeSdGDLMNhS4gcwYtwLM3oEJBGmD
		EkjIlBQoIMb/woZVNgpYELbMQp8CkKZRYhZogyIwYIQZXEIm0A0XkCjNmVOHkoVABd4FCrRqFZg4
		08BYuMXwZR90Q+MUiFOz58sCZG70LICnDjxKDC3Au3LrY88lkMgs2TAHGSV4zApYEwMGJTclc5hR
		onTjnTExlIQ1XOITHplh/wwfRpxY8WLGjR0/hhxZ8mTKlS1fxpxZ82bOnT17HkYGXkvSpU2fRp1a
		9WrWrV2/hv3aGBiMtW3fxo2REjpIJbmhi4gM2apadd7NketKjCJkeN69Q/eu4jsLtdRFfIcH2TAw
		G24Jg4QnEBhI3KyBRwZJjLEViuDh6b7oHZny6JYAv5GQmTFk/4qWqHsJElqomw0PZlJSZAULBHyn
		DmRuqOOGRQJJEBILLowDDGsOjGiFQMS7wUPx8IDwBvPgWSi/GzKEBJL5FjkGkhV+y24DC46R0LrB
		CvusRx9/BDJIIYckskgjOQtttNiWZLJJJ598crbcpsytj0XIKIALZJg5iosrAlliDhe7swYMdUKE
		5Ipj3slvA+G4rGMYC426og4w8FhBGPJWgA8Ps1yCxJUPwVACHkjm0O+thtZkJo5AI2ooT1q4vFNN
		6BJCRhhablkkPWusiQOdhG7YQL07NwjxBkiUSHVVNBdVsDsI6zgmw2laDNVECyjaEiEL8MBDzB2P
		JLZYY49FNv9ZZZVNEkpnn4U2WtekpLJajDYoEwy9drXgFGtWESO9Y8gsST360OEGkjjqsIYMbl1g
		xhoX5Pp1iTzB4EJM8eKwASdmVoHHArliDGTGu/CgREZubrAL4Lu44GKFG5Zo6V886IME3hWOcYEL
		MsTAg+MWXbhhmhWPosUCR8WoA4+VWybjmFusyfNCd+uA5BgyAMVDjBbJmMMadQqyxgKNVqBv2GWX
		Zrppp5+GWshmpaW6aquZpNbaAlLguuuuQ+EaL0pSCKUAF1wogJIMW6KE0AxdWKQOY9p2YQO50gaD
		DLtbUmJnJS5SgtCdwTAGI2P+vihtv/9OuwDEAz+c8b+NSZP/tA3spmTnPq7A6O+8Mffb8doulyvv
		Pkon43RraIEn8M3B2NzxxFOXa3Bj9uv7dL3lUjpq338HPnjhj536auOPR55w2nDzOgVEnoc++uib
		bx43y104nTUqk2eb+9POftJz1Hofvnzzz0c//cSK975992MrvDavpX++G/vvxz//buhHxGvbSNNa
		AAU4QAIWUIAANKC1yKc+BjbQgQ88EvveN0EKfm9rXJPe/XCwQQ520IMf5CD9upZAEk6pSSVEofVa
		UkDSLBCCL4RhDGUIGQlW0IbvS4ELnCc9D27Bhz8EYhBVkIMteLAeJOhGBC4xPa+5RgwPUc3u5IIc
		1ggDWGq7/0JL+hCYkuBhA1z4lJKq2DYmiSGLtCsNGltygwKcBidRvIJoCDNDOtbRji+s4Q31aDz5
		iWCHiOBgELewB0IW0pB7kIIMBDEKFUhBEydQQSVmUY9Z0IIW88CBJrQBC1TwIQXviMA0UgCJwpWn
		NjyJwwd2RgYugMkiSzCIOtR1jA3QQiINCYQShGEBo7QED9ywyqFaggx1JCwQ7jIGjLKoBGac5Cs+
		kUhLkKIUZpyuD3OoCzPfocu75IUWGXLFCkCWvWNygwvDQEfP3BKHFSghEB9YASXWIx28mMQVFpiD
		C++4T372s2l53GNAqdY1ETxvg0A8ZEINmQN/8EAKleCBDP944I9K+EMTeZCBDCqhiVloAhza6IQN
		qICOS0SgDOqJ0SKQoxdmtKcln9oQM+ZQsAMdAw8oAk7EIDGhW7xDTxVTBLDupYRPzWdDRlFXSyCx
		Iv745zrw0RCHEnQLwt2iD9qxwIuOwQxk/GZet7DpHKD6S/xY4x2KiBGwwMCyNGUVOMeA67ryo09/
		1tWudw0SQAW61xNipGvd0MZBfXjIdRTWsIc97ChkMAoeRHQdEk1EYyHKg0pUQgpbOIEmLlAGVCAC
		FVw4RQpQMTOjeHEFsSLPFUo2sRVYQxE/gY8x4MMMSNShDlcQEzdIkxIXhExz6mCGIghCBjsx46fy
		KoCYBNX/GztVak2iugHhyoQHOalLVO9ghhLuVR6BsQQMXF2VjAJxXS7MxhiqosQx0pMwk1BkJnTF
		a3zlO9/J6JWv93WNbbqGg8DiYJCEROwaBDxgAgsYFJWQKA8YK4OGbkKyjdWEFPwxisyuwgiowAEq
		TmGDWnjrBlkUxszIAFUuuIBjKxBTHW7EjBvgwQUWQEkcSGSMGM0ni5AI6hyOsQg8oGNex7BAUckT
		FzDMQaUNMxQloMqMlGFMT30IcruY4bKficEa6ChQi6wxHvKkqw8hAk/GPEY49Vy5FpDog7psUJA6
		rAC+9IVznOFsX/zWGTX6TYH9+PvfPRi2wOQAdKABTeAE/8BhDQlIgAxQwANEIxoUjwbFOlRASBXU
		w9I4gAUi/JiCV2SxJXW7m+gAJ5csUmIipcYbqDMHO0o4zgV+e/VsCEW4wSUOI72cBuIady3QkSZ3
		pqvdp+cFuz70zdeSC9yqbU23wl2kbbPZXKHmKGdqV5u+dLZztkvzV/ttYdIAHnCgGz1ucpc7AdWo
		hqADPWDDFtKH93uetW6oQm2n5s3Wxne+Y4jtetuZ290Y5KQLK2BykPsI2bgDBmAAAz/4QR4BgHjE
		5SGPhh/iEHdgwBEkQW4Cr8PdG4xeCkU+cpKXHCP31nfKVY4+fvf7vv/2ISkSsQ6CA1oSnBBCOxwe
		cZ733P/nPKd4O4QgCaI3WsCFJWQRcQA9kzfd6U+nEspXPnWqR63lLt8rtwe7jhmsweacuAMMHi5x
		P8DgEBi4QzY4sfFGH4EBCMfAIRg+9ojDYOhEH/QaPr70eEPd738nudSrPnjCI+vqWN+j1gdZ2BkA
		mhMY8IPEYYCBbGic7eMWtLkTcHCF090PGOCE0fW+Bx+CHBGAR33qDSj4wrfe9VITDeKxzrVuL34d
		5KiGJDAwdnkcQgicsDzRJaHuAns984gWviSEAIOI++EOR0C0gJO+Bfv1XfXXxz5uWP967nd/M4eX
		fQW1DmBAe4L5AZAHBjJ+BPYLP+/Fh3/NyUF09rt99xD/hwEDou9x0ps++///v+3zvgEkwMgAv/Cb
		INoDuMXzumyIvAA4hPWrP/cjB3ZDrAsssEaThPpzu3Z4OHnQvwRAunezPgA0QcATwAJUwRU8jANE
		QPdRQB8qLHI4gsjzg9/jBOCbwOGrwAtsNwALMOOjP/bLQZzDP07oQULyvxNkQr9LQRaEwgF0wRf0
		nhjss9vDAPTDwSLchlYgBh5cg7UzrGowJE/ogR4YvT2wA0mYQZurvyLEuYe7gwSQvv5juibEQ5N7
		wijkQ9ebQipMHtrzryskh8g7BDjMQXHghG2QBQbYBkkQhx6wA2IABS9MgD1Yg1Z4tHWoAWJIAHFg
		RHTb/wZO6AEvPAJEPIQAgAE6HL0iusM8hMUU2sM+pMWq+0NAPB5BZEBygDhPQEROUIZWUAZZkAVi
		OENjHARIrIYe6LNI9IQEUIZqIAZPIAZl4AQvbAVOEAdiOEU4FAL0Q7QR5LvTi8VyJKFZrMV0TLlb
		xMWr0cU+8zqI64FfVMRWKMZWsEdZ6IF1SABm3AZM3IZAY8YeIEY0VIYzZABu/MVvlIdw9DhXLEFz
		lMgAQkd1tMhqY8d2rJp3nMHIa4dfDMZWYIAe2AZG7AFjPIJ9ZMZ1iMQekIR9JAZi2AZPWAOEFIdt
		7MYiTMVVrEOIJMeJBEoFmraLJMrXy0iNlBYrnMEslP+HLSzCjBM+ARNBckC6QloDQAAExGLFMEwA
		TmCAX7yDiZvDnhzHoDTLqBvKolTLwTtKpISWGNyCGTwC5nM+OGSAu7xLROTAveTLnPRKvMzJOzjC
		JNyDJTzLw7SNilzLxfSntnRLZ4FLeCSHbDi/CNTL9ru8RlO3giu3DSTCHGS/bDiEh/ODEBxB6otI
		xDxLxWTM1rQjx3zMJxk/TDy0Cjg/eWiHyttBHqzA+PszQRvCDhy7Q9y/pDNM1TxM1nTN5dy32IvN
		xMuzBSTEajiCO3hAeYCBOwA+4dPMzdzMcUs+sDu/AHA+6GPF6au+n0TO1UxL5nTP+YLN52wSxYPH
		GUD/tMd7QPSDAaFbO+7UPA0UPgYQgkPIT/IEPbzrSaVLzfUESuV8zwdNn/iUTyZRQOnkukDbwAEt
		UPJcuHbAACHIhq+kv7e7gztoB4bbOYnzPQqsw/4rSwZNzvaE0BnlJwmd0NiAubicOfnbwGzovJ8D
		0p/DTspLvryrSgVdUBiVSAel0Sb9HRu9UdiAuT1QAT/zunJjgISTu4abOLpDv4Yzuw9lAP8UvTXg
		PxcNOSVlTx5x0jalIyiN0teAuW8bOPnjzP8kN3HL0/czU3dD0v5R0wAqDQBkUjc11GWB0zhtDa/p
		Nm3gMyslMO8UNECIAnIYhUvl06P7QdJ7N/vxGipK/426+DRPgxYxIo2ZopolCCPS8IvWEAZSFYO9
		AYMlIKPWKNRDxVVjSVRFZQ1GBSz/4rMrhFTf5IELAITK8gdQkKhRAIVNAAUpcCQeuIZrGIUtGIUJ
		8AEimAAnEAa0WYIPGAYLQAaMEIMPgwR4EIYPUAtkuAKNcAGKgYc42IiBEQN5nQgLKBznKIBjEAOW
		qQMlsIB2AgN4gKcVuAJ9TY+CKLUVMAuD2ADxKACGBRqI0BB46IM+eAl4INhaMFh8kjGdgB1IWAUX
		CJhhcIVjmANuSQol4AYY24l3oIQlcNmvkNFctdny2VVeTQ35ob3++qGE8sELzKjGoizJkiiNQjCJ
		yv+BevCBBvABHziFCAAtLqiFAjAGWgkEfNKQG4EEG0CGC7EALuAG5lCEiLGABGGJDXAFMlgEPnkQ
		qwgYeFCHOLAGZKiDlkUGuyGDolmquEUHYbAP+LgCAEGHWtgPZFiE+1iCOuACuDqKRTAaa2gRBbEG
		FfmmJaAFjEiJVZAJVbGAJZgJVbkBo1kY/QAmGAGvW73Z1c0r59TZCcKzggIkwQpWhTIkULgABpOs
		SgCExvKH35WBa9AETeqGMkCHE/CBFLAGLjADZKiF7uCCD3Oz1KqtnoErk/mNNYEHdBADdHDcgy0A
		dVgTs1ACPOgDuFoVO6EuLuAlMLiCnLGR842R8i3/AKqahl3Bg/L1meWiiO01iuooto2oCGQ4hj6A
		KdUKHDD4VxSblRWIg1nxkkOBEEUYBlXJlXeoYNVl3Q3+jJx93Z31Kz+Cng4SJNvdAwXbglmYsAjz
		BxnIAR5IBh44AW1ABR/Qhm4gAhsIhQjwgUBYF3TIEEpYhcWtA6O4ATLY2xtIJl7KkxgRhqtSAi6A
		BD05WIpQlzhQqTi4BRdzC2ZglxezBjoJERfQYi7eCSVzXxiDMfVgsjPrg2qiKvJQBKM5BjWpBUVo
		JpB5DuBqm5xAB/pgXCmGkMZtMma4BWaAl0YZmYLQYA52ZM3w4A9WjRz6oxEmYUECIkuLuS2ohy3Q
		/4YcANZ3EwEieJ4J6ASuQZsCmIZe6g4wmIbTsY1X7o5Wq41hS+BhmzUwGDZPM4bTueVng+XbmBtC
		qZbA4RzbWAIoUgJjMIaDGB1anhtKuIJUttpSwxy82JuLlYu9GeZlbgljaORHFufK6APXleQKQpuu
		ySA9A6F2bmf+ceb/ua/aiJbsYRJ6e5LB6INx5udl6QNjANVzpqD48St1ph/9QWh4E6ERCtSGTq5e
		7ueIRha+EGgbyho8mx/+kR7qqZ5yHFSTQyCJXA+JJuliiaOKrqCLthaOToHaiINX4KLcEAZ20S2+
		CejUWA/SiANSnQNZzS+MCJptYo0tio05cIGfgsONObDnJnleYIOjkobqItmcj8knjbXqq8bqrNbq
		rebqrvbqrwbrsBbrsSbrsjbrs0brtFbrtfbqOSCIK9jnqJbrINkcZkbiu8brvNbrvebrvvbrvwbs
		wBbswSbswjbsw0bsxFbsxWZswGZmuJ7ryBaSPhiGyrbsy8bszNbszebszvbszwbt0Bbt0Sbt0jbt
		00bt1Fbt1fbsuJbs14bt2Jbt2abt2rbt28bt3Nbt3ebt3vbt3wbu4Bbu4Sbu4jbu4z6MgAAAOw==
		"""
		
	img_dict["ncbi_b2"] = """
		R0lGODlhvAKQAfcAAAAAAP//ALnOrKmpaGSPWiY3uv8AAPj4/yFEaebx7/b2z0im3avb9EJCQlqE
		rgAA//n5ssXAw93dl7W12CFZlGZm5O7u7r29hZ2dq6Wm0OjRuCUlJZycceLd3ebm5jac8u7uJefn
		0D09/RkZAMTE242mv6PO3sukpIimxv3sAWNGRnt7e97f7a2EhIeHmXKVvPj4LK2trYiI/CEAAPzn
		5T09xczMzMzM/5SU/XNzc/Xlv6WlpaWl/EFql7W1797e3naNitW0tOv54m5ISEwuLmtra+fn9dfX
		5f7397Ccm5WU51paWh0d/cXF/6Wl7BkAANDQkX5+s729vc/Q5oiI5ISEhE9PxCkpAPTe3d7e1sbG
		jLV/Y+/v93FxUKOjmlJSUv//3kSj6Hp74JJubdbW1pSty9nHxmmMscXF8evludPTwv//75eX3bTE
		2Ku/2G1tormQiy1OY5mZmf3v78bDtTMzM1RUhFJSKcyZmWy234CAdwwMAP////7+vXRz4LW1tahq
		SvrW1pmZzDNmmbKype3tqEpKSlZW+P//Ojme5rm5/97e/7zV6KurieHiwfX22dbW/729yxkZGTwf
		H8/P2L6+rWZmZszCp1Sr9tPUsuK9vU97q+flmcDB2WSLtNOurYhjY7+/5r2+3d/Fzs7O9JiYxZmZ
		Zv//97TNvlet0ebm/4aIwD9zn62t2/Xqxvf390p2pQsL/9fX815eOShdlff34f//5sjW2ysCADMz
		/3t7/7rr9p94evjHyT0pKf//a3lWVsvYz+zGx5yc5WZm/36bubGxmHNz/4mJaDtroPbx9PTOz52c
		jIHB3LCLi///zJSUlK2s7aurud7dspmZ/9/rzmZm997e9/Hv1IyMjGZmma6td///xSEhADMzAHNz
		+Nalo3t7+O/v/66xrv//sytinL2975m3zY+PdmRkrBAQEL2UlMXTwx9Mienp3ZGQgl43N62t/IKC
		Tnh4Y9PTpcXFxUlJ92JgRb++l///M///1r/O33trNd20tvzk3P///yH/C1hNUCBEYXRhWE1QPD94
		cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1w
		bWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNC4x
		LWMwMzQgNDYuMjcyOTc2LCBTYXQgSmFuIDI3IDIwMDcgMjI6Mzc6MzcgICAgICAgICI+CiAgIDxy
		ZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4
		LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHht
		bG5zOnhhcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx4YXA6Q3Jl
		YXRvclRvb2w+QWRvYmUgRmlyZXdvcmtzIENTMzwveGFwOkNyZWF0b3JUb29sPgogICAgICAgICA8
		eGFwOkNyZWF0ZURhdGU+MjAxMS0wOC0wNlQwMjoxMTo0Nlo8L3hhcDpDcmVhdGVEYXRlPgogICAg
		ICAgICA8eGFwOk1vZGlmeURhdGU+MjAxMS0wOC0wNlQwMjoyMzo0M1o8L3hhcDpNb2RpZnlEYXRl
		PgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJv
		dXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZGM9Imh0dHA6Ly9wdXJsLm9yZy9kYy9lbGVtZW50cy8x
		LjEvIj4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9naWY8L2RjOmZvcm1hdD4KICAgICAgPC9y
		ZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAg
		ICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4B//79/Pv6+fj39vX08/Lx8O/u7ezr6uno5+bl5OPi
		4eDf3t3c29rZ2NfW1dTT0tHQz87NzMvKycjHxsXEw8LBwL++vby7urm4t7a1tLOysbCvrq2sq6qp
		qKempaSjoqGgn56dnJuamZiXlpWUk5KRkI+OjYyLiomIh4aFhIOCgYB/fn18e3p5eHd2dXRzcnFw
		b25tbGtqaWhnZmVkY2JhYF9eXVxbWllYV1ZVVFNSUVBPTk1MS0pJSEdGRURDQkFAPz49PAA6OTg3
		NjU0MzIxMC8uLSwrKikoJyYlJCMiISAfHh0cGxoZGBcWFRQTEhEQDw4NDAsKCQgHBgUEAwIBAAAh
		+QQBBwD/ACwAAAAAvAKQAQAI/wD/CRxIsKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBD
		ihxJsqTJkyhTqlzJsqXLlzBjypxJs6bNmzhz6tzJs6fPn0CDCh1KtKjRo0iTKl3KtKnTp1CjSp1K
		tarVq1izat3KtavXr2DDih1LtqzZs2jTql3Ltq3bt3Djyp1Lt67du3jz6t3Lt6/fv4ADCx5MuLDh
		w4gTK17MuLHjx5AjS55MubLly4MtaLbwb7MHD5s3Yx5NunRRCzuK7JCieYclS3I+e9jhmgxn07hz
		645pYfaKH6DJkPnxx9If2R4sUbq9u7nz5yB7e/kN+vMPMqp/aP9hyYYH6ODDi/+XKJ26Zg/Xcwzf
		3h30+Pfw43f+MR34eeJS1mtvz1y+//+4WUCfeZrJ8ZoU23HnXX8ANujgZALWB1pvP9RjSRH68ffg
		hhw6FiGB6JExjiUJatjhiSgS9iFw1WlXTxElLpjijDTyteJnvaG3QwzWKehejWyFJuSQRBZp5JFI
		Jqnkkkw26eSTUEYp5ZRUVmnllViKdlB52nlQhGpy7ICcjwwCSRaF1wmn5ppstunmm3DGKeecdNZp
		55145qnnnnz26eefgAbaZ5cMcomjcJp1lmN3ZZopVm9k2FCPFJRWaumlmGaq6aacdurpp6CGKuqo
		pJZq6qmopqrqqqyiWo8NZPz/KFBvO6yAY5nnWWKbo2d5QAYfwAYr7LDEFmvsscgmq+yyzDbr7LPQ
		RivttNRWa+212GbLR6wFoYbhD43+I5yu4fLq1Q82aKvuuuy26+678MYr77zO2vCDQb5yi5B2ZJhr
		loD10CvwwAQXbPDBCNNbD7j+6mUBGVIIi8ImDlRc8SYUF3MOChZ37PHHIIcs8sgsJGzyySinrLKy
		+ZXbMFwPRxysA+3QYjMFFDhwzhFc8HFEzTYHLfTQRBdt9NFDU3DEykw37fTT77b8Ml4xC+sJBYMM
		QosnSwfLRRu0ZF1O1mSXbfbZaKetNtm0lAz123DHLbexUk9tV9XBXq31JsAe/1GGJ5uwkszYDmxS
		zthrJ6544m3P7fjjkKdct9104Q2s3hScwUcZOFNg8+HlJHNGGbBgvfjpqGvtduSst+66u5NTLpfl
		fOg9SDJHuEEB4mbT4sAUL4Sd+vBqN/768a7/Mc7y4/yxLGjI/vFrssozv/z0yP6gbuyywwyx1aaH
		7kYZg6PdDgp8bCI88eyzvTry8M/9CgD0179BusdSsoH2xioDQBHJskD9BpiDZC0BgNriXvfcQjvb
		DaIcW3uB4YY2CK7VznTta5/x4sdBuM1vCTYIITQkoQ4LHKsKAECW/wqoQgCAMIQh9ECyAFCF7e1q
		gXFpIAazhrNkwMIBL0DBOf/24bZ9lK99oONd1my2tg128IlNmx8LgSUHAJiQDz9gHrB+sAQA7AB7
		f3AesPy3Aj4oj3/DIqOxxvGZ5fEvBgD4gvNEZMYYHABYZwTWK6rHPOwFS4E4XIsO2ea7nfVsWCwo
		xuHUtsiyKZEWyaiYI3/IivU1convg6ImUSbFYHFxA8rgwwoGWAdR1g+AP6gD/TbwK/8ZQpX0kwOx
		1EgsARpCEvXbwQEGyIccuBAAkngFGTZQvzIKcIAAmOIfbxhIBn4vb6ajxSb2IaxXGOEIbeDYIHaX
		tnI44AgoiGYxjsAK0AnRDUdIwNXGWQY3cAEFtAjdEc6xPidu8p4Ie4U61LH/gX7Sz4TQAMAKQugF
		AGTDApYAgBRkSMJX4dIC+hRoCDegjlAKSxn77KdGQ2kBddBQUhsIpg0AoBw+oFAS9YCoOlBqAxTK
		EoZkaIAXiQXIZqJlkOWARc+McI4XOAAWg4NkOXaINlpMgQ8OwBoFXmAE0LnhBUMdhBuu9gIuDNUN
		BwgqCzjnPnx6NZ8rbYBYZYpK7EnhfyYFwCv4UEX+WcAQUtjlEoKFwisGC6MbGGsDDLFWAVqCrmrl
		Aw2BNUoZ8iEbVgyWJdSxVsICABrFqqlN//XMyynVE3xow1CFdjhYFCN460MbClhghAeWwxP7wBkK
		jrC7wyUjGVtjwTZfkIAl/+4Dnl39qm4H1slgBbSGFihCSOlXxrqa0qJ3FWiwRmnXMQ62ls815Svm
		V0bpAsuXGqUoACxahMfSjZmTVcsgszaFNnDTbIdDwT4qqTYU6DS1mduHzfZxDqLG9rVTxZpRcYvJ
		3fp3XvNDYLCS6QES7rUeyUyrCUfZ2OROkblpVC50qytd6jrWor6UQgQ2HCtgdRey33VZeB9V2QuK
		TarkUyLZ2nEOFhzxbOcYBN9Q0A6d2Wyr9vUEF8pwDiOg4HD7rWcm/0tkdfV2izRE7BU9kGAUAmsH
		AMAfGeoA2QQ7trl8oOWwBEhhBs+vhscFVkF3ECwP/OEV3SXzsSQ7YhLLzP+yZIOgJyQoNggy0Q0m
		RlsbSveC2rECnm0zb+88wQI5b85zU+Cv6orM6HXNzxAxiHQMPGrm/8XAl4Md5Rf5QMwdefRXVjYl
		lv33BUlLOssSrnAcnTdK5BIzBzHoriUK2gApSNqPwGJzm8EyXrYNAhZZg8UmPFEMNySAD1yAhYrJ
		tg/DUeAcr3gBVJ/9imREU86y3SYRPXdbITf629iK6AAlkQ1gdZF+VahDA14BR7RagJjAhOyRIXzR
		PSCTftMNtS+nC8swA8sDhqjfF14xSmRSeJki3rVXen02WtzijsFqdmjjzIojKHuobeBDMWwGi1cc
		QX1buxqhh0qBfeiOAon/xqA9wc1yaEUKhjZo7suzXA8kbMs7YwyhXXH+bxvYfFiUgDkMgcVzPngA
		fxYIodHxJyw19VzohhWWrhXeFYabjQIlM8JtQZ423x3AAesDZ9h8d2wjaN3a6DsHsd1QzkF8zdtz
		Q4Lc5073utv97njPu973zve++/3vgA+84AdPd8mBl+pjsbrZMAZbJq6NFQ5gRdmSIfkliq4MZWDv
		D0tQhheQLZKbKFvbTkH60pv+9KhPvepXj/pjEf71sI+97GdP+9r7PWFTR7xWFC96xy9u4kX1vdaE
		n7YfsP74yE8+8vU+h+Y7//nQj770p0/96lv/+tjPvva3z/3ua1/vB8u9/+6x0sDQvfb86E+/+tdP
		eVa4//3wj7/85x//BKzh/vjPv/73z//++3//qGd33jeABFiABniACJiA22d3BiN+42cVtKMNCDCB
		FFiBFniBGBgHGriBHNiBHviBICgHhDCCJFiCJniCKJiCKriCKJgELviCMBiDMjiDNFiDNniDOJiD
		OriDPNiDPviDM0gbtGFqRFiERniESGiEDviAVEE7sHRvUBiF9bMHVFiFVTgCWJiFWriFXNiFXviF
		YBiGYriFVmiFT3CGaJiGariGbNiGbviGcBiHcjiHdFiHdniHePiGUriHfNiH97aETCgVtCNTfsiH
		ZbgHY5iIiriIjNiIef/4BDPwiJI4iZRYiZZYiZEoh4W4iZxIP4AYiFAxiJ0IhYf4hd1wit6ADlcw
		C7PQBSPQDRyADN7wit1wD7Nwit0wD7i4i7zYiI2Ii2MIiTMwjMRYjMY4A7wACvBAjCpABDMwBEMw
		A2PgC8U4BM54jNiYjdq4jdy4jcAAD/BAjcWoApNgjLgADL6ACzMADOXYje74jvB4jLiQjNc4jJMA
		DGhIBJKAhqPYj1L4iaDoFKLoj/RThlvIi7vYBegwC/dwD8hwiqqIDt2ADOjAAejgDY1wB40gi77Q
		CPeADg2JDnfAAV2AkCZ5kiiZkiaphfE4jLjgDNAIjiowBM5wj+vgC0H/4AtDMAaToALrUI8tGZRC
		aYyg4AzfqALkCI2gQATAwJPAAAw+OQQ9uQ73OAbqOJRYGY+T0AJQCQzQCI0/yQs9SQRGqQ5PQJBo
		6YmHF5C7V2KESJBWqIW7eAV0WZdXgA/IsA1d0AXIQJcccAfy4Asc4JENiQ/3IA9dUJh8OQvGwAGz
		gAz3YJeSOZmUWZmWKZkmiQuauZlXqY240ALL+JReOQTfyAumCQ/OwAtM+Y1Z2Zot+Y39AA9POQRL
		yQvwsA4tsJoqMJtPeZst0I6uGZzYuJXLCAq7CZW0CZNe+ZS+cIZpSZAAyZZLMZD+GJdYiIuWeQd3
		cAV30AV3EJlXYAp9/zmS3ikPyPCXyCCL5/mY2okMd+Celxmf8jmfdImLnHmf+MmZKuCSY2CNPEkE
		4AgPkwAPoIAL8CCWwpmg2iigUnmguDCTAkqgDwoMuAAKDcoLBlqgCrqhMzCgmsmgQ1Chk7CURFCi
		AsqPzzmK0SmdSUGd/WidryiZ3jCjNOoN9HmjOJqjk1mjPEqZuGAAQBqkQjqkRFqkRnqkSJqkSrqk
		TNqkTvqkUBqlRjqMaZiiKrqWLAqBbgmXV3id3ZACARCmYjqmZFqmZnqmaJqmarqmaZoCbmqXPyql
		cjqndFqndnqneHqkVFqlVrqJK5qlRkE7tpaESUiCxnCoiMqmirqojP/aqIrqpilwARcAB5QKpJQK
		B86QqZq6qZzaqZ76qaAaqqI6qqRaqp5KqS2Qqqq6qqzaqq7aqpeKqq86q7TqqpdqqXAQg0NIqLza
		q5L2p4BKFLSTL33iCMZqrNMQpgKwrMzarM76rNAardI6rdRardKKD26KqMaQBEAKDt4KDp8QruIa
		BORarv1wruiaruq6ruzaru76rvAar/LarifgDOuAB/iar/q6r/zar/q6DuuArgDrrwRbsHgAsAjb
		AngQrkBarppgBhBrBoJSJ8AarEJBOwnyckIHUxobQmrwsWqQCSIrsmF6rCbrCNWQsiq7sizbsi77
		sjAbszL7sic7DW7/OrLkCqTrAK7i6q3i+rOfIAyBMLREW7RGe7RIm7RKu7RM27ROi7TO0A9PO7VG
		C7CfcAJwQLVNuwy90LVd2w8t4K1AOq7kumEbe7Zom7ZqawMVa7FAQTv1UAVymx8wp7FkEEYdC7Ih
		O7L0EKbP8LeA+7f6MLj6AAaGe7iIm7iKu7iM27iO27iEqw+B+7d90AduqgM6oAGaq7NwMAae2wIA
		CwdAG65Cq7Wme7qom7qBsAzOoAnL8LqvKwzCALu0W7u2e7vLEAgnsA5XiwerS7uaILS1+7uzi7tc
		K7vIqwlhCw7dGq7larZrG73SC3Nt67Y+QTtk8BoxsAL5oSbSsx5f/wANR2cDWZAFH2u+auAI00AP
		fRsAz2AKafAMWqAFkXu4zMC42IANmWC/j9u//uu/kRu4faADbpoGmru5BnCvpNkCYwAOtomunxAE
		pKu6FFzBFky0rOu6shsIXDkGvCC8uXu7Qzu7I4y8yLsMu3u167AMybuToHACrzvCQTC0J9APIRy7
		tCsMmrDDmgC2YmsAPPu8ETC9RBy91Wu9PEE7FgAN4mshZJANXiAFdSAHUlAFNiAHOSAHkQLFWVAJ
		6FAJmcABl7C+YcoN8mAKzyCp06AP0wAG+NAIjoAObtwI2DDHj0CRjuDGxoAMc1zH//vHgBy5kvsM
		A+ymB6wBmmCp/f8wBgqLB5QKDP3AC87wCZMctBd8yZhMtRmMvIEwBifQyetwAuHKC6IsDEH7CWC7
		widAyixswrObwrvbyqY8BkM7BhLMC5+wDvAQBCdwAsKwyuHquqicqjy8wz7MvEAMrkI8xEXczBt7
		xEisE8OaDdkwLn+QDeG7BDEgBysAG+ELDVKQDYbgBXqgB4SQmF1Axu7LAVAABfiADxygD+hwCWJs
		DMzgxfjwDpXADJfADP58z8xgDPNAB+iAl7Zw0Aid0Aq90Azd0A19uAH8twScAtMgDyXKC5YKDv0J
		Dy0wBLzgweAIB6JsyZlc0iZ9tKwbBDy8DP05Bi98my/s0s5QlMn/yMgnAAzrAAwnUMw7LAz4qsI6
		vMOfMAQMDApBgNPAkIyg4LkzvQ6gUJQsvdSe28PourzdqsxlC73OvNVsi6XR3BRKDA1yYAF/sAL1
		kA1LwM0/wM1FkA1jvQThvAReQAh6UAld8M6Z0L7vm8byQM9gwAHGQAcHHdDz4AUBLdjvQAiVcKiZ
		YAvvINBe8A4OPdmUXdkKDQYRPdHsQAfwMAR0oMi8AAfe6sGeOwah3A8TfNKqbdIpzcPC4Mmd/NFB
		AAqdzJVPacsefAIcrdNBja6aYLW7KwznqgknMAQACwq6zJVwYJqfwMgqwJUnwMhFPdU/a9XJHMFZ
		zcxc7czQ/NU3/0E7NvAFS5ANv5ENlrAEOTDeX7ACDYDFK3DN5z0PejAPxlCRHKDOe/0MXXAJjcAB
		86AG6OAF9qwGiU0HBO0FXqAGhk3g7/DfiV0J/xfhEh7hCW24gyvRbmrgGq6zeACNeNAPX1nTVkvS
		q13iF5zS6CoMT90CyA0KmgAKLP4JyG3a65CMTp2auwuwVP3bvLu7VN0PJwAKr2uaY4DjLh3dzlDk
		vKC8Q6C8ngsHqC2u1h3EWb3dXN3d3l0T4I3gcgAr9RDFy1MPzFMPMbADFeIFlUCCjpAJjUAP+O0K
		kfsImfAItqAGdFALtbAGdp7ndn5/7uAOeq4GfH7nE17oho5/Ff+O2RieAstKKX/A4amKB+DgDKla
		r6LLuyRu4pqeuqyL3eRary1Qwzt9AqFO3Lw8zKOusEEAsDU83MC9DppQrldbrr2ssMR9ArzMy6F+
		rq1O6eH6reAw5c5b5VbO3V6d5S1aYmkiHCEkJ81OBnqbviKr188wuIeL0GugfNq+7dx+evdnCxCt
		DwrgCjebCRuewMDOs6Ob2pve7qbb2r7Nw/3Qw/KursYs7/XeD8Lw6sLt2/FuzPP+78M93D9e1T9M
		tkGg1cVOxFiO7DKBsVyttyM7smEqsiAbDBiP8bew8Rzf8R7/8SAf8iI/8iS/8Rmf8XubCW7aCP/M
		DFed7t86uq7/a7w0X/M2f/M4n/M2v++hbrA+X7ChHq6gewI/X/T72gKijczDTuwLz/DH7vCBWmId
		W8QSP/GZEKZwPriPkL/5Oweb8QpfTyRgnyVWwvX56wqukAaGfMhACgowD+zrHvdyP/d0X/d2f/d4
		P7oHi7B83/d+//eAP9IqDPiEX/gIe6k7e/CevmHa3fTS2/BQ/xK0M12UX/mWf/nTheeaXwsK0Plh
		qg9vTMfYTgakh0WeVCy4ljCk9+3gPrgKUMAGjMB5Ovu0X/u2f/tL+rpYsPs00PvKoAyYH/zCP/yW
		D/mR3xK0My2rvwbgbuH68Pl9zd8hgNB6MF188AUm9ANfwAdg/69HynBwJrP8B43Z4l7AbI/76J/+
		6r/+Tzq0vU8DzTd39GL8x78SyS8t4h/un28Kg1vfdk4HAJGjShUPDeTwqfLlBzRoEX4MzMFH4kSK
		FS1exJjx4qlTa9bYsgUGzLNnKVKkSaPjkg4NmsYsgxlTZiCaNW3exJlT506ePX3+BBpU6FCigWQe
		vemPBo05TZE81RhVqkUpZCz8w5pV61auXb1+BRtW7FiyZc2eRZtW7Vq2bd2WtUBGylSpHD2GFKlP
		X4AA+rqgQ+eoEh06hPScGjdOTrZ62XbEyBFjRYy5EelexmzR7ke8+kqe1GFq1kqXRU2fRp1a9WrW
		QP0pZeoUav9m2hSrXn2bW/du3r19/wYePG3cubUrbsYLRi9ffchEgjFWSQ+hIh12jIP2QyG0cSv+
		/IkRg8wS4+WjIu+8N4AOehzwrdQwpvV8+vXt3w/6emnsOU9nm8fsNuEGJLBAAw9EMMGuiANQIuSe
		W64vfJ57hJl3siAkGzmUGYePDsdRZjEylMnGsQZPnAi9vNRLyRUXXYnvNRmxoBELGW/EMUcdd+Sx
		Rx9/BDJIIYckssgca7Txxv348+8/FKMSUEEpp6SySisRZLDBB1dkTi99RALJo1OeJLOujjjjcj0d
		1lwzxh2XhDNOOeeks04778QzTz335LNPOmWks6n+mixTqij/r0Q0UUUXZVSrLAHcUjn18kil0jwu
		zQMTTTfltFNPPwU1VFFH9RRTU/PgCyVV04jRT1dfhTVWWWel1U5BZfOvUEOtarRXX38FtrdHzVNR
		Ur4WaCbZVBJhNpEPnoX2WUyipbZaa6/FNlttP2h2AW8XSGUBvuih5xJzzUWmVnXXZbddd+u8Nd4m
		kdB1V9yCxTdffffNalg+PNgh4B0ssMiDPyxK7C688GmEr1RuSdaEcMOg+INm8vhg2oy35bhjj6ml
		OIxvwa00Fb6eUcAVRxyhwxh04oU5Zplnprlmm2/GOWedd+a5Z5znpbdeKHnlt2ijj7bS3z8AYBqA
		OjyoqI4N/yySpA6FRbrDG4dRqbQZE0zI4+s8GGAgj2QxuZgBE0Jmu22334Y7brndHrnkSvlK2ZFM
		MqnEZZ//BjxwwQcnvPBBgXZSaIwORbpxxx8XVq6KpABghx92AMChBur4YmkALLGgAUmgOaWOOgzx
		pZHn7rjDYXbETjbZREy4mJGxY489kbl35733tuu22+QAUnZl75bRWQNx5Zdnvnnnn4c+eumnp756
		6xFXfCrGIee+e+/H8pdyScaPCJo/LAFACql/aAAAaDYoSJJKNqjjuVm0DiAVrsPFfQHavTZb2C4m
		O98V0IB0+1bw7jY8BegtE8dL3vUkOEEKVtCCF5xg9gJEtP/vddCDHgwfAL5gCUMYwgKv+EIdAECG
		zfFhAw2YSB0asIY63AEvrHPYOUp2Mf+BDVkC/CGmRDYyIhbRiEdEYhKNqMAFKkABIZjGAwmBvDWM
		SYNXxGIWtbjFjGzvg18Eo9FCWIU/VAEANmjABuoBgB+YzoWSsMESLGA6GtowJDjMHxOVuEc+9tGP
		RWRiE58YxcKggyNcRGQiFblI83gxjI+EpK9C2DRLvMISexCdHFbwORuoAwBLUAYdawgSMMziCnyp
		hhNVqQBstNKVj3BHLGU5S1jGspazxGUudblLXurSla6sRjCDibcnqkENhTwkI5W5TGYy0pGRhGY0
		q+SvV/z/wJo/mAgZPOABMvCBDNjkpkQ60IE1hCAEpEzDNE4mAZKghCTP8JI+phFPesrTS/OsZz71
		uU9+7vOd/yQJMUNgTGRasZkHRWhCC/VMaTbUoQTyV3nO5BEInYwfF3jGBTD6T1c0Rx8p0wtIL4CP
		NHxUAab4aEf7uVKW6hOgLxUoQQlRhWQq1KY3xSldGPpQnvZUNxGtDUdUpB6+FNWoR0VqUpW6VKY2
		1alPdeJAjznTmubUqlfN6U59ulWungWotBHqmUgJhqeW1axnRStaoypTmhoUq2+FKzO1aiAL1HUr
		db0KXu/VVb5e6atB9cjVLtFRZDxjGrPQAgfoIQ98XMAV/+3BhynwMVnHuucC29DoNJAR2cm21LOe
		fSlAFUCPR2BDqoWhaVxVu1pFzhWiOyjCDqSQVwv8wBLbBNgOLMHBvvZWQX/NjFADy5nB6gMfesHH
		NKbBgQsoYBuKxYcCGsGBaTiXugqYrAI44B7pciATnwVveOmZiUc84rRUZW161atB1wrHAgBbwTbx
		6oEq3Ba3HrAEJfbqW/4WCLjB3cxdLoGN50gqngVGcIIVvGAGN9jBC65ngR+RiVpgwx3GjMBM17th
		DpOpvcF5rxdW8AMPvNcD4bGENXFrCRt4oL8v9q/kUBTW4dIhBA/GcY51vGMeg6EWFK7FhW2Q4Sp0
		2MhHrv/Nh4ET4hGT2AOXi0CKr2nbFu8XxlfezX8BHGA6YAMkxmjEjUPQiDCDgWGV6HGa1fxgkLS5
		FnSoRZCDMWQNI9nOd+4ib6VUWy/k4JvWhAYlpLDbKbO4xFhGNG+0jJmwCpUO7liDMYxBB2aEIDCZ
		YAbD1PCOSrTZ058GdahFPWpSl5rUb46zO8gw5HEUGc+vhrWSf8NnP1tTClKwwaD/bE1DWznRvx6O
		jJ/U6FM8eg168EgsmWGMEPwYHZXARi1MPW1qV3vaw/XIm9fw3lVHoNWwBvedZe0bWv85G6s+Hxl2
		3Wtgt3st/rImH+KNEQ/IQQ4Ho0g3J5KFC0Ma2VmYhxr/bLFpQqxBDVMMAbYVvnCGN9zhD4c4tmtR
		j1dwe8gxyMaJXqHv8rzCBpchQz3ogs2PX8TjfDi5RZRRcouAk2DefLlUyGBvkbe8Ij9QRrgnMm5h
		/aDP34xBEXKQgyJYIgd/uCa73b10s/grYHy4jgXkgM0/yAFqUM8ONKTwAznMtgGztXqr/2CBU7xD
		DRbIASG8EOcqVKIStfBCwSM+d7rX3eFhVQbFLR6B831HIjOfC9ehtoM/VLPr8rY61At/sB3I4RUG
		k8PLf1D1akJNm+OQghekoIwcyNabchB5PWJgAcIfgA9ohIYNRh8DORzAA5j3QgQkUg9D/GEFO5D9
		zGse/7p6KKMKPzghJfigeQ+sAOqOP74ylkDGuGhS3XJg+cw/LvqcV8ELNqiCDajfeOWvQBmN54ND
		6uGFmsdaz7/1ea1/oH0p6LYe664y0+UPPmFLJDF8iMEfsvGHCEiBjJb5g87Lvnrwv3HIgSyognqo
		h3Eoggggu1fIhiqAhg5Qg4GwCmiwPmUgtg3kwA70wA8EQQ98Bb3jpiGLAEnwM5T7jhWQAsZYQC8Y
		BzLwjhzwvz+wgXHIhhhYiKobPy8ogsaQCGjIgR6MAAjUpGzIAWiohyWIgGyQghmMgC+ohx2Ahhiw
		vCL4AUOYQtlqPIhIPW8qgvFowicMwI+jL2jwAC+4Pv8LyIZxuI6Zw47G+wPC84L90zrGWIJ68I4w
		/JcVqIcE/IIi5IPUg0Ap+AIbkIP82wEy8gJ7kwPCk8Iq4Dg84zlFSz8Ve7IfqAcpIzEqO7T5A0Wv
		cLqDSYyFIEBLgIaD8JBsQMR6sABoKII/gAY+MD78iwBtoogQ1MVd5MVebDSKGMGKK8EIiIAN4DgP
		gAZLaEGJAD2J+AIMjItsKEKG4Lod+Lgq/LhalAPhg4YdELlHPLETY73hk4IlwEAymEUIhAaCYUM+
		yDho6KZuBBjSE7l2zLiuM8cqIJh6s4EctMZXkAMv6Capk4MklIKpe4UqJD0cxL9yhEZ5K7JEVMVB
		LIL/KhgHZHRHnHtEZYCGFXBCwjuIQAO3SsyyNBwx+XovG7CvbfJEXwtFUPQXRJQ6G7CBV6iC8Ng4
		iQiYV7iObCg+ybCAFbAAG7gOSrg6nUM5Euy2E6w5zkO7MuImwrMBMqiCyrOKEXtF1gsPZJStV6jF
		hoBAynjCHSADgSS8JUBG/aumHzA+4GuIPvRKPrg3rpODmdO9f8mB4htEHKymfTS+iowBvrs9XLOB
		buw9rqsKeytMHLSAJVBL4OtDNiyjiTg3iWDLQXw/xYS+96rCIsu+kTy/BGEyEsMNvaqrbWIxl3zJ
		+Yso7Js+SQTIBPy7FaiCDcG+rCNLSVS3FvMQeyPF/66rN0c8SvUKxr2TAkPAptmrTQ/APjIwQgv4
		w8jzvxKrgh14hT8gEYKwgR84AHyrB+7EzhLBNeZkTjLYAcd4hQiwPgs4GPqyTj5QhsWDzwiEzvr8
		Tom4PdmLAA/4wx3IOfb8lxiwSSe0yYHZvAj8AQisAmVQz7HzP+mszleQiAKMz527OgC1gIFQhumM
		QP4UND6QguEUt9DEEvj6RK44zd1SzdVkukUzj/3kAyy0JtZDxz/QwwTMuQ0rzmHEOA16hR8F0iAV
		0iEl0iI10iNF0iRV0iVl0iZ10ieF0if9A6P0K9jSpq9QNxVl0S110fKAUUsImKFkPtPDPCPb0W77
		Nv+h+VHTZNM2ddM3hdM4ldM5pdM6tdM7xdM81VM3jYH3K7E9tdOw4CYS+wprIoMtRdQuNQ4YzQGa
		lFAyiAGCwD9847AzZTVX0xVhfDJ149RO9dRPBdVQFdVRJdVSNdVTRdVUVdVVZVVV9QIbpYRWVVUV
		W1FEtVWxUNTaYFRl4NXveAUviAGo65AOs1RvczUJBdKpiDmMEMZVI8Bbg9ZolVYpSAzMm9ZrxdZs
		1dZt5dZu9dZvBddwFddx3dZsANY/INdwrYepPNFbdVeyiChenUVlgJr7ezwQDVGJoFd9zVEPkFAY
		xcDq5MjalNCpNFOlZLUcyAbotIGj20cJ5QN2hFj/EjkIglGGmAvScKKNcUTKjl2mDug/KSDGCLCB
		DrjSd0VZXK0/iKyCIvAADXnCJShMOeC75UM6mCWDbMiOqsuOehBRcCvWP/iCBngMoyPLqrM6hW3B
		xEMj22OMgbCBPyiCbPiCbLCm8vPYrIWroWRJdXOI7UzZsP2KUeSDHKimHaBBKdg4tK06WlzbIsC+
		0VsC2JrSn4W1Yu2Og2jDH8g/MLWEAOSDPwSR+eQDS5DLj3OMCPDG8Jg8rXXct4q3ivsBSogASvjO
		WhXbDtIrrDjNP93cWVtZz/s9svQOnyXd+xtdMiiCf7m3ERsRGA1Ouz2yM6VcA5zFKoRU2/sBbXK1
		/x9gjIitggMosi/Mwcu5nD8gA0rlg6rDt2+yCNa7OsW4OsKrOkQEu9lCQ5TjzYkgPNZNPIqYt5Gb
		OqnY3sdVqN09gGqiSSkQNBLNXBCCLdnCrY5cgfjKLS2NnOKYCOzLBriVQBqkQZ2lwSV4xD+ExYVg
		xYDpWagZscIMD5SjCHq1SYilCH/FqhE8AGgAVprsDksYB2CF1MxrxIfgA0o4R+AV3sCVQCkQD7Ik
		vOTNtyXQt8ioiOuoBzSURRswPtlSN7RcgdZTiEecOu1QXjRKUNrM0YlQhpykC0lUXoz4W/O1KfTF
		r3O7RZJ83315rx04SZY011e9r/zC3GDT34nYXf8JPeOTS+Oh/Dvn9Kbk3M7wg5puTNAiqF8qHMSH
		qIJsMIS6vLUcGAeeTc6cwuDHsEHV+z3nTFaPg5qXK192/LuPC1JuK2OEkIgY0GBHDMhgRTlW1EEv
		wK/isMbLqbeyhbpg9TuWS0L2nAvzNON6+DoLiAFlmLyq6JCFgJosFLmBMZjJ+4FAvmQnlOLz7ab2
		m8p6aN8xzmLHGc1OFEh1c7InMzRyW9lCgdHTc8JbW4G47Ma5kLo+XcBtXgLIqGSbKuT8o8lIzVR/
		KTLZ6rzv+A6tmwjjkwOXNcD2O73rKIL8C1xoWIK54OejrMr92zo5cEOJsIQ+sy1LqIKhk4PaXNr/
		bsIv82S9hg1KoQM9yrAE2RtmhEJfyaXcZF7mMGpmayqC1PszllS6LKvmMoHRhc3QGFhEWrSBWNwB
		/nQM2+vRWPSCQcYpDH7EGEhnTCWTilvZIosI/yuREmlbb6JedwRmyxCIQePohpVQdK2IIrOBQ4xq
		ifiOg7itH9g6hyDGwry6jIuIx5hFMhLrybyOjvboEYmL9RXpkf4iPmsy5oRFSzi3Qos/RWtpMoFR
		7IPNVG7D2ORUKpScfvTPq9rR3RU9on4Soy7jP6i9wlyCWpyIxqjC06tNx/OCzxRWr5TQSC05gTi9
		S669QSy8hz7tlpVp2VoBDAxYqJW32utPgKTa/yUI7dSDhi+oAuGDa2bKOwU07nroACy2a2DB62i2
		Jt3q6aT7a5YuZ5eWXTwLRnpFU8lGEcrON3WTt2U149gimPWTCCZGOQl9uUmMt6vj1PNGuUH+M4n4
		uCmbMomIi24iA9PLyfu2in8ZbmZ6vLri1QM4gA113+VmZp/r4q7VLb9u19zIVdq4ZqTEW+7WuAnH
		v4kM8A7vOM/lVV5VbgXvleaWr0y0LQhX5qYL7Ce55sa7bmJFWGNd5xb38BuvlwEn8BAfcRJnFBMv
		MZb8AZfNxJX+KRs/ERiVyvG14IjV16OU0H6lYEKe8TQtE+/G8Sz3URDn8QT3cTFicBWbrW0iS//c
		asn8zR4YrcUSYz00rF+kG4hbQ0UMnDw5yA7HrnIMbxAstz/z+TufvuTxZV2wc8S6Mh9GRjzl7V66
		FNHwnQquA/SLKF8tTyQdt4AQR/AV/3J8aWYPKILYSr3OPXPArm7BZmB5a1RLIGfjc4y5qM7voIxx
		UHUaxPNmvdQaL+PxmGFO5l4bzI5XKIIQtcnsIw8U+qbOocUanQhKaIAjzoYkPm/0lgpJLHWKiGJK
		VyRLx/Qe33REGU350qZ7MbHUpOZqRxGAtQG0k4w/EEjPdMOX9cZxWMDuYPdIV6gLx/WsvuRU1ORE
		PO/fU1io8Ts0LOXlPZip2wFKUGUcPhhX/rv/CIjlWf7lqghWXL5t2QPlXkY6YIY6Ycb2SudyEffy
		bteXLT5Ju0LRidZ0uFhZZGSIdKcLTB7WivDZIFzOhfDPg2ltgvimnge0xrYqvF0BlrOISbyMi/SA
		W9N3d6beeNbfWoxLfsY8v5tUMPQCAJeIgUZXrjvowlVoS2Boh4ZoDRnIFINB6MuBi86BjKbqjwd5
		vNr2kSf5fCG9MAQ+r8hSuUcLf1k5ma0Koqx4QZ831jPFtAzcMPVYvM2BFXhVxCsONPLZw4uAxp+5
		o6TCoEROC/gC8qAIpAZRCWQI81FFdJzn5Q1WZaBNiMVq4+PniSgySjhEv7OMWwPrJxtrTUTm/zt3
		R1NWa4RAOilwa153ey3S9i5f+bn3FW462a4w1CVr6SJDMSm4Q6yOWEe+SX/NPq1zzLFL/CpfgY12
		whkUuSFnywAsx8aowZoLmHpYDP9EO6IeB0MYB8yW7MbIQdZlxfrVN52d54h8aIUHCD58Yhj6wwfa
		n1deqtgQmKNKkRg7dkhZAa3KxSoaG/4oWK/Kjldysn1ZshCaDWhfqlAS6PIlzJgyZ9KsafMmzpw6
		d+585cECUGVClUkhY+Ef0qRKlzJt6vQp1KhSp1KtavUq1qxat3LFaoGMFJlVBsaQw+fPHw8IZf6Q
		YilCNj7jxkHjE8HDQGjQLHjA6zKGXr8vf//8uNlwBzTBPF3+0DtOZsOZkfm8qveKLxkbEcblMLvj
		jyVo2fAqi/tFNJm4O+qlDstHTkNoMWxcBvmSDG4+PyywLbIDqI3ChGcO52MDr1/cZAS+olxYIOHn
		HKNTF/h1+XLnuqPr5q14Mfjw4seTL+8TqIWhRI12be/+Pfz48ufTj//VNcwcfHZwtsGfkjL6Udbc
		WTFYsEMMo8kxzlh38VEEYVUAxYcHyvBhiQ02yJGdMnhNWKFAFcYQg0AjxvCHhsgRyBsffLnUHIse
		ECgHSn/s4JKMFLboF18WZCNHPcxZhplm46ywRGN/ZKPMbi0WYUEVTP6wwmt/kOEBlXx4EUP/YxRd
		tkJci43jRXllmnnmTK+ouSabbbr5JpxxyjknnXXaCacyHfSFHlB/UOJBfYEKOiihhRr63n0yGUQJ
		GRbJ8YoNVWSXGx/KyFGFF6+QgekrBjloiRdbSlHPHxr9IOGB2RQRaRVSjPoHjT/EgNFKlFXxSpY/
		lZVYDitIcWoVEbilVxWyxrrfOBakVMQfsxbrxQ8//rqCRoZEK+RlHmS22QoJhhSpFxbyUYWVmFoQ
		1nEfPffKRcr+cFkMlqA5L7312qQmn/nquy+//fr7L8ABCyywttT1JStrPw28MMMNO/wwxBFLPDHF
		/h6aaE1jjedgDpRQsuWsZBVhKlp/hFXF/4mW7JBDqQLtEAFlVFL5w6oqF1ERH9m8nDNFJYO2QxFB
		7mAJpnzkgOt+E+2wwg4gBekjH1lWlu22DNZ7GVj2ar31vNl68INyYYs9Ntllm3022mmrvfbZEWT4
		doZe/FEPo2zbfTfeeeu9N999+/232YT9RCjGNIkrHsdA6ZygBwtqvB+pO3iQzTh/rPCHF5tqS3nM
		Bx1XhJGYbzquRGrtYMNsI14O7Wswd76CWpjPavKIHkQwltRDalvk42hijZ9c0Dxm3HMvIVa83Grp
		lRJKeuklxR8IQVr8fgY1lhhMxeXUGPWSfXcm1TbU4yr55Zt/Pvrpq78+++27/376Jvqs5P+WJsN/
		P/75678///37/z8A1VcPG1zpKIIqnL0clJGCnSok+CGgSKrgAbR0SRmUwJQHXDMadlVBDtqCxg6I
		wgcpRFBbJiQD2EBoIQIyxyCRCskKRAKNd13kB5SAFbaItJnegQ+BZECSQ0hkPBTNcD+/SpANluAB
		jSyRIUj6wRO/YBCXkKEB7wLT4ZijKZ0UC3gzscQU6dUhMvSgjGY8IxrTqMY1srGNbnwjHOMoxznS
		sY52vCMe86jHPfKxj2y80qAQWC8HhWdDNtEQ1wRCBrPMpIiU0V3VNNYXmRBoJ8r4HUw0Bhg5cLKT
		QnyFBJdgkObsYDlokUtYVsCXLJ1yMhb/mWBYyHAjRUqhAVI40FdiUBQSNQYvHQmLF/ryhx8M80Qu
		C5a9LPADG1CgHM50JgUowIpNPLOa1rwmNrOpzW1y85nR/GY3w2nNb0ZTnOY8JzrTqc51srOd7nwn
		PLcZnEBmLSaXjFEWX8IjvEikkhYgJHhYZBOBbo2gMRHo1HRoNS9kA2UhGogUbCC3A7RuHPXYp0so
		YpnMDM8lY6FIDj5TMmjgR2c5kMKNyFCXgRhkRHxYgkbkxVIdCeRW2TDZD+RgI4GAKgc/sATRctCZ
		DkrhR4WxgCV+4IVxwCYHFlhBEVYAJF2+JZk/qActBqHVQZTDAfswwhRYwdWtDoIW16QF/1qfmVWz
		krWtg0hGMsrh1rnSda7l8MQL8uqArNa1r8l4a1vvmtcX7LWvhj0sYhOr2MUytrGOfSxkIyvZw9Zj
		Nwesp0uGtRJidjIsp3QLuYBVESWOcAmz4ade+KKY631vJkFKpHgSursdGs1C9RgH0erxmRgUwRK8
		sUQOoEG0ovxoijqdDZjC5FGjnQUjzsMhH2R5StiRyThzqV7OBBImk2Uyul+wQeWYexZYvaIIX/tV
		BH4QgQhQwpFx0Q+C6hJa6H1UiF27D1+1SosjuAEWYvWEA54JCxSwghawKMZbi3GOYjigBGV4QTJQ
		EGC6nqPCnuCrM+MqV65qU6sZfuYZzv/ggBGLeMNlJSwFUKxha27iHPsoAyyqGeIRO6DEk70xjnOs
		4x3zuMeRLYoB6yPIEdUjBkW2wB9CKt/mlIVnBiGXayZiF7yYd0ofshDsRucigViIRRPSz5Zh2xNI
		8i66VciGbh+TjRHJLTKSc6nOmFYEgSwVSBbpqFwMMY6UwBQm9cjGmimzkEYVQQ4RUQgIX0EQtBTE
		aGOJzKIPQsKFROYhEZlIRS6SkY3opiAvjGBJvGCRlKxkMj0ES365mldafLMNxeArC/ZBAVjsAxbn
		8IQnyoACNzjgCKyYwhlSTdZzOPMcrEABCpLxAhR4IhllKMOxB1EMT5zDAWVoNrKVzez/ciSjBKxI
		RjuSAYsSmJgCxXgBBZhN7TMUoxwocLczB1GGZJxj3tz29iDCPW4T+7jf/v43wAPuYyBf1otGHhX0
		YkAJNNeDWSUyCAjDsmbXGPNTnNQlqZgYKjJ0KAfMikBoLuKBhxQrG9FakJjHHD7acqRbEmfz6QTi
		QSMfAISS88tSs6Epag1mOE2KyQ9y4AXevEI4mcmOcRRJHeEUJjkoZI52oPMDv0xn6c9RpnCYw3Sf
		W6i15PmdsCmwCRSUwQ37YEGwtYqCFw8C2WWgAFpf4IYXELsNE55rG8pQ6xeU4dbnhgVhz8B3eRfj
		3C+gRTH67gkUEJbb057CJo7ggHZv/zXFbVj7GcpQjgeX/cFZjTCDV52Mad8i8pPnt8BTr/rVs17g
		BA+UIMex3vXaaAdLuGhSBRLebGxKeFIw70w5hhuQjeW6KkVRB3NQuT+MQwohm8tEQjrnlOdEtpEc
		1/NisASSnghBTt2PVG1Q80jJIcqwumBnwIM56rPfPPglKy1ewAIW3OLFycgvgY/A+Gc3kwKecMMZ
		7MP/3Z1bnUO6bQLdFQMsOMCyvQBe8Z2zEVZeKVsZKCADlgEtdFuKGcGFkVvlTVs7nNu8lcEmuEEx
		tAEsfN6DecK0ZWAJmJsRBJgHth4N1qAN3uBivZ6QYZYWsYlx3FOWDEilUEhkcJwQJv/O5CCIgkQP
		UKBMDJSGF9zWbXHGIkUPgzBf+92E9ZWZcTTEgjQEm5BBc2gKi1jIMr3ImtTD+GQhG6Yc2MHfFLxb
		NG2CJ5BVGwwCLBhBtbGAJ7CCA+xaO7hBGdidsG3VC5QDK7xA26HAICyeA8jbu+WahD3itS1iI0rY
		vbHaIFDAIMxgWQGY/22CtQXYIR6eITobI77VC3IiJ3oiDr4iLMbi6ukgfQhSTXiBqeWEg1yKBKFQ
		A0GKqUQQ9BQMblhEpkwaNCBdG8bEFtLWSwSH+/HgMk7jfaFaWyEgK5RDM+0DCqDVJrQBK1BA5qXY
		FOzDucUhCsBCG1wYXWVVPFXT5IX/GLtRE1nFW4dtlVlZUzyGWDHQoyz+I0AGZI7R4nzY4rwA1Hjw
		EDXSRDNaDb1gkkvQxfBAI0wcT4jgx5VcD/M5D4kAhmDwh24ERvZ0j01wj2F4nZm8YT1ym1exwBQE
		GL+p1SBkI1zFGOoJHC3Q4YhtQiFGFi3QmAOkoEAOJVEWJWIRpHwYJJogpHjk00KmCZk5YzUCDxQ9
		Rw7Yl8sQUWHIwReESAP8gdvYQBGsyhLYANOsgBhSkRWBks7BhJrkYsa0xU2A0daoZFv95DkoYk+u
		JDaxXjmgFVvt2F+mlVEWpmEWJlLahzR6j7YknTLWhIMgxl58zWCI5FOORzMmSHdA/8cB/Fx4QORy
		7Qc0dJInMUeWaEzTuIbzNcdYRJALucQrnZIsUVEt3dJvkMGJUAIvjUanhYUHecA4/MA44KYQpWZd
		vp9dldNhLidzNqdz/hh7wN5i9lM9eMGNoOU4NAA0NEDzASf2TMRrJc0rOEiVqRJvNEmWVQFFMQZ2
		/YC48IaXGdQ0NuMfLIEFjOVvBVc27MV+yIFAyUEMaApJjdCJ6NwPTATPvcRHSUFI+cyACsRp5kzt
		CUQy1tRLeIEUCIZNNV9O7dSDeEEOeABQVYFQXUr5GVWLJJVONdVTRdVUuYXr2MvvwB1g1qiN3iiO
		5qiO7iiP9qiP/iiQBqmQDimRFv+pkR4pkiapki7pjiYmfAhSqcSAByyBFOjUloAoJUDImlnCwsGK
		FHRlc0npRV3Ixb1KQ3nADmxIaWhXmkbAQ8DKDD1EQ1nJfqJk+9HnEnRSc6yZqGmIknCGy1DEpixc
		BNyenqUptQBXd+lHqTgPQjDSIlmoXiwBlSCNhWZUGI2Ld9nAKQmIqzzKk7SFeqkXe7kXc8XXuAwT
		fSXNcYJFjckjrMaqrM4qrdaqrd4qruaqru4qr/aqr/4qsAarsA4rsRarsdqqkyLKYjZNYxTIUtGF
		plLOyxmEcjWNB4xpDuAGgD7fYxzfbCTcDhCTW6wMzswZQ6yZfLYhfa4EiriMrMT/xsoIj8wFCSjt
		R5PFhWwoFc78hZ7xGQ/9WaB1ml+4ylkMD0E8BmB8S4k0WvkphKQ4BESMQ5pmGkZohEa0REcgX0hc
		yhLkqUWkRqlpze90AMmWrMmeLMqmrMquLMu2rMu+LMzGrMzOLM3WrM3eLM7mrM7uLM+ubLK6hyAR
		xmfkgERFD4LAjnmBBImQy+nIlND6CZX1xeKYnE4lBpaAUoPQRbOsTqNETdR4wKzEKDWuK0iERJWU
		X86cyFe4jEVtSrSUCq68gs6khJH0nHCka9ANXaW4pxYJ4XYIR2T4BXdQRtTpxiQl3dJ9jV9IiW5o
		HYX0hS91mcjeB+BUruVeLuZm/67mbi7ndq7n5s3PtocgWcBoHoCjVIa2piku5sYtWaeAkG6m7CKg
		MZDOQAqgbaVB1MMMoa4KhYXvkq7ZPmVl9EVmjM843Mym8EakZOgIsQvvMQc0hIsNrNkr+C4fDFAG
		1QMj8cT6Xab3Ugblfq74ji/5lq/5ni/6dm7odoVSaur2yIGUwQRT1sREVNL36gQZqKH+DpBClglo
		3i8AV1/4pi8BF7ABHzACJzDfrC9XtK/93gTYyMT80gRJBvBAXRKbYMnVtK8FdzBzDLACh7D4Wh0J
		l7AJnzAKp7AKrzALt7ALvzAMxzAMM/BWcHCZRKZlxsTTeXBOKAyfTMkG82CCCP8RRRqPI0lZgvDF
		furFLIVKiWAPdPBngmSqQMClTVjnAx+UF/kOCIsNdZwN2Ijw2HgMGZexGZ8xGqexGq8xGSuHDQQQ
		HMexHM8xHddx+0TnDm7xQUatBiuTdRTGZxBuBfMwjugLEOOEQVlAFr8IAlVlEMGE3FCCHLRF+YXr
		ElDGElwQ921KyUxyECoDiUYXEMEEk6SrouiSneoGmAZxUYwNzTSAITSAB5nNaoQxbhyoeSUwG+8y
		L/eyGrfFlUCuMA8zMRezMR8zMiezMi8zMzezMz8zNEezNA8zDWuFLU7IZr6EH1vHZoYJf7hKW/wW
		J4XrmQ3TmUGP86GpThHyTPj/MHqcyjZnFEeoicWySD341jb7RIt0B2521378CGkCKHPcikO8Rl+Y
		hUWRjkGsgG7KEmWehfK57yRzWT3kgG+hBVGEq+QcgBMbzZwd6H6ALViwjkT1b0p28S0bAkrsQB1k
		KGH4YnRwJwMRhvgsHQGb8lOyAFjgNDv3tE/rRDVnhSClxgwxFSf5bmdJwRLMxUiMjtGAiiXoDG9k
		KxlYp8RRxLjUkkHArxWzszsDhQd8ASdlavmVhU6p9FcKBKWyCqksQbwuAbOARnd5gZuKFFo8qNe+
		hilBj0EkWTK+QtPIixz4lFCUCHhB64oWBiWACkWUxA40QD1QKUJ0C4VmjtxE/091ZoMt8Z5OyRQr
		k80vqYmerYAlQLYXNEADUMQGNEB6fUEDIEkMXE7HNgC0pC+L1B5Pu0RLwJa23NJP/zZwAzUe16I0
		vpAFuHVEQAO7AM3KjEmL/AHorJSfoNT18jHlQMt1N0ZZzMZtmTQhf7UiS4KcDZHKUKlZxMVuSGnM
		6YxBzNnREO32WiijOpdeQJeGKNq6UEtzSEEwwSapGISACMTcHIS8wNfwtJlEuGddxIXOIYiAE9OT
		xQBx3giAhkWAPyRKo9AXdEYO1AEZfAGG2MChfgEZGIJ/VoEl/BD8itIGFNUXXMf5Ep0lfCpeNIeF
		yC2XQUeOb01v53Zw//hPB/+1VyymBSwI7Ljn773xbxrThlBOmCgc9EzZa9yuQphclRfMCKXEIH+3
		vryCJKSFYizVkS9RzU0OSslSQ+iMZajnrVRB3fLrbEBDnz2jRpCIUg82hZrFTz2JbhSNJoercACV
		IuvHp+lGnjLLj9TDFyi6oi/NLEHVgRRLaiyBJdzeizfN7aXyZ2b4D3yBIVR6BLyCIUjBAcjBElxG
		QVCpMhiCISxBA4CRJYzDJdueMti2rbiMqlQORtRDAyDZaAIng7YKmuRUmnrHTgM5sie7kF9F0DYU
		bsaK6ZpZ+Z0SJ0m2gAtdWExwstcEeFuASg+o66xGms6QaURZhpyzkYGS3IL/crzYLYU4JYV0hoyA
		zXdICYwUT2MWtr0TbuNy2W6c57wr7m4gXWPSlIwUHWUWXaXAezS2shePerZ0RLJwpU+kuhSs+oaw
		xtDIukgsQa2jL4vAVLE0GZWgqmkxC/xeJ5p4QB0AwKlTyLFvu8wH+XAX5GIWx5VAHczrvBiqCRWx
		iLbPfEyA96lEsDJIjSIR3eP2bQT7/BgW3WwuhocK/ak5fNj8QANI6S1nvbZ8wQrkwBesuk9x5dKE
		imkZgkiEva1b6mukkqUwyAGA0YZEXF6Dz/b2ONXnfQcvu1XYcHkQkhc40k6o1I2EZwcTfRDye8Pr
		/XxyequE8ZSkl6x0bARY/0AMLPrIeT2SZcPtWACDwLj5Ep19sYZddBBReMD0/kZELQdW0gveMz7s
		XybfV4Xfk8cuFoUHbdllQAd8Fo+GkIGNSBDU5TN88r6Ot8i6FH82b7lOID4rxz4b/k7ZfE3YUD8K
		gfX10ztQoJDi4oa22LoFvz70jz8bzj5V1P7G4EUQkoHHgWVUHyigRU/5/R7nWwdMuQqGnPOwNBT8
		S0qoFAVAVMkmRYolaNmqkIkhBxoZL16k8JE4kWJFixI9WNC48ceKix9BXnxlgUzEiTGyxZBo44fF
		HdBa8vFgkg9LPi89HNixQ6JDij+yWbiZbZzFeiEvPnyF1AJNpE9BjixJhv9qVatXsWbVupVrV69Y
		c74SO5ZsWbNn0aZVK/bHDykeoMaVO5duXbt38ebVK1cKGQv/AAcWPJhwYcIkne69GAGuR4lSquzI
		Me6PlB1VJHrJsWNFjD+fJSrLwSfbDil/IpA2fVpKDMyeY+z4seNo5NOf/1jaUaRebDJ6M27U2LHi
		q6N1S06U6vTHkpg5VFKESEbObzlfMDaoJ0XOjyp/IO6gDn6isiqjm8ek+OqHUKh/YrxF+gO74qiI
		v+bXv59/f///v9qOoAEJLNDAAxFMUMEFGWzQwQchjFDCCSks0C/DMMywMMQq+iEGmA748AeddmAP
		mhgO+KGhV3Z6hYwT+eD/bgcb4JKjHg+riMGCbGyEL5sfbIDmuz9Mo84tLzCLbDsvVKQtBhtiQElF
		KeoZBxoim4QSyhhWAO+H3jDLKzjhvJvNynFeKUKOol78I0YvPNghhqX4eLGvBuSQiJLSbPCiojB3
		4BGaQaGRI7pXHAM0mxufLFGiyNysoi2J/lihqDC7C62eHCyx4DNPvXDoh1cekiiHIur0E07xpGCy
		JjnCtE8k/ACs1dZbcc1V11157dXXX4HVqq+/NCw2Qw4pisESMrKp1Fk5pOjojxz+aLaeP3L8UooV
		pFgCMjmUkUiObH7zYqC32gJqBwteaus3G7Lx4oCI6qHqlXE9ICPffNtK/+mVIEcdl6R99W1SGYCB
		E244aJCEZgU5IrAkyG3/KKJbGwKNAS4LVmCWS6E4tuELL5b4kw8vNt0Btz+goSlR0ojkSY4cfuOj
		O8r4qEIjiZ78w0qbuWuJDN1M+2KJHbTz9srOJIJGPIhYrifQBiIgV47cZP1ouWC57trrr8EOW+yx
		+xvW2LM3TI6icSJq1pI1ceZjCYY88ADGy+qemWU+VAw3678Bl0lhC1SM4YdxDh8nT5XfhikbcbPZ
		GLMdfubDgipYlMMQk0fDltCW83z1UT4GXaJlN1d4xXA+ouTDMUqPgsYSPkZTObM/MJZNGWhIy5nF
		6BAHLUcydpLZMz5QDf9cOVrJbt55XSl5XvrpqRf2QrSxBwzZiXbKeZx1yRgHZe8GtoHjtiiXFLow
		64FL+fcTVjjLGVVeos2gqPKIjCktXwEobCXCMTIswQvJ45khYrCnJcRqJVXIkUR+YAj3UYkMVYDG
		OCIwtxywKCH745slLOEBRNVkBY5qjhyKUC0bfaEeLPwCZ3jiuiKwS1LMWoIlltBCGuZQPYDbWvWA
		KL0QsKEVWaBEEbNAhiSSYQJUKCIllogVKgwjC1kgARWiCMUlbtGIVcwCEaMYRDFWz2zZw972evIb
		KbAoG5S4F7iAAi54/WB3XnBRab4kkfZl5key8uDJstFHqOjrfWPiSEL/CEYGls0JXjtQRkR2hKKV
		EOUVNInAzBbyk0l5wG8V8cDD4KKMUUlELDKp2Q8IKRPLhUuUo6STekS5sx/kpD21JNxEPBAT94mQ
		PbdUZSmV98MxDvNrIRADFSnBBjZUQAzNJAEb7OEHNoghA2GkCgmYGQIqVOAQVCCDGKY5gWWKgQxU
		8EMyxdCKTvjBHkUk5judV0Yzng2NgPuBF4QCLerULSYjgWAA++keCLpnNm56xbJe1JL2YESVltuY
		UHbpPsUYcjivs0/mqkAQu1gGfh31qDDhGVJeabOaJBDDFKmgTDaktBXgnIA1h8jNVviBBNKswDBa
		YU6UUkEMWeiEPXQ6/wE/uFOkRe2aPOdZrHr+TRl/EMrrbCCQyliCXDvpS7wIsgSPvCIl5iJeNpaQ
		mleECTYI+UERAvkdDxQhhZXJwXfgJQeJxo9MFr0oS9TmUb3uFSogNepf/2NMNpChEydtYhOpkFgi
		8tSaZPDDMJpJ06HaQxR+8EMFqCCKlPqhE504xGJbSlTAjlZXSE3qsfKqPMa4biLQyplnThMbD22m
		M5+5Vm4kA5mTGZSsrmEdl5CXs6hK5jMeSUhKBEpXjtj1okvl63Oh61fSTrcrWchABfzgRHVutxXd
		pUIGxPDSqyQzBGQgIma/OMRjbrcTkLWuH0RBict2orHUta9+THtaw/8sNZejqlvdZLLQ4tDJIq9Y
		rY08hEen3bZKVxqSyg6wAsxQK1SSsoRBi9CWhkjKwazNkY545NsVeIBLx9kLRQnHXMUsJ1kp0WMP
		MwMTjLhpJS1pF6n8dBMZQzAoQylKRUwcF6UwJTE+ZN59kYwVLy6ZyUzOCherqEQlNjnKTU7ylfF7
		Pf2iNjFSKMKgLDAOEGKQqgmZiEJtMGK+CTQbq7UZuQDZX3fBhEUwmZQNfvOiEjFrB+4bVx89VskY
		xehebf5DHiOwuznZB8XeGShDddlDfwo40gGkSgwh6BxTRWci06nOyerjAe0E7TteiMA4FEec0FQB
		Vekp8CzjAh83g4T/Ph2VLpZxnWtdBzG/Wx5MPWNjATpVhnVHIZK4oFUPzfnMq4+aNXShjcvBeeAL
		9wzkDwyyhBxcdU0S2YG3YuCFhpirLytY1DiWgJLZUURRDCGUoSbysqHciH506tiMDBeTSl1KXDGx
		QARysAQPfAo8onqjqVDlk1WVJFM2gJWtj7xriU+c4l/rta8DU8/cuPi3fNi4mW0WKlTniYAWc/Zc
		ow1tFL9CEtW6CXBH47QcaEZcbhqZJaTwuN3ZQDVONTm7bVaPEq6sZfEe3Xe6N7OafXpmdPRbzz4E
		tEwNTU5SMBrSbKC0fTftaVKwktSyoR1yeQFr8Lt1xdGedrX75+IY//8HsJ3SOiv5pTweIMrPZkjH
		k0+EKkEeF4zNJciU4wXFFpBEzm/ykpyRTk4ADvoBckA4D2DmFdDgeWkY8/OJTNjjFiQUd1YSOsww
		xHSncZ3qWnK80UwENaQrWe1oTPbccZJ3j8OcnCQSPDelhHhJP54Bg4mYCNSD+MU3/vGRn3zlL5/5
		zXf+86EffelPn/rVt/71sZ997W+f+8pvO8Y1TmNKuQk0ybqSW6N0kJi02X2zCRSA9emqhWZYRTUb
		vF0KvwGMBZJZB8jGATas6G7iKNztB8alLwQiAmKAMVYA+GLgC2LAhhioJhzox+hjgm7EgjBobjrG
		gvLtg0JohNJs0f9OyGJ4pIVQ8IVKSCIakIZQKRtAKIe+YIdu5H2WA8/WLgd1cAeth1jc7jBSCzkm
		wgLgIpX4wMDgIlC85a0SIkzoaAcsIcP8p/7u7y4azTHobim00JSUg07ork4womaUgSRyDII2icAo
		4pPkig+UQYSUgwv5hu7yhQ1ZqS22sKHYsD2EAtb+q258KcAYSibYgggZCpgCh8WqMBEVcREZsREd
		ESS+z9ecK2tWyyPSx+MCRSZyQNmg0Muu7RGh4goPcRKRgqNAURER8RRVcRVZsRVd8SIicctI0T4q
		Edtyw+EsIwLOyjUs4CEm8BWlTX5UbC9SERhbsRiNMRmVcRmZ0T7/YlG/ZlExVovP3EIOYmhcNEZd
		iK8ZBUcYRzEIuZERkTEcybEczTEZn/G06okq8sL+9AjlzhEkGo2B8IoieM4lkks5jqIYXSM66iVZ
		BCImmIVw+qhM6iQlUgQhO40ngCJyKuKP4oJZ3PEjdPGjojEeMTIjNZKv0jGp6skLxONE2INcDsAL
		4EgkX4QMWMSRxkEnIscAO2kjLQLFqA1ixIUy7mUcbKAB+mLHiuALPMBcCOdqLOfLNGY30lDgNi0p
		E+qeRiUhGuJqQmXETqQK7ObH+KYBVNKC0HAi7hEqrLLILCKFLBIcGVEZ0PIAZHItlxEt0RIdtewH
		BWMdycAGIqBL/8jlWhCsS6jFWrBFY5qlOk6kCAis72osjc6RJrukZG5CcarlD8ggBz7pD45jIKKE
		OmYGLl5hCeDlex4H6IbC3QbF7m7iD5ruCF9ucqIEYxSCNU3sYX4ANBzOK6WgAf4gKC0AY3RyBw6g
		goTGNkmnbmQjgXDvZKogNSDOLFWBGqhBFfgAEi5iERbhI+KhOSliEcRBHKYTKjyFMihDoDzAtRSD
		OoTCduxJPNMwH2HtC5MFPSGoyAomJL7yHHmAGtTyIyBBHPhgEe5zPVrjMxDnKSzgLROxI+fJuQyw
		L3mGxuZGDjQC3i7DAOODNMZhg3piJyLHA+DlUfyin7rSGOexd/9K83HMBSjq5Eq8jXh47kTu0QJ4
		B1qkYPU2L+iGDjcsgKpKJIc+DWNOlDN/YObqBEgFCjNSIlqgJceKgDM84IbOo4SqgOzipSUsoAjC
		kztsIAeUYQVyYAXCox6KADnNzrniIRyaAAcWQRH4IB7i4QBugAfEQU0XoTlvgA/mtDohQQbSVBFU
		wR6sgUxVQRHQdBF4oE7XdE75oCWVg8YQhTr6ok4Gri/cBEpITNhMoyZKJJdyrx6u5CWOA0rKk154
		7lFTRSjYpg3xqTw6xvIM8BVmYm5w81BXIDVg5UbYQ4QsQWrchDYiKAJ2IDUooU4CxRD8plIjgCrk
		wBJTo1jDkRr/4qFM+YAa5rQJ1jRNvwE6DyEe4vQ59bMiWQ8ey6MOuoRLJExKSakrDbFch/AI6SS5
		LABPHudcDdSMnMt/oCMvTTMDSQJIPgmVvOBDTPNFYoAwAWkJEcJFc8lBi8AS2EYpmZEmqSV5DOVH
		VKRCPeBGHMPyvoc6KpUNDQFeAhbTRqdzVuBzzMN9JufQVGIp0oy1ouQ1OG3xyOALbAA0Vo8goEEZ
		Zmgm3KIkilWQHmc0vGAcHqdL3AKAQLIsxTIe0FRNqUERZIAHVOFamVURpFUGcKAJ8PQGcIAHzlQG
		ZGBMrZYaeMAamnZrrQFruXY7IZV1FKm1VIZjcmY3YAUa6mEJ/3JDRC6jbqtAcb4yTiIQNF4Bga7G
		YSJAZm0mB+gWPjbVW/b2de5FZcwjAh7C3C7DSohEYmzGSVlmK48wMHPEf7gEMrjqewQWQ1sorrjl
		WOvBECZSGRVha8WBB3iATK9VTePhEKbzG3hABhShOdUyWniCDCLg2SrCAtRBhG5oA9ShUhwoGwwh
		Al6hDkjHEIog3QyBPlbgeS2nDtzmworA3EYWGoqgDiTBEP5gCYogBhpAKOI1exC0NOqGJE1SlOJF
		GfaEjqzxACLAJQ/2qRoTMz7DbqChYiNjMkBWGWky3RwDz2xA0QBQCuDFfWjkAAQGIheJxBwQAiUw
		Wb7gx8hgBf+pqggwxszELSFeIiGOYwcg8CakQCdA7q2K4HtaZmQtyIEcKM86mBI6416qYAk4kFzA
		Khvm8xuTFk15IB5wIHbNFE+/FlBxwBpu4BCaYD+bABJwIB6+QQbaFFCP+AYUIR7wNBzEgRrMlPV4
		uETEr15aBjNORJEoQXEXT1LkwG55pwgYCFxkAzSyVDUkbENPxi1sdjMG7nwVbyLUGPFSIjbr9iHg
		RKO64zNy4HF2hA0Zpo+74zpczlBMUyKCYuQWTw5gpQqChBwh4QaagAdwwGubgBqelZXjYU7Llg/C
		YSKkoCkC6d+8NTQkoUvqwIcb4AfUIRvq4AuS5wtywBC4N+z/6uAH6oB6A0gdkMcQ0FealcWBDEGa
		v0MSEsI92veMzDJr9qhjLuxWidKCWGddeET8ljGBuy1rivG/BNGTHK+hCKcl5uoL6c494DkNcSkj
		ekIm+nCf2xAuJGpj4NkN89HIzLIJwkFNn/VNqWERvqFpm0BaZ5cP8PQ5m1YRBDUexOFpcQBQS9mL
		ceAbDqA6pTP3KEWlOfkyHO5YcSemhXbxFkV2EG8namYFcK4eblgiliAlGsnRboKqgiQb7i2sduJG
		NDMyRBmU4eOrdsIG6gEGeU4OqCooDWpufiSo6RYaOBOU97YghCICHAhe/A9WgvoXlfGUX1lQ9ZQH
		+IAHIIEH/75BP5k1HgZVFdTyNvkgAtg3ly1nD8RiA665DmxAEsbFh71tA26oCHLgC+rAC8p33Txg
		D2inAZplNxjbEq65Ab5gWbJBHSJjKboZbS5SL6YxJTzgkniTb2IiULYDxpLRYWWbGE+bLRU6aa2B
		bKnhab9Bdw9honFguL8BB6jBHpiTrsmWrnU3HJx7uKG7pA+BuWfXOd9iKUSJJoyjJYyDl8gCZCyn
		ToQtn1a2TvCsJmLCPGqGEsj15aRUJT1gS0eFAE2iu4/wKJRhJOa7J+6RVVtix8igBtE7vLOwfdiC
		TmgkvJVhj2wioZUxHnZbdvt0d3t7bHnba2XAGnZ3im2ggf+PsCkcnJSwdKwMJT6wRU5iyAIAYBxE
		QzIDpQqsMTQ26JP8BxsnD8aPS4dF2RLCpbTp6ZtlhXhxWxRzG7ehbRyfExIgoaJN+Qaa3Mmh3Mmr
		uKKbAMqr/MmjPMuvvMr1M0a8UyzxArxDIsTZsD8DKMHL40PtgsyNfC6y/M3hPMqdkw8ogTI+Iybz
		IjI8yseN5bbxQsjZksj/Bsnb3Ab9vNAR3bY3IqAZvdEd/dEhvfAGZ9IXnSYj/dLrRiwwPdLNHBbj
		Ui61B8hpES4C72Un5S6GmBEF3Z3RqB/1qHXHZekW5zvGQSACKZT+7uDOTGdu4oGAjC5AGc8twlMM
		XdQT/dj/J4qT3HItmL3Znf3ZoT3apX0tZknYIPHTQf3Q7WK1Io8QXWSV6sQL9TkMQwOiVGkOwVAR
		V11W3jmElpIioMUA+6VVPCCE6h0ooGEpvuR/aCN0OrfV3L04YO09KBOwM63YwRzZFV4vrH3h9UpD
		20PNYwTb5VLb62K1DAIamuKnP6M1wKpKAuWs9raCmiU3DiIhqkOqHkKdB2/dmysIw8RcRLNQsDIl
		VAJVwgQz4oYFR8l1Tr1SVCJMGiKAYlTgoiTMqqM7dJ1T6iRP5GpGTLMlHE6tXz7hHf7q56LhP+IU
		uL7rvf7rwR7r07AS6EANQkABFEAf1H7t+VypjH0vKhHA/yjntXyLcXLLIzDvtQgkNmjjCKNa3QdH
		1Qa9nkYvzVQGNwTQdXRCp1mLZcXPO6IDJggU6l6UO/JMN9jm6hog6yJgaWjMaRzi1Oh2aqbaIbwM
		4cU+9dc8JsG+9V3/9bve4eOkEjIhDVzBFdA+9xWg7TXE4uliteiPxGjGaVCCDCym1D44Z/51wcah
		Siy3Ooa31gHfG4sc6EZjHMJ3UECvJnKMWxrfI4iNvVmQRVCu9byadkrzdqRGY3and24vhnSPNCKw
		eEjn91Bf9fE/LtwQ7AlhB9yhEgBijcCBBAsOrORFzamFDBd2UFaPj8SJEj14IEMxo8aNHDt6/Agy
		owcvhP/oOHLlSoHKlVLIWPgHM6bMmTRr0rRARkrInRwjeOCzI1u2P3+qZPPw44eHHVWkeIAW41XE
		CAeCWlCK9YeNqtl+kIH2g6fYsXw8WDiL9scKsiFf4dQ5McaXGGSyLcmW0UaVFeP4kKmyQ+LfKmR+
		WLKULccPoT8iLIG2Iikfw5Y8HFhLZkWMA5OXeCkiJRu0el9I11uyQ7PEFUUsMEWa7fAS0q6rWKoX
		lu1Htzl1+/4NPLjw4cSHe1DWcOG7d4QIfSGkZk0lY2tCJLQ1vZb16LUaVJpHZ7t0QvUa/PFSr56U
		A2To2iY6MqkUKa+K2w85suTJlCtVtnxpU4AC3tTbfRT/+ZRRDBFQNFI2GBkIoUdmoXWWWgbyBldF
		FpVVn0YerCDHD8r8NNGGr1gk4is/WFDRiq/Ud6IHHVY00YlnlfWTWToqkxsfV9FYVkUWkPjTixe+
		FWGSSi7JZJNlIbfQQA24I9AszHTxzjzooNOFMV0wc0cjdHTRyB0h2HKPLcbM04UX97zTwA6EGGLD
		EjkssUIVNuRgSBFVyJGDJTHgiSdeTt6Xn0ko9eefSwM+OiCSFP1g1A6vZOhbPSR2pCKLhyY5IYUW
		dlTYRlIptREZFhU4lhSBfQqrbxjGSmutti553CkFGXLmI/eE0MU8zFTSxT2+ZsJBF5fM0gg62ICR
		JjPz/9zTrBrvWELHF+7YKUcMK0AjhyU5dFvEF69wu0MOtwKX6H6MKvAfpPLWJGlc0HggxzhVvLID
		WMrIAdYrXnjBI1Qd/gGNpXXt4KkcDq6LK4UVruBFNlflK5ENiUkRkQ0/IByDBVXgVteK0EBjwWF1
		FQFxy8TN6nLMMs88kTu1FIQdMujg04UjZCKDjDHocIDMJRzM0ywzzCgAhpXIOIKM0nQwY4kXevxh
		ybepgfhFapAZtYJQqdHMU7uLMhrvvGrDVK9E44Qox3l/rPBHET/UU1RRMXiQwx859MXHFzbE3ZUU
		LMqB2w5hqQrkRWSPFSqFG/zxAzRe5PCTMpFZUhQfcf8v8dUfO+wwTlceRxADuH8AWsXjru/W9uuy
		z36fzQTZgrsj04Dhij69O+KIPvpkooA+wAtPvPCuEA8GGJlgYwvwArlDoTJ8UJKjjHzY8KIFynhK
		u4ckKcpff2mvPW/sWEN1ADR1d8vHOJ/xEQNhlsghB4mtxxADXgiu1anRdcVPdMnG6MLXkcihRRIY
		gYoNJCIyPvyhdPSLgRyAEoMd8M9QytiBHKowjh+ES10TYUoMJBKBB1HEYQ/6AeBONpFSUQowFAGc
		ROQQmBluSjA9CkldVNgRKfSwODBDoBGPuBOG2E4gtmgeGIQHxShKcYpUdCIYbDEQhiCRLWYrH0sc
		hb7/9LFKIjv4w0SqILqLIIwSS/AAJbyQOg/YgETq0qCD/sCitfCtHpZIlxRal40YFCFdW2SQxM6y
		AbrgEC6aI8MS/uCgJUjBEjZwX8JKRwYbZDACKxgd/k5YospIJAegnAjiRIiRHXzhetmohxckIhQ+
		vCIbXiDDBfmQjVVO5AcNoAQu5TAjikRkJ1XwwDA9UgQzHmmMhWzmFpV4szXg7on6eIY1r4nNbGpT
		m1FsHhYFokVngqSL7zpfGB8VOzKoMCL9IgO/5BCBV+BwMgnrUERU9RSGeU6IRdDXeTLDBzSi0YaF
		VOBVOomyUgkGGuPACUPVErftueQrlpGDF2xQsmyw/4wireNDxQB2spPZcC0BrSAfWPaKKuwrfjuQ
		wgUHBw0+HBNEHzPj4CaCN/PgS47dqofCqrA48/ABLD9Q3A4G96oPLmiZmBKnU8O3EJtN84kKQIkr
		IIDVrGp1q1zNqlVRgo2wivWQZC2rWc+K1rSqVWLi08/ZzAfGc6KTmffRlES8AJUhGSwiEUndEJFo
		0FG1xVAgKaJEWicHG3SSKESBRoZI2tHUWEKCANPJOCyBxnrkgAxFcMsZcakgMqDnloNcgQWW4Kcc
		AMaAkFScjzAHjQgkNgevWIFqW3rUHBzTPobFqSR+W4cdemQcX7AACT3ygzo88LDL1cgPNrCBC1ZB
		Ev91AF9GslGHyU5mAw+swgYa4Kkc6PKpn2qIVJuoj18gAhH5aK973wvf+Mr3F88Qnje/eQrySmh8
		7kJbXOUqoNjdB0H6HechBUvE2LVOXeP4VkhdKhFXHnYiK9AJXhMmwQf262QN2GHrfkAnovCBhI21
		QBFGJMQUp/BhuByxRylItx9IoXPzZOpGYrCBs3yhDmUpZlmEMqQTfiwGDViBOgJTvxPaMoYNUMdS
		fwCANgKlCuCrwxKSmwNJ1MMQhqAIU04EgAY80AZN/gGOLZCNBkwmzAUur65CUIvmCS8AdK6zne+M
		5zzbmb72/eYaFtJmD5Vxjq9IzkLMCWCbCNg+BA7/NEcCS1Letk2VBbxLRiixF2X+oLhqCcwOuvwK
		Q8QGMaWM6TApDRSdMCU3qv3bOBz7rSpAQ6UqxQgZvjCOzGzGC1VYwhLk8K3F3KW5CaarBCWRDTk0
		AHMNMESH61CHBjxyA0CpgxQaUAR1NAUAX5CEDfaE03pYO2Pq6HA21AFtEoXFA3VYgZpjwOPVULcB
		9Sj3T6RgA+XmO5etq8MXxutoA1mgQ1EKwSPk/Aw6y3fhDH+vwq2pj/uCM+AlGrRlNoLoRBOoqd2j
		yIxgZKqekIiFnhPKHzIpEfpUzFJ+CUtQjFLKx0HaxiXa0MA3IrIQyVJGnsXRi5CCIo14yiLCBR9a
		/yQSlrJKJEZBohGFmm7dly36D+r4AgAm+4cwq0Nj7abEH3j8hwZcW9x+8bccrKeRDWRIuXyQhE4k
		oczJqCMb16ZfvNseEW/XAYgb0JS/61C/TqrZqRa5OYNAohS0g8RrZxFILbBxcDBYk8596AM5Lo/5
		zGt+85rPRwDyAXF94A6/FK+IxYM5kYxrXCbq+0NELHIAu/FBGYrpSm5cctKwGKk+HsCj5xL3gxyg
		hcg/qUIGXaMTWZeFDJZA1etmfp/e7iQCryq9bqRv9+0BgAz12EMEihkDKXD5DxuIvdjNw+PKxWAP
		u52I2icCdz5s4ChOFky76ScJE999A/fa+rjdT/8GO8BjAlgHGyAJ23dEZ+EWN7ciBzAk3xN0ODdw
		J4Ij37MiLBJ1QyVal/MOdKAHxiBn1UR5llcInMAJmXcBFyABhVCCnNd5n8cN3NBnpJdAjEMRMfBA
		SrEpPBISK3IoS/EHhIZx/7V6MxE7/HNUVYAehnBCHsCEiEEY8uNYuCZBfYEwgZRHsrQiiGExUmA5
		uARRP9EerlVSswN9kmZs1qck2AdvElEEwVUEG5ADymAJkrABkQFdG/AF1/YDkgA66gBdH9NlFPF+
		bshANiAJ6kBbElEHAFCAnPVbKiQFibgWhSgRffcKdbh3V1EFdYB6stMpnVIRysB0Z/E9puKDkyH/
		Iz9xgQ+oEXLQT29zGCGgBgcnPNwwghIABRcABRIAAeRQCAPACYUgARKwDeSggi5IDp6XDzE4gxPH
		ETaQHvWwFbKEgycXA9ToAfiGZn9QHzi4PUJWDxYQGn8FKqc3hABShBuXEePwan9BMISFF+ryB1Eh
		SKuzdFXwLy3FOHqUA3+0Idn4FXhhTCvgAUXAGgDUUbJzhsXWVGq4JNhHgYJRHz0iGT7iTgOXI0mH
		ez/CIMH0A/XhkRqiTkgXdR6pPSXSIbg3ERk4O25xAA7IexriIzrCGRrhFj/ndN7TdBkhBxjhUkUw
		MJUQgrgYAMAIBdvAAfIABScIAQNwAcgIBVqw/4vC6ILM6IwRhzvQ6CHpgVEeUxa39AoKIjqjQwkr
		EAF/IAURUEuo4yplJAUG+YPoqBGqt45H2D9uoUExNWFrEQOisxipMxFYYwNqyThe0BJF4C3qtBQn
		BA2WIAVeUFR/YhFV4EvH9XwHFmkO6WXGl3JAdEMsBkMSARX18zBM8QeUYEAzMk86lBEKtRM/BBJC
		tIaLBpEBB3JjoXgbQYoSkQUWkAXzAILUZJTkwAkXQADNQAAXcILBKAFSWZUDUAhXCYMyqJU0qBGZ
		hD1X8UD4ooXjkJbeqJaedkK5Fhpe4I2BQZtOAoRCWJdEuI5sw0xEIZm1NkgS0UcxpZapcxs58P8q
		B3lQ+gQUDOUBqeM+F6lq7mODXiFTtNOQUjdGHiBKfKAaK4QbIVIX9XBBcoA9Eoovc2QJFuATjrVL
		YvZLn9igxGQB7bcRyVSbaXibMVocp+AOalCLxEl5xCgPBEAAEtCcUSmVKngBWjCdnIeV1nlF2JkR
		WsFzJSlTA+MB44A39aM4nfRtOBSA3fIHcpQawqUk7ZmSGWGXRWibPoKBJDIkSwpB6tZRFuB7Mfqg
		w9FbHfVBIBVSNpQN7jhiP4Aao/QDtVSGkJSiFBoiIlZJOBV2lJM/GpqNXvAKfxFUZmR7RoVUN4SW
		L/qQMqqpwxElkEdNCRcAlVeMKuiLl/eL5JD/VcZZpEZanc/4Zx1RD6pyNzOCey8yljbAIioiGGcq
		S/UBm00Cpig6pqtXpr5BhnzQaBAZp8Ixp56jWGXEWCS6GkCxApqxAjdVBP00YZ6zAixZUoGUQqPl
		hqlxWqm1WmVkQEkHWxqqWSl1W66yJ0sVIdi3qfXqGwUXeZMXqpXHCT56qsoIsMwYeqPHlakSqyg6
		EbtJM8GajvHJjklCYNDwMA4TSNuTbDGkUrfUEarJYi6zrMHRrOriLSHlWLckYRRqAzNGoS0GWSUU
		dyUFYoVpRiRVYie2jTImYy3BYgv2YngRYzOGWNUHIfRqr0UrFviKcArXcEsbXw9XXxL3qqXH/7Dv
		qY4OK5+ZWhwIMhpLoRZoMTiNcUseBLbLN1SBgXvC5wEE2UBKVisfCxyGpUo7UBeWRhF/QTd+0Ulk
		FBmU9he55I6eeWpzkWpTxmpV4Gp0F2uzRmu2NheZ0Re8Zgm/FjbClg3EFn3FarSZ6xEFF2fUpGef
		C7p3xmdamUX5JbV0KabwGZ+YGxz/o4UpA2ThN630AxdAVQR9FDZYUxn90zGsdVtlRCtu+xuGRXQ+
		cpMZITIBY10sUrxXkRYQpCFF15I3MhlmekhLdyNGZ70YCL3zyrqaC74TYV61ME3pxV5Mi77uNbpQ
		a7qnG4RhShHDqnHf+xuuyzcA+RPAu7K0e/9Y9RBI/yhbgkQfS+GO/tkU9TAORxW8mklzY+FT4YuT
		9AvB4BtV5NtET3RNaUAPG1wIMcgN07AN25AG3JBVVNnBI0zCz3AB9DAN+vAsVxRNhue+7pm6VWu1
		EqwbCIKYnLWYhfEVXvcqQeF1RLEDHgAYr4FDDlIXeUMUCqIvCywxCAahWDvBY0G0VQzB0MREF6wP
		CrDBX5wGz+AK2yDGLLwNF5AGQzoNWnAB05AG2zANyNAI9OAIzGAM2IAOzKAGWeAFDWV9U1vDVst6
		MDocBNYvW2qgffEV1Vc5UEFGsXUR6lcYJ/MTFhQWGJU/UCwqmznFWPy2i/YDwaBO6mSOfMD/BVxg
		BAZyAEZgBOJANjG5EeKQyiEBy0ikxUzkRI6wwdOgOy3sCo0ARY2gAPhAzPhAD6aQgmg8zPRAzI9Q
		EsxQC7W0A/H0xxaHBA0ryFerJMmqhsIrK5OWt3zQEq/YsVBBKdmwAvVAQx/0Eyk0VHyJdFRGrTEX
		YWLxCuCisEJHz5xZl9LolZmKBn6gBErgA3wgyxIhDq4sBqk8DAatChMRkzdpBJxxvGIw0AU9EeZg
		Dk5AET5ACnwwyxMx0XzQ0CDNB+ZACrN80BBNBR8t0ied0gidyrJwDaZ8vNdw0cfLBQY9y1zAGbKQ
		yiNt0wi0RFtsC9OQCY6gEo6QCV3cCLrM/8zTYAyXQMz0wAH4kAn4cAmOYAzFrAbGQAdeEM3u4IWl
		rF/taQGpLAOQEL+qe5eELBzc/McMfLkROqEVakoX+kA/aQFvYxgiExgAcwC8tGIaWiOxURYT+ppe
		yhHjEIQuOSlL4L3GNo2UQAnctxEeLRFUcA3DMAzmgNNKYAQWzQdKgNPDgAZoIAbDUAGmbQ5KMAzX
		4NJ8QAWwbA5owAfR4AM+4ARG4Nlo4ANo8Npi4NI+oAROcA1OoNpKQArmINBocNrmMBHXQNwTEQ0t
		7QPPjdNOQApoQApUMNCpfABUIBFoMMurTQpOoNyhjdqy4ANUMAyjHd7hU9TShDvYcAkhAP8Gj5AJ
		+r3fjYAP/30J/D0N2JAJjQB5CJ4JxqAG0UwHtaAGr4CriImw+vUDGCANGRAK4XADhyAD8SAO8cAD
		8ptoOMwWEUsYQ6VSJ6QXGjsYGlu3TkHF6zIhtqoinCynCnZDf0KyDHVGfFp9YDEZFyTk/ZKyfbFZ
		uaE3ZchibnonjbkUiRUwoxko1xNT93JRqYMR9TBrk52p1KgqV8GiJ73an20OYnDdwW3KTuAD5jAM
		B5DcVNDmwi3caC4GuD0RAq0E4tDmJL3bTsAFu+3exk3S0m3Qzm0O0aDopb3btA3nTiAGXKAKnKHm
		fDDeBq3bjh7nbU7eai4OSpARByAGuS3/Bk5A0LJwAARN6LpN3tGA52aIHAZRHZlA645gRbeO66On
		6wTREDF64RnO2QfAA4qAA+LAAzhA4gCmPrLkjRL0sjxRKnYFDXNUpcrwPYNjTGHLMJXkWYTWfMY1
		Gct1kTQ+JKR8UBRhud/MTK0z7YsVrRliQNcaUzd1WMrQOnxhUdTaWR1yjf0yVBpqa32kll+AGg3g
		SFwel3DRLTawA/VgQQ4PDXRSuQ2/UQ0sTKrSPWPO2z4w6rzNymqe6uNt2tEgC1SA0idvDlRgBNdw
		vKVt3R+t6r090MC96nhO8iav29I9DGpu2h5NBde9064uEZee27jd86Sg6g0t9EQP1AYN/+pOEA3X
		YAROIAt+7gNKf/VFHz65EiUF8XgWrOthL/YEWxC97usYgAEZwAbmsAg4EA84AAnUQA3JLlexYzqC
		sxg5AC6PWk+vBkxuAxZxdCcuZT0A5BJcaAGyu78WlBM7YAkJLLFS8GsupZoapDE6R+M8QvAxwCP7
		kjB9fc9UZktHcc87oHgIcqVUBpZ4tGQctbLegj/4I1sRNg4qC1SvJM4SJElAIQdL0FEVRhFq6TmS
		XUfKFDfUNw7HEVOtsy8HRD9kIGIG9EYDM1R/yQfaZfE4ZRa2Oua3zQeyANrDoNyyANudzQekIAay
		IP5U4N3tD9zqbQRVLxGgLhHkP/Mb3f/Rwu0EfuDS6u0HwA0Q5vw4QWMODR8npIYNo8LHIR8fBx06
		GUbKHCmECocpMWfOCUSMfDRGO8DngBI+soYlvLaRI6loSpS05BMt5EOcOXXu5NnTZ08Pyk4NHbrG
		6FGkSZUuPUp06E+oUaVOpQpUTpQMU75BwsGDhzUe8aSQsfDP7Fm0adWuVWuBjJScUv7UK2LjT4Qc
		Nrz8WfEnxx9Lev84/GJjXN8VO8aNy/GKzwo+HnJIyWbBAp8dgx87jFEEWgw+OTYvJr1jR44dK8hk
		23G56uuoHiy8+lHvgLIf2f5kG5c7Rowf0LysCL57nGs+EaDxgVblT/AdUl7lcFsE547/LztyL8mW
		k0yVvg5Te1hRJJulwT9WeHgoxYZ60GR+8PlhyRL7KnzIrABNf4mXIiiDpp4l6vmCwNT6K8+CGKrw
		IDdLiijwCwarsKSe+WD76RW34NJJinpCDNHDnIy4xgguZOGCFB9QRAMNLk4U5xouXjTxGhxPNMIH
		UlY04kcdXUTjxiBv9MGHYaL50QhzclzJnBhPpBENUpYEssgWl5ySFFVyvPFHcQqyUkYxYUKDCh19
		UFFKLjR0800PXuHQMjprsfNOPPPUM086+/TzT0ADFXRQQgs1VNBXPJADA0FkkgEHSCMdqyy2KrW0
		rbd0WgGyTfnIbxy/vPDCg+5+cyi//868kMsGvBzbiwxLYlBNPjKgsWsHh1R1aLrHbNANGtOg+cO5
		5xqM4E1kcaJTTjnJwywbMuTYoR7mYrDB02czdAhYKaxlbodrq3BLtIdkuwy5nCyoApoMz/XgXZ84
		3NWxRONU9iEOlVGGD8v47TPRhyxgj1+HXKOzYD7kTHYnDjPVSRlzLdtXJx9ksnihjRay+GKMO+54
		Y5CV8NiljakgWeSPUdZYJoxD3jhllVsGeeWZF6JCZJNh5mhhnqGKk1mggxZ6aKKLNvpopJNWeumk
		I8uMrFN2mvRSqi/tUCdolss6NMx2gMaD9yDboT/R/tjBAzJikCMGcvlQWwpl/pBDDv+4fpBDs8gG
		5uNaReEi410y+PhjVMxI7FlDZUpStgoyav1DWC9skBauWaGJQGE+pFjCgnEil2Mc0zYnw7rX6unv
		cNRTp6phw1V3/XXYY5cdKMd6cup23HGfffeFPcjMBns/JKtq4te6Oqcf5kueD2qT9wDYV65dnnnO
		vn6+nh0isOG95OVL/gcb/gb/ezK2fy/8B8NvvPHuvTf/ffjjl39++ueXIgL88x+nilfu3hszaOCG
		PTbo32Do9hDIAPAy0qqHW+TAOwhGUCesk2AFLXhBCAYPgxuUne/+ALzaxWV4xSOhWY73OgtkTYUr
		ZGHW6iCJFbRQhjOkYQ1teEMcqhD/XVH527bwlhMKclCIhwuihgTmEIix54iom9gQnchBDT5Risjy
		IAilNsISFu+EQwzhFC+otwluMTW4ylzgctIcSjgkbe0JXDagURIbLIcPbsTJDxyEGf7ohFpTeQU0
		5NBEnnjgdK4r4od+sp9sgGYFn0Pk6Za4xHIFLDJyWsFlgpI5h4DRi5t8XRQ5+Umf/c6TDplaFrXo
		MFCm8oKFtIAlXJNHnMgBeLLEzBcc8oMGjMVWO6CEHLAXR8nhCxqWiIwrdyIfqYDKBjvUyQ+WELtC
		XseWPtmeMnSzhNbUgwzKSGBu7ubNcTgEMFWQguYWU4VsRMAQf5Abu2IgBUtUIZyq/6QnFbtYT3xW
		cZRlpJQpq7ZFnABygveEirb4WDsLNBFzOFlozxKKLPCxp6ELi2Z++CCHKsiBhXhLoEV3IEsphJM/
		g0kkaHKATMFVATQWhVbB/LIE353Na3EkQx/lmANixpE5drNBDKARuHo0B5oADZhFfaIu7bgHMkjd
		FRl2YIlXOJWYXZujaTbzmwdiEz1rw1UC8flVquwTrJ/UJ0H56U/iETV53QHfRbNBm2v9wVv0uRZ9
		MgS8gq0gPz84ANgK9q4MAfJ3+pnPtRZT12/F4IO3RCxd1XhXxj7WIddCJl6jKtHGtpVfGaqHG6EV
		A9sg9jL7kpNlA6dZNbJHGctMFP8Zfoitn1YhM+x8HIk6+phxzM1tm2LnVcuDOWtJwWvMkVzgYJUZ
		KXwBmw0gwxLiKAVyOuRzNgCX2kwHDUP4irp0GSoqdZKfxnqHPcTZF+MuQy6nkuGkOxideMKZSMrx
		YTHLKcKDUvjOzYxVvz8R636nWNYr9hOtlgLod84Dnf3VRVqgWgKwajU2X8nhB6bJhvRyaYlsQBca
		49BcNr7AOMHJBX9F8Aw7I+A1uTSYjDnIgRws8RlfWVU/wBqHDdAZLWHFeBydlTCw6jEXr1WhPmjk
		1mTXFdIlDIabD5mwFCbHB2uqywKs2QG0lkA3YJGRMl6YsGmcs5+c5Acysprb3CL/8EDmkTE/H12C
		RVdgg27ldwXHesgf4CKHZ4pNM3cT7jiCspz88E/GMXAtSXkpB1ExB1R8sITiCEnUh+xLkzixQQyt
		VYUc1KPSwDIyNHJACXSSbhwNpu1FmwMrs2nUbhzGln9dnZP+vnqIABaegAfMFoBGZzPRmozf5PAX
		RerHxd/xggWuHCCHdEc0+IUviEyXsE1ZGjQl7Q5mROqQcRR6jp359UMkxx9qWSCBOyiCHFQjWwt8
		9Ae/KVWD3NYtOZiRlqzxkLr0o5sYREBtZmTbCiZzZUtA96ItTqCNdyCnHSS5CvVoWy21c55qP+Q7
		sr3lFwamPfiIhzj7iY/y7IMf//3A0pkAisC6CBSBL0QAmyuY54Ia9CALSQjlFSoChl4Xzar4lT5m
		1Pktf+CY6XWtrrXD6/LwqgyFCVTW+x0lxA6nyYkuPZCiNGspb12pXA/mzWfLwY7JMKquP7AK1PUA
		VNPdIIi9cjO6TuSPf6wZvWZUsdt2d7q1Lh5tsyYGTk+OdsAdmaV6Ye9xssDdLFPSNVeZD6qyTAJ9
		WVUPLZkPoH6nwBLol2zUfAVJzI+w+K4vaDiZPJQYxxcGeTBm/hVfs2Eoui4jr4TRyzJdRA6HFNYv
		P8HeXwgjmL8MtqubQ3p34ZN68cN6z1csMtwEjdNzWP/852TugTGYlqeUl435uP9GGa6ZtKtpLUJb
		Xz0tALUjeMq/8JpnowoLj+cfJr6e9f9gHNnAfrLnSJ/1lxPOcPZQjd1Tzouai2GJAACstlChFnZB
		J82YOCHTq3UjJzvKsPJbt2xwuwYRsuUArflbQL1yO4lbv8qosQbRjCl7he7wAvoLDv3IPzVCpx9A
		wcAgj9YxPgvCORq8QSfyJA/wArdRm8WYsPKhP7PJLXDJKOrKgZ9Tm1cQPE1bj8z5ArnqC2jQq55q
		Kan7PpywOvHDlBnsl90jGC+MjIIxGO5TOiTqvtjgCdYLGDDyQi8cmEeaGDAapTbsPoHpIjScJGVp
		w9qRKOHDwd2xQUAcRAvSQVz/8YvMeZys6RZloAzIkAJh2ZT+CRxl8IIl7AA5yLzB2A31IsIP8iX3
		Kz4sZKPw20IT8i5CvEFBTEXYWcXYyEM1TL2HMB2+iYHL+AH2EKTtWwwO8bNbskWdEKTLMKNbYo8f
		uEVgDKlEAUb9YMXjywluipxoKbYY6IBx6IA/8IAI4A3B+4P5A50V6IBT2MFXMA0peB4bOAUp0ANQ
		eadywh5ItIEssICoebVRJCUsMkW0+ENndLVCGiNxIsaHaI66Wg0/2xTwsDzwyChvuyPpeiD1cEKc
		QCmpsLHw2olQfDRUrAqr8gDp8MhevAz8SZTjwEUG2b4QoQ/psoAP6o3jGDvM/0i3qIKGV7AWM3oP
		MmKy52igGJANfjEvEAMeP/upcvSdzPGqfuQv5suCoZjHU3iFp4zKU6BHp3QHqLRKqDwFoVAGMsAd
		y1iDrgwappyN3BmrezwrfRy/jUzKV2MlY3qMQboo4PECSjC2epATPyo7h7gPYFHBr1vDyGiAa/Gj
		qpsKcblInfiL4FtLqRCknqwxD4DMaakunsSQEHmOuVCVuvQh4AinGHgF7REcO9ubwayxcnmtSdGO
		cVCYVxiL1jQj7ZGcP7CAkDqWuWNLpeSD3DkFpuhN3/xN4CzLfKK6AEtLtZxBG6PJnyCj16oznvgb
		eNEPgcxCwemJ5lCp/qkCS/8cDljqCbhoTnxRPzk4gD6SrdVav+lkKPDEJMSMJTNsvdt8CIvCKI1a
		IbxxEGioMPkyoOR5oNwaHE85KepxiBXwAm0LqvYYhzp4DnZRjneSg6hSDf1ogPfqzxcMKjKaQjpT
		HVf8iXqYm3qYJzLKMLiRiwdxv+0Jpx0DH8TissvAFVzRNLdhEMFhjwfiQVISKBkFl3lyiNAMzV7c
		Fxv4MY/0lWx4T9zMJKFwCuBsUid9UqS4nXo6Sy00ToDqJbA5OIxKns+Ajlf4guVYAUpIoz+wKXFb
		QnbJzh/IgSUAju+YDC+VuDo4DcJ8MHppDDkRPGUArSlrjV1pDrRJJP2Y0xz/yAZLjKPPTBhbAZs+
		U4boWIFEkSNlEA4LQNQz1ag4YQ0baADFKk+3aI4MsQQoFBbKO4CPMjfCM4Rpkk/m+I7ZYqfQQyBZ
		nTt2YrVxMI8dUIYliBZKaKL8YI0I+DqdCo0dqAJdLYKFrLLMYA0log5b8SVIxTR6i7dMW8wZnIr+
		4LCe1DcPqIex8MjesAtNIwNafA9KeA/OaI98Y55rETG3ISU+ZZBsSCOGCikCykbX0CbmCZyQqofI
		9LN+pQ0ITVKgWFLeTApbSFiFXViGbViHfViIZVilcAp6otJ8tFJUzIyH6BxSYRsL+IsciAEUjJax
		8RTQeY9I9AuzIZXMYDfJ/5CCvigCvFEG6tjVu4lZzeCORFKPeHMMXROPswGWSuKXmo0WvvgDZFsy
		t0ieRaqpKjtHznCOH5BZmR0b5+APa6m0KfuN5/ECB0mgAcEocXsezSGDwuAfcZMjVh2zRSqzDy2J
		E9sVSJUrh8iBBDJNLMOMH9qr7Aqp/ILVj00U9xuLcvoOMxKzxduN0OgNueg8HOVQftyQefk9lYwM
		1zAog4Iy4GOyZtpclZQTgem+DGGWnsgQn6xcguUvoUDYhgUD131d2I1d2Z1d2pVdh41SolAliy1F
		U8y6gpk7+GI00yAVD9DOufsMzeAN1NA3uEgkOIuB7pCLIjANdAk0vZ1eP/9NvtlrmIArnIfInm3b
		o1ew3szA3tGCDEUpAu6tB30BkIeA3uM6m7VJjO1KmM4Dl2oJl1xJG/0dmwfqDrSluO/NDghR2xZU
		zAm02wzxAlypj3gKp4zbIy8wvXfDowzJAUzzxgyLoXVZv/jTD9Pbj8EoVvswN3bJhgZrz2Tp0NRt
		Yapwh1pg3RAIgdqtYRu+4dpd2KbIXVDaXePcR1QMDsOwM1v5jJWqDfW4qCVwMsBg4tUwG/B5HERd
		sApbgnFgFwzBHEsAM8HDYokKjPfIrWiBi73YWFmSFs14hS2GjLXx4lz5A0ooJydznAqzMTWKo8ep
		jScGjp56lS3WDV96MnL/2SUpOIA3yzD+gVRIFTekRD01dKOauqQwXD1I0r4x3CHkSCg5hDJ96WR9
		2RXck6Q5ORck0shrdWFUfuEYPoqExQcOaAQF0AdH0Ada1gcFiOVY1oc00IdGyIRa/mVgDmZhDubZ
		tYUdfgqyIs5a++GzUKu1wTY5EJj5UJTPrCtqob5rob7ocRsJ42aB8aVvloJv/kzFEA9Co493WZva
		URv/URvNCDpuxg1tUQzj+ubV/F7/wYwDspto3hX/sZsyvZaPYg/FKMds02faGCA1sgBcFDa4uBaI
		5hBEfI2eSmWeYOGfMIKeeAUjMCuo4AIucLSE0WiQBumo0OioOACRhgqO/0Zp2DCClcagmM4Jk8YJ
		ooBhVrYFMDAGeqDlC9iGacCHbbiAV26ERkgDfOhlZMCHYW5qpx5m2DVmo+BhTvJhZv6HyK0geLbo
		i85qruYjr+4JEmiFKSgJl3aMDJiACdDos+aDDJhpPpiCtAbpVuBotZ6CKRAEQZgCEiABnxjrsn6I
		thaFNvmRhHEIl+aJtJ6AKeADLnCMCXBsOckAyXYILhAFhxjrCShsy9aJx+5sx7bs2klsnSABFuAD
		I8Dszw5tUZiC024Tx1ZpzOYDEkjrI3iIx7aACcDpNUhY170AZKAHV9iGZ7iAC5iG48aHoJ4GejBu
		ekiDZ4hu6Z5u6q5u6/+u7l92XaleA6r2Iqtm5rD+6ifCaPFm6fDWCbyOay6YAlE4giNIayOYgFcg
		Abxu7/du71WAbfRu7LjOACPA61dobNfmA7XuifSeAiPICvZmgffebEGYAPdmgSlYaxJo7544gLp+
		hbUWBVFI7dTGbxbgcCMYa8p+hbpmAS6o8COIb0EIcT7ocA7nAts2glZggQ8fcQvnCdOu7Vb4cBmH
		8LRG8Bq/8ch+8SO4bLlmgQnohCkoBRhWWDDwaehOA6A27jS4gCu/cijYBi7XAnq4bjCvbm4YczIn
		c+qmZe2O0mT+oH2q0rQ87/LmoH9MjIAEIoJMGIwyIyr7i489OP3cG4f/vCiI3BRNosiosEioOGhT
		dhMSOIJXaPEMAOwpOAK5bgUSOABBIAHGdm++NvBSaGxBaAXK1nQBZwEW0OvT3gnT5gJBOIJW4IMQ
		J2sGn/AXx+vIPoC+Ju2cePBSmG9RPwJRCPAMoPQp+HXMfnVYbwXCFgRRmAASSHH2fnESd3VpP21R
		EHUWyHWxjnZR0PRhf/XWPgJtX++smO1OePADEIVsV4YxpYRHeATf1odfQAQYgIF8yAcYAAF8r3d8
		7/d8r3d9v3eBH3iCL3iDP/hfeAY0B4OEneo1t6JlvmqAAl2G4onMvWiPdgy9kUUj4vio0D6kY1GH
		mo2oi5faAV3vsoAi/3ilQeqfuUybXBWNeDu8EKmMZ02eYgshDxBM5hhYQ5KKw4QKxVx0DRnxFKfx
		SXdtSp9tt056xi52uDZtWN/w9jZx2hZ3Bmf6nMj2o4/sCRCFcm/0yG7tBecCCS/ynTiAyHbtCSeB
		1Ab2UgD2to9vGneIYG9txpZwVwf2+J77scfr/+52s6/wnmByGGdvtx/7vqZvBOfruC/yDrf79T6C
		TjiCSMCGWnhdfQgAzu98z/980A990R990vf8hEfz7UZm71Zm8LtqrEbFxWien9tib/OAA8Dgpgqc
		13OMbB4MdN2bONliv/kOx5K4grxJoDv+hKGswpIoZNpmJqsrtLFfKP/7DCkoN077n3uBsuhRIu4n
		GHrRprWhs8tafszCLC9oHkvARVPBifnMKPqjP2GRzwljp5GTTzdzm8f5tAF9DAPtLYCol40PQSnj
		6vz5Ae2HFGg7pMh5ZWMFGT5kGsTgk+3HDzkdIzgkCG1FBIImT6JMqTLlKwtkpKyMefLVFEFTuEzJ
		cGTnkSkkjADNeYSEoAlGMhhZudPIlCNcek4QdISpTy44V+KUyuXnlFYkRBU18pPEFBZdzeqM+UoU
		0J+tjP6cMIFFKxZymZYyyjSsUCOtbE4pxfat2MI6/cLNwCJm2cBsM8ClOmHK0alyhwadypTF0U4e
		pKmpBQaMPn0BAuT/g6F6NevWrl/Djh37dL5nz0aDsWVrzZpTMn8DD/7bw44/Njy8UimFjIV/zp9D
		jy59unSXME/GiLGjXpXtX/4QlCMnm5Qv9QguyVbFxsAYf3bIkfLnj/ZsNuCT/y7HRpVsRchkAx9B
		ZDgUA3/ZkCGecQFul41HDtXzRwTwVUGGJdCs5xB4fPAnx3xLgPdKFXwoA0120IQHUXEmKTOiBVWI
		VwUlAz3ERwz1bCdFDhF4EQNMryyBoQ1y7GAfkUbK8YUNHH4hhXqWoDQiNGR0N9980FzHxwp8yLHC
		DzFUiCIf/RG0ZXb/7aeMSSMGWA8ZO9ggZg47VKHMEkVUsUKAAf4R/6AHfFiQgwVG1rOCiDkECBEZ
		OZwnnKMmtfTSoyh99ZUoolh66aVyTYCpKHJ1EioXK00hl6aaZqrpBAesVOmpqr4aq6ejqmSErLee
		SgIJpmaaKa+p4nrpV8mptCumwAab7LGRRFKPaKQ9c1ohEFBbrbXXYputtttumw9qtpWm2269TVqu
		uSYRZxxyyjFHnbvvTmcdSuOMsxCMygxUJh/0yWFSDvvGMBC9+bpniRxFOMkHvf06BFM2MRj8L0FD
		5hBDSa9syccORXT5Q3cWwPdlwDaCaaN8U4Z33sMbisjHKyaOrLFBKJt0o3sj7jByjYGusIIc2e2w
		Q0kWbFncEnJYYv/D0ZYkLMd5+L6SAxkZr6mlxj6L53REfMjn3pjyWW1DdkuucEBxKK5YtQeG2GCQ
		1fv+AY0HObziwR8vvbRchQSNuKUXfR6QwzgM/SGlF+cGF2mWiDPeuOOPQx655MCdcsoa2Dwymm2n
		QdCH54UUQo7onpP++bSlo5666qiL3rrr3ubDDTel5Taub5NHnu5xxKK0XHPwAv+uvNgF3FLQYlo9
		sElmlmyiizlXUTfRJKOY6AErZFc3QRN6gL0UB0wPcgx1v6KMHONY8GJ2OBep8R/pSxyfRj4ShDGg
		MOcLTT3wn6RMDn1rrGRV+NH/urODcRAJJtM7X/Q8MLe6dW9MQ4v/ntQkRpAdfGEHP8jGhVBCpRyA
		x2NVyEgMvLQDQ1hgbRpcwTj48AMW8qEkfPBCBk12tR8Q5H8gLFwEVoAhDFUhiDgkwxdi8ELw0KkI
		R/Ohxy60JNy5bHhQnCIVq2jFK66kcmsIQeZKE60AdK4PEhjAAC4QRtRtwxRkLMTqJLC6N7oujrCT
		He10w5vbYbFcultXSnwXvD/GS1InkYIUNChEjhEETFVQiEkG8ocIVSFphSMkJBc5jkN6wQsirIIH
		grghKgWxk4sEkxREWEohgqkeUqgkI8cByQ2JMEKNcuEKqmCBRxYQiVUATwtFsgON9ecHdLIEJRJJ
		hrv9QQrueRqK/wwEpo3QCZqRrAiQxuGFHEDJJBZQhgVItBJ8IYhEfyKImtJHzm6qiZzqBBQ3UZJO
		EimDWH9SBj3rSc/6tQRQLHJZPb3psikqLo8CHShBC/obLXKRNPr4YucKMQDRSaAQEtgGFPqghW1A
		YBtsdOhEK3pRKECBH2d8I+taNy1qzXF2+qgdb8hlUODskXeDbBcga+ocKabknvkkCB9XMk4+/BSo
		8kzOTu8pzpNskyBJBSo5x2kBeZ6kp+jqX1C1yTsIapNEIwLqengKVXPxMawzSZ8qzSW2l6L1UQFN
		K1vb6tZzIbSLC+VcHxwqRo2aQgumgII8oHCBC6hxG5zI617lMf9GwJJ0da6ThzfuoIWU0q52tngF
		ZXl3gMtWtrIFjSm7fmdTQOL0raKd1DELutbRotZcp00ta1tr0LhqjqF1HYDn5KEFeVxgABPtwzb+
		KgFq8SO3Y+RGbwcgu+MiN7klFR0/HgrZlYKhFtKtRTwza93rDpSzfaTpZ/8YWteCN62rDS95IfXd
		8qI3veaCLbTo2gcoDGAbhv3rBRya0QtIQHYZ7W0h5EFGTmg0uQI+7nJb99zoTtcD6dumPeu54G3K
		9Ira7R13uwu886o3w7hb7Q7mRJA/FHMmQmrkCquwo571sJaCmtsvX/FLk0ADRS9cQVXJgENH8eeJ
		MhlHRTaMYQ3/AznIBGFvadxbV06Q7rfcQB2Bf1sIU0wDAkvuw4CrTFLYgWul0nXHxh6i4PRJwQv7
		A9kOLMEcygp0wjP1rIXhFdpXyAFG3TRJL/toEphsKCZk6HFBUJJn4chhzr+xgUtuLJx6UGJxHOIz
		FV+hHkazJDuLs0AR5oy9mezHA15YkkeU8R4PFKFEchC1B7JpiW5WYQlIbcB5oOGFCPdZOHXScUxA
		CMXxCjnXQEbos4ocAFcktsrHhQAUhC3sxPYBy8+A7pa94CWOcGQFUvhyCktNCQinuTi762ybgxfa
		oL3ikQDagTJWoAwvIKhEU2rAL39Qhw476BXjJhZ/EMaeGJCh/w7jYM8OXlGEeAuE3OyxgfnCyYcc
		fAcaPK7Cq+Ejhxzc2BIXquUPCn7jOHHSBhUpZMkIwp0i1IM/44iASyzwAy/E+eIBWkG/7+3iAIWb
		D26CFII8IAcP8KffO1jIeDwAjQb8eUwigVE2ip4NaOS5Qks4HEGy8Sevec0jCZJ5DFAkwzHt4Jjg
		EQiruBYDfROIIYmKyEQqcpGMLLIjHXGSFy47kqtLDte6njt6K3eKENTCFqMxzWn67ve/Az7wgh88
		4f2OiGUz2x3ucPae97wCTf7AgQ78QdIUDGsqqvnOFe42dULbSWgsCYQV+9sK/gDCrE+tm1GzgJmL
		U3rBlSlQd/+LgODqRAbaS+E/f7t9Dpx0t3GUPpvxKWG5LeAhS/xgCfxJEZgGdck/CH8FFtDQ/GKG
		MUoXzvh7IlItp8eHGKO7OCC0xB+W0JHCcSlL3geU9LG0BE0/DHu1jNL3qVQcK2GJxGGS+YuhnpH5
		GIgNFIENWIJRCV2bUMIOUIKc0AmQ/I+e7Fxx+AmJCEo2UILTGIqJjd3UzFLc/RjdgWBq2d0puEPe
		6R0YIELhqeAKsqDg/UJkRZfiMd6ejQMx7ZnkeQDlHcdTZZu6IAG3cZ7wCJJ5/QDCzMkO+Nw4zEk9
		jMOGbJXQjYh7HKGlcc1y7EDpoch9lF6/+MibrMD+3N+cyBD/nEiI1ZyI0GVM1j3S95XQdlzQkphI
		q52IFyzSiPzBONDIH6xADuQA0p3HVmmQEblHEQSNB9AIHsqMNmWMMnhMAKFIl2zH+VAN31jNFWaN
		1iSHfLhNhRzOKxDSL8nPwW1JR8iBIQTViKxN27RQxsyH09GN3eANIVFJjwHQ32RD1AzOfBjOrZ1X
		SzzY5YVgMA5U5ZSguCjUQtlGMirjMjJjMzrjM0Ij4klWLbhDFlyTDWDjvz3cRkCbDlpeDx6HMlzW
		OF6WHwWhu4RWQwxJ3PxABHjMH3iEDcTN3fwHQZhZ0VRdO95YFdQDiFigJSjh1FAC+YEIlsgI+UUA
		gLzHDzSK/5hlh5YIhBSMyL9IDMp5yJgsZKNsTD14yM8UwfosGD82STYIRJxU3XvARPzcx33USztO
		DZf0ST2YB5q9wt/Ug71wh0SSDBncW0aYBAZpEAchD0F4TBFsSAl1Ep4wjY1UQZ0FzUn0iwwlyS/R
		zxWOkw7pYg/9UBAFk0UU0REBkxJ1ib04kY8N4SBFQFqmpaIRxDUowTAMQ1KohDkQBBqUSzQogRLQ
		pUlcwzWQAkocgF2ixF/KhCyci2H2ZWKKQ0pcw16ixDUsJuQYZkwcwGSmhCwIZnCggVyahCy8pQWU
		IG+cIGmwAyqY5mmiZmqq5mqypmoqQGnAZmzG5miICzV2gP+zYSMBgt5EFEE3Vh4P5pHNYQAGlEEZ
		nMNxIuc5mOM5BhJbwiN42Nz4LAk84lD2POROupADnY88xUf6dGcTGt+0JSB0dmdHdBMC3dgPVJsL
		yc+SuCdR7kc3LUkM3NwFOUg35YyN/QCfrZ0y2BxMVJyCRR6HEKXJGej5SYQLmVx8mE+WwEc3rR2B
		2sjN2UBZWRU6fVOM9Zia+KKgCZpaKNVOQQqLxJNSucx1EQtlYag6ZZY/ASPjyB2i6QolMKRK+MAw
		9CUVHIAPKIERHEA0RMMBVEA08IGO4iUXGEE0+IAT+MABuCVdEiYfiIFVcIEsXAMfkIKSKoGTXkNS
		oEEFGKb/XTamFWymEvgAH7glUCgpGlwDj/poNMRlWyrpMJypW7KpFfhAlpoDGohBBZwpH9ilLFhB
		NHimOVRmj4qBH3ABXorDNUTDXppDNHDBjXLBATDpodqlOTgBGggqm+olH2gqrRyAoV6qZ3Iqnj4p
		qObpow6DY14DmB4AYRoBFRiBLDiBdLWUuJRmNfBqr/rqrwJrsArrr5qmbM4mbuRGS9kmbrZN0mCj
		hSQER/zmi+KOcGJACRRnch7ncjJndHygMP6GgbQVGVTVb8gdcJwVuEJOjCJa5NVoSiwpULQqFfgA
		FUQqmzoBjuIoGtxovUYDFTyqmdorrfCBH8Dljp6pmcar/xNsKh9EA78WqcP+qxEogSy0asVmqRgY
		wTD86zU4gTkILEE4gRI4AcCCrMXW68b6wJI6AaNaLB8YwZSSgjlQARpg7MeurK1OLB8IqSzgJY+a
		gw+wKb2KARr4ga2mbMUOw5eSQtdxQau2qluiLBVwgdJ+qVvCJckSpqX+pajm6zVwQWiKpm6gQjXU
		ghCgrRDgRtqybdu6LbKurduiLSrAbd2KS0utQfrcZg5gYwSYWeM9HrRNKzh6gDiSYzluXrfe1Fmq
		a+OaF+M67kDFKCUomH92oEmYgx8kqjhk7seaw14qAdbywY3aK2ZiJp/mK2cWaV/uqF0y6cI6ASkY
		waBaAf/FgqqmRuzKDgNBRMNfMulf0qkYtCrvNmZjmsPurqwT8AGTRqoP9GU0OEFSHIASoKkT+AEa
		7K7Dtinw+sBkigP1RoPwokHvEkQFMKzHOizugu+SnkTVLi+Ogq/6Oiz7Rq8PLGqUxi5KvMI1DIMS
		SJfl4C0qZEHbVsI7GMPZym0CC4EAvMM7MIMAqIEAJHA10G3dSpYd4W0K7W3j2aDjRas3AicW7dEP
		bhebKe7ismXkguu5qrAVxeiZtcTl8q5dOm/QckFj9u41UAEfDMP1OsE1iIHQ7mnQDkOVGkFkHsAO
		E4QPPGwQ8yiXqoISsCnIhq4f0CzF8i/I+uWj8oEScLH/XppDlYosKeTpyobuvG6skras8lJB9orD
		DtOqGGixz66s87asYL5x+t7wynKqElSpKhwtGp8xyLZv6PIvj2bxllJBIvOwx3pslA5DlPJB1fbl
		MPwvAPNGG9wC21YCM6iBMRhD2rLDD6BtMAhBMOjBKZsy2qIDIVRDMAQDO+iBLcBy2/4AKohLLucy
		3tqdBl9T4xEJtBVBDkrrDlLr5GReQSSu4pqcDLdwMHKYh+0LrbnMiFnEw3SPiqXQA9bSLWIIf9LY
		DEnzScAdcOALNHyoShBHFcndcugnQ9QKrRimpibFyvLBZP5l0ILtAVRqpR7A8F4pQVjm6DqvVQS0
		QHcm/xds6o6SgjgsLcwOAz+PSpcupmEuKa34aD/z80M/LFAg6caObpQaphE0rCpE9NOCqvIecWcu
		sRMspg/Q5cbapZnaJaE+7V9adEBfKfnyL06jaSTfM5rCLMx2HZqyivK2ZcvyAXXZXUtpcgJAdQIA
		ASpA9S0sAQLJARAEAwex3BeMAxAAwThANRDkwDugghcUCSqAtVizQFuzQBvo8rjg7R3ZnX9uMEd0
		jwIuhOSB8DFLTjJzzTIr7g9Q8zNDM05RmqX5ZP3IwbXBiQWYx2WJB+vZ4/S1HLhZEJwtAfhUmkrY
		gKGF692kc0okHzufF0/mpsbNJVwOA8OusWszLFzC9v9suzaQtjZr5ytrAylss/Zty3bLQi/0Andr
		C3e+unZrMyz0/vZs23Zx13YPC69sEzecvrZwFzduw+VuDzdwK8GQwql1U3cPtzFy2/Z2T/dt0zZu
		j2wF4LZtT8ArjGDltAEj7EJ97wIQnEN9u0EO7MIXyMESnAMQ0FAJlAAQrABZ1zcQyAEq3AIQDKeB
		I7h970IbzHWF90Z8c5OmPZsDpRBzLJgDJU36+HXuaJtUaZ4Jn/A/eACkGXYIjteIvAzRGR3SrYnN
		gZ6NgIfU9Uu9GJEwjUMp3Vif9BuMdxVQxUAOmF8mdYT+IMig5IsScchAbITToNvGqYdpQ66jGEFi
		cnn/l3v5l4N5mIv5mJN5mZM5UJh5moP5los5m6u5mbs5lx9BcsT3fEt4gaMCBoD1LljCDrjAOeRA
		g0MDWCt4CSR4ft93VrtAoUv4LriBhcd3pLcEcdDYlzUYN6WQmWFbcCLdcRAEHuABPAU2ip9wh1co
		IaF6qqv6qrN6q7v6q8N6rMv6rNN6rds6rNMHutGfvdzflWQJ1ZgJeHRNSSgho3DJeqCZjbTNzmlE
		giwJGXwkIX2BJcSAISQfgEikDP3NfbzJdtTLFwDIShYBlqdwi5v7FJk4H+wDfTNAu+9CgRcDAxh6
		GQBBMewCvRfDcZoAWJtAfZdBv9/7cTIAv+9Cu7e7/xtEesLrLzdtDLk+1XUpw55perKLcKdbgCYA
		AiCcABZkvCZwa4rfFDE33siTfMmb/MmjfMqr/MqzfMu7/MvDPMtTQoQwXdUUDdaIB0dmok9ijDLQ
		Sw5ljCtxyAAd3En8+Aypmt9ch4e8x/sMChQqg4DYSKK1kEPEiXh833zwgSWM+LmwMHAAxUr4gOr+
		hmO25VvGpSQDB1726LmjVbrPt8G7e30zQMHbd903Ot3L/d7jPd8jfKQDhy/eIMVDCkcwR4mmGdJR
		QgcAgjBsQagHgcZ/PMg/x4NZ/uVjfuZr/uZzfud7/ueDfuiLvuiveD0stsZk0AZ10EkUZQgJUQ6E
		s//GtJvEmZgpcYQLSdyfDARYWsQSdBh36M8SRMAXRIDv25qWVFrzJSWSl4cFgAmjgLYHZjlQletg
		9mXo/miPKoEVtGmPJqnQKimtmoQTVACaBjSQIukbW2qPWupCA2msEsQBiMH1O6o5UKyhpmlfYmn9
		u+U1ZH+jAkQ0c3wIFjR4EGFChQsZNnT4ECJBD68Q7mvGiEFGjRs5dvT4ceM5NxEPvjJ5MuFJlSRZ
		JvQA7Q+lDoCEbTlRc8snKWQs/PP5E2hQoUOJFjV6FGlSpUuZNnX6VKkHSn8MWnhlgQ/FlNCyUbpK
		0WRCZcqsZsWaleDYAwa1ZkWpDKzKV8oKziWoFW//WLQtSV4lIyXhjypVKDH04WOYD1LmnFwbFs0H
		mmiOfYhRVYFUBXNKCorjfGAtHx9+hg1Ucg2NDyXmoqERg0aJDyNcCB6gcu2ak8pGqFTeLEuWQD5K
		oonh7UOWj8lOihvh+xx6dOkS2xpscx17du3buXfnXr3vSoXip5N8+ceGBU2AAH0SBmgLnp09oda3
		fx9/fv37l1r4y9eGccobkEAC/QIMIYp2IMMwNLgYBg1zBiqNFDTQ4COxCznjjAqDODPIh8aMOIAz
		xGLTkI9olHCuID+UUIILxfjwwwknjPiwNT50I4WPa5QgRcbEeCyQyCKfm8jIJJVckg8PdkDPAz6Q
		/5CSD7qUmY+/LLXckssu6/MPQSbFHLMvMFNaIQY+zkoIMlJuZIwyCxtLzAc+OrzToA4NEo4PEhmT
		5bXWLMvNHNr61DNF04yQxUdZgIxMDB8GcnO15fgkE1MikcyU005detKGTQ/C0stSTT0V1fvM9JRV
		Mg90qQpoPLBhoRG5cEIcPhg7QJxcd+2VD1mCHbYgYc0Z0ohcCRL2MGEhK/HCa4otKFk+VCmNj1tp
		O+waLmjLbS3GsjW01XIjEtXcdJV0EkrwCCI11XjlnTfeVQnaIYcdCBqHVrayqaJfG7xQM5tsyKhn
		MGgIQi+rKgYm6IcVopQjX4QiIEmZbKBZUyEnmf989TlzhnnMiceiqbHkaE6ucZiSXR555JL9ECPm
		kmM22QkxlHCiApNbhtnmll1WueWTcWaZuZSj+XkgdZ12yd2npY6O3VBDG5UnerXemmv97K2yCLr4
		QJMtOXjaoR4+YliCjx94WiG9iPkgowGqoPlBbILkWOKqsBOygcGHYviDp4Z+YHtJkPkyArfGHX8c
		8sivUUUVySNn3PLMNb986s7R7Rz0lpwcp54fLBgL9bHg7Zr11l0f6ms+qsgKmhXkKLhgmApagaDZ
		s7Lkh30F3GEHGw6X4wAyAh8nmx1emf35fp3MYYkfvPDiBzmgicBgCwomqAi2bciGj2yyj+D2wqT/
		yIb3xGMPHf74yfxc/vpd8iIGKQD/gf/+f1j9dQEUoNZiNzvzVeFJf1AgNMLUPt95QA5yIEg2LICm
		bMQgBuaDhl5iYAMpeEFhBpMDrchQhPxJ4QuWiIEhDkeGbEihChfjgxfQsyDi1eMP0PjCD7JRjwUV
		4WPvs98QiUg1C1ytiESsGscMAsABPhGKXirg2PiAr+tdzwZyoIgU0iQ7g/DOArMbxw4sAQ0cUrEg
		+Zsh23jnBQTJYRx/oKEFvOfFKihjBxJUmwcFBI3iQSOCfIAJVfjmvv885xVeMF8iF6nI4EUnbQbp
		VxIp2RJluK0eUtDkJjnZSU9+EpShFOUoSUlK/wWWEpWb/AMG/8BJGvIEiQVxYhRpWUv8fG0HX9iB
		B7JhCT0WRDBFQNAPvmABDwwmSq0sSD3SFgOJKa9tlrBElMgXMarMbQn4QlgPl4BCKWQzB9dcQREs
		EIMqGLMKRaAeCsu5ghyUTkmKa8kfdhBGOfKQnhVMi/Y8oAztPfIHO8iGByD4Bx6O4wd1+wE0YvAK
		gwr0kZWUaEP8E4FxjJF4GdXoRjnaUY9+FKQhFalHYwANkzI0jxmUQ0oBuYMYpDQGK32pHF6q0duN
		kaER/MMLD0aXV/AEYHyYpS2JWlSlfA0uPh0PV/p1krIwJC530ctd2KIVuLjlLXXBC1WxylVDhv+J
		Lwv1glZ4J1aIWXQFP7BoDu5VhIXuoAgeSCtDJRbOHIxjpTmQ20T5qhBleIAMNqhHBAhbWMMeFrGJ
		VexiGdtYxyrWBjCJLEZ34DDilbQKcqCnSzP6Bzl44UlSiIAUmMmVDmY0plL4LDRcqLG6CTVrRpXt
		bI8iRIeQQUB9jadtH2ISwejtB771ndq8AMQYFJcgHSxfDC7GOwwqbAkRzF4M0tY+3V63T8b033a5
		213vfhe84RXvePv3knoog4F/yCzaxpFZs8nBorGqxwVtUASNWcBtZOBfYOUgBWgMhnjjsARc/UsQ
		WcGWPrRV8IL/wVvsekqeLLlnFV6BJgvcs33/ObSBJfxrA8TFIAdk8KOAViDiP+TgmLPi4Q4ExNYH
		X/cAc0ndjGlcYxvfGMc51vGOxyK7DprtX+v9V8G0t74VpFW9UkCTFDxAx4m48AebpWlk/7ACetqg
		CgcL6lAZ3OUoOvjFmYowSwRK0Mw2FKIFySNg1ryvKlCQf3O74AE0u+JX7I8PMgwzjEHTZz//GdCB
		FvSgCV1oQw+aD/PdmFAXRFgbLIgMbjyAFHZACfRK4RURgIYyKHFEQ61PDmOJoDJs8Ip6MDDTL7QA
		rbjsZVcHEMx7HtOYMTUOPcsa17k2F7n40upX/7prsdZ1kmg9bGMfe89ckMuyma0SXwMb2vMS/zay
		DTRtal8b27p+drS5fSprZxs6xY5n1AqC37M8ko4LiShDHkluYGbFdBCD91PBXW/7bbvb+ebSt+3N
		EnE/RJlqIsi5B05wgrbtLlg5CxzH4YF6UPcH45ACVljbNvJFgLkEyWKCuFiPV4wjLK9grcgZxMX0
		tPcVJrdAe/PWb5d3Dt/6lvl++P3y3ta8LhdNeQw8gHGH/6F0EveAJpV3sA5O1gOPrCd6KEI66l6l
		xGpTmII0rq+D1INWEfBAw6PkJNMtyCxpcngVyT52m5/9aTGf+drtg3O0j8ftfKBEwXCbFau/cJdA
		V0YmZxUgPpBOeZNkaCRLF6B6kMGzoVopRf8On0aEzAcafl8mrbD+LsDsRG1kx/zbOd8qtbMd9E2J
		e+frEneE4pZfWw8V2tLzcOXhkJkGBXpgbSA2q/NBYKv24MGy0XBnrtoLVjHJ7YH5h6E7SS/6Eyqt
		Vk/2V+zgB2kiPumxTV7rizeWWEtw6LnvtUNSH5FxDxwZhv6K8m99IqRt2ziMSccYtJ+gjwycUJWr
		fjURnIudxsr8DRJ9rPygySSi66LE/+ZGIt7PAMGv+vCGjhrQAR8QAiNQAhswzhbi87oPA4li9Kjv
		3xTQA40Nb8hDquQCq5rNBE2CC9bt8WIrA1vwKTaQ9DrwA2dQ1kxHJXCrlWAJJfwDNGzwBJn/Db8Y
		4gJd0AVhsPNkkAaTELt8kCIIhyzoyPxMArCowi/ELkquogHVJLhUIggtkAWJEAyRwgg5DwkXggVa
		gUUQggRagQSyjw9YoFZaYQJo4wgIggQmwAimoBVaYQqMIA0T4gz/ECHqkA9mgyREYQLm0CAIkSDg
		8CAI8QynwA2JhAUMhRENwg8FsU8gUQ55rRENwhGRjQn5gJ4M6vBeCfGehCBwyGw06X8Gp5WiTAqC
		x6lUUPvCEBdr6/uUsCHKMCGMQBS4YAq8ZQ65gATaMANegQSGsRiX0QiiwBML4hi54ABYoBSEcQpe
		IRgnQBReIQMmwAyDcRingAVYYAKUARgl/zEDgpEF/LAbzVETC+IAkpELWuEARCEbW0Eb+3AVjFES
		zbEVskIfSaAc5/AAjtEI4PAI7nEK+GAKgvEenQMfqxEPF0IUChIc8dEhg1EQJmAhRcEI9vEVApIP
		ROEIuAAPSYALTJIF+nEijyAdKTIaH2wUpYAS0s8G/uBKJu7C3sUGPEiBMskCmGwWCWsialEIvzAX
		l/InxvDtfFENTxIN+XAC9HAKjuAb8ZAqp6Aq9XASp6AUGjIRVTIRnYMcjWAP45EPCJILMsAIBCEh
		SUAU7pAEsJIF8PEh27EqQzEhOrIVWOAh+VAcBTMwHxIrCcIq55Erp2AKMoAr+aAqRSEDjv9AEFig
		E6aABIxALidzLxdiGU0yMiezMo/xGBlzNvTwCESBIDrhG+9yLlPzIY/RMeVSFECTHHNtFA1qYTxo
		KA+Pi3Zzk0pn4v7gwn7AgwADKb1w+5iSKZ0S7aDyIBgTMrGyNFngCLgyJPlAEKoTMFVTIR6SGgVB
		MstxJNcSMFvBMb+zIQVzLSfAMa3zIUuSMcGxGjVSIebRCJKRBNbxLu+yFK6zMS8SHMHRIbWRMpcx
		M5cxI9fwIlVzLuFQFDrxLhtSIRR0LRn0LuXzCI6RBerzPwkUH2kjGLuRMTGzFS5yGglyQnFT+HxL
		+AAQb4KLtH6gB/Fr6KTgknLUdP6iRa//whabSCmZMxed8+yg8xFNkg82NCH9EDALQkmpsx5nMkmd
		oxzfEDOR9AiatCQXIi/X0iGPkTqV0SHbMTVfYUMvUQ2z5SSX8RWG8Q6NICWzkSsJlC65QElXEi6P
		gBv9UUyZcTbY9Ey5NA/3lE1JwCENEyX98E0pdBgR01vm8hXitE2PwEyNIFBxLQRRwi3qYi82tSTQ
		ojrk4pKScjmFFBeJ1OaMtCC4ch1rcx0TEVZjdR0zIANO1C0rNFYTMUJfNVel9A55NRFttVYRMVdP
		1D0V8RflEBEl01gjNFjd01izMhG/ERFbtRUE4RupdVhh1VmZtVq7USGIVVuNFVaVlVrl/zBXc1Uy
		udFWyTVWKxM3eWIC55VeJVC/SNVUmROXiqAKIkkIFwKC7uUnIcICzCbRfkm56uGX4kdVCcJbHhZi
		I1ZiIXYhJtZivaViL1ZjI3YhDmBjPxZkQ5ZiFUJkS9Zkde36Uta7GmII81XfvuYV2EoO/FV0ECec
		zsUSqGJtCIJuAGNn66dheVFoebFlXbbbYicHIgD6LMCkVq1fmdZsBCqCWKuHhIp9Foam1EsOVi0b
		0qNgKpAUrwl6XkqGhkt+8Itmh1Zt11YhSqdUjbYFkZZs/iCFEEYZEO8LTCicXkoKLCEHAAb6gOjv
		amcFeu8P/LZf+/UgBqd3+MCEMqthhv8IvyaJbSvXco0Hbod0F71oBV4Bg+gIjFzqdGYnB9iKrTxg
		lfhgCbBicEBFCtqrSSxgBxTGIBiXiujJEsgHjernr/jPcn93aMkvc091F70gm45pfKpg6KqAyd7M
		wy5MQNRLZ6sgB7CiCqTJl94MhpgpacF2BWaHDJYgShKNhMTXfq4CsAQrldaXfdvXfd/3kzAIFhVo
		p/CnleAXf/NXf/eXf/vXf/+Xk7CO/N52eLsPZjvVIFpOLMZDPMTG3a4LfZOu6CaYgivYgi8YgzNY
		gzeYgzs4gyPgJ0P4J2moHijBg08YhVNYhVeYhVvYhV8YhjOYf5qsgMMQVZ8TC+tVh3f/mId72Id/
		GAIBy3/ij7oGGIiPGImTWImXmImb2ImVuIY1F6yAtyR+0IqvGIuzWIu3GIuVoQMI6gFjwgOimIzL
		WEhvmIqzzfwaMHWK1ozfGI5d7WuKS3ENApoe4iUElnIZor5oxZ+y7F9CLI0ZtsnoqI2DNI4TWZG5
		DWZlNm0VoosMwgNs9poeogqsx4WqN+kubZDhZ40NGXXceJFHmZQFCGkpzXSaNgaUp2u9pysaIAbm
		Lm1gKMNoypy2dny81nweiXdggtKchyCsq5M755NPJ5QRuZSTWZlrSW7ThG4tgQyq4HC/d5XMTHW/
		99F+QHDHgXCzQYEsoXARhmZf4gv6/4XFEm36hvlpivmQCXiZ3xmeW2eKOvdzhxJ22QXqfuB0V+kV
		VldtSpGPZqfJZvcguKcgZlaQHlmd1YWdj9md4xmiIzpV5vh4AeZfruQPIoB5j0l5wwmGqKK9qld2
		sFcO3kyjubd0Hqlp+UAOVgBBaHehp6ahVQeZJdqmb3pLDhg8sAw5xyMiyK0tpiqmQWemr6SmcRqp
		k/pLNjchFGion7OQjZmmH1qpq9qqdXGKn9oDi1qUr9qrJRqNtVrWuPqov9qsr3qO+VWhzQOmm6St
		CwKC7pgllKGOxVpMyJqqz1qvkbqRWfrWalaSEecgDmchIjklzGeE7Pquo7qd99qxv/86doRpaU2K
		h7w5Gy4Ghp5He7oihiatClagz2DozUzsXyLgAJqHEmxgBeqBlzCAEmAZy0Lla8ngAJQBtFlM0BTb
		QBjboR/bt6tabvVlHPJ2uD0AeC4bAxZqlXagb/+2HjDgCIoANKQAupdMtZaABeQgElranOyUBaRh
		CaQhGw7gCwo3EqogEvqMC0AbA6Th0P5Mt/uCt6f6t+sbp+eZC+p5vEFbmjHACEC7dA8gB8ThCKQB
		A7gAu8XBwI2gjCLBBVygCoxADqRhwqWhCsSBBSIBGnJAGlxgCgY8SzHABXqlV1YguyOBxFP8vf0s
		vsdjvo06r+1bxhX5a/YGA45pvrj/6Zu+6btNXMGlQcFXAMilwZ2OoFeIPAc6wQWKAAOOLBKOYAks
		wQUiYQUiIRJK1wWEnMitPAcigRIooVeOgMNTnMzLnMQPrcXv4sW7esbbPF8BSwr8jBqp0czrXBwo
		B8/zXM/z/BqWQBb2HNApZ3ICndDx3M7LnNB0G6/dnNFLWSri3M8OvdAJfREqvdLxfAowgBQmfdIt
		3dI5fc8PXRxyW6sXvdFPPZEfnVfMvNM93dVfHdZjXdZnndZffdLrPNCG2tRRndfJmAtYgBKAnMQD
		vdZdHRKOHdmTHdmLXdaV3dmXndkvPdQRHb7Vedd7HdszNy6lIc8xwA60IQNm3dmj/yADnv3YRcEO
		vl0bzJ3djz0DogAS0OAN3qAVjn0V6r3dzZ3Wp/3Mq32Qrz3bA15IxWFRSIDbVcHStUEWXCDcFyHf
		j10bVuEGbkDiJ97ibyAKSuEGWuHiV+Hh7d0OMF7jQz4DEEAQLh7lL/7jY13PVZzF/33Ny1rgZ777
		eqVyZIE1XX3dyT0D3iAD5P0NzGHegd5C3sAONL4VECAK0EAbTn7iV+ENosAHVkEboiDp553eoyDo
		jd7nL/4NbsAHoiAKBAENVmEVnD7l0z7t293V89zlQQPm2bi3aZ7uifDOBf0hwz3Zv13j390OMgDc
		BUEbWqEU0r3nfeANSqEJeKAGdP+hBuwhFyI/F5ggFirf8mPhATJf8zef8zP/8i+fCSJfBA7hEIhB
		F3AgHhShCVZ/9dU+5Z297Smn3+GeigG+7m9/7WyechZBFtBgAgRB2bXB4qPeDso+6FchHazAHiCf
		CSi/858f+qNf+qd/8yu/+XPBHkyfB1i/9V0/2T1d9nvl5X/X9nHf/LlN9ysdEirkWi8+CuwgClbf
		DqygACbf+ak/Fig/9EVABAqgAGoAIGrUsEIwXTo7Pnxoe5PBjjZtGW5IbGXHiRKCFXQRs8dRRK5c
		TJjEGvmgpMmTD2IxyXXoGDVFTWLGlEjzBqSbixapUiWu54GfB/gIHUq0qNGjSJP/Kl3KtKnTp0Jf
		ebBAVZlVZVLIWPjHtavXr2DDih1LtqzZs2jTql3Ltq3bt3Djyp1Lt65duj135rx5w1wrQTJj4jiU
		KxbKkypziThETAaPwDVrNolM+SYkm3wpa5YYOKYiHjKIHfIo0vDhxMRwwIRME6fOnuKAQp1Nu7bt
		20ulUrVwFavWu8CDCx9OvLjx48iTK2crTm/mJj6cCFIkQ4RplCpFNI4nc7P3ypbDix9/+bv3zk3i
		hSZ9vWR2Xdy7Y87J0+dP3Pjz69/PR3fVq1lttdyABBZo4IEIJqjgXM2psshzijhxiEgoMaHdY+iZ
		JxF5HFqW04cgPtjheBregJ5n/zgQIwKFJsWSyzHxTYbTTvYFxd+NOOZoFBK7XYWEbwIuKOSQRBZp
		5JFI/tPcXpxRY91JTByimiKrdfbdiOSFqOWWIGIp3nfoUUmleoRdF4s91Mw0I0+y6ejmm/lxcc6c
		57hhJwsBJqnnnnz26eefXTX4oETx2GOaizLEo+g39hwiQ5UzERpPa1hyuWUT4YR4wzff3HBpOIos
		wsM34diE6U3xHHIINapac4irr6aZHqiK4PCoIorqUphJhyiyoU713QfnsMQ+xQgjP+20i515Aurs
		s9BGK61cgl7WBBMlMWENFWIo6m2v3+AQWKngZWmppTccstO6OPAg0aWH8LCINf+LyIADJK5aZu8N
		4eCQLqYyYCquNfGIaQ0O3irKAzGmMeEuJPTVWOzEFBt1bE+7MMDAnM1O6/HHIIfs55KD5pISMTxY
		1G3C9sjwDQ/xWPNyLpx+Q3DMo4YTzjfxvJwTDgf3PCmnNvEMCdGjfgPJzjtZY88iPUMCNA4fUkPN
		ItTIIAMkPPAQjr7UQCIDNTdYc4O9MR0Mqgyr8nBzwooeYpgI89HYZsV4F3uxOBlvfE7HIgcu+OCE
		H0fyZSUdg6vKcKu69mLUfKOICIoc/OrLOLT7Kr3zKm2PNeFYLVE4TWRuzw08+Muz5DshHI+/Ln8D
		Yrui9ssqD6ffNLbY/pqNdhP/oKsGetxwe6sIMSnVzaaweTf/5t59c/xb4dRXb/31aB1+Q0nELK7E
		yt9Wrt6tBJtta6eKQPIqvpA0kZPV8y5SethHix1PpqlDYk8T1GS6iOv3Gpu8PoSDq9ELB/2qDmay
		tjR3ma1fTRhbv2olJUUconiKOl7y1hQb5jnvgzfam8b8BjjsmfCEKBSZ9kx2JmowzluMApU1kqYI
		Uh0CU+HoGQ+4tkOvDVBnUMvh0vwHKvVBzGvh8FqoFhEOet2PiTIA0Tei6LUovi88o5oU275xuTTV
		0II8kwF8ioe7ktCNg3cDoRrzs7djMUJ6QUqhHOdIRz5V6wbxMNkDosSthGnt/49/zJwgB0mNAlqt
		kDw4pNUS2TVFUoORXetaPCJJSUo6UpGpu6QgC1nIQdrKVjKwxxS1JoKXJYwHcitJLiYFsdd00EZr
		jOVt5FSGWtayBLcoYR13ycteEuiON7DgoZgAI0XJQGfIDAcgl8lMTzrzmdCMpjSjycxq/jGZOoPZ
		wnZ1Ml/ZBFj2kaU4baOMepjznJSwgC59yc52urMu2jMR7trDBHvAR0wn8o6XRnSuveyTQ+cJE5V4
		oAt7sCglvVITxOzmwXE6lCk/IAMflOEBD5AhApRY5zs3ytGOkqVa5WlChCqALeywRDX51NA/V7rS
		Ep2IOoQ5aEpyoYsqKU9iD//N6VIi+hML/MAGUsjo9DxK1KIaFaScic50QilT96zkELrgAaRKRFXM
		hKeqVJWJIqhxjJiSBDEnnep8XPlKnZoVKRHlgw3+8Acb1EOocTSqXOfqy7w4SER9+UtnttnUFoUk
		F406BsJYg9XCBjQmr+uqR0DSHsRY6BhStRKlIobTs1p2KGmVwhLk4Fa40vWzoK2jXf2JhlZEhCbo
		IehoSnMY7Kjkr4pZDGOOcQyttct4k0EtrhSWNTEeQzSHsMdiQ8La1rYoO43BEGEp1Uoa1QiWl7Us
		Tw/wgx9klBL1+EFcQ8vd7hZutA8iRShakZnNdKZWoiFNcY3L3va6970p+ev/YlxiU/OEB0TOfSV0
		o3vW6k7UojaIBCVs8APvGvjAhGuQg2QxBVGI6KpYDQxoNBLcxYKEuCPJcIZPo+EME1e+iyEGMWqr
		XMOOJ0Trgg1Q9stfs1qADB6IqA1sEIEOwBjBOM6xx+x6DQaLYgIZCLIghkzkIhv5yEhOspKXzOQm
		O9nIQY5yBqRB5SpLQwpYzrKWt8zlLnv5y2AOs5jHTOYym7keNoDxdnXM5jbrKS89ngIJSCCKOtd5
		AnjOs5713Io++/nPgA60oAdN6EIHes+IzrOdF92JTsz50ZSItKTJQOlKW/rSmM60pjfN6U57+tOg
		DvWnqzsVN5v61G82ghF6/ywLBk/h1aSItazRQOta2/rWuM61rnfN6173WtbAfvWrW01sFhj72BVN
		9lR2w+xmO/vZ0I62tKdN7Wpb+9rWRrW2t10kcXBB1au+BquJTe5yA/vc6E63utfN7nafu9zwJre4
		5w3uejOb2/jOt74XBBsFr+vfeumnwAdOcIID/OD5Fce+F87whg+p37BBuMQBzqWJW/yuWrq4xCEO
		G4d7/OMgRxDH+63xkpv85AmHeMhXzvKWK2jkMI+5zGc+c5fb/OY4z7nOd87znvv850APutCHTvSi
		G/3oSE+60pfO9KY7/elQj7rUp071qlv96ljPuta3zvWue/3rYA+72MdO9jOym/3saE+72tfO9ra7
		/e1wj7vc5073utv97njPu973zve++/3vgA+84AdP+MIb/vB6CggAOw==
		"""

def fileToDict(file, delimiter, key_col):
	d = {}
	try:
		f = open(r"{}".format(file))
	except:
		return(0)
	else:
		for line in f:
			line_seg = line.split("{}".format(delimiter))
			for x,y in enumerate(line_seg):
				if x == key_col:
					continue
				else:
					if line_seg[key_col].strip() in d:
						d[line_seg[key_col].strip()].append(y.strip())
					else:
						d[line_seg[key_col].strip()] = [y.strip()]
		f.close()
	return(d)
			
def arraysToStr(array, str):
	# Error Checking, if not array type
	if not isinstance(array, type([])):
		if str == '':
			return("{}".format(array))
		else:
			return("{}\t{}".format(str, array))
	
	for a in range(len(array)):
		if not isinstance(array[a], type([])):
			if str == '':
				str = "{}".format(array[a])
			else:
				str = "{}\t{}".format(str, array[a])
		else:
			str = arraysToStr(array[a], str)
	return(str)

def saveDictAs(dict, file, a01, k01):			# Dictionary, Save File, Arrays? Print Keys?
	try:
		save = open(r"{}".format(file))			# Do not Overwrite existing files
	except:
		save = open(r"{}".format(file), 'w')	# No existing file, go ahead write
	else:
		print("Can\'t save over existing files, specify new dictionary save file name!")
		save.close()
		return(0)								# Quit function, return false, zero
	
	for keys in dict:
		if a01 == 1:				# Arrays present in dict? Separate via tab
			str = ''
			if k01 == 1:			# Include key as first col. in output file?
				str = keys
			out_str = arraysToStr(dict[keys], str)
			save.write("{}\n".format(out_str))
		else:
			if k01 == 1:
				save.write("{}\t{}\n".format(keys, dict[keys]))
			else:
				save.write("{}\n".format(dict[keys]))
	save.close()
	return(1)									# Success
	
def w1(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(page, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	pina_img = PhotoImage(data=img_dict["pina_help"])
	pLab = ttk.Label(page, text="To download the PINA database, click on the url in the main window or enter the URL in a browser.  Select the \"Statistics & Download\" link, then download the Human database (MITAB format).\n", justify=LEFT, wraplength=580, compound=BOTTOM, image=pina_img)
	pLab.photo = pina_img
	pLab.grid(row=0, column=1)
	ttk.Label(page, text="\nAccessed: August 2nd, 2011").grid(row=1, column=1, sticky=SW)
	
def w2(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(page, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	uni_img = PhotoImage(data=img_dict["uni_help"])
	uLab = ttk.Label(page, text="On the www.uniprot.org website, paste the copied Uniprot Accession IDs into the text entry or upload the saved file, map, then download the \"mapping table\" and the \"not mapped\" files.\n", justify=LEFT, wraplength=700, compound=BOTTOM, image=uni_img)
	uLab.photo = uni_img
	uLab.grid(row=0, column=1)
	ttk.Label(page, text="\nAccessed: August 3rd, 2011").grid(row=1, column=1, sticky=SW)

def w3(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(page, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text="From the Gene section of the National Center for Biotechnology Information website select the \"Download\" link and navigate to the Homo sapiens, human, (*.gene_info.gz) zipped file.  Unzip to a local directory and load the (*.gene_info) file into the guide.", justify=LEFT, wraplength=700).grid(row=0, column=1, sticky=W)
	ncbi_img = PhotoImage(data=img_dict["ncbi_g"])
	ncbi = ttk.Label(page, image=ncbi_img)
	ncbi.photo = ncbi_img
	ncbi.grid(row=1, column=1)
	ttk.Label(page, text="Accessed: August 5th, 2011").grid(row=2, column=1, sticky=SW)

def w4(root):
	root.page1 = ttk.Frame(root, padding="20")
	root.page2 = ttk.Frame(root, padding="20")
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(root.page1, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(root.page1, text="On the National Center for Biotechnology Information website select the tools link, then scroll down to the \"Batch Entrez\" link.  This method looks for the UniProt IDs that were not directly mapped to a Gene ID.", justify=LEFT, wraplength=700).grid(row=0, column=1, sticky=W)
	ncbi_1_img = PhotoImage(data=img_dict["ncbi_b1"])
	ncbi_1 = ttk.Label(root.page1, image=ncbi_1_img)
	ncbi_1.photo = ncbi_1_img
	ncbi_1.grid(row=1, column=1)
	ttk.Label(root.page1, text="Accessed: August 5th, 2011").grid(row=2, column=1, sticky=SW)
	
	ttk.Label(root.page2, image=help.photo).grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(root.page2, text="From the UniProt mapping, upload the (*.not) file, select \"Protein\" from the dropdown menu, scroll down to the bottom of the results, continue to the results, then save the results as a GenPept file (*.gp).", justify=LEFT, wraplength=700).grid(row=0, column=1, sticky=W)
	ncbi_2_img = PhotoImage(data=img_dict["ncbi_b2"])
	ncbi_2 = ttk.Label(root.page2, image=ncbi_2_img)
	ncbi_2.photo = ncbi_2_img
	ncbi_2.grid(row=1, column=1)
	ttk.Label(root.page2, text="Accessed: August 5th, 2011").grid(row=2, column=1, sticky=SW)

def w5(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(page, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text="After searching for the non-mapped gene symbol in the text box, enter the correct gene symbol AND related gene ID (i.e. GeneID:3269, Gene Symbol:HRH1), the update button will correct it in the dictionary.", justify=LEFT, wraplength=300).grid(row=0, column=1, sticky=W)

def w6(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	
	help_32_img = PhotoImage(data=img_dict["help_32"])
	help = ttk.Label(page, image=help_32_img)
	help.photo = help_32_img
	help.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text="After searching the gene ID, if the ID is outdated or has been withdrawn, then press the \"Ignore\" button to disregard all \" - \" mappings of the UniProt ID to the specific gene ID. This will remove the specific UniProt ID mapping from the dictionary.", justify=LEFT, wraplength=300).grid(row=0, column=1, sticky=W)

def w_note(root):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	note_32_img = PhotoImage(data=img_dict["note_32"])
	notify = ttk.Label(page, image=note_32_img)
	notify.photo = note_32_img
	notify.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text="Make sure to map from \"UniProtKB AC/ID\" to \"Entrez Gene (Gene ID)\".", wraplength=300, justify=LEFT).grid(row=0, column=1)
	
def w_err(root, string):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	note_32_img = PhotoImage(data=img_dict["note_32"])
	notify = ttk.Label(page, image=note_32_img)
	notify.photo = note_32_img
	notify.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text=string, wraplength=300, justify=LEFT).grid(row=0, column=1)

def w_good(root, string):
	page = ttk.Frame(root, padding="20")
	page.grid(row=0, column=1)
	good_32_img = PhotoImage(data=img_dict["good_32"])
	notify = ttk.Label(page, image=good_32_img)
	notify.photo = good_32_img
	notify.grid(row=0, column=0, sticky=NW, ipadx=10)
	ttk.Label(page, text=string, wraplength=300, justify=LEFT).grid(row=0, column=1)
	
def main(root):
	root.page1 = ttk.Frame(root, padding="20")
	root.page2 = ttk.Frame(root, padding="20")
	root.page3 = ttk.Frame(root, padding="20")
	root.page4 = ttk.Frame(root, padding="20")
	root.page5 = ttk.Frame(root, padding="20")
	root.page6 = ttk.Frame(root, padding="20")
	root.page7 = ttk.Frame(root, padding="20")
	root.page8 = ttk.Frame(root, padding="20")
	
	
	# Images
	# - Icons
	help_img = PhotoImage(data=img_dict["help"])
	help_img_h = PhotoImage(data=img_dict["help_h"])
	help_img_d = PhotoImage(data=img_dict["help_d"])
	good_img = PhotoImage(data=img_dict["good"])
	bad_img = PhotoImage(data=img_dict["bad"])
	note_img = PhotoImage(data=img_dict["note"])
	note_img_h = PhotoImage(data=img_dict["note_h"])
	note_img_d = PhotoImage(data=img_dict["note_d"])
	refresh_img = PhotoImage(data=img_dict["refresh"])
	down_img = PhotoImage(data=img_dict["drop"])
	
	# - Large$
	intro_img = PhotoImage(data=img_dict["intro"])
	gene_img = PhotoImage(data=img_dict["gene_info"])
	clean_img = PhotoImage(data=img_dict["clean"])
	
	# Page 1, Title Screen		
	ttk.Label(root.page1, text="Welcome to PPI Cleaner:\n\t(P)rotein-(P)rotein (I)nteraction Cleaner\n\nThis is a guide to processing the Protein Interaction Network Analysis (PINA) human dataset, and an automated tool to generate a non-redundant human protein interaction database reference.\n", wraplength=400, justify=(LEFT)).grid(column=0, row=0, columnspan=2, sticky=(N, W, E))
	#ttk.Label(root.page1, text="", wraplength=400, justify=LEFT).grid(column=0, row=1, sticky=(N, W, E))
	root.intro = Label(root.page1, text="Automating Network Generation and Analysis", compound=TOP, image=intro_img)
	root.intro.photo = intro_img
	root.intro.grid(column=0, row=4, columnspan=2)
	ttk.Separator(root.page1, orient=HORIZONTAL).grid(column=0, row=2, columnspan=2, sticky=(W,E))
	ttk.Label(root.page1, text=" ").grid(row=3, column=0)
	
	# Page 2, Load Pina database, display unique uniprot ID's
	ttk.Label(root.page2, text="Please download the human PINA database from the link below:", wraplength=400).grid(row=0, column=0, columnspan=2, sticky=W)
	root.linkf_1 = ttk.Frame(root.page2)
	root.linkf_1.grid(row=1, column=0, columnspan=2)
	link1 = ttk.Label(root.linkf_1, text="http://cbg.garvan.unsw.edu.au/pina/")
	link1.grid(row=0, column=0, sticky=E)
	WebLinks(link1, "http://cbg.garvan.unsw.edu.au/pina/")
	
	help = ttk.Label(root.linkf_1, image=help_img)
	help.photo = help_img
	help.photo_h = help_img_h
	help.photo_d = help_img_d
	help.grid(row=0, column=1, sticky=W)
	FramePop(create="w1", title="PINA Online", label=help, photo=help.photo, hover=help.photo_h, down=help.photo_d)
	
	ttk.Label(root.page2, text="\nLoad PINA PPI data (*.txt)").grid(column=0, row=2, sticky=(S,W))
	ttk.Entry(root.page2, width=54, textvariable=root.pina_in).grid(column=0, row=3, sticky=(E,W))
	ttk.Button(root.page2, text="Open", command=(root.page2.register(root.dia_file), "self.pina_in")).grid(column=1, row=3, sticky=E)
	ttk.Label(root.page2, text="").grid(row=4, column=0)
	results = ttk.Labelframe(root.page2, text="", padding="20 5 20 10")
	results.grid(column=0, row=5, columnspan=2)
	ttk.Button(results, text="Get Unique UniProt IDs", command=(root.page2.register(root.pina_ids), "pina_in", "St1", "unq_uID")).grid(column=0, row=0, sticky=NW)
	
	ttk.Label(results, text="").grid(column=0, row=1)
	
	root.St1 = ScrolledText(results, width=12, height=11)
	
	root.St1.grid(column=0, row=2, sticky=EW)
	root.St1.insert('1.0', root.unq_uID)
	ttk.Label(results, text="   ").grid(column=1, row=2)
	ttk.Label(results, textvariable=root.pina_res_ids, wraplength=60).grid(column=2, row=2, sticky=NE)
	
	ttk.Label(results, text="").grid(column=0, row=3)
	
	lab_y = "self.spina_good.config(image=self.spina_good.photo)"
	lab_n = "self.spina_good.config(image=self.pina_good.photo_b)"
	ttk.Button(results, text="Save IDs", command=(root.page2.register(root.save_text), "self.St1.get(1.0, END).strip()", lab_y, lab_n)).grid(column=0, columnspan=3, row=4)
	
	root.pina_good = ttk.Label(results, image=None)			# Grabbed Uniprot IDs correctly
	root.pina_good.photo = good_img
	root.pina_good.photo_b = bad_img
	root.pina_good.grid(column=2, row=0, sticky=E)
	root.spina_good = ttk.Label(results, image=None)		# Saved IDs to a file
	root.spina_good.photo = good_img
	root.spina_good.grid(column=2, row=4, sticky=E)
	
	# Page 3, Gene Info Dictionary Creation
	ttk.Label(root.page3, text="Instructions for downloading NCBI Human gene annotation file:").grid(row=6, column=0, columnspan=2, sticky=W)
	root.linkf_3 = ttk.Frame(root.page3)
	root.linkf_3.grid(row=7, column=0, columnspan=2)
	link3 = ttk.Label(root.linkf_3, text="http://www.ncbi.nlm.nih.gov/gene/")
	link3.grid(row=0, column=0, sticky=E)
	WebLinks(link3, "http://www.ncbi.nlm.nih.gov/gene/")
	help3 = ttk.Label(root.linkf_3, image=help_img)
	help3.grid(row=0, column=1, sticky=W)
	FramePop(create="w3", title="NCBI gene Info", label=help3, photo=help.photo, hover=help.photo_h, down=help.photo_d)
	ttk.Label(root.page3, text="\nHuman gene file location (*.gene_info)").grid(column=0, row=8, sticky=W)
	ttk.Entry(root.page3, width=54, textvariable=root.gene_in).grid(column=0, row=9, sticky=(E,W))
	ttk.Button(root.page3, text="Open", command=(root.page3.register(root.dia_file), "self.gene_in")).grid(column=1, row=9, sticky=E)		
	
	ttk.Label(root.page3, text="").grid(column=0, row=11)
	
	genein = ttk.Labelframe(root.page3, text="", padding="20 5 20 10")
	genein.grid(column=0, columnspan=2, row=12, sticky=EW)
	ttk.Button(genein, text="Load Genes", command=(root.page3.register(root.load_gene))).pack(side=LEFT)
	root.gene_good = ttk.Label(genein, image=None)
	root.gene_good.photo = root.pina_good.photo
	root.gene_good.photo_b = root.pina_good.photo_b
	root.gene_good.pack(anchor='e')
	
	genimg = ttk.Label(root.page3, text="\n\n\n\n", compound=BOTTOM, image=gene_img)
	genimg.photo = gene_img
	genimg.grid(column=0, columnspan=2, row=13)
	
	# Page 4, Directions for Uniprot Mapping
	ttk.Label(root.page4, text="Instructions for UniProt Accession ID mapping to Entrez Gene ID:").grid(row=0, column=0, columnspan=2, sticky=W)
	root.linkf_2 = ttk.Frame(root.page4)
	root.linkf_2.grid(row=1, column=0, columnspan=2)
	link2 = ttk.Label(root.linkf_2, text="http://www.uniprot.org/")
	link2.grid(row=0, column=0, sticky=E)
	WebLinks(link2, "http://www.uniprot.org/")
	help2 = ttk.Label(root.linkf_2, image=help_img)
	help2.grid(row=0, column=1, sticky=W)
	FramePop(create="w2", title="UniProt Online", label=help2, photo=help.photo, hover=help.photo_h, down=help.photo_d)
	note = ttk.Label(root.linkf_2, image=note_img)
	note.photo = note_img
	note.photo_h = note_img_h
	note.photo_d = note_img_d
	note.grid(row=0, column=2, sticky=W)
	FramePop(create="w_note", title="Caution", label=note, photo=note.photo, hover=note.photo_h, down=note.photo_d)
	
	# ttk.Label(root.page4, text="Make sure to download the not-mapped file (*.not).\nThe next page has instructions to find the missing gene information.", wraplength=400, justify=LEFT).grid(column=0, columnspan=2, row=2, sticky=SW)
	# ttk.Label(root.page4, text="Go to the website above, copy the PINA unique IDs from the previous page, paste the IDs in the \"Database identifiers\" section of the \"ID Mapping\" tab, and map.", wraplength=400, justify=LEFT).grid(row=2, column=0, columnspan=2)
	ttk.Label(root.page4, text="\nEnter the mapping table file (*.tab)").grid(column=0, row=3, sticky=(S,W))
	ttk.Entry(root.page4, width=54, textvariable=root.map_in).grid(column=0, row=4, sticky=(E,W))
	ttk.Button(root.page4, text="Open", command=(root.page4.register(root.dia_file), "self.map_in")).grid(column=1, row=4, sticky=E)
	
	ttk.Label(root.page4, text="").grid(column=0, row=12)
	
	mapping = ttk.Labelframe(root.page4, text="Map UniProt IDs to gene IDs and gene symbols", padding="20 5 20 10")
	mapping.grid(column=0, columnspan=2, row=15, sticky=EW)
	ttk.Button(mapping, text="Load Info", command=(root.page4.register(root.map_gene))).grid(row=0, column=0, sticky=W)
	root.map_good = ttk.Label(mapping, image=None)
	root.map_good.grid(row=0, column=3, sticky=E)
	
	ttk.Label(mapping, text="").grid(row=2, column=0)
	
	ttk.Label(mapping, textvariable=root.g1_res, wraplength=350, justify=LEFT).grid(row=0, column=2, sticky=E)
	
	sdict = {1:"  ->  ", 2:"  =  "}
	titles = ["UniProt ID", "Gene ID", "Gene symbol"]
	root.g1Texts = TextScrolledLink(master=mapping, num=3, spacers=sdict, width=11, height=8, xview=True, titles=titles)
	root.g1Texts.grid(row=3, column=0, columnspan=4)
	ttk.Label(mapping, text="").grid(row=4, column=0)
	root.refresh = ttk.Button(mapping, text="Switch View", image=refresh_img, compound=LEFT, command=(root.page4.register(root.text_switch), "g1Texts"))
	root.refresh.photo = refresh_img
	root.refresh.grid(row=5, column=0, sticky=W)
	root.refresh.grid_remove()
	root.refresh_note = ttk.Label(mapping, textvariable=root.g1_res_note)
	root.refresh_note.grid(row=5, column=2, columnspan=2, sticky=E)
	root.refresh_note.grid_remove()
	
	
	# Page 5, Directions for NCBI Batch Entrez
	ttk.Label(root.page5, text="Finding unmapped UniProt IDs from a Batch Entrez search:").grid(row=0, column=0, columnspan=2, sticky=W)
	root.linkf_4 = ttk.Frame(root.page5)
	root.linkf_4.grid(row=1, column=0, columnspan=2)
	link4 = ttk.Label(root.linkf_4, text="http://www.ncbi.nlm.nih.gov/gene/")
	link4.grid(row=0, column=0, sticky=E)
	WebLinks(link4, "http://www.ncbi.nlm.nih.gov/gene/")
	help4 = ttk.Label(root.linkf_4, image=help_img)
	help4.grid(row=0, column=1, sticky=W)
	FramePop(create="w4", nav=True, title="NCBI Batch Entrez", label=help4, photo=help.photo, hover=help.photo_h, down=help.photo_d)
	
	ttk.Label(root.page5, text="\nEnter the Entrez search results (*.gp)").grid(column=0, row=3, sticky=(S,W))
	ttk.Entry(root.page5, width=54, textvariable=root.gp_in).grid(column=0, row=4, sticky=(E,W))
	ttk.Button(root.page5, text="Open", command=(root.page5.register(root.dia_file), "self.gp_in")).grid(column=1, row=4, sticky=E)
	
	ttk.Label(root.page5, text="").grid(column=0, row=10)
	
	parsing = ttk.Labelframe(root.page5, text="Parse and check NCBI Entrez search result", padding="20 5 20 10")
	parsing.grid(column=0, columnspan=2, row=15, sticky=EW)
	ttk.Button(parsing, text="Parse", command=(root.page5.register(root.parse_gp))).grid(row=0, column=0, sticky=W)
	ttk.Label(parsing, textvariable=root.gp_res, wraplength=350, justify=LEFT).grid(row=0, column=2, sticky=E)
	
	root.gp_good = ttk.Label(parsing, image=None)
	root.gp_good.grid(row=0, column=3, sticky=E)
	
	ttk.Label(parsing, text="").grid(column=0, row=2)
	
	root.g2Texts = TextScrolledLink(master=parsing, num=3, spacers=sdict, width=11, height=8, xview=True, titles=titles)
	root.g2Texts.grid(row=3, column=0, columnspan=4)
	
	ttk.Label(parsing, text="").grid(column=0, row=4)
	
	root.gp_upFrame = ttk.Frame(parsing, padding="0 0 0 10")
	root.gp_upFrame.grid(row=6, column=0, columnspan=4)
	root.gp_upFrame.grid_remove()
	ttk.Button(root.gp_upFrame, text="Update", command=(root.page5.register(root.gp_update))).grid(row=0, column=0, sticky=W)
	help5 = ttk.Label(root.gp_upFrame, image=help_img)
	help5.grid(row=0, column=1, sticky=W)
	FramePop(create="w5", title="Updating UniProt Gene Info", label=help5, photo=help.photo, hover=help.photo_h, down=help.photo_d)
	root.gp_update_good = ttk.Label(parsing, image=None)
	root.gp_update_good.grid(row=6, column=3, sticky=NE)
	
	root.gp_valid = ttk.Button(parsing, text="Switch View", image=refresh_img, compound=LEFT, command=(root.page5.register(root.text_switch), "g2Texts"))
	root.gp_valid.photo = refresh_img
	root.gp_valid.grid(row=7, column=0, sticky=W)
	root.gp_valid.grid_remove()
	root.gp_valid_note = ttk.Label(parsing, textvariable=root.gp_res_note)
	root.gp_valid_note.grid(row=7, column=2, columnspan=2, sticky=E)
	root.gp_valid_note.grid_remove()
	
	# Page 6, Compile and Save Clean Pina
	clean = ttk.Label(root.page6, image=clean_img)
	clean.photo = clean_img
	ttk.Label(root.page6, text="Select the exclusion methods and output columns below, then clean the PINA data.\n",wraplength=360).grid(row=0,column=1,columnspan=2,sticky=EW)
	
	pinaLab = ttk.Labelframe(root.page6, text="Clean PINA Options", padding="20 5 20 10")
	b = {"image":down_img,"text":"Exclude Methods","compound":RIGHT}
	l = {"selectmode":EXTENDED,"width":20,"height":10}
	root.l_meth = ListDropDown(master=pinaLab, b_kws=b, selectmode=EXTENDED,width=25,height=10,exportselection=0)
	root.l_meth.button.bind("<Button-1>", lambda e: root.meth_get("meths"), "+")
	root.l_meth.good = ttk.Label(pinaLab, image=None)
	root.l_meth.good.photo = good_img
	root.l_meth.good.photo_b = bad_img
	b = {"image":down_img,"text":"Output Columns","compound":RIGHT}
	root.l_cols = ListDropDown(master=pinaLab, b_kws=b, selectmode=EXTENDED,width=25,height=10,exportselection=0)
	root.l_cols.button.bind("<Button-1>", lambda e: root.meth_get("cols"), "+")
	root.l_cols.good = ttk.Label(pinaLab, image=None)
	
	root.clean_bt = ttk.Button(root.page6,text="Clean PINA",command=(root.page6.register(root.on_button)))
	root.clean_good = ttk.Label(root.page6, image=None)
	root.prog_clean = ttk.Progressbar(root.page6,orient=HORIZONTAL,length=200,mode="determinate",variable=root.prog_c)
	
	clean.grid(row=0, column=0, padx=20, sticky=N)
	pinaLab.grid(row=2,column=0, columnspan=3, sticky=(EW))
	root.l_meth.pack(side=LEFT)
	root.l_meth.good.pack(side=LEFT)
	root.l_cols.pack(side=RIGHT)
	root.l_cols.good.pack(side=RIGHT)
	root.clean_good.grid(row=9,column=2,padx=20,sticky=E)
	root.prog_clean.grid(row=9,column=0, columnspan=3)
	Label(root.page6, text="").grid(row=8, pady=20)
	root.clean_bt.grid(row=10,column=0, pady=40, columnspan=3)

	
	# Page 7, Results, Lookup specific Uniprots (not found) modify
	ttk.Label(root.page7, text="Review the cleaned PPIs below, save the cleaned data and use it in conjunction with the DrugBank search tool.",wraplength=400).grid(row=0,column=0,columnspan=2,sticky=W)
	root.cleanText = TextScrolledLink(root.page7, xview=True, width=40, height=20)
	ly = "self.sc_good.config(image=self.pina_good.photo)"
	ln = "self.sc_good.config(image=self.pina_good.photo_b)"
	root.saveClean = ttk.Button(root.page7, text="Save As", command=(root.page7.register(root.save_cpna), ly, ln))
	root.sc_good = ttk.Label(root.page7, image=None)
	
	root.cleanText.grid(row=2, column=0, columnspan=2, padx=30, pady=20)
	root.saveClean.grid(row=3, column=0, columnspan=2)
	root.sc_good.grid(row=3, column=1, columnspan=2, sticky=E)
	
	# Page 8, Congratulations, Finished
	ttk.Label(root.page8, image=intro_img).grid(row=0, column=0, columnspan=2, sticky=N)
	ttk.Label(root.page8, text="\n\nThank you for using PPI Cleaner, you are now finished.\n\nCreated by Paul Hart for\nVanderbilt University Department of Biomedical Informatics\nVersion 1.00 August 28, 2011.",wraplength=400, justify=CENTER).grid(row=1,column=0,columnspan=2)
	
			
class Application(Frame):
	def meth_get(self, var):
		global errMess
		
		self.l_meth.exclude = ["-", "unspecified method", "inferred by author", "inferred by curator",
					"structure based prediction", "interaction prediction", "experimental knowledge based",
					"domain profile pairs", "interologs mapping", "text mining", "confirmational text mining",
					"predictive text mining", "genome based prediction", "domain fusion", "gene neighbourhood",
					"phylogenetic profile", "sequence based phylogenetic profile", "sequence based prediction",
					"correlated mutations", "docking", "inference"]
		if hasattr(self.l_meth, "meths"):
			if var == "meths":
				self.l_meth.good.config(image="")
			else:
				self.l_cols.good.config(image="")
		else:
			try:
				p = open(r"{}".format(self.pina_in.get()))
			except:
				if var == "meths":
					self.l_meth.good.config(image=self.l_meth.good.photo_b)
				else:
					self.l_cols.good.config(image=self.l_meth.good.photo_b)
				errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
				errMess = errMess + "- The PINA file was not loaded correctly"
				FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
				errMess = ""
			else:
				self.l_meth.good.config(image=self.l_meth.good.photo)
				self.l_cols.good.config(image=self.l_meth.good.photo)
				setattr(self.l_meth, "meths", {})
				setattr(self.l_cols, "cols", {})
				method_set = set([])
				i = 0
				for line in p:
					line_seg = line.split("\t")
					if i == 0:
						for a in range(len(line_seg)):
							self.l_cols.cols[a] = line_seg[a]
							self.l_cols.insert(END, line_seg[a])
						for a in range(4):
							self.l_cols.itemconfig(a,bg="#AADDFF",fg="#999",selectbackground="#AADDFF",selectforeground="#999")
						i = 1
						continue
					methods = line_seg[6].split("|")
					for a in methods:
						method_set.update(set([a.strip()]))
				p.close()
				i=0
				for a in method_set:
					key = a
					try:
						key = a[a.index("(")+1:a.rindex(")")]
					except:
						pass
					self.l_meth.meths[i] = [key, a]
					self.l_meth.insert(END, key)
					if key in self.l_meth.exclude:
						self.l_meth.itemconfig(i,bg="#AADDFF",fg="#999",selectbackground="#AADDFF",selectforeground="#999")
					i += 1
				#print(self.l_meth.get(1, END))
		
	def save_cpna(self, label_y, label_n):
		global errMess
		sfile = tF.asksaveasfile()
		if sfile != None:
			s = open(r"{}".format(sfile.name), 'w')
			if hasattr(self.cleanText.text0, "strs"):
				for a in self.cleanText.text0.strs:
					s.write(a)
				if label_y != None:
					eval(label_y)
				s.close()
			else:
				errMess = "Sorry, but there is no text to save, please load the PINA data and get the unique IDs."
				FramePop(create="w_err", varPass="self, errMess", title="Error: No Selection")
				errMess = ''
				eval(label_n)
			# results = "Congratulations, you saved the UniProt IDs in the file:\n\n{}".format(sfile.name)
			# FramePop(create="w_good", varPass="self, results", title="Success")
			# results = ''
		else:
			if label_n != None:
				eval(label_n)
	
	def callback(self):
		self.clean_bt.config(state=NORMAL)
		self.b.config(state=NORMAL)
		self.n.config(state=NORMAL)
		self.l_meth.button.config(state=NORMAL)
		self.l_cols.button.config(state=NORMAL)
	
	def on_button(self):
		global errMess
		err_strs = []
		# err = [ ["file/variable/object", "var str", "err-message", "special case?"], [etc...] ]
		err = [["f", "pina_in", "- PINA database could not be opened"],
				["v", "d_gp_map", "- GenPept file information was not loaded, page 5."],
				["v", "d_mapped", "- UniProt IDs from the mapping table were not loaded, page 4."]]
		for a in err:
			try:
				if a[0] == 'f':
					f = getattr(self, a[1]).get()
					o = open(r"{}".format(f))
				if a[0] == 'v':
					getattr(self, a[1])
			except:
				err_strs.append(a[2])
				# print(sys.exc_info())
			else:
				# if len(a) == 4:		# Special cases
				if a[0] == 'f':
					o.close()

		if len(err_strs) > 0:
			errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
			for a in err_strs:
				errMess = errMess + "{}\n".format(a)
			FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
			errMess = ""
			self.clean_good.config(image=self.pina_good.photo_b)
		else:
			self.clean_bt.config(state=DISABLED)
			self.b.config(state=DISABLED)
			self.n.config(state=DISABLED)
			self.l_meth.button.config(state=DISABLED)
			self.l_cols.button.config(state=DISABLED)
			thd = Thread(self.compile, self.callback)
			thd.start()
	
	def compile(self):
		p = open(r"{}".format(self.pina_in.get()))
		lines = 0
		for line in p:
			lines += 1
		p.close()
		
		d_all = {}
		d_not = {}
		d_all.update(self.d_mapped)
		d_all.update(self.d_gp_map)
		exclude = set([])
		cols = set([0,1,2,3])
		try:
			getattr(self.l_meth, "meths")
		except:
			pass
		else:
			for a in self.l_meth.curselection():
				exclude.update(set([self.l_meth.meths[int(a)][1]]))
			for a in range(len(self.l_meth.get(1,END))):
				if self.l_meth.get(a) in self.l_meth.exclude:
					exclude.update(set([self.l_meth.meths[int(a)][1]]))
		try:
			getattr(self.l_cols, "cols")
		except:
			pass
		else:
			for a in self.l_cols.curselection():
				cols.update(set([int(a)]))
			
		p = open(r"{}".format(self.pina_in.get()))
		i = 0
		taxon = 'taxid:9606(Homo sapiens)'
		not_num = 0
		
		#self.cleanText.text0.delete(1.0, END)
		self.cleanText.text0.strs = []
		for line in p:
			i += 1
			#self.page6.update_idletasks()
			self.prog_c.set(int((i/lines)*100))
			#self.page6.update_idletasks()
			# self.prog_clean.grid()
			# print(i, lines, self.prog_c.get())				
			line_seg = line.split("\t")
			aseg = line_seg[0][line_seg[0].find(':')+1:]
			bseg = line_seg[1][line_seg[1].find(':')+1:]
			
			if i == 1:
				str = "UP_ID:A\tUP_ID:B\tGeneID:A\tGeneSymb:A\tGeneID:B\tGeneSymb:B"
				for a in cols:
					if a in [0,1,2,3]:
						pass
					else:
						str += "\t{}".format(line_seg[a])
				self.cleanText.text0.strs.append(str)
				continue
			
			if line_seg[0] == line_seg[1]:
				if "Redundant" not in d_not:
					d_not["Redundant"] = [[aseg, bseg, i]]
				else:
					d_not["Redundant"].append([aseg,bseg,i])
				not_num += 1 
				continue
			if line_seg[9] != taxon or line_seg[10] != taxon:
				if "Non-human" not in d_not:
					d_not["Non-human"] = [[aseg, bseg, i]]
				else:
					d_not["Non-human"].append([aseg,bseg,i])
				not_num += 1
				continue
			
			if len(exclude):
				methods = line_seg[6].split("|")
				count = len(methods)
				for meth in methods:
					if meth.strip() in exclude:
						count = count - 1
				if count == 0:
					if "Exclusion" not in d_not:
						d_not["Exclusion"] = [[aseg, bseg, i, methods]]
					else:
						d_not["Exclusion"].append([aseg,bseg,i, methods])
					not_num += 1
					continue
			
			if aseg not in d_all or bseg not in d_all:
				if "Not Mapped" not in d_not:
					d_not["Not Mapped"] = [[aseg, bseg, i]]
				else:
					d_not["Not Mapped"].append([aseg,bseg,i])
				not_num += 1
				continue
			
			self.pina_str = ""
			
			for aid in range(len(d_all[aseg])):
				self.page6.update_idletasks()
				for bid in range(len(d_all[bseg])):
					self.page6.update_idletasks()
					str = "{}\t{}\t".format(aseg,bseg)
					str += "{}\t{}\t".format(d_all[aseg][aid][0], d_all[aseg][aid][1])
					str += "{}\t{}".format(d_all[bseg][bid][0], d_all[bseg][bid][1])
					for a in cols:
						if a in [0,1,2,3]:
							pass
						else:
							str += "\t{}".format(line_seg[a])
					self.pina_str += "\n{}".format(str)
			self.cleanText.text0.strs.append(self.pina_str)
			#self.cleanText.text0.insert(END, self.pina_str)
		p.close()
		self.clean_good.config(image=self.pina_good.photo)
				
	def gp_update(self):
		self.g2Texts.text0.config(state=NORMAL)
		uIDs = self.g2Texts.text0.get(1.0, END).split("\n")
		gIDs = self.g2Texts.text1.get(1.0, END).split("\n")
		gSym = self.g2Texts.text2.get(1.0, END).split("\n")
		
		mapped_num = 0		# number of genes mapped / updated
		del_num = 0			# number of uniprot IDs updated
		
		for a in range(len(uIDs)):
			dotI = uIDs[a].find(".")
			if dotI != -1:
				dotI += 2
			else:
				continue
			if uIDs[a] == "" or self.d_gp_not[uIDs[a][dotI:]].count(gSym[a][dotI:]):
				continue
			if uIDs[a][0:dotI] != gIDs[a][0:dotI] or uIDs[a][0:dotI] != gSym[a][0:dotI]:
				continue
				
			if gIDs[a][dotI:].isalnum():
				if uIDs[a][dotI:] in self.d_gp_map:
					self.d_gp_map[uIDs[a][dotI:]].append([gIDs[a][dotI:], gSym[a][dotI:]])
					
					if len(self.d_gp_not[uIDs[a][dotI:]]) == 1:
						del self.d_gp_not[uIDs[a][dotI:]]
						del_num += 1
					else:
						self.d_gp_not[uIDs[a][dotI:]].remove(self.d_gp_not_numtos[int(uIDs[a][0:dotI-2])])
				else:
					self.d_gp_map[uIDs[a][dotI:]] = [[gIDs[a][dotI:], gSym[a][dotI:]]]
					
					if len(self.d_gp_not[uIDs[a][dotI:]]) == 1:
						del self.d_gp_not[uIDs[a][dotI:]]
						del_num += 1
					else:
						self.d_gp_not[uIDs[a][dotI:]].remove(self.d_gp_not_numtos[int(uIDs[a][0:dotI-2])])
				mapped_num += 1
				
		self.g2Texts.err_num -= del_num
		self.g2Texts.num += mapped_num
		if mapped_num:
			self.gp_res.set("{} UP IDs not mapped".format(len(self.d_gp_not))) #, self.g2Texts.err_num))
			self.gp_res_note.set("{} UP IDs updated with {} genes".format(del_num, mapped_num))
			self.g2Texts.text0.err = self.g2Texts.text1.err = self.g2Texts.text2.err = ""		
			i = 0
			self.d_gp_not_numtos = {}
			for key in self.d_gp_not:
				i += 1
				for a in range(len(self.d_gp_not[key])):
					if self.g2Texts.text0.err == "":
						self.g2Texts.text0.err += "{}. {}".format((i+a), key)
						self.g2Texts.text1.err += "{}. {}".format((i+a), "-")
						self.g2Texts.text2.err += "{}. {}".format((i+a), self.d_gp_not[key][a])
						self.d_gp_not_numtos[int(i+a)] = self.d_gp_not[key][a]
					else:
						self.g2Texts.text0.err += "\n{}. {}".format((i+a), key)
						self.g2Texts.text1.err += "\n{}. {}".format((i+a), "-")
						self.g2Texts.text2.err += "\n{}. {}".format((i+a), self.d_gp_not[key][a])
						self.d_gp_not_numtos[int(i+a)] = self.d_gp_not[key][a]
			for a in range(3):
				eval("self.g2Texts.text{}.delete(1.0, END)".format(a))
				eval("self.g2Texts.text{}.insert(END, self.g2Texts.text{}.err)".format(a, a))
			self.gp_update_good.config(image=self.pina_good.photo)
			self.gp_update_good.grid()
		else:
			self.gp_res_note.set("No IDs were added to the dictionary")
			self.gp_update_good.config(image=self.pina_good.photo_b)
			self.gp_update_good.grid()
		self.g2Texts.text0.config(state=DISABLED)
		if len(self.d_gp_not) == 0:
			self.gp_good.config(image=self.pina_good.photo)
			
	def parse_gp(self):
		global errMess
		err_strs = []
		# err = [ ["file/variable/object", "var str", "err-message", "special case?"], [etc...] ]
		err = [["f", "gp_in", "- GenPept file could was not loaded, please try again.", 1],
				["v", "d_gene_itos", "- Gene Info dictionary has not been created, load it on page 3."]]
				
		for a in err:
			try:
				if a[0] == 'f':
					f = getattr(self, a[1]).get()
					o = open(r"{}".format(f))
				if a[0] == 'v':
					getattr(self, a[1])
			except:
				err_strs.append(a[2])
				# print(sys.exc_info())
			else:
				if len(a) == 4:		# Special cases
					if a[3] == 1:
						line = o.readline()
						if "LOCUS" not in line:
							err_strs.append("- GenPept file was not recognized, double check for correct file type")
							err_strs.append("\nIf problem persists, view python code for error testing in \"def parse_gp\"")
				if a[0] == 'f':
					o.close()

		if len(err_strs) > 0:
			errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
			for a in err_strs:
				errMess = errMess + "{}\n".format(a)
			FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
			errMess = ""
			self.gp_good.config(image=self.pina_good.photo_b)
		else:
			f = open(self.gp_in.get())
			self.d_gp_map = {}					# UniProtID: [[GeneID, Gene_Symb], [id2, symb2]]
			self.d_gp_not = {}					# UniProtID: [Symbol?, sym2?, etc]
			uID = ""
			terms = ["/gene=\"", "/product=\"", "/note=\""]
			get_gene = 0
			d_utos = {}							# UniProtID: [Recorded Symb, Symb2, etc]
			d_stou = {}							# Recorded Symb: [UniProtID, uID2, uID3]
			for line in f:
				if 'LOCUS' == line[0:5]:
					locus = line.split()[1]
				if 'ACCESSION' == line[0:9]:
					uID = line.split()[1].strip()
					if uID in d_utos:
						d_utos[uID].append("")
					else:
						d_utos[uID] = [""]
					get_gene = 1
					continue
				if get_gene == 1:
					for a in terms:
						if a in line:
							d_utos[uID][-1] = line[line.find('"')+1:line.rfind('"')]
							val = d_utos[uID][-1]
							get_gene = 0
						
					if get_gene == 0 and (val == '' or len(val.split()) != 1 or '.' in val):
						d_utos[uID][-1] = locus
			
			d={}
			for symb in self.d_gene_stoi:
				d[symb.lower()] = symb		# Lower case gene symbol: gene symbol
			for key in d_utos:
				for a in range(len(d_utos[key])):
					k = d_utos[key][a].lower()
					if k in d:
						if key in self.d_gp_map:
							self.d_gp_map[key].append([self.d_gene_stoi[d[k]], d[k]])
						else:
							self.d_gp_map[key] = [[self.d_gene_stoi[d[k]], d[k]]]
					else:
						self.d_gp_not[key] = d_utos[key]
			f.close()
			
			self.g2Texts.text0.delete(1.0, END)
			self.g2Texts.text0.good = ""
			self.g2Texts.text0.err = ""
			self.g2Texts.text1.delete(1.0, END)
			self.g2Texts.text1.good = ""
			self.g2Texts.text1.err = ""
			self.g2Texts.text2.delete(1.0, END)
			self.g2Texts.text2.good = ""
			self.g2Texts.text2.err = ""
			
			self.g2Texts.err_num = 0
			self.g2Texts.num = 0
			
			self.g2Texts.display = "mapped"
			self.d_gp_not_numtos = {}		# Text displayed symbol number : original symbol
			
			for key in self.d_gp_not:
				for a in range(len(self.d_gp_not[key])):
					if self.g2Texts.text0.err == "":
						self.g2Texts.text0.err += "{}. {}".format((self.g2Texts.err_num+1), key)
						self.g2Texts.text1.err += "{}. {}".format((self.g2Texts.err_num+1), "-")
						self.g2Texts.text2.err += "{}. {}".format((self.g2Texts.err_num+1), self.d_gp_not[key][a])
						self.d_gp_not_numtos[int(self.g2Texts.err_num+1)] = self.d_gp_not[key][a]
					else:
						self.g2Texts.text0.err += "\n{}. {}".format((self.g2Texts.err_num+1), key)
						self.g2Texts.text1.err += "\n{}. {}".format((self.g2Texts.err_num+1), "-")
						self.g2Texts.text2.err += "\n{}. {}".format((self.g2Texts.err_num+1), self.d_gp_not[key][a])
						self.d_gp_not_numtos[int(self.g2Texts.err_num+1)] = self.d_gp_not[key][a]
					self.g2Texts.err_num += 1
			for key in self.d_gp_map:
				for a in range(len(self.d_gp_map[key])):
					if self.g2Texts.text0.good == "":
						self.g2Texts.text0.good += "{}".format(key)
						self.g2Texts.text1.good += "{}".format(self.d_gp_map[key][a][0])
						self.g2Texts.text2.good += "{}".format(self.d_gp_map[key][a][1])
					else:
						self.g2Texts.text0.good += "\n{}".format(key)
						self.g2Texts.text1.good += "\n{}".format(self.d_gp_map[key][a][0])
						self.g2Texts.text2.good += "\n{}".format(self.d_gp_map[key][a][1])
					self.g2Texts.num += 1
			# if self.g2Texts.err_num:
				# self.refresh.grid()
				# self.refresh_note.grid()
				# self.g1_res_note.set("{} UP IDs not mapped to {} genes".format(len(self.d_notmap), self.g1Texts.err_num))
			
			if self.g2Texts.err_num:
				self.g2Texts.text0.insert(END, self.g2Texts.text0.err)
				self.g2Texts.text1.insert(END, self.g2Texts.text1.err)
				self.g2Texts.text2.insert(END, self.g2Texts.text2.err)
				self.gp_good.config(image=self.pina_good.photo_b)
				self.gp_res.set("{} UP IDs not mapped".format(len(self.d_gp_not))) #, self.g2Texts.err_num))
				self.gp_res_note.set("")
				self.gp_valid.grid()
				self.gp_valid_note.grid()
				self.gp_upFrame.grid()
				self.g2Texts.display = "not"
			else:
				self.g2Texts.text0.insert(END, self.g2Texts.text0.good)
				self.g2Texts.text1.insert(END, self.g2Texts.text1.good)
				self.g2Texts.text2.insert(END, self.g2Texts.text2.good)
				self.gp_good.config(image=self.pina_good.photo)
				self.gp_res.set("{} UP IDs mapped to {} genes".format(len(self.d_gp_map), self.g2Texts.num))
		
		if self.g2Texts.display == "not":
			self.g2Texts.text0.config(state=DISABLED, foreground="#999999")
		else:
			self.g2Texts.text0.config(state=NORMAL, foreground="#000000")
					
	def text_switch(self, var):
		if var == "g2Texts":
			self.g2Texts.text0.config(state=NORMAL, foreground="#000000")
		if getattr(eval("self.{}".format(var)), "display") ==  "mapped":
			setattr(eval("self.{}".format(var)), "display", "not")
			eval("self.{}.text0.delete(1.0, END)".format(var))
			eval("self.{}.text1.delete(1.0, END)".format(var))
			eval("self.{}.text2.delete(1.0, END)".format(var))
			if var == "g1Texts":
				self.g1_res.set("{} UP IDs not mapped".format(len(self.d_notmap))) #, self.g1Texts.err_num))
				self.g1_res_note.set("{} UP IDs mapped to {} genes".format(len(self.d_mapped), self.g1Texts.num))
				self.gene_good.config(image=self.gene_good.photo_b)
			elif var == "g2Texts":
				self.gp_res.set("{} UP IDs not mapped".format(len(self.d_gp_not))) #, self.g2Texts.err_num))
				self.gp_res_note.set("")
				self.gp_upFrame.grid()
				if len(self.d_gp_not):
					self.gp_update_good.grid_remove()
					self.gp_good.config(image=self.pina_good.photo_b)
				i = 0
				setattr(eval("self.{}.text0".format(var)), "err", "")
				setattr(eval("self.{}.text1".format(var)), "err", "")
				setattr(eval("self.{}.text2".format(var)), "err", "")
				for key in self.d_gp_not:
					i += 1
					for a in range(len(self.d_gp_not[key])):
						if self.g2Texts.text0.err == "":
							self.g2Texts.text0.err += "{}. {}".format((i+a), key)
							self.g2Texts.text1.err += "{}. {}".format((i+a), "-")
							self.g2Texts.text2.err += "{}. {}".format((i+a), self.d_gp_not[key][a])
						else:
							self.g2Texts.text0.err += "\n{}. {}".format((i+a), key)
							self.g2Texts.text1.err += "\n{}. {}".format((i+a), "-")
							self.g2Texts.text2.err += "\n{}. {}".format((i+a), self.d_gp_not[key][a])
			eval("self.{}.text0.insert(END, self.{}.text0.err)".format(var, var))
			eval("self.{}.text1.insert(END, self.{}.text1.err)".format(var, var))
			eval("self.{}.text2.insert(END, self.{}.text2.err)".format(var, var))
		else:
			setattr(eval("self.{}".format(var)), "display", "mapped")
			eval("self.{}.text0.delete(1.0, END)".format(var))
			eval("self.{}.text1.delete(1.0, END)".format(var))
			eval("self.{}.text2.delete(1.0, END)".format(var))
			if var == "g1Texts":
				self.g1_res.set("{} UP IDs mapped to {} genes".format(len(self.d_mapped), self.g1Texts.num))
				self.g1_res_note.set("{} UP IDs not mapped".format(len(self.d_notmap))) #, self.g1Texts.err_num))
				self.gene_good.config(image=self.gene_good.photo)
			elif var == "g2Texts":
				self.gp_res.set("{} UP IDs mapped to {} genes".format(len(self.d_gp_map), self.g2Texts.num))
				self.gp_res_note.set("{} UP IDs not mapped".format(len(self.d_gp_not))) #, self.g2Texts.err_num))
				self.gp_good.config(image=self.pina_good.photo)
				self.gp_update_good.config(image=None)
				self.gp_update_good.grid_remove()
				self.gp_upFrame.grid_remove()
				setattr(eval("self.{}.text0".format(var)), "good", "")
				setattr(eval("self.{}.text1".format(var)), "good", "")
				setattr(eval("self.{}.text2".format(var)), "good", "")
				for key in self.d_gp_map:
					for a in range(len(self.d_gp_map[key])):
						if self.g2Texts.text0.good == "":
							self.g2Texts.text0.good += "{}".format(key)
							self.g2Texts.text1.good += "{}".format(self.d_gp_map[key][a][0])
							self.g2Texts.text2.good += "{}".format(self.d_gp_map[key][a][1])
						else:
							self.g2Texts.text0.good += "\n{}".format(key)
							self.g2Texts.text1.good += "\n{}".format(self.d_gp_map[key][a][0])
							self.g2Texts.text2.good += "\n{}".format(self.d_gp_map[key][a][1])
			eval("self.{}.text0.insert(END, self.{}.text0.good)".format(var, var))
			eval("self.{}.text1.insert(END, self.{}.text1.good)".format(var, var))
			eval("self.{}.text2.insert(END, self.{}.text2.good)".format(var, var))
		
		if var == "g2Texts":
			if self.g2Texts.display == "mapped":
				self.g2Texts.text0.config(state=NORMAL, foreground="#000000")
			else:
				self.g2Texts.text0.config(state=DISABLED, foreground="#999999")
		
	def map_gene(self):
		global errMess
		err_strs = []
		# err = [ ["file/variable/object", "var str", "err-message", "special case?"], [etc...] ]
		err = [["f", "map_in", "- Mapping table could not be opened", 1],
				["v", "d_gene_itos", "- Gene Info dictionary has not been created, load it on page 3."]]
				
		for a in err:
			try:
				if a[0] == 'f':
					f = getattr(self, a[1]).get()
					o = open(r"{}".format(f))
				if a[0] == 'v':
					getattr(self, a[1])
			except:
				err_strs.append(a[2])
				# print(sys.exc_info())
			else:
				if len(a) == 4:		# Special cases
					if a[3] == 1:
						line = o.readline()
						if len(line.split("\t")) != 2:
							err_strs.append("- Mapping table was not recognized, double check for correct file type")
							err_strs.append("\nIf problem persists, view python code for error testing in \"def load_gene\"")
					if a[3] == 2:
						line = o.readline()
						if line.split("\t")[0] != "9606":
							err_strs.append("- Human Gene Info file was not recognized, double check for correct file type")
							err_strs.append("\nIf problem persists, view python code for error testing in \"def load_gene\"")
				if a[0] == 'f':
					o.close()

		if len(err_strs) > 0:
			errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
			for a in err_strs:
				errMess = errMess + "{}\n".format(a)
			FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
			errMess = ""
			self.map_good.config(image=self.pina_good.photo_b)
		else:
			self.map_good.config(image=self.pina_good.photo)
			
			m = open(r"{}".format(self.map_in.get()))
			
			m_utog = {}						# Mapping Table, Uniprot : Gene ID
			self.d_mapped = {}				# Uniprot: [[id1, symb1], [id2, symb2]]
			self.d_notmap = {}				# Uniprot: [not found id1, id2, ect]
			
			for line in m:
				if "To" in line:
					continue
				line_seg = line.strip().split("\t")
				if line_seg[0].strip() in m_utog:
					m_utog[line_seg[0].strip()].append(line_seg[1].strip())
				else:
					m_utog[line_seg[0].strip()] = [line_seg[1].strip()]				# [id1, id2, id3]
				
			for key in m_utog:
				self.d_mapped[key] = []
				for a in range(len(m_utog[key])):
					try:
						self.d_mapped[key].append([m_utog[key][a], self.d_gene_itos[m_utog[key][a]]])
					except:
						if key in self.d_notmap:
							self.d_notmap[key].append(m_utog[key][a])
						else:
							self.d_notmap[key] = [m_utog[key][a]]
			
			self.g1Texts.text0.delete(1.0, END)
			self.g1Texts.text0.good = ""
			self.g1Texts.text0.err = ""
			self.g1Texts.text1.delete(1.0, END)
			self.g1Texts.text1.good = ""
			self.g1Texts.text1.err = ""
			self.g1Texts.text2.delete(1.0, END)
			self.g1Texts.text2.good = ""
			self.g1Texts.text2.err = ""
			
			self.g1Texts.err_num = 0
			self.g1Texts.num = 0
			
			self.g1Texts.display = "mapped"
			
			for key in self.d_notmap:
				for a in range(len(self.d_notmap[key])):
					if self.g1Texts.text0.err == "":
						self.g1Texts.text0.err += "{}".format(key)
						self.g1Texts.text1.err += "{}".format(self.d_notmap[key][a])
						self.g1Texts.text2.err += "{}".format("-")
					else:
						self.g1Texts.text0.err += "\n{}".format(key)
						self.g1Texts.text1.err += "\n{}".format(self.d_notmap[key][a])
						self.g1Texts.text2.err += "\n{}".format("-")
					self.g1Texts.err_num += 1
			for key in self.d_mapped:
				for a in range(len(self.d_mapped[key])):
					if self.g1Texts.text0.good == "":
						self.g1Texts.text0.good += "{}".format(key)
						self.g1Texts.text1.good += "{}".format(self.d_mapped[key][a][0])
						self.g1Texts.text2.good += "{}".format(self.d_mapped[key][a][1])
					else:
						self.g1Texts.text0.good += "\n{}".format(key)
						self.g1Texts.text1.good += "\n{}".format(self.d_mapped[key][a][0])
						self.g1Texts.text2.good += "\n{}".format(self.d_mapped[key][a][1])
					self.g1Texts.num += 1
			if self.g1Texts.err_num:
				self.refresh.grid()
				self.refresh_note.grid()
				self.g1_res_note.set("{} UP IDs not mapped".format(len(self.d_notmap))) #, self.g1Texts.err_num))
			# if len(self.d_notmap):
				# self.g1_res.set("{} UP IDs not mapped to {} genes".format(len(self.d_notmap), self.g1Texts.err_num))
				# self.g1Texts.text0.insert(END, self.g1Texts.text0.err)
				# self.g1Texts.text1.insert(END, self.g1Texts.text1.err)
				# self.g1Texts.text2.insert(END, self.g1Texts.text2.err)
				# # Error, bad icon
				# self.map_good.config(image=self.pina_good.photo_b)
			# else:			
			self.g1_res.set("{} UP IDs mapped to {} genes".format(len(self.d_mapped), self.g1Texts.num))
			self.g1Texts.text0.insert(END, self.g1Texts.text0.good)
			self.g1Texts.text1.insert(END, self.g1Texts.text1.good)
			self.g1Texts.text2.insert(END, self.g1Texts.text2.good)
			m.close()

	def load_gene(self):
		global errMess
		err_strs = []
		# err = [ ["file/variable/object", "var str", "err-message", "special case?"], [etc...] ]
		err = [["f", "gene_in", "- Human Gene Info file was not found", 2]]
				
		for a in err:
			try:
				if a[0] == 'f':
					f = getattr(self, a[1]).get()
					o = open(r"{}".format(f))
				if a[0] == 'v':
					getattr(self, a[1])
			except:
				err_strs.append(a[2])
				# print(sys.exc_info())
			else:
				if len(a) == 4:		# Special cases
					if a[3] == 2:
						line = o.readline()
						if line.split("\t")[0] != "9606":
							err_strs.append("- Human Gene Info file was not recognized, double check for correct file type")
							err_strs.append("\nIf problem persists, view python code for error testing in \"def load_gene\"")
				if a[0] == 'f':
					o.close()

		if len(err_strs) > 0:
			errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
			for a in err_strs:
				errMess = errMess + "{}\n".format(a)
			FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
			errMess = ""
			self.gene_good.config(image=self.gene_good.photo_b)
		else:
			self.gene_good.config(image=self.gene_good.photo)
			g = open(r"{}".format(self.gene_in.get()))
			
			self.d_gene_itos = {}			# Gene, Gene ID : Gene Symbol
			self.d_gene_stoi = {}			# Gene, Gene Symbol : Gene ID
			
			for line in g:
				line_seg = line.strip().split("\t")
				self.d_gene_itos[line_seg[1].strip()] = line_seg[2].strip()
				self.d_gene_stoi[line_seg[2].strip()] = line_seg[1].strip()
			
			g.close()
			
	def pina_ids(self, pina_f, label_n, text_n):		# pass Pina file name, label string reference, text string reference
		global errMess
		err_strs = []
		# err = [ ["file/variable/object", "eval str", "err-message", "special case?"], [etc...] ]
		err = [["f", pina_f, "- PINA database could not be opened", 1],
				["v", "self.{}".format(label_n), "- Invalid scrolled text object selection"],
				["v", "self.{}".format(text_n), "- Invalid scrolled text string reference"]]
		for a in err:
			try:
				if a[0] == 'f':
					f = eval("self.{}.get()".format(a[1]))
					o = eval("open(r\"{}\".format(f))")
				if a[0] == 'v':
					eval(a[1])
			except:
				err_strs.append(a[2])
				# print(sys.exc_info())
			else:
				if len(a) == 4:		# Special cases
					if a[3] == 1:
						line = o.readline()
						if "\"ID(s) interactor A\"" not in line:
							err_strs.append("- Pina file did not contain the correct header, double check for correct file type")
							err_strs.append("\nIf problem persists, view python code for header testing in def pina_ids")
				if a[0] == 'f':
					o.close()

		if len(err_strs) > 0:
			errMess = "Before we can process the command,\nPlease check the following values and terms:\n\n"
			for a in err_strs:
				errMess = errMess + "{}\n".format(a)
			FramePop(create="w_err", varPass="self, errMess", title="Errors Occurred: Warning")
			errMess = ""
			self.pina_good.config(image=self.pina_good.photo_b)
		else:
			f = eval("open(self.{}.get())".format(pina_f))
			taxon = 'taxid:9606(Homo sapiens)'
			uni_set = set([])
			i = 0
			for line in f:
				if i == 0:			# Skip header
					i = i+1
					continue
				line_seg = line.split("\t")
				if line_seg[9] == taxon:
					uni_set.update(set([line_seg[0][line_seg[0].find(":")+1:]]))
				if line_seg[10] == taxon:
					uni_set.update(set([line_seg[1][line_seg[1].find(":")+1:]]))
			f.close()
			self.unq_uID = ''
			for item in uni_set:
				self.unq_uID += "{}\n".format(item)
			self.St1.delete(1.0, END)
			self.St1.insert('1.0', self.unq_uID)
			self.pina_res_ids.set("Found {} unique human IDs".format(len(uni_set)))
			self.pina_good.config(image=self.pina_good.photo)
	
	def save_text(self, var, label_y, label_n):
		global errMess
		sfile = tF.asksaveasfile()
		if sfile != None:
			texts = eval("{}".format(var))
			if texts.strip() != '':
				s = open(r"{}".format(sfile.name), 'w')
				s.write(texts)
				if label_y != None:
					eval(label_y)
				s.close()
			else:
				errMess = "Sorry, but there is no text to save, please load the PINA data and get the unique IDs."
				FramePop(create="w_err", varPass="self, errMess", title="Error: No Selection")
				errMess = ''
				eval(label_n)
			# results = "Congratulations, you saved the UniProt IDs in the file:\n\n{}".format(sfile.name)
			# FramePop(create="w_good", varPass="self, results", title="Success")
			# results = ''
		else:
			if label_n != None:
				eval(label_n)
							
	def dia_file(self, var):
		file = tF.askopenfile()
		if file != None:
			eval("{}.set(file.name)".format(var))
			
	def dia_sfile(self, var):
		sfile = tF.asksaveasfile()
		if sfile != None:
			eval("{}.set(sfile.name)".format(var))
	
	def back(self):
		if self.page_num > 1:
			self.page_num = self.page_num - 1
			self.updatePage()
			if self.page_num == 1:
				self.b.config(state=DISABLED)
		if self.page_num < self.num_page:
			self.n.config(state=NORMAL)
		self.page.set("{} of {}".format(self.page_num, self.num_page))
		
	def next(self):
		if self.page_num < self.num_page:			# Current page less than total number of pages
			self.page_num = self.page_num + 1
			self.updatePage()
			if self.page_num == self.num_page:
				self.n.config(state=DISABLED)
		if self.page_num > 1:
			self.b.config(state=NORMAL)
		self.page.set("{} of {}".format(self.page_num, self.num_page))
		
		if self.page_num == 7 and hasattr(self.cleanText.text0, "strs"):
			self.cleanText.text0.delete(1.0,END)
			for a in range(100):
				self.cleanText.text0.insert(END, self.cleanText.text0.strs[a])
			self.cleanText.text0.insert(END, "\n\n-- Only Showing First 100 Lines --")

	def nav_bar(self):
		self.nav = ttk.Frame(self, padding="20 1 20 20")
		ttk.Label(self.nav, textvariable=self.page, font=("Arial", 7)).grid(column=0, row=0, sticky=(S,W))
		self.b = ttk.Button(self.nav, text="Back", command=self.back, state=DISABLED)
		self.b.grid(column=1, row=0, sticky=E)
		self.n = ttk.Button(self.nav, text="Next", command=self.next)
		self.n.grid(column=2, row=0, sticky=E)
		self.nav.grid(column=1, row=1, sticky=(N,S,E,W))
		self.nav.columnconfigure(0, weight=1)
		self.nav.rowconfigure(0, weight=1)
		self.page.set("{} of {}".format(self.page_num, self.num_page))
		
	def main_bar(self):
		self.icobar = Frame(self, padx="10", pady="20", background="#333")
		self.icobar.grid(column=0, row=0, rowspan=2, sticky=(N,S,E,W))
		logo_img = PhotoImage(data=img_dict["logo"])
		self.img1 = Label(self.icobar, image=logo_img)
		self.img1.photo = logo_img
		self.img1.grid(column=0, row=0, sticky=N)
	
	def updatePage(self):
		try:
			a = self.num_page
			a = self.page_num
			a = self.page.get()
		except:
			self.page = StringVar()
			self.page_num = 1
			self.num_page = 0
			high = 0
			for key in dir(self):
				if 'page' in key:
					try:
						if int(key[4]) > high:
							high = int(key[4])
					except:
						continue
			self.num_page = high
			eval("self.page{}.grid(column=1, row=0, sticky=(N,S,E,W))".format(self.page_num))
		else:
			if self.page_num != 1:
				eval("self.page{}.grid_remove()".format(self.page_num-1))
			if self.page_num != self.num_page:
				eval("self.page{}.grid_remove()".format(self.page_num+1))
			eval("self.page{}.grid(column=1, row=0, sticky=(N,S,E,W))".format(self.page_num))
				
	def init_vars(self):
		self.pina_in = StringVar()
		self.map_in = StringVar()
		self.gene_in = StringVar()
		self.gp_in = StringVar()
		self.file_dict = StringVar()
		self.file_s = StringVar()
		self.string = ''
		self.pina_res_ids = StringVar()
		self.unq_uID = ''
		self.g1_res = StringVar()
		self.g1_res_note = StringVar()
		self.gp_res = StringVar()
		self.gp_res_note = StringVar()
		self.prog_c = IntVar()
		self.pina_str = ""
		
	def __init__(self, master=None, Main=False, create=None, varPass="self", nav=False):
		Frame.__init__(self, master)
		self.grid()
		self.main_bar()
		if Main == True:
			self.init_vars()
			self.rowconfigure(0, minsize=500)
			self.columnconfigure(1, minsize=450)
		if create != None:
			eval("{}({})".format(create, varPass))
		if nav == True:
			self.updatePage()
			self.nav_bar()
			
			
def run_app():
	root = Tk()
	root.title("PPI Cleaner")
	app = Application(master=root, Main=True, create="main", nav=True)
	app.mainloop()

if __name__ == "__main__":
	run_app()
